// Code generated by go-swagger; DO NOT EDIT.

package migrations

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/grafana/grafana-openapi-client-go/models"
)

// GetShapshotListReader is a Reader for the GetShapshotList structure.
type GetShapshotListReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *GetShapshotListReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewGetShapshotListOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	case 400:
		result := NewGetShapshotListBadRequest()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 401:
		result := NewGetShapshotListUnauthorized()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 403:
		result := NewGetShapshotListForbidden()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 500:
		result := NewGetShapshotListInternalServerError()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	default:
		return nil, runtime.NewAPIError("[GET /cloudmigration/migration/{uid}/snapshots] getShapshotList", response, response.Code())
	}
}

// NewGetShapshotListOK creates a GetShapshotListOK with default headers values
func NewGetShapshotListOK() *GetShapshotListOK {
	return &GetShapshotListOK{}
}

/*
GetShapshotListOK describes a response with status code 200, with default header values.

(empty)
*/
type GetShapshotListOK struct {
	Payload *models.SnapshotListResponseDTO
}

// IsSuccess returns true when this get shapshot list Ok response has a 2xx status code
func (o *GetShapshotListOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this get shapshot list Ok response has a 3xx status code
func (o *GetShapshotListOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this get shapshot list Ok response has a 4xx status code
func (o *GetShapshotListOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this get shapshot list Ok response has a 5xx status code
func (o *GetShapshotListOK) IsServerError() bool {
	return false
}

// IsCode returns true when this get shapshot list Ok response a status code equal to that given
func (o *GetShapshotListOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the get shapshot list Ok response
func (o *GetShapshotListOK) Code() int {
	return 200
}

func (o *GetShapshotListOK) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /cloudmigration/migration/{uid}/snapshots][%d] getShapshotListOk %s", 200, payload)
}

func (o *GetShapshotListOK) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /cloudmigration/migration/{uid}/snapshots][%d] getShapshotListOk %s", 200, payload)
}

func (o *GetShapshotListOK) GetPayload() *models.SnapshotListResponseDTO {
	return o.Payload
}

func (o *GetShapshotListOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.SnapshotListResponseDTO)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewGetShapshotListBadRequest creates a GetShapshotListBadRequest with default headers values
func NewGetShapshotListBadRequest() *GetShapshotListBadRequest {
	return &GetShapshotListBadRequest{}
}

/*
GetShapshotListBadRequest describes a response with status code 400, with default header values.

BadRequestError is returned when the request is invalid and it cannot be processed.
*/
type GetShapshotListBadRequest struct {
	Payload *models.ErrorResponseBody
}

// IsSuccess returns true when this get shapshot list bad request response has a 2xx status code
func (o *GetShapshotListBadRequest) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this get shapshot list bad request response has a 3xx status code
func (o *GetShapshotListBadRequest) IsRedirect() bool {
	return false
}

// IsClientError returns true when this get shapshot list bad request response has a 4xx status code
func (o *GetShapshotListBadRequest) IsClientError() bool {
	return true
}

// IsServerError returns true when this get shapshot list bad request response has a 5xx status code
func (o *GetShapshotListBadRequest) IsServerError() bool {
	return false
}

// IsCode returns true when this get shapshot list bad request response a status code equal to that given
func (o *GetShapshotListBadRequest) IsCode(code int) bool {
	return code == 400
}

// Code gets the status code for the get shapshot list bad request response
func (o *GetShapshotListBadRequest) Code() int {
	return 400
}

func (o *GetShapshotListBadRequest) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /cloudmigration/migration/{uid}/snapshots][%d] getShapshotListBadRequest %s", 400, payload)
}

func (o *GetShapshotListBadRequest) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /cloudmigration/migration/{uid}/snapshots][%d] getShapshotListBadRequest %s", 400, payload)
}

func (o *GetShapshotListBadRequest) GetPayload() *models.ErrorResponseBody {
	return o.Payload
}

func (o *GetShapshotListBadRequest) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponseBody)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewGetShapshotListUnauthorized creates a GetShapshotListUnauthorized with default headers values
func NewGetShapshotListUnauthorized() *GetShapshotListUnauthorized {
	return &GetShapshotListUnauthorized{}
}

/*
GetShapshotListUnauthorized describes a response with status code 401, with default header values.

UnauthorizedError is returned when the request is not authenticated.
*/
type GetShapshotListUnauthorized struct {
	Payload *models.ErrorResponseBody
}

// IsSuccess returns true when this get shapshot list unauthorized response has a 2xx status code
func (o *GetShapshotListUnauthorized) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this get shapshot list unauthorized response has a 3xx status code
func (o *GetShapshotListUnauthorized) IsRedirect() bool {
	return false
}

// IsClientError returns true when this get shapshot list unauthorized response has a 4xx status code
func (o *GetShapshotListUnauthorized) IsClientError() bool {
	return true
}

// IsServerError returns true when this get shapshot list unauthorized response has a 5xx status code
func (o *GetShapshotListUnauthorized) IsServerError() bool {
	return false
}

// IsCode returns true when this get shapshot list unauthorized response a status code equal to that given
func (o *GetShapshotListUnauthorized) IsCode(code int) bool {
	return code == 401
}

// Code gets the status code for the get shapshot list unauthorized response
func (o *GetShapshotListUnauthorized) Code() int {
	return 401
}

func (o *GetShapshotListUnauthorized) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /cloudmigration/migration/{uid}/snapshots][%d] getShapshotListUnauthorized %s", 401, payload)
}

func (o *GetShapshotListUnauthorized) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /cloudmigration/migration/{uid}/snapshots][%d] getShapshotListUnauthorized %s", 401, payload)
}

func (o *GetShapshotListUnauthorized) GetPayload() *models.ErrorResponseBody {
	return o.Payload
}

func (o *GetShapshotListUnauthorized) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponseBody)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewGetShapshotListForbidden creates a GetShapshotListForbidden with default headers values
func NewGetShapshotListForbidden() *GetShapshotListForbidden {
	return &GetShapshotListForbidden{}
}

/*
GetShapshotListForbidden describes a response with status code 403, with default header values.

ForbiddenError is returned if the user/token has insufficient permissions to access the requested resource.
*/
type GetShapshotListForbidden struct {
	Payload *models.ErrorResponseBody
}

// IsSuccess returns true when this get shapshot list forbidden response has a 2xx status code
func (o *GetShapshotListForbidden) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this get shapshot list forbidden response has a 3xx status code
func (o *GetShapshotListForbidden) IsRedirect() bool {
	return false
}

// IsClientError returns true when this get shapshot list forbidden response has a 4xx status code
func (o *GetShapshotListForbidden) IsClientError() bool {
	return true
}

// IsServerError returns true when this get shapshot list forbidden response has a 5xx status code
func (o *GetShapshotListForbidden) IsServerError() bool {
	return false
}

// IsCode returns true when this get shapshot list forbidden response a status code equal to that given
func (o *GetShapshotListForbidden) IsCode(code int) bool {
	return code == 403
}

// Code gets the status code for the get shapshot list forbidden response
func (o *GetShapshotListForbidden) Code() int {
	return 403
}

func (o *GetShapshotListForbidden) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /cloudmigration/migration/{uid}/snapshots][%d] getShapshotListForbidden %s", 403, payload)
}

func (o *GetShapshotListForbidden) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /cloudmigration/migration/{uid}/snapshots][%d] getShapshotListForbidden %s", 403, payload)
}

func (o *GetShapshotListForbidden) GetPayload() *models.ErrorResponseBody {
	return o.Payload
}

func (o *GetShapshotListForbidden) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponseBody)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewGetShapshotListInternalServerError creates a GetShapshotListInternalServerError with default headers values
func NewGetShapshotListInternalServerError() *GetShapshotListInternalServerError {
	return &GetShapshotListInternalServerError{}
}

/*
GetShapshotListInternalServerError describes a response with status code 500, with default header values.

InternalServerError is a general error indicating something went wrong internally.
*/
type GetShapshotListInternalServerError struct {
	Payload *models.ErrorResponseBody
}

// IsSuccess returns true when this get shapshot list internal server error response has a 2xx status code
func (o *GetShapshotListInternalServerError) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this get shapshot list internal server error response has a 3xx status code
func (o *GetShapshotListInternalServerError) IsRedirect() bool {
	return false
}

// IsClientError returns true when this get shapshot list internal server error response has a 4xx status code
func (o *GetShapshotListInternalServerError) IsClientError() bool {
	return false
}

// IsServerError returns true when this get shapshot list internal server error response has a 5xx status code
func (o *GetShapshotListInternalServerError) IsServerError() bool {
	return true
}

// IsCode returns true when this get shapshot list internal server error response a status code equal to that given
func (o *GetShapshotListInternalServerError) IsCode(code int) bool {
	return code == 500
}

// Code gets the status code for the get shapshot list internal server error response
func (o *GetShapshotListInternalServerError) Code() int {
	return 500
}

func (o *GetShapshotListInternalServerError) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /cloudmigration/migration/{uid}/snapshots][%d] getShapshotListInternalServerError %s", 500, payload)
}

func (o *GetShapshotListInternalServerError) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /cloudmigration/migration/{uid}/snapshots][%d] getShapshotListInternalServerError %s", 500, payload)
}

func (o *GetShapshotListInternalServerError) GetPayload() *models.ErrorResponseBody {
	return o.Payload
}

func (o *GetShapshotListInternalServerError) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponseBody)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
