// Code generated by go-swagger; DO NOT EDIT.

package group_attribute_sync

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/grafana/grafana-openapi-client-go/models"
)

// CreateGroupMappingsReader is a Reader for the CreateGroupMappings structure.
type CreateGroupMappingsReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *CreateGroupMappingsReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 201:
		result := NewCreateGroupMappingsCreated()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	case 400:
		result := NewCreateGroupMappingsBadRequest()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 401:
		result := NewCreateGroupMappingsUnauthorized()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 403:
		result := NewCreateGroupMappingsForbidden()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 500:
		result := NewCreateGroupMappingsInternalServerError()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	default:
		return nil, runtime.NewAPIError("[POST /groupsync/groups/{group_id}] createGroupMappings", response, response.Code())
	}
}

// NewCreateGroupMappingsCreated creates a CreateGroupMappingsCreated with default headers values
func NewCreateGroupMappingsCreated() *CreateGroupMappingsCreated {
	return &CreateGroupMappingsCreated{}
}

/*
CreateGroupMappingsCreated describes a response with status code 201, with default header values.

(empty)
*/
type CreateGroupMappingsCreated struct {
	Payload *models.MessageResponse
}

// IsSuccess returns true when this create group mappings created response has a 2xx status code
func (o *CreateGroupMappingsCreated) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this create group mappings created response has a 3xx status code
func (o *CreateGroupMappingsCreated) IsRedirect() bool {
	return false
}

// IsClientError returns true when this create group mappings created response has a 4xx status code
func (o *CreateGroupMappingsCreated) IsClientError() bool {
	return false
}

// IsServerError returns true when this create group mappings created response has a 5xx status code
func (o *CreateGroupMappingsCreated) IsServerError() bool {
	return false
}

// IsCode returns true when this create group mappings created response a status code equal to that given
func (o *CreateGroupMappingsCreated) IsCode(code int) bool {
	return code == 201
}

// Code gets the status code for the create group mappings created response
func (o *CreateGroupMappingsCreated) Code() int {
	return 201
}

func (o *CreateGroupMappingsCreated) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /groupsync/groups/{group_id}][%d] createGroupMappingsCreated %s", 201, payload)
}

func (o *CreateGroupMappingsCreated) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /groupsync/groups/{group_id}][%d] createGroupMappingsCreated %s", 201, payload)
}

func (o *CreateGroupMappingsCreated) GetPayload() *models.MessageResponse {
	return o.Payload
}

func (o *CreateGroupMappingsCreated) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.MessageResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewCreateGroupMappingsBadRequest creates a CreateGroupMappingsBadRequest with default headers values
func NewCreateGroupMappingsBadRequest() *CreateGroupMappingsBadRequest {
	return &CreateGroupMappingsBadRequest{}
}

/*
CreateGroupMappingsBadRequest describes a response with status code 400, with default header values.

BadRequestError is returned when the request is invalid and it cannot be processed.
*/
type CreateGroupMappingsBadRequest struct {
	Payload *models.ErrorResponseBody
}

// IsSuccess returns true when this create group mappings bad request response has a 2xx status code
func (o *CreateGroupMappingsBadRequest) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this create group mappings bad request response has a 3xx status code
func (o *CreateGroupMappingsBadRequest) IsRedirect() bool {
	return false
}

// IsClientError returns true when this create group mappings bad request response has a 4xx status code
func (o *CreateGroupMappingsBadRequest) IsClientError() bool {
	return true
}

// IsServerError returns true when this create group mappings bad request response has a 5xx status code
func (o *CreateGroupMappingsBadRequest) IsServerError() bool {
	return false
}

// IsCode returns true when this create group mappings bad request response a status code equal to that given
func (o *CreateGroupMappingsBadRequest) IsCode(code int) bool {
	return code == 400
}

// Code gets the status code for the create group mappings bad request response
func (o *CreateGroupMappingsBadRequest) Code() int {
	return 400
}

func (o *CreateGroupMappingsBadRequest) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /groupsync/groups/{group_id}][%d] createGroupMappingsBadRequest %s", 400, payload)
}

func (o *CreateGroupMappingsBadRequest) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /groupsync/groups/{group_id}][%d] createGroupMappingsBadRequest %s", 400, payload)
}

func (o *CreateGroupMappingsBadRequest) GetPayload() *models.ErrorResponseBody {
	return o.Payload
}

func (o *CreateGroupMappingsBadRequest) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponseBody)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewCreateGroupMappingsUnauthorized creates a CreateGroupMappingsUnauthorized with default headers values
func NewCreateGroupMappingsUnauthorized() *CreateGroupMappingsUnauthorized {
	return &CreateGroupMappingsUnauthorized{}
}

/*
CreateGroupMappingsUnauthorized describes a response with status code 401, with default header values.

UnauthorizedError is returned when the request is not authenticated.
*/
type CreateGroupMappingsUnauthorized struct {
	Payload *models.ErrorResponseBody
}

// IsSuccess returns true when this create group mappings unauthorized response has a 2xx status code
func (o *CreateGroupMappingsUnauthorized) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this create group mappings unauthorized response has a 3xx status code
func (o *CreateGroupMappingsUnauthorized) IsRedirect() bool {
	return false
}

// IsClientError returns true when this create group mappings unauthorized response has a 4xx status code
func (o *CreateGroupMappingsUnauthorized) IsClientError() bool {
	return true
}

// IsServerError returns true when this create group mappings unauthorized response has a 5xx status code
func (o *CreateGroupMappingsUnauthorized) IsServerError() bool {
	return false
}

// IsCode returns true when this create group mappings unauthorized response a status code equal to that given
func (o *CreateGroupMappingsUnauthorized) IsCode(code int) bool {
	return code == 401
}

// Code gets the status code for the create group mappings unauthorized response
func (o *CreateGroupMappingsUnauthorized) Code() int {
	return 401
}

func (o *CreateGroupMappingsUnauthorized) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /groupsync/groups/{group_id}][%d] createGroupMappingsUnauthorized %s", 401, payload)
}

func (o *CreateGroupMappingsUnauthorized) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /groupsync/groups/{group_id}][%d] createGroupMappingsUnauthorized %s", 401, payload)
}

func (o *CreateGroupMappingsUnauthorized) GetPayload() *models.ErrorResponseBody {
	return o.Payload
}

func (o *CreateGroupMappingsUnauthorized) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponseBody)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewCreateGroupMappingsForbidden creates a CreateGroupMappingsForbidden with default headers values
func NewCreateGroupMappingsForbidden() *CreateGroupMappingsForbidden {
	return &CreateGroupMappingsForbidden{}
}

/*
CreateGroupMappingsForbidden describes a response with status code 403, with default header values.

ForbiddenError is returned if the user/token has insufficient permissions to access the requested resource.
*/
type CreateGroupMappingsForbidden struct {
	Payload *models.ErrorResponseBody
}

// IsSuccess returns true when this create group mappings forbidden response has a 2xx status code
func (o *CreateGroupMappingsForbidden) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this create group mappings forbidden response has a 3xx status code
func (o *CreateGroupMappingsForbidden) IsRedirect() bool {
	return false
}

// IsClientError returns true when this create group mappings forbidden response has a 4xx status code
func (o *CreateGroupMappingsForbidden) IsClientError() bool {
	return true
}

// IsServerError returns true when this create group mappings forbidden response has a 5xx status code
func (o *CreateGroupMappingsForbidden) IsServerError() bool {
	return false
}

// IsCode returns true when this create group mappings forbidden response a status code equal to that given
func (o *CreateGroupMappingsForbidden) IsCode(code int) bool {
	return code == 403
}

// Code gets the status code for the create group mappings forbidden response
func (o *CreateGroupMappingsForbidden) Code() int {
	return 403
}

func (o *CreateGroupMappingsForbidden) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /groupsync/groups/{group_id}][%d] createGroupMappingsForbidden %s", 403, payload)
}

func (o *CreateGroupMappingsForbidden) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /groupsync/groups/{group_id}][%d] createGroupMappingsForbidden %s", 403, payload)
}

func (o *CreateGroupMappingsForbidden) GetPayload() *models.ErrorResponseBody {
	return o.Payload
}

func (o *CreateGroupMappingsForbidden) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponseBody)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewCreateGroupMappingsInternalServerError creates a CreateGroupMappingsInternalServerError with default headers values
func NewCreateGroupMappingsInternalServerError() *CreateGroupMappingsInternalServerError {
	return &CreateGroupMappingsInternalServerError{}
}

/*
CreateGroupMappingsInternalServerError describes a response with status code 500, with default header values.

InternalServerError is a general error indicating something went wrong internally.
*/
type CreateGroupMappingsInternalServerError struct {
	Payload *models.ErrorResponseBody
}

// IsSuccess returns true when this create group mappings internal server error response has a 2xx status code
func (o *CreateGroupMappingsInternalServerError) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this create group mappings internal server error response has a 3xx status code
func (o *CreateGroupMappingsInternalServerError) IsRedirect() bool {
	return false
}

// IsClientError returns true when this create group mappings internal server error response has a 4xx status code
func (o *CreateGroupMappingsInternalServerError) IsClientError() bool {
	return false
}

// IsServerError returns true when this create group mappings internal server error response has a 5xx status code
func (o *CreateGroupMappingsInternalServerError) IsServerError() bool {
	return true
}

// IsCode returns true when this create group mappings internal server error response a status code equal to that given
func (o *CreateGroupMappingsInternalServerError) IsCode(code int) bool {
	return code == 500
}

// Code gets the status code for the create group mappings internal server error response
func (o *CreateGroupMappingsInternalServerError) Code() int {
	return 500
}

func (o *CreateGroupMappingsInternalServerError) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /groupsync/groups/{group_id}][%d] createGroupMappingsInternalServerError %s", 500, payload)
}

func (o *CreateGroupMappingsInternalServerError) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /groupsync/groups/{group_id}][%d] createGroupMappingsInternalServerError %s", 500, payload)
}

func (o *CreateGroupMappingsInternalServerError) GetPayload() *models.ErrorResponseBody {
	return o.Payload
}

func (o *CreateGroupMappingsInternalServerError) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponseBody)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
