// Code generated by go-swagger; DO NOT EDIT.

package group_attribute_sync

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/grafana/grafana-openapi-client-go/models"
)

// CreateGroupMappingReader is a Reader for the CreateGroupMapping structure.
type CreateGroupMappingReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *CreateGroupMappingReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 201:
		result := NewCreateGroupMappingCreated()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	case 400:
		result := NewCreateGroupMappingBadRequest()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 401:
		result := NewCreateGroupMappingUnauthorized()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 403:
		result := NewCreateGroupMappingForbidden()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 409:
		result := NewCreateGroupMappingConflict()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 500:
		result := NewCreateGroupMappingInternalServerError()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	default:
		return nil, runtime.NewAPIError("[POST /groupsync/mappings] createGroupMapping", response, response.Code())
	}
}

// NewCreateGroupMappingCreated creates a CreateGroupMappingCreated with default headers values
func NewCreateGroupMappingCreated() *CreateGroupMappingCreated {
	return &CreateGroupMappingCreated{}
}

/*
CreateGroupMappingCreated describes a response with status code 201, with default header values.

(empty)
*/
type CreateGroupMappingCreated struct {
	Payload *models.MessageResponse
}

// IsSuccess returns true when this create group mapping created response has a 2xx status code
func (o *CreateGroupMappingCreated) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this create group mapping created response has a 3xx status code
func (o *CreateGroupMappingCreated) IsRedirect() bool {
	return false
}

// IsClientError returns true when this create group mapping created response has a 4xx status code
func (o *CreateGroupMappingCreated) IsClientError() bool {
	return false
}

// IsServerError returns true when this create group mapping created response has a 5xx status code
func (o *CreateGroupMappingCreated) IsServerError() bool {
	return false
}

// IsCode returns true when this create group mapping created response a status code equal to that given
func (o *CreateGroupMappingCreated) IsCode(code int) bool {
	return code == 201
}

// Code gets the status code for the create group mapping created response
func (o *CreateGroupMappingCreated) Code() int {
	return 201
}

func (o *CreateGroupMappingCreated) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /groupsync/mappings][%d] createGroupMappingCreated %s", 201, payload)
}

func (o *CreateGroupMappingCreated) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /groupsync/mappings][%d] createGroupMappingCreated %s", 201, payload)
}

func (o *CreateGroupMappingCreated) GetPayload() *models.MessageResponse {
	return o.Payload
}

func (o *CreateGroupMappingCreated) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.MessageResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewCreateGroupMappingBadRequest creates a CreateGroupMappingBadRequest with default headers values
func NewCreateGroupMappingBadRequest() *CreateGroupMappingBadRequest {
	return &CreateGroupMappingBadRequest{}
}

/*
CreateGroupMappingBadRequest describes a response with status code 400, with default header values.

BadRequestError is returned when the request is invalid and it cannot be processed.
*/
type CreateGroupMappingBadRequest struct {
	Payload *models.ErrorResponseBody
}

// IsSuccess returns true when this create group mapping bad request response has a 2xx status code
func (o *CreateGroupMappingBadRequest) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this create group mapping bad request response has a 3xx status code
func (o *CreateGroupMappingBadRequest) IsRedirect() bool {
	return false
}

// IsClientError returns true when this create group mapping bad request response has a 4xx status code
func (o *CreateGroupMappingBadRequest) IsClientError() bool {
	return true
}

// IsServerError returns true when this create group mapping bad request response has a 5xx status code
func (o *CreateGroupMappingBadRequest) IsServerError() bool {
	return false
}

// IsCode returns true when this create group mapping bad request response a status code equal to that given
func (o *CreateGroupMappingBadRequest) IsCode(code int) bool {
	return code == 400
}

// Code gets the status code for the create group mapping bad request response
func (o *CreateGroupMappingBadRequest) Code() int {
	return 400
}

func (o *CreateGroupMappingBadRequest) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /groupsync/mappings][%d] createGroupMappingBadRequest %s", 400, payload)
}

func (o *CreateGroupMappingBadRequest) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /groupsync/mappings][%d] createGroupMappingBadRequest %s", 400, payload)
}

func (o *CreateGroupMappingBadRequest) GetPayload() *models.ErrorResponseBody {
	return o.Payload
}

func (o *CreateGroupMappingBadRequest) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponseBody)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewCreateGroupMappingUnauthorized creates a CreateGroupMappingUnauthorized with default headers values
func NewCreateGroupMappingUnauthorized() *CreateGroupMappingUnauthorized {
	return &CreateGroupMappingUnauthorized{}
}

/*
CreateGroupMappingUnauthorized describes a response with status code 401, with default header values.

UnauthorizedError is returned when the request is not authenticated.
*/
type CreateGroupMappingUnauthorized struct {
	Payload *models.ErrorResponseBody
}

// IsSuccess returns true when this create group mapping unauthorized response has a 2xx status code
func (o *CreateGroupMappingUnauthorized) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this create group mapping unauthorized response has a 3xx status code
func (o *CreateGroupMappingUnauthorized) IsRedirect() bool {
	return false
}

// IsClientError returns true when this create group mapping unauthorized response has a 4xx status code
func (o *CreateGroupMappingUnauthorized) IsClientError() bool {
	return true
}

// IsServerError returns true when this create group mapping unauthorized response has a 5xx status code
func (o *CreateGroupMappingUnauthorized) IsServerError() bool {
	return false
}

// IsCode returns true when this create group mapping unauthorized response a status code equal to that given
func (o *CreateGroupMappingUnauthorized) IsCode(code int) bool {
	return code == 401
}

// Code gets the status code for the create group mapping unauthorized response
func (o *CreateGroupMappingUnauthorized) Code() int {
	return 401
}

func (o *CreateGroupMappingUnauthorized) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /groupsync/mappings][%d] createGroupMappingUnauthorized %s", 401, payload)
}

func (o *CreateGroupMappingUnauthorized) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /groupsync/mappings][%d] createGroupMappingUnauthorized %s", 401, payload)
}

func (o *CreateGroupMappingUnauthorized) GetPayload() *models.ErrorResponseBody {
	return o.Payload
}

func (o *CreateGroupMappingUnauthorized) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponseBody)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewCreateGroupMappingForbidden creates a CreateGroupMappingForbidden with default headers values
func NewCreateGroupMappingForbidden() *CreateGroupMappingForbidden {
	return &CreateGroupMappingForbidden{}
}

/*
CreateGroupMappingForbidden describes a response with status code 403, with default header values.

ForbiddenError is returned if the user/token has insufficient permissions to access the requested resource.
*/
type CreateGroupMappingForbidden struct {
	Payload *models.ErrorResponseBody
}

// IsSuccess returns true when this create group mapping forbidden response has a 2xx status code
func (o *CreateGroupMappingForbidden) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this create group mapping forbidden response has a 3xx status code
func (o *CreateGroupMappingForbidden) IsRedirect() bool {
	return false
}

// IsClientError returns true when this create group mapping forbidden response has a 4xx status code
func (o *CreateGroupMappingForbidden) IsClientError() bool {
	return true
}

// IsServerError returns true when this create group mapping forbidden response has a 5xx status code
func (o *CreateGroupMappingForbidden) IsServerError() bool {
	return false
}

// IsCode returns true when this create group mapping forbidden response a status code equal to that given
func (o *CreateGroupMappingForbidden) IsCode(code int) bool {
	return code == 403
}

// Code gets the status code for the create group mapping forbidden response
func (o *CreateGroupMappingForbidden) Code() int {
	return 403
}

func (o *CreateGroupMappingForbidden) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /groupsync/mappings][%d] createGroupMappingForbidden %s", 403, payload)
}

func (o *CreateGroupMappingForbidden) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /groupsync/mappings][%d] createGroupMappingForbidden %s", 403, payload)
}

func (o *CreateGroupMappingForbidden) GetPayload() *models.ErrorResponseBody {
	return o.Payload
}

func (o *CreateGroupMappingForbidden) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponseBody)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewCreateGroupMappingConflict creates a CreateGroupMappingConflict with default headers values
func NewCreateGroupMappingConflict() *CreateGroupMappingConflict {
	return &CreateGroupMappingConflict{}
}

/*
CreateGroupMappingConflict describes a response with status code 409, with default header values.

ConflictError
*/
type CreateGroupMappingConflict struct {
	Payload *models.ErrorResponseBody
}

// IsSuccess returns true when this create group mapping conflict response has a 2xx status code
func (o *CreateGroupMappingConflict) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this create group mapping conflict response has a 3xx status code
func (o *CreateGroupMappingConflict) IsRedirect() bool {
	return false
}

// IsClientError returns true when this create group mapping conflict response has a 4xx status code
func (o *CreateGroupMappingConflict) IsClientError() bool {
	return true
}

// IsServerError returns true when this create group mapping conflict response has a 5xx status code
func (o *CreateGroupMappingConflict) IsServerError() bool {
	return false
}

// IsCode returns true when this create group mapping conflict response a status code equal to that given
func (o *CreateGroupMappingConflict) IsCode(code int) bool {
	return code == 409
}

// Code gets the status code for the create group mapping conflict response
func (o *CreateGroupMappingConflict) Code() int {
	return 409
}

func (o *CreateGroupMappingConflict) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /groupsync/mappings][%d] createGroupMappingConflict %s", 409, payload)
}

func (o *CreateGroupMappingConflict) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /groupsync/mappings][%d] createGroupMappingConflict %s", 409, payload)
}

func (o *CreateGroupMappingConflict) GetPayload() *models.ErrorResponseBody {
	return o.Payload
}

func (o *CreateGroupMappingConflict) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponseBody)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewCreateGroupMappingInternalServerError creates a CreateGroupMappingInternalServerError with default headers values
func NewCreateGroupMappingInternalServerError() *CreateGroupMappingInternalServerError {
	return &CreateGroupMappingInternalServerError{}
}

/*
CreateGroupMappingInternalServerError describes a response with status code 500, with default header values.

InternalServerError is a general error indicating something went wrong internally.
*/
type CreateGroupMappingInternalServerError struct {
	Payload *models.ErrorResponseBody
}

// IsSuccess returns true when this create group mapping internal server error response has a 2xx status code
func (o *CreateGroupMappingInternalServerError) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this create group mapping internal server error response has a 3xx status code
func (o *CreateGroupMappingInternalServerError) IsRedirect() bool {
	return false
}

// IsClientError returns true when this create group mapping internal server error response has a 4xx status code
func (o *CreateGroupMappingInternalServerError) IsClientError() bool {
	return false
}

// IsServerError returns true when this create group mapping internal server error response has a 5xx status code
func (o *CreateGroupMappingInternalServerError) IsServerError() bool {
	return true
}

// IsCode returns true when this create group mapping internal server error response a status code equal to that given
func (o *CreateGroupMappingInternalServerError) IsCode(code int) bool {
	return code == 500
}

// Code gets the status code for the create group mapping internal server error response
func (o *CreateGroupMappingInternalServerError) Code() int {
	return 500
}

func (o *CreateGroupMappingInternalServerError) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /groupsync/mappings][%d] createGroupMappingInternalServerError %s", 500, payload)
}

func (o *CreateGroupMappingInternalServerError) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /groupsync/mappings][%d] createGroupMappingInternalServerError %s", 500, payload)
}

func (o *CreateGroupMappingInternalServerError) GetPayload() *models.ErrorResponseBody {
	return o.Payload
}

func (o *CreateGroupMappingInternalServerError) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponseBody)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
