// Code generated by go-swagger; DO NOT EDIT.

package enterprise

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/grafana/grafana-openapi-client-go/models"
)

// DisableDataSourceCacheReader is a Reader for the DisableDataSourceCache structure.
type DisableDataSourceCacheReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *DisableDataSourceCacheReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewDisableDataSourceCacheOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	case 500:
		result := NewDisableDataSourceCacheInternalServerError()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	default:
		return nil, runtime.NewAPIError("[POST /datasources/{dataSourceUID}/cache/disable] disableDataSourceCache", response, response.Code())
	}
}

// NewDisableDataSourceCacheOK creates a DisableDataSourceCacheOK with default headers values
func NewDisableDataSourceCacheOK() *DisableDataSourceCacheOK {
	return &DisableDataSourceCacheOK{}
}

/*
DisableDataSourceCacheOK describes a response with status code 200, with default header values.

CacheConfigResponse
*/
type DisableDataSourceCacheOK struct {
	Payload *models.CacheConfigResponse
}

// IsSuccess returns true when this disable data source cache Ok response has a 2xx status code
func (o *DisableDataSourceCacheOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this disable data source cache Ok response has a 3xx status code
func (o *DisableDataSourceCacheOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this disable data source cache Ok response has a 4xx status code
func (o *DisableDataSourceCacheOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this disable data source cache Ok response has a 5xx status code
func (o *DisableDataSourceCacheOK) IsServerError() bool {
	return false
}

// IsCode returns true when this disable data source cache Ok response a status code equal to that given
func (o *DisableDataSourceCacheOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the disable data source cache Ok response
func (o *DisableDataSourceCacheOK) Code() int {
	return 200
}

func (o *DisableDataSourceCacheOK) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /datasources/{dataSourceUID}/cache/disable][%d] disableDataSourceCacheOk %s", 200, payload)
}

func (o *DisableDataSourceCacheOK) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /datasources/{dataSourceUID}/cache/disable][%d] disableDataSourceCacheOk %s", 200, payload)
}

func (o *DisableDataSourceCacheOK) GetPayload() *models.CacheConfigResponse {
	return o.Payload
}

func (o *DisableDataSourceCacheOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.CacheConfigResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewDisableDataSourceCacheInternalServerError creates a DisableDataSourceCacheInternalServerError with default headers values
func NewDisableDataSourceCacheInternalServerError() *DisableDataSourceCacheInternalServerError {
	return &DisableDataSourceCacheInternalServerError{}
}

/*
DisableDataSourceCacheInternalServerError describes a response with status code 500, with default header values.

InternalServerError is a general error indicating something went wrong internally.
*/
type DisableDataSourceCacheInternalServerError struct {
	Payload *models.ErrorResponseBody
}

// IsSuccess returns true when this disable data source cache internal server error response has a 2xx status code
func (o *DisableDataSourceCacheInternalServerError) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this disable data source cache internal server error response has a 3xx status code
func (o *DisableDataSourceCacheInternalServerError) IsRedirect() bool {
	return false
}

// IsClientError returns true when this disable data source cache internal server error response has a 4xx status code
func (o *DisableDataSourceCacheInternalServerError) IsClientError() bool {
	return false
}

// IsServerError returns true when this disable data source cache internal server error response has a 5xx status code
func (o *DisableDataSourceCacheInternalServerError) IsServerError() bool {
	return true
}

// IsCode returns true when this disable data source cache internal server error response a status code equal to that given
func (o *DisableDataSourceCacheInternalServerError) IsCode(code int) bool {
	return code == 500
}

// Code gets the status code for the disable data source cache internal server error response
func (o *DisableDataSourceCacheInternalServerError) Code() int {
	return 500
}

func (o *DisableDataSourceCacheInternalServerError) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /datasources/{dataSourceUID}/cache/disable][%d] disableDataSourceCacheInternalServerError %s", 500, payload)
}

func (o *DisableDataSourceCacheInternalServerError) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /datasources/{dataSourceUID}/cache/disable][%d] disableDataSourceCacheInternalServerError %s", 500, payload)
}

func (o *DisableDataSourceCacheInternalServerError) GetPayload() *models.ErrorResponseBody {
	return o.Payload
}

func (o *DisableDataSourceCacheInternalServerError) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponseBody)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
