// Code generated by go-swagger; DO NOT EDIT.

package datasources

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/grafana/grafana-openapi-client-go/models"
)

// GetDataSourceByUIDReader is a Reader for the GetDataSourceByUID structure.
type GetDataSourceByUIDReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *GetDataSourceByUIDReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewGetDataSourceByUIDOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	case 400:
		result := NewGetDataSourceByUIDBadRequest()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 401:
		result := NewGetDataSourceByUIDUnauthorized()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 403:
		result := NewGetDataSourceByUIDForbidden()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 404:
		result := NewGetDataSourceByUIDNotFound()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 500:
		result := NewGetDataSourceByUIDInternalServerError()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	default:
		return nil, runtime.NewAPIError("[GET /datasources/uid/{uid}] getDataSourceByUID", response, response.Code())
	}
}

// NewGetDataSourceByUIDOK creates a GetDataSourceByUIDOK with default headers values
func NewGetDataSourceByUIDOK() *GetDataSourceByUIDOK {
	return &GetDataSourceByUIDOK{}
}

/*
GetDataSourceByUIDOK describes a response with status code 200, with default header values.

(empty)
*/
type GetDataSourceByUIDOK struct {
	Payload *models.DataSource
}

// IsSuccess returns true when this get data source by Uid Ok response has a 2xx status code
func (o *GetDataSourceByUIDOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this get data source by Uid Ok response has a 3xx status code
func (o *GetDataSourceByUIDOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this get data source by Uid Ok response has a 4xx status code
func (o *GetDataSourceByUIDOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this get data source by Uid Ok response has a 5xx status code
func (o *GetDataSourceByUIDOK) IsServerError() bool {
	return false
}

// IsCode returns true when this get data source by Uid Ok response a status code equal to that given
func (o *GetDataSourceByUIDOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the get data source by Uid Ok response
func (o *GetDataSourceByUIDOK) Code() int {
	return 200
}

func (o *GetDataSourceByUIDOK) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /datasources/uid/{uid}][%d] getDataSourceByUidOk %s", 200, payload)
}

func (o *GetDataSourceByUIDOK) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /datasources/uid/{uid}][%d] getDataSourceByUidOk %s", 200, payload)
}

func (o *GetDataSourceByUIDOK) GetPayload() *models.DataSource {
	return o.Payload
}

func (o *GetDataSourceByUIDOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.DataSource)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewGetDataSourceByUIDBadRequest creates a GetDataSourceByUIDBadRequest with default headers values
func NewGetDataSourceByUIDBadRequest() *GetDataSourceByUIDBadRequest {
	return &GetDataSourceByUIDBadRequest{}
}

/*
GetDataSourceByUIDBadRequest describes a response with status code 400, with default header values.

BadRequestError is returned when the request is invalid and it cannot be processed.
*/
type GetDataSourceByUIDBadRequest struct {
	Payload *models.ErrorResponseBody
}

// IsSuccess returns true when this get data source by Uid bad request response has a 2xx status code
func (o *GetDataSourceByUIDBadRequest) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this get data source by Uid bad request response has a 3xx status code
func (o *GetDataSourceByUIDBadRequest) IsRedirect() bool {
	return false
}

// IsClientError returns true when this get data source by Uid bad request response has a 4xx status code
func (o *GetDataSourceByUIDBadRequest) IsClientError() bool {
	return true
}

// IsServerError returns true when this get data source by Uid bad request response has a 5xx status code
func (o *GetDataSourceByUIDBadRequest) IsServerError() bool {
	return false
}

// IsCode returns true when this get data source by Uid bad request response a status code equal to that given
func (o *GetDataSourceByUIDBadRequest) IsCode(code int) bool {
	return code == 400
}

// Code gets the status code for the get data source by Uid bad request response
func (o *GetDataSourceByUIDBadRequest) Code() int {
	return 400
}

func (o *GetDataSourceByUIDBadRequest) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /datasources/uid/{uid}][%d] getDataSourceByUidBadRequest %s", 400, payload)
}

func (o *GetDataSourceByUIDBadRequest) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /datasources/uid/{uid}][%d] getDataSourceByUidBadRequest %s", 400, payload)
}

func (o *GetDataSourceByUIDBadRequest) GetPayload() *models.ErrorResponseBody {
	return o.Payload
}

func (o *GetDataSourceByUIDBadRequest) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponseBody)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewGetDataSourceByUIDUnauthorized creates a GetDataSourceByUIDUnauthorized with default headers values
func NewGetDataSourceByUIDUnauthorized() *GetDataSourceByUIDUnauthorized {
	return &GetDataSourceByUIDUnauthorized{}
}

/*
GetDataSourceByUIDUnauthorized describes a response with status code 401, with default header values.

UnauthorizedError is returned when the request is not authenticated.
*/
type GetDataSourceByUIDUnauthorized struct {
	Payload *models.ErrorResponseBody
}

// IsSuccess returns true when this get data source by Uid unauthorized response has a 2xx status code
func (o *GetDataSourceByUIDUnauthorized) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this get data source by Uid unauthorized response has a 3xx status code
func (o *GetDataSourceByUIDUnauthorized) IsRedirect() bool {
	return false
}

// IsClientError returns true when this get data source by Uid unauthorized response has a 4xx status code
func (o *GetDataSourceByUIDUnauthorized) IsClientError() bool {
	return true
}

// IsServerError returns true when this get data source by Uid unauthorized response has a 5xx status code
func (o *GetDataSourceByUIDUnauthorized) IsServerError() bool {
	return false
}

// IsCode returns true when this get data source by Uid unauthorized response a status code equal to that given
func (o *GetDataSourceByUIDUnauthorized) IsCode(code int) bool {
	return code == 401
}

// Code gets the status code for the get data source by Uid unauthorized response
func (o *GetDataSourceByUIDUnauthorized) Code() int {
	return 401
}

func (o *GetDataSourceByUIDUnauthorized) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /datasources/uid/{uid}][%d] getDataSourceByUidUnauthorized %s", 401, payload)
}

func (o *GetDataSourceByUIDUnauthorized) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /datasources/uid/{uid}][%d] getDataSourceByUidUnauthorized %s", 401, payload)
}

func (o *GetDataSourceByUIDUnauthorized) GetPayload() *models.ErrorResponseBody {
	return o.Payload
}

func (o *GetDataSourceByUIDUnauthorized) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponseBody)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewGetDataSourceByUIDForbidden creates a GetDataSourceByUIDForbidden with default headers values
func NewGetDataSourceByUIDForbidden() *GetDataSourceByUIDForbidden {
	return &GetDataSourceByUIDForbidden{}
}

/*
GetDataSourceByUIDForbidden describes a response with status code 403, with default header values.

ForbiddenError is returned if the user/token has insufficient permissions to access the requested resource.
*/
type GetDataSourceByUIDForbidden struct {
	Payload *models.ErrorResponseBody
}

// IsSuccess returns true when this get data source by Uid forbidden response has a 2xx status code
func (o *GetDataSourceByUIDForbidden) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this get data source by Uid forbidden response has a 3xx status code
func (o *GetDataSourceByUIDForbidden) IsRedirect() bool {
	return false
}

// IsClientError returns true when this get data source by Uid forbidden response has a 4xx status code
func (o *GetDataSourceByUIDForbidden) IsClientError() bool {
	return true
}

// IsServerError returns true when this get data source by Uid forbidden response has a 5xx status code
func (o *GetDataSourceByUIDForbidden) IsServerError() bool {
	return false
}

// IsCode returns true when this get data source by Uid forbidden response a status code equal to that given
func (o *GetDataSourceByUIDForbidden) IsCode(code int) bool {
	return code == 403
}

// Code gets the status code for the get data source by Uid forbidden response
func (o *GetDataSourceByUIDForbidden) Code() int {
	return 403
}

func (o *GetDataSourceByUIDForbidden) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /datasources/uid/{uid}][%d] getDataSourceByUidForbidden %s", 403, payload)
}

func (o *GetDataSourceByUIDForbidden) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /datasources/uid/{uid}][%d] getDataSourceByUidForbidden %s", 403, payload)
}

func (o *GetDataSourceByUIDForbidden) GetPayload() *models.ErrorResponseBody {
	return o.Payload
}

func (o *GetDataSourceByUIDForbidden) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponseBody)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewGetDataSourceByUIDNotFound creates a GetDataSourceByUIDNotFound with default headers values
func NewGetDataSourceByUIDNotFound() *GetDataSourceByUIDNotFound {
	return &GetDataSourceByUIDNotFound{}
}

/*
GetDataSourceByUIDNotFound describes a response with status code 404, with default header values.

NotFoundError is returned when the requested resource was not found.
*/
type GetDataSourceByUIDNotFound struct {
	Payload *models.ErrorResponseBody
}

// IsSuccess returns true when this get data source by Uid not found response has a 2xx status code
func (o *GetDataSourceByUIDNotFound) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this get data source by Uid not found response has a 3xx status code
func (o *GetDataSourceByUIDNotFound) IsRedirect() bool {
	return false
}

// IsClientError returns true when this get data source by Uid not found response has a 4xx status code
func (o *GetDataSourceByUIDNotFound) IsClientError() bool {
	return true
}

// IsServerError returns true when this get data source by Uid not found response has a 5xx status code
func (o *GetDataSourceByUIDNotFound) IsServerError() bool {
	return false
}

// IsCode returns true when this get data source by Uid not found response a status code equal to that given
func (o *GetDataSourceByUIDNotFound) IsCode(code int) bool {
	return code == 404
}

// Code gets the status code for the get data source by Uid not found response
func (o *GetDataSourceByUIDNotFound) Code() int {
	return 404
}

func (o *GetDataSourceByUIDNotFound) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /datasources/uid/{uid}][%d] getDataSourceByUidNotFound %s", 404, payload)
}

func (o *GetDataSourceByUIDNotFound) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /datasources/uid/{uid}][%d] getDataSourceByUidNotFound %s", 404, payload)
}

func (o *GetDataSourceByUIDNotFound) GetPayload() *models.ErrorResponseBody {
	return o.Payload
}

func (o *GetDataSourceByUIDNotFound) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponseBody)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewGetDataSourceByUIDInternalServerError creates a GetDataSourceByUIDInternalServerError with default headers values
func NewGetDataSourceByUIDInternalServerError() *GetDataSourceByUIDInternalServerError {
	return &GetDataSourceByUIDInternalServerError{}
}

/*
GetDataSourceByUIDInternalServerError describes a response with status code 500, with default header values.

InternalServerError is a general error indicating something went wrong internally.
*/
type GetDataSourceByUIDInternalServerError struct {
	Payload *models.ErrorResponseBody
}

// IsSuccess returns true when this get data source by Uid internal server error response has a 2xx status code
func (o *GetDataSourceByUIDInternalServerError) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this get data source by Uid internal server error response has a 3xx status code
func (o *GetDataSourceByUIDInternalServerError) IsRedirect() bool {
	return false
}

// IsClientError returns true when this get data source by Uid internal server error response has a 4xx status code
func (o *GetDataSourceByUIDInternalServerError) IsClientError() bool {
	return false
}

// IsServerError returns true when this get data source by Uid internal server error response has a 5xx status code
func (o *GetDataSourceByUIDInternalServerError) IsServerError() bool {
	return true
}

// IsCode returns true when this get data source by Uid internal server error response a status code equal to that given
func (o *GetDataSourceByUIDInternalServerError) IsCode(code int) bool {
	return code == 500
}

// Code gets the status code for the get data source by Uid internal server error response
func (o *GetDataSourceByUIDInternalServerError) Code() int {
	return 500
}

func (o *GetDataSourceByUIDInternalServerError) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /datasources/uid/{uid}][%d] getDataSourceByUidInternalServerError %s", 500, payload)
}

func (o *GetDataSourceByUIDInternalServerError) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /datasources/uid/{uid}][%d] getDataSourceByUidInternalServerError %s", 500, payload)
}

func (o *GetDataSourceByUIDInternalServerError) GetPayload() *models.ErrorResponseBody {
	return o.Payload
}

func (o *GetDataSourceByUIDInternalServerError) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponseBody)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
