// Code generated by go-swagger; DO NOT EDIT.

package dashboard_public

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/grafana/grafana-openapi-client-go/models"
)

// DeletePublicDashboardReader is a Reader for the DeletePublicDashboard structure.
type DeletePublicDashboardReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *DeletePublicDashboardReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewDeletePublicDashboardOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	case 400:
		result := NewDeletePublicDashboardBadRequest()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 401:
		result := NewDeletePublicDashboardUnauthorized()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 403:
		result := NewDeletePublicDashboardForbidden()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 500:
		result := NewDeletePublicDashboardInternalServerError()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	default:
		return nil, runtime.NewAPIError("[DELETE /dashboards/uid/{dashboardUid}/public-dashboards/{uid}] deletePublicDashboard", response, response.Code())
	}
}

// NewDeletePublicDashboardOK creates a DeletePublicDashboardOK with default headers values
func NewDeletePublicDashboardOK() *DeletePublicDashboardOK {
	return &DeletePublicDashboardOK{}
}

/*
DeletePublicDashboardOK describes a response with status code 200, with default header values.

An OKResponse is returned if the request was successful.
*/
type DeletePublicDashboardOK struct {
	Payload *models.SuccessResponseBody
}

// IsSuccess returns true when this delete public dashboard Ok response has a 2xx status code
func (o *DeletePublicDashboardOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this delete public dashboard Ok response has a 3xx status code
func (o *DeletePublicDashboardOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this delete public dashboard Ok response has a 4xx status code
func (o *DeletePublicDashboardOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this delete public dashboard Ok response has a 5xx status code
func (o *DeletePublicDashboardOK) IsServerError() bool {
	return false
}

// IsCode returns true when this delete public dashboard Ok response a status code equal to that given
func (o *DeletePublicDashboardOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the delete public dashboard Ok response
func (o *DeletePublicDashboardOK) Code() int {
	return 200
}

func (o *DeletePublicDashboardOK) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /dashboards/uid/{dashboardUid}/public-dashboards/{uid}][%d] deletePublicDashboardOk %s", 200, payload)
}

func (o *DeletePublicDashboardOK) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /dashboards/uid/{dashboardUid}/public-dashboards/{uid}][%d] deletePublicDashboardOk %s", 200, payload)
}

func (o *DeletePublicDashboardOK) GetPayload() *models.SuccessResponseBody {
	return o.Payload
}

func (o *DeletePublicDashboardOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.SuccessResponseBody)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewDeletePublicDashboardBadRequest creates a DeletePublicDashboardBadRequest with default headers values
func NewDeletePublicDashboardBadRequest() *DeletePublicDashboardBadRequest {
	return &DeletePublicDashboardBadRequest{}
}

/*
DeletePublicDashboardBadRequest describes a response with status code 400, with default header values.

BadRequestPublicError is returned when the request is invalid and it cannot be processed.
*/
type DeletePublicDashboardBadRequest struct {
	Payload *models.PublicError
}

// IsSuccess returns true when this delete public dashboard bad request response has a 2xx status code
func (o *DeletePublicDashboardBadRequest) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this delete public dashboard bad request response has a 3xx status code
func (o *DeletePublicDashboardBadRequest) IsRedirect() bool {
	return false
}

// IsClientError returns true when this delete public dashboard bad request response has a 4xx status code
func (o *DeletePublicDashboardBadRequest) IsClientError() bool {
	return true
}

// IsServerError returns true when this delete public dashboard bad request response has a 5xx status code
func (o *DeletePublicDashboardBadRequest) IsServerError() bool {
	return false
}

// IsCode returns true when this delete public dashboard bad request response a status code equal to that given
func (o *DeletePublicDashboardBadRequest) IsCode(code int) bool {
	return code == 400
}

// Code gets the status code for the delete public dashboard bad request response
func (o *DeletePublicDashboardBadRequest) Code() int {
	return 400
}

func (o *DeletePublicDashboardBadRequest) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /dashboards/uid/{dashboardUid}/public-dashboards/{uid}][%d] deletePublicDashboardBadRequest %s", 400, payload)
}

func (o *DeletePublicDashboardBadRequest) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /dashboards/uid/{dashboardUid}/public-dashboards/{uid}][%d] deletePublicDashboardBadRequest %s", 400, payload)
}

func (o *DeletePublicDashboardBadRequest) GetPayload() *models.PublicError {
	return o.Payload
}

func (o *DeletePublicDashboardBadRequest) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.PublicError)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewDeletePublicDashboardUnauthorized creates a DeletePublicDashboardUnauthorized with default headers values
func NewDeletePublicDashboardUnauthorized() *DeletePublicDashboardUnauthorized {
	return &DeletePublicDashboardUnauthorized{}
}

/*
DeletePublicDashboardUnauthorized describes a response with status code 401, with default header values.

UnauthorisedPublicError is returned when the request is not authenticated.
*/
type DeletePublicDashboardUnauthorized struct {
	Payload *models.PublicError
}

// IsSuccess returns true when this delete public dashboard unauthorized response has a 2xx status code
func (o *DeletePublicDashboardUnauthorized) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this delete public dashboard unauthorized response has a 3xx status code
func (o *DeletePublicDashboardUnauthorized) IsRedirect() bool {
	return false
}

// IsClientError returns true when this delete public dashboard unauthorized response has a 4xx status code
func (o *DeletePublicDashboardUnauthorized) IsClientError() bool {
	return true
}

// IsServerError returns true when this delete public dashboard unauthorized response has a 5xx status code
func (o *DeletePublicDashboardUnauthorized) IsServerError() bool {
	return false
}

// IsCode returns true when this delete public dashboard unauthorized response a status code equal to that given
func (o *DeletePublicDashboardUnauthorized) IsCode(code int) bool {
	return code == 401
}

// Code gets the status code for the delete public dashboard unauthorized response
func (o *DeletePublicDashboardUnauthorized) Code() int {
	return 401
}

func (o *DeletePublicDashboardUnauthorized) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /dashboards/uid/{dashboardUid}/public-dashboards/{uid}][%d] deletePublicDashboardUnauthorized %s", 401, payload)
}

func (o *DeletePublicDashboardUnauthorized) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /dashboards/uid/{dashboardUid}/public-dashboards/{uid}][%d] deletePublicDashboardUnauthorized %s", 401, payload)
}

func (o *DeletePublicDashboardUnauthorized) GetPayload() *models.PublicError {
	return o.Payload
}

func (o *DeletePublicDashboardUnauthorized) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.PublicError)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewDeletePublicDashboardForbidden creates a DeletePublicDashboardForbidden with default headers values
func NewDeletePublicDashboardForbidden() *DeletePublicDashboardForbidden {
	return &DeletePublicDashboardForbidden{}
}

/*
DeletePublicDashboardForbidden describes a response with status code 403, with default header values.

ForbiddenPublicError is returned if the user/token has insufficient permissions to access the requested resource.
*/
type DeletePublicDashboardForbidden struct {
	Payload *models.PublicError
}

// IsSuccess returns true when this delete public dashboard forbidden response has a 2xx status code
func (o *DeletePublicDashboardForbidden) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this delete public dashboard forbidden response has a 3xx status code
func (o *DeletePublicDashboardForbidden) IsRedirect() bool {
	return false
}

// IsClientError returns true when this delete public dashboard forbidden response has a 4xx status code
func (o *DeletePublicDashboardForbidden) IsClientError() bool {
	return true
}

// IsServerError returns true when this delete public dashboard forbidden response has a 5xx status code
func (o *DeletePublicDashboardForbidden) IsServerError() bool {
	return false
}

// IsCode returns true when this delete public dashboard forbidden response a status code equal to that given
func (o *DeletePublicDashboardForbidden) IsCode(code int) bool {
	return code == 403
}

// Code gets the status code for the delete public dashboard forbidden response
func (o *DeletePublicDashboardForbidden) Code() int {
	return 403
}

func (o *DeletePublicDashboardForbidden) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /dashboards/uid/{dashboardUid}/public-dashboards/{uid}][%d] deletePublicDashboardForbidden %s", 403, payload)
}

func (o *DeletePublicDashboardForbidden) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /dashboards/uid/{dashboardUid}/public-dashboards/{uid}][%d] deletePublicDashboardForbidden %s", 403, payload)
}

func (o *DeletePublicDashboardForbidden) GetPayload() *models.PublicError {
	return o.Payload
}

func (o *DeletePublicDashboardForbidden) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.PublicError)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewDeletePublicDashboardInternalServerError creates a DeletePublicDashboardInternalServerError with default headers values
func NewDeletePublicDashboardInternalServerError() *DeletePublicDashboardInternalServerError {
	return &DeletePublicDashboardInternalServerError{}
}

/*
DeletePublicDashboardInternalServerError describes a response with status code 500, with default header values.

InternalServerPublicError is a general error indicating something went wrong internally.
*/
type DeletePublicDashboardInternalServerError struct {
	Payload *models.PublicError
}

// IsSuccess returns true when this delete public dashboard internal server error response has a 2xx status code
func (o *DeletePublicDashboardInternalServerError) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this delete public dashboard internal server error response has a 3xx status code
func (o *DeletePublicDashboardInternalServerError) IsRedirect() bool {
	return false
}

// IsClientError returns true when this delete public dashboard internal server error response has a 4xx status code
func (o *DeletePublicDashboardInternalServerError) IsClientError() bool {
	return false
}

// IsServerError returns true when this delete public dashboard internal server error response has a 5xx status code
func (o *DeletePublicDashboardInternalServerError) IsServerError() bool {
	return true
}

// IsCode returns true when this delete public dashboard internal server error response a status code equal to that given
func (o *DeletePublicDashboardInternalServerError) IsCode(code int) bool {
	return code == 500
}

// Code gets the status code for the delete public dashboard internal server error response
func (o *DeletePublicDashboardInternalServerError) Code() int {
	return 500
}

func (o *DeletePublicDashboardInternalServerError) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /dashboards/uid/{dashboardUid}/public-dashboards/{uid}][%d] deletePublicDashboardInternalServerError %s", 500, payload)
}

func (o *DeletePublicDashboardInternalServerError) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /dashboards/uid/{dashboardUid}/public-dashboards/{uid}][%d] deletePublicDashboardInternalServerError %s", 500, payload)
}

func (o *DeletePublicDashboardInternalServerError) GetPayload() *models.PublicError {
	return o.Payload
}

func (o *DeletePublicDashboardInternalServerError) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.PublicError)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
