// Code generated by go-swagger; DO NOT EDIT.

package access_control

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/grafana/grafana-openapi-client-go/models"
)

// UpdateRoleReader is a Reader for the UpdateRole structure.
type UpdateRoleReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *UpdateRoleReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewUpdateRoleOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	case 400:
		result := NewUpdateRoleBadRequest()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 403:
		result := NewUpdateRoleForbidden()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 404:
		result := NewUpdateRoleNotFound()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 500:
		result := NewUpdateRoleInternalServerError()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	default:
		return nil, runtime.NewAPIError("[PUT /access-control/roles/{roleUID}] updateRole", response, response.Code())
	}
}

// NewUpdateRoleOK creates a UpdateRoleOK with default headers values
func NewUpdateRoleOK() *UpdateRoleOK {
	return &UpdateRoleOK{}
}

/*
UpdateRoleOK describes a response with status code 200, with default header values.

(empty)
*/
type UpdateRoleOK struct {
	Payload *models.RoleDTO
}

// IsSuccess returns true when this update role Ok response has a 2xx status code
func (o *UpdateRoleOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this update role Ok response has a 3xx status code
func (o *UpdateRoleOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this update role Ok response has a 4xx status code
func (o *UpdateRoleOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this update role Ok response has a 5xx status code
func (o *UpdateRoleOK) IsServerError() bool {
	return false
}

// IsCode returns true when this update role Ok response a status code equal to that given
func (o *UpdateRoleOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the update role Ok response
func (o *UpdateRoleOK) Code() int {
	return 200
}

func (o *UpdateRoleOK) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PUT /access-control/roles/{roleUID}][%d] updateRoleOk %s", 200, payload)
}

func (o *UpdateRoleOK) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PUT /access-control/roles/{roleUID}][%d] updateRoleOk %s", 200, payload)
}

func (o *UpdateRoleOK) GetPayload() *models.RoleDTO {
	return o.Payload
}

func (o *UpdateRoleOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.RoleDTO)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewUpdateRoleBadRequest creates a UpdateRoleBadRequest with default headers values
func NewUpdateRoleBadRequest() *UpdateRoleBadRequest {
	return &UpdateRoleBadRequest{}
}

/*
UpdateRoleBadRequest describes a response with status code 400, with default header values.

BadRequestError is returned when the request is invalid and it cannot be processed.
*/
type UpdateRoleBadRequest struct {
	Payload *models.ErrorResponseBody
}

// IsSuccess returns true when this update role bad request response has a 2xx status code
func (o *UpdateRoleBadRequest) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this update role bad request response has a 3xx status code
func (o *UpdateRoleBadRequest) IsRedirect() bool {
	return false
}

// IsClientError returns true when this update role bad request response has a 4xx status code
func (o *UpdateRoleBadRequest) IsClientError() bool {
	return true
}

// IsServerError returns true when this update role bad request response has a 5xx status code
func (o *UpdateRoleBadRequest) IsServerError() bool {
	return false
}

// IsCode returns true when this update role bad request response a status code equal to that given
func (o *UpdateRoleBadRequest) IsCode(code int) bool {
	return code == 400
}

// Code gets the status code for the update role bad request response
func (o *UpdateRoleBadRequest) Code() int {
	return 400
}

func (o *UpdateRoleBadRequest) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PUT /access-control/roles/{roleUID}][%d] updateRoleBadRequest %s", 400, payload)
}

func (o *UpdateRoleBadRequest) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PUT /access-control/roles/{roleUID}][%d] updateRoleBadRequest %s", 400, payload)
}

func (o *UpdateRoleBadRequest) GetPayload() *models.ErrorResponseBody {
	return o.Payload
}

func (o *UpdateRoleBadRequest) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponseBody)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewUpdateRoleForbidden creates a UpdateRoleForbidden with default headers values
func NewUpdateRoleForbidden() *UpdateRoleForbidden {
	return &UpdateRoleForbidden{}
}

/*
UpdateRoleForbidden describes a response with status code 403, with default header values.

ForbiddenError is returned if the user/token has insufficient permissions to access the requested resource.
*/
type UpdateRoleForbidden struct {
	Payload *models.ErrorResponseBody
}

// IsSuccess returns true when this update role forbidden response has a 2xx status code
func (o *UpdateRoleForbidden) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this update role forbidden response has a 3xx status code
func (o *UpdateRoleForbidden) IsRedirect() bool {
	return false
}

// IsClientError returns true when this update role forbidden response has a 4xx status code
func (o *UpdateRoleForbidden) IsClientError() bool {
	return true
}

// IsServerError returns true when this update role forbidden response has a 5xx status code
func (o *UpdateRoleForbidden) IsServerError() bool {
	return false
}

// IsCode returns true when this update role forbidden response a status code equal to that given
func (o *UpdateRoleForbidden) IsCode(code int) bool {
	return code == 403
}

// Code gets the status code for the update role forbidden response
func (o *UpdateRoleForbidden) Code() int {
	return 403
}

func (o *UpdateRoleForbidden) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PUT /access-control/roles/{roleUID}][%d] updateRoleForbidden %s", 403, payload)
}

func (o *UpdateRoleForbidden) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PUT /access-control/roles/{roleUID}][%d] updateRoleForbidden %s", 403, payload)
}

func (o *UpdateRoleForbidden) GetPayload() *models.ErrorResponseBody {
	return o.Payload
}

func (o *UpdateRoleForbidden) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponseBody)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewUpdateRoleNotFound creates a UpdateRoleNotFound with default headers values
func NewUpdateRoleNotFound() *UpdateRoleNotFound {
	return &UpdateRoleNotFound{}
}

/*
UpdateRoleNotFound describes a response with status code 404, with default header values.

NotFoundError is returned when the requested resource was not found.
*/
type UpdateRoleNotFound struct {
	Payload *models.ErrorResponseBody
}

// IsSuccess returns true when this update role not found response has a 2xx status code
func (o *UpdateRoleNotFound) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this update role not found response has a 3xx status code
func (o *UpdateRoleNotFound) IsRedirect() bool {
	return false
}

// IsClientError returns true when this update role not found response has a 4xx status code
func (o *UpdateRoleNotFound) IsClientError() bool {
	return true
}

// IsServerError returns true when this update role not found response has a 5xx status code
func (o *UpdateRoleNotFound) IsServerError() bool {
	return false
}

// IsCode returns true when this update role not found response a status code equal to that given
func (o *UpdateRoleNotFound) IsCode(code int) bool {
	return code == 404
}

// Code gets the status code for the update role not found response
func (o *UpdateRoleNotFound) Code() int {
	return 404
}

func (o *UpdateRoleNotFound) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PUT /access-control/roles/{roleUID}][%d] updateRoleNotFound %s", 404, payload)
}

func (o *UpdateRoleNotFound) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PUT /access-control/roles/{roleUID}][%d] updateRoleNotFound %s", 404, payload)
}

func (o *UpdateRoleNotFound) GetPayload() *models.ErrorResponseBody {
	return o.Payload
}

func (o *UpdateRoleNotFound) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponseBody)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewUpdateRoleInternalServerError creates a UpdateRoleInternalServerError with default headers values
func NewUpdateRoleInternalServerError() *UpdateRoleInternalServerError {
	return &UpdateRoleInternalServerError{}
}

/*
UpdateRoleInternalServerError describes a response with status code 500, with default header values.

InternalServerError is a general error indicating something went wrong internally.
*/
type UpdateRoleInternalServerError struct {
	Payload *models.ErrorResponseBody
}

// IsSuccess returns true when this update role internal server error response has a 2xx status code
func (o *UpdateRoleInternalServerError) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this update role internal server error response has a 3xx status code
func (o *UpdateRoleInternalServerError) IsRedirect() bool {
	return false
}

// IsClientError returns true when this update role internal server error response has a 4xx status code
func (o *UpdateRoleInternalServerError) IsClientError() bool {
	return false
}

// IsServerError returns true when this update role internal server error response has a 5xx status code
func (o *UpdateRoleInternalServerError) IsServerError() bool {
	return true
}

// IsCode returns true when this update role internal server error response a status code equal to that given
func (o *UpdateRoleInternalServerError) IsCode(code int) bool {
	return code == 500
}

// Code gets the status code for the update role internal server error response
func (o *UpdateRoleInternalServerError) Code() int {
	return 500
}

func (o *UpdateRoleInternalServerError) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PUT /access-control/roles/{roleUID}][%d] updateRoleInternalServerError %s", 500, payload)
}

func (o *UpdateRoleInternalServerError) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PUT /access-control/roles/{roleUID}][%d] updateRoleInternalServerError %s", 500, payload)
}

func (o *UpdateRoleInternalServerError) GetPayload() *models.ErrorResponseBody {
	return o.Payload
}

func (o *UpdateRoleInternalServerError) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponseBody)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
