// Code generated by go-swagger; DO NOT EDIT.

package access_control

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"

	"github.com/grafana/grafana-openapi-client-go/models"
)

// NewSetResourcePermissionsParams creates a new SetResourcePermissionsParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewSetResourcePermissionsParams() *SetResourcePermissionsParams {
	return &SetResourcePermissionsParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewSetResourcePermissionsParamsWithTimeout creates a new SetResourcePermissionsParams object
// with the ability to set a timeout on a request.
func NewSetResourcePermissionsParamsWithTimeout(timeout time.Duration) *SetResourcePermissionsParams {
	return &SetResourcePermissionsParams{
		timeout: timeout,
	}
}

// NewSetResourcePermissionsParamsWithContext creates a new SetResourcePermissionsParams object
// with the ability to set a context for a request.
func NewSetResourcePermissionsParamsWithContext(ctx context.Context) *SetResourcePermissionsParams {
	return &SetResourcePermissionsParams{
		Context: ctx,
	}
}

// NewSetResourcePermissionsParamsWithHTTPClient creates a new SetResourcePermissionsParams object
// with the ability to set a custom HTTPClient for a request.
func NewSetResourcePermissionsParamsWithHTTPClient(client *http.Client) *SetResourcePermissionsParams {
	return &SetResourcePermissionsParams{
		HTTPClient: client,
	}
}

/*
SetResourcePermissionsParams contains all the parameters to send to the API endpoint

	for the set resource permissions operation.

	Typically these are written to a http.Request.
*/
type SetResourcePermissionsParams struct {

	// Body.
	Body *models.SetPermissionsCommand

	// Resource.
	Resource string

	// ResourceID.
	ResourceID string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the set resource permissions params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *SetResourcePermissionsParams) WithDefaults() *SetResourcePermissionsParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the set resource permissions params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *SetResourcePermissionsParams) SetDefaults() {
	// no default values defined for this parameter
}

// WithTimeout adds the timeout to the set resource permissions params
func (o *SetResourcePermissionsParams) WithTimeout(timeout time.Duration) *SetResourcePermissionsParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the set resource permissions params
func (o *SetResourcePermissionsParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the set resource permissions params
func (o *SetResourcePermissionsParams) WithContext(ctx context.Context) *SetResourcePermissionsParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the set resource permissions params
func (o *SetResourcePermissionsParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the set resource permissions params
func (o *SetResourcePermissionsParams) WithHTTPClient(client *http.Client) *SetResourcePermissionsParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the set resource permissions params
func (o *SetResourcePermissionsParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithBody adds the body to the set resource permissions params
func (o *SetResourcePermissionsParams) WithBody(body *models.SetPermissionsCommand) *SetResourcePermissionsParams {
	o.SetBody(body)
	return o
}

// SetBody adds the body to the set resource permissions params
func (o *SetResourcePermissionsParams) SetBody(body *models.SetPermissionsCommand) {
	o.Body = body
}

// WithResource adds the resource to the set resource permissions params
func (o *SetResourcePermissionsParams) WithResource(resource string) *SetResourcePermissionsParams {
	o.SetResource(resource)
	return o
}

// SetResource adds the resource to the set resource permissions params
func (o *SetResourcePermissionsParams) SetResource(resource string) {
	o.Resource = resource
}

// WithResourceID adds the resourceID to the set resource permissions params
func (o *SetResourcePermissionsParams) WithResourceID(resourceID string) *SetResourcePermissionsParams {
	o.SetResourceID(resourceID)
	return o
}

// SetResourceID adds the resourceId to the set resource permissions params
func (o *SetResourcePermissionsParams) SetResourceID(resourceID string) {
	o.ResourceID = resourceID
}

// WriteToRequest writes these params to a swagger request
func (o *SetResourcePermissionsParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error
	if o.Body != nil {
		if err := r.SetBodyParam(o.Body); err != nil {
			return err
		}
	}

	// path param resource
	if err := r.SetPathParam("resource", o.Resource); err != nil {
		return err
	}

	// path param resourceID
	if err := r.SetPathParam("resourceID", o.ResourceID); err != nil {
		return err
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
