/*
 * Decompiled with CFR 0.152.
 */
package org.openide.io;

import java.awt.Color;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.EnumSet;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Action;
import org.netbeans.api.io.Hyperlink;
import org.netbeans.api.io.OutputColor;
import org.netbeans.api.io.ShowOperation;
import org.netbeans.spi.io.InputOutputProvider;
import org.netbeans.spi.io.support.Hyperlinks;
import org.netbeans.spi.io.support.OutputColorType;
import org.netbeans.spi.io.support.OutputColors;
import org.openide.util.Lookup;
import org.openide.windows.FoldHandle;
import org.openide.windows.IOColorLines;
import org.openide.windows.IOColorPrint;
import org.openide.windows.IOColors;
import org.openide.windows.IOContainer;
import org.openide.windows.IOFolding;
import org.openide.windows.IOPosition;
import org.openide.windows.IOProvider;
import org.openide.windows.IOSelect;
import org.openide.windows.IOTab;
import org.openide.windows.InputOutput;
import org.openide.windows.OutputEvent;
import org.openide.windows.OutputListener;
import org.openide.windows.OutputWriter;

public final class BridgingInputOutputProvider
implements InputOutputProvider<InputOutput, OutputWriter, IOPosition.Position, FoldHandle> {
    private final IOProvider delegate;
    private static final Logger LOG = Logger.getLogger(BridgingInputOutputProvider.class.getName());
    private final Deque<FoldHandle> foldStack = new ArrayDeque<FoldHandle>();

    public BridgingInputOutputProvider(IOProvider iOProvider) {
        this.delegate = iOProvider;
    }

    public String getId() {
        return this.delegate.getName();
    }

    public InputOutput getIO(String string, boolean bl, Lookup lookup) {
        Action[] actionArray = (Action[])lookup.lookup(Action[].class);
        IOContainer iOContainer = (IOContainer)lookup.lookup(IOContainer.class);
        if (iOContainer == null && actionArray == null) {
            return this.delegate.getIO(string, bl);
        }
        if (bl) {
            if (iOContainer != null && actionArray != null) {
                return this.delegate.getIO(string, actionArray, iOContainer);
            }
            if (actionArray != null) {
                return this.delegate.getIO(string, actionArray);
            }
            return this.delegate.getIO(string, new Action[0], iOContainer);
        }
        return this.delegate.getIO(string, bl, actionArray == null ? new Action[]{} : actionArray, iOContainer);
    }

    public Reader getIn(InputOutput inputOutput) {
        return inputOutput.getIn();
    }

    public OutputWriter getOut(InputOutput inputOutput) {
        return inputOutput.getOut();
    }

    public OutputWriter getErr(InputOutput inputOutput) {
        return inputOutput.getErr();
    }

    public void print(InputOutput inputOutput, OutputWriter outputWriter, String string, Hyperlink hyperlink, OutputColor outputColor, boolean bl) {
        Color color = BridgingInputOutputProvider.outputColorToAwtColor(inputOutput, outputColor);
        OutputListener outputListener = BridgingInputOutputProvider.hyperlinkToOutputListener(hyperlink);
        boolean bl2 = hyperlink != null && Hyperlinks.isImportant((Hyperlink)hyperlink);
        try {
            if (bl && outputColor == null) {
                outputWriter.println(string, outputListener, bl2);
            } else if (bl && IOColorLines.isSupported(inputOutput)) {
                IOColorLines.println(inputOutput, string, outputListener, bl2, color);
            } else if (IOColorPrint.isSupported(inputOutput)) {
                IOColorPrint.print(inputOutput, string, outputListener, bl2, color);
                if (bl) {
                    outputWriter.println();
                }
            } else if (bl) {
                outputWriter.println(string);
            } else {
                outputWriter.print(string);
            }
        }
        catch (IOException iOException) {
            LOG.log(Level.FINE, "Cannot print color or hyperlink", iOException);
        }
    }

    public Lookup getIOLookup(InputOutput inputOutput) {
        if (inputOutput instanceof Lookup.Provider) {
            return ((Lookup.Provider)inputOutput).getLookup();
        }
        return Lookup.EMPTY;
    }

    public void resetIO(InputOutput inputOutput) {
        try {
            inputOutput.getOut().reset();
        }
        catch (IOException iOException) {
            LOG.log(Level.FINE, "Cannot reset InputOutput.", iOException);
        }
    }

    public void showIO(InputOutput inputOutput, Set<ShowOperation> set) {
        if (set.contains(ShowOperation.OPEN) && set.contains(ShowOperation.MAKE_VISIBLE) && set.size() == 2) {
            inputOutput.select();
        } else {
            IOSelect.select(inputOutput, this.showOperationsToIoSelect(set));
        }
    }

    private Set<IOSelect.AdditionalOperation> showOperationsToIoSelect(Set<ShowOperation> set) {
        EnumSet<IOSelect.AdditionalOperation> enumSet = EnumSet.noneOf(IOSelect.AdditionalOperation.class);
        for (ShowOperation showOperation : set) {
            switch (showOperation) {
                case OPEN: {
                    enumSet.add(IOSelect.AdditionalOperation.OPEN);
                    break;
                }
                case MAKE_VISIBLE: {
                    enumSet.add(IOSelect.AdditionalOperation.REQUEST_VISIBLE);
                    break;
                }
                case ACTIVATE: {
                    enumSet.add(IOSelect.AdditionalOperation.REQUEST_ACTIVE);
                }
            }
        }
        return enumSet;
    }

    public void closeIO(InputOutput inputOutput) {
        inputOutput.closeInputOutput();
    }

    public boolean isIOClosed(InputOutput inputOutput) {
        return inputOutput.isClosed();
    }

    public IOPosition.Position getCurrentPosition(InputOutput inputOutput, OutputWriter outputWriter) {
        if (IOPosition.isSupported(inputOutput)) {
            return IOPosition.currentPosition(inputOutput);
        }
        return null;
    }

    public void scrollTo(InputOutput inputOutput, OutputWriter outputWriter, IOPosition.Position position) {
        position.scrollTo();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FoldHandle startFold(InputOutput inputOutput, OutputWriter outputWriter, boolean bl) {
        if (IOFolding.isSupported(inputOutput)) {
            Deque<FoldHandle> deque = this.foldStack;
            synchronized (deque) {
                if (this.foldStack.isEmpty()) {
                    this.foldStack.addLast(IOFolding.startFold(inputOutput, bl));
                } else {
                    this.foldStack.addLast(this.foldStack.getLast().startFold(bl));
                }
                return this.foldStack.getLast();
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void endFold(InputOutput inputOutput, OutputWriter outputWriter, FoldHandle foldHandle) {
        Deque<FoldHandle> deque = this.foldStack;
        synchronized (deque) {
            while (!this.foldStack.isEmpty() && this.foldStack.removeLast() != foldHandle) {
            }
            foldHandle.silentFinish();
        }
    }

    public void setFoldExpanded(InputOutput inputOutput, OutputWriter outputWriter, FoldHandle foldHandle, boolean bl) {
        foldHandle.setExpanded(bl);
    }

    public String getIODescription(InputOutput inputOutput) {
        if (IOTab.isSupported(inputOutput)) {
            return IOTab.getToolTipText(inputOutput);
        }
        return null;
    }

    public void setIODescription(InputOutput inputOutput, String string) {
        if (IOTab.isSupported(inputOutput)) {
            IOTab.setToolTipText(inputOutput, string);
        }
    }

    private static OutputListener hyperlinkToOutputListener(final Hyperlink hyperlink) {
        if (hyperlink == null) {
            return null;
        }
        return new OutputListenerAdapter(){

            @Override
            public void outputLineAction(OutputEvent outputEvent) {
                Hyperlinks.invoke((Hyperlink)hyperlink);
            }
        };
    }

    private static Color outputColorToAwtColor(InputOutput inputOutput, OutputColor outputColor) {
        if (outputColor == null) {
            return null;
        }
        OutputColorType outputColorType = OutputColors.getType((OutputColor)outputColor);
        if (outputColorType == OutputColorType.RGB) {
            return new Color(OutputColors.getRGB((OutputColor)outputColor));
        }
        if (IOColors.isSupported(inputOutput)) {
            switch (outputColorType) {
                case DEBUG: {
                    return IOColors.getColor(inputOutput, IOColors.OutputType.LOG_DEBUG);
                }
                case FAILURE: {
                    return IOColors.getColor(inputOutput, IOColors.OutputType.LOG_FAILURE);
                }
                case WARNING: {
                    return IOColors.getColor(inputOutput, IOColors.OutputType.LOG_WARNING);
                }
                case SUCCESS: {
                    return IOColors.getColor(inputOutput, IOColors.OutputType.LOG_SUCCESS);
                }
            }
            return null;
        }
        return null;
    }

    private static class OutputListenerAdapter
    implements OutputListener {
        private OutputListenerAdapter() {
        }

        @Override
        public void outputLineSelected(OutputEvent outputEvent) {
        }

        @Override
        public void outputLineAction(OutputEvent outputEvent) {
        }

        @Override
        public void outputLineCleared(OutputEvent outputEvent) {
        }
    }
}

