// Copyright (c) 2016, 2018, 2025, Oracle and/or its affiliates.  All rights reserved.
// This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.
// Code generated. DO NOT EDIT.

// Ops Insights API
//
// Use the Ops Insights API to perform data extraction operations to obtain database
// resource utilization, performance statistics, and reference information. For more information,
// see About Oracle Cloud Infrastructure Ops Insights (https://docs.oracle.com/iaas/en-us/iaas/operations-insights/doc/operations-insights.html).
//

package opsi

import (
	"fmt"
	"github.com/oracle/oci-go-sdk/v65/common"
	"strings"
)

// CreateOperationsInsightsPrivateEndpointDetails The details used to create a new Operation Insights private endpoint.
type CreateOperationsInsightsPrivateEndpointDetails struct {

	// The display name for the private endpoint. It is changeable.
	DisplayName *string `mandatory:"true" json:"displayName"`

	// The compartment OCID (https://docs.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Private service accessed database.
	CompartmentId *string `mandatory:"true" json:"compartmentId"`

	// The VCN OCID (https://docs.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Private service accessed database.
	VcnId *string `mandatory:"true" json:"vcnId"`

	// The Subnet OCID (https://docs.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Private service accessed database.
	SubnetId *string `mandatory:"true" json:"subnetId"`

	// This flag was previously used to create a private endpoint with scan proxy. Setting this to true will now create a private endpoint with a
	// DNS proxy causing `isProxyEnabled` flag to be true; this is used exclusively for full feature support for dedicated Autonomous Databases.
	IsUsedForRacDbs *bool `mandatory:"true" json:"isUsedForRacDbs"`

	// The description of the private endpoint.
	Description *string `mandatory:"false" json:"description"`

	// The OCID (https://docs.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the network security groups that the private endpoint belongs to.
	NsgIds []string `mandatory:"false" json:"nsgIds"`

	// Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only.
	// Example: `{"bar-key": "value"}`
	FreeformTags map[string]string `mandatory:"false" json:"freeformTags"`

	// Defined tags for this resource. Each key is predefined and scoped to a namespace.
	// Example: `{"foo-namespace": {"bar-key": "value"}}`
	DefinedTags map[string]map[string]interface{} `mandatory:"false" json:"definedTags"`
}

func (m CreateOperationsInsightsPrivateEndpointDetails) String() string {
	return common.PointerString(m)
}

// ValidateEnumValue returns an error when providing an unsupported enum value
// This function is being called during constructing API request process
// Not recommended for calling this function directly
func (m CreateOperationsInsightsPrivateEndpointDetails) ValidateEnumValue() (bool, error) {
	errMessage := []string{}

	if len(errMessage) > 0 {
		return true, fmt.Errorf("%s", strings.Join(errMessage, "\n"))
	}
	return false, nil
}
