/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.http.client;

import io.netty.channel.ChannelOption;
import java.io.IOException;
import java.net.URI;
import java.time.Duration;
import java.util.function.Function;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.context.SmartLifecycle;
import org.springframework.http.HttpMethod;
import org.springframework.http.client.ClientHttpRequest;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.http.client.ReactorNettyClientRequest;
import org.springframework.http.client.ReactorResourceFactory;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import reactor.netty.http.client.HttpClient;
import reactor.netty.resources.ConnectionProvider;

public class ReactorNettyClientRequestFactory
implements ClientHttpRequestFactory,
SmartLifecycle {
    private static final Log logger = LogFactory.getLog(ReactorNettyClientRequestFactory.class);
    private static final Function<HttpClient, HttpClient> defaultInitializer = client -> client.compress(true);
    @Nullable
    private final ReactorResourceFactory resourceFactory;
    @Nullable
    private final Function<HttpClient, HttpClient> mapper;
    @Nullable
    private Integer connectTimeout;
    private Duration readTimeout = Duration.ofSeconds(10L);
    private Duration exchangeTimeout = Duration.ofSeconds(5L);
    @Nullable
    private volatile HttpClient httpClient;
    private final Object lifecycleMonitor = new Object();

    public ReactorNettyClientRequestFactory() {
        this.httpClient = defaultInitializer.apply(HttpClient.create());
        this.resourceFactory = null;
        this.mapper = null;
    }

    public ReactorNettyClientRequestFactory(HttpClient httpClient) {
        Assert.notNull((Object)httpClient, (String)"HttpClient must not be null");
        this.httpClient = httpClient;
        this.resourceFactory = null;
        this.mapper = null;
    }

    public ReactorNettyClientRequestFactory(ReactorResourceFactory resourceFactory, Function<HttpClient, HttpClient> mapper) {
        this.resourceFactory = resourceFactory;
        this.mapper = mapper;
        if (resourceFactory.isRunning()) {
            this.httpClient = this.createHttpClient(resourceFactory, mapper);
        }
    }

    public void setConnectTimeout(int connectTimeout) {
        Assert.isTrue((connectTimeout >= 0 ? 1 : 0) != 0, (String)"Timeout must be a non-negative value");
        this.connectTimeout = connectTimeout;
        HttpClient httpClient = this.httpClient;
        if (httpClient != null) {
            this.httpClient = (HttpClient)httpClient.option(ChannelOption.CONNECT_TIMEOUT_MILLIS, (Object)this.connectTimeout);
        }
    }

    public void setConnectTimeout(Duration connectTimeout) {
        Assert.notNull((Object)connectTimeout, (String)"ConnectTimeout must not be null");
        this.setConnectTimeout((int)connectTimeout.toMillis());
    }

    public void setReadTimeout(long readTimeout) {
        Assert.isTrue((readTimeout > 0L ? 1 : 0) != 0, (String)"Timeout must be a positive value");
        this.readTimeout = Duration.ofMillis(readTimeout);
    }

    public void setReadTimeout(Duration readTimeout) {
        Assert.notNull((Object)readTimeout, (String)"ReadTimeout must not be null");
        Assert.isTrue((!readTimeout.isNegative() ? 1 : 0) != 0, (String)"Timeout must be a non-negative value");
        this.readTimeout = readTimeout;
    }

    public void setExchangeTimeout(long exchangeTimeout) {
        Assert.isTrue((exchangeTimeout > 0L ? 1 : 0) != 0, (String)"Timeout must be a positive value");
        this.exchangeTimeout = Duration.ofMillis(exchangeTimeout);
    }

    public void setExchangeTimeout(Duration exchangeTimeout) {
        Assert.notNull((Object)exchangeTimeout, (String)"ExchangeTimeout must not be null");
        Assert.isTrue((!exchangeTimeout.isNegative() ? 1 : 0) != 0, (String)"Timeout must be a non-negative value");
        this.exchangeTimeout = exchangeTimeout;
    }

    private HttpClient createHttpClient(ReactorResourceFactory factory, Function<HttpClient, HttpClient> mapper) {
        HttpClient httpClient = defaultInitializer.andThen(mapper).apply(HttpClient.create((ConnectionProvider)factory.getConnectionProvider()));
        httpClient = (HttpClient)httpClient.runOn(factory.getLoopResources());
        if (this.connectTimeout != null) {
            httpClient = (HttpClient)httpClient.option(ChannelOption.CONNECT_TIMEOUT_MILLIS, (Object)this.connectTimeout);
        }
        return httpClient;
    }

    @Override
    public ClientHttpRequest createRequest(URI uri, HttpMethod httpMethod) throws IOException {
        HttpClient httpClient = this.httpClient;
        if (httpClient == null) {
            Assert.state((this.resourceFactory != null && this.mapper != null ? 1 : 0) != 0, (String)"Illegal configuration");
            httpClient = this.createHttpClient(this.resourceFactory, this.mapper);
        }
        return new ReactorNettyClientRequest(httpClient, uri, httpMethod, this.exchangeTimeout, this.readTimeout);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        if (this.resourceFactory != null && this.mapper != null) {
            Object object = this.lifecycleMonitor;
            synchronized (object) {
                if (this.httpClient == null) {
                    this.httpClient = this.createHttpClient(this.resourceFactory, this.mapper);
                }
            }
        } else {
            logger.warn((Object)"Restarting a ReactorNettyClientRequestFactory bean is only supported with externally managed Reactor Netty resources");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        if (this.resourceFactory != null && this.mapper != null) {
            Object object = this.lifecycleMonitor;
            synchronized (object) {
                this.httpClient = null;
            }
        }
    }

    public boolean isRunning() {
        return this.httpClient != null;
    }

    public int getPhase() {
        return 1;
    }
}

