/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.protocol;

import io.netty.channel.Channel;
import java.net.SocketAddress;
import java.util.regex.Pattern;
import org.traccar.BaseProtocolDecoder;
import org.traccar.NetworkMessage;
import org.traccar.Protocol;
import org.traccar.helper.Parser;
import org.traccar.helper.PatternBuilder;
import org.traccar.model.Position;
import org.traccar.session.DeviceSession;

public class Gl100ProtocolDecoder
extends BaseProtocolDecoder {
    private static final Pattern PATTERN = new PatternBuilder().text("+RESP:").expression("GT...,").number("(d{15}),").groupBegin().number("d+,").number("d,").number("d+").or().number("[^,]*").groupEnd(",").expression("([01]),").number("(d+.d),").number("(d+),").number("(-?d+.d),").number("d*,").number("(-?d+.d+),").number("(-?d+.d+),").number("(dddd)(dd)(dd)").number("(dd)(dd)(dd),").any().compile();

    public Gl100ProtocolDecoder(Protocol protocol) {
        super(protocol);
    }

    @Override
    protected Object decode(Channel channel, SocketAddress remoteAddress, Object msg) throws Exception {
        Parser parser;
        String sentence = (String)msg;
        if (sentence.contains("AT+GTHBD=") && channel != null) {
            Object response = "+RESP:GTHBD,GPRS ACTIVE,";
            response = (String)response + sentence.substring(9, sentence.lastIndexOf(44));
            response = (String)response + "\u0000";
            channel.writeAndFlush((Object)new NetworkMessage(response, remoteAddress));
        }
        if (!(parser = new Parser(PATTERN, sentence)).matches()) {
            return null;
        }
        Position position = new Position(this.getProtocolName());
        DeviceSession deviceSession = this.getDeviceSession(channel, remoteAddress, parser.next());
        if (deviceSession == null) {
            return null;
        }
        position.setDeviceId(deviceSession.getDeviceId());
        position.setValid(parser.nextInt(0) == 0);
        position.setSpeed(parser.nextDouble(0.0));
        position.setCourse(parser.nextDouble(0.0));
        position.setAltitude(parser.nextDouble(0.0));
        position.setLongitude(parser.nextDouble(0.0));
        position.setLatitude(parser.nextDouble(0.0));
        position.setTime(parser.nextDateTime());
        return position;
    }
}

