// Copyright (c) HashiCorp, Inc.
// SPDX-License-Identifier: MPL-2.0
//
// Code generated with OpenAPI Generator (https://openapi-generator.tech); DO NOT EDIT.

package schema

// CentrifyConfigureRequest struct for CentrifyConfigureRequest
type CentrifyConfigureRequest struct {
	// OAuth2 App ID
	AppId string `json:"app_id,omitempty"`

	// OAuth2 Client ID
	ClientId string `json:"client_id,omitempty"`

	// OAuth2 Client Secret
	ClientSecret string `json:"client_secret,omitempty"`

	// Use \"token_policies\" instead. If this and \"token_policies\" are both specified, only \"token_policies\" will be used.
	// Deprecated
	Policies []string `json:"policies,omitempty"`

	// OAuth2 App Scope
	Scope string `json:"scope,omitempty"`

	// Service URL (https://<tenant>.my.centrify.com)
	ServiceUrl string `json:"service_url,omitempty"`

	// Comma separated string or JSON list of CIDR blocks. If set, specifies the blocks of IP addresses which are allowed to use the generated token.
	TokenBoundCidrs []string `json:"token_bound_cidrs,omitempty"`

	// If true, the 'default' policy will not automatically be added to generated tokens
	TokenNoDefaultPolicy bool `json:"token_no_default_policy,omitempty"`

	// The maximum number of times a token may be used, a value of zero means unlimited
	TokenNumUses int32 `json:"token_num_uses,omitempty"`

	// Comma-separated list of policies
	TokenPolicies []string `json:"token_policies,omitempty"`

	// The initial ttl of the token to generate
	TokenTtl string `json:"token_ttl,omitempty"`

	// The type of token to generate, service or batch
	TokenType string `json:"token_type,omitempty"`
}
