/*
Copyright The Kubernetes Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by applyconfiguration-gen. DO NOT EDIT.

package v1

// FlockerVolumeSourceApplyConfiguration represents a declarative configuration of the FlockerVolumeSource type for use
// with apply.
//
// Represents a Flocker volume mounted by the Flocker agent.
// One and only one of datasetName and datasetUUID should be set.
// Flocker volumes do not support ownership management or SELinux relabeling.
type FlockerVolumeSourceApplyConfiguration struct {
	// datasetName is Name of the dataset stored as metadata -> name on the dataset for Flocker
	// should be considered as deprecated
	DatasetName *string `json:"datasetName,omitempty"`
	// datasetUUID is the UUID of the dataset. This is unique identifier of a Flocker dataset
	DatasetUUID *string `json:"datasetUUID,omitempty"`
}

// FlockerVolumeSourceApplyConfiguration constructs a declarative configuration of the FlockerVolumeSource type for use with
// apply.
func FlockerVolumeSource() *FlockerVolumeSourceApplyConfiguration {
	return &FlockerVolumeSourceApplyConfiguration{}
}

// WithDatasetName sets the DatasetName field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the DatasetName field is set to the value of the last call.
func (b *FlockerVolumeSourceApplyConfiguration) WithDatasetName(value string) *FlockerVolumeSourceApplyConfiguration {
	b.DatasetName = &value
	return b
}

// WithDatasetUUID sets the DatasetUUID field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the DatasetUUID field is set to the value of the last call.
func (b *FlockerVolumeSourceApplyConfiguration) WithDatasetUUID(value string) *FlockerVolumeSourceApplyConfiguration {
	b.DatasetUUID = &value
	return b
}
