// Copyright The OpenTelemetry Authors
// SPDX-License-Identifier: Apache-2.0

// Code generated by "internal/cmd/pdatagen/main.go". DO NOT EDIT.
// To regenerate this file run "make genpdata".

package internal

import (
	"strconv"
	"testing"

	"github.com/stretchr/testify/assert"
	"github.com/stretchr/testify/require"
	gootlpprofiles "go.opentelemetry.io/proto/slim/otlp/profiles/v1development"
	"google.golang.org/protobuf/proto"

	"go.opentelemetry.io/collector/featuregate"
	"go.opentelemetry.io/collector/pdata/internal/json"
)

func TestCopyFunction(t *testing.T) {
	for name, src := range genTestEncodingValuesFunction() {
		for _, pooling := range []bool{true, false} {
			t.Run(name+"/Pooling="+strconv.FormatBool(pooling), func(t *testing.T) {
				prevPooling := UseProtoPooling.IsEnabled()
				require.NoError(t, featuregate.GlobalRegistry().Set(UseProtoPooling.ID(), pooling))
				defer func() {
					require.NoError(t, featuregate.GlobalRegistry().Set(UseProtoPooling.ID(), prevPooling))
				}()

				dest := NewFunction()
				CopyFunction(dest, src)
				assert.Equal(t, src, dest)
				CopyFunction(dest, dest)
				assert.Equal(t, src, dest)
			})
		}
	}
}

func TestCopyFunctionSlice(t *testing.T) {
	src := []Function{}
	dest := []Function{}
	// Test CopyTo empty
	dest = CopyFunctionSlice(dest, src)
	assert.Equal(t, []Function{}, dest)

	// Test CopyTo larger slice
	src = GenTestFunctionSlice()
	dest = CopyFunctionSlice(dest, src)
	assert.Equal(t, GenTestFunctionSlice(), dest)

	// Test CopyTo same size slice
	dest = CopyFunctionSlice(dest, src)
	assert.Equal(t, GenTestFunctionSlice(), dest)

	// Test CopyTo smaller size slice
	dest = CopyFunctionSlice(dest, []Function{})
	assert.Len(t, dest, 0)

	// Test CopyTo larger slice with enough capacity
	dest = CopyFunctionSlice(dest, src)
	assert.Equal(t, GenTestFunctionSlice(), dest)
}

func TestCopyFunctionPtrSlice(t *testing.T) {
	src := []*Function{}
	dest := []*Function{}
	// Test CopyTo empty
	dest = CopyFunctionPtrSlice(dest, src)
	assert.Equal(t, []*Function{}, dest)

	// Test CopyTo larger slice
	src = GenTestFunctionPtrSlice()
	dest = CopyFunctionPtrSlice(dest, src)
	assert.Equal(t, GenTestFunctionPtrSlice(), dest)

	// Test CopyTo same size slice
	dest = CopyFunctionPtrSlice(dest, src)
	assert.Equal(t, GenTestFunctionPtrSlice(), dest)

	// Test CopyTo smaller size slice
	dest = CopyFunctionPtrSlice(dest, []*Function{})
	assert.Len(t, dest, 0)

	// Test CopyTo larger slice with enough capacity
	dest = CopyFunctionPtrSlice(dest, src)
	assert.Equal(t, GenTestFunctionPtrSlice(), dest)
}

func TestMarshalAndUnmarshalJSONFunctionUnknown(t *testing.T) {
	iter := json.BorrowIterator([]byte(`{"unknown": "string"}`))
	defer json.ReturnIterator(iter)
	dest := NewFunction()
	dest.UnmarshalJSON(iter)
	require.NoError(t, iter.Error())
	assert.Equal(t, NewFunction(), dest)
}

func TestMarshalAndUnmarshalJSONFunction(t *testing.T) {
	for name, src := range genTestEncodingValuesFunction() {
		for _, pooling := range []bool{true, false} {
			t.Run(name+"/Pooling="+strconv.FormatBool(pooling), func(t *testing.T) {
				prevPooling := UseProtoPooling.IsEnabled()
				require.NoError(t, featuregate.GlobalRegistry().Set(UseProtoPooling.ID(), pooling))
				defer func() {
					require.NoError(t, featuregate.GlobalRegistry().Set(UseProtoPooling.ID(), prevPooling))
				}()

				stream := json.BorrowStream(nil)
				defer json.ReturnStream(stream)
				src.MarshalJSON(stream)
				require.NoError(t, stream.Error())

				iter := json.BorrowIterator(stream.Buffer())
				defer json.ReturnIterator(iter)
				dest := NewFunction()
				dest.UnmarshalJSON(iter)
				require.NoError(t, iter.Error())

				assert.Equal(t, src, dest)
				DeleteFunction(dest, true)
			})
		}
	}
}

func TestMarshalAndUnmarshalProtoFunctionFailing(t *testing.T) {
	for name, buf := range genTestFailingUnmarshalProtoValuesFunction() {
		t.Run(name, func(t *testing.T) {
			dest := NewFunction()
			require.Error(t, dest.UnmarshalProto(buf))
		})
	}
}

func TestMarshalAndUnmarshalProtoFunctionUnknown(t *testing.T) {
	dest := NewFunction()
	// message Test { required int64 field = 1313; } encoding { "field": "1234" }
	require.NoError(t, dest.UnmarshalProto([]byte{0x88, 0x52, 0xD2, 0x09}))
	assert.Equal(t, NewFunction(), dest)
}

func TestMarshalAndUnmarshalProtoFunction(t *testing.T) {
	for name, src := range genTestEncodingValuesFunction() {
		for _, pooling := range []bool{true, false} {
			t.Run(name+"/Pooling="+strconv.FormatBool(pooling), func(t *testing.T) {
				prevPooling := UseProtoPooling.IsEnabled()
				require.NoError(t, featuregate.GlobalRegistry().Set(UseProtoPooling.ID(), pooling))
				defer func() {
					require.NoError(t, featuregate.GlobalRegistry().Set(UseProtoPooling.ID(), prevPooling))
				}()

				buf := make([]byte, src.SizeProto())
				gotSize := src.MarshalProto(buf)
				assert.Equal(t, len(buf), gotSize)

				dest := NewFunction()
				require.NoError(t, dest.UnmarshalProto(buf))

				assert.Equal(t, src, dest)
				DeleteFunction(dest, true)
			})
		}
	}
}

func TestMarshalAndUnmarshalProtoViaProtobufFunction(t *testing.T) {
	for name, src := range genTestEncodingValuesFunction() {
		t.Run(name, func(t *testing.T) {
			buf := make([]byte, src.SizeProto())
			gotSize := src.MarshalProto(buf)
			assert.Equal(t, len(buf), gotSize)

			goDest := &gootlpprofiles.Function{}
			require.NoError(t, proto.Unmarshal(buf, goDest))

			goBuf, err := proto.Marshal(goDest)
			require.NoError(t, err)

			dest := NewFunction()
			require.NoError(t, dest.UnmarshalProto(goBuf))
			assert.Equal(t, src, dest)
		})
	}
}

func genTestFailingUnmarshalProtoValuesFunction() map[string][]byte {
	return map[string][]byte{
		"invalid_field":                      {0x02},
		"NameStrindex/wrong_wire_type":       {0xc},
		"NameStrindex/missing_value":         {0x8},
		"SystemNameStrindex/wrong_wire_type": {0x14},
		"SystemNameStrindex/missing_value":   {0x10},
		"FilenameStrindex/wrong_wire_type":   {0x1c},
		"FilenameStrindex/missing_value":     {0x18},
		"StartLine/wrong_wire_type":          {0x24},
		"StartLine/missing_value":            {0x20},
	}
}

func genTestEncodingValuesFunction() map[string]*Function {
	return map[string]*Function{
		"empty":                   NewFunction(),
		"NameStrindex/test":       {NameStrindex: int32(13)},
		"SystemNameStrindex/test": {SystemNameStrindex: int32(13)},
		"FilenameStrindex/test":   {FilenameStrindex: int32(13)},
		"StartLine/test":          {StartLine: int64(13)},
	}
}
