// Copyright 2018 Google Inc.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//
////////////////////////////////////////////////////////////////////////////////

// Definitions for RSA SSA (Signature Schemes with Appendix) using PSS
// (Probabilistic Signature Scheme ) encoding
// (https://tools.ietf.org/html/rfc8017#section-8.1).

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.36.6
// 	protoc        v3.21.12
// source: rsa_ssa_pss.proto

package rsa_ssa_pss_go_proto

import (
	common_go_proto "github.com/tink-crypto/tink-go/v2/proto/common_go_proto"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	reflect "reflect"
	sync "sync"
	unsafe "unsafe"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

type RsaSsaPssParams struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// Hash function used in computing hash of the signing message
	// (see https://tools.ietf.org/html/rfc8017#section-9.1.1).
	// Required.
	SigHash common_go_proto.HashType `protobuf:"varint,1,opt,name=sig_hash,json=sigHash,proto3,enum=google.crypto.tink.HashType" json:"sig_hash,omitempty"`
	// Hash function used in MGF1 (a mask generation function based on a
	// hash function) (see https://tools.ietf.org/html/rfc8017#appendix-B.2.1).
	// Required.
	Mgf1Hash common_go_proto.HashType `protobuf:"varint,2,opt,name=mgf1_hash,json=mgf1Hash,proto3,enum=google.crypto.tink.HashType" json:"mgf1_hash,omitempty"`
	// Salt length (see https://tools.ietf.org/html/rfc8017#section-9.1.1)
	// Required.
	SaltLength    int32 `protobuf:"varint,3,opt,name=salt_length,json=saltLength,proto3" json:"salt_length,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *RsaSsaPssParams) Reset() {
	*x = RsaSsaPssParams{}
	mi := &file_rsa_ssa_pss_proto_msgTypes[0]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *RsaSsaPssParams) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RsaSsaPssParams) ProtoMessage() {}

func (x *RsaSsaPssParams) ProtoReflect() protoreflect.Message {
	mi := &file_rsa_ssa_pss_proto_msgTypes[0]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RsaSsaPssParams.ProtoReflect.Descriptor instead.
func (*RsaSsaPssParams) Descriptor() ([]byte, []int) {
	return file_rsa_ssa_pss_proto_rawDescGZIP(), []int{0}
}

func (x *RsaSsaPssParams) GetSigHash() common_go_proto.HashType {
	if x != nil {
		return x.SigHash
	}
	return common_go_proto.HashType(0)
}

func (x *RsaSsaPssParams) GetMgf1Hash() common_go_proto.HashType {
	if x != nil {
		return x.Mgf1Hash
	}
	return common_go_proto.HashType(0)
}

func (x *RsaSsaPssParams) GetSaltLength() int32 {
	if x != nil {
		return x.SaltLength
	}
	return 0
}

// key_type: type.googleapis.com/google.crypto.tink.RsaSsaPssPublicKey
type RsaSsaPssPublicKey struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// Required.
	Version uint32 `protobuf:"varint,1,opt,name=version,proto3" json:"version,omitempty"`
	// Required.
	Params *RsaSsaPssParams `protobuf:"bytes,2,opt,name=params,proto3" json:"params,omitempty"`
	// Modulus.
	// Unsigned big integer in bigendian representation.
	N []byte `protobuf:"bytes,3,opt,name=n,proto3" json:"n,omitempty"`
	// Public exponent.
	// Unsigned big integer in bigendian representation.
	E             []byte `protobuf:"bytes,4,opt,name=e,proto3" json:"e,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *RsaSsaPssPublicKey) Reset() {
	*x = RsaSsaPssPublicKey{}
	mi := &file_rsa_ssa_pss_proto_msgTypes[1]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *RsaSsaPssPublicKey) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RsaSsaPssPublicKey) ProtoMessage() {}

func (x *RsaSsaPssPublicKey) ProtoReflect() protoreflect.Message {
	mi := &file_rsa_ssa_pss_proto_msgTypes[1]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RsaSsaPssPublicKey.ProtoReflect.Descriptor instead.
func (*RsaSsaPssPublicKey) Descriptor() ([]byte, []int) {
	return file_rsa_ssa_pss_proto_rawDescGZIP(), []int{1}
}

func (x *RsaSsaPssPublicKey) GetVersion() uint32 {
	if x != nil {
		return x.Version
	}
	return 0
}

func (x *RsaSsaPssPublicKey) GetParams() *RsaSsaPssParams {
	if x != nil {
		return x.Params
	}
	return nil
}

func (x *RsaSsaPssPublicKey) GetN() []byte {
	if x != nil {
		return x.N
	}
	return nil
}

func (x *RsaSsaPssPublicKey) GetE() []byte {
	if x != nil {
		return x.E
	}
	return nil
}

// key_type: type.googleapis.com/google.crypto.tink.RsaSsaPssPrivateKey
type RsaSsaPssPrivateKey struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// Required.
	Version uint32 `protobuf:"varint,1,opt,name=version,proto3" json:"version,omitempty"`
	// Required.
	PublicKey *RsaSsaPssPublicKey `protobuf:"bytes,2,opt,name=public_key,json=publicKey,proto3" json:"public_key,omitempty"`
	// Private exponent.
	// Unsigned big integer in bigendian representation.
	// Required.
	D []byte `protobuf:"bytes,3,opt,name=d,proto3" json:"d,omitempty"`
	// The following parameters are used to optimize RSA signature computation.
	// The prime factor p of n.
	// Unsigned big integer in bigendian representation.
	// Required.
	P []byte `protobuf:"bytes,4,opt,name=p,proto3" json:"p,omitempty"`
	// The prime factor q of n.
	// Unsigned big integer in bigendian representation.
	// Required.
	Q []byte `protobuf:"bytes,5,opt,name=q,proto3" json:"q,omitempty"`
	// d mod (p - 1).
	// Unsigned big integer in bigendian representation.
	// Required.
	Dp []byte `protobuf:"bytes,6,opt,name=dp,proto3" json:"dp,omitempty"`
	// d mod (q - 1).
	// Unsigned big integer in bigendian representation.
	// Required.
	Dq []byte `protobuf:"bytes,7,opt,name=dq,proto3" json:"dq,omitempty"`
	// Chinese Remainder Theorem coefficient q^(-1) mod p.
	// Unsigned big integer in bigendian representation.
	// Required.
	Crt           []byte `protobuf:"bytes,8,opt,name=crt,proto3" json:"crt,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *RsaSsaPssPrivateKey) Reset() {
	*x = RsaSsaPssPrivateKey{}
	mi := &file_rsa_ssa_pss_proto_msgTypes[2]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *RsaSsaPssPrivateKey) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RsaSsaPssPrivateKey) ProtoMessage() {}

func (x *RsaSsaPssPrivateKey) ProtoReflect() protoreflect.Message {
	mi := &file_rsa_ssa_pss_proto_msgTypes[2]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RsaSsaPssPrivateKey.ProtoReflect.Descriptor instead.
func (*RsaSsaPssPrivateKey) Descriptor() ([]byte, []int) {
	return file_rsa_ssa_pss_proto_rawDescGZIP(), []int{2}
}

func (x *RsaSsaPssPrivateKey) GetVersion() uint32 {
	if x != nil {
		return x.Version
	}
	return 0
}

func (x *RsaSsaPssPrivateKey) GetPublicKey() *RsaSsaPssPublicKey {
	if x != nil {
		return x.PublicKey
	}
	return nil
}

func (x *RsaSsaPssPrivateKey) GetD() []byte {
	if x != nil {
		return x.D
	}
	return nil
}

func (x *RsaSsaPssPrivateKey) GetP() []byte {
	if x != nil {
		return x.P
	}
	return nil
}

func (x *RsaSsaPssPrivateKey) GetQ() []byte {
	if x != nil {
		return x.Q
	}
	return nil
}

func (x *RsaSsaPssPrivateKey) GetDp() []byte {
	if x != nil {
		return x.Dp
	}
	return nil
}

func (x *RsaSsaPssPrivateKey) GetDq() []byte {
	if x != nil {
		return x.Dq
	}
	return nil
}

func (x *RsaSsaPssPrivateKey) GetCrt() []byte {
	if x != nil {
		return x.Crt
	}
	return nil
}

type RsaSsaPssKeyFormat struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// Required.
	Params *RsaSsaPssParams `protobuf:"bytes,1,opt,name=params,proto3" json:"params,omitempty"`
	// Required.
	ModulusSizeInBits uint32 `protobuf:"varint,2,opt,name=modulus_size_in_bits,json=modulusSizeInBits,proto3" json:"modulus_size_in_bits,omitempty"`
	// Required.
	PublicExponent []byte `protobuf:"bytes,3,opt,name=public_exponent,json=publicExponent,proto3" json:"public_exponent,omitempty"`
	unknownFields  protoimpl.UnknownFields
	sizeCache      protoimpl.SizeCache
}

func (x *RsaSsaPssKeyFormat) Reset() {
	*x = RsaSsaPssKeyFormat{}
	mi := &file_rsa_ssa_pss_proto_msgTypes[3]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *RsaSsaPssKeyFormat) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RsaSsaPssKeyFormat) ProtoMessage() {}

func (x *RsaSsaPssKeyFormat) ProtoReflect() protoreflect.Message {
	mi := &file_rsa_ssa_pss_proto_msgTypes[3]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RsaSsaPssKeyFormat.ProtoReflect.Descriptor instead.
func (*RsaSsaPssKeyFormat) Descriptor() ([]byte, []int) {
	return file_rsa_ssa_pss_proto_rawDescGZIP(), []int{3}
}

func (x *RsaSsaPssKeyFormat) GetParams() *RsaSsaPssParams {
	if x != nil {
		return x.Params
	}
	return nil
}

func (x *RsaSsaPssKeyFormat) GetModulusSizeInBits() uint32 {
	if x != nil {
		return x.ModulusSizeInBits
	}
	return 0
}

func (x *RsaSsaPssKeyFormat) GetPublicExponent() []byte {
	if x != nil {
		return x.PublicExponent
	}
	return nil
}

var File_rsa_ssa_pss_proto protoreflect.FileDescriptor

const file_rsa_ssa_pss_proto_rawDesc = "" +
	"\n" +
	"\x11rsa_ssa_pss.proto\x12\x12google.crypto.tink\x1a\x12proto/common.proto\"\xa6\x01\n" +
	"\x0fRsaSsaPssParams\x127\n" +
	"\bsig_hash\x18\x01 \x01(\x0e2\x1c.google.crypto.tink.HashTypeR\asigHash\x129\n" +
	"\tmgf1_hash\x18\x02 \x01(\x0e2\x1c.google.crypto.tink.HashTypeR\bmgf1Hash\x12\x1f\n" +
	"\vsalt_length\x18\x03 \x01(\x05R\n" +
	"saltLength\"\x87\x01\n" +
	"\x12RsaSsaPssPublicKey\x12\x18\n" +
	"\aversion\x18\x01 \x01(\rR\aversion\x12;\n" +
	"\x06params\x18\x02 \x01(\v2#.google.crypto.tink.RsaSsaPssParamsR\x06params\x12\f\n" +
	"\x01n\x18\x03 \x01(\fR\x01n\x12\f\n" +
	"\x01e\x18\x04 \x01(\fR\x01e\"\xd2\x01\n" +
	"\x13RsaSsaPssPrivateKey\x12\x18\n" +
	"\aversion\x18\x01 \x01(\rR\aversion\x12E\n" +
	"\n" +
	"public_key\x18\x02 \x01(\v2&.google.crypto.tink.RsaSsaPssPublicKeyR\tpublicKey\x12\f\n" +
	"\x01d\x18\x03 \x01(\fR\x01d\x12\f\n" +
	"\x01p\x18\x04 \x01(\fR\x01p\x12\f\n" +
	"\x01q\x18\x05 \x01(\fR\x01q\x12\x0e\n" +
	"\x02dp\x18\x06 \x01(\fR\x02dp\x12\x0e\n" +
	"\x02dq\x18\a \x01(\fR\x02dq\x12\x10\n" +
	"\x03crt\x18\b \x01(\fR\x03crt\"\xab\x01\n" +
	"\x12RsaSsaPssKeyFormat\x12;\n" +
	"\x06params\x18\x01 \x01(\v2#.google.crypto.tink.RsaSsaPssParamsR\x06params\x12/\n" +
	"\x14modulus_size_in_bits\x18\x02 \x01(\rR\x11modulusSizeInBits\x12'\n" +
	"\x0fpublic_exponent\x18\x03 \x01(\fR\x0epublicExponentB^\n" +
	"\x1ccom.google.crypto.tink.protoP\x01Z<github.com/tink-crypto/tink-go/v2/proto/rsa_ssa_pss_go_protob\x06proto3"

var (
	file_rsa_ssa_pss_proto_rawDescOnce sync.Once
	file_rsa_ssa_pss_proto_rawDescData []byte
)

func file_rsa_ssa_pss_proto_rawDescGZIP() []byte {
	file_rsa_ssa_pss_proto_rawDescOnce.Do(func() {
		file_rsa_ssa_pss_proto_rawDescData = protoimpl.X.CompressGZIP(unsafe.Slice(unsafe.StringData(file_rsa_ssa_pss_proto_rawDesc), len(file_rsa_ssa_pss_proto_rawDesc)))
	})
	return file_rsa_ssa_pss_proto_rawDescData
}

var file_rsa_ssa_pss_proto_msgTypes = make([]protoimpl.MessageInfo, 4)
var file_rsa_ssa_pss_proto_goTypes = []any{
	(*RsaSsaPssParams)(nil),       // 0: google.crypto.tink.RsaSsaPssParams
	(*RsaSsaPssPublicKey)(nil),    // 1: google.crypto.tink.RsaSsaPssPublicKey
	(*RsaSsaPssPrivateKey)(nil),   // 2: google.crypto.tink.RsaSsaPssPrivateKey
	(*RsaSsaPssKeyFormat)(nil),    // 3: google.crypto.tink.RsaSsaPssKeyFormat
	(common_go_proto.HashType)(0), // 4: google.crypto.tink.HashType
}
var file_rsa_ssa_pss_proto_depIdxs = []int32{
	4, // 0: google.crypto.tink.RsaSsaPssParams.sig_hash:type_name -> google.crypto.tink.HashType
	4, // 1: google.crypto.tink.RsaSsaPssParams.mgf1_hash:type_name -> google.crypto.tink.HashType
	0, // 2: google.crypto.tink.RsaSsaPssPublicKey.params:type_name -> google.crypto.tink.RsaSsaPssParams
	1, // 3: google.crypto.tink.RsaSsaPssPrivateKey.public_key:type_name -> google.crypto.tink.RsaSsaPssPublicKey
	0, // 4: google.crypto.tink.RsaSsaPssKeyFormat.params:type_name -> google.crypto.tink.RsaSsaPssParams
	5, // [5:5] is the sub-list for method output_type
	5, // [5:5] is the sub-list for method input_type
	5, // [5:5] is the sub-list for extension type_name
	5, // [5:5] is the sub-list for extension extendee
	0, // [0:5] is the sub-list for field type_name
}

func init() { file_rsa_ssa_pss_proto_init() }
func file_rsa_ssa_pss_proto_init() {
	if File_rsa_ssa_pss_proto != nil {
		return
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: unsafe.Slice(unsafe.StringData(file_rsa_ssa_pss_proto_rawDesc), len(file_rsa_ssa_pss_proto_rawDesc)),
			NumEnums:      0,
			NumMessages:   4,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_rsa_ssa_pss_proto_goTypes,
		DependencyIndexes: file_rsa_ssa_pss_proto_depIdxs,
		MessageInfos:      file_rsa_ssa_pss_proto_msgTypes,
	}.Build()
	File_rsa_ssa_pss_proto = out.File
	file_rsa_ssa_pss_proto_goTypes = nil
	file_rsa_ssa_pss_proto_depIdxs = nil
}
