# Conversations

Response Types:

- <a href="https://pkg.go.dev/github.com/openai/openai-go/v3/conversations">conversations</a>.<a href="https://pkg.go.dev/github.com/openai/openai-go/v3/conversations#ComputerScreenshotContent">ComputerScreenshotContent</a>
- <a href="https://pkg.go.dev/github.com/openai/openai-go/v3/conversations">conversations</a>.<a href="https://pkg.go.dev/github.com/openai/openai-go/v3/conversations#Conversation">Conversation</a>
- <a href="https://pkg.go.dev/github.com/openai/openai-go/v3/conversations">conversations</a>.<a href="https://pkg.go.dev/github.com/openai/openai-go/v3/conversations#ConversationDeletedResource">ConversationDeletedResource</a>
- <a href="https://pkg.go.dev/github.com/openai/openai-go/v3/conversations">conversations</a>.<a href="https://pkg.go.dev/github.com/openai/openai-go/v3/conversations#Message">Message</a>
- <a href="https://pkg.go.dev/github.com/openai/openai-go/v3/conversations">conversations</a>.<a href="https://pkg.go.dev/github.com/openai/openai-go/v3/conversations#SummaryTextContent">SummaryTextContent</a>
- <a href="https://pkg.go.dev/github.com/openai/openai-go/v3/conversations">conversations</a>.<a href="https://pkg.go.dev/github.com/openai/openai-go/v3/conversations#TextContent">TextContent</a>

Methods:

- <code title="post /conversations">client.Conversations.<a href="https://pkg.go.dev/github.com/openai/openai-go/v3/conversations#ConversationService.New">New</a>(ctx <a href="https://pkg.go.dev/context">context</a>.<a href="https://pkg.go.dev/context#Context">Context</a>, body <a href="https://pkg.go.dev/github.com/openai/openai-go/v3/conversations">conversations</a>.<a href="https://pkg.go.dev/github.com/openai/openai-go/v3/conversations#ConversationNewParams">ConversationNewParams</a>) (\*<a href="https://pkg.go.dev/github.com/openai/openai-go/v3/conversations">conversations</a>.<a href="https://pkg.go.dev/github.com/openai/openai-go/v3/conversations#Conversation">Conversation</a>, <a href="https://pkg.go.dev/builtin#error">error</a>)</code>
- <code title="get /conversations/{conversation_id}">client.Conversations.<a href="https://pkg.go.dev/github.com/openai/openai-go/v3/conversations#ConversationService.Get">Get</a>(ctx <a href="https://pkg.go.dev/context">context</a>.<a href="https://pkg.go.dev/context#Context">Context</a>, conversationID <a href="https://pkg.go.dev/builtin#string">string</a>) (\*<a href="https://pkg.go.dev/github.com/openai/openai-go/v3/conversations">conversations</a>.<a href="https://pkg.go.dev/github.com/openai/openai-go/v3/conversations#Conversation">Conversation</a>, <a href="https://pkg.go.dev/builtin#error">error</a>)</code>
- <code title="post /conversations/{conversation_id}">client.Conversations.<a href="https://pkg.go.dev/github.com/openai/openai-go/v3/conversations#ConversationService.Update">Update</a>(ctx <a href="https://pkg.go.dev/context">context</a>.<a href="https://pkg.go.dev/context#Context">Context</a>, conversationID <a href="https://pkg.go.dev/builtin#string">string</a>, body <a href="https://pkg.go.dev/github.com/openai/openai-go/v3/conversations">conversations</a>.<a href="https://pkg.go.dev/github.com/openai/openai-go/v3/conversations#ConversationUpdateParams">ConversationUpdateParams</a>) (\*<a href="https://pkg.go.dev/github.com/openai/openai-go/v3/conversations">conversations</a>.<a href="https://pkg.go.dev/github.com/openai/openai-go/v3/conversations#Conversation">Conversation</a>, <a href="https://pkg.go.dev/builtin#error">error</a>)</code>
- <code title="delete /conversations/{conversation_id}">client.Conversations.<a href="https://pkg.go.dev/github.com/openai/openai-go/v3/conversations#ConversationService.Delete">Delete</a>(ctx <a href="https://pkg.go.dev/context">context</a>.<a href="https://pkg.go.dev/context#Context">Context</a>, conversationID <a href="https://pkg.go.dev/builtin#string">string</a>) (\*<a href="https://pkg.go.dev/github.com/openai/openai-go/v3/conversations">conversations</a>.<a href="https://pkg.go.dev/github.com/openai/openai-go/v3/conversations#ConversationDeletedResource">ConversationDeletedResource</a>, <a href="https://pkg.go.dev/builtin#error">error</a>)</code>

## Items

Response Types:

- <a href="https://pkg.go.dev/github.com/openai/openai-go/v3/conversations">conversations</a>.<a href="https://pkg.go.dev/github.com/openai/openai-go/v3/conversations#ConversationItemUnion">ConversationItemUnion</a>
- <a href="https://pkg.go.dev/github.com/openai/openai-go/v3/conversations">conversations</a>.<a href="https://pkg.go.dev/github.com/openai/openai-go/v3/conversations#ConversationItemList">ConversationItemList</a>

Methods:

- <code title="post /conversations/{conversation_id}/items">client.Conversations.Items.<a href="https://pkg.go.dev/github.com/openai/openai-go/v3/conversations#ItemService.New">New</a>(ctx <a href="https://pkg.go.dev/context">context</a>.<a href="https://pkg.go.dev/context#Context">Context</a>, conversationID <a href="https://pkg.go.dev/builtin#string">string</a>, params <a href="https://pkg.go.dev/github.com/openai/openai-go/v3/conversations">conversations</a>.<a href="https://pkg.go.dev/github.com/openai/openai-go/v3/conversations#ItemNewParams">ItemNewParams</a>) (\*<a href="https://pkg.go.dev/github.com/openai/openai-go/v3/conversations">conversations</a>.<a href="https://pkg.go.dev/github.com/openai/openai-go/v3/conversations#ConversationItemList">ConversationItemList</a>, <a href="https://pkg.go.dev/builtin#error">error</a>)</code>
- <code title="get /conversations/{conversation_id}/items/{item_id}">client.Conversations.Items.<a href="https://pkg.go.dev/github.com/openai/openai-go/v3/conversations#ItemService.Get">Get</a>(ctx <a href="https://pkg.go.dev/context">context</a>.<a href="https://pkg.go.dev/context#Context">Context</a>, conversationID <a href="https://pkg.go.dev/builtin#string">string</a>, itemID <a href="https://pkg.go.dev/builtin#string">string</a>, query <a href="https://pkg.go.dev/github.com/openai/openai-go/v3/conversations">conversations</a>.<a href="https://pkg.go.dev/github.com/openai/openai-go/v3/conversations#ItemGetParams">ItemGetParams</a>) (\*<a href="https://pkg.go.dev/github.com/openai/openai-go/v3/conversations">conversations</a>.<a href="https://pkg.go.dev/github.com/openai/openai-go/v3/conversations#ConversationItemUnion">ConversationItemUnion</a>, <a href="https://pkg.go.dev/builtin#error">error</a>)</code>
- <code title="get /conversations/{conversation_id}/items">client.Conversations.Items.<a href="https://pkg.go.dev/github.com/openai/openai-go/v3/conversations#ItemService.List">List</a>(ctx <a href="https://pkg.go.dev/context">context</a>.<a href="https://pkg.go.dev/context#Context">Context</a>, conversationID <a href="https://pkg.go.dev/builtin#string">string</a>, query <a href="https://pkg.go.dev/github.com/openai/openai-go/v3/conversations">conversations</a>.<a href="https://pkg.go.dev/github.com/openai/openai-go/v3/conversations#ItemListParams">ItemListParams</a>) (\*<a href="https://pkg.go.dev/github.com/openai/openai-go/v3/packages/pagination">pagination</a>.<a href="https://pkg.go.dev/github.com/openai/openai-go/v3/packages/pagination#ConversationCursorPage">ConversationCursorPage</a>[<a href="https://pkg.go.dev/github.com/openai/openai-go/v3/conversations">conversations</a>.<a href="https://pkg.go.dev/github.com/openai/openai-go/v3/conversations#ConversationItemUnion">ConversationItemUnion</a>], <a href="https://pkg.go.dev/builtin#error">error</a>)</code>
- <code title="delete /conversations/{conversation_id}/items/{item_id}">client.Conversations.Items.<a href="https://pkg.go.dev/github.com/openai/openai-go/v3/conversations#ItemService.Delete">Delete</a>(ctx <a href="https://pkg.go.dev/context">context</a>.<a href="https://pkg.go.dev/context#Context">Context</a>, conversationID <a href="https://pkg.go.dev/builtin#string">string</a>, itemID <a href="https://pkg.go.dev/builtin#string">string</a>) (\*<a href="https://pkg.go.dev/github.com/openai/openai-go/v3/conversations">conversations</a>.<a href="https://pkg.go.dev/github.com/openai/openai-go/v3/conversations#Conversation">Conversation</a>, <a href="https://pkg.go.dev/builtin#error">error</a>)</code>
