package model

import (
	"github.com/huaweicloud/huaweicloud-sdk-go-v3/core/utils"

	"strings"
)

// ListPublications4SubscriptionRequestBody 可选的rds实例列表及其发布。
type ListPublications4SubscriptionRequestBody struct {

	// 发布实例id。若不为空，优先查该实例下的发布。
	PublicationInstanceId *string `json:"publication_instance_id,omitempty"`

	// 发布实例名称（模糊匹配）。
	PublicationInstanceName *string `json:"publication_instance_name,omitempty"`

	// 发布名称（模糊匹配）。
	PublicationName *string `json:"publication_name,omitempty"`

	// 索引位置，偏移量。从第一条数据偏移offset条数据后开始查询，默认为0（偏移0条数据，表示从第一条数据开始查询），必须为数字，不能为负数。
	Offset *int32 `json:"offset,omitempty"`

	// 查询记录数。默认为10，不能为负数，最小值为1，最大值为1000。
	Limit *int32 `json:"limit,omitempty"`
}

func (o ListPublications4SubscriptionRequestBody) String() string {
	data, err := utils.Marshal(o)
	if err != nil {
		return "ListPublications4SubscriptionRequestBody struct{}"
	}

	return strings.Join([]string{"ListPublications4SubscriptionRequestBody", string(data)}, " ")
}
