package model

import (
	"github.com/huaweicloud/huaweicloud-sdk-go-v3/core/utils"

	"strings"
)

// VulnerabilityHostNumberInfo 影响主机数量
type VulnerabilityHostNumberInfo struct {

	// **参数解释**: 重要主机数量 **取值范围**: 取值0-10000
	Important *int32 `json:"important,omitempty"`

	// **参数解释**: 一般主机数量 **取值范围**: 取值0-10000
	Common *int32 `json:"common,omitempty"`

	// **参数解释**: 测试主机数量 **取值范围**: 取值0-10000
	Test *int32 `json:"test,omitempty"`
}

func (o VulnerabilityHostNumberInfo) String() string {
	data, err := utils.Marshal(o)
	if err != nil {
		return "VulnerabilityHostNumberInfo struct{}"
	}

	return strings.Join([]string{"VulnerabilityHostNumberInfo", string(data)}, " ")
}
