/*
 * Decompiled with CFR 0.152.
 */
package org.rzo.yajsw.ws;

import java.awt.TextArea;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import org.rzo.yajsw.ws.WSForm;

public class WebStartBooter {
    static WSForm wsform = new WSForm();
    static String source;
    static String destination;
    static String action;
    static boolean start;
    static boolean tray;
    static String configuration;
    static String _wrapperJar;
    static String TITLE;
    static boolean _useProxies;

    static {
        destination = "";
        action = "-c";
        start = false;
        tray = false;
        configuration = "";
        TITLE = "YAJSW-WS Rel 0.2";
        _useProxies = false;
    }

    private static void showFile(String file) {
        TextArea textarea = new TextArea("", 24, 80);
        textarea.setEditable(false);
        final JFrame frame = new JFrame();
        frame.setSize(530, 450);
        frame.setLocation(100, 100);
        frame.getContentPane().add(textarea);
        frame.setVisible(true);
        frame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                frame.dispose();
            }
        });
        textarea.setText(WebStartBooter.getFile(file));
    }

    private static boolean downloadFile(String source, String destination) throws IOException {
        System.out.println("checking " + source);
        URL url = new URL(source);
        URLConnection con = url.openConnection();
        File outFile = new File(destination);
        if (outFile.exists() && outFile.lastModified() < con.getLastModified()) {
            System.out.println("file changed -> overwrite " + destination);
        } else if (outFile.exists()) {
            System.out.println("file unchanged -> continue");
            return false;
        }
        if (!outFile.getParentFile().exists()) {
            outFile.getParentFile().mkdirs();
        }
        System.out.println("loading " + source + " -> " + destination);
        BufferedInputStream in = new BufferedInputStream(url.openStream());
        BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(outFile), 1024);
        WebStartBooter.copyStream(in, out);
        out.close();
        in.close();
        return true;
    }

    private static void copyStream(BufferedInputStream in, BufferedOutputStream out) throws IOException {
        long startTime;
        byte[] data = new byte[1024];
        int count = 0;
        long total = 0L;
        long duration = startTime = System.currentTimeMillis();
        while ((count = in.read(data, 0, 1024)) != -1) {
            out.write(data, 0, count);
            total += (long)count;
            duration = (System.currentTimeMillis() - startTime) / 1000L;
            if (duration <= 0L) continue;
            WebStartBooter.showSpeed(total / duration);
        }
    }

    private static void loadWrapperJar(String base, String destination) throws IOException {
        WebStartBooter.downloadFile(String.valueOf(base) + "/wrapper.jar", String.valueOf(destination) + "/wrapper.jar");
        _wrapperJar = String.valueOf(destination) + "/wrapper.jar";
    }

    public static void main(String[] args) throws Exception {
        source = args[0];
        destination = args[1];
        action = args[2];
        configuration = args[3];
        if (!args[args.length - 1].contains("nogui")) {
            // empty if block
        }
        WebStartBooter.doGui(args);
        File destF = new File(destination);
        if (!destF.exists()) {
            System.out.println("creating installation folder");
            destF.mkdirs();
        }
        try {
            WebStartBooter.downloadWrapper();
            WebStartBooter.showStep("Loading & Executing application ...");
            WebStartBooter.doActions(destination, action, configuration);
        }
        catch (Exception ex) {
            WebStartBooter.showStep("Error -> aborted");
            System.out.println("Error : " + ex.getMessage());
        }
    }

    private static void downloadWrapper() throws IOException {
        if (source.endsWith(".zip")) {
            URL sourceURL = new URL(source);
            String sourceName = new File(sourceURL.getPath()).getName();
            WebStartBooter.showStep("Downloading " + sourceName + " ...");
            if (WebStartBooter.downloadFile(source, String.valueOf(destination) + "/" + sourceName)) {
                WebStartBooter.showStep("Unzip " + sourceName + " ...");
                WebStartBooter.unzipWrapper(destination, String.valueOf(destination) + "/" + sourceName);
            }
        } else {
            WebStartBooter.showStep("Loading wrapper.jar ...");
            WebStartBooter.loadWrapperJar(source, destination);
            WebStartBooter.showStep("Loading wrapper libs ...");
            WebStartBooter.loadManifestFiles(source, destination);
            WebStartBooter.showStep("Loading wrapper resources ...");
            WebStartBooter.loadResources(source, destination);
        }
        WebStartBooter.findWrapperJar(new File(destination));
    }

    private static void findWrapperJar(File file) {
        block3: {
            block4: {
                if (_wrapperJar != null) break block3;
                if (!file.isDirectory()) break block4;
                File[] fileArray = file.listFiles();
                int n = fileArray.length;
                int n2 = 0;
                while (n2 < n) {
                    File f = fileArray[n2];
                    WebStartBooter.findWrapperJar(f);
                    ++n2;
                }
                break block3;
            }
            if (!file.getName().equals("wrapper.jar")) break block3;
            try {
                _wrapperJar = file.getCanonicalPath();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private static void unzipWrapper(String destination, String zipFileName) throws IOException, IOException {
        ZipFile zipFile = new ZipFile(zipFileName);
        Enumeration<? extends ZipEntry> entries = zipFile.entries();
        while (entries.hasMoreElements()) {
            ZipEntry entry = entries.nextElement();
            if (entry.isDirectory()) {
                System.err.println("Extracting wrapper folder: " + entry.getName());
                new File(String.valueOf(destination) + "/" + entry.getName()).mkdir();
                continue;
            }
            if (entry.getName().endsWith("wrapper.jar")) {
                _wrapperJar = String.valueOf(destination) + "/" + entry.getName();
            }
            if (entry.getName().endsWith(".java")) continue;
            System.err.println("Extracting wrapper file: " + entry.getName());
            BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(String.valueOf(destination) + "/" + entry.getName()));
            WebStartBooter.copyStream(new BufferedInputStream(zipFile.getInputStream(entry)), out);
            out.close();
        }
        zipFile.close();
    }

    private static void doActions(String destination, String action, String configuration) throws IOException {
        if (!action.startsWith("-")) {
            action = "-" + action;
        }
        WebStartBooter.startAppl(destination, action, configuration);
    }

    private static void showStep(String txt) {
        if (wsform != null) {
            WebStartBooter.wsform._STATE.setText(txt);
        }
    }

    private static void showSpeed(long speed) {
        if (wsform != null) {
            WebStartBooter.wsform._SPEED.setText(String.valueOf(speed / 1024L) + " kB/s");
        }
    }

    private static void doGui(String[] args) throws IOException, Exception {
        WebStartBooter.wsform._APPLICATION.setText(configuration);
        WebStartBooter.wsform._INSTALL_FOLDER.setText(new File(destination).getAbsolutePath());
        if (action.contains("c")) {
            WebStartBooter.wsform._CONSOLE_OPTION.setSelected(true);
        }
        if (action.contains("i")) {
            WebStartBooter.wsform._INSTALL_OPTION.setSelected(true);
        }
        if (action.contains("y")) {
            WebStartBooter.wsform._TRAY_ICON_OPTION.setSelected(true);
        }
        if (action.contains("t")) {
            WebStartBooter.wsform._START_OPTION.setSelected(true);
        }
        PrintStream aPrintStream = new PrintStream(new FilteredStream(new ByteArrayOutputStream()));
        System.setOut(aPrintStream);
        System.setErr(aPrintStream);
        final ReentrantLock lock = new ReentrantLock();
        final Condition cont = lock.newCondition();
        WebStartBooter.wsform._GO_BUTTON.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                lock.lock();
                cont.signal();
                lock.unlock();
            }
        });
        WebStartBooter.wsform._SHOW_CONF_BUTTON.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                WebStartBooter.showFile(configuration);
            }
        });
        WebStartBooter.wsform._SELECT_FOLDER_BUTTON.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JFileChooser fc = new JFileChooser();
                fc.setCurrentDirectory(new File("."));
                fc.setFileSelectionMode(1);
                fc.setAcceptAllFileFilterUsed(false);
                int retval = fc.showOpenDialog(wsform);
                if (retval == 0) {
                    File file = fc.getSelectedFile();
                    try {
                        WebStartBooter.wsform._INSTALL_FOLDER.setText(file.getCanonicalPath());
                    }
                    catch (IOException e1) {
                        e1.printStackTrace();
                    }
                }
            }
        });
        WebStartBooter.wsform._CANCEL_BUTTON.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                System.exit(0);
            }
        });
        JFrame frame = new JFrame();
        frame.setTitle(TITLE);
        frame.setSize(530, 450);
        frame.setLocation(100, 100);
        frame.getContentPane().add(wsform);
        frame.setVisible(true);
        frame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                System.exit(0);
            }
        });
        WebStartBooter.showStep("Click button to continue");
        lock.lock();
        cont.await();
        lock.unlock();
        destination = WebStartBooter.wsform._INSTALL_FOLDER.getText();
        if (WebStartBooter.wsform._INSTALL_OPTION.isSelected()) {
            action = "i";
            if (WebStartBooter.wsform._START_OPTION.isSelected()) {
                action = String.valueOf(action) + "t";
            }
        }
        if (WebStartBooter.wsform._CONSOLE_OPTION.isSelected()) {
            action = "c";
        }
        if (WebStartBooter.wsform._TRAY_ICON_OPTION.isSelected()) {
            action = String.valueOf(action) + "y";
        }
    }

    private static void startAppl(String destination, String func, String conf) throws IOException {
        String useProxies = _useProxies ? " -Djava.net.useSystemProxies=true" : "";
        String wrapperJar = _wrapperJar.contains(" ") ? "\"" + _wrapperJar + "\"" : _wrapperJar;
        String cmd = String.valueOf(WebStartBooter.getJava()) + useProxies + " -jar " + wrapperJar + " " + func + " " + conf;
        System.out.println("executing " + cmd);
        final Process p = Runtime.getRuntime().exec(cmd);
        new Thread(new Runnable(){

            @Override
            public void run() {
                BufferedReader in = new BufferedReader(new InputStreamReader(p.getInputStream()));
                try {
                    String line = null;
                    while ((line = in.readLine()) != null) {
                        System.out.println(line);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }).start();
        new Thread(new Runnable(){

            @Override
            public void run() {
                BufferedReader in = new BufferedReader(new InputStreamReader(p.getErrorStream()));
                try {
                    String line = null;
                    while ((line = in.readLine()) != null) {
                        System.err.println(line);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }).start();
    }

    private static String getJava() {
        return "java";
    }

    private static void loadManifestFiles(String base, String destination) throws IOException {
        String manifest = WebStartBooter.getManifest(destination);
        Set<String> jars = WebStartBooter.getJars(manifest);
        for (String jar : jars) {
            if (jar.contains("wrapper.jar")) continue;
            try {
                WebStartBooter.downloadFile(String.valueOf(base) + "/" + jar, String.valueOf(destination) + "/" + jar);
            }
            catch (Exception ex) {
                System.out.println("error loading " + base + "/" + jar);
                System.out.println(ex.getMessage());
            }
        }
    }

    private static void loadResources(String base, String destination) throws IOException {
        String[] stringArray = WebStartBooter.getResources(base);
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String r = stringArray[n2];
            r = r.trim();
            WebStartBooter.downloadFile(String.valueOf(base) + "/" + r, String.valueOf(destination) + "/" + r);
            ++n2;
        }
    }

    private static Set<String> getJars(String manifest) {
        String[] s;
        HashSet<String> result = new HashSet<String>();
        String[] stringArray = s = manifest.split(" ");
        int n = s.length;
        int n2 = 0;
        while (n2 < n) {
            String x = stringArray[n2];
            if (x.endsWith(".jar")) {
                result.add(x.trim());
            }
            ++n2;
        }
        return result;
    }

    private static String[] getResources(String base) {
        return WebStartBooter.getFile(String.valueOf(base) + "/resources.txt").split("\r\n");
    }

    public static String getFile(String file) {
        BufferedInputStream in;
        URL url;
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            url = new URL(file);
        }
        catch (MalformedURLException e1) {
            System.out.println(e1.getMessage());
            return "";
        }
        try {
            URLConnection con = url.openConnection();
        }
        catch (IOException e1) {
            System.out.println(e1.getMessage());
            return "";
        }
        try {
            in = new BufferedInputStream(url.openStream());
        }
        catch (IOException e1) {
            System.out.println(e1.getMessage());
            return "";
        }
        byte[] data = new byte[1024];
        int count = 0;
        try {
            while ((count = in.read(data, 0, 1024)) != -1) {
                out.write(data, 0, count);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        try {
            in.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return new String(out.toByteArray());
    }

    private static String getManifest(String destination) throws IOException {
        ZipFile z = new ZipFile(String.valueOf(destination) + "/wrapper.jar");
        ZipEntry ze = z.getEntry("META-INF/MANIFEST.MF");
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        BufferedInputStream in = new BufferedInputStream(z.getInputStream(ze));
        byte[] data = new byte[1024];
        int count = 0;
        while ((count = in.read(data, 0, 1024)) != -1) {
            out.write(data, 0, count);
        }
        in.close();
        z.close();
        return new String(out.toByteArray()).replaceAll("\r\n ", "");
    }

    static class FilteredStream
    extends FilterOutputStream {
        public FilteredStream(OutputStream aStream) {
            super(aStream);
        }

        @Override
        public void write(byte[] b) throws IOException {
            String aString = new String(b);
            WebStartBooter.wsform._LOG_AREA.append(aString);
        }

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
            String aString = new String(b, off, len);
            WebStartBooter.wsform._LOG_AREA.append(aString);
            if (WebStartBooter.wsform._LOG_AREA.getText().contains("Exception")) {
                WebStartBooter.showStep("Error found");
            }
            if (WebStartBooter.wsform._LOG_AREA.getText().contains("configuration file not found")) {
                WebStartBooter.showStep("Error: Configuration file not found");
            }
            WebStartBooter.wsform._LOG_AREA.setCaretPosition(WebStartBooter.wsform._LOG_AREA.getDocument().getLength());
        }
    }
}

