// Copyright 2025 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go-grpc. DO NOT EDIT.
// versions:
// - protoc-gen-go-grpc v1.3.0
// - protoc             v4.25.7
// source: google/cloud/dialogflow/cx/v3beta1/transition_route_group.proto

package cxpb

import (
	context "context"

	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
	emptypb "google.golang.org/protobuf/types/known/emptypb"
)

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
// Requires gRPC-Go v1.32.0 or later.
const _ = grpc.SupportPackageIsVersion7

const (
	TransitionRouteGroups_ListTransitionRouteGroups_FullMethodName  = "/google.cloud.dialogflow.cx.v3beta1.TransitionRouteGroups/ListTransitionRouteGroups"
	TransitionRouteGroups_GetTransitionRouteGroup_FullMethodName    = "/google.cloud.dialogflow.cx.v3beta1.TransitionRouteGroups/GetTransitionRouteGroup"
	TransitionRouteGroups_CreateTransitionRouteGroup_FullMethodName = "/google.cloud.dialogflow.cx.v3beta1.TransitionRouteGroups/CreateTransitionRouteGroup"
	TransitionRouteGroups_UpdateTransitionRouteGroup_FullMethodName = "/google.cloud.dialogflow.cx.v3beta1.TransitionRouteGroups/UpdateTransitionRouteGroup"
	TransitionRouteGroups_DeleteTransitionRouteGroup_FullMethodName = "/google.cloud.dialogflow.cx.v3beta1.TransitionRouteGroups/DeleteTransitionRouteGroup"
)

// TransitionRouteGroupsClient is the client API for TransitionRouteGroups service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://pkg.go.dev/google.golang.org/grpc/?tab=doc#ClientConn.NewStream.
type TransitionRouteGroupsClient interface {
	// Returns the list of all transition route groups in the specified flow.
	ListTransitionRouteGroups(ctx context.Context, in *ListTransitionRouteGroupsRequest, opts ...grpc.CallOption) (*ListTransitionRouteGroupsResponse, error)
	// Retrieves the specified
	// [TransitionRouteGroup][google.cloud.dialogflow.cx.v3beta1.TransitionRouteGroup].
	GetTransitionRouteGroup(ctx context.Context, in *GetTransitionRouteGroupRequest, opts ...grpc.CallOption) (*TransitionRouteGroup, error)
	// Creates an
	// [TransitionRouteGroup][google.cloud.dialogflow.cx.v3beta1.TransitionRouteGroup]
	// in the specified flow.
	//
	// Note: You should always train a flow prior to sending it queries. See the
	// [training
	// documentation](https://cloud.google.com/dialogflow/cx/docs/concept/training).
	CreateTransitionRouteGroup(ctx context.Context, in *CreateTransitionRouteGroupRequest, opts ...grpc.CallOption) (*TransitionRouteGroup, error)
	// Updates the specified
	// [TransitionRouteGroup][google.cloud.dialogflow.cx.v3beta1.TransitionRouteGroup].
	//
	// Note: You should always train a flow prior to sending it queries. See the
	// [training
	// documentation](https://cloud.google.com/dialogflow/cx/docs/concept/training).
	UpdateTransitionRouteGroup(ctx context.Context, in *UpdateTransitionRouteGroupRequest, opts ...grpc.CallOption) (*TransitionRouteGroup, error)
	// Deletes the specified
	// [TransitionRouteGroup][google.cloud.dialogflow.cx.v3beta1.TransitionRouteGroup].
	//
	// Note: You should always train a flow prior to sending it queries. See the
	// [training
	// documentation](https://cloud.google.com/dialogflow/cx/docs/concept/training).
	DeleteTransitionRouteGroup(ctx context.Context, in *DeleteTransitionRouteGroupRequest, opts ...grpc.CallOption) (*emptypb.Empty, error)
}

type transitionRouteGroupsClient struct {
	cc grpc.ClientConnInterface
}

func NewTransitionRouteGroupsClient(cc grpc.ClientConnInterface) TransitionRouteGroupsClient {
	return &transitionRouteGroupsClient{cc}
}

func (c *transitionRouteGroupsClient) ListTransitionRouteGroups(ctx context.Context, in *ListTransitionRouteGroupsRequest, opts ...grpc.CallOption) (*ListTransitionRouteGroupsResponse, error) {
	out := new(ListTransitionRouteGroupsResponse)
	err := c.cc.Invoke(ctx, TransitionRouteGroups_ListTransitionRouteGroups_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *transitionRouteGroupsClient) GetTransitionRouteGroup(ctx context.Context, in *GetTransitionRouteGroupRequest, opts ...grpc.CallOption) (*TransitionRouteGroup, error) {
	out := new(TransitionRouteGroup)
	err := c.cc.Invoke(ctx, TransitionRouteGroups_GetTransitionRouteGroup_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *transitionRouteGroupsClient) CreateTransitionRouteGroup(ctx context.Context, in *CreateTransitionRouteGroupRequest, opts ...grpc.CallOption) (*TransitionRouteGroup, error) {
	out := new(TransitionRouteGroup)
	err := c.cc.Invoke(ctx, TransitionRouteGroups_CreateTransitionRouteGroup_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *transitionRouteGroupsClient) UpdateTransitionRouteGroup(ctx context.Context, in *UpdateTransitionRouteGroupRequest, opts ...grpc.CallOption) (*TransitionRouteGroup, error) {
	out := new(TransitionRouteGroup)
	err := c.cc.Invoke(ctx, TransitionRouteGroups_UpdateTransitionRouteGroup_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *transitionRouteGroupsClient) DeleteTransitionRouteGroup(ctx context.Context, in *DeleteTransitionRouteGroupRequest, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, TransitionRouteGroups_DeleteTransitionRouteGroup_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// TransitionRouteGroupsServer is the server API for TransitionRouteGroups service.
// All implementations should embed UnimplementedTransitionRouteGroupsServer
// for forward compatibility
type TransitionRouteGroupsServer interface {
	// Returns the list of all transition route groups in the specified flow.
	ListTransitionRouteGroups(context.Context, *ListTransitionRouteGroupsRequest) (*ListTransitionRouteGroupsResponse, error)
	// Retrieves the specified
	// [TransitionRouteGroup][google.cloud.dialogflow.cx.v3beta1.TransitionRouteGroup].
	GetTransitionRouteGroup(context.Context, *GetTransitionRouteGroupRequest) (*TransitionRouteGroup, error)
	// Creates an
	// [TransitionRouteGroup][google.cloud.dialogflow.cx.v3beta1.TransitionRouteGroup]
	// in the specified flow.
	//
	// Note: You should always train a flow prior to sending it queries. See the
	// [training
	// documentation](https://cloud.google.com/dialogflow/cx/docs/concept/training).
	CreateTransitionRouteGroup(context.Context, *CreateTransitionRouteGroupRequest) (*TransitionRouteGroup, error)
	// Updates the specified
	// [TransitionRouteGroup][google.cloud.dialogflow.cx.v3beta1.TransitionRouteGroup].
	//
	// Note: You should always train a flow prior to sending it queries. See the
	// [training
	// documentation](https://cloud.google.com/dialogflow/cx/docs/concept/training).
	UpdateTransitionRouteGroup(context.Context, *UpdateTransitionRouteGroupRequest) (*TransitionRouteGroup, error)
	// Deletes the specified
	// [TransitionRouteGroup][google.cloud.dialogflow.cx.v3beta1.TransitionRouteGroup].
	//
	// Note: You should always train a flow prior to sending it queries. See the
	// [training
	// documentation](https://cloud.google.com/dialogflow/cx/docs/concept/training).
	DeleteTransitionRouteGroup(context.Context, *DeleteTransitionRouteGroupRequest) (*emptypb.Empty, error)
}

// UnimplementedTransitionRouteGroupsServer should be embedded to have forward compatible implementations.
type UnimplementedTransitionRouteGroupsServer struct {
}

func (UnimplementedTransitionRouteGroupsServer) ListTransitionRouteGroups(context.Context, *ListTransitionRouteGroupsRequest) (*ListTransitionRouteGroupsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListTransitionRouteGroups not implemented")
}
func (UnimplementedTransitionRouteGroupsServer) GetTransitionRouteGroup(context.Context, *GetTransitionRouteGroupRequest) (*TransitionRouteGroup, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetTransitionRouteGroup not implemented")
}
func (UnimplementedTransitionRouteGroupsServer) CreateTransitionRouteGroup(context.Context, *CreateTransitionRouteGroupRequest) (*TransitionRouteGroup, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateTransitionRouteGroup not implemented")
}
func (UnimplementedTransitionRouteGroupsServer) UpdateTransitionRouteGroup(context.Context, *UpdateTransitionRouteGroupRequest) (*TransitionRouteGroup, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateTransitionRouteGroup not implemented")
}
func (UnimplementedTransitionRouteGroupsServer) DeleteTransitionRouteGroup(context.Context, *DeleteTransitionRouteGroupRequest) (*emptypb.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteTransitionRouteGroup not implemented")
}

// UnsafeTransitionRouteGroupsServer may be embedded to opt out of forward compatibility for this service.
// Use of this interface is not recommended, as added methods to TransitionRouteGroupsServer will
// result in compilation errors.
type UnsafeTransitionRouteGroupsServer interface {
	mustEmbedUnimplementedTransitionRouteGroupsServer()
}

func RegisterTransitionRouteGroupsServer(s grpc.ServiceRegistrar, srv TransitionRouteGroupsServer) {
	s.RegisterService(&TransitionRouteGroups_ServiceDesc, srv)
}

func _TransitionRouteGroups_ListTransitionRouteGroups_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListTransitionRouteGroupsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(TransitionRouteGroupsServer).ListTransitionRouteGroups(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: TransitionRouteGroups_ListTransitionRouteGroups_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(TransitionRouteGroupsServer).ListTransitionRouteGroups(ctx, req.(*ListTransitionRouteGroupsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _TransitionRouteGroups_GetTransitionRouteGroup_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetTransitionRouteGroupRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(TransitionRouteGroupsServer).GetTransitionRouteGroup(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: TransitionRouteGroups_GetTransitionRouteGroup_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(TransitionRouteGroupsServer).GetTransitionRouteGroup(ctx, req.(*GetTransitionRouteGroupRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _TransitionRouteGroups_CreateTransitionRouteGroup_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateTransitionRouteGroupRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(TransitionRouteGroupsServer).CreateTransitionRouteGroup(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: TransitionRouteGroups_CreateTransitionRouteGroup_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(TransitionRouteGroupsServer).CreateTransitionRouteGroup(ctx, req.(*CreateTransitionRouteGroupRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _TransitionRouteGroups_UpdateTransitionRouteGroup_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateTransitionRouteGroupRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(TransitionRouteGroupsServer).UpdateTransitionRouteGroup(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: TransitionRouteGroups_UpdateTransitionRouteGroup_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(TransitionRouteGroupsServer).UpdateTransitionRouteGroup(ctx, req.(*UpdateTransitionRouteGroupRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _TransitionRouteGroups_DeleteTransitionRouteGroup_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteTransitionRouteGroupRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(TransitionRouteGroupsServer).DeleteTransitionRouteGroup(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: TransitionRouteGroups_DeleteTransitionRouteGroup_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(TransitionRouteGroupsServer).DeleteTransitionRouteGroup(ctx, req.(*DeleteTransitionRouteGroupRequest))
	}
	return interceptor(ctx, in, info, handler)
}

// TransitionRouteGroups_ServiceDesc is the grpc.ServiceDesc for TransitionRouteGroups service.
// It's only intended for direct use with grpc.RegisterService,
// and not to be introspected or modified (even as a copy)
var TransitionRouteGroups_ServiceDesc = grpc.ServiceDesc{
	ServiceName: "google.cloud.dialogflow.cx.v3beta1.TransitionRouteGroups",
	HandlerType: (*TransitionRouteGroupsServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "ListTransitionRouteGroups",
			Handler:    _TransitionRouteGroups_ListTransitionRouteGroups_Handler,
		},
		{
			MethodName: "GetTransitionRouteGroup",
			Handler:    _TransitionRouteGroups_GetTransitionRouteGroup_Handler,
		},
		{
			MethodName: "CreateTransitionRouteGroup",
			Handler:    _TransitionRouteGroups_CreateTransitionRouteGroup_Handler,
		},
		{
			MethodName: "UpdateTransitionRouteGroup",
			Handler:    _TransitionRouteGroups_UpdateTransitionRouteGroup_Handler,
		},
		{
			MethodName: "DeleteTransitionRouteGroup",
			Handler:    _TransitionRouteGroups_DeleteTransitionRouteGroup_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/cloud/dialogflow/cx/v3beta1/transition_route_group.proto",
}
