// Copyright 2025 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go-grpc. DO NOT EDIT.
// versions:
// - protoc-gen-go-grpc v1.3.0
// - protoc             v4.25.7
// source: google/cloud/dialogflow/v2beta1/session.proto

package dialogflowpb

import (
	context "context"

	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
)

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
// Requires gRPC-Go v1.32.0 or later.
const _ = grpc.SupportPackageIsVersion7

const (
	Sessions_DetectIntent_FullMethodName          = "/google.cloud.dialogflow.v2beta1.Sessions/DetectIntent"
	Sessions_StreamingDetectIntent_FullMethodName = "/google.cloud.dialogflow.v2beta1.Sessions/StreamingDetectIntent"
)

// SessionsClient is the client API for Sessions service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://pkg.go.dev/google.golang.org/grpc/?tab=doc#ClientConn.NewStream.
type SessionsClient interface {
	// Processes a natural language query and returns structured, actionable data
	// as a result. This method is not idempotent, because it may cause contexts
	// and session entity types to be updated, which in turn might affect
	// results of future queries.
	//
	// If you might use
	// [Agent Assist](https://cloud.google.com/dialogflow/docs/#aa)
	// or other CCAI products now or in the future, consider using
	// [AnalyzeContent][google.cloud.dialogflow.v2beta1.Participants.AnalyzeContent]
	// instead of `DetectIntent`. `AnalyzeContent` has additional
	// functionality for Agent Assist and other CCAI products.
	//
	// Note: Always use agent versions for production traffic.
	// See [Versions and
	// environments](https://cloud.google.com/dialogflow/es/docs/agents-versions).
	DetectIntent(ctx context.Context, in *DetectIntentRequest, opts ...grpc.CallOption) (*DetectIntentResponse, error)
	// Processes a natural language query in audio format in a streaming fashion
	// and returns structured, actionable data as a result. This method is only
	// available via the gRPC API (not REST).
	//
	// If you might use
	// [Agent Assist](https://cloud.google.com/dialogflow/docs/#aa)
	// or other CCAI products now or in the future, consider using
	// [StreamingAnalyzeContent][google.cloud.dialogflow.v2beta1.Participants.StreamingAnalyzeContent]
	// instead of `StreamingDetectIntent`. `StreamingAnalyzeContent` has
	// additional functionality for Agent Assist and other CCAI products.
	//
	// Note: Always use agent versions for production traffic.
	// See [Versions and
	// environments](https://cloud.google.com/dialogflow/es/docs/agents-versions).
	StreamingDetectIntent(ctx context.Context, opts ...grpc.CallOption) (Sessions_StreamingDetectIntentClient, error)
}

type sessionsClient struct {
	cc grpc.ClientConnInterface
}

func NewSessionsClient(cc grpc.ClientConnInterface) SessionsClient {
	return &sessionsClient{cc}
}

func (c *sessionsClient) DetectIntent(ctx context.Context, in *DetectIntentRequest, opts ...grpc.CallOption) (*DetectIntentResponse, error) {
	out := new(DetectIntentResponse)
	err := c.cc.Invoke(ctx, Sessions_DetectIntent_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *sessionsClient) StreamingDetectIntent(ctx context.Context, opts ...grpc.CallOption) (Sessions_StreamingDetectIntentClient, error) {
	stream, err := c.cc.NewStream(ctx, &Sessions_ServiceDesc.Streams[0], Sessions_StreamingDetectIntent_FullMethodName, opts...)
	if err != nil {
		return nil, err
	}
	x := &sessionsStreamingDetectIntentClient{stream}
	return x, nil
}

type Sessions_StreamingDetectIntentClient interface {
	Send(*StreamingDetectIntentRequest) error
	Recv() (*StreamingDetectIntentResponse, error)
	grpc.ClientStream
}

type sessionsStreamingDetectIntentClient struct {
	grpc.ClientStream
}

func (x *sessionsStreamingDetectIntentClient) Send(m *StreamingDetectIntentRequest) error {
	return x.ClientStream.SendMsg(m)
}

func (x *sessionsStreamingDetectIntentClient) Recv() (*StreamingDetectIntentResponse, error) {
	m := new(StreamingDetectIntentResponse)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

// SessionsServer is the server API for Sessions service.
// All implementations should embed UnimplementedSessionsServer
// for forward compatibility
type SessionsServer interface {
	// Processes a natural language query and returns structured, actionable data
	// as a result. This method is not idempotent, because it may cause contexts
	// and session entity types to be updated, which in turn might affect
	// results of future queries.
	//
	// If you might use
	// [Agent Assist](https://cloud.google.com/dialogflow/docs/#aa)
	// or other CCAI products now or in the future, consider using
	// [AnalyzeContent][google.cloud.dialogflow.v2beta1.Participants.AnalyzeContent]
	// instead of `DetectIntent`. `AnalyzeContent` has additional
	// functionality for Agent Assist and other CCAI products.
	//
	// Note: Always use agent versions for production traffic.
	// See [Versions and
	// environments](https://cloud.google.com/dialogflow/es/docs/agents-versions).
	DetectIntent(context.Context, *DetectIntentRequest) (*DetectIntentResponse, error)
	// Processes a natural language query in audio format in a streaming fashion
	// and returns structured, actionable data as a result. This method is only
	// available via the gRPC API (not REST).
	//
	// If you might use
	// [Agent Assist](https://cloud.google.com/dialogflow/docs/#aa)
	// or other CCAI products now or in the future, consider using
	// [StreamingAnalyzeContent][google.cloud.dialogflow.v2beta1.Participants.StreamingAnalyzeContent]
	// instead of `StreamingDetectIntent`. `StreamingAnalyzeContent` has
	// additional functionality for Agent Assist and other CCAI products.
	//
	// Note: Always use agent versions for production traffic.
	// See [Versions and
	// environments](https://cloud.google.com/dialogflow/es/docs/agents-versions).
	StreamingDetectIntent(Sessions_StreamingDetectIntentServer) error
}

// UnimplementedSessionsServer should be embedded to have forward compatible implementations.
type UnimplementedSessionsServer struct {
}

func (UnimplementedSessionsServer) DetectIntent(context.Context, *DetectIntentRequest) (*DetectIntentResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DetectIntent not implemented")
}
func (UnimplementedSessionsServer) StreamingDetectIntent(Sessions_StreamingDetectIntentServer) error {
	return status.Errorf(codes.Unimplemented, "method StreamingDetectIntent not implemented")
}

// UnsafeSessionsServer may be embedded to opt out of forward compatibility for this service.
// Use of this interface is not recommended, as added methods to SessionsServer will
// result in compilation errors.
type UnsafeSessionsServer interface {
	mustEmbedUnimplementedSessionsServer()
}

func RegisterSessionsServer(s grpc.ServiceRegistrar, srv SessionsServer) {
	s.RegisterService(&Sessions_ServiceDesc, srv)
}

func _Sessions_DetectIntent_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DetectIntentRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SessionsServer).DetectIntent(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Sessions_DetectIntent_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SessionsServer).DetectIntent(ctx, req.(*DetectIntentRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Sessions_StreamingDetectIntent_Handler(srv interface{}, stream grpc.ServerStream) error {
	return srv.(SessionsServer).StreamingDetectIntent(&sessionsStreamingDetectIntentServer{stream})
}

type Sessions_StreamingDetectIntentServer interface {
	Send(*StreamingDetectIntentResponse) error
	Recv() (*StreamingDetectIntentRequest, error)
	grpc.ServerStream
}

type sessionsStreamingDetectIntentServer struct {
	grpc.ServerStream
}

func (x *sessionsStreamingDetectIntentServer) Send(m *StreamingDetectIntentResponse) error {
	return x.ServerStream.SendMsg(m)
}

func (x *sessionsStreamingDetectIntentServer) Recv() (*StreamingDetectIntentRequest, error) {
	m := new(StreamingDetectIntentRequest)
	if err := x.ServerStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

// Sessions_ServiceDesc is the grpc.ServiceDesc for Sessions service.
// It's only intended for direct use with grpc.RegisterService,
// and not to be introspected or modified (even as a copy)
var Sessions_ServiceDesc = grpc.ServiceDesc{
	ServiceName: "google.cloud.dialogflow.v2beta1.Sessions",
	HandlerType: (*SessionsServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "DetectIntent",
			Handler:    _Sessions_DetectIntent_Handler,
		},
	},
	Streams: []grpc.StreamDesc{
		{
			StreamName:    "StreamingDetectIntent",
			Handler:       _Sessions_StreamingDetectIntent_Handler,
			ServerStreams: true,
			ClientStreams: true,
		},
	},
	Metadata: "google/cloud/dialogflow/v2beta1/session.proto",
}
