// Copyright 2025 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.35.2
// 	protoc        v4.25.7
// source: google/cloud/gkemulticloud/v1/azure_service.proto

package gkemulticloudpb

import (
	reflect "reflect"
	sync "sync"

	longrunningpb "cloud.google.com/go/longrunning/autogen/longrunningpb"
	_ "google.golang.org/genproto/googleapis/api/annotations"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	_ "google.golang.org/protobuf/types/known/emptypb"
	fieldmaskpb "google.golang.org/protobuf/types/known/fieldmaskpb"
	timestamppb "google.golang.org/protobuf/types/known/timestamppb"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// Request message for `AzureClusters.CreateAzureCluster` method.
//
// Deprecated: Marked as deprecated in google/cloud/gkemulticloud/v1/azure_service.proto.
type CreateAzureClusterRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The parent location where this
	// [AzureCluster][google.cloud.gkemulticloud.v1.AzureCluster] resource will be
	// created.
	//
	// Location names are formatted as `projects/<project-id>/locations/<region>`.
	//
	// See [Resource Names](https://cloud.google.com/apis/design/resource_names)
	// for more details on Google Cloud resource names.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. The specification of the
	// [AzureCluster][google.cloud.gkemulticloud.v1.AzureCluster] to create.
	AzureCluster *AzureCluster `protobuf:"bytes,2,opt,name=azure_cluster,json=azureCluster,proto3" json:"azure_cluster,omitempty"`
	// Required. A client provided ID the resource. Must be unique within the
	// parent resource.
	//
	// The provided ID will be part of the
	// [AzureCluster][google.cloud.gkemulticloud.v1.AzureCluster] resource name
	// formatted as
	// `projects/<project-id>/locations/<region>/azureClusters/<cluster-id>`.
	//
	// Valid characters are `/[a-z][0-9]-/`. Cannot be longer than 63 characters.
	AzureClusterId string `protobuf:"bytes,3,opt,name=azure_cluster_id,json=azureClusterId,proto3" json:"azure_cluster_id,omitempty"`
	// If set, only validate the request, but do not actually create the cluster.
	ValidateOnly bool `protobuf:"varint,4,opt,name=validate_only,json=validateOnly,proto3" json:"validate_only,omitempty"`
}

func (x *CreateAzureClusterRequest) Reset() {
	*x = CreateAzureClusterRequest{}
	mi := &file_google_cloud_gkemulticloud_v1_azure_service_proto_msgTypes[0]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *CreateAzureClusterRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateAzureClusterRequest) ProtoMessage() {}

func (x *CreateAzureClusterRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_gkemulticloud_v1_azure_service_proto_msgTypes[0]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateAzureClusterRequest.ProtoReflect.Descriptor instead.
func (*CreateAzureClusterRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_gkemulticloud_v1_azure_service_proto_rawDescGZIP(), []int{0}
}

func (x *CreateAzureClusterRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *CreateAzureClusterRequest) GetAzureCluster() *AzureCluster {
	if x != nil {
		return x.AzureCluster
	}
	return nil
}

func (x *CreateAzureClusterRequest) GetAzureClusterId() string {
	if x != nil {
		return x.AzureClusterId
	}
	return ""
}

func (x *CreateAzureClusterRequest) GetValidateOnly() bool {
	if x != nil {
		return x.ValidateOnly
	}
	return false
}

// Request message for `AzureClusters.UpdateAzureCluster` method.
//
// Deprecated: Marked as deprecated in google/cloud/gkemulticloud/v1/azure_service.proto.
type UpdateAzureClusterRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The [AzureCluster][google.cloud.gkemulticloud.v1.AzureCluster]
	// resource to update.
	AzureCluster *AzureCluster `protobuf:"bytes,1,opt,name=azure_cluster,json=azureCluster,proto3" json:"azure_cluster,omitempty"`
	// If set, only validate the request, but do not actually update the cluster.
	ValidateOnly bool `protobuf:"varint,2,opt,name=validate_only,json=validateOnly,proto3" json:"validate_only,omitempty"`
	// Required. Mask of fields to update. At least one path must be supplied in
	// this field. The elements of the repeated paths field can only include these
	// fields from [AzureCluster][google.cloud.gkemulticloud.v1.AzureCluster]:
	//
	//   - `description`.
	//   - `azureClient`.
	//   - `control_plane.version`.
	//   - `control_plane.vm_size`.
	//   - `annotations`.
	//   - `authorization.admin_users`.
	//   - `authorization.admin_groups`.
	//   - `control_plane.root_volume.size_gib`.
	//   - `azure_services_authentication`.
	//   - `azure_services_authentication.tenant_id`.
	//   - `azure_services_authentication.application_id`.
	//   - `control_plane.proxy_config`.
	//   - `control_plane.proxy_config.resource_group_id`.
	//   - `control_plane.proxy_config.secret_id`.
	//   - `control_plane.ssh_config.authorized_key`.
	//   - `logging_config.component_config.enable_components`
	//   - `monitoring_config.managed_prometheus_config.enabled`.
	UpdateMask *fieldmaskpb.FieldMask `protobuf:"bytes,4,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
}

func (x *UpdateAzureClusterRequest) Reset() {
	*x = UpdateAzureClusterRequest{}
	mi := &file_google_cloud_gkemulticloud_v1_azure_service_proto_msgTypes[1]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *UpdateAzureClusterRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateAzureClusterRequest) ProtoMessage() {}

func (x *UpdateAzureClusterRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_gkemulticloud_v1_azure_service_proto_msgTypes[1]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdateAzureClusterRequest.ProtoReflect.Descriptor instead.
func (*UpdateAzureClusterRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_gkemulticloud_v1_azure_service_proto_rawDescGZIP(), []int{1}
}

func (x *UpdateAzureClusterRequest) GetAzureCluster() *AzureCluster {
	if x != nil {
		return x.AzureCluster
	}
	return nil
}

func (x *UpdateAzureClusterRequest) GetValidateOnly() bool {
	if x != nil {
		return x.ValidateOnly
	}
	return false
}

func (x *UpdateAzureClusterRequest) GetUpdateMask() *fieldmaskpb.FieldMask {
	if x != nil {
		return x.UpdateMask
	}
	return nil
}

// Request message for `AzureClusters.GetAzureCluster` method.
//
// Deprecated: Marked as deprecated in google/cloud/gkemulticloud/v1/azure_service.proto.
type GetAzureClusterRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the
	// [AzureCluster][google.cloud.gkemulticloud.v1.AzureCluster] resource to
	// describe.
	//
	// `AzureCluster` names are formatted as
	// `projects/<project-id>/locations/<region>/azureClusters/<cluster-id>`.
	//
	// See [Resource Names](https://cloud.google.com/apis/design/resource_names)
	// for more details on Google Cloud Platform resource names.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *GetAzureClusterRequest) Reset() {
	*x = GetAzureClusterRequest{}
	mi := &file_google_cloud_gkemulticloud_v1_azure_service_proto_msgTypes[2]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GetAzureClusterRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetAzureClusterRequest) ProtoMessage() {}

func (x *GetAzureClusterRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_gkemulticloud_v1_azure_service_proto_msgTypes[2]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetAzureClusterRequest.ProtoReflect.Descriptor instead.
func (*GetAzureClusterRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_gkemulticloud_v1_azure_service_proto_rawDescGZIP(), []int{2}
}

func (x *GetAzureClusterRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Request message for `AzureClusters.ListAzureClusters` method.
//
// Deprecated: Marked as deprecated in google/cloud/gkemulticloud/v1/azure_service.proto.
type ListAzureClustersRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The parent location which owns this collection of
	// [AzureCluster][google.cloud.gkemulticloud.v1.AzureCluster] resources.
	//
	// Location names are formatted as `projects/<project-id>/locations/<region>`.
	//
	// See [Resource Names](https://cloud.google.com/apis/design/resource_names)
	// for more details on Google Cloud Platform resource names.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// The maximum number of items to return.
	//
	// If not specified, a default value of 50 will be used by the service.
	// Regardless of the pageSize value, the response can include a partial list
	// and a caller should only rely on response's
	// [nextPageToken][google.cloud.gkemulticloud.v1.ListAzureClustersResponse.next_page_token]
	// to determine if there are more instances left to be queried.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// The `nextPageToken` value returned from a previous
	// [azureClusters.list][google.cloud.gkemulticloud.v1.AzureClusters.ListAzureClusters]
	// request, if any.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
}

func (x *ListAzureClustersRequest) Reset() {
	*x = ListAzureClustersRequest{}
	mi := &file_google_cloud_gkemulticloud_v1_azure_service_proto_msgTypes[3]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ListAzureClustersRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListAzureClustersRequest) ProtoMessage() {}

func (x *ListAzureClustersRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_gkemulticloud_v1_azure_service_proto_msgTypes[3]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListAzureClustersRequest.ProtoReflect.Descriptor instead.
func (*ListAzureClustersRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_gkemulticloud_v1_azure_service_proto_rawDescGZIP(), []int{3}
}

func (x *ListAzureClustersRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListAzureClustersRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListAzureClustersRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

// Response message for `AzureClusters.ListAzureClusters` method.
//
// Deprecated: Marked as deprecated in google/cloud/gkemulticloud/v1/azure_service.proto.
type ListAzureClustersResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// A list of [AzureCluster][google.cloud.gkemulticloud.v1.AzureCluster]
	// resources in the specified Google Cloud Platform project and region region.
	AzureClusters []*AzureCluster `protobuf:"bytes,1,rep,name=azure_clusters,json=azureClusters,proto3" json:"azure_clusters,omitempty"`
	// Token to retrieve the next page of results, or empty if there are no more
	// results in the list.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
}

func (x *ListAzureClustersResponse) Reset() {
	*x = ListAzureClustersResponse{}
	mi := &file_google_cloud_gkemulticloud_v1_azure_service_proto_msgTypes[4]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ListAzureClustersResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListAzureClustersResponse) ProtoMessage() {}

func (x *ListAzureClustersResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_gkemulticloud_v1_azure_service_proto_msgTypes[4]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListAzureClustersResponse.ProtoReflect.Descriptor instead.
func (*ListAzureClustersResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_gkemulticloud_v1_azure_service_proto_rawDescGZIP(), []int{4}
}

func (x *ListAzureClustersResponse) GetAzureClusters() []*AzureCluster {
	if x != nil {
		return x.AzureClusters
	}
	return nil
}

func (x *ListAzureClustersResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

// Request message for `AzureClusters.DeleteAzureCluster` method.
//
// Deprecated: Marked as deprecated in google/cloud/gkemulticloud/v1/azure_service.proto.
type DeleteAzureClusterRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The resource name the
	// [AzureCluster][google.cloud.gkemulticloud.v1.AzureCluster] to delete.
	//
	// `AzureCluster` names are formatted as
	// `projects/<project-id>/locations/<region>/azureClusters/<cluster-id>`.
	//
	// See [Resource Names](https://cloud.google.com/apis/design/resource_names)
	// for more details on Google Cloud Platform resource names.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// If set to true, and the
	// [AzureCluster][google.cloud.gkemulticloud.v1.AzureCluster] resource is not
	// found, the request will succeed but no action will be taken on the server
	// and a completed [Operation][google.longrunning.Operation] will be returned.
	//
	// Useful for idempotent deletion.
	AllowMissing bool `protobuf:"varint,2,opt,name=allow_missing,json=allowMissing,proto3" json:"allow_missing,omitempty"`
	// If set, only validate the request, but do not actually delete the resource.
	ValidateOnly bool `protobuf:"varint,3,opt,name=validate_only,json=validateOnly,proto3" json:"validate_only,omitempty"`
	// The current etag of the
	// [AzureCluster][google.cloud.gkemulticloud.v1.AzureCluster].
	//
	// Allows clients to perform deletions through optimistic concurrency control.
	//
	// If the provided etag does not match the current etag of the cluster,
	// the request will fail and an ABORTED error will be returned.
	Etag string `protobuf:"bytes,4,opt,name=etag,proto3" json:"etag,omitempty"`
	// Optional. If set to true, the deletion of
	// [AzureCluster][google.cloud.gkemulticloud.v1.AzureCluster] resource will
	// succeed even if errors occur during deleting in cluster resources. Using
	// this parameter may result in orphaned resources in the cluster.
	IgnoreErrors bool `protobuf:"varint,5,opt,name=ignore_errors,json=ignoreErrors,proto3" json:"ignore_errors,omitempty"`
}

func (x *DeleteAzureClusterRequest) Reset() {
	*x = DeleteAzureClusterRequest{}
	mi := &file_google_cloud_gkemulticloud_v1_azure_service_proto_msgTypes[5]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *DeleteAzureClusterRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteAzureClusterRequest) ProtoMessage() {}

func (x *DeleteAzureClusterRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_gkemulticloud_v1_azure_service_proto_msgTypes[5]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeleteAzureClusterRequest.ProtoReflect.Descriptor instead.
func (*DeleteAzureClusterRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_gkemulticloud_v1_azure_service_proto_rawDescGZIP(), []int{5}
}

func (x *DeleteAzureClusterRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *DeleteAzureClusterRequest) GetAllowMissing() bool {
	if x != nil {
		return x.AllowMissing
	}
	return false
}

func (x *DeleteAzureClusterRequest) GetValidateOnly() bool {
	if x != nil {
		return x.ValidateOnly
	}
	return false
}

func (x *DeleteAzureClusterRequest) GetEtag() string {
	if x != nil {
		return x.Etag
	}
	return ""
}

func (x *DeleteAzureClusterRequest) GetIgnoreErrors() bool {
	if x != nil {
		return x.IgnoreErrors
	}
	return false
}

// Response message for `AzureClusters.CreateAzureNodePool` method.
//
// Deprecated: Marked as deprecated in google/cloud/gkemulticloud/v1/azure_service.proto.
type CreateAzureNodePoolRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The [AzureCluster][google.cloud.gkemulticloud.v1.AzureCluster]
	// resource where this node pool will be created.
	//
	// `AzureCluster` names are formatted as
	// `projects/<project-id>/locations/<region>/azureClusters/<cluster-id>`.
	//
	// See [Resource Names](https://cloud.google.com/apis/design/resource_names)
	// for more details on Google Cloud resource names.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. The specification of the
	// [AzureNodePool][google.cloud.gkemulticloud.v1.AzureNodePool] to create.
	AzureNodePool *AzureNodePool `protobuf:"bytes,2,opt,name=azure_node_pool,json=azureNodePool,proto3" json:"azure_node_pool,omitempty"`
	// Required. A client provided ID the resource. Must be unique within the
	// parent resource.
	//
	// The provided ID will be part of the
	// [AzureNodePool][google.cloud.gkemulticloud.v1.AzureNodePool] resource name
	// formatted as
	// `projects/<project-id>/locations/<region>/azureClusters/<cluster-id>/azureNodePools/<node-pool-id>`.
	//
	// Valid characters are `/[a-z][0-9]-/`. Cannot be longer than 63 characters.
	AzureNodePoolId string `protobuf:"bytes,3,opt,name=azure_node_pool_id,json=azureNodePoolId,proto3" json:"azure_node_pool_id,omitempty"`
	// If set, only validate the request, but do not actually create the node
	// pool.
	ValidateOnly bool `protobuf:"varint,4,opt,name=validate_only,json=validateOnly,proto3" json:"validate_only,omitempty"`
}

func (x *CreateAzureNodePoolRequest) Reset() {
	*x = CreateAzureNodePoolRequest{}
	mi := &file_google_cloud_gkemulticloud_v1_azure_service_proto_msgTypes[6]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *CreateAzureNodePoolRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateAzureNodePoolRequest) ProtoMessage() {}

func (x *CreateAzureNodePoolRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_gkemulticloud_v1_azure_service_proto_msgTypes[6]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateAzureNodePoolRequest.ProtoReflect.Descriptor instead.
func (*CreateAzureNodePoolRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_gkemulticloud_v1_azure_service_proto_rawDescGZIP(), []int{6}
}

func (x *CreateAzureNodePoolRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *CreateAzureNodePoolRequest) GetAzureNodePool() *AzureNodePool {
	if x != nil {
		return x.AzureNodePool
	}
	return nil
}

func (x *CreateAzureNodePoolRequest) GetAzureNodePoolId() string {
	if x != nil {
		return x.AzureNodePoolId
	}
	return ""
}

func (x *CreateAzureNodePoolRequest) GetValidateOnly() bool {
	if x != nil {
		return x.ValidateOnly
	}
	return false
}

// Request message for `AzureClusters.UpdateAzureNodePool` method.
//
// Deprecated: Marked as deprecated in google/cloud/gkemulticloud/v1/azure_service.proto.
type UpdateAzureNodePoolRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The [AzureNodePool][google.cloud.gkemulticloud.v1.AzureNodePool]
	// resource to update.
	AzureNodePool *AzureNodePool `protobuf:"bytes,1,opt,name=azure_node_pool,json=azureNodePool,proto3" json:"azure_node_pool,omitempty"`
	// If set, only validate the request, but don't actually update the node pool.
	ValidateOnly bool `protobuf:"varint,2,opt,name=validate_only,json=validateOnly,proto3" json:"validate_only,omitempty"`
	// Required. Mask of fields to update. At least one path must be supplied in
	// this field. The elements of the repeated paths field can only include these
	// fields from [AzureNodePool][google.cloud.gkemulticloud.v1.AzureNodePool]:
	//
	//	*.  `annotations`.
	//	*   `version`.
	//	*   `autoscaling.min_node_count`.
	//	*   `autoscaling.max_node_count`.
	//	*   `config.ssh_config.authorized_key`.
	//	*   `management.auto_repair`.
	//	*   `management`.
	UpdateMask *fieldmaskpb.FieldMask `protobuf:"bytes,3,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
}

func (x *UpdateAzureNodePoolRequest) Reset() {
	*x = UpdateAzureNodePoolRequest{}
	mi := &file_google_cloud_gkemulticloud_v1_azure_service_proto_msgTypes[7]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *UpdateAzureNodePoolRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateAzureNodePoolRequest) ProtoMessage() {}

func (x *UpdateAzureNodePoolRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_gkemulticloud_v1_azure_service_proto_msgTypes[7]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdateAzureNodePoolRequest.ProtoReflect.Descriptor instead.
func (*UpdateAzureNodePoolRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_gkemulticloud_v1_azure_service_proto_rawDescGZIP(), []int{7}
}

func (x *UpdateAzureNodePoolRequest) GetAzureNodePool() *AzureNodePool {
	if x != nil {
		return x.AzureNodePool
	}
	return nil
}

func (x *UpdateAzureNodePoolRequest) GetValidateOnly() bool {
	if x != nil {
		return x.ValidateOnly
	}
	return false
}

func (x *UpdateAzureNodePoolRequest) GetUpdateMask() *fieldmaskpb.FieldMask {
	if x != nil {
		return x.UpdateMask
	}
	return nil
}

// Request message for `AzureClusters.GetAzureNodePool` method.
//
// Deprecated: Marked as deprecated in google/cloud/gkemulticloud/v1/azure_service.proto.
type GetAzureNodePoolRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the
	// [AzureNodePool][google.cloud.gkemulticloud.v1.AzureNodePool] resource to
	// describe.
	//
	// `AzureNodePool` names are formatted as
	// `projects/<project-id>/locations/<region>/azureClusters/<cluster-id>/azureNodePools/<node-pool-id>`.
	//
	// See [Resource Names](https://cloud.google.com/apis/design/resource_names)
	// for more details on Google Cloud resource names.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *GetAzureNodePoolRequest) Reset() {
	*x = GetAzureNodePoolRequest{}
	mi := &file_google_cloud_gkemulticloud_v1_azure_service_proto_msgTypes[8]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GetAzureNodePoolRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetAzureNodePoolRequest) ProtoMessage() {}

func (x *GetAzureNodePoolRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_gkemulticloud_v1_azure_service_proto_msgTypes[8]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetAzureNodePoolRequest.ProtoReflect.Descriptor instead.
func (*GetAzureNodePoolRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_gkemulticloud_v1_azure_service_proto_rawDescGZIP(), []int{8}
}

func (x *GetAzureNodePoolRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Request message for `AzureClusters.ListAzureNodePools` method.
//
// Deprecated: Marked as deprecated in google/cloud/gkemulticloud/v1/azure_service.proto.
type ListAzureNodePoolsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The parent `AzureCluster` which owns this collection of
	// [AzureNodePool][google.cloud.gkemulticloud.v1.AzureNodePool] resources.
	//
	// `AzureCluster` names are formatted as
	// `projects/<project-id>/locations/<region>/azureClusters/<cluster-id>`.
	//
	// See [Resource Names](https://cloud.google.com/apis/design/resource_names)
	// for more details on Google Cloud resource names.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// The maximum number of items to return.
	//
	// If not specified, a default value of 50 will be used by the service.
	// Regardless of the pageSize value, the response can include a partial list
	// and a caller should only rely on response's
	// [nextPageToken][google.cloud.gkemulticloud.v1.ListAzureNodePoolsResponse.next_page_token]
	// to determine if there are more instances left to be queried.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// The `nextPageToken` value returned from a previous
	// [azureNodePools.list][google.cloud.gkemulticloud.v1.AzureClusters.ListAzureNodePools]
	// request, if any.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
}

func (x *ListAzureNodePoolsRequest) Reset() {
	*x = ListAzureNodePoolsRequest{}
	mi := &file_google_cloud_gkemulticloud_v1_azure_service_proto_msgTypes[9]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ListAzureNodePoolsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListAzureNodePoolsRequest) ProtoMessage() {}

func (x *ListAzureNodePoolsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_gkemulticloud_v1_azure_service_proto_msgTypes[9]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListAzureNodePoolsRequest.ProtoReflect.Descriptor instead.
func (*ListAzureNodePoolsRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_gkemulticloud_v1_azure_service_proto_rawDescGZIP(), []int{9}
}

func (x *ListAzureNodePoolsRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListAzureNodePoolsRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListAzureNodePoolsRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

// Response message for `AzureClusters.ListAzureNodePools` method.
//
// Deprecated: Marked as deprecated in google/cloud/gkemulticloud/v1/azure_service.proto.
type ListAzureNodePoolsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// A list of [AzureNodePool][google.cloud.gkemulticloud.v1.AzureNodePool]
	// resources in the specified `AzureCluster`.
	AzureNodePools []*AzureNodePool `protobuf:"bytes,1,rep,name=azure_node_pools,json=azureNodePools,proto3" json:"azure_node_pools,omitempty"`
	// Token to retrieve the next page of results, or empty if there are no more
	// results in the list.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
}

func (x *ListAzureNodePoolsResponse) Reset() {
	*x = ListAzureNodePoolsResponse{}
	mi := &file_google_cloud_gkemulticloud_v1_azure_service_proto_msgTypes[10]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ListAzureNodePoolsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListAzureNodePoolsResponse) ProtoMessage() {}

func (x *ListAzureNodePoolsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_gkemulticloud_v1_azure_service_proto_msgTypes[10]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListAzureNodePoolsResponse.ProtoReflect.Descriptor instead.
func (*ListAzureNodePoolsResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_gkemulticloud_v1_azure_service_proto_rawDescGZIP(), []int{10}
}

func (x *ListAzureNodePoolsResponse) GetAzureNodePools() []*AzureNodePool {
	if x != nil {
		return x.AzureNodePools
	}
	return nil
}

func (x *ListAzureNodePoolsResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

// Request message for `AzureClusters.DeleteAzureNodePool` method.
//
// Deprecated: Marked as deprecated in google/cloud/gkemulticloud/v1/azure_service.proto.
type DeleteAzureNodePoolRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The resource name the
	// [AzureNodePool][google.cloud.gkemulticloud.v1.AzureNodePool] to delete.
	//
	// `AzureNodePool` names are formatted as
	// `projects/<project-id>/locations/<region>/azureClusters/<cluster-id>/azureNodePools/<node-pool-id>`.
	//
	// See [Resource Names](https://cloud.google.com/apis/design/resource_names)
	// for more details on Google Cloud resource names.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// If set, only validate the request, but do not actually delete the node
	// pool.
	ValidateOnly bool `protobuf:"varint,2,opt,name=validate_only,json=validateOnly,proto3" json:"validate_only,omitempty"`
	// If set to true, and the
	// [AzureNodePool][google.cloud.gkemulticloud.v1.AzureNodePool] resource is
	// not found, the request will succeed but no action will be taken on the
	// server and a completed [Operation][google.longrunning.Operation] will be
	// returned.
	//
	// Useful for idempotent deletion.
	AllowMissing bool `protobuf:"varint,3,opt,name=allow_missing,json=allowMissing,proto3" json:"allow_missing,omitempty"`
	// The current ETag of the
	// [AzureNodePool][google.cloud.gkemulticloud.v1.AzureNodePool].
	//
	// Allows clients to perform deletions through optimistic concurrency control.
	//
	// If the provided ETag does not match the current etag of the node pool,
	// the request will fail and an ABORTED error will be returned.
	Etag string `protobuf:"bytes,4,opt,name=etag,proto3" json:"etag,omitempty"`
	// Optional. If set to true, the deletion of
	// [AzureNodePool][google.cloud.gkemulticloud.v1.AzureNodePool] resource will
	// succeed even if errors occur during deleting in node pool resources. Using
	// this parameter may result in orphaned resources in the node pool.
	IgnoreErrors bool `protobuf:"varint,5,opt,name=ignore_errors,json=ignoreErrors,proto3" json:"ignore_errors,omitempty"`
}

func (x *DeleteAzureNodePoolRequest) Reset() {
	*x = DeleteAzureNodePoolRequest{}
	mi := &file_google_cloud_gkemulticloud_v1_azure_service_proto_msgTypes[11]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *DeleteAzureNodePoolRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteAzureNodePoolRequest) ProtoMessage() {}

func (x *DeleteAzureNodePoolRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_gkemulticloud_v1_azure_service_proto_msgTypes[11]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeleteAzureNodePoolRequest.ProtoReflect.Descriptor instead.
func (*DeleteAzureNodePoolRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_gkemulticloud_v1_azure_service_proto_rawDescGZIP(), []int{11}
}

func (x *DeleteAzureNodePoolRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *DeleteAzureNodePoolRequest) GetValidateOnly() bool {
	if x != nil {
		return x.ValidateOnly
	}
	return false
}

func (x *DeleteAzureNodePoolRequest) GetAllowMissing() bool {
	if x != nil {
		return x.AllowMissing
	}
	return false
}

func (x *DeleteAzureNodePoolRequest) GetEtag() string {
	if x != nil {
		return x.Etag
	}
	return ""
}

func (x *DeleteAzureNodePoolRequest) GetIgnoreErrors() bool {
	if x != nil {
		return x.IgnoreErrors
	}
	return false
}

// GetAzureOpenIdConfigRequest gets the OIDC discovery document for the
// cluster. See the OpenID Connect Discovery 1.0 specification for details.
//
// Deprecated: Marked as deprecated in google/cloud/gkemulticloud/v1/azure_service.proto.
type GetAzureOpenIdConfigRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The AzureCluster, which owns the OIDC discovery document.
	// Format:
	// projects/<project-id>/locations/<region>/azureClusters/<cluster-id>
	AzureCluster string `protobuf:"bytes,1,opt,name=azure_cluster,json=azureCluster,proto3" json:"azure_cluster,omitempty"`
}

func (x *GetAzureOpenIdConfigRequest) Reset() {
	*x = GetAzureOpenIdConfigRequest{}
	mi := &file_google_cloud_gkemulticloud_v1_azure_service_proto_msgTypes[12]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GetAzureOpenIdConfigRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetAzureOpenIdConfigRequest) ProtoMessage() {}

func (x *GetAzureOpenIdConfigRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_gkemulticloud_v1_azure_service_proto_msgTypes[12]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetAzureOpenIdConfigRequest.ProtoReflect.Descriptor instead.
func (*GetAzureOpenIdConfigRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_gkemulticloud_v1_azure_service_proto_rawDescGZIP(), []int{12}
}

func (x *GetAzureOpenIdConfigRequest) GetAzureCluster() string {
	if x != nil {
		return x.AzureCluster
	}
	return ""
}

// GetAzureJsonWebKeysRequest gets the public component of the keys used by the
// cluster to sign token requests. This will be the jwks_uri for the discover
// document returned by getOpenIDConfig. See the OpenID Connect
// Discovery 1.0 specification for details.
//
// Deprecated: Marked as deprecated in google/cloud/gkemulticloud/v1/azure_service.proto.
type GetAzureJsonWebKeysRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The AzureCluster, which owns the JsonWebKeys.
	// Format:
	// `projects/<project-id>/locations/<region>/azureClusters/<cluster-id>`
	AzureCluster string `protobuf:"bytes,1,opt,name=azure_cluster,json=azureCluster,proto3" json:"azure_cluster,omitempty"`
}

func (x *GetAzureJsonWebKeysRequest) Reset() {
	*x = GetAzureJsonWebKeysRequest{}
	mi := &file_google_cloud_gkemulticloud_v1_azure_service_proto_msgTypes[13]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GetAzureJsonWebKeysRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetAzureJsonWebKeysRequest) ProtoMessage() {}

func (x *GetAzureJsonWebKeysRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_gkemulticloud_v1_azure_service_proto_msgTypes[13]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetAzureJsonWebKeysRequest.ProtoReflect.Descriptor instead.
func (*GetAzureJsonWebKeysRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_gkemulticloud_v1_azure_service_proto_rawDescGZIP(), []int{13}
}

func (x *GetAzureJsonWebKeysRequest) GetAzureCluster() string {
	if x != nil {
		return x.AzureCluster
	}
	return ""
}

// GetAzureServerConfigRequest gets the server config of GKE cluster on Azure.
//
// Deprecated: Marked as deprecated in google/cloud/gkemulticloud/v1/azure_service.proto.
type GetAzureServerConfigRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the
	// [AzureServerConfig][google.cloud.gkemulticloud.v1.AzureServerConfig]
	// resource to describe.
	//
	// `AzureServerConfig` names are formatted as
	// `projects/<project-id>/locations/<region>/azureServerConfig`.
	//
	// See [Resource Names](https://cloud.google.com/apis/design/resource_names)
	// for more details on Google Cloud resource names.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *GetAzureServerConfigRequest) Reset() {
	*x = GetAzureServerConfigRequest{}
	mi := &file_google_cloud_gkemulticloud_v1_azure_service_proto_msgTypes[14]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GetAzureServerConfigRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetAzureServerConfigRequest) ProtoMessage() {}

func (x *GetAzureServerConfigRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_gkemulticloud_v1_azure_service_proto_msgTypes[14]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetAzureServerConfigRequest.ProtoReflect.Descriptor instead.
func (*GetAzureServerConfigRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_gkemulticloud_v1_azure_service_proto_rawDescGZIP(), []int{14}
}

func (x *GetAzureServerConfigRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Request message for `AzureClusters.CreateAzureClient` method.
//
// Deprecated: Marked as deprecated in google/cloud/gkemulticloud/v1/azure_service.proto.
type CreateAzureClientRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The parent location where this
	// [AzureClient][google.cloud.gkemulticloud.v1.AzureClient] resource will be
	// created.
	//
	// Location names are formatted as `projects/<project-id>/locations/<region>`.
	//
	// See [Resource Names](https://cloud.google.com/apis/design/resource_names)
	// for more details on Google Cloud resource names.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. The specification of the
	// [AzureClient][google.cloud.gkemulticloud.v1.AzureClient] to create.
	AzureClient *AzureClient `protobuf:"bytes,2,opt,name=azure_client,json=azureClient,proto3" json:"azure_client,omitempty"`
	// Required. A client provided ID the resource. Must be unique within the
	// parent resource.
	//
	// The provided ID will be part of the
	// [AzureClient][google.cloud.gkemulticloud.v1.AzureClient] resource name
	// formatted as
	// `projects/<project-id>/locations/<region>/azureClients/<client-id>`.
	//
	// Valid characters are `/[a-z][0-9]-/`. Cannot be longer than 63 characters.
	AzureClientId string `protobuf:"bytes,4,opt,name=azure_client_id,json=azureClientId,proto3" json:"azure_client_id,omitempty"`
	// If set, only validate the request, but do not actually create the client.
	ValidateOnly bool `protobuf:"varint,3,opt,name=validate_only,json=validateOnly,proto3" json:"validate_only,omitempty"`
}

func (x *CreateAzureClientRequest) Reset() {
	*x = CreateAzureClientRequest{}
	mi := &file_google_cloud_gkemulticloud_v1_azure_service_proto_msgTypes[15]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *CreateAzureClientRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateAzureClientRequest) ProtoMessage() {}

func (x *CreateAzureClientRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_gkemulticloud_v1_azure_service_proto_msgTypes[15]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateAzureClientRequest.ProtoReflect.Descriptor instead.
func (*CreateAzureClientRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_gkemulticloud_v1_azure_service_proto_rawDescGZIP(), []int{15}
}

func (x *CreateAzureClientRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *CreateAzureClientRequest) GetAzureClient() *AzureClient {
	if x != nil {
		return x.AzureClient
	}
	return nil
}

func (x *CreateAzureClientRequest) GetAzureClientId() string {
	if x != nil {
		return x.AzureClientId
	}
	return ""
}

func (x *CreateAzureClientRequest) GetValidateOnly() bool {
	if x != nil {
		return x.ValidateOnly
	}
	return false
}

// Request message for `AzureClusters.GetAzureClient` method.
//
// Deprecated: Marked as deprecated in google/cloud/gkemulticloud/v1/azure_service.proto.
type GetAzureClientRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the
	// [AzureClient][google.cloud.gkemulticloud.v1.AzureClient] resource to
	// describe.
	//
	// [AzureClient][google.cloud.gkemulticloud.v1.AzureClient] names are
	// formatted as
	// `projects/<project-id>/locations/<region>/azureClients/<client-id>`.
	//
	// See [Resource Names](https://cloud.google.com/apis/design/resource_names)
	// for more details on Google Cloud resource names.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *GetAzureClientRequest) Reset() {
	*x = GetAzureClientRequest{}
	mi := &file_google_cloud_gkemulticloud_v1_azure_service_proto_msgTypes[16]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GetAzureClientRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetAzureClientRequest) ProtoMessage() {}

func (x *GetAzureClientRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_gkemulticloud_v1_azure_service_proto_msgTypes[16]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetAzureClientRequest.ProtoReflect.Descriptor instead.
func (*GetAzureClientRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_gkemulticloud_v1_azure_service_proto_rawDescGZIP(), []int{16}
}

func (x *GetAzureClientRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Request message for `AzureClusters.ListAzureClients` method.
//
// Deprecated: Marked as deprecated in google/cloud/gkemulticloud/v1/azure_service.proto.
type ListAzureClientsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The parent location which owns this collection of
	// [AzureClient][google.cloud.gkemulticloud.v1.AzureClient] resources.
	//
	// Location names are formatted as `projects/<project-id>/locations/<region>`.
	//
	// See [Resource Names](https://cloud.google.com/apis/design/resource_names)
	// for more details on Google Cloud Platform resource names.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// The maximum number of items to return.
	//
	// If not specified, a default value of 50 will be used by the service.
	// Regardless of the pageSize value, the response can include a partial list
	// and a caller should only rely on response's
	// [nextPageToken][google.cloud.gkemulticloud.v1.ListAzureClientsResponse.next_page_token]
	// to determine if there are more instances left to be queried.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// The `nextPageToken` value returned from a previous
	// [azureClients.list][google.cloud.gkemulticloud.v1.AzureClusters.ListAzureClients]
	// request, if any.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
}

func (x *ListAzureClientsRequest) Reset() {
	*x = ListAzureClientsRequest{}
	mi := &file_google_cloud_gkemulticloud_v1_azure_service_proto_msgTypes[17]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ListAzureClientsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListAzureClientsRequest) ProtoMessage() {}

func (x *ListAzureClientsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_gkemulticloud_v1_azure_service_proto_msgTypes[17]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListAzureClientsRequest.ProtoReflect.Descriptor instead.
func (*ListAzureClientsRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_gkemulticloud_v1_azure_service_proto_rawDescGZIP(), []int{17}
}

func (x *ListAzureClientsRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListAzureClientsRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListAzureClientsRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

// Response message for `AzureClusters.ListAzureClients` method.
//
// Deprecated: Marked as deprecated in google/cloud/gkemulticloud/v1/azure_service.proto.
type ListAzureClientsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// A list of [AzureClient][google.cloud.gkemulticloud.v1.AzureClient]
	// resources in the specified Google Cloud project and region region.
	AzureClients []*AzureClient `protobuf:"bytes,1,rep,name=azure_clients,json=azureClients,proto3" json:"azure_clients,omitempty"`
	// Token to retrieve the next page of results, or empty if there are no more
	// results in the list.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
}

func (x *ListAzureClientsResponse) Reset() {
	*x = ListAzureClientsResponse{}
	mi := &file_google_cloud_gkemulticloud_v1_azure_service_proto_msgTypes[18]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ListAzureClientsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListAzureClientsResponse) ProtoMessage() {}

func (x *ListAzureClientsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_gkemulticloud_v1_azure_service_proto_msgTypes[18]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListAzureClientsResponse.ProtoReflect.Descriptor instead.
func (*ListAzureClientsResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_gkemulticloud_v1_azure_service_proto_rawDescGZIP(), []int{18}
}

func (x *ListAzureClientsResponse) GetAzureClients() []*AzureClient {
	if x != nil {
		return x.AzureClients
	}
	return nil
}

func (x *ListAzureClientsResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

// Request message for `AzureClusters.DeleteAzureClient` method.
//
// Deprecated: Marked as deprecated in google/cloud/gkemulticloud/v1/azure_service.proto.
type DeleteAzureClientRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The resource name the
	// [AzureClient][google.cloud.gkemulticloud.v1.AzureClient] to delete.
	//
	// [AzureClient][google.cloud.gkemulticloud.v1.AzureClient] names are
	// formatted as
	// `projects/<project-id>/locations/<region>/azureClients/<client-id>`.
	//
	// See [Resource Names](https://cloud.google.com/apis/design/resource_names)
	// for more details on Google Cloud resource names.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// If set to true, and the
	// [AzureClient][google.cloud.gkemulticloud.v1.AzureClient] resource is not
	// found, the request will succeed but no action will be taken on the server
	// and a completed [Operation][google.longrunning.Operation] will be returned.
	//
	// Useful for idempotent deletion.
	AllowMissing bool `protobuf:"varint,2,opt,name=allow_missing,json=allowMissing,proto3" json:"allow_missing,omitempty"`
	// If set, only validate the request, but do not actually delete the resource.
	ValidateOnly bool `protobuf:"varint,3,opt,name=validate_only,json=validateOnly,proto3" json:"validate_only,omitempty"`
}

func (x *DeleteAzureClientRequest) Reset() {
	*x = DeleteAzureClientRequest{}
	mi := &file_google_cloud_gkemulticloud_v1_azure_service_proto_msgTypes[19]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *DeleteAzureClientRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteAzureClientRequest) ProtoMessage() {}

func (x *DeleteAzureClientRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_gkemulticloud_v1_azure_service_proto_msgTypes[19]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeleteAzureClientRequest.ProtoReflect.Descriptor instead.
func (*DeleteAzureClientRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_gkemulticloud_v1_azure_service_proto_rawDescGZIP(), []int{19}
}

func (x *DeleteAzureClientRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *DeleteAzureClientRequest) GetAllowMissing() bool {
	if x != nil {
		return x.AllowMissing
	}
	return false
}

func (x *DeleteAzureClientRequest) GetValidateOnly() bool {
	if x != nil {
		return x.ValidateOnly
	}
	return false
}

// Request message for `AzureClusters.GenerateAzureAccessToken` method.
//
// Deprecated: Marked as deprecated in google/cloud/gkemulticloud/v1/azure_service.proto.
type GenerateAzureAccessTokenRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the
	// [AzureCluster][google.cloud.gkemulticloud.v1.AzureCluster] resource to
	// authenticate to.
	//
	// `AzureCluster` names are formatted as
	// `projects/<project-id>/locations/<region>/azureClusters/<cluster-id>`.
	//
	// See [Resource Names](https://cloud.google.com/apis/design/resource_names)
	// for more details on Google Cloud resource names.
	AzureCluster string `protobuf:"bytes,1,opt,name=azure_cluster,json=azureCluster,proto3" json:"azure_cluster,omitempty"`
}

func (x *GenerateAzureAccessTokenRequest) Reset() {
	*x = GenerateAzureAccessTokenRequest{}
	mi := &file_google_cloud_gkemulticloud_v1_azure_service_proto_msgTypes[20]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GenerateAzureAccessTokenRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GenerateAzureAccessTokenRequest) ProtoMessage() {}

func (x *GenerateAzureAccessTokenRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_gkemulticloud_v1_azure_service_proto_msgTypes[20]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GenerateAzureAccessTokenRequest.ProtoReflect.Descriptor instead.
func (*GenerateAzureAccessTokenRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_gkemulticloud_v1_azure_service_proto_rawDescGZIP(), []int{20}
}

func (x *GenerateAzureAccessTokenRequest) GetAzureCluster() string {
	if x != nil {
		return x.AzureCluster
	}
	return ""
}

// Response message for `AzureClusters.GenerateAzureAccessToken` method.
//
// Deprecated: Marked as deprecated in google/cloud/gkemulticloud/v1/azure_service.proto.
type GenerateAzureAccessTokenResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. Access token to authenticate to k8s api-server.
	AccessToken string `protobuf:"bytes,1,opt,name=access_token,json=accessToken,proto3" json:"access_token,omitempty"`
	// Output only. Timestamp at which the token will expire.
	ExpirationTime *timestamppb.Timestamp `protobuf:"bytes,2,opt,name=expiration_time,json=expirationTime,proto3" json:"expiration_time,omitempty"`
}

func (x *GenerateAzureAccessTokenResponse) Reset() {
	*x = GenerateAzureAccessTokenResponse{}
	mi := &file_google_cloud_gkemulticloud_v1_azure_service_proto_msgTypes[21]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GenerateAzureAccessTokenResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GenerateAzureAccessTokenResponse) ProtoMessage() {}

func (x *GenerateAzureAccessTokenResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_gkemulticloud_v1_azure_service_proto_msgTypes[21]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GenerateAzureAccessTokenResponse.ProtoReflect.Descriptor instead.
func (*GenerateAzureAccessTokenResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_gkemulticloud_v1_azure_service_proto_rawDescGZIP(), []int{21}
}

func (x *GenerateAzureAccessTokenResponse) GetAccessToken() string {
	if x != nil {
		return x.AccessToken
	}
	return ""
}

func (x *GenerateAzureAccessTokenResponse) GetExpirationTime() *timestamppb.Timestamp {
	if x != nil {
		return x.ExpirationTime
	}
	return nil
}

// Deprecated: Marked as deprecated in google/cloud/gkemulticloud/v1/azure_service.proto.
type GenerateAzureClusterAgentTokenRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required.
	AzureCluster string `protobuf:"bytes,1,opt,name=azure_cluster,json=azureCluster,proto3" json:"azure_cluster,omitempty"`
	// Required.
	SubjectToken string `protobuf:"bytes,2,opt,name=subject_token,json=subjectToken,proto3" json:"subject_token,omitempty"`
	// Required.
	SubjectTokenType string `protobuf:"bytes,3,opt,name=subject_token_type,json=subjectTokenType,proto3" json:"subject_token_type,omitempty"`
	// Required.
	Version string `protobuf:"bytes,4,opt,name=version,proto3" json:"version,omitempty"`
	// Optional.
	NodePoolId string `protobuf:"bytes,5,opt,name=node_pool_id,json=nodePoolId,proto3" json:"node_pool_id,omitempty"`
	// Optional.
	GrantType string `protobuf:"bytes,6,opt,name=grant_type,json=grantType,proto3" json:"grant_type,omitempty"`
	// Optional.
	Audience string `protobuf:"bytes,7,opt,name=audience,proto3" json:"audience,omitempty"`
	// Optional.
	Scope string `protobuf:"bytes,8,opt,name=scope,proto3" json:"scope,omitempty"`
	// Optional.
	RequestedTokenType string `protobuf:"bytes,9,opt,name=requested_token_type,json=requestedTokenType,proto3" json:"requested_token_type,omitempty"`
	// Optional.
	Options string `protobuf:"bytes,10,opt,name=options,proto3" json:"options,omitempty"`
}

func (x *GenerateAzureClusterAgentTokenRequest) Reset() {
	*x = GenerateAzureClusterAgentTokenRequest{}
	mi := &file_google_cloud_gkemulticloud_v1_azure_service_proto_msgTypes[22]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GenerateAzureClusterAgentTokenRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GenerateAzureClusterAgentTokenRequest) ProtoMessage() {}

func (x *GenerateAzureClusterAgentTokenRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_gkemulticloud_v1_azure_service_proto_msgTypes[22]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GenerateAzureClusterAgentTokenRequest.ProtoReflect.Descriptor instead.
func (*GenerateAzureClusterAgentTokenRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_gkemulticloud_v1_azure_service_proto_rawDescGZIP(), []int{22}
}

func (x *GenerateAzureClusterAgentTokenRequest) GetAzureCluster() string {
	if x != nil {
		return x.AzureCluster
	}
	return ""
}

func (x *GenerateAzureClusterAgentTokenRequest) GetSubjectToken() string {
	if x != nil {
		return x.SubjectToken
	}
	return ""
}

func (x *GenerateAzureClusterAgentTokenRequest) GetSubjectTokenType() string {
	if x != nil {
		return x.SubjectTokenType
	}
	return ""
}

func (x *GenerateAzureClusterAgentTokenRequest) GetVersion() string {
	if x != nil {
		return x.Version
	}
	return ""
}

func (x *GenerateAzureClusterAgentTokenRequest) GetNodePoolId() string {
	if x != nil {
		return x.NodePoolId
	}
	return ""
}

func (x *GenerateAzureClusterAgentTokenRequest) GetGrantType() string {
	if x != nil {
		return x.GrantType
	}
	return ""
}

func (x *GenerateAzureClusterAgentTokenRequest) GetAudience() string {
	if x != nil {
		return x.Audience
	}
	return ""
}

func (x *GenerateAzureClusterAgentTokenRequest) GetScope() string {
	if x != nil {
		return x.Scope
	}
	return ""
}

func (x *GenerateAzureClusterAgentTokenRequest) GetRequestedTokenType() string {
	if x != nil {
		return x.RequestedTokenType
	}
	return ""
}

func (x *GenerateAzureClusterAgentTokenRequest) GetOptions() string {
	if x != nil {
		return x.Options
	}
	return ""
}

// Deprecated: Marked as deprecated in google/cloud/gkemulticloud/v1/azure_service.proto.
type GenerateAzureClusterAgentTokenResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	AccessToken string `protobuf:"bytes,1,opt,name=access_token,proto3" json:"access_token,omitempty"`
	ExpiresIn   int32  `protobuf:"varint,2,opt,name=expires_in,proto3" json:"expires_in,omitempty"`
	TokenType   string `protobuf:"bytes,3,opt,name=token_type,proto3" json:"token_type,omitempty"`
}

func (x *GenerateAzureClusterAgentTokenResponse) Reset() {
	*x = GenerateAzureClusterAgentTokenResponse{}
	mi := &file_google_cloud_gkemulticloud_v1_azure_service_proto_msgTypes[23]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GenerateAzureClusterAgentTokenResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GenerateAzureClusterAgentTokenResponse) ProtoMessage() {}

func (x *GenerateAzureClusterAgentTokenResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_gkemulticloud_v1_azure_service_proto_msgTypes[23]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GenerateAzureClusterAgentTokenResponse.ProtoReflect.Descriptor instead.
func (*GenerateAzureClusterAgentTokenResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_gkemulticloud_v1_azure_service_proto_rawDescGZIP(), []int{23}
}

func (x *GenerateAzureClusterAgentTokenResponse) GetAccessToken() string {
	if x != nil {
		return x.AccessToken
	}
	return ""
}

func (x *GenerateAzureClusterAgentTokenResponse) GetExpiresIn() int32 {
	if x != nil {
		return x.ExpiresIn
	}
	return 0
}

func (x *GenerateAzureClusterAgentTokenResponse) GetTokenType() string {
	if x != nil {
		return x.TokenType
	}
	return ""
}

var File_google_cloud_gkemulticloud_v1_azure_service_proto protoreflect.FileDescriptor

var file_google_cloud_gkemulticloud_v1_azure_service_proto_rawDesc = []byte{
	0x0a, 0x31, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x67,
	0x6b, 0x65, 0x6d, 0x75, 0x6c, 0x74, 0x69, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x76, 0x31, 0x2f,
	0x61, 0x7a, 0x75, 0x72, 0x65, 0x5f, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x12, 0x1d, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x67, 0x6b, 0x65, 0x6d, 0x75, 0x6c, 0x74, 0x69, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x76, 0x31, 0x1a, 0x1c, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x61,
	0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x1a, 0x17, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x63, 0x6c, 0x69,
	0x65, 0x6e, 0x74, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x62, 0x65, 0x68, 0x61,
	0x76, 0x69, 0x6f, 0x72, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x19, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x33, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2f, 0x67, 0x6b, 0x65, 0x6d, 0x75, 0x6c, 0x74, 0x69, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2f, 0x76, 0x31, 0x2f, 0x61, 0x7a, 0x75, 0x72, 0x65, 0x5f, 0x72, 0x65, 0x73, 0x6f, 0x75,
	0x72, 0x63, 0x65, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x34, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x67, 0x6b, 0x65, 0x6d, 0x75, 0x6c, 0x74,
	0x69, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x76, 0x31, 0x2f, 0x63, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e,
	0x5f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x1a, 0x23, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e,
	0x6e, 0x69, 0x6e, 0x67, 0x2f, 0x6f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1b, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x65, 0x6d, 0x70, 0x74, 0x79, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x1a, 0x20, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x62, 0x75, 0x66, 0x2f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x74, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0x95, 0x02, 0x0a, 0x19, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65,
	0x41, 0x7a, 0x75, 0x72, 0x65, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x12, 0x49, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x09, 0x42, 0x31, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x2b, 0x12, 0x29, 0x67, 0x6b, 0x65,
	0x6d, 0x75, 0x6c, 0x74, 0x69, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x41, 0x7a, 0x75, 0x72, 0x65, 0x43,
	0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x55,
	0x0a, 0x0d, 0x61, 0x7a, 0x75, 0x72, 0x65, 0x5f, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6b, 0x65, 0x6d, 0x75, 0x6c, 0x74, 0x69, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x7a, 0x75, 0x72, 0x65, 0x43, 0x6c, 0x75, 0x73, 0x74,
	0x65, 0x72, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0c, 0x61, 0x7a, 0x75, 0x72, 0x65, 0x43, 0x6c,
	0x75, 0x73, 0x74, 0x65, 0x72, 0x12, 0x2d, 0x0a, 0x10, 0x61, 0x7a, 0x75, 0x72, 0x65, 0x5f, 0x63,
	0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x5f, 0x69, 0x64, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x03, 0xe0, 0x41, 0x02, 0x52, 0x0e, 0x61, 0x7a, 0x75, 0x72, 0x65, 0x43, 0x6c, 0x75, 0x73, 0x74,
	0x65, 0x72, 0x49, 0x64, 0x12, 0x23, 0x0a, 0x0d, 0x76, 0x61, 0x6c, 0x69, 0x64, 0x61, 0x74, 0x65,
	0x5f, 0x6f, 0x6e, 0x6c, 0x79, 0x18, 0x04, 0x20, 0x01, 0x28, 0x08, 0x52, 0x0c, 0x76, 0x61, 0x6c,
	0x69, 0x64, 0x61, 0x74, 0x65, 0x4f, 0x6e, 0x6c, 0x79, 0x3a, 0x02, 0x18, 0x01, 0x22, 0xdd, 0x01,
	0x0a, 0x19, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x41, 0x7a, 0x75, 0x72, 0x65, 0x43, 0x6c, 0x75,
	0x73, 0x74, 0x65, 0x72, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x55, 0x0a, 0x0d, 0x61,
	0x7a, 0x75, 0x72, 0x65, 0x5f, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x2b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x67, 0x6b, 0x65, 0x6d, 0x75, 0x6c, 0x74, 0x69, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x76, 0x31, 0x2e, 0x41, 0x7a, 0x75, 0x72, 0x65, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x42,
	0x03, 0xe0, 0x41, 0x02, 0x52, 0x0c, 0x61, 0x7a, 0x75, 0x72, 0x65, 0x43, 0x6c, 0x75, 0x73, 0x74,
	0x65, 0x72, 0x12, 0x23, 0x0a, 0x0d, 0x76, 0x61, 0x6c, 0x69, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6f,
	0x6e, 0x6c, 0x79, 0x18, 0x02, 0x20, 0x01, 0x28, 0x08, 0x52, 0x0c, 0x76, 0x61, 0x6c, 0x69, 0x64,
	0x61, 0x74, 0x65, 0x4f, 0x6e, 0x6c, 0x79, 0x12, 0x40, 0x0a, 0x0b, 0x75, 0x70, 0x64, 0x61, 0x74,
	0x65, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x46,
	0x69, 0x65, 0x6c, 0x64, 0x4d, 0x61, 0x73, 0x6b, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0a, 0x75,
	0x70, 0x64, 0x61, 0x74, 0x65, 0x4d, 0x61, 0x73, 0x6b, 0x3a, 0x02, 0x18, 0x01, 0x22, 0x63, 0x0a,
	0x16, 0x47, 0x65, 0x74, 0x41, 0x7a, 0x75, 0x72, 0x65, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x45, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x31, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x2b, 0x0a, 0x29, 0x67,
	0x6b, 0x65, 0x6d, 0x75, 0x6c, 0x74, 0x69, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x41, 0x7a, 0x75, 0x72,
	0x65, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x3a, 0x02,
	0x18, 0x01, 0x22, 0xa5, 0x01, 0x0a, 0x18, 0x4c, 0x69, 0x73, 0x74, 0x41, 0x7a, 0x75, 0x72, 0x65,
	0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12,
	0x49, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x31, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x2b, 0x12, 0x29, 0x67, 0x6b, 0x65, 0x6d, 0x75, 0x6c, 0x74,
	0x69, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69,
	0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x41, 0x7a, 0x75, 0x72, 0x65, 0x43, 0x6c, 0x75, 0x73, 0x74,
	0x65, 0x72, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x1b, 0x0a, 0x09, 0x70, 0x61,
	0x67, 0x65, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x52, 0x08, 0x70,
	0x61, 0x67, 0x65, 0x53, 0x69, 0x7a, 0x65, 0x12, 0x1d, 0x0a, 0x0a, 0x70, 0x61, 0x67, 0x65, 0x5f,
	0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x70, 0x61, 0x67,
	0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x3a, 0x02, 0x18, 0x01, 0x22, 0x9b, 0x01, 0x0a, 0x19, 0x4c,
	0x69, 0x73, 0x74, 0x41, 0x7a, 0x75, 0x72, 0x65, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x73,
	0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x52, 0x0a, 0x0e, 0x61, 0x7a, 0x75, 0x72,
	0x65, 0x5f, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b,
	0x32, 0x2b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x67, 0x6b, 0x65, 0x6d, 0x75, 0x6c, 0x74, 0x69, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x31,
	0x2e, 0x41, 0x7a, 0x75, 0x72, 0x65, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x52, 0x0d, 0x61,
	0x7a, 0x75, 0x72, 0x65, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x73, 0x12, 0x26, 0x0a, 0x0f,
	0x6e, 0x65, 0x78, 0x74, 0x5f, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x6e, 0x65, 0x78, 0x74, 0x50, 0x61, 0x67, 0x65, 0x54,
	0x6f, 0x6b, 0x65, 0x6e, 0x3a, 0x02, 0x18, 0x01, 0x22, 0xee, 0x01, 0x0a, 0x19, 0x44, 0x65, 0x6c,
	0x65, 0x74, 0x65, 0x41, 0x7a, 0x75, 0x72, 0x65, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x45, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x31, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x2b, 0x0a, 0x29, 0x67, 0x6b,
	0x65, 0x6d, 0x75, 0x6c, 0x74, 0x69, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x41, 0x7a, 0x75, 0x72, 0x65,
	0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x23, 0x0a,
	0x0d, 0x61, 0x6c, 0x6c, 0x6f, 0x77, 0x5f, 0x6d, 0x69, 0x73, 0x73, 0x69, 0x6e, 0x67, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x08, 0x52, 0x0c, 0x61, 0x6c, 0x6c, 0x6f, 0x77, 0x4d, 0x69, 0x73, 0x73, 0x69,
	0x6e, 0x67, 0x12, 0x23, 0x0a, 0x0d, 0x76, 0x61, 0x6c, 0x69, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6f,
	0x6e, 0x6c, 0x79, 0x18, 0x03, 0x20, 0x01, 0x28, 0x08, 0x52, 0x0c, 0x76, 0x61, 0x6c, 0x69, 0x64,
	0x61, 0x74, 0x65, 0x4f, 0x6e, 0x6c, 0x79, 0x12, 0x12, 0x0a, 0x04, 0x65, 0x74, 0x61, 0x67, 0x18,
	0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x65, 0x74, 0x61, 0x67, 0x12, 0x28, 0x0a, 0x0d, 0x69,
	0x67, 0x6e, 0x6f, 0x72, 0x65, 0x5f, 0x65, 0x72, 0x72, 0x6f, 0x72, 0x73, 0x18, 0x05, 0x20, 0x01,
	0x28, 0x08, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0c, 0x69, 0x67, 0x6e, 0x6f, 0x72, 0x65, 0x45,
	0x72, 0x72, 0x6f, 0x72, 0x73, 0x3a, 0x02, 0x18, 0x01, 0x22, 0x9e, 0x02, 0x0a, 0x1a, 0x43, 0x72,
	0x65, 0x61, 0x74, 0x65, 0x41, 0x7a, 0x75, 0x72, 0x65, 0x4e, 0x6f, 0x64, 0x65, 0x50, 0x6f, 0x6f,
	0x6c, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x4a, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65,
	0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x32, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x2c,
	0x12, 0x2a, 0x67, 0x6b, 0x65, 0x6d, 0x75, 0x6c, 0x74, 0x69, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x41,
	0x7a, 0x75, 0x72, 0x65, 0x4e, 0x6f, 0x64, 0x65, 0x50, 0x6f, 0x6f, 0x6c, 0x52, 0x06, 0x70, 0x61,
	0x72, 0x65, 0x6e, 0x74, 0x12, 0x59, 0x0a, 0x0f, 0x61, 0x7a, 0x75, 0x72, 0x65, 0x5f, 0x6e, 0x6f,
	0x64, 0x65, 0x5f, 0x70, 0x6f, 0x6f, 0x6c, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2c, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6b, 0x65,
	0x6d, 0x75, 0x6c, 0x74, 0x69, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x7a,
	0x75, 0x72, 0x65, 0x4e, 0x6f, 0x64, 0x65, 0x50, 0x6f, 0x6f, 0x6c, 0x42, 0x03, 0xe0, 0x41, 0x02,
	0x52, 0x0d, 0x61, 0x7a, 0x75, 0x72, 0x65, 0x4e, 0x6f, 0x64, 0x65, 0x50, 0x6f, 0x6f, 0x6c, 0x12,
	0x30, 0x0a, 0x12, 0x61, 0x7a, 0x75, 0x72, 0x65, 0x5f, 0x6e, 0x6f, 0x64, 0x65, 0x5f, 0x70, 0x6f,
	0x6f, 0x6c, 0x5f, 0x69, 0x64, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02,
	0x52, 0x0f, 0x61, 0x7a, 0x75, 0x72, 0x65, 0x4e, 0x6f, 0x64, 0x65, 0x50, 0x6f, 0x6f, 0x6c, 0x49,
	0x64, 0x12, 0x23, 0x0a, 0x0d, 0x76, 0x61, 0x6c, 0x69, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6f, 0x6e,
	0x6c, 0x79, 0x18, 0x04, 0x20, 0x01, 0x28, 0x08, 0x52, 0x0c, 0x76, 0x61, 0x6c, 0x69, 0x64, 0x61,
	0x74, 0x65, 0x4f, 0x6e, 0x6c, 0x79, 0x3a, 0x02, 0x18, 0x01, 0x22, 0xe2, 0x01, 0x0a, 0x1a, 0x55,
	0x70, 0x64, 0x61, 0x74, 0x65, 0x41, 0x7a, 0x75, 0x72, 0x65, 0x4e, 0x6f, 0x64, 0x65, 0x50, 0x6f,
	0x6f, 0x6c, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x59, 0x0a, 0x0f, 0x61, 0x7a, 0x75,
	0x72, 0x65, 0x5f, 0x6e, 0x6f, 0x64, 0x65, 0x5f, 0x70, 0x6f, 0x6f, 0x6c, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x2c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x67, 0x6b, 0x65, 0x6d, 0x75, 0x6c, 0x74, 0x69, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x76, 0x31, 0x2e, 0x41, 0x7a, 0x75, 0x72, 0x65, 0x4e, 0x6f, 0x64, 0x65, 0x50, 0x6f, 0x6f, 0x6c,
	0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0d, 0x61, 0x7a, 0x75, 0x72, 0x65, 0x4e, 0x6f, 0x64, 0x65,
	0x50, 0x6f, 0x6f, 0x6c, 0x12, 0x23, 0x0a, 0x0d, 0x76, 0x61, 0x6c, 0x69, 0x64, 0x61, 0x74, 0x65,
	0x5f, 0x6f, 0x6e, 0x6c, 0x79, 0x18, 0x02, 0x20, 0x01, 0x28, 0x08, 0x52, 0x0c, 0x76, 0x61, 0x6c,
	0x69, 0x64, 0x61, 0x74, 0x65, 0x4f, 0x6e, 0x6c, 0x79, 0x12, 0x40, 0x0a, 0x0b, 0x75, 0x70, 0x64,
	0x61, 0x74, 0x65, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66,
	0x2e, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x4d, 0x61, 0x73, 0x6b, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52,
	0x0a, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x4d, 0x61, 0x73, 0x6b, 0x3a, 0x02, 0x18, 0x01, 0x22,
	0x65, 0x0a, 0x17, 0x47, 0x65, 0x74, 0x41, 0x7a, 0x75, 0x72, 0x65, 0x4e, 0x6f, 0x64, 0x65, 0x50,
	0x6f, 0x6f, 0x6c, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x46, 0x0a, 0x04, 0x6e, 0x61,
	0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x32, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x2c,
	0x0a, 0x2a, 0x67, 0x6b, 0x65, 0x6d, 0x75, 0x6c, 0x74, 0x69, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x41,
	0x7a, 0x75, 0x72, 0x65, 0x4e, 0x6f, 0x64, 0x65, 0x50, 0x6f, 0x6f, 0x6c, 0x52, 0x04, 0x6e, 0x61,
	0x6d, 0x65, 0x3a, 0x02, 0x18, 0x01, 0x22, 0xa7, 0x01, 0x0a, 0x19, 0x4c, 0x69, 0x73, 0x74, 0x41,
	0x7a, 0x75, 0x72, 0x65, 0x4e, 0x6f, 0x64, 0x65, 0x50, 0x6f, 0x6f, 0x6c, 0x73, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x12, 0x4a, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x32, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x2c, 0x12, 0x2a, 0x67, 0x6b,
	0x65, 0x6d, 0x75, 0x6c, 0x74, 0x69, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x41, 0x7a, 0x75, 0x72, 0x65,
	0x4e, 0x6f, 0x64, 0x65, 0x50, 0x6f, 0x6f, 0x6c, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74,
	0x12, 0x1b, 0x0a, 0x09, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x05, 0x52, 0x08, 0x70, 0x61, 0x67, 0x65, 0x53, 0x69, 0x7a, 0x65, 0x12, 0x1d, 0x0a,
	0x0a, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x09, 0x70, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x3a, 0x02, 0x18, 0x01,
	0x22, 0xa0, 0x01, 0x0a, 0x1a, 0x4c, 0x69, 0x73, 0x74, 0x41, 0x7a, 0x75, 0x72, 0x65, 0x4e, 0x6f,
	0x64, 0x65, 0x50, 0x6f, 0x6f, 0x6c, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12,
	0x56, 0x0a, 0x10, 0x61, 0x7a, 0x75, 0x72, 0x65, 0x5f, 0x6e, 0x6f, 0x64, 0x65, 0x5f, 0x70, 0x6f,
	0x6f, 0x6c, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2c, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6b, 0x65, 0x6d, 0x75, 0x6c, 0x74,
	0x69, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x7a, 0x75, 0x72, 0x65, 0x4e,
	0x6f, 0x64, 0x65, 0x50, 0x6f, 0x6f, 0x6c, 0x52, 0x0e, 0x61, 0x7a, 0x75, 0x72, 0x65, 0x4e, 0x6f,
	0x64, 0x65, 0x50, 0x6f, 0x6f, 0x6c, 0x73, 0x12, 0x26, 0x0a, 0x0f, 0x6e, 0x65, 0x78, 0x74, 0x5f,
	0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x0d, 0x6e, 0x65, 0x78, 0x74, 0x50, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x3a,
	0x02, 0x18, 0x01, 0x22, 0xf0, 0x01, 0x0a, 0x1a, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x41, 0x7a,
	0x75, 0x72, 0x65, 0x4e, 0x6f, 0x64, 0x65, 0x50, 0x6f, 0x6f, 0x6c, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x12, 0x46, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09,
	0x42, 0x32, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x2c, 0x0a, 0x2a, 0x67, 0x6b, 0x65, 0x6d, 0x75, 0x6c,
	0x74, 0x69, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70,
	0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x41, 0x7a, 0x75, 0x72, 0x65, 0x4e, 0x6f, 0x64, 0x65,
	0x50, 0x6f, 0x6f, 0x6c, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x23, 0x0a, 0x0d, 0x76, 0x61,
	0x6c, 0x69, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6f, 0x6e, 0x6c, 0x79, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x08, 0x52, 0x0c, 0x76, 0x61, 0x6c, 0x69, 0x64, 0x61, 0x74, 0x65, 0x4f, 0x6e, 0x6c, 0x79, 0x12,
	0x23, 0x0a, 0x0d, 0x61, 0x6c, 0x6c, 0x6f, 0x77, 0x5f, 0x6d, 0x69, 0x73, 0x73, 0x69, 0x6e, 0x67,
	0x18, 0x03, 0x20, 0x01, 0x28, 0x08, 0x52, 0x0c, 0x61, 0x6c, 0x6c, 0x6f, 0x77, 0x4d, 0x69, 0x73,
	0x73, 0x69, 0x6e, 0x67, 0x12, 0x12, 0x0a, 0x04, 0x65, 0x74, 0x61, 0x67, 0x18, 0x04, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x04, 0x65, 0x74, 0x61, 0x67, 0x12, 0x28, 0x0a, 0x0d, 0x69, 0x67, 0x6e, 0x6f,
	0x72, 0x65, 0x5f, 0x65, 0x72, 0x72, 0x6f, 0x72, 0x73, 0x18, 0x05, 0x20, 0x01, 0x28, 0x08, 0x42,
	0x03, 0xe0, 0x41, 0x01, 0x52, 0x0c, 0x69, 0x67, 0x6e, 0x6f, 0x72, 0x65, 0x45, 0x72, 0x72, 0x6f,
	0x72, 0x73, 0x3a, 0x02, 0x18, 0x01, 0x22, 0x79, 0x0a, 0x1b, 0x47, 0x65, 0x74, 0x41, 0x7a, 0x75,
	0x72, 0x65, 0x4f, 0x70, 0x65, 0x6e, 0x49, 0x64, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x56, 0x0a, 0x0d, 0x61, 0x7a, 0x75, 0x72, 0x65, 0x5f, 0x63,
	0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x31, 0xe0, 0x41,
	0x02, 0xfa, 0x41, 0x2b, 0x0a, 0x29, 0x67, 0x6b, 0x65, 0x6d, 0x75, 0x6c, 0x74, 0x69, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63,
	0x6f, 0x6d, 0x2f, 0x41, 0x7a, 0x75, 0x72, 0x65, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x52,
	0x0c, 0x61, 0x7a, 0x75, 0x72, 0x65, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x3a, 0x02, 0x18,
	0x01, 0x22, 0x78, 0x0a, 0x1a, 0x47, 0x65, 0x74, 0x41, 0x7a, 0x75, 0x72, 0x65, 0x4a, 0x73, 0x6f,
	0x6e, 0x57, 0x65, 0x62, 0x4b, 0x65, 0x79, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12,
	0x56, 0x0a, 0x0d, 0x61, 0x7a, 0x75, 0x72, 0x65, 0x5f, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x31, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x2b, 0x0a, 0x29,
	0x67, 0x6b, 0x65, 0x6d, 0x75, 0x6c, 0x74, 0x69, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x41, 0x7a, 0x75,
	0x72, 0x65, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x52, 0x0c, 0x61, 0x7a, 0x75, 0x72, 0x65,
	0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x3a, 0x02, 0x18, 0x01, 0x22, 0x6d, 0x0a, 0x1b, 0x47,
	0x65, 0x74, 0x41, 0x7a, 0x75, 0x72, 0x65, 0x53, 0x65, 0x72, 0x76, 0x65, 0x72, 0x43, 0x6f, 0x6e,
	0x66, 0x69, 0x67, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x4a, 0x0a, 0x04, 0x6e, 0x61,
	0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x36, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x30,
	0x0a, 0x2e, 0x67, 0x6b, 0x65, 0x6d, 0x75, 0x6c, 0x74, 0x69, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x41,
	0x7a, 0x75, 0x72, 0x65, 0x53, 0x65, 0x72, 0x76, 0x65, 0x72, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67,
	0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x3a, 0x02, 0x18, 0x01, 0x22, 0x8e, 0x02, 0x0a, 0x18, 0x43,
	0x72, 0x65, 0x61, 0x74, 0x65, 0x41, 0x7a, 0x75, 0x72, 0x65, 0x43, 0x6c, 0x69, 0x65, 0x6e, 0x74,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x48, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e,
	0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x30, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x2a, 0x12,
	0x28, 0x67, 0x6b, 0x65, 0x6d, 0x75, 0x6c, 0x74, 0x69, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x41, 0x7a,
	0x75, 0x72, 0x65, 0x43, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e,
	0x74, 0x12, 0x52, 0x0a, 0x0c, 0x61, 0x7a, 0x75, 0x72, 0x65, 0x5f, 0x63, 0x6c, 0x69, 0x65, 0x6e,
	0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6b, 0x65, 0x6d, 0x75, 0x6c, 0x74, 0x69, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x7a, 0x75, 0x72, 0x65, 0x43, 0x6c, 0x69,
	0x65, 0x6e, 0x74, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0b, 0x61, 0x7a, 0x75, 0x72, 0x65, 0x43,
	0x6c, 0x69, 0x65, 0x6e, 0x74, 0x12, 0x2b, 0x0a, 0x0f, 0x61, 0x7a, 0x75, 0x72, 0x65, 0x5f, 0x63,
	0x6c, 0x69, 0x65, 0x6e, 0x74, 0x5f, 0x69, 0x64, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03,
	0xe0, 0x41, 0x02, 0x52, 0x0d, 0x61, 0x7a, 0x75, 0x72, 0x65, 0x43, 0x6c, 0x69, 0x65, 0x6e, 0x74,
	0x49, 0x64, 0x12, 0x23, 0x0a, 0x0d, 0x76, 0x61, 0x6c, 0x69, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6f,
	0x6e, 0x6c, 0x79, 0x18, 0x03, 0x20, 0x01, 0x28, 0x08, 0x52, 0x0c, 0x76, 0x61, 0x6c, 0x69, 0x64,
	0x61, 0x74, 0x65, 0x4f, 0x6e, 0x6c, 0x79, 0x3a, 0x02, 0x18, 0x01, 0x22, 0x61, 0x0a, 0x15, 0x47,
	0x65, 0x74, 0x41, 0x7a, 0x75, 0x72, 0x65, 0x43, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x12, 0x44, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x42, 0x30, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x2a, 0x0a, 0x28, 0x67, 0x6b, 0x65, 0x6d,
	0x75, 0x6c, 0x74, 0x69, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x41, 0x7a, 0x75, 0x72, 0x65, 0x43, 0x6c,
	0x69, 0x65, 0x6e, 0x74, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x3a, 0x02, 0x18, 0x01, 0x22, 0xa3,
	0x01, 0x0a, 0x17, 0x4c, 0x69, 0x73, 0x74, 0x41, 0x7a, 0x75, 0x72, 0x65, 0x43, 0x6c, 0x69, 0x65,
	0x6e, 0x74, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x48, 0x0a, 0x06, 0x70, 0x61,
	0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x30, 0xe0, 0x41, 0x02, 0xfa,
	0x41, 0x2a, 0x12, 0x28, 0x67, 0x6b, 0x65, 0x6d, 0x75, 0x6c, 0x74, 0x69, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d,
	0x2f, 0x41, 0x7a, 0x75, 0x72, 0x65, 0x43, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x52, 0x06, 0x70, 0x61,
	0x72, 0x65, 0x6e, 0x74, 0x12, 0x1b, 0x0a, 0x09, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x73, 0x69, 0x7a,
	0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x52, 0x08, 0x70, 0x61, 0x67, 0x65, 0x53, 0x69, 0x7a,
	0x65, 0x12, 0x1d, 0x0a, 0x0a, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18,
	0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x70, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e,
	0x3a, 0x02, 0x18, 0x01, 0x22, 0x97, 0x01, 0x0a, 0x18, 0x4c, 0x69, 0x73, 0x74, 0x41, 0x7a, 0x75,
	0x72, 0x65, 0x43, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73,
	0x65, 0x12, 0x4f, 0x0a, 0x0d, 0x61, 0x7a, 0x75, 0x72, 0x65, 0x5f, 0x63, 0x6c, 0x69, 0x65, 0x6e,
	0x74, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6b, 0x65, 0x6d, 0x75, 0x6c, 0x74, 0x69,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x7a, 0x75, 0x72, 0x65, 0x43, 0x6c,
	0x69, 0x65, 0x6e, 0x74, 0x52, 0x0c, 0x61, 0x7a, 0x75, 0x72, 0x65, 0x43, 0x6c, 0x69, 0x65, 0x6e,
	0x74, 0x73, 0x12, 0x26, 0x0a, 0x0f, 0x6e, 0x65, 0x78, 0x74, 0x5f, 0x70, 0x61, 0x67, 0x65, 0x5f,
	0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x6e, 0x65, 0x78,
	0x74, 0x50, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x3a, 0x02, 0x18, 0x01, 0x22, 0xae,
	0x01, 0x0a, 0x18, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x41, 0x7a, 0x75, 0x72, 0x65, 0x43, 0x6c,
	0x69, 0x65, 0x6e, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x44, 0x0a, 0x04, 0x6e,
	0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x30, 0xe0, 0x41, 0x02, 0xfa, 0x41,
	0x2a, 0x0a, 0x28, 0x67, 0x6b, 0x65, 0x6d, 0x75, 0x6c, 0x74, 0x69, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f,
	0x41, 0x7a, 0x75, 0x72, 0x65, 0x43, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x52, 0x04, 0x6e, 0x61, 0x6d,
	0x65, 0x12, 0x23, 0x0a, 0x0d, 0x61, 0x6c, 0x6c, 0x6f, 0x77, 0x5f, 0x6d, 0x69, 0x73, 0x73, 0x69,
	0x6e, 0x67, 0x18, 0x02, 0x20, 0x01, 0x28, 0x08, 0x52, 0x0c, 0x61, 0x6c, 0x6c, 0x6f, 0x77, 0x4d,
	0x69, 0x73, 0x73, 0x69, 0x6e, 0x67, 0x12, 0x23, 0x0a, 0x0d, 0x76, 0x61, 0x6c, 0x69, 0x64, 0x61,
	0x74, 0x65, 0x5f, 0x6f, 0x6e, 0x6c, 0x79, 0x18, 0x03, 0x20, 0x01, 0x28, 0x08, 0x52, 0x0c, 0x76,
	0x61, 0x6c, 0x69, 0x64, 0x61, 0x74, 0x65, 0x4f, 0x6e, 0x6c, 0x79, 0x3a, 0x02, 0x18, 0x01, 0x22,
	0x7d, 0x0a, 0x1f, 0x47, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x65, 0x41, 0x7a, 0x75, 0x72, 0x65,
	0x41, 0x63, 0x63, 0x65, 0x73, 0x73, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x12, 0x56, 0x0a, 0x0d, 0x61, 0x7a, 0x75, 0x72, 0x65, 0x5f, 0x63, 0x6c, 0x75, 0x73,
	0x74, 0x65, 0x72, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x31, 0xe0, 0x41, 0x02, 0xfa, 0x41,
	0x2b, 0x0a, 0x29, 0x67, 0x6b, 0x65, 0x6d, 0x75, 0x6c, 0x74, 0x69, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f,
	0x41, 0x7a, 0x75, 0x72, 0x65, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x52, 0x0c, 0x61, 0x7a,
	0x75, 0x72, 0x65, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x3a, 0x02, 0x18, 0x01, 0x22, 0x98,
	0x01, 0x0a, 0x20, 0x47, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x65, 0x41, 0x7a, 0x75, 0x72, 0x65,
	0x41, 0x63, 0x63, 0x65, 0x73, 0x73, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x52, 0x65, 0x73, 0x70, 0x6f,
	0x6e, 0x73, 0x65, 0x12, 0x26, 0x0a, 0x0c, 0x61, 0x63, 0x63, 0x65, 0x73, 0x73, 0x5f, 0x74, 0x6f,
	0x6b, 0x65, 0x6e, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0b,
	0x61, 0x63, 0x63, 0x65, 0x73, 0x73, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x12, 0x48, 0x0a, 0x0f, 0x65,
	0x78, 0x70, 0x69, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70,
	0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0e, 0x65, 0x78, 0x70, 0x69, 0x72, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x54, 0x69, 0x6d, 0x65, 0x3a, 0x02, 0x18, 0x01, 0x22, 0xdc, 0x03, 0x0a, 0x25, 0x47, 0x65,
	0x6e, 0x65, 0x72, 0x61, 0x74, 0x65, 0x41, 0x7a, 0x75, 0x72, 0x65, 0x43, 0x6c, 0x75, 0x73, 0x74,
	0x65, 0x72, 0x41, 0x67, 0x65, 0x6e, 0x74, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x12, 0x56, 0x0a, 0x0d, 0x61, 0x7a, 0x75, 0x72, 0x65, 0x5f, 0x63, 0x6c, 0x75,
	0x73, 0x74, 0x65, 0x72, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x31, 0xe0, 0x41, 0x02, 0xfa,
	0x41, 0x2b, 0x0a, 0x29, 0x67, 0x6b, 0x65, 0x6d, 0x75, 0x6c, 0x74, 0x69, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d,
	0x2f, 0x41, 0x7a, 0x75, 0x72, 0x65, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x52, 0x0c, 0x61,
	0x7a, 0x75, 0x72, 0x65, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x12, 0x28, 0x0a, 0x0d, 0x73,
	0x75, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0c, 0x73, 0x75, 0x62, 0x6a, 0x65, 0x63, 0x74,
	0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x12, 0x31, 0x0a, 0x12, 0x73, 0x75, 0x62, 0x6a, 0x65, 0x63, 0x74,
	0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28,
	0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x10, 0x73, 0x75, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x54,
	0x6f, 0x6b, 0x65, 0x6e, 0x54, 0x79, 0x70, 0x65, 0x12, 0x1d, 0x0a, 0x07, 0x76, 0x65, 0x72, 0x73,
	0x69, 0x6f, 0x6e, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x07,
	0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x25, 0x0a, 0x0c, 0x6e, 0x6f, 0x64, 0x65, 0x5f,
	0x70, 0x6f, 0x6f, 0x6c, 0x5f, 0x69, 0x64, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0,
	0x41, 0x01, 0x52, 0x0a, 0x6e, 0x6f, 0x64, 0x65, 0x50, 0x6f, 0x6f, 0x6c, 0x49, 0x64, 0x12, 0x22,
	0x0a, 0x0a, 0x67, 0x72, 0x61, 0x6e, 0x74, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x06, 0x20, 0x01,
	0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x09, 0x67, 0x72, 0x61, 0x6e, 0x74, 0x54, 0x79,
	0x70, 0x65, 0x12, 0x1f, 0x0a, 0x08, 0x61, 0x75, 0x64, 0x69, 0x65, 0x6e, 0x63, 0x65, 0x18, 0x07,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x08, 0x61, 0x75, 0x64, 0x69, 0x65,
	0x6e, 0x63, 0x65, 0x12, 0x19, 0x0a, 0x05, 0x73, 0x63, 0x6f, 0x70, 0x65, 0x18, 0x08, 0x20, 0x01,
	0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x05, 0x73, 0x63, 0x6f, 0x70, 0x65, 0x12, 0x35,
	0x0a, 0x14, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x65, 0x64, 0x5f, 0x74, 0x6f, 0x6b, 0x65,
	0x6e, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x09, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41,
	0x01, 0x52, 0x12, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x65, 0x64, 0x54, 0x6f, 0x6b, 0x65,
	0x6e, 0x54, 0x79, 0x70, 0x65, 0x12, 0x1d, 0x0a, 0x07, 0x6f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73,
	0x18, 0x0a, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x07, 0x6f, 0x70, 0x74,
	0x69, 0x6f, 0x6e, 0x73, 0x3a, 0x02, 0x18, 0x01, 0x22, 0x90, 0x01, 0x0a, 0x26, 0x47, 0x65, 0x6e,
	0x65, 0x72, 0x61, 0x74, 0x65, 0x41, 0x7a, 0x75, 0x72, 0x65, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65,
	0x72, 0x41, 0x67, 0x65, 0x6e, 0x74, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x52, 0x65, 0x73, 0x70, 0x6f,
	0x6e, 0x73, 0x65, 0x12, 0x22, 0x0a, 0x0c, 0x61, 0x63, 0x63, 0x65, 0x73, 0x73, 0x5f, 0x74, 0x6f,
	0x6b, 0x65, 0x6e, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0c, 0x61, 0x63, 0x63, 0x65, 0x73,
	0x73, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x12, 0x1e, 0x0a, 0x0a, 0x65, 0x78, 0x70, 0x69, 0x72,
	0x65, 0x73, 0x5f, 0x69, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x52, 0x0a, 0x65, 0x78, 0x70,
	0x69, 0x72, 0x65, 0x73, 0x5f, 0x69, 0x6e, 0x12, 0x1e, 0x0a, 0x0a, 0x74, 0x6f, 0x6b, 0x65, 0x6e,
	0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0a, 0x74, 0x6f, 0x6b,
	0x65, 0x6e, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x3a, 0x02, 0x18, 0x01, 0x32, 0x89, 0x24, 0x0a, 0x0d,
	0x41, 0x7a, 0x75, 0x72, 0x65, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x73, 0x12, 0x80, 0x02,
	0x0a, 0x11, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x41, 0x7a, 0x75, 0x72, 0x65, 0x43, 0x6c, 0x69,
	0x65, 0x6e, 0x74, 0x12, 0x37, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x67, 0x6b, 0x65, 0x6d, 0x75, 0x6c, 0x74, 0x69, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x76, 0x31, 0x2e, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x41, 0x7a, 0x75, 0x72, 0x65, 0x43,
	0x6c, 0x69, 0x65, 0x6e, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e,
	0x67, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x92, 0x01, 0xca, 0x41,
	0x20, 0x0a, 0x0b, 0x41, 0x7a, 0x75, 0x72, 0x65, 0x43, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x12, 0x11,
	0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74,
	0x61, 0xda, 0x41, 0x23, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x2c, 0x61, 0x7a, 0x75, 0x72, 0x65,
	0x5f, 0x63, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x2c, 0x61, 0x7a, 0x75, 0x72, 0x65, 0x5f, 0x63, 0x6c,
	0x69, 0x65, 0x6e, 0x74, 0x5f, 0x69, 0x64, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x40, 0x3a, 0x0c, 0x61,
	0x7a, 0x75, 0x72, 0x65, 0x5f, 0x63, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x22, 0x30, 0x2f, 0x76, 0x31,
	0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74,
	0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d,
	0x2f, 0x61, 0x7a, 0x75, 0x72, 0x65, 0x43, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x73, 0x88, 0x02, 0x01,
	0x12, 0xb6, 0x01, 0x0a, 0x0e, 0x47, 0x65, 0x74, 0x41, 0x7a, 0x75, 0x72, 0x65, 0x43, 0x6c, 0x69,
	0x65, 0x6e, 0x74, 0x12, 0x34, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x67, 0x6b, 0x65, 0x6d, 0x75, 0x6c, 0x74, 0x69, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x76, 0x31, 0x2e, 0x47, 0x65, 0x74, 0x41, 0x7a, 0x75, 0x72, 0x65, 0x43, 0x6c, 0x69, 0x65,
	0x6e, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x2a, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6b, 0x65, 0x6d, 0x75, 0x6c, 0x74,
	0x69, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x7a, 0x75, 0x72, 0x65, 0x43,
	0x6c, 0x69, 0x65, 0x6e, 0x74, 0x22, 0x42, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x82, 0xd3,
	0xe4, 0x93, 0x02, 0x32, 0x12, 0x30, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d,
	0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x61, 0x7a, 0x75, 0x72, 0x65, 0x43, 0x6c, 0x69, 0x65,
	0x6e, 0x74, 0x73, 0x2f, 0x2a, 0x7d, 0x88, 0x02, 0x01, 0x12, 0xc9, 0x01, 0x0a, 0x10, 0x4c, 0x69,
	0x73, 0x74, 0x41, 0x7a, 0x75, 0x72, 0x65, 0x43, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x73, 0x12, 0x36,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6b,
	0x65, 0x6d, 0x75, 0x6c, 0x74, 0x69, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x31, 0x2e, 0x4c,
	0x69, 0x73, 0x74, 0x41, 0x7a, 0x75, 0x72, 0x65, 0x43, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x73, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x37, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6b, 0x65, 0x6d, 0x75, 0x6c, 0x74, 0x69, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x41, 0x7a, 0x75, 0x72, 0x65,
	0x43, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22,
	0x44, 0xda, 0x41, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x32,
	0x12, 0x30, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72,
	0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x61, 0x7a, 0x75, 0x72, 0x65, 0x43, 0x6c, 0x69, 0x65, 0x6e,
	0x74, 0x73, 0x88, 0x02, 0x01, 0x12, 0xdc, 0x01, 0x0a, 0x11, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65,
	0x41, 0x7a, 0x75, 0x72, 0x65, 0x43, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x12, 0x37, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6b, 0x65, 0x6d, 0x75,
	0x6c, 0x74, 0x69, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x65, 0x6c, 0x65,
	0x74, 0x65, 0x41, 0x7a, 0x75, 0x72, 0x65, 0x43, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6c, 0x6f,
	0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x22, 0x6f, 0xca, 0x41, 0x2a, 0x0a, 0x15, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x45, 0x6d, 0x70, 0x74, 0x79, 0x12,
	0x11, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61,
	0x74, 0x61, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x32, 0x2a,
	0x30, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65,
	0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f,
	0x2a, 0x2f, 0x61, 0x7a, 0x75, 0x72, 0x65, 0x43, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x73, 0x2f, 0x2a,
	0x7d, 0x88, 0x02, 0x01, 0x12, 0x87, 0x02, 0x0a, 0x12, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x41,
	0x7a, 0x75, 0x72, 0x65, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x12, 0x38, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6b, 0x65, 0x6d, 0x75,
	0x6c, 0x74, 0x69, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x72, 0x65, 0x61,
	0x74, 0x65, 0x41, 0x7a, 0x75, 0x72, 0x65, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6c,
	0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x22, 0x97, 0x01, 0xca, 0x41, 0x21, 0x0a, 0x0c, 0x41, 0x7a, 0x75, 0x72,
	0x65, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x12, 0x11, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0xda, 0x41, 0x25, 0x70, 0x61,
	0x72, 0x65, 0x6e, 0x74, 0x2c, 0x61, 0x7a, 0x75, 0x72, 0x65, 0x5f, 0x63, 0x6c, 0x75, 0x73, 0x74,
	0x65, 0x72, 0x2c, 0x61, 0x7a, 0x75, 0x72, 0x65, 0x5f, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72,
	0x5f, 0x69, 0x64, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x42, 0x3a, 0x0d, 0x61, 0x7a, 0x75, 0x72, 0x65,
	0x5f, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x22, 0x31, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x70,
	0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a,
	0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x61, 0x7a,
	0x75, 0x72, 0x65, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x73, 0x88, 0x02, 0x01, 0x12, 0x89,
	0x02, 0x0a, 0x12, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x41, 0x7a, 0x75, 0x72, 0x65, 0x43, 0x6c,
	0x75, 0x73, 0x74, 0x65, 0x72, 0x12, 0x38, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6b, 0x65, 0x6d, 0x75, 0x6c, 0x74, 0x69, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x76, 0x31, 0x2e, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x41, 0x7a, 0x75, 0x72,
	0x65, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a,
	0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e,
	0x6e, 0x69, 0x6e, 0x67, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x99,
	0x01, 0xca, 0x41, 0x21, 0x0a, 0x0c, 0x41, 0x7a, 0x75, 0x72, 0x65, 0x43, 0x6c, 0x75, 0x73, 0x74,
	0x65, 0x72, 0x12, 0x11, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74,
	0x61, 0x64, 0x61, 0x74, 0x61, 0xda, 0x41, 0x19, 0x61, 0x7a, 0x75, 0x72, 0x65, 0x5f, 0x63, 0x6c,
	0x75, 0x73, 0x74, 0x65, 0x72, 0x2c, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6d, 0x61, 0x73,
	0x6b, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x50, 0x3a, 0x0d, 0x61, 0x7a, 0x75, 0x72, 0x65, 0x5f, 0x63,
	0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x32, 0x3f, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x61, 0x7a, 0x75,
	0x72, 0x65, 0x5f, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x2e, 0x6e, 0x61, 0x6d, 0x65, 0x3d,
	0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x61, 0x7a, 0x75, 0x72, 0x65, 0x43, 0x6c, 0x75, 0x73,
	0x74, 0x65, 0x72, 0x73, 0x2f, 0x2a, 0x7d, 0x88, 0x02, 0x01, 0x12, 0xba, 0x01, 0x0a, 0x0f, 0x47,
	0x65, 0x74, 0x41, 0x7a, 0x75, 0x72, 0x65, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x12, 0x35,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6b,
	0x65, 0x6d, 0x75, 0x6c, 0x74, 0x69, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x31, 0x2e, 0x47,
	0x65, 0x74, 0x41, 0x7a, 0x75, 0x72, 0x65, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x2b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6b, 0x65, 0x6d, 0x75, 0x6c, 0x74, 0x69, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x7a, 0x75, 0x72, 0x65, 0x43, 0x6c, 0x75, 0x73, 0x74,
	0x65, 0x72, 0x22, 0x43, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x82, 0xd3, 0xe4, 0x93, 0x02,
	0x33, 0x12, 0x31, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f,
	0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x73, 0x2f, 0x2a, 0x2f, 0x61, 0x7a, 0x75, 0x72, 0x65, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72,
	0x73, 0x2f, 0x2a, 0x7d, 0x88, 0x02, 0x01, 0x12, 0xcd, 0x01, 0x0a, 0x11, 0x4c, 0x69, 0x73, 0x74,
	0x41, 0x7a, 0x75, 0x72, 0x65, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x73, 0x12, 0x37, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6b, 0x65,
	0x6d, 0x75, 0x6c, 0x74, 0x69, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69,
	0x73, 0x74, 0x41, 0x7a, 0x75, 0x72, 0x65, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x73, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x38, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6b, 0x65, 0x6d, 0x75, 0x6c, 0x74, 0x69, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x41, 0x7a, 0x75, 0x72, 0x65,
	0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65,
	0x22, 0x45, 0xda, 0x41, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x82, 0xd3, 0xe4, 0x93, 0x02,
	0x33, 0x12, 0x31, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70,
	0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x61, 0x7a, 0x75, 0x72, 0x65, 0x43, 0x6c, 0x75, 0x73,
	0x74, 0x65, 0x72, 0x73, 0x88, 0x02, 0x01, 0x12, 0xdf, 0x01, 0x0a, 0x12, 0x44, 0x65, 0x6c, 0x65,
	0x74, 0x65, 0x41, 0x7a, 0x75, 0x72, 0x65, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x12, 0x38,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6b,
	0x65, 0x6d, 0x75, 0x6c, 0x74, 0x69, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x31, 0x2e, 0x44,
	0x65, 0x6c, 0x65, 0x74, 0x65, 0x41, 0x7a, 0x75, 0x72, 0x65, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65,
	0x72, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2e, 0x4f, 0x70,
	0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x70, 0xca, 0x41, 0x2a, 0x0a, 0x15, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x45, 0x6d,
	0x70, 0x74, 0x79, 0x12, 0x11, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65,
	0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x82, 0xd3, 0xe4,
	0x93, 0x02, 0x33, 0x2a, 0x31, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70,
	0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x61, 0x7a, 0x75, 0x72, 0x65, 0x43, 0x6c, 0x75, 0x73, 0x74,
	0x65, 0x72, 0x73, 0x2f, 0x2a, 0x7d, 0x88, 0x02, 0x01, 0x12, 0x96, 0x02, 0x0a, 0x1e, 0x47, 0x65,
	0x6e, 0x65, 0x72, 0x61, 0x74, 0x65, 0x41, 0x7a, 0x75, 0x72, 0x65, 0x43, 0x6c, 0x75, 0x73, 0x74,
	0x65, 0x72, 0x41, 0x67, 0x65, 0x6e, 0x74, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x12, 0x44, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6b, 0x65, 0x6d,
	0x75, 0x6c, 0x74, 0x69, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x31, 0x2e, 0x47, 0x65, 0x6e,
	0x65, 0x72, 0x61, 0x74, 0x65, 0x41, 0x7a, 0x75, 0x72, 0x65, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65,
	0x72, 0x41, 0x67, 0x65, 0x6e, 0x74, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x1a, 0x45, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x67, 0x6b, 0x65, 0x6d, 0x75, 0x6c, 0x74, 0x69, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x76, 0x31, 0x2e, 0x47, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x65, 0x41, 0x7a, 0x75, 0x72, 0x65,
	0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x41, 0x67, 0x65, 0x6e, 0x74, 0x54, 0x6f, 0x6b, 0x65,
	0x6e, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x67, 0x82, 0xd3, 0xe4, 0x93, 0x02,
	0x5e, 0x3a, 0x01, 0x2a, 0x22, 0x59, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x61, 0x7a, 0x75, 0x72, 0x65,
	0x5f, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74,
	0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f,
	0x61, 0x7a, 0x75, 0x72, 0x65, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x73, 0x2f, 0x2a, 0x7d,
	0x3a, 0x67, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x65, 0x41, 0x7a, 0x75, 0x72, 0x65, 0x43, 0x6c,
	0x75, 0x73, 0x74, 0x65, 0x72, 0x41, 0x67, 0x65, 0x6e, 0x74, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x88,
	0x02, 0x01, 0x12, 0xfb, 0x01, 0x0a, 0x18, 0x47, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x65, 0x41,
	0x7a, 0x75, 0x72, 0x65, 0x41, 0x63, 0x63, 0x65, 0x73, 0x73, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x12,
	0x3e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67,
	0x6b, 0x65, 0x6d, 0x75, 0x6c, 0x74, 0x69, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x31, 0x2e,
	0x47, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x65, 0x41, 0x7a, 0x75, 0x72, 0x65, 0x41, 0x63, 0x63,
	0x65, 0x73, 0x73, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a,
	0x3f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67,
	0x6b, 0x65, 0x6d, 0x75, 0x6c, 0x74, 0x69, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x31, 0x2e,
	0x47, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x65, 0x41, 0x7a, 0x75, 0x72, 0x65, 0x41, 0x63, 0x63,
	0x65, 0x73, 0x73, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65,
	0x22, 0x5e, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x55, 0x12, 0x53, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x61,
	0x7a, 0x75, 0x72, 0x65, 0x5f, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x3d, 0x70, 0x72, 0x6f,
	0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x73, 0x2f, 0x2a, 0x2f, 0x61, 0x7a, 0x75, 0x72, 0x65, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72,
	0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x67, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x65, 0x41, 0x7a, 0x75,
	0x72, 0x65, 0x41, 0x63, 0x63, 0x65, 0x73, 0x73, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x88, 0x02, 0x01,
	0x12, 0xa1, 0x02, 0x0a, 0x13, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x41, 0x7a, 0x75, 0x72, 0x65,
	0x4e, 0x6f, 0x64, 0x65, 0x50, 0x6f, 0x6f, 0x6c, 0x12, 0x39, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6b, 0x65, 0x6d, 0x75, 0x6c, 0x74, 0x69,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x41,
	0x7a, 0x75, 0x72, 0x65, 0x4e, 0x6f, 0x64, 0x65, 0x50, 0x6f, 0x6f, 0x6c, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6c, 0x6f, 0x6e,
	0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x22, 0xaf, 0x01, 0xca, 0x41, 0x22, 0x0a, 0x0d, 0x41, 0x7a, 0x75, 0x72, 0x65, 0x4e,
	0x6f, 0x64, 0x65, 0x50, 0x6f, 0x6f, 0x6c, 0x12, 0x11, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0xda, 0x41, 0x29, 0x70, 0x61, 0x72,
	0x65, 0x6e, 0x74, 0x2c, 0x61, 0x7a, 0x75, 0x72, 0x65, 0x5f, 0x6e, 0x6f, 0x64, 0x65, 0x5f, 0x70,
	0x6f, 0x6f, 0x6c, 0x2c, 0x61, 0x7a, 0x75, 0x72, 0x65, 0x5f, 0x6e, 0x6f, 0x64, 0x65, 0x5f, 0x70,
	0x6f, 0x6f, 0x6c, 0x5f, 0x69, 0x64, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x55, 0x3a, 0x0f, 0x61, 0x7a,
	0x75, 0x72, 0x65, 0x5f, 0x6e, 0x6f, 0x64, 0x65, 0x5f, 0x70, 0x6f, 0x6f, 0x6c, 0x22, 0x42, 0x2f,
	0x76, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65,
	0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f,
	0x2a, 0x2f, 0x61, 0x7a, 0x75, 0x72, 0x65, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x73, 0x2f,
	0x2a, 0x7d, 0x2f, 0x61, 0x7a, 0x75, 0x72, 0x65, 0x4e, 0x6f, 0x64, 0x65, 0x50, 0x6f, 0x6f, 0x6c,
	0x73, 0x88, 0x02, 0x01, 0x12, 0xa3, 0x02, 0x0a, 0x13, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x41,
	0x7a, 0x75, 0x72, 0x65, 0x4e, 0x6f, 0x64, 0x65, 0x50, 0x6f, 0x6f, 0x6c, 0x12, 0x39, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6b, 0x65, 0x6d,
	0x75, 0x6c, 0x74, 0x69, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x31, 0x2e, 0x55, 0x70, 0x64,
	0x61, 0x74, 0x65, 0x41, 0x7a, 0x75, 0x72, 0x65, 0x4e, 0x6f, 0x64, 0x65, 0x50, 0x6f, 0x6f, 0x6c,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2e, 0x4f, 0x70, 0x65,
	0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0xb1, 0x01, 0xca, 0x41, 0x22, 0x0a, 0x0d, 0x41, 0x7a,
	0x75, 0x72, 0x65, 0x4e, 0x6f, 0x64, 0x65, 0x50, 0x6f, 0x6f, 0x6c, 0x12, 0x11, 0x4f, 0x70, 0x65,
	0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0xda, 0x41,
	0x1b, 0x61, 0x7a, 0x75, 0x72, 0x65, 0x5f, 0x6e, 0x6f, 0x64, 0x65, 0x5f, 0x70, 0x6f, 0x6f, 0x6c,
	0x2c, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x82, 0xd3, 0xe4, 0x93,
	0x02, 0x65, 0x3a, 0x0f, 0x61, 0x7a, 0x75, 0x72, 0x65, 0x5f, 0x6e, 0x6f, 0x64, 0x65, 0x5f, 0x70,
	0x6f, 0x6f, 0x6c, 0x32, 0x52, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x61, 0x7a, 0x75, 0x72, 0x65, 0x5f,
	0x6e, 0x6f, 0x64, 0x65, 0x5f, 0x70, 0x6f, 0x6f, 0x6c, 0x2e, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70,
	0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x61, 0x7a, 0x75, 0x72, 0x65, 0x43, 0x6c, 0x75, 0x73, 0x74,
	0x65, 0x72, 0x73, 0x2f, 0x2a, 0x2f, 0x61, 0x7a, 0x75, 0x72, 0x65, 0x4e, 0x6f, 0x64, 0x65, 0x50,
	0x6f, 0x6f, 0x6c, 0x73, 0x2f, 0x2a, 0x7d, 0x88, 0x02, 0x01, 0x12, 0xce, 0x01, 0x0a, 0x10, 0x47,
	0x65, 0x74, 0x41, 0x7a, 0x75, 0x72, 0x65, 0x4e, 0x6f, 0x64, 0x65, 0x50, 0x6f, 0x6f, 0x6c, 0x12,
	0x36, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67,
	0x6b, 0x65, 0x6d, 0x75, 0x6c, 0x74, 0x69, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x31, 0x2e,
	0x47, 0x65, 0x74, 0x41, 0x7a, 0x75, 0x72, 0x65, 0x4e, 0x6f, 0x64, 0x65, 0x50, 0x6f, 0x6f, 0x6c,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x2c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6b, 0x65, 0x6d, 0x75, 0x6c, 0x74, 0x69, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x7a, 0x75, 0x72, 0x65, 0x4e, 0x6f, 0x64,
	0x65, 0x50, 0x6f, 0x6f, 0x6c, 0x22, 0x54, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x82, 0xd3,
	0xe4, 0x93, 0x02, 0x44, 0x12, 0x42, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d,
	0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x61, 0x7a, 0x75, 0x72, 0x65, 0x43, 0x6c, 0x75, 0x73,
	0x74, 0x65, 0x72, 0x73, 0x2f, 0x2a, 0x2f, 0x61, 0x7a, 0x75, 0x72, 0x65, 0x4e, 0x6f, 0x64, 0x65,
	0x50, 0x6f, 0x6f, 0x6c, 0x73, 0x2f, 0x2a, 0x7d, 0x88, 0x02, 0x01, 0x12, 0xe1, 0x01, 0x0a, 0x12,
	0x4c, 0x69, 0x73, 0x74, 0x41, 0x7a, 0x75, 0x72, 0x65, 0x4e, 0x6f, 0x64, 0x65, 0x50, 0x6f, 0x6f,
	0x6c, 0x73, 0x12, 0x38, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x67, 0x6b, 0x65, 0x6d, 0x75, 0x6c, 0x74, 0x69, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x76, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x41, 0x7a, 0x75, 0x72, 0x65, 0x4e, 0x6f, 0x64, 0x65,
	0x50, 0x6f, 0x6f, 0x6c, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x39, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6b, 0x65, 0x6d,
	0x75, 0x6c, 0x74, 0x69, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69, 0x73,
	0x74, 0x41, 0x7a, 0x75, 0x72, 0x65, 0x4e, 0x6f, 0x64, 0x65, 0x50, 0x6f, 0x6f, 0x6c, 0x73, 0x52,
	0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x56, 0xda, 0x41, 0x06, 0x70, 0x61, 0x72, 0x65,
	0x6e, 0x74, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x44, 0x12, 0x42, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x70,
	0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a,
	0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x61, 0x7a, 0x75,
	0x72, 0x65, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x61, 0x7a,
	0x75, 0x72, 0x65, 0x4e, 0x6f, 0x64, 0x65, 0x50, 0x6f, 0x6f, 0x6c, 0x73, 0x88, 0x02, 0x01, 0x12,
	0xf3, 0x01, 0x0a, 0x13, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x41, 0x7a, 0x75, 0x72, 0x65, 0x4e,
	0x6f, 0x64, 0x65, 0x50, 0x6f, 0x6f, 0x6c, 0x12, 0x39, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6b, 0x65, 0x6d, 0x75, 0x6c, 0x74, 0x69, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x41, 0x7a,
	0x75, 0x72, 0x65, 0x4e, 0x6f, 0x64, 0x65, 0x50, 0x6f, 0x6f, 0x6c, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x1a, 0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6c, 0x6f, 0x6e, 0x67,
	0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x22, 0x81, 0x01, 0xca, 0x41, 0x2a, 0x0a, 0x15, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x45, 0x6d, 0x70, 0x74, 0x79, 0x12, 0x11,
	0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74,
	0x61, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x44, 0x2a, 0x42,
	0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63,
	0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a,
	0x2f, 0x61, 0x7a, 0x75, 0x72, 0x65, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x73, 0x2f, 0x2a,
	0x2f, 0x61, 0x7a, 0x75, 0x72, 0x65, 0x4e, 0x6f, 0x64, 0x65, 0x50, 0x6f, 0x6f, 0x6c, 0x73, 0x2f,
	0x2a, 0x7d, 0x88, 0x02, 0x01, 0x12, 0xfc, 0x01, 0x0a, 0x14, 0x47, 0x65, 0x74, 0x41, 0x7a, 0x75,
	0x72, 0x65, 0x4f, 0x70, 0x65, 0x6e, 0x49, 0x64, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x3a,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6b,
	0x65, 0x6d, 0x75, 0x6c, 0x74, 0x69, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x31, 0x2e, 0x47,
	0x65, 0x74, 0x41, 0x7a, 0x75, 0x72, 0x65, 0x4f, 0x70, 0x65, 0x6e, 0x49, 0x64, 0x43, 0x6f, 0x6e,
	0x66, 0x69, 0x67, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x30, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6b, 0x65, 0x6d, 0x75, 0x6c,
	0x74, 0x69, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x7a, 0x75, 0x72, 0x65,
	0x4f, 0x70, 0x65, 0x6e, 0x49, 0x64, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x22, 0x76, 0xda, 0x41,
	0x0d, 0x61, 0x7a, 0x75, 0x72, 0x65, 0x5f, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x82, 0xd3,
	0xe4, 0x93, 0x02, 0x5d, 0x12, 0x5b, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x61, 0x7a, 0x75, 0x72, 0x65,
	0x5f, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74,
	0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f,
	0x61, 0x7a, 0x75, 0x72, 0x65, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x73, 0x2f, 0x2a, 0x7d,
	0x2f, 0x2e, 0x77, 0x65, 0x6c, 0x6c, 0x2d, 0x6b, 0x6e, 0x6f, 0x77, 0x6e, 0x2f, 0x6f, 0x70, 0x65,
	0x6e, 0x69, 0x64, 0x2d, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x88, 0x02, 0x01, 0x12, 0xdd, 0x01, 0x0a, 0x13, 0x47, 0x65, 0x74, 0x41, 0x7a, 0x75, 0x72,
	0x65, 0x4a, 0x73, 0x6f, 0x6e, 0x57, 0x65, 0x62, 0x4b, 0x65, 0x79, 0x73, 0x12, 0x39, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6b, 0x65, 0x6d,
	0x75, 0x6c, 0x74, 0x69, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x31, 0x2e, 0x47, 0x65, 0x74,
	0x41, 0x7a, 0x75, 0x72, 0x65, 0x4a, 0x73, 0x6f, 0x6e, 0x57, 0x65, 0x62, 0x4b, 0x65, 0x79, 0x73,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x2f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6b, 0x65, 0x6d, 0x75, 0x6c, 0x74, 0x69, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x7a, 0x75, 0x72, 0x65, 0x4a, 0x73, 0x6f,
	0x6e, 0x57, 0x65, 0x62, 0x4b, 0x65, 0x79, 0x73, 0x22, 0x5a, 0xda, 0x41, 0x0d, 0x61, 0x7a, 0x75,
	0x72, 0x65, 0x5f, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x41,
	0x12, 0x3f, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x61, 0x7a, 0x75, 0x72, 0x65, 0x5f, 0x63, 0x6c, 0x75,
	0x73, 0x74, 0x65, 0x72, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f,
	0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x61, 0x7a, 0x75, 0x72,
	0x65, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x6a, 0x77, 0x6b,
	0x73, 0x88, 0x02, 0x01, 0x12, 0xcb, 0x01, 0x0a, 0x14, 0x47, 0x65, 0x74, 0x41, 0x7a, 0x75, 0x72,
	0x65, 0x53, 0x65, 0x72, 0x76, 0x65, 0x72, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x3a, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6b, 0x65,
	0x6d, 0x75, 0x6c, 0x74, 0x69, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x31, 0x2e, 0x47, 0x65,
	0x74, 0x41, 0x7a, 0x75, 0x72, 0x65, 0x53, 0x65, 0x72, 0x76, 0x65, 0x72, 0x43, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x30, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6b, 0x65, 0x6d, 0x75, 0x6c, 0x74,
	0x69, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x7a, 0x75, 0x72, 0x65, 0x53,
	0x65, 0x72, 0x76, 0x65, 0x72, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x22, 0x45, 0xda, 0x41, 0x04,
	0x6e, 0x61, 0x6d, 0x65, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x35, 0x12, 0x33, 0x2f, 0x76, 0x31, 0x2f,
	0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a,
	0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x61, 0x7a, 0x75,
	0x72, 0x65, 0x53, 0x65, 0x72, 0x76, 0x65, 0x72, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x7d, 0x88,
	0x02, 0x01, 0x1a, 0x53, 0xca, 0x41, 0x1c, 0x67, 0x6b, 0x65, 0x6d, 0x75, 0x6c, 0x74, 0x69, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e,
	0x63, 0x6f, 0x6d, 0xd2, 0x41, 0x2e, 0x68, 0x74, 0x74, 0x70, 0x73, 0x3a, 0x2f, 0x2f, 0x77, 0x77,
	0x77, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d,
	0x2f, 0x61, 0x75, 0x74, 0x68, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2d, 0x70, 0x6c, 0x61, 0x74,
	0x66, 0x6f, 0x72, 0x6d, 0x88, 0x02, 0x01, 0x42, 0xe4, 0x01, 0x0a, 0x21, 0x63, 0x6f, 0x6d, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6b, 0x65,
	0x6d, 0x75, 0x6c, 0x74, 0x69, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x31, 0x42, 0x11, 0x41,
	0x7a, 0x75, 0x72, 0x65, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x50, 0x72, 0x6f, 0x74, 0x6f,
	0x50, 0x01, 0x5a, 0x47, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x67, 0x6f, 0x2f, 0x67, 0x6b, 0x65, 0x6d, 0x75, 0x6c, 0x74, 0x69,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x61, 0x70, 0x69, 0x76, 0x31, 0x2f, 0x67, 0x6b, 0x65, 0x6d,
	0x75, 0x6c, 0x74, 0x69, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x70, 0x62, 0x3b, 0x67, 0x6b, 0x65, 0x6d,
	0x75, 0x6c, 0x74, 0x69, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x70, 0x62, 0xaa, 0x02, 0x1d, 0x47, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x47, 0x6b, 0x65, 0x4d, 0x75,
	0x6c, 0x74, 0x69, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x56, 0x31, 0xca, 0x02, 0x1d, 0x47, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x5c, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x5c, 0x47, 0x6b, 0x65, 0x4d, 0x75,
	0x6c, 0x74, 0x69, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x5c, 0x56, 0x31, 0xea, 0x02, 0x20, 0x47, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x3a, 0x3a, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x3a, 0x3a, 0x47, 0x6b, 0x65,
	0x4d, 0x75, 0x6c, 0x74, 0x69, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x3a, 0x3a, 0x56, 0x31, 0x62, 0x06,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_cloud_gkemulticloud_v1_azure_service_proto_rawDescOnce sync.Once
	file_google_cloud_gkemulticloud_v1_azure_service_proto_rawDescData = file_google_cloud_gkemulticloud_v1_azure_service_proto_rawDesc
)

func file_google_cloud_gkemulticloud_v1_azure_service_proto_rawDescGZIP() []byte {
	file_google_cloud_gkemulticloud_v1_azure_service_proto_rawDescOnce.Do(func() {
		file_google_cloud_gkemulticloud_v1_azure_service_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_cloud_gkemulticloud_v1_azure_service_proto_rawDescData)
	})
	return file_google_cloud_gkemulticloud_v1_azure_service_proto_rawDescData
}

var file_google_cloud_gkemulticloud_v1_azure_service_proto_msgTypes = make([]protoimpl.MessageInfo, 24)
var file_google_cloud_gkemulticloud_v1_azure_service_proto_goTypes = []any{
	(*CreateAzureClusterRequest)(nil),              // 0: google.cloud.gkemulticloud.v1.CreateAzureClusterRequest
	(*UpdateAzureClusterRequest)(nil),              // 1: google.cloud.gkemulticloud.v1.UpdateAzureClusterRequest
	(*GetAzureClusterRequest)(nil),                 // 2: google.cloud.gkemulticloud.v1.GetAzureClusterRequest
	(*ListAzureClustersRequest)(nil),               // 3: google.cloud.gkemulticloud.v1.ListAzureClustersRequest
	(*ListAzureClustersResponse)(nil),              // 4: google.cloud.gkemulticloud.v1.ListAzureClustersResponse
	(*DeleteAzureClusterRequest)(nil),              // 5: google.cloud.gkemulticloud.v1.DeleteAzureClusterRequest
	(*CreateAzureNodePoolRequest)(nil),             // 6: google.cloud.gkemulticloud.v1.CreateAzureNodePoolRequest
	(*UpdateAzureNodePoolRequest)(nil),             // 7: google.cloud.gkemulticloud.v1.UpdateAzureNodePoolRequest
	(*GetAzureNodePoolRequest)(nil),                // 8: google.cloud.gkemulticloud.v1.GetAzureNodePoolRequest
	(*ListAzureNodePoolsRequest)(nil),              // 9: google.cloud.gkemulticloud.v1.ListAzureNodePoolsRequest
	(*ListAzureNodePoolsResponse)(nil),             // 10: google.cloud.gkemulticloud.v1.ListAzureNodePoolsResponse
	(*DeleteAzureNodePoolRequest)(nil),             // 11: google.cloud.gkemulticloud.v1.DeleteAzureNodePoolRequest
	(*GetAzureOpenIdConfigRequest)(nil),            // 12: google.cloud.gkemulticloud.v1.GetAzureOpenIdConfigRequest
	(*GetAzureJsonWebKeysRequest)(nil),             // 13: google.cloud.gkemulticloud.v1.GetAzureJsonWebKeysRequest
	(*GetAzureServerConfigRequest)(nil),            // 14: google.cloud.gkemulticloud.v1.GetAzureServerConfigRequest
	(*CreateAzureClientRequest)(nil),               // 15: google.cloud.gkemulticloud.v1.CreateAzureClientRequest
	(*GetAzureClientRequest)(nil),                  // 16: google.cloud.gkemulticloud.v1.GetAzureClientRequest
	(*ListAzureClientsRequest)(nil),                // 17: google.cloud.gkemulticloud.v1.ListAzureClientsRequest
	(*ListAzureClientsResponse)(nil),               // 18: google.cloud.gkemulticloud.v1.ListAzureClientsResponse
	(*DeleteAzureClientRequest)(nil),               // 19: google.cloud.gkemulticloud.v1.DeleteAzureClientRequest
	(*GenerateAzureAccessTokenRequest)(nil),        // 20: google.cloud.gkemulticloud.v1.GenerateAzureAccessTokenRequest
	(*GenerateAzureAccessTokenResponse)(nil),       // 21: google.cloud.gkemulticloud.v1.GenerateAzureAccessTokenResponse
	(*GenerateAzureClusterAgentTokenRequest)(nil),  // 22: google.cloud.gkemulticloud.v1.GenerateAzureClusterAgentTokenRequest
	(*GenerateAzureClusterAgentTokenResponse)(nil), // 23: google.cloud.gkemulticloud.v1.GenerateAzureClusterAgentTokenResponse
	(*AzureCluster)(nil),                           // 24: google.cloud.gkemulticloud.v1.AzureCluster
	(*fieldmaskpb.FieldMask)(nil),                  // 25: google.protobuf.FieldMask
	(*AzureNodePool)(nil),                          // 26: google.cloud.gkemulticloud.v1.AzureNodePool
	(*AzureClient)(nil),                            // 27: google.cloud.gkemulticloud.v1.AzureClient
	(*timestamppb.Timestamp)(nil),                  // 28: google.protobuf.Timestamp
	(*longrunningpb.Operation)(nil),                // 29: google.longrunning.Operation
	(*AzureOpenIdConfig)(nil),                      // 30: google.cloud.gkemulticloud.v1.AzureOpenIdConfig
	(*AzureJsonWebKeys)(nil),                       // 31: google.cloud.gkemulticloud.v1.AzureJsonWebKeys
	(*AzureServerConfig)(nil),                      // 32: google.cloud.gkemulticloud.v1.AzureServerConfig
}
var file_google_cloud_gkemulticloud_v1_azure_service_proto_depIdxs = []int32{
	24, // 0: google.cloud.gkemulticloud.v1.CreateAzureClusterRequest.azure_cluster:type_name -> google.cloud.gkemulticloud.v1.AzureCluster
	24, // 1: google.cloud.gkemulticloud.v1.UpdateAzureClusterRequest.azure_cluster:type_name -> google.cloud.gkemulticloud.v1.AzureCluster
	25, // 2: google.cloud.gkemulticloud.v1.UpdateAzureClusterRequest.update_mask:type_name -> google.protobuf.FieldMask
	24, // 3: google.cloud.gkemulticloud.v1.ListAzureClustersResponse.azure_clusters:type_name -> google.cloud.gkemulticloud.v1.AzureCluster
	26, // 4: google.cloud.gkemulticloud.v1.CreateAzureNodePoolRequest.azure_node_pool:type_name -> google.cloud.gkemulticloud.v1.AzureNodePool
	26, // 5: google.cloud.gkemulticloud.v1.UpdateAzureNodePoolRequest.azure_node_pool:type_name -> google.cloud.gkemulticloud.v1.AzureNodePool
	25, // 6: google.cloud.gkemulticloud.v1.UpdateAzureNodePoolRequest.update_mask:type_name -> google.protobuf.FieldMask
	26, // 7: google.cloud.gkemulticloud.v1.ListAzureNodePoolsResponse.azure_node_pools:type_name -> google.cloud.gkemulticloud.v1.AzureNodePool
	27, // 8: google.cloud.gkemulticloud.v1.CreateAzureClientRequest.azure_client:type_name -> google.cloud.gkemulticloud.v1.AzureClient
	27, // 9: google.cloud.gkemulticloud.v1.ListAzureClientsResponse.azure_clients:type_name -> google.cloud.gkemulticloud.v1.AzureClient
	28, // 10: google.cloud.gkemulticloud.v1.GenerateAzureAccessTokenResponse.expiration_time:type_name -> google.protobuf.Timestamp
	15, // 11: google.cloud.gkemulticloud.v1.AzureClusters.CreateAzureClient:input_type -> google.cloud.gkemulticloud.v1.CreateAzureClientRequest
	16, // 12: google.cloud.gkemulticloud.v1.AzureClusters.GetAzureClient:input_type -> google.cloud.gkemulticloud.v1.GetAzureClientRequest
	17, // 13: google.cloud.gkemulticloud.v1.AzureClusters.ListAzureClients:input_type -> google.cloud.gkemulticloud.v1.ListAzureClientsRequest
	19, // 14: google.cloud.gkemulticloud.v1.AzureClusters.DeleteAzureClient:input_type -> google.cloud.gkemulticloud.v1.DeleteAzureClientRequest
	0,  // 15: google.cloud.gkemulticloud.v1.AzureClusters.CreateAzureCluster:input_type -> google.cloud.gkemulticloud.v1.CreateAzureClusterRequest
	1,  // 16: google.cloud.gkemulticloud.v1.AzureClusters.UpdateAzureCluster:input_type -> google.cloud.gkemulticloud.v1.UpdateAzureClusterRequest
	2,  // 17: google.cloud.gkemulticloud.v1.AzureClusters.GetAzureCluster:input_type -> google.cloud.gkemulticloud.v1.GetAzureClusterRequest
	3,  // 18: google.cloud.gkemulticloud.v1.AzureClusters.ListAzureClusters:input_type -> google.cloud.gkemulticloud.v1.ListAzureClustersRequest
	5,  // 19: google.cloud.gkemulticloud.v1.AzureClusters.DeleteAzureCluster:input_type -> google.cloud.gkemulticloud.v1.DeleteAzureClusterRequest
	22, // 20: google.cloud.gkemulticloud.v1.AzureClusters.GenerateAzureClusterAgentToken:input_type -> google.cloud.gkemulticloud.v1.GenerateAzureClusterAgentTokenRequest
	20, // 21: google.cloud.gkemulticloud.v1.AzureClusters.GenerateAzureAccessToken:input_type -> google.cloud.gkemulticloud.v1.GenerateAzureAccessTokenRequest
	6,  // 22: google.cloud.gkemulticloud.v1.AzureClusters.CreateAzureNodePool:input_type -> google.cloud.gkemulticloud.v1.CreateAzureNodePoolRequest
	7,  // 23: google.cloud.gkemulticloud.v1.AzureClusters.UpdateAzureNodePool:input_type -> google.cloud.gkemulticloud.v1.UpdateAzureNodePoolRequest
	8,  // 24: google.cloud.gkemulticloud.v1.AzureClusters.GetAzureNodePool:input_type -> google.cloud.gkemulticloud.v1.GetAzureNodePoolRequest
	9,  // 25: google.cloud.gkemulticloud.v1.AzureClusters.ListAzureNodePools:input_type -> google.cloud.gkemulticloud.v1.ListAzureNodePoolsRequest
	11, // 26: google.cloud.gkemulticloud.v1.AzureClusters.DeleteAzureNodePool:input_type -> google.cloud.gkemulticloud.v1.DeleteAzureNodePoolRequest
	12, // 27: google.cloud.gkemulticloud.v1.AzureClusters.GetAzureOpenIdConfig:input_type -> google.cloud.gkemulticloud.v1.GetAzureOpenIdConfigRequest
	13, // 28: google.cloud.gkemulticloud.v1.AzureClusters.GetAzureJsonWebKeys:input_type -> google.cloud.gkemulticloud.v1.GetAzureJsonWebKeysRequest
	14, // 29: google.cloud.gkemulticloud.v1.AzureClusters.GetAzureServerConfig:input_type -> google.cloud.gkemulticloud.v1.GetAzureServerConfigRequest
	29, // 30: google.cloud.gkemulticloud.v1.AzureClusters.CreateAzureClient:output_type -> google.longrunning.Operation
	27, // 31: google.cloud.gkemulticloud.v1.AzureClusters.GetAzureClient:output_type -> google.cloud.gkemulticloud.v1.AzureClient
	18, // 32: google.cloud.gkemulticloud.v1.AzureClusters.ListAzureClients:output_type -> google.cloud.gkemulticloud.v1.ListAzureClientsResponse
	29, // 33: google.cloud.gkemulticloud.v1.AzureClusters.DeleteAzureClient:output_type -> google.longrunning.Operation
	29, // 34: google.cloud.gkemulticloud.v1.AzureClusters.CreateAzureCluster:output_type -> google.longrunning.Operation
	29, // 35: google.cloud.gkemulticloud.v1.AzureClusters.UpdateAzureCluster:output_type -> google.longrunning.Operation
	24, // 36: google.cloud.gkemulticloud.v1.AzureClusters.GetAzureCluster:output_type -> google.cloud.gkemulticloud.v1.AzureCluster
	4,  // 37: google.cloud.gkemulticloud.v1.AzureClusters.ListAzureClusters:output_type -> google.cloud.gkemulticloud.v1.ListAzureClustersResponse
	29, // 38: google.cloud.gkemulticloud.v1.AzureClusters.DeleteAzureCluster:output_type -> google.longrunning.Operation
	23, // 39: google.cloud.gkemulticloud.v1.AzureClusters.GenerateAzureClusterAgentToken:output_type -> google.cloud.gkemulticloud.v1.GenerateAzureClusterAgentTokenResponse
	21, // 40: google.cloud.gkemulticloud.v1.AzureClusters.GenerateAzureAccessToken:output_type -> google.cloud.gkemulticloud.v1.GenerateAzureAccessTokenResponse
	29, // 41: google.cloud.gkemulticloud.v1.AzureClusters.CreateAzureNodePool:output_type -> google.longrunning.Operation
	29, // 42: google.cloud.gkemulticloud.v1.AzureClusters.UpdateAzureNodePool:output_type -> google.longrunning.Operation
	26, // 43: google.cloud.gkemulticloud.v1.AzureClusters.GetAzureNodePool:output_type -> google.cloud.gkemulticloud.v1.AzureNodePool
	10, // 44: google.cloud.gkemulticloud.v1.AzureClusters.ListAzureNodePools:output_type -> google.cloud.gkemulticloud.v1.ListAzureNodePoolsResponse
	29, // 45: google.cloud.gkemulticloud.v1.AzureClusters.DeleteAzureNodePool:output_type -> google.longrunning.Operation
	30, // 46: google.cloud.gkemulticloud.v1.AzureClusters.GetAzureOpenIdConfig:output_type -> google.cloud.gkemulticloud.v1.AzureOpenIdConfig
	31, // 47: google.cloud.gkemulticloud.v1.AzureClusters.GetAzureJsonWebKeys:output_type -> google.cloud.gkemulticloud.v1.AzureJsonWebKeys
	32, // 48: google.cloud.gkemulticloud.v1.AzureClusters.GetAzureServerConfig:output_type -> google.cloud.gkemulticloud.v1.AzureServerConfig
	30, // [30:49] is the sub-list for method output_type
	11, // [11:30] is the sub-list for method input_type
	11, // [11:11] is the sub-list for extension type_name
	11, // [11:11] is the sub-list for extension extendee
	0,  // [0:11] is the sub-list for field type_name
}

func init() { file_google_cloud_gkemulticloud_v1_azure_service_proto_init() }
func file_google_cloud_gkemulticloud_v1_azure_service_proto_init() {
	if File_google_cloud_gkemulticloud_v1_azure_service_proto != nil {
		return
	}
	file_google_cloud_gkemulticloud_v1_azure_resources_proto_init()
	file_google_cloud_gkemulticloud_v1_common_resources_proto_init()
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_cloud_gkemulticloud_v1_azure_service_proto_rawDesc,
			NumEnums:      0,
			NumMessages:   24,
			NumExtensions: 0,
			NumServices:   1,
		},
		GoTypes:           file_google_cloud_gkemulticloud_v1_azure_service_proto_goTypes,
		DependencyIndexes: file_google_cloud_gkemulticloud_v1_azure_service_proto_depIdxs,
		MessageInfos:      file_google_cloud_gkemulticloud_v1_azure_service_proto_msgTypes,
	}.Build()
	File_google_cloud_gkemulticloud_v1_azure_service_proto = out.File
	file_google_cloud_gkemulticloud_v1_azure_service_proto_rawDesc = nil
	file_google_cloud_gkemulticloud_v1_azure_service_proto_goTypes = nil
	file_google_cloud_gkemulticloud_v1_azure_service_proto_depIdxs = nil
}
