package api

import (
	structpb "google.golang.org/protobuf/types/known/structpb"
)

type FunctionCall struct {
	// The name of the function to call.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// The arguments to call the function with, generated by model, formatted as
	// json, may not valid, the caller should validate the arguments before
	// calling the function.
	Arguments string `protobuf:"bytes,2,opt,name=arguments,proto3" json:"arguments,omitempty"`
}

func (x *FunctionCall) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *FunctionCall) GetArguments() string {
	if x != nil {
		return x.Arguments
	}
	return ""
}

type TopLogprobsItem struct {
	Item map[string]float32 `protobuf:"bytes,1,rep,name=item,proto3" json:"item,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"fixed32,2,opt,name=value,proto3"`
}

func (x *TopLogprobsItem) GetItem() map[string]float32 {
	if x != nil {
		return x.Item
	}
	return nil
}

type Logprobs struct {
	TextOffset    []int64             `protobuf:"varint,1,rep,packed,name=text_offset,json=textOffset,proto3" json:"text_offset,omitempty"`
	TokenLogprobs []float64           `protobuf:"fixed64,2,rep,packed,name=token_logprobs,json=tokenLogprobs,proto3" json:"token_logprobs,omitempty"`
	Tokens        []string            `protobuf:"bytes,3,rep,name=tokens,proto3" json:"tokens,omitempty"`
	TopLogprobs   *structpb.ListValue `protobuf:"bytes,4,opt,name=top_logprobs,json=topLogprobs,proto3" json:"top_logprobs,omitempty"`
}

func (x *Logprobs) GetTextOffset() []int64 {
	if x != nil {
		return x.TextOffset
	}
	return nil
}

func (x *Logprobs) GetTokenLogprobs() []float64 {
	if x != nil {
		return x.TokenLogprobs
	}
	return nil
}

func (x *Logprobs) GetTokens() []string {
	if x != nil {
		return x.Tokens
	}
	return nil
}

func (x *Logprobs) GetTopLogprobs() *structpb.ListValue {
	if x != nil {
		return x.TopLogprobs
	}
	return nil
}

type Message struct {
	// The role of the author of this message. One of system, user, assistant or
	// function.
	Role string `protobuf:"bytes,1,opt,name=role,proto3" json:"role,omitempty"`
	// The real content of the message, may be empty for assistant message with
	// function call.
	Content string `protobuf:"bytes,2,opt,name=content,proto3" json:"content,omitempty"`
	// If the role is `function`, is the name of the function which generate the
	// content.
	Name string `protobuf:"bytes,4,opt,name=name,proto3" json:"name,omitempty"`
	// The name and arguments of a function call generated by model.
	FunctionCall *FunctionCall `protobuf:"bytes,5,opt,name=function_call,json=functionCall,proto3" json:"function_call,omitempty"`
	// url reference for searching, optional
	References []*Reference `protobuf:"bytes,3,rep,name=references,proto3" json:"references,omitempty"`
}

func (x *Message) GetRole() string {
	if x != nil {
		return x.Role
	}
	return ""
}

func (x *Message) GetContent() string {
	if x != nil {
		return x.Content
	}
	return ""
}

func (x *Message) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *Message) GetFunctionCall() *FunctionCall {
	if x != nil {
		return x.FunctionCall
	}
	return nil
}

func (x *Message) GetReferences() []*Reference {
	if x != nil {
		return x.References
	}
	return nil
}

type Reference struct {
	// url
	Url string `protobuf:"bytes,1,opt,name=url,proto3" json:"url,omitempty"`
	// the index of url
	Idx int32 `protobuf:"varint,2,opt,name=idx,proto3" json:"idx,omitempty"`
	// the logo of url
	LogoUrl string `protobuf:"bytes,3,opt,name=logo_url,json=logoUrl,proto3" json:"logo_url,omitempty"`
	// the url be used for pc
	PcUrl string `protobuf:"bytes,4,opt,name=pc_url,json=pcUrl,proto3" json:"pc_url,omitempty"`
	// the topic of url
	SiteName string `protobuf:"bytes,5,opt,name=site_name,json=siteName,proto3" json:"site_name,omitempty"`
}

func (x *Reference) GetUrl() string {
	if x != nil {
		return x.Url
	}
	return ""
}

func (x *Reference) GetIdx() int32 {
	if x != nil {
		return x.Idx
	}
	return 0
}

func (x *Reference) GetLogoUrl() string {
	if x != nil {
		return x.LogoUrl
	}
	return ""
}

func (x *Reference) GetPcUrl() string {
	if x != nil {
		return x.PcUrl
	}
	return ""
}

func (x *Reference) GetSiteName() string {
	if x != nil {
		return x.SiteName
	}
	return ""
}

type Model struct {
	// Unified model name in model db
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Use specific endpoint id for inference, if set, parameters `name` and
	// `version` will be ignored.
	EndpointId string `protobuf:"bytes,2,opt,name=endpoint_id,json=endpointId,proto3" json:"endpoint_id,omitempty"`
	// Use specific model version for inference, optional.
	Version string `protobuf:"bytes,3,opt,name=version,proto3" json:"version,omitempty"`
}

func (x *Model) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *Model) GetEndpointId() string {
	if x != nil {
		return x.EndpointId
	}
	return ""
}

func (x *Model) GetVersion() string {
	if x != nil {
		return x.Version
	}
	return ""
}

type Error struct {
	Code    string `protobuf:"bytes,1,opt,name=code,proto3" json:"code,omitempty"`
	CodeN   int32  `protobuf:"varint,2,opt,name=code_n,json=codeN,proto3" json:"code_n,omitempty"`
	Message string `protobuf:"bytes,3,opt,name=message,proto3" json:"message,omitempty"`
}

func (x *Error) GetCode() string {
	if x != nil {
		return x.Code
	}
	return ""
}

func (x *Error) GetCodeN() int32 {
	if x != nil {
		return x.CodeN
	}
	return 0
}

func (x *Error) GetMessage() string {
	if x != nil {
		return x.Message
	}
	return ""
}

type ErrorResp struct {
	Error *Error `protobuf:"bytes,1,opt,name=error,proto3" json:"error,omitempty"`
	ReqId string `protobuf:"bytes,2,opt,name=req_id,json=reqId,proto3" json:"req_id,omitempty"`
}

func (x *ErrorResp) GetError() *Error {
	if x != nil {
		return x.Error
	}
	return nil
}

func (x *ErrorResp) GetReqId() string {
	if x != nil {
		return x.ReqId
	}
	return ""
}

type Choice struct {
	Index        int32     `protobuf:"varint,1,opt,name=index,proto3" json:"index,omitempty"`
	Message      *Message  `protobuf:"bytes,2,opt,name=message,proto3" json:"message,omitempty"`
	FinishReason string    `protobuf:"bytes,3,opt,name=finish_reason,json=finishReason,proto3" json:"finish_reason,omitempty"`
	Logprobs     *Logprobs `protobuf:"bytes,4,opt,name=logprobs,proto3" json:"logprobs,omitempty"`
}

func (x *Choice) GetIndex() int32 {
	if x != nil {
		return x.Index
	}
	return 0
}

func (x *Choice) GetMessage() *Message {
	if x != nil {
		return x.Message
	}
	return nil
}

func (x *Choice) GetFinishReason() string {
	if x != nil {
		return x.FinishReason
	}
	return ""
}

func (x *Choice) GetLogprobs() *Logprobs {
	if x != nil {
		return x.Logprobs
	}
	return nil
}

type Parameters struct {
	// Exponential scaling output probability distribution
	Temperature float32 `protobuf:"fixed32,1,opt,name=temperature,proto3" json:"temperature,omitempty"`
	// The maximum number of tokens to generate in the char completion.
	MaxTokens int64 `protobuf:"varint,2,opt,name=max_tokens,json=maxTokens,proto3" json:"max_tokens,omitempty"`
	// An alternative to sampling with temperature, called nucleus sampling,
	// where the model considers the results of the tokens with top_p probability
	// mass
	TopP float32 `protobuf:"fixed32,3,opt,name=top_p,json=topP,proto3" json:"top_p,omitempty"`
	// Number between -2.0 and 2.0. Positive values penalize new tokens based
	// on whether they appear in the text so far, increasing the model's
	// likelihood to talk about new topics.
	PresencePenalty float32 `protobuf:"fixed32,4,opt,name=presence_penalty,json=presencePenalty,proto3" json:"presence_penalty,omitempty"`
	// Number between -2.0 and 2.0. Positive values penalize new tokens based on
	// their existing frequency in the text so far, decreasing the model's
	// likelihood to repeat the same line verbatim.
	FrequencyPenalty float32 `protobuf:"fixed32,5,opt,name=frequency_penalty,json=frequencyPenalty,proto3" json:"frequency_penalty,omitempty"`
	// The maximum number of tokens to generate, ignoring the number of tokens in
	// the prompt
	MaxNewTokens int64 `protobuf:"varint,6,opt,name=max_new_tokens,json=maxNewTokens,proto3" json:"max_new_tokens,omitempty"`
	// The parameter for repetition penalty, from [1.0, 2.0]
	RepetitionPenalty float32 `protobuf:"fixed32,7,opt,name=repetition_penalty,json=repetitionPenalty,proto3" json:"repetition_penalty,omitempty"`
	// Whether or not to use sampling, use greedy decoding otherwise. Default to
	// false
	DoSample bool `protobuf:"varint,8,opt,name=do_sample,json=doSample,proto3" json:"do_sample,omitempty"`
	// The number of highest probability vocabulary tokens to keep for
	// top-k-filtering.
	TopK int64 `protobuf:"varint,9,opt,name=top_k,json=topK,proto3" json:"top_k,omitempty"`
	// the minimum number of tokens to generate
	MinNewTokens int64 `protobuf:"varint,10,opt,name=min_new_tokens,json=minNewTokens,proto3" json:"min_new_tokens,omitempty"`
	// the maximum number of prompt tokens, if prompt tokens length over this
	// limit, it will be truncated as prompt[-max_prompt_tokens:]
	MaxPromptTokens int64    `protobuf:"varint,11,opt,name=max_prompt_tokens,json=maxPromptTokens,proto3" json:"max_prompt_tokens,omitempty"`
	Logprobs        int64    `protobuf:"varint,12,opt,name=logprobs,proto3" json:"logprobs,omitempty"`
	Stop            []string `protobuf:"bytes,13,rep,name=stop,proto3" json:"stop,omitempty"`
}

func (x *Parameters) GetTemperature() float32 {
	if x != nil {
		return x.Temperature
	}
	return 0
}

func (x *Parameters) GetMaxTokens() int64 {
	if x != nil {
		return x.MaxTokens
	}
	return 0
}

func (x *Parameters) GetTopP() float32 {
	if x != nil {
		return x.TopP
	}
	return 0
}

func (x *Parameters) GetPresencePenalty() float32 {
	if x != nil {
		return x.PresencePenalty
	}
	return 0
}

func (x *Parameters) GetFrequencyPenalty() float32 {
	if x != nil {
		return x.FrequencyPenalty
	}
	return 0
}

func (x *Parameters) GetMaxNewTokens() int64 {
	if x != nil {
		return x.MaxNewTokens
	}
	return 0
}

func (x *Parameters) GetRepetitionPenalty() float32 {
	if x != nil {
		return x.RepetitionPenalty
	}
	return 0
}

func (x *Parameters) GetDoSample() bool {
	if x != nil {
		return x.DoSample
	}
	return false
}

func (x *Parameters) GetTopK() int64 {
	if x != nil {
		return x.TopK
	}
	return 0
}

func (x *Parameters) GetMinNewTokens() int64 {
	if x != nil {
		return x.MinNewTokens
	}
	return 0
}

func (x *Parameters) GetMaxPromptTokens() int64 {
	if x != nil {
		return x.MaxPromptTokens
	}
	return 0
}

func (x *Parameters) GetLogprobs() int64 {
	if x != nil {
		return x.Logprobs
	}
	return 0
}

func (x *Parameters) GetStop() []string {
	if x != nil {
		return x.Stop
	}
	return nil
}

type Usage struct {
	// The number of prompt tokens
	PromptTokens int64 `protobuf:"varint,1,opt,name=prompt_tokens,json=promptTokens,proto3" json:"prompt_tokens,omitempty"`
	// The number of generated tokens
	CompletionTokens int64 `protobuf:"varint,2,opt,name=completion_tokens,json=completionTokens,proto3" json:"completion_tokens,omitempty"`
	// The number of all: prompt_tokens + completion_tokens
	TotalTokens int64 `protobuf:"varint,3,opt,name=total_tokens,json=totalTokens,proto3" json:"total_tokens,omitempty"`
}

func (x *Usage) GetPromptTokens() int64 {
	if x != nil {
		return x.PromptTokens
	}
	return 0
}

func (x *Usage) GetCompletionTokens() int64 {
	if x != nil {
		return x.CompletionTokens
	}
	return 0
}

func (x *Usage) GetTotalTokens() int64 {
	if x != nil {
		return x.TotalTokens
	}
	return 0
}

type Function struct {
	// The name of the function.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// A description of the function, used by the model to choose when and how to
	// call the function.
	Description string `protobuf:"bytes,2,opt,name=description,proto3" json:"description,omitempty"`
	// The parameters of the function, described as Json Schema.
	Parameters *structpb.Struct `protobuf:"bytes,3,opt,name=parameters,proto3" json:"parameters,omitempty"`
	// The examples of the function parameters, as the above json schema
	// describes.
	Examples []string `protobuf:"bytes,4,rep,name=examples,proto3" json:"examples,omitempty"`
}

func (x *Function) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *Function) GetDescription() string {
	if x != nil {
		return x.Description
	}
	return ""
}

func (x *Function) GetParameters() *structpb.Struct {
	if x != nil {
		return x.Parameters
	}
	return nil
}

func (x *Function) GetExamples() []string {
	if x != nil {
		return x.Examples
	}
	return nil
}

type ChatReq struct {
	// Used model for inference
	Model *Model `protobuf:"bytes,1,opt,name=model,proto3" json:"model,omitempty"`
	// User input prompt
	Messages []*Message `protobuf:"bytes,2,rep,name=messages,proto3" json:"messages,omitempty"`
	// API specific parameters
	Parameters *Parameters `protobuf:"bytes,3,opt,name=parameters,proto3" json:"parameters,omitempty"`
	// Whether use stream mode, if set, partial message deltas will be sent as
	// data-only server-sent events as they become available
	// The stream will be terminated by a data: [DONE]
	Stream bool `protobuf:"varint,4,opt,name=stream,proto3" json:"stream,omitempty"`
	// Unified request id
	ReqId string `protobuf:"bytes,5,opt,name=req_id,json=reqId,proto3" json:"req_id,omitempty"`
	// symmetric key to encrypt messages, the key itself is encrypted
	// with model's public key.
	CryptoToken string `protobuf:"bytes,6,opt,name=crypto_token,json=cryptoToken,proto3" json:"crypto_token,omitempty"` //[ (api.header) = "Ml-Maas-Crypto-Token" ];
	// list of functions the model may generate json inputs for.
	Functions []*Function `protobuf:"bytes,7,rep,name=functions,proto3" json:"functions,omitempty"`
	// list of plugins the model may call.
	Plugins []string `protobuf:"bytes,8,rep,name=plugins,proto3" json:"plugins,omitempty"`
	// Method supports chat/tokenize/classification
	Method string `protobuf:"bytes,9,opt,name=method,proto3" json:"method,omitempty"`
	// extra info
	Extra map[string]string `protobuf:"bytes,100,rep,name=extra,proto3" json:"extra,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
}

func (x *ChatReq) GetModel() *Model {
	if x != nil {
		return x.Model
	}
	return nil
}

func (x *ChatReq) GetMessages() []*Message {
	if x != nil {
		return x.Messages
	}
	return nil
}

func (x *ChatReq) GetParameters() *Parameters {
	if x != nil {
		return x.Parameters
	}
	return nil
}

func (x *ChatReq) GetStream() bool {
	if x != nil {
		return x.Stream
	}
	return false
}

func (x *ChatReq) GetReqId() string {
	if x != nil {
		return x.ReqId
	}
	return ""
}

func (x *ChatReq) GetCryptoToken() string {
	if x != nil {
		return x.CryptoToken
	}
	return ""
}

func (x *ChatReq) GetFunctions() []*Function {
	if x != nil {
		return x.Functions
	}
	return nil
}

func (x *ChatReq) GetPlugins() []string {
	if x != nil {
		return x.Plugins
	}
	return nil
}

func (x *ChatReq) GetMethod() string {
	if x != nil {
		return x.Method
	}
	return ""
}

func (x *ChatReq) GetExtra() map[string]string {
	if x != nil {
		return x.Extra
	}
	return nil
}

type TokenizeReq struct {
	Model *Model `protobuf:"bytes,1,opt,name=model,proto3" json:"model,omitempty"`
	ReqId string `protobuf:"bytes,2,opt,name=req_id,json=reqId,proto3" json:"req_id,omitempty"`
	Text  string `protobuf:"bytes,3,opt,name=text,proto3" json:"text,omitempty"`
}

func (x *TokenizeReq) GetModel() *Model {
	if x != nil {
		return x.Model
	}
	return nil
}

func (x *TokenizeReq) GetReqId() string {
	if x != nil {
		return x.ReqId
	}
	return ""
}

func (x *TokenizeReq) GetText() string {
	if x != nil {
		return x.Text
	}
	return ""
}

type TokenizeResp struct {
	TotalTokens int64    `protobuf:"varint,1,opt,name=total_tokens,json=totalTokens,proto3" json:"total_tokens,omitempty"`
	Tokens      []string `protobuf:"bytes,2,rep,name=tokens,proto3" json:"tokens,omitempty"`
	// Unified request id
	ReqId string `protobuf:"bytes,3,opt,name=req_id,json=reqId,proto3" json:"req_id,omitempty"`
	// Error if exists for the req
	Error *Error `protobuf:"bytes,4,opt,name=error,proto3" json:"error,omitempty"`
}

func (x *TokenizeResp) GetTotalTokens() int64 {
	if x != nil {
		return x.TotalTokens
	}
	return 0
}

func (x *TokenizeResp) GetTokens() []string {
	if x != nil {
		return x.Tokens
	}
	return nil
}

func (x *TokenizeResp) GetReqId() string {
	if x != nil {
		return x.ReqId
	}
	return ""
}

func (x *TokenizeResp) GetError() *Error {
	if x != nil {
		return x.Error
	}
	return nil
}

type LabelLogprobosValue struct {
	Tokens        []string  `protobuf:"bytes,1,rep,name=tokens,proto3" json:"tokens,omitempty"`
	TokenLogprobs []float64 `protobuf:"fixed64,2,rep,packed,name=token_logprobs,json=tokenLogprobs,proto3" json:"token_logprobs,omitempty"`
	ReqId         string    `protobuf:"bytes,3,opt,name=req_id,json=reqId,proto3" json:"req_id,omitempty"`
}

func (x *LabelLogprobosValue) GetTokens() []string {
	if x != nil {
		return x.Tokens
	}
	return nil
}

func (x *LabelLogprobosValue) GetTokenLogprobs() []float64 {
	if x != nil {
		return x.TokenLogprobs
	}
	return nil
}

func (x *LabelLogprobosValue) GetReqId() string {
	if x != nil {
		return x.ReqId
	}
	return ""
}

type ClassificationReq struct {
	Model  *Model   `protobuf:"bytes,1,opt,name=model,proto3" json:"model,omitempty"`
	ReqId  string   `protobuf:"bytes,2,opt,name=req_id,json=reqId,proto3" json:"req_id,omitempty"`
	Query  string   `protobuf:"bytes,3,opt,name=query,proto3" json:"query,omitempty"`
	Labels []string `protobuf:"bytes,4,rep,name=labels,proto3" json:"labels,omitempty"`
}

func (x *ClassificationReq) GetModel() *Model {
	if x != nil {
		return x.Model
	}
	return nil
}

func (x *ClassificationReq) GetReqId() string {
	if x != nil {
		return x.ReqId
	}
	return ""
}

func (x *ClassificationReq) GetQuery() string {
	if x != nil {
		return x.Query
	}
	return ""
}

func (x *ClassificationReq) GetLabels() []string {
	if x != nil {
		return x.Labels
	}
	return nil
}

type ClassificationResp struct {
	Label          string                          `protobuf:"bytes,1,opt,name=label,proto3" json:"label,omitempty"`
	LabelLogprobos map[string]*LabelLogprobosValue `protobuf:"bytes,2,rep,name=label_logprobos,json=labelLogprobos,proto3" json:"label_logprobos,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// The tokens usage
	Usage *Usage `protobuf:"bytes,3,opt,name=usage,proto3" json:"usage,omitempty"`
	// Unified request id
	ReqId string `protobuf:"bytes,4,opt,name=req_id,json=reqId,proto3" json:"req_id,omitempty"`
	// Error if exists for the req
	Error *Error `protobuf:"bytes,5,opt,name=error,proto3" json:"error,omitempty"`
}

func (x *ClassificationResp) GetLabel() string {
	if x != nil {
		return x.Label
	}
	return ""
}

func (x *ClassificationResp) GetLabelLogprobos() map[string]*LabelLogprobosValue {
	if x != nil {
		return x.LabelLogprobos
	}
	return nil
}

func (x *ClassificationResp) GetUsage() *Usage {
	if x != nil {
		return x.Usage
	}
	return nil
}

func (x *ClassificationResp) GetReqId() string {
	if x != nil {
		return x.ReqId
	}
	return ""
}

func (x *ClassificationResp) GetError() *Error {
	if x != nil {
		return x.Error
	}
	return nil
}

type ChatResp struct {
	// Unified request id
	ReqId string `protobuf:"bytes,1,opt,name=req_id,json=reqId,proto3" json:"req_id,omitempty"`
	// Error if exists for the req
	Error *Error `protobuf:"bytes,2,opt,name=error,proto3" json:"error,omitempty"`
	// The generated result
	Choice *Choice `protobuf:"bytes,3,opt,name=choice,proto3" json:"choice,omitempty"`
	// The tokens usage
	Usage *Usage `protobuf:"bytes,4,opt,name=usage,proto3" json:"usage,omitempty"`
	// extra info
	Extra map[string]string `protobuf:"bytes,100,rep,name=extra,proto3" json:"extra,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
}

func (x *ChatResp) GetReqId() string {
	if x != nil {
		return x.ReqId
	}
	return ""
}

func (x *ChatResp) GetError() *Error {
	if x != nil {
		return x.Error
	}
	return nil
}

func (x *ChatResp) GetChoice() *Choice {
	if x != nil {
		return x.Choice
	}
	return nil
}

func (x *ChatResp) GetUsage() *Usage {
	if x != nil {
		return x.Usage
	}
	return nil
}

func (x *ChatResp) GetExtra() map[string]string {
	if x != nil {
		return x.Extra
	}
	return nil
}

type CertReq struct {
	Model *Model `protobuf:"bytes,1,opt,name=model,proto3" json:"model,omitempty"`
}

func (x *CertReq) GetModel() *Model {
	if x != nil {
		return x.Model
	}
	return nil
}

type CertResp struct {
	Model *Model `protobuf:"bytes,1,opt,name=model,proto3" json:"model,omitempty"`
	Cert  string `protobuf:"bytes,2,opt,name=cert,proto3" json:"cert,omitempty"`
}

func (x *CertResp) GetModel() *Model {
	if x != nil {
		return x.Model
	}
	return nil
}

func (x *CertResp) GetCert() string {
	if x != nil {
		return x.Cert
	}
	return ""
}

type EmbeddingsReq struct {
	ReqId          string   `protobuf:"bytes,1,opt,name=req_id,json=reqId,proto3" json:"req_id,omitempty"`
	Input          []string `protobuf:"bytes,2,rep,name=input,proto3" json:"input,omitempty"`
	Model          *Model   `protobuf:"bytes,3,opt,name=model,proto3" json:"model,omitempty"`
	EncodingFormat *string  `protobuf:"bytes,4,opt,name=encoding_format,json=encodingFormat,proto3,oneof" json:"encoding_format,omitempty"`
	User           *string  `protobuf:"bytes,5,opt,name=user,proto3,oneof" json:"user,omitempty"`
}

func (x *EmbeddingsReq) GetReqId() string {
	if x != nil {
		return x.ReqId
	}
	return ""
}

func (x *EmbeddingsReq) GetInput() []string {
	if x != nil {
		return x.Input
	}
	return nil
}

func (x *EmbeddingsReq) GetModel() *Model {
	if x != nil {
		return x.Model
	}
	return nil
}

func (x *EmbeddingsReq) GetEncodingFormat() string {
	if x != nil && x.EncodingFormat != nil {
		return *x.EncodingFormat
	}
	return ""
}

func (x *EmbeddingsReq) GetUser() string {
	if x != nil && x.User != nil {
		return *x.User
	}
	return ""
}

type Embedding struct {
	Index     *int64    `protobuf:"varint,1,opt,name=index,proto3,oneof" json:"index,omitempty"`
	Embedding []float64 `protobuf:"fixed64,2,rep,packed,name=embedding,proto3" json:"embedding,omitempty"`
	Object    string    `protobuf:"bytes,3,opt,name=object,proto3" json:"object,omitempty"`
}

func (x *Embedding) GetIndex() int64 {
	if x != nil && x.Index != nil {
		return *x.Index
	}
	return 0
}

func (x *Embedding) GetEmbedding() []float64 {
	if x != nil {
		return x.Embedding
	}
	return nil
}

func (x *Embedding) GetObject() string {
	if x != nil {
		return x.Object
	}
	return ""
}

type EmbeddingsResp struct {
	ReqId  string       `protobuf:"bytes,1,opt,name=req_id,json=reqId,proto3" json:"req_id,omitempty"`
	Object string       `protobuf:"bytes,2,opt,name=object,proto3" json:"object,omitempty"`
	Data   []*Embedding `protobuf:"bytes,3,rep,name=data,proto3" json:"data,omitempty"`
	Model  *Model       `protobuf:"bytes,4,opt,name=model,proto3" json:"model,omitempty"`
	Usage  *Usage       `protobuf:"bytes,5,opt,name=usage,proto3" json:"usage,omitempty"`
	Error  *Error       `protobuf:"bytes,6,opt,name=error,proto3" json:"error,omitempty"`
}

func (x *EmbeddingsResp) GetReqId() string {
	if x != nil {
		return x.ReqId
	}
	return ""
}

func (x *EmbeddingsResp) GetObject() string {
	if x != nil {
		return x.Object
	}
	return ""
}

func (x *EmbeddingsResp) GetData() []*Embedding {
	if x != nil {
		return x.Data
	}
	return nil
}

func (x *EmbeddingsResp) GetModel() *Model {
	if x != nil {
		return x.Model
	}
	return nil
}

func (x *EmbeddingsResp) GetUsage() *Usage {
	if x != nil {
		return x.Usage
	}
	return nil
}

func (x *EmbeddingsResp) GetError() *Error {
	if x != nil {
		return x.Error
	}
	return nil
}

type ListString struct {
	Values []string `protobuf:"bytes,1,rep,name=values,proto3" json:"values,omitempty"`
}

func (x *ListString) GetValues() []string {
	if x != nil {
		return x.Values
	}
	return nil
}
