// Copyright 2025 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by the Google Gen AI SDK generator DO NOT EDIT.

package genai

import (
	"fmt"
)

func liveClientContentToMldev(fromObject map[string]any, parentObject map[string]any) (toObject map[string]any, err error) {
	toObject = make(map[string]any)

	fromTurns := getValueByPath(fromObject, []string{"turns"})
	if fromTurns != nil {
		fromTurns, err = applyConverterToSlice(fromTurns.([]any), contentToMldev)
		if err != nil {
			return nil, err
		}

		setValueByPath(toObject, []string{"turns"}, fromTurns)
	}

	fromTurnComplete := getValueByPath(fromObject, []string{"turnComplete"})
	if fromTurnComplete != nil {
		setValueByPath(toObject, []string{"turnComplete"}, fromTurnComplete)
	}

	return toObject, nil
}

func liveClientMessageToMldev(fromObject map[string]any, parentObject map[string]any) (toObject map[string]any, err error) {
	toObject = make(map[string]any)

	fromSetup := getValueByPath(fromObject, []string{"setup"})
	if fromSetup != nil {
		fromSetup, err = liveClientSetupToMldev(fromSetup.(map[string]any), toObject)
		if err != nil {
			return nil, err
		}

		setValueByPath(toObject, []string{"setup"}, fromSetup)
	}

	fromClientContent := getValueByPath(fromObject, []string{"clientContent"})
	if fromClientContent != nil {
		fromClientContent, err = liveClientContentToMldev(fromClientContent.(map[string]any), toObject)
		if err != nil {
			return nil, err
		}

		setValueByPath(toObject, []string{"clientContent"}, fromClientContent)
	}

	fromRealtimeInput := getValueByPath(fromObject, []string{"realtimeInput"})
	if fromRealtimeInput != nil {
		fromRealtimeInput, err = liveClientRealtimeInputToMldev(fromRealtimeInput.(map[string]any), toObject)
		if err != nil {
			return nil, err
		}

		setValueByPath(toObject, []string{"realtimeInput"}, fromRealtimeInput)
	}

	fromToolResponse := getValueByPath(fromObject, []string{"toolResponse"})
	if fromToolResponse != nil {
		setValueByPath(toObject, []string{"toolResponse"}, fromToolResponse)
	}

	return toObject, nil
}

func liveClientMessageToVertex(fromObject map[string]any, parentObject map[string]any) (toObject map[string]any, err error) {
	toObject = make(map[string]any)

	fromSetup := getValueByPath(fromObject, []string{"setup"})
	if fromSetup != nil {
		fromSetup, err = liveClientSetupToVertex(fromSetup.(map[string]any), toObject)
		if err != nil {
			return nil, err
		}

		setValueByPath(toObject, []string{"setup"}, fromSetup)
	}

	fromClientContent := getValueByPath(fromObject, []string{"clientContent"})
	if fromClientContent != nil {
		setValueByPath(toObject, []string{"clientContent"}, fromClientContent)
	}

	fromRealtimeInput := getValueByPath(fromObject, []string{"realtimeInput"})
	if fromRealtimeInput != nil {
		fromRealtimeInput, err = liveClientRealtimeInputToVertex(fromRealtimeInput.(map[string]any), toObject)
		if err != nil {
			return nil, err
		}

		setValueByPath(toObject, []string{"realtimeInput"}, fromRealtimeInput)
	}

	fromToolResponse := getValueByPath(fromObject, []string{"toolResponse"})
	if fromToolResponse != nil {
		setValueByPath(toObject, []string{"toolResponse"}, fromToolResponse)
	}

	return toObject, nil
}

func liveClientRealtimeInputToMldev(fromObject map[string]any, parentObject map[string]any) (toObject map[string]any, err error) {
	toObject = make(map[string]any)

	fromMediaChunks := getValueByPath(fromObject, []string{"mediaChunks"})
	if fromMediaChunks != nil {
		fromMediaChunks, err = applyConverterToSlice(fromMediaChunks.([]any), blobToMldev)
		if err != nil {
			return nil, err
		}

		setValueByPath(toObject, []string{"mediaChunks"}, fromMediaChunks)
	}

	fromActivityStart := getValueByPath(fromObject, []string{"activityStart"})
	if fromActivityStart != nil {
		setValueByPath(toObject, []string{"activityStart"}, fromActivityStart)
	}

	fromActivityEnd := getValueByPath(fromObject, []string{"activityEnd"})
	if fromActivityEnd != nil {
		setValueByPath(toObject, []string{"activityEnd"}, fromActivityEnd)
	}

	return toObject, nil
}

func liveClientRealtimeInputToVertex(fromObject map[string]any, parentObject map[string]any) (toObject map[string]any, err error) {
	toObject = make(map[string]any)

	fromMediaChunks := getValueByPath(fromObject, []string{"mediaChunks"})
	if fromMediaChunks != nil {
		setValueByPath(toObject, []string{"mediaChunks"}, fromMediaChunks)
	}

	fromActivityStart := getValueByPath(fromObject, []string{"activityStart"})
	if fromActivityStart != nil {
		setValueByPath(toObject, []string{"activityStart"}, fromActivityStart)
	}

	fromActivityEnd := getValueByPath(fromObject, []string{"activityEnd"})
	if fromActivityEnd != nil {
		setValueByPath(toObject, []string{"activityEnd"}, fromActivityEnd)
	}

	return toObject, nil
}

func liveClientSetupToMldev(fromObject map[string]any, parentObject map[string]any) (toObject map[string]any, err error) {
	toObject = make(map[string]any)

	fromModel := getValueByPath(fromObject, []string{"model"})
	if fromModel != nil {
		setValueByPath(toObject, []string{"model"}, fromModel)
	}

	fromGenerationConfig := getValueByPath(fromObject, []string{"generationConfig"})
	if fromGenerationConfig != nil {
		setValueByPath(toObject, []string{"generationConfig"}, fromGenerationConfig)
	}

	fromSystemInstruction := getValueByPath(fromObject, []string{"systemInstruction"})
	if fromSystemInstruction != nil {
		fromSystemInstruction, err = tContent(fromSystemInstruction)
		if err != nil {
			return nil, err
		}

		fromSystemInstruction, err = contentToMldev(fromSystemInstruction.(map[string]any), toObject)
		if err != nil {
			return nil, err
		}

		setValueByPath(toObject, []string{"systemInstruction"}, fromSystemInstruction)
	}

	fromTools := getValueByPath(fromObject, []string{"tools"})
	if fromTools != nil {
		fromTools, err = applyItemTransformerToSlice(fromTools.([]any), tTool)
		if err != nil {
			return nil, err
		}

		fromTools, err = tTools(fromTools)
		if err != nil {
			return nil, err
		}

		fromTools, err = applyConverterToSlice(fromTools.([]any), toolToMldev)
		if err != nil {
			return nil, err
		}

		setValueByPath(toObject, []string{"tools"}, fromTools)
	}

	fromRealtimeInputConfig := getValueByPath(fromObject, []string{"realtimeInputConfig"})
	if fromRealtimeInputConfig != nil {
		setValueByPath(toObject, []string{"realtimeInputConfig"}, fromRealtimeInputConfig)
	}

	fromSessionResumption := getValueByPath(fromObject, []string{"sessionResumption"})
	if fromSessionResumption != nil {
		fromSessionResumption, err = sessionResumptionConfigToMldev(fromSessionResumption.(map[string]any), toObject)
		if err != nil {
			return nil, err
		}

		setValueByPath(toObject, []string{"sessionResumption"}, fromSessionResumption)
	}

	fromContextWindowCompression := getValueByPath(fromObject, []string{"contextWindowCompression"})
	if fromContextWindowCompression != nil {
		setValueByPath(toObject, []string{"contextWindowCompression"}, fromContextWindowCompression)
	}

	fromInputAudioTranscription := getValueByPath(fromObject, []string{"inputAudioTranscription"})
	if fromInputAudioTranscription != nil {
		setValueByPath(toObject, []string{"inputAudioTranscription"}, fromInputAudioTranscription)
	}

	fromOutputAudioTranscription := getValueByPath(fromObject, []string{"outputAudioTranscription"})
	if fromOutputAudioTranscription != nil {
		setValueByPath(toObject, []string{"outputAudioTranscription"}, fromOutputAudioTranscription)
	}

	fromProactivity := getValueByPath(fromObject, []string{"proactivity"})
	if fromProactivity != nil {
		setValueByPath(toObject, []string{"proactivity"}, fromProactivity)
	}

	return toObject, nil
}

func liveClientSetupToVertex(fromObject map[string]any, parentObject map[string]any) (toObject map[string]any, err error) {
	toObject = make(map[string]any)

	fromModel := getValueByPath(fromObject, []string{"model"})
	if fromModel != nil {
		setValueByPath(toObject, []string{"model"}, fromModel)
	}

	fromGenerationConfig := getValueByPath(fromObject, []string{"generationConfig"})
	if fromGenerationConfig != nil {
		fromGenerationConfig, err = generationConfigToVertex(fromGenerationConfig.(map[string]any), toObject)
		if err != nil {
			return nil, err
		}

		setValueByPath(toObject, []string{"generationConfig"}, fromGenerationConfig)
	}

	fromSystemInstruction := getValueByPath(fromObject, []string{"systemInstruction"})
	if fromSystemInstruction != nil {
		fromSystemInstruction, err = tContent(fromSystemInstruction)
		if err != nil {
			return nil, err
		}

		setValueByPath(toObject, []string{"systemInstruction"}, fromSystemInstruction)
	}

	fromTools := getValueByPath(fromObject, []string{"tools"})
	if fromTools != nil {
		fromTools, err = applyItemTransformerToSlice(fromTools.([]any), tTool)
		if err != nil {
			return nil, err
		}

		fromTools, err = tTools(fromTools)
		if err != nil {
			return nil, err
		}

		fromTools, err = applyConverterToSlice(fromTools.([]any), toolToVertex)
		if err != nil {
			return nil, err
		}

		setValueByPath(toObject, []string{"tools"}, fromTools)
	}

	fromRealtimeInputConfig := getValueByPath(fromObject, []string{"realtimeInputConfig"})
	if fromRealtimeInputConfig != nil {
		setValueByPath(toObject, []string{"realtimeInputConfig"}, fromRealtimeInputConfig)
	}

	fromSessionResumption := getValueByPath(fromObject, []string{"sessionResumption"})
	if fromSessionResumption != nil {
		setValueByPath(toObject, []string{"sessionResumption"}, fromSessionResumption)
	}

	fromContextWindowCompression := getValueByPath(fromObject, []string{"contextWindowCompression"})
	if fromContextWindowCompression != nil {
		setValueByPath(toObject, []string{"contextWindowCompression"}, fromContextWindowCompression)
	}

	fromInputAudioTranscription := getValueByPath(fromObject, []string{"inputAudioTranscription"})
	if fromInputAudioTranscription != nil {
		setValueByPath(toObject, []string{"inputAudioTranscription"}, fromInputAudioTranscription)
	}

	fromOutputAudioTranscription := getValueByPath(fromObject, []string{"outputAudioTranscription"})
	if fromOutputAudioTranscription != nil {
		setValueByPath(toObject, []string{"outputAudioTranscription"}, fromOutputAudioTranscription)
	}

	fromProactivity := getValueByPath(fromObject, []string{"proactivity"})
	if fromProactivity != nil {
		setValueByPath(toObject, []string{"proactivity"}, fromProactivity)
	}

	return toObject, nil
}

func liveConnectConfigToMldev(fromObject map[string]any, parentObject map[string]any) (toObject map[string]any, err error) {
	toObject = make(map[string]any)

	fromResponseModalities := getValueByPath(fromObject, []string{"responseModalities"})
	if fromResponseModalities != nil {
		setValueByPath(parentObject, []string{"setup", "generationConfig", "responseModalities"}, fromResponseModalities)
	}

	fromTemperature := getValueByPath(fromObject, []string{"temperature"})
	if fromTemperature != nil {
		setValueByPath(parentObject, []string{"setup", "generationConfig", "temperature"}, fromTemperature)
	}

	fromTopP := getValueByPath(fromObject, []string{"topP"})
	if fromTopP != nil {
		setValueByPath(parentObject, []string{"setup", "generationConfig", "topP"}, fromTopP)
	}

	fromTopK := getValueByPath(fromObject, []string{"topK"})
	if fromTopK != nil {
		setValueByPath(parentObject, []string{"setup", "generationConfig", "topK"}, fromTopK)
	}

	fromMaxOutputTokens := getValueByPath(fromObject, []string{"maxOutputTokens"})
	if fromMaxOutputTokens != nil {
		setValueByPath(parentObject, []string{"setup", "generationConfig", "maxOutputTokens"}, fromMaxOutputTokens)
	}

	fromMediaResolution := getValueByPath(fromObject, []string{"mediaResolution"})
	if fromMediaResolution != nil {
		setValueByPath(parentObject, []string{"setup", "generationConfig", "mediaResolution"}, fromMediaResolution)
	}

	fromSeed := getValueByPath(fromObject, []string{"seed"})
	if fromSeed != nil {
		setValueByPath(parentObject, []string{"setup", "generationConfig", "seed"}, fromSeed)
	}

	fromSpeechConfig := getValueByPath(fromObject, []string{"speechConfig"})
	if fromSpeechConfig != nil {
		fromSpeechConfig, err = tLiveSpeechConfig(fromSpeechConfig)
		if err != nil {
			return nil, err
		}

		setValueByPath(parentObject, []string{"setup", "generationConfig", "speechConfig"}, fromSpeechConfig)
	}

	fromThinkingConfig := getValueByPath(fromObject, []string{"thinkingConfig"})
	if fromThinkingConfig != nil {
		setValueByPath(parentObject, []string{"setup", "generationConfig", "thinkingConfig"}, fromThinkingConfig)
	}

	fromEnableAffectiveDialog := getValueByPath(fromObject, []string{"enableAffectiveDialog"})
	if fromEnableAffectiveDialog != nil {
		setValueByPath(parentObject, []string{"setup", "generationConfig", "enableAffectiveDialog"}, fromEnableAffectiveDialog)
	}

	fromSystemInstruction := getValueByPath(fromObject, []string{"systemInstruction"})
	if fromSystemInstruction != nil {
		fromSystemInstruction, err = tContent(fromSystemInstruction)
		if err != nil {
			return nil, err
		}

		fromSystemInstruction, err = contentToMldev(fromSystemInstruction.(map[string]any), toObject)
		if err != nil {
			return nil, err
		}

		setValueByPath(parentObject, []string{"setup", "systemInstruction"}, fromSystemInstruction)
	}

	fromTools := getValueByPath(fromObject, []string{"tools"})
	if fromTools != nil {
		fromTools, err = applyItemTransformerToSlice(fromTools.([]any), tTool)
		if err != nil {
			return nil, err
		}

		fromTools, err = tTools(fromTools)
		if err != nil {
			return nil, err
		}

		fromTools, err = applyConverterToSlice(fromTools.([]any), toolToMldev)
		if err != nil {
			return nil, err
		}

		setValueByPath(parentObject, []string{"setup", "tools"}, fromTools)
	}

	fromSessionResumption := getValueByPath(fromObject, []string{"sessionResumption"})
	if fromSessionResumption != nil {
		fromSessionResumption, err = sessionResumptionConfigToMldev(fromSessionResumption.(map[string]any), toObject)
		if err != nil {
			return nil, err
		}

		setValueByPath(parentObject, []string{"setup", "sessionResumption"}, fromSessionResumption)
	}

	fromInputAudioTranscription := getValueByPath(fromObject, []string{"inputAudioTranscription"})
	if fromInputAudioTranscription != nil {
		setValueByPath(parentObject, []string{"setup", "inputAudioTranscription"}, fromInputAudioTranscription)
	}

	fromOutputAudioTranscription := getValueByPath(fromObject, []string{"outputAudioTranscription"})
	if fromOutputAudioTranscription != nil {
		setValueByPath(parentObject, []string{"setup", "outputAudioTranscription"}, fromOutputAudioTranscription)
	}

	fromRealtimeInputConfig := getValueByPath(fromObject, []string{"realtimeInputConfig"})
	if fromRealtimeInputConfig != nil {
		setValueByPath(parentObject, []string{"setup", "realtimeInputConfig"}, fromRealtimeInputConfig)
	}

	fromContextWindowCompression := getValueByPath(fromObject, []string{"contextWindowCompression"})
	if fromContextWindowCompression != nil {
		setValueByPath(parentObject, []string{"setup", "contextWindowCompression"}, fromContextWindowCompression)
	}

	fromProactivity := getValueByPath(fromObject, []string{"proactivity"})
	if fromProactivity != nil {
		setValueByPath(parentObject, []string{"setup", "proactivity"}, fromProactivity)
	}

	return toObject, nil
}

func liveConnectConfigToVertex(fromObject map[string]any, parentObject map[string]any) (toObject map[string]any, err error) {
	toObject = make(map[string]any)

	fromResponseModalities := getValueByPath(fromObject, []string{"responseModalities"})
	if fromResponseModalities != nil {
		setValueByPath(parentObject, []string{"setup", "generationConfig", "responseModalities"}, fromResponseModalities)
	}

	fromTemperature := getValueByPath(fromObject, []string{"temperature"})
	if fromTemperature != nil {
		setValueByPath(parentObject, []string{"setup", "generationConfig", "temperature"}, fromTemperature)
	}

	fromTopP := getValueByPath(fromObject, []string{"topP"})
	if fromTopP != nil {
		setValueByPath(parentObject, []string{"setup", "generationConfig", "topP"}, fromTopP)
	}

	fromTopK := getValueByPath(fromObject, []string{"topK"})
	if fromTopK != nil {
		setValueByPath(parentObject, []string{"setup", "generationConfig", "topK"}, fromTopK)
	}

	fromMaxOutputTokens := getValueByPath(fromObject, []string{"maxOutputTokens"})
	if fromMaxOutputTokens != nil {
		setValueByPath(parentObject, []string{"setup", "generationConfig", "maxOutputTokens"}, fromMaxOutputTokens)
	}

	fromMediaResolution := getValueByPath(fromObject, []string{"mediaResolution"})
	if fromMediaResolution != nil {
		setValueByPath(parentObject, []string{"setup", "generationConfig", "mediaResolution"}, fromMediaResolution)
	}

	fromSeed := getValueByPath(fromObject, []string{"seed"})
	if fromSeed != nil {
		setValueByPath(parentObject, []string{"setup", "generationConfig", "seed"}, fromSeed)
	}

	fromSpeechConfig := getValueByPath(fromObject, []string{"speechConfig"})
	if fromSpeechConfig != nil {
		fromSpeechConfig, err = tLiveSpeechConfig(fromSpeechConfig)
		if err != nil {
			return nil, err
		}

		fromSpeechConfig, err = speechConfigToVertex(fromSpeechConfig.(map[string]any), toObject)
		if err != nil {
			return nil, err
		}

		setValueByPath(parentObject, []string{"setup", "generationConfig", "speechConfig"}, fromSpeechConfig)
	}

	fromThinkingConfig := getValueByPath(fromObject, []string{"thinkingConfig"})
	if fromThinkingConfig != nil {
		setValueByPath(parentObject, []string{"setup", "generationConfig", "thinkingConfig"}, fromThinkingConfig)
	}

	fromEnableAffectiveDialog := getValueByPath(fromObject, []string{"enableAffectiveDialog"})
	if fromEnableAffectiveDialog != nil {
		setValueByPath(parentObject, []string{"setup", "generationConfig", "enableAffectiveDialog"}, fromEnableAffectiveDialog)
	}

	fromSystemInstruction := getValueByPath(fromObject, []string{"systemInstruction"})
	if fromSystemInstruction != nil {
		fromSystemInstruction, err = tContent(fromSystemInstruction)
		if err != nil {
			return nil, err
		}

		setValueByPath(parentObject, []string{"setup", "systemInstruction"}, fromSystemInstruction)
	}

	fromTools := getValueByPath(fromObject, []string{"tools"})
	if fromTools != nil {
		fromTools, err = applyItemTransformerToSlice(fromTools.([]any), tTool)
		if err != nil {
			return nil, err
		}

		fromTools, err = tTools(fromTools)
		if err != nil {
			return nil, err
		}

		fromTools, err = applyConverterToSlice(fromTools.([]any), toolToVertex)
		if err != nil {
			return nil, err
		}

		setValueByPath(parentObject, []string{"setup", "tools"}, fromTools)
	}

	fromSessionResumption := getValueByPath(fromObject, []string{"sessionResumption"})
	if fromSessionResumption != nil {
		setValueByPath(parentObject, []string{"setup", "sessionResumption"}, fromSessionResumption)
	}

	fromInputAudioTranscription := getValueByPath(fromObject, []string{"inputAudioTranscription"})
	if fromInputAudioTranscription != nil {
		setValueByPath(parentObject, []string{"setup", "inputAudioTranscription"}, fromInputAudioTranscription)
	}

	fromOutputAudioTranscription := getValueByPath(fromObject, []string{"outputAudioTranscription"})
	if fromOutputAudioTranscription != nil {
		setValueByPath(parentObject, []string{"setup", "outputAudioTranscription"}, fromOutputAudioTranscription)
	}

	fromRealtimeInputConfig := getValueByPath(fromObject, []string{"realtimeInputConfig"})
	if fromRealtimeInputConfig != nil {
		setValueByPath(parentObject, []string{"setup", "realtimeInputConfig"}, fromRealtimeInputConfig)
	}

	fromContextWindowCompression := getValueByPath(fromObject, []string{"contextWindowCompression"})
	if fromContextWindowCompression != nil {
		setValueByPath(parentObject, []string{"setup", "contextWindowCompression"}, fromContextWindowCompression)
	}

	fromProactivity := getValueByPath(fromObject, []string{"proactivity"})
	if fromProactivity != nil {
		setValueByPath(parentObject, []string{"setup", "proactivity"}, fromProactivity)
	}

	return toObject, nil
}

func liveConnectParametersToMldev(ac *apiClient, fromObject map[string]any, parentObject map[string]any) (toObject map[string]any, err error) {
	toObject = make(map[string]any)

	fromModel := getValueByPath(fromObject, []string{"model"})
	if fromModel != nil {
		fromModel, err = tModel(ac, fromModel)
		if err != nil {
			return nil, err
		}

		setValueByPath(toObject, []string{"setup", "model"}, fromModel)
	}

	fromConfig := getValueByPath(fromObject, []string{"config"})
	if fromConfig != nil {
		fromConfig, err = liveConnectConfigToMldev(fromConfig.(map[string]any), toObject)
		if err != nil {
			return nil, err
		}

		setValueByPath(toObject, []string{"config"}, fromConfig)
	}

	return toObject, nil
}

func liveConnectParametersToVertex(ac *apiClient, fromObject map[string]any, parentObject map[string]any) (toObject map[string]any, err error) {
	toObject = make(map[string]any)

	fromModel := getValueByPath(fromObject, []string{"model"})
	if fromModel != nil {
		fromModel, err = tModel(ac, fromModel)
		if err != nil {
			return nil, err
		}

		setValueByPath(toObject, []string{"setup", "model"}, fromModel)
	}

	fromConfig := getValueByPath(fromObject, []string{"config"})
	if fromConfig != nil {
		fromConfig, err = liveConnectConfigToVertex(fromConfig.(map[string]any), toObject)
		if err != nil {
			return nil, err
		}

		setValueByPath(toObject, []string{"config"}, fromConfig)
	}

	return toObject, nil
}

func liveSendRealtimeInputParametersToMldev(fromObject map[string]any, parentObject map[string]any) (toObject map[string]any, err error) {
	toObject = make(map[string]any)

	fromMedia := getValueByPath(fromObject, []string{"media"})
	if fromMedia != nil {
		fromMedia, err = tBlobs(fromMedia)
		if err != nil {
			return nil, err
		}

		fromMedia, err = applyConverterToSlice(fromMedia.([]any), blobToMldev)
		if err != nil {
			return nil, err
		}

		setValueByPath(toObject, []string{"mediaChunks"}, fromMedia)
	}

	fromAudio := getValueByPath(fromObject, []string{"audio"})
	if fromAudio != nil {
		fromAudio, err = tAudioBlob(fromAudio)
		if err != nil {
			return nil, err
		}

		fromAudio, err = blobToMldev(fromAudio.(map[string]any), toObject)
		if err != nil {
			return nil, err
		}

		setValueByPath(toObject, []string{"audio"}, fromAudio)
	}

	fromAudioStreamEnd := getValueByPath(fromObject, []string{"audioStreamEnd"})
	if fromAudioStreamEnd != nil {
		setValueByPath(toObject, []string{"audioStreamEnd"}, fromAudioStreamEnd)
	}

	fromVideo := getValueByPath(fromObject, []string{"video"})
	if fromVideo != nil {
		fromVideo, err = tImageBlob(fromVideo)
		if err != nil {
			return nil, err
		}

		fromVideo, err = blobToMldev(fromVideo.(map[string]any), toObject)
		if err != nil {
			return nil, err
		}

		setValueByPath(toObject, []string{"video"}, fromVideo)
	}

	fromText := getValueByPath(fromObject, []string{"text"})
	if fromText != nil {
		setValueByPath(toObject, []string{"text"}, fromText)
	}

	fromActivityStart := getValueByPath(fromObject, []string{"activityStart"})
	if fromActivityStart != nil {
		setValueByPath(toObject, []string{"activityStart"}, fromActivityStart)
	}

	fromActivityEnd := getValueByPath(fromObject, []string{"activityEnd"})
	if fromActivityEnd != nil {
		setValueByPath(toObject, []string{"activityEnd"}, fromActivityEnd)
	}

	return toObject, nil
}

func liveSendRealtimeInputParametersToVertex(fromObject map[string]any, parentObject map[string]any) (toObject map[string]any, err error) {
	toObject = make(map[string]any)

	fromMedia := getValueByPath(fromObject, []string{"media"})
	if fromMedia != nil {
		fromMedia, err = tBlobs(fromMedia)
		if err != nil {
			return nil, err
		}

		setValueByPath(toObject, []string{"mediaChunks"}, fromMedia)
	}

	fromAudio := getValueByPath(fromObject, []string{"audio"})
	if fromAudio != nil {
		fromAudio, err = tAudioBlob(fromAudio)
		if err != nil {
			return nil, err
		}

		setValueByPath(toObject, []string{"audio"}, fromAudio)
	}

	fromAudioStreamEnd := getValueByPath(fromObject, []string{"audioStreamEnd"})
	if fromAudioStreamEnd != nil {
		setValueByPath(toObject, []string{"audioStreamEnd"}, fromAudioStreamEnd)
	}

	fromVideo := getValueByPath(fromObject, []string{"video"})
	if fromVideo != nil {
		fromVideo, err = tImageBlob(fromVideo)
		if err != nil {
			return nil, err
		}

		setValueByPath(toObject, []string{"video"}, fromVideo)
	}

	fromText := getValueByPath(fromObject, []string{"text"})
	if fromText != nil {
		setValueByPath(toObject, []string{"text"}, fromText)
	}

	fromActivityStart := getValueByPath(fromObject, []string{"activityStart"})
	if fromActivityStart != nil {
		setValueByPath(toObject, []string{"activityStart"}, fromActivityStart)
	}

	fromActivityEnd := getValueByPath(fromObject, []string{"activityEnd"})
	if fromActivityEnd != nil {
		setValueByPath(toObject, []string{"activityEnd"}, fromActivityEnd)
	}

	return toObject, nil
}

func liveServerMessageFromVertex(fromObject map[string]any, parentObject map[string]any) (toObject map[string]any, err error) {
	toObject = make(map[string]any)

	fromSetupComplete := getValueByPath(fromObject, []string{"setupComplete"})
	if fromSetupComplete != nil {
		setValueByPath(toObject, []string{"setupComplete"}, fromSetupComplete)
	}

	fromServerContent := getValueByPath(fromObject, []string{"serverContent"})
	if fromServerContent != nil {
		setValueByPath(toObject, []string{"serverContent"}, fromServerContent)
	}

	fromToolCall := getValueByPath(fromObject, []string{"toolCall"})
	if fromToolCall != nil {
		setValueByPath(toObject, []string{"toolCall"}, fromToolCall)
	}

	fromToolCallCancellation := getValueByPath(fromObject, []string{"toolCallCancellation"})
	if fromToolCallCancellation != nil {
		setValueByPath(toObject, []string{"toolCallCancellation"}, fromToolCallCancellation)
	}

	fromUsageMetadata := getValueByPath(fromObject, []string{"usageMetadata"})
	if fromUsageMetadata != nil {
		fromUsageMetadata, err = usageMetadataFromVertex(fromUsageMetadata.(map[string]any), toObject)
		if err != nil {
			return nil, err
		}

		setValueByPath(toObject, []string{"usageMetadata"}, fromUsageMetadata)
	}

	fromGoAway := getValueByPath(fromObject, []string{"goAway"})
	if fromGoAway != nil {
		setValueByPath(toObject, []string{"goAway"}, fromGoAway)
	}

	fromSessionResumptionUpdate := getValueByPath(fromObject, []string{"sessionResumptionUpdate"})
	if fromSessionResumptionUpdate != nil {
		setValueByPath(toObject, []string{"sessionResumptionUpdate"}, fromSessionResumptionUpdate)
	}

	return toObject, nil
}

func sessionResumptionConfigToMldev(fromObject map[string]any, parentObject map[string]any) (toObject map[string]any, err error) {
	toObject = make(map[string]any)

	fromHandle := getValueByPath(fromObject, []string{"handle"})
	if fromHandle != nil {
		setValueByPath(toObject, []string{"handle"}, fromHandle)
	}

	if getValueByPath(fromObject, []string{"transparent"}) != nil {
		return nil, fmt.Errorf("transparent parameter is not supported in Gemini API")
	}

	return toObject, nil
}

func usageMetadataFromVertex(fromObject map[string]any, parentObject map[string]any) (toObject map[string]any, err error) {
	toObject = make(map[string]any)

	fromPromptTokenCount := getValueByPath(fromObject, []string{"promptTokenCount"})
	if fromPromptTokenCount != nil {
		setValueByPath(toObject, []string{"promptTokenCount"}, fromPromptTokenCount)
	}

	fromCachedContentTokenCount := getValueByPath(fromObject, []string{"cachedContentTokenCount"})
	if fromCachedContentTokenCount != nil {
		setValueByPath(toObject, []string{"cachedContentTokenCount"}, fromCachedContentTokenCount)
	}

	fromResponseTokenCount := getValueByPath(fromObject, []string{"candidatesTokenCount"})
	if fromResponseTokenCount != nil {
		setValueByPath(toObject, []string{"responseTokenCount"}, fromResponseTokenCount)
	}

	fromToolUsePromptTokenCount := getValueByPath(fromObject, []string{"toolUsePromptTokenCount"})
	if fromToolUsePromptTokenCount != nil {
		setValueByPath(toObject, []string{"toolUsePromptTokenCount"}, fromToolUsePromptTokenCount)
	}

	fromThoughtsTokenCount := getValueByPath(fromObject, []string{"thoughtsTokenCount"})
	if fromThoughtsTokenCount != nil {
		setValueByPath(toObject, []string{"thoughtsTokenCount"}, fromThoughtsTokenCount)
	}

	fromTotalTokenCount := getValueByPath(fromObject, []string{"totalTokenCount"})
	if fromTotalTokenCount != nil {
		setValueByPath(toObject, []string{"totalTokenCount"}, fromTotalTokenCount)
	}

	fromPromptTokensDetails := getValueByPath(fromObject, []string{"promptTokensDetails"})
	if fromPromptTokensDetails != nil {
		setValueByPath(toObject, []string{"promptTokensDetails"}, fromPromptTokensDetails)
	}

	fromCacheTokensDetails := getValueByPath(fromObject, []string{"cacheTokensDetails"})
	if fromCacheTokensDetails != nil {
		setValueByPath(toObject, []string{"cacheTokensDetails"}, fromCacheTokensDetails)
	}

	fromResponseTokensDetails := getValueByPath(fromObject, []string{"candidatesTokensDetails"})
	if fromResponseTokensDetails != nil {
		setValueByPath(toObject, []string{"responseTokensDetails"}, fromResponseTokensDetails)
	}

	fromToolUsePromptTokensDetails := getValueByPath(fromObject, []string{"toolUsePromptTokensDetails"})
	if fromToolUsePromptTokensDetails != nil {
		setValueByPath(toObject, []string{"toolUsePromptTokensDetails"}, fromToolUsePromptTokensDetails)
	}

	fromTrafficType := getValueByPath(fromObject, []string{"trafficType"})
	if fromTrafficType != nil {
		setValueByPath(toObject, []string{"trafficType"}, fromTrafficType)
	}

	return toObject, nil
}
