#!/usr/bin/env python3

# Copyright 2020 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

with open("pcsc_errors") as f:
    data = f.read()

name = ""
val = 0
desc = ""

with open("pcsc_errors.go", 'w+') as f:
    print("""// Copyright 2020 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

package piv

// https://golang.org/s/generatedcode

// Code generated by errors.py DO NOT EDIT.

var pcscErrMsgs = map[int64]string{""", file=f)
    for line in data.split("\n"):
        if not line.strip():
            continue
        if line.startswith("SC"):
            name = line.split()[0][len("SCARD_E_"):]
            name = "".join([s[0] + s[1:].lower() for s in name.split("_")])
            name = "rc" + name
            val = line.split()[1]
        else:
            desc = line[:-1]
            desc = desc[0].lower() + desc[1:]
            desc = desc.replace("\"", "\\\"")
            print("\t%s: \"%s\"," % (val, desc), file=f)
    print("}", file=f)
