package storage

// Code generated by cdproto-gen. DO NOT EDIT.

import (
	"fmt"
	"strings"

	"github.com/chromedp/cdproto/cdp"
	"github.com/chromedp/cdproto/target"
)

// SerializedStorageKey [no description].
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/Storage#type-SerializedStorageKey
type SerializedStorageKey string

// String returns the SerializedStorageKey as string value.
func (t SerializedStorageKey) String() string {
	return string(t)
}

// Type enum of possible storage types.
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/Storage#type-StorageType
type Type string

// String returns the Type as string value.
func (t Type) String() string {
	return string(t)
}

// Type values.
const (
	TypeCookies        Type = "cookies"
	TypeFileSystems    Type = "file_systems"
	TypeIndexeddb      Type = "indexeddb"
	TypeLocalStorage   Type = "local_storage"
	TypeShaderCache    Type = "shader_cache"
	TypeWebsql         Type = "websql"
	TypeServiceWorkers Type = "service_workers"
	TypeCacheStorage   Type = "cache_storage"
	TypeInterestGroups Type = "interest_groups"
	TypeSharedStorage  Type = "shared_storage"
	TypeStorageBuckets Type = "storage_buckets"
	TypeAll            Type = "all"
	TypeOther          Type = "other"
)

// UnmarshalJSON satisfies [json.Unmarshaler].
func (t *Type) UnmarshalJSON(buf []byte) error {
	s := string(buf)
	s = strings.TrimSuffix(strings.TrimPrefix(s, `"`), `"`)

	switch Type(s) {
	case TypeCookies:
		*t = TypeCookies
	case TypeFileSystems:
		*t = TypeFileSystems
	case TypeIndexeddb:
		*t = TypeIndexeddb
	case TypeLocalStorage:
		*t = TypeLocalStorage
	case TypeShaderCache:
		*t = TypeShaderCache
	case TypeWebsql:
		*t = TypeWebsql
	case TypeServiceWorkers:
		*t = TypeServiceWorkers
	case TypeCacheStorage:
		*t = TypeCacheStorage
	case TypeInterestGroups:
		*t = TypeInterestGroups
	case TypeSharedStorage:
		*t = TypeSharedStorage
	case TypeStorageBuckets:
		*t = TypeStorageBuckets
	case TypeAll:
		*t = TypeAll
	case TypeOther:
		*t = TypeOther
	default:
		return fmt.Errorf("unknown Type value: %v", s)
	}
	return nil
}

// UsageForType usage for a storage type.
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/Storage#type-UsageForType
type UsageForType struct {
	StorageType Type    `json:"storageType"` // Name of storage type.
	Usage       float64 `json:"usage"`       // Storage usage (bytes).
}

// TrustTokens pair of issuer origin and number of available (signed, but not
// used) Trust Tokens from that issuer.
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/Storage#type-TrustTokens
type TrustTokens struct {
	IssuerOrigin string  `json:"issuerOrigin"`
	Count        float64 `json:"count"`
}

// InterestGroupAuctionID protected audience interest group auction
// identifier.
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/Storage#type-InterestGroupAuctionId
type InterestGroupAuctionID string

// String returns the InterestGroupAuctionID as string value.
func (t InterestGroupAuctionID) String() string {
	return string(t)
}

// InterestGroupAccessType enum of interest group access types.
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/Storage#type-InterestGroupAccessType
type InterestGroupAccessType string

// String returns the InterestGroupAccessType as string value.
func (t InterestGroupAccessType) String() string {
	return string(t)
}

// InterestGroupAccessType values.
const (
	InterestGroupAccessTypeJoin                  InterestGroupAccessType = "join"
	InterestGroupAccessTypeLeave                 InterestGroupAccessType = "leave"
	InterestGroupAccessTypeUpdate                InterestGroupAccessType = "update"
	InterestGroupAccessTypeLoaded                InterestGroupAccessType = "loaded"
	InterestGroupAccessTypeBid                   InterestGroupAccessType = "bid"
	InterestGroupAccessTypeWin                   InterestGroupAccessType = "win"
	InterestGroupAccessTypeAdditionalBid         InterestGroupAccessType = "additionalBid"
	InterestGroupAccessTypeAdditionalBidWin      InterestGroupAccessType = "additionalBidWin"
	InterestGroupAccessTypeTopLevelBid           InterestGroupAccessType = "topLevelBid"
	InterestGroupAccessTypeTopLevelAdditionalBid InterestGroupAccessType = "topLevelAdditionalBid"
	InterestGroupAccessTypeClear                 InterestGroupAccessType = "clear"
)

// UnmarshalJSON satisfies [json.Unmarshaler].
func (t *InterestGroupAccessType) UnmarshalJSON(buf []byte) error {
	s := string(buf)
	s = strings.TrimSuffix(strings.TrimPrefix(s, `"`), `"`)

	switch InterestGroupAccessType(s) {
	case InterestGroupAccessTypeJoin:
		*t = InterestGroupAccessTypeJoin
	case InterestGroupAccessTypeLeave:
		*t = InterestGroupAccessTypeLeave
	case InterestGroupAccessTypeUpdate:
		*t = InterestGroupAccessTypeUpdate
	case InterestGroupAccessTypeLoaded:
		*t = InterestGroupAccessTypeLoaded
	case InterestGroupAccessTypeBid:
		*t = InterestGroupAccessTypeBid
	case InterestGroupAccessTypeWin:
		*t = InterestGroupAccessTypeWin
	case InterestGroupAccessTypeAdditionalBid:
		*t = InterestGroupAccessTypeAdditionalBid
	case InterestGroupAccessTypeAdditionalBidWin:
		*t = InterestGroupAccessTypeAdditionalBidWin
	case InterestGroupAccessTypeTopLevelBid:
		*t = InterestGroupAccessTypeTopLevelBid
	case InterestGroupAccessTypeTopLevelAdditionalBid:
		*t = InterestGroupAccessTypeTopLevelAdditionalBid
	case InterestGroupAccessTypeClear:
		*t = InterestGroupAccessTypeClear
	default:
		return fmt.Errorf("unknown InterestGroupAccessType value: %v", s)
	}
	return nil
}

// InterestGroupAuctionEventType enum of auction events.
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/Storage#type-InterestGroupAuctionEventType
type InterestGroupAuctionEventType string

// String returns the InterestGroupAuctionEventType as string value.
func (t InterestGroupAuctionEventType) String() string {
	return string(t)
}

// InterestGroupAuctionEventType values.
const (
	InterestGroupAuctionEventTypeStarted        InterestGroupAuctionEventType = "started"
	InterestGroupAuctionEventTypeConfigResolved InterestGroupAuctionEventType = "configResolved"
)

// UnmarshalJSON satisfies [json.Unmarshaler].
func (t *InterestGroupAuctionEventType) UnmarshalJSON(buf []byte) error {
	s := string(buf)
	s = strings.TrimSuffix(strings.TrimPrefix(s, `"`), `"`)

	switch InterestGroupAuctionEventType(s) {
	case InterestGroupAuctionEventTypeStarted:
		*t = InterestGroupAuctionEventTypeStarted
	case InterestGroupAuctionEventTypeConfigResolved:
		*t = InterestGroupAuctionEventTypeConfigResolved
	default:
		return fmt.Errorf("unknown InterestGroupAuctionEventType value: %v", s)
	}
	return nil
}

// InterestGroupAuctionFetchType enum of network fetches auctions can do.
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/Storage#type-InterestGroupAuctionFetchType
type InterestGroupAuctionFetchType string

// String returns the InterestGroupAuctionFetchType as string value.
func (t InterestGroupAuctionFetchType) String() string {
	return string(t)
}

// InterestGroupAuctionFetchType values.
const (
	InterestGroupAuctionFetchTypeBidderJs             InterestGroupAuctionFetchType = "bidderJs"
	InterestGroupAuctionFetchTypeBidderWasm           InterestGroupAuctionFetchType = "bidderWasm"
	InterestGroupAuctionFetchTypeSellerJs             InterestGroupAuctionFetchType = "sellerJs"
	InterestGroupAuctionFetchTypeBidderTrustedSignals InterestGroupAuctionFetchType = "bidderTrustedSignals"
	InterestGroupAuctionFetchTypeSellerTrustedSignals InterestGroupAuctionFetchType = "sellerTrustedSignals"
)

// UnmarshalJSON satisfies [json.Unmarshaler].
func (t *InterestGroupAuctionFetchType) UnmarshalJSON(buf []byte) error {
	s := string(buf)
	s = strings.TrimSuffix(strings.TrimPrefix(s, `"`), `"`)

	switch InterestGroupAuctionFetchType(s) {
	case InterestGroupAuctionFetchTypeBidderJs:
		*t = InterestGroupAuctionFetchTypeBidderJs
	case InterestGroupAuctionFetchTypeBidderWasm:
		*t = InterestGroupAuctionFetchTypeBidderWasm
	case InterestGroupAuctionFetchTypeSellerJs:
		*t = InterestGroupAuctionFetchTypeSellerJs
	case InterestGroupAuctionFetchTypeBidderTrustedSignals:
		*t = InterestGroupAuctionFetchTypeBidderTrustedSignals
	case InterestGroupAuctionFetchTypeSellerTrustedSignals:
		*t = InterestGroupAuctionFetchTypeSellerTrustedSignals
	default:
		return fmt.Errorf("unknown InterestGroupAuctionFetchType value: %v", s)
	}
	return nil
}

// SharedStorageAccessScope enum of shared storage access scopes.
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/Storage#type-SharedStorageAccessScope
type SharedStorageAccessScope string

// String returns the SharedStorageAccessScope as string value.
func (t SharedStorageAccessScope) String() string {
	return string(t)
}

// SharedStorageAccessScope values.
const (
	SharedStorageAccessScopeWindow                   SharedStorageAccessScope = "window"
	SharedStorageAccessScopeSharedStorageWorklet     SharedStorageAccessScope = "sharedStorageWorklet"
	SharedStorageAccessScopeProtectedAudienceWorklet SharedStorageAccessScope = "protectedAudienceWorklet"
	SharedStorageAccessScopeHeader                   SharedStorageAccessScope = "header"
)

// UnmarshalJSON satisfies [json.Unmarshaler].
func (t *SharedStorageAccessScope) UnmarshalJSON(buf []byte) error {
	s := string(buf)
	s = strings.TrimSuffix(strings.TrimPrefix(s, `"`), `"`)

	switch SharedStorageAccessScope(s) {
	case SharedStorageAccessScopeWindow:
		*t = SharedStorageAccessScopeWindow
	case SharedStorageAccessScopeSharedStorageWorklet:
		*t = SharedStorageAccessScopeSharedStorageWorklet
	case SharedStorageAccessScopeProtectedAudienceWorklet:
		*t = SharedStorageAccessScopeProtectedAudienceWorklet
	case SharedStorageAccessScopeHeader:
		*t = SharedStorageAccessScopeHeader
	default:
		return fmt.Errorf("unknown SharedStorageAccessScope value: %v", s)
	}
	return nil
}

// SharedStorageAccessMethod enum of shared storage access methods.
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/Storage#type-SharedStorageAccessMethod
type SharedStorageAccessMethod string

// String returns the SharedStorageAccessMethod as string value.
func (t SharedStorageAccessMethod) String() string {
	return string(t)
}

// SharedStorageAccessMethod values.
const (
	SharedStorageAccessMethodAddModule       SharedStorageAccessMethod = "addModule"
	SharedStorageAccessMethodCreateWorklet   SharedStorageAccessMethod = "createWorklet"
	SharedStorageAccessMethodSelectURL       SharedStorageAccessMethod = "selectURL"
	SharedStorageAccessMethodRun             SharedStorageAccessMethod = "run"
	SharedStorageAccessMethodBatchUpdate     SharedStorageAccessMethod = "batchUpdate"
	SharedStorageAccessMethodSet             SharedStorageAccessMethod = "set"
	SharedStorageAccessMethodAppend          SharedStorageAccessMethod = "append"
	SharedStorageAccessMethodDelete          SharedStorageAccessMethod = "delete"
	SharedStorageAccessMethodClear           SharedStorageAccessMethod = "clear"
	SharedStorageAccessMethodGet             SharedStorageAccessMethod = "get"
	SharedStorageAccessMethodKeys            SharedStorageAccessMethod = "keys"
	SharedStorageAccessMethodValues          SharedStorageAccessMethod = "values"
	SharedStorageAccessMethodEntries         SharedStorageAccessMethod = "entries"
	SharedStorageAccessMethodLength          SharedStorageAccessMethod = "length"
	SharedStorageAccessMethodRemainingBudget SharedStorageAccessMethod = "remainingBudget"
)

// UnmarshalJSON satisfies [json.Unmarshaler].
func (t *SharedStorageAccessMethod) UnmarshalJSON(buf []byte) error {
	s := string(buf)
	s = strings.TrimSuffix(strings.TrimPrefix(s, `"`), `"`)

	switch SharedStorageAccessMethod(s) {
	case SharedStorageAccessMethodAddModule:
		*t = SharedStorageAccessMethodAddModule
	case SharedStorageAccessMethodCreateWorklet:
		*t = SharedStorageAccessMethodCreateWorklet
	case SharedStorageAccessMethodSelectURL:
		*t = SharedStorageAccessMethodSelectURL
	case SharedStorageAccessMethodRun:
		*t = SharedStorageAccessMethodRun
	case SharedStorageAccessMethodBatchUpdate:
		*t = SharedStorageAccessMethodBatchUpdate
	case SharedStorageAccessMethodSet:
		*t = SharedStorageAccessMethodSet
	case SharedStorageAccessMethodAppend:
		*t = SharedStorageAccessMethodAppend
	case SharedStorageAccessMethodDelete:
		*t = SharedStorageAccessMethodDelete
	case SharedStorageAccessMethodClear:
		*t = SharedStorageAccessMethodClear
	case SharedStorageAccessMethodGet:
		*t = SharedStorageAccessMethodGet
	case SharedStorageAccessMethodKeys:
		*t = SharedStorageAccessMethodKeys
	case SharedStorageAccessMethodValues:
		*t = SharedStorageAccessMethodValues
	case SharedStorageAccessMethodEntries:
		*t = SharedStorageAccessMethodEntries
	case SharedStorageAccessMethodLength:
		*t = SharedStorageAccessMethodLength
	case SharedStorageAccessMethodRemainingBudget:
		*t = SharedStorageAccessMethodRemainingBudget
	default:
		return fmt.Errorf("unknown SharedStorageAccessMethod value: %v", s)
	}
	return nil
}

// SharedStorageEntry struct for a single key-value pair in an origin's
// shared storage.
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/Storage#type-SharedStorageEntry
type SharedStorageEntry struct {
	Key   string `json:"key"`
	Value string `json:"value"`
}

// SharedStorageMetadata details for an origin's shared storage.
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/Storage#type-SharedStorageMetadata
type SharedStorageMetadata struct {
	CreationTime    *cdp.TimeSinceEpoch `json:"creationTime"`    // Time when the origin's shared storage was last created.
	Length          int64               `json:"length"`          // Number of key-value pairs stored in origin's shared storage.
	RemainingBudget float64             `json:"remainingBudget"` // Current amount of bits of entropy remaining in the navigation budget.
	BytesUsed       int64               `json:"bytesUsed"`       // Total number of bytes stored as key-value pairs in origin's shared storage.
}

// SharedStoragePrivateAggregationConfig represents a dictionary object
// passed in as privateAggregationConfig to run or selectURL.
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/Storage#type-SharedStoragePrivateAggregationConfig
type SharedStoragePrivateAggregationConfig struct {
	AggregationCoordinatorOrigin string `json:"aggregationCoordinatorOrigin,omitempty,omitzero"` // The chosen aggregation service deployment.
	ContextID                    string `json:"contextId,omitempty,omitzero"`                    // The context ID provided.
	FilteringIDMaxBytes          int64  `json:"filteringIdMaxBytes"`                             // Configures the maximum size allowed for filtering IDs.
	MaxContributions             int64  `json:"maxContributions,omitempty,omitzero"`             // The limit on the number of contributions in the final report.
}

// SharedStorageReportingMetadata pair of reporting metadata details for a
// candidate URL for selectURL().
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/Storage#type-SharedStorageReportingMetadata
type SharedStorageReportingMetadata struct {
	EventType    string `json:"eventType"`
	ReportingURL string `json:"reportingUrl"`
}

// SharedStorageURLWithMetadata bundles a candidate URL with its reporting
// metadata.
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/Storage#type-SharedStorageUrlWithMetadata
type SharedStorageURLWithMetadata struct {
	URL               string                            `json:"url"`               // Spec of candidate URL.
	ReportingMetadata []*SharedStorageReportingMetadata `json:"reportingMetadata"` // Any associated reporting metadata.
}

// SharedStorageAccessParams bundles the parameters for shared storage access
// events whose presence/absence can vary according to SharedStorageAccessType.
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/Storage#type-SharedStorageAccessParams
type SharedStorageAccessParams struct {
	ScriptSourceURL          string                                 `json:"scriptSourceUrl,omitempty,omitzero"`          // Spec of the module script URL. Present only for SharedStorageAccessMethods: addModule and createWorklet.
	DataOrigin               string                                 `json:"dataOrigin,omitempty,omitzero"`               // String denoting "context-origin", "script-origin", or a custom origin to be used as the worklet's data origin. Present only for SharedStorageAccessMethod: createWorklet.
	OperationName            string                                 `json:"operationName,omitempty,omitzero"`            // Name of the registered operation to be run. Present only for SharedStorageAccessMethods: run and selectURL.
	OperationID              string                                 `json:"operationId,omitempty,omitzero"`              // ID of the operation call. Present only for SharedStorageAccessMethods: run and selectURL.
	KeepAlive                bool                                   `json:"keepAlive"`                                   // Whether or not to keep the worket alive for future run or selectURL calls. Present only for SharedStorageAccessMethods: run and selectURL.
	PrivateAggregationConfig *SharedStoragePrivateAggregationConfig `json:"privateAggregationConfig,omitempty,omitzero"` // Configures the private aggregation options. Present only for SharedStorageAccessMethods: run and selectURL.
	SerializedData           string                                 `json:"serializedData,omitempty,omitzero"`           // The operation's serialized data in bytes (converted to a string). Present only for SharedStorageAccessMethods: run and selectURL. TODO(crbug.com/401011862): Consider updating this parameter to binary.
	URLsWithMetadata         []*SharedStorageURLWithMetadata        `json:"urlsWithMetadata,omitempty,omitzero"`         // Array of candidate URLs' specs, along with any associated metadata. Present only for SharedStorageAccessMethod: selectURL.
	UrnUUID                  string                                 `json:"urnUuid,omitempty,omitzero"`                  // Spec of the URN:UUID generated for a selectURL call. Present only for SharedStorageAccessMethod: selectURL.
	Key                      string                                 `json:"key,omitempty,omitzero"`                      // Key for a specific entry in an origin's shared storage. Present only for SharedStorageAccessMethods: set, append, delete, and get.
	Value                    string                                 `json:"value,omitempty,omitzero"`                    // Value for a specific entry in an origin's shared storage. Present only for SharedStorageAccessMethods: set and append.
	IgnoreIfPresent          bool                                   `json:"ignoreIfPresent"`                             // Whether or not to set an entry for a key if that key is already present. Present only for SharedStorageAccessMethod: set.
	WorkletOrdinal           int64                                  `json:"workletOrdinal,omitempty,omitzero"`           // A number denoting the (0-based) order of the worklet's creation relative to all other shared storage worklets created by documents using the current storage partition. Present only for SharedStorageAccessMethods: addModule, createWorklet.
	WorkletTargetID          target.ID                              `json:"workletTargetId,omitempty,omitzero"`          // Hex representation of the DevTools token used as the TargetID for the associated shared storage worklet. Present only for SharedStorageAccessMethods: addModule, createWorklet, run, selectURL, and any other SharedStorageAccessMethod when the SharedStorageAccessScope is sharedStorageWorklet.
	WithLock                 string                                 `json:"withLock,omitempty,omitzero"`                 // Name of the lock to be acquired, if present. Optionally present only for SharedStorageAccessMethods: batchUpdate, set, append, delete, and clear.
	BatchUpdateID            string                                 `json:"batchUpdateId,omitempty,omitzero"`            // If the method has been called as part of a batchUpdate, then this number identifies the batch to which it belongs. Optionally present only for SharedStorageAccessMethods: batchUpdate (required), set, append, delete, and clear.
	BatchSize                int64                                  `json:"batchSize,omitempty,omitzero"`                // Number of modifier methods sent in batch. Present only for SharedStorageAccessMethod: batchUpdate.
}

// BucketsDurability [no description].
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/Storage#type-StorageBucketsDurability
type BucketsDurability string

// String returns the BucketsDurability as string value.
func (t BucketsDurability) String() string {
	return string(t)
}

// BucketsDurability values.
const (
	BucketsDurabilityRelaxed BucketsDurability = "relaxed"
	BucketsDurabilityStrict  BucketsDurability = "strict"
)

// UnmarshalJSON satisfies [json.Unmarshaler].
func (t *BucketsDurability) UnmarshalJSON(buf []byte) error {
	s := string(buf)
	s = strings.TrimSuffix(strings.TrimPrefix(s, `"`), `"`)

	switch BucketsDurability(s) {
	case BucketsDurabilityRelaxed:
		*t = BucketsDurabilityRelaxed
	case BucketsDurabilityStrict:
		*t = BucketsDurabilityStrict
	default:
		return fmt.Errorf("unknown BucketsDurability value: %v", s)
	}
	return nil
}

// Bucket [no description].
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/Storage#type-StorageBucket
type Bucket struct {
	StorageKey SerializedStorageKey `json:"storageKey"`
	Name       string               `json:"name,omitempty,omitzero"` // If not specified, it is the default bucket of the storageKey.
}

// BucketInfo [no description].
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/Storage#type-StorageBucketInfo
type BucketInfo struct {
	Bucket     *Bucket             `json:"bucket"`
	ID         string              `json:"id"`
	Expiration *cdp.TimeSinceEpoch `json:"expiration"`
	Quota      float64             `json:"quota"` // Storage quota (bytes).
	Persistent bool                `json:"persistent"`
	Durability BucketsDurability   `json:"durability"`
}

// AttributionReportingSourceType [no description].
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/Storage#type-AttributionReportingSourceType
type AttributionReportingSourceType string

// String returns the AttributionReportingSourceType as string value.
func (t AttributionReportingSourceType) String() string {
	return string(t)
}

// AttributionReportingSourceType values.
const (
	AttributionReportingSourceTypeNavigation AttributionReportingSourceType = "navigation"
	AttributionReportingSourceTypeEvent      AttributionReportingSourceType = "event"
)

// UnmarshalJSON satisfies [json.Unmarshaler].
func (t *AttributionReportingSourceType) UnmarshalJSON(buf []byte) error {
	s := string(buf)
	s = strings.TrimSuffix(strings.TrimPrefix(s, `"`), `"`)

	switch AttributionReportingSourceType(s) {
	case AttributionReportingSourceTypeNavigation:
		*t = AttributionReportingSourceTypeNavigation
	case AttributionReportingSourceTypeEvent:
		*t = AttributionReportingSourceTypeEvent
	default:
		return fmt.Errorf("unknown AttributionReportingSourceType value: %v", s)
	}
	return nil
}

// UnsignedInt64asBase10 [no description].
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/Storage#type-UnsignedInt64AsBase10
type UnsignedInt64asBase10 string

// String returns the UnsignedInt64asBase10 as string value.
func (t UnsignedInt64asBase10) String() string {
	return string(t)
}

// UnsignedInt128asBase16 [no description].
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/Storage#type-UnsignedInt128AsBase16
type UnsignedInt128asBase16 string

// String returns the UnsignedInt128asBase16 as string value.
func (t UnsignedInt128asBase16) String() string {
	return string(t)
}

// SignedInt64asBase10 [no description].
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/Storage#type-SignedInt64AsBase10
type SignedInt64asBase10 string

// String returns the SignedInt64asBase10 as string value.
func (t SignedInt64asBase10) String() string {
	return string(t)
}

// AttributionReportingFilterDataEntry [no description].
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/Storage#type-AttributionReportingFilterDataEntry
type AttributionReportingFilterDataEntry struct {
	Key    string   `json:"key"`
	Values []string `json:"values"`
}

// AttributionReportingFilterConfig [no description].
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/Storage#type-AttributionReportingFilterConfig
type AttributionReportingFilterConfig struct {
	FilterValues   []*AttributionReportingFilterDataEntry `json:"filterValues"`
	LookbackWindow int64                                  `json:"lookbackWindow,omitempty,omitzero"` // duration in seconds
}

// AttributionReportingFilterPair [no description].
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/Storage#type-AttributionReportingFilterPair
type AttributionReportingFilterPair struct {
	Filters    []*AttributionReportingFilterConfig `json:"filters"`
	NotFilters []*AttributionReportingFilterConfig `json:"notFilters"`
}

// AttributionReportingAggregationKeysEntry [no description].
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/Storage#type-AttributionReportingAggregationKeysEntry
type AttributionReportingAggregationKeysEntry struct {
	Key   string                 `json:"key"`
	Value UnsignedInt128asBase16 `json:"value"`
}

// AttributionReportingEventReportWindows [no description].
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/Storage#type-AttributionReportingEventReportWindows
type AttributionReportingEventReportWindows struct {
	Start int64   `json:"start"` // duration in seconds
	Ends  []int64 `json:"ends"`  // duration in seconds
}

// AttributionReportingTriggerDataMatching [no description].
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/Storage#type-AttributionReportingTriggerDataMatching
type AttributionReportingTriggerDataMatching string

// String returns the AttributionReportingTriggerDataMatching as string value.
func (t AttributionReportingTriggerDataMatching) String() string {
	return string(t)
}

// AttributionReportingTriggerDataMatching values.
const (
	AttributionReportingTriggerDataMatchingExact   AttributionReportingTriggerDataMatching = "exact"
	AttributionReportingTriggerDataMatchingModulus AttributionReportingTriggerDataMatching = "modulus"
)

// UnmarshalJSON satisfies [json.Unmarshaler].
func (t *AttributionReportingTriggerDataMatching) UnmarshalJSON(buf []byte) error {
	s := string(buf)
	s = strings.TrimSuffix(strings.TrimPrefix(s, `"`), `"`)

	switch AttributionReportingTriggerDataMatching(s) {
	case AttributionReportingTriggerDataMatchingExact:
		*t = AttributionReportingTriggerDataMatchingExact
	case AttributionReportingTriggerDataMatchingModulus:
		*t = AttributionReportingTriggerDataMatchingModulus
	default:
		return fmt.Errorf("unknown AttributionReportingTriggerDataMatching value: %v", s)
	}
	return nil
}

// AttributionReportingAggregatableDebugReportingData [no description].
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/Storage#type-AttributionReportingAggregatableDebugReportingData
type AttributionReportingAggregatableDebugReportingData struct {
	KeyPiece UnsignedInt128asBase16 `json:"keyPiece"`
	Value    float64                `json:"value"` // number instead of integer because not all uint32 can be represented by int
	Types    []string               `json:"types"`
}

// AttributionReportingAggregatableDebugReportingConfig [no description].
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/Storage#type-AttributionReportingAggregatableDebugReportingConfig
type AttributionReportingAggregatableDebugReportingConfig struct {
	Budget                       float64                                               `json:"budget,omitempty,omitzero"` // number instead of integer because not all uint32 can be represented by int, only present for source registrations
	KeyPiece                     UnsignedInt128asBase16                                `json:"keyPiece"`
	DebugData                    []*AttributionReportingAggregatableDebugReportingData `json:"debugData"`
	AggregationCoordinatorOrigin string                                                `json:"aggregationCoordinatorOrigin,omitempty,omitzero"`
}

// AttributionScopesData [no description].
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/Storage#type-AttributionScopesData
type AttributionScopesData struct {
	Values         []string `json:"values"`
	Limit          float64  `json:"limit"` // number instead of integer because not all uint32 can be represented by int
	MaxEventStates float64  `json:"maxEventStates"`
}

// AttributionReportingNamedBudgetDef [no description].
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/Storage#type-AttributionReportingNamedBudgetDef
type AttributionReportingNamedBudgetDef struct {
	Name   string `json:"name"`
	Budget int64  `json:"budget"`
}

// AttributionReportingSourceRegistration [no description].
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/Storage#type-AttributionReportingSourceRegistration
type AttributionReportingSourceRegistration struct {
	Time                             *cdp.TimeSinceEpoch                                   `json:"time"`
	Expiry                           int64                                                 `json:"expiry"`      // duration in seconds
	TriggerData                      []float64                                             `json:"triggerData"` // number instead of integer because not all uint32 can be represented by int
	EventReportWindows               *AttributionReportingEventReportWindows               `json:"eventReportWindows"`
	AggregatableReportWindow         int64                                                 `json:"aggregatableReportWindow"` // duration in seconds
	Type                             AttributionReportingSourceType                        `json:"type"`
	SourceOrigin                     string                                                `json:"sourceOrigin"`
	ReportingOrigin                  string                                                `json:"reportingOrigin"`
	DestinationSites                 []string                                              `json:"destinationSites"`
	EventID                          UnsignedInt64asBase10                                 `json:"eventId"`
	Priority                         SignedInt64asBase10                                   `json:"priority"`
	FilterData                       []*AttributionReportingFilterDataEntry                `json:"filterData"`
	AggregationKeys                  []*AttributionReportingAggregationKeysEntry           `json:"aggregationKeys"`
	DebugKey                         UnsignedInt64asBase10                                 `json:"debugKey,omitempty,omitzero"`
	TriggerDataMatching              AttributionReportingTriggerDataMatching               `json:"triggerDataMatching"`
	DestinationLimitPriority         SignedInt64asBase10                                   `json:"destinationLimitPriority"`
	AggregatableDebugReportingConfig *AttributionReportingAggregatableDebugReportingConfig `json:"aggregatableDebugReportingConfig"`
	ScopesData                       *AttributionScopesData                                `json:"scopesData,omitempty,omitzero"`
	MaxEventLevelReports             int64                                                 `json:"maxEventLevelReports"`
	NamedBudgets                     []*AttributionReportingNamedBudgetDef                 `json:"namedBudgets"`
	DebugReporting                   bool                                                  `json:"debugReporting"`
	EventLevelEpsilon                float64                                               `json:"eventLevelEpsilon"`
}

// AttributionReportingSourceRegistrationResult [no description].
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/Storage#type-AttributionReportingSourceRegistrationResult
type AttributionReportingSourceRegistrationResult string

// String returns the AttributionReportingSourceRegistrationResult as string value.
func (t AttributionReportingSourceRegistrationResult) String() string {
	return string(t)
}

// AttributionReportingSourceRegistrationResult values.
const (
	AttributionReportingSourceRegistrationResultSuccess                                AttributionReportingSourceRegistrationResult = "success"
	AttributionReportingSourceRegistrationResultInternalError                          AttributionReportingSourceRegistrationResult = "internalError"
	AttributionReportingSourceRegistrationResultInsufficientSourceCapacity             AttributionReportingSourceRegistrationResult = "insufficientSourceCapacity"
	AttributionReportingSourceRegistrationResultInsufficientUniqueDestinationCapacity  AttributionReportingSourceRegistrationResult = "insufficientUniqueDestinationCapacity"
	AttributionReportingSourceRegistrationResultExcessiveReportingOrigins              AttributionReportingSourceRegistrationResult = "excessiveReportingOrigins"
	AttributionReportingSourceRegistrationResultProhibitedByBrowserPolicy              AttributionReportingSourceRegistrationResult = "prohibitedByBrowserPolicy"
	AttributionReportingSourceRegistrationResultSuccessNoised                          AttributionReportingSourceRegistrationResult = "successNoised"
	AttributionReportingSourceRegistrationResultDestinationReportingLimitReached       AttributionReportingSourceRegistrationResult = "destinationReportingLimitReached"
	AttributionReportingSourceRegistrationResultDestinationGlobalLimitReached          AttributionReportingSourceRegistrationResult = "destinationGlobalLimitReached"
	AttributionReportingSourceRegistrationResultDestinationBothLimitsReached           AttributionReportingSourceRegistrationResult = "destinationBothLimitsReached"
	AttributionReportingSourceRegistrationResultReportingOriginsPerSiteLimitReached    AttributionReportingSourceRegistrationResult = "reportingOriginsPerSiteLimitReached"
	AttributionReportingSourceRegistrationResultExceedsMaxChannelCapacity              AttributionReportingSourceRegistrationResult = "exceedsMaxChannelCapacity"
	AttributionReportingSourceRegistrationResultExceedsMaxScopesChannelCapacity        AttributionReportingSourceRegistrationResult = "exceedsMaxScopesChannelCapacity"
	AttributionReportingSourceRegistrationResultExceedsMaxTriggerStateCardinality      AttributionReportingSourceRegistrationResult = "exceedsMaxTriggerStateCardinality"
	AttributionReportingSourceRegistrationResultExceedsMaxEventStatesLimit             AttributionReportingSourceRegistrationResult = "exceedsMaxEventStatesLimit"
	AttributionReportingSourceRegistrationResultDestinationPerDayReportingLimitReached AttributionReportingSourceRegistrationResult = "destinationPerDayReportingLimitReached"
)

// UnmarshalJSON satisfies [json.Unmarshaler].
func (t *AttributionReportingSourceRegistrationResult) UnmarshalJSON(buf []byte) error {
	s := string(buf)
	s = strings.TrimSuffix(strings.TrimPrefix(s, `"`), `"`)

	switch AttributionReportingSourceRegistrationResult(s) {
	case AttributionReportingSourceRegistrationResultSuccess:
		*t = AttributionReportingSourceRegistrationResultSuccess
	case AttributionReportingSourceRegistrationResultInternalError:
		*t = AttributionReportingSourceRegistrationResultInternalError
	case AttributionReportingSourceRegistrationResultInsufficientSourceCapacity:
		*t = AttributionReportingSourceRegistrationResultInsufficientSourceCapacity
	case AttributionReportingSourceRegistrationResultInsufficientUniqueDestinationCapacity:
		*t = AttributionReportingSourceRegistrationResultInsufficientUniqueDestinationCapacity
	case AttributionReportingSourceRegistrationResultExcessiveReportingOrigins:
		*t = AttributionReportingSourceRegistrationResultExcessiveReportingOrigins
	case AttributionReportingSourceRegistrationResultProhibitedByBrowserPolicy:
		*t = AttributionReportingSourceRegistrationResultProhibitedByBrowserPolicy
	case AttributionReportingSourceRegistrationResultSuccessNoised:
		*t = AttributionReportingSourceRegistrationResultSuccessNoised
	case AttributionReportingSourceRegistrationResultDestinationReportingLimitReached:
		*t = AttributionReportingSourceRegistrationResultDestinationReportingLimitReached
	case AttributionReportingSourceRegistrationResultDestinationGlobalLimitReached:
		*t = AttributionReportingSourceRegistrationResultDestinationGlobalLimitReached
	case AttributionReportingSourceRegistrationResultDestinationBothLimitsReached:
		*t = AttributionReportingSourceRegistrationResultDestinationBothLimitsReached
	case AttributionReportingSourceRegistrationResultReportingOriginsPerSiteLimitReached:
		*t = AttributionReportingSourceRegistrationResultReportingOriginsPerSiteLimitReached
	case AttributionReportingSourceRegistrationResultExceedsMaxChannelCapacity:
		*t = AttributionReportingSourceRegistrationResultExceedsMaxChannelCapacity
	case AttributionReportingSourceRegistrationResultExceedsMaxScopesChannelCapacity:
		*t = AttributionReportingSourceRegistrationResultExceedsMaxScopesChannelCapacity
	case AttributionReportingSourceRegistrationResultExceedsMaxTriggerStateCardinality:
		*t = AttributionReportingSourceRegistrationResultExceedsMaxTriggerStateCardinality
	case AttributionReportingSourceRegistrationResultExceedsMaxEventStatesLimit:
		*t = AttributionReportingSourceRegistrationResultExceedsMaxEventStatesLimit
	case AttributionReportingSourceRegistrationResultDestinationPerDayReportingLimitReached:
		*t = AttributionReportingSourceRegistrationResultDestinationPerDayReportingLimitReached
	default:
		return fmt.Errorf("unknown AttributionReportingSourceRegistrationResult value: %v", s)
	}
	return nil
}

// AttributionReportingSourceRegistrationTimeConfig [no description].
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/Storage#type-AttributionReportingSourceRegistrationTimeConfig
type AttributionReportingSourceRegistrationTimeConfig string

// String returns the AttributionReportingSourceRegistrationTimeConfig as string value.
func (t AttributionReportingSourceRegistrationTimeConfig) String() string {
	return string(t)
}

// AttributionReportingSourceRegistrationTimeConfig values.
const (
	AttributionReportingSourceRegistrationTimeConfigInclude AttributionReportingSourceRegistrationTimeConfig = "include"
	AttributionReportingSourceRegistrationTimeConfigExclude AttributionReportingSourceRegistrationTimeConfig = "exclude"
)

// UnmarshalJSON satisfies [json.Unmarshaler].
func (t *AttributionReportingSourceRegistrationTimeConfig) UnmarshalJSON(buf []byte) error {
	s := string(buf)
	s = strings.TrimSuffix(strings.TrimPrefix(s, `"`), `"`)

	switch AttributionReportingSourceRegistrationTimeConfig(s) {
	case AttributionReportingSourceRegistrationTimeConfigInclude:
		*t = AttributionReportingSourceRegistrationTimeConfigInclude
	case AttributionReportingSourceRegistrationTimeConfigExclude:
		*t = AttributionReportingSourceRegistrationTimeConfigExclude
	default:
		return fmt.Errorf("unknown AttributionReportingSourceRegistrationTimeConfig value: %v", s)
	}
	return nil
}

// AttributionReportingAggregatableValueDictEntry [no description].
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/Storage#type-AttributionReportingAggregatableValueDictEntry
type AttributionReportingAggregatableValueDictEntry struct {
	Key         string                `json:"key"`
	Value       float64               `json:"value"` // number instead of integer because not all uint32 can be represented by int
	FilteringID UnsignedInt64asBase10 `json:"filteringId"`
}

// AttributionReportingAggregatableValueEntry [no description].
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/Storage#type-AttributionReportingAggregatableValueEntry
type AttributionReportingAggregatableValueEntry struct {
	Values  []*AttributionReportingAggregatableValueDictEntry `json:"values"`
	Filters *AttributionReportingFilterPair                   `json:"filters"`
}

// AttributionReportingEventTriggerData [no description].
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/Storage#type-AttributionReportingEventTriggerData
type AttributionReportingEventTriggerData struct {
	Data     UnsignedInt64asBase10           `json:"data"`
	Priority SignedInt64asBase10             `json:"priority"`
	DedupKey UnsignedInt64asBase10           `json:"dedupKey,omitempty,omitzero"`
	Filters  *AttributionReportingFilterPair `json:"filters"`
}

// AttributionReportingAggregatableTriggerData [no description].
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/Storage#type-AttributionReportingAggregatableTriggerData
type AttributionReportingAggregatableTriggerData struct {
	KeyPiece   UnsignedInt128asBase16          `json:"keyPiece"`
	SourceKeys []string                        `json:"sourceKeys"`
	Filters    *AttributionReportingFilterPair `json:"filters"`
}

// AttributionReportingAggregatableDedupKey [no description].
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/Storage#type-AttributionReportingAggregatableDedupKey
type AttributionReportingAggregatableDedupKey struct {
	DedupKey UnsignedInt64asBase10           `json:"dedupKey,omitempty,omitzero"`
	Filters  *AttributionReportingFilterPair `json:"filters"`
}

// AttributionReportingNamedBudgetCandidate [no description].
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/Storage#type-AttributionReportingNamedBudgetCandidate
type AttributionReportingNamedBudgetCandidate struct {
	Name    string                          `json:"name,omitempty,omitzero"`
	Filters *AttributionReportingFilterPair `json:"filters"`
}

// AttributionReportingTriggerRegistration [no description].
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/Storage#type-AttributionReportingTriggerRegistration
type AttributionReportingTriggerRegistration struct {
	Filters                          *AttributionReportingFilterPair                       `json:"filters"`
	DebugKey                         UnsignedInt64asBase10                                 `json:"debugKey,omitempty,omitzero"`
	AggregatableDedupKeys            []*AttributionReportingAggregatableDedupKey           `json:"aggregatableDedupKeys"`
	EventTriggerData                 []*AttributionReportingEventTriggerData               `json:"eventTriggerData"`
	AggregatableTriggerData          []*AttributionReportingAggregatableTriggerData        `json:"aggregatableTriggerData"`
	AggregatableValues               []*AttributionReportingAggregatableValueEntry         `json:"aggregatableValues"`
	AggregatableFilteringIDMaxBytes  int64                                                 `json:"aggregatableFilteringIdMaxBytes"`
	DebugReporting                   bool                                                  `json:"debugReporting"`
	AggregationCoordinatorOrigin     string                                                `json:"aggregationCoordinatorOrigin,omitempty,omitzero"`
	SourceRegistrationTimeConfig     AttributionReportingSourceRegistrationTimeConfig      `json:"sourceRegistrationTimeConfig"`
	TriggerContextID                 string                                                `json:"triggerContextId,omitempty,omitzero"`
	AggregatableDebugReportingConfig *AttributionReportingAggregatableDebugReportingConfig `json:"aggregatableDebugReportingConfig"`
	Scopes                           []string                                              `json:"scopes"`
	NamedBudgets                     []*AttributionReportingNamedBudgetCandidate           `json:"namedBudgets"`
}

// AttributionReportingEventLevelResult [no description].
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/Storage#type-AttributionReportingEventLevelResult
type AttributionReportingEventLevelResult string

// String returns the AttributionReportingEventLevelResult as string value.
func (t AttributionReportingEventLevelResult) String() string {
	return string(t)
}

// AttributionReportingEventLevelResult values.
const (
	AttributionReportingEventLevelResultSuccess                             AttributionReportingEventLevelResult = "success"
	AttributionReportingEventLevelResultSuccessDroppedLowerPriority         AttributionReportingEventLevelResult = "successDroppedLowerPriority"
	AttributionReportingEventLevelResultInternalError                       AttributionReportingEventLevelResult = "internalError"
	AttributionReportingEventLevelResultNoCapacityForAttributionDestination AttributionReportingEventLevelResult = "noCapacityForAttributionDestination"
	AttributionReportingEventLevelResultNoMatchingSources                   AttributionReportingEventLevelResult = "noMatchingSources"
	AttributionReportingEventLevelResultDeduplicated                        AttributionReportingEventLevelResult = "deduplicated"
	AttributionReportingEventLevelResultExcessiveAttributions               AttributionReportingEventLevelResult = "excessiveAttributions"
	AttributionReportingEventLevelResultPriorityTooLow                      AttributionReportingEventLevelResult = "priorityTooLow"
	AttributionReportingEventLevelResultNeverAttributedSource               AttributionReportingEventLevelResult = "neverAttributedSource"
	AttributionReportingEventLevelResultExcessiveReportingOrigins           AttributionReportingEventLevelResult = "excessiveReportingOrigins"
	AttributionReportingEventLevelResultNoMatchingSourceFilterData          AttributionReportingEventLevelResult = "noMatchingSourceFilterData"
	AttributionReportingEventLevelResultProhibitedByBrowserPolicy           AttributionReportingEventLevelResult = "prohibitedByBrowserPolicy"
	AttributionReportingEventLevelResultNoMatchingConfigurations            AttributionReportingEventLevelResult = "noMatchingConfigurations"
	AttributionReportingEventLevelResultExcessiveReports                    AttributionReportingEventLevelResult = "excessiveReports"
	AttributionReportingEventLevelResultFalselyAttributedSource             AttributionReportingEventLevelResult = "falselyAttributedSource"
	AttributionReportingEventLevelResultReportWindowPassed                  AttributionReportingEventLevelResult = "reportWindowPassed"
	AttributionReportingEventLevelResultNotRegistered                       AttributionReportingEventLevelResult = "notRegistered"
	AttributionReportingEventLevelResultReportWindowNotStarted              AttributionReportingEventLevelResult = "reportWindowNotStarted"
	AttributionReportingEventLevelResultNoMatchingTriggerData               AttributionReportingEventLevelResult = "noMatchingTriggerData"
)

// UnmarshalJSON satisfies [json.Unmarshaler].
func (t *AttributionReportingEventLevelResult) UnmarshalJSON(buf []byte) error {
	s := string(buf)
	s = strings.TrimSuffix(strings.TrimPrefix(s, `"`), `"`)

	switch AttributionReportingEventLevelResult(s) {
	case AttributionReportingEventLevelResultSuccess:
		*t = AttributionReportingEventLevelResultSuccess
	case AttributionReportingEventLevelResultSuccessDroppedLowerPriority:
		*t = AttributionReportingEventLevelResultSuccessDroppedLowerPriority
	case AttributionReportingEventLevelResultInternalError:
		*t = AttributionReportingEventLevelResultInternalError
	case AttributionReportingEventLevelResultNoCapacityForAttributionDestination:
		*t = AttributionReportingEventLevelResultNoCapacityForAttributionDestination
	case AttributionReportingEventLevelResultNoMatchingSources:
		*t = AttributionReportingEventLevelResultNoMatchingSources
	case AttributionReportingEventLevelResultDeduplicated:
		*t = AttributionReportingEventLevelResultDeduplicated
	case AttributionReportingEventLevelResultExcessiveAttributions:
		*t = AttributionReportingEventLevelResultExcessiveAttributions
	case AttributionReportingEventLevelResultPriorityTooLow:
		*t = AttributionReportingEventLevelResultPriorityTooLow
	case AttributionReportingEventLevelResultNeverAttributedSource:
		*t = AttributionReportingEventLevelResultNeverAttributedSource
	case AttributionReportingEventLevelResultExcessiveReportingOrigins:
		*t = AttributionReportingEventLevelResultExcessiveReportingOrigins
	case AttributionReportingEventLevelResultNoMatchingSourceFilterData:
		*t = AttributionReportingEventLevelResultNoMatchingSourceFilterData
	case AttributionReportingEventLevelResultProhibitedByBrowserPolicy:
		*t = AttributionReportingEventLevelResultProhibitedByBrowserPolicy
	case AttributionReportingEventLevelResultNoMatchingConfigurations:
		*t = AttributionReportingEventLevelResultNoMatchingConfigurations
	case AttributionReportingEventLevelResultExcessiveReports:
		*t = AttributionReportingEventLevelResultExcessiveReports
	case AttributionReportingEventLevelResultFalselyAttributedSource:
		*t = AttributionReportingEventLevelResultFalselyAttributedSource
	case AttributionReportingEventLevelResultReportWindowPassed:
		*t = AttributionReportingEventLevelResultReportWindowPassed
	case AttributionReportingEventLevelResultNotRegistered:
		*t = AttributionReportingEventLevelResultNotRegistered
	case AttributionReportingEventLevelResultReportWindowNotStarted:
		*t = AttributionReportingEventLevelResultReportWindowNotStarted
	case AttributionReportingEventLevelResultNoMatchingTriggerData:
		*t = AttributionReportingEventLevelResultNoMatchingTriggerData
	default:
		return fmt.Errorf("unknown AttributionReportingEventLevelResult value: %v", s)
	}
	return nil
}

// AttributionReportingAggregatableResult [no description].
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/Storage#type-AttributionReportingAggregatableResult
type AttributionReportingAggregatableResult string

// String returns the AttributionReportingAggregatableResult as string value.
func (t AttributionReportingAggregatableResult) String() string {
	return string(t)
}

// AttributionReportingAggregatableResult values.
const (
	AttributionReportingAggregatableResultSuccess                             AttributionReportingAggregatableResult = "success"
	AttributionReportingAggregatableResultInternalError                       AttributionReportingAggregatableResult = "internalError"
	AttributionReportingAggregatableResultNoCapacityForAttributionDestination AttributionReportingAggregatableResult = "noCapacityForAttributionDestination"
	AttributionReportingAggregatableResultNoMatchingSources                   AttributionReportingAggregatableResult = "noMatchingSources"
	AttributionReportingAggregatableResultExcessiveAttributions               AttributionReportingAggregatableResult = "excessiveAttributions"
	AttributionReportingAggregatableResultExcessiveReportingOrigins           AttributionReportingAggregatableResult = "excessiveReportingOrigins"
	AttributionReportingAggregatableResultNoHistograms                        AttributionReportingAggregatableResult = "noHistograms"
	AttributionReportingAggregatableResultInsufficientBudget                  AttributionReportingAggregatableResult = "insufficientBudget"
	AttributionReportingAggregatableResultInsufficientNamedBudget             AttributionReportingAggregatableResult = "insufficientNamedBudget"
	AttributionReportingAggregatableResultNoMatchingSourceFilterData          AttributionReportingAggregatableResult = "noMatchingSourceFilterData"
	AttributionReportingAggregatableResultNotRegistered                       AttributionReportingAggregatableResult = "notRegistered"
	AttributionReportingAggregatableResultProhibitedByBrowserPolicy           AttributionReportingAggregatableResult = "prohibitedByBrowserPolicy"
	AttributionReportingAggregatableResultDeduplicated                        AttributionReportingAggregatableResult = "deduplicated"
	AttributionReportingAggregatableResultReportWindowPassed                  AttributionReportingAggregatableResult = "reportWindowPassed"
	AttributionReportingAggregatableResultExcessiveReports                    AttributionReportingAggregatableResult = "excessiveReports"
)

// UnmarshalJSON satisfies [json.Unmarshaler].
func (t *AttributionReportingAggregatableResult) UnmarshalJSON(buf []byte) error {
	s := string(buf)
	s = strings.TrimSuffix(strings.TrimPrefix(s, `"`), `"`)

	switch AttributionReportingAggregatableResult(s) {
	case AttributionReportingAggregatableResultSuccess:
		*t = AttributionReportingAggregatableResultSuccess
	case AttributionReportingAggregatableResultInternalError:
		*t = AttributionReportingAggregatableResultInternalError
	case AttributionReportingAggregatableResultNoCapacityForAttributionDestination:
		*t = AttributionReportingAggregatableResultNoCapacityForAttributionDestination
	case AttributionReportingAggregatableResultNoMatchingSources:
		*t = AttributionReportingAggregatableResultNoMatchingSources
	case AttributionReportingAggregatableResultExcessiveAttributions:
		*t = AttributionReportingAggregatableResultExcessiveAttributions
	case AttributionReportingAggregatableResultExcessiveReportingOrigins:
		*t = AttributionReportingAggregatableResultExcessiveReportingOrigins
	case AttributionReportingAggregatableResultNoHistograms:
		*t = AttributionReportingAggregatableResultNoHistograms
	case AttributionReportingAggregatableResultInsufficientBudget:
		*t = AttributionReportingAggregatableResultInsufficientBudget
	case AttributionReportingAggregatableResultInsufficientNamedBudget:
		*t = AttributionReportingAggregatableResultInsufficientNamedBudget
	case AttributionReportingAggregatableResultNoMatchingSourceFilterData:
		*t = AttributionReportingAggregatableResultNoMatchingSourceFilterData
	case AttributionReportingAggregatableResultNotRegistered:
		*t = AttributionReportingAggregatableResultNotRegistered
	case AttributionReportingAggregatableResultProhibitedByBrowserPolicy:
		*t = AttributionReportingAggregatableResultProhibitedByBrowserPolicy
	case AttributionReportingAggregatableResultDeduplicated:
		*t = AttributionReportingAggregatableResultDeduplicated
	case AttributionReportingAggregatableResultReportWindowPassed:
		*t = AttributionReportingAggregatableResultReportWindowPassed
	case AttributionReportingAggregatableResultExcessiveReports:
		*t = AttributionReportingAggregatableResultExcessiveReports
	default:
		return fmt.Errorf("unknown AttributionReportingAggregatableResult value: %v", s)
	}
	return nil
}

// AttributionReportingReportResult [no description].
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/Storage#type-AttributionReportingReportResult
type AttributionReportingReportResult string

// String returns the AttributionReportingReportResult as string value.
func (t AttributionReportingReportResult) String() string {
	return string(t)
}

// AttributionReportingReportResult values.
const (
	AttributionReportingReportResultSent             AttributionReportingReportResult = "sent"
	AttributionReportingReportResultProhibited       AttributionReportingReportResult = "prohibited"
	AttributionReportingReportResultFailedToAssemble AttributionReportingReportResult = "failedToAssemble"
	AttributionReportingReportResultExpired          AttributionReportingReportResult = "expired"
)

// UnmarshalJSON satisfies [json.Unmarshaler].
func (t *AttributionReportingReportResult) UnmarshalJSON(buf []byte) error {
	s := string(buf)
	s = strings.TrimSuffix(strings.TrimPrefix(s, `"`), `"`)

	switch AttributionReportingReportResult(s) {
	case AttributionReportingReportResultSent:
		*t = AttributionReportingReportResultSent
	case AttributionReportingReportResultProhibited:
		*t = AttributionReportingReportResultProhibited
	case AttributionReportingReportResultFailedToAssemble:
		*t = AttributionReportingReportResultFailedToAssemble
	case AttributionReportingReportResultExpired:
		*t = AttributionReportingReportResultExpired
	default:
		return fmt.Errorf("unknown AttributionReportingReportResult value: %v", s)
	}
	return nil
}

// RelatedWebsiteSet a single Related Website Set object.
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/Storage#type-RelatedWebsiteSet
type RelatedWebsiteSet struct {
	PrimarySites    []string `json:"primarySites"`    // The primary site of this set, along with the ccTLDs if there is any.
	AssociatedSites []string `json:"associatedSites"` // The associated sites of this set, along with the ccTLDs if there is any.
	ServiceSites    []string `json:"serviceSites"`    // The service sites of this set, along with the ccTLDs if there is any.
}
