package indexeddb

// Code generated by cdproto-gen. DO NOT EDIT.

import (
	"fmt"
	"strings"

	"github.com/chromedp/cdproto/runtime"
)

// DatabaseWithObjectStores database with an array of object stores.
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/IndexedDB#type-DatabaseWithObjectStores
type DatabaseWithObjectStores struct {
	Name         string         `json:"name"`         // Database name.
	Version      float64        `json:"version"`      // Database version (type is not 'integer', as the standard requires the version number to be 'unsigned long long')
	ObjectStores []*ObjectStore `json:"objectStores"` // Object stores in this database.
}

// ObjectStore object store.
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/IndexedDB#type-ObjectStore
type ObjectStore struct {
	Name          string              `json:"name"`          // Object store name.
	KeyPath       *KeyPath            `json:"keyPath"`       // Object store key path.
	AutoIncrement bool                `json:"autoIncrement"` // If true, object store has auto increment flag set.
	Indexes       []*ObjectStoreIndex `json:"indexes"`       // Indexes in this object store.
}

// ObjectStoreIndex object store index.
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/IndexedDB#type-ObjectStoreIndex
type ObjectStoreIndex struct {
	Name       string   `json:"name"`       // Index name.
	KeyPath    *KeyPath `json:"keyPath"`    // Index key path.
	Unique     bool     `json:"unique"`     // If true, index is unique.
	MultiEntry bool     `json:"multiEntry"` // If true, index allows multiple entries for a key.
}

// Key Key.
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/IndexedDB#type-Key
type Key struct {
	Type   KeyType `json:"type"`                      // Key type.
	Number float64 `json:"number,omitempty,omitzero"` // Number value.
	String string  `json:"string,omitempty,omitzero"` // String value.
	Date   float64 `json:"date,omitempty,omitzero"`   // Date value.
	Array  []*Key  `json:"array,omitempty,omitzero"`  // Array value.
}

// KeyRange key range.
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/IndexedDB#type-KeyRange
type KeyRange struct {
	Lower     *Key `json:"lower,omitempty,omitzero"` // Lower bound.
	Upper     *Key `json:"upper,omitempty,omitzero"` // Upper bound.
	LowerOpen bool `json:"lowerOpen"`                // If true lower bound is open.
	UpperOpen bool `json:"upperOpen"`                // If true upper bound is open.
}

// DataEntry data entry.
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/IndexedDB#type-DataEntry
type DataEntry struct {
	Key        *runtime.RemoteObject `json:"key"`        // Key object.
	PrimaryKey *runtime.RemoteObject `json:"primaryKey"` // Primary key object.
	Value      *runtime.RemoteObject `json:"value"`      // Value object.
}

// KeyPath key path.
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/IndexedDB#type-KeyPath
type KeyPath struct {
	Type   KeyPathType `json:"type"`                      // Key path type.
	String string      `json:"string,omitempty,omitzero"` // String value.
	Array  []string    `json:"array,omitempty,omitzero"`  // Array value.
}

// KeyType key type.
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/IndexedDB#type-Key
type KeyType string

// String returns the KeyType as string value.
func (t KeyType) String() string {
	return string(t)
}

// KeyType values.
const (
	KeyTypeNumber KeyType = "number"
	KeyTypeString KeyType = "string"
	KeyTypeDate   KeyType = "date"
	KeyTypeArray  KeyType = "array"
)

// UnmarshalJSON satisfies [json.Unmarshaler].
func (t *KeyType) UnmarshalJSON(buf []byte) error {
	s := string(buf)
	s = strings.TrimSuffix(strings.TrimPrefix(s, `"`), `"`)

	switch KeyType(s) {
	case KeyTypeNumber:
		*t = KeyTypeNumber
	case KeyTypeString:
		*t = KeyTypeString
	case KeyTypeDate:
		*t = KeyTypeDate
	case KeyTypeArray:
		*t = KeyTypeArray
	default:
		return fmt.Errorf("unknown KeyType value: %v", s)
	}
	return nil
}

// KeyPathType key path type.
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/IndexedDB#type-KeyPath
type KeyPathType string

// String returns the KeyPathType as string value.
func (t KeyPathType) String() string {
	return string(t)
}

// KeyPathType values.
const (
	KeyPathTypeNull   KeyPathType = "null"
	KeyPathTypeString KeyPathType = "string"
	KeyPathTypeArray  KeyPathType = "array"
)

// UnmarshalJSON satisfies [json.Unmarshaler].
func (t *KeyPathType) UnmarshalJSON(buf []byte) error {
	s := string(buf)
	s = strings.TrimSuffix(strings.TrimPrefix(s, `"`), `"`)

	switch KeyPathType(s) {
	case KeyPathTypeNull:
		*t = KeyPathTypeNull
	case KeyPathTypeString:
		*t = KeyPathTypeString
	case KeyPathTypeArray:
		*t = KeyPathTypeArray
	default:
		return fmt.Errorf("unknown KeyPathType value: %v", s)
	}
	return nil
}
