// Copyright 2025 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go-grpc. DO NOT EDIT.
// versions:
// - protoc-gen-go-grpc v1.3.0
// - protoc             v4.25.7
// source: google/cloud/aiplatform/v1/vertex_rag_data_service.proto

package aiplatformpb

import (
	context "context"

	longrunningpb "cloud.google.com/go/longrunning/autogen/longrunningpb"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
)

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
// Requires gRPC-Go v1.32.0 or later.
const _ = grpc.SupportPackageIsVersion7

const (
	VertexRagDataService_CreateRagCorpus_FullMethodName       = "/google.cloud.aiplatform.v1.VertexRagDataService/CreateRagCorpus"
	VertexRagDataService_UpdateRagCorpus_FullMethodName       = "/google.cloud.aiplatform.v1.VertexRagDataService/UpdateRagCorpus"
	VertexRagDataService_GetRagCorpus_FullMethodName          = "/google.cloud.aiplatform.v1.VertexRagDataService/GetRagCorpus"
	VertexRagDataService_ListRagCorpora_FullMethodName        = "/google.cloud.aiplatform.v1.VertexRagDataService/ListRagCorpora"
	VertexRagDataService_DeleteRagCorpus_FullMethodName       = "/google.cloud.aiplatform.v1.VertexRagDataService/DeleteRagCorpus"
	VertexRagDataService_UploadRagFile_FullMethodName         = "/google.cloud.aiplatform.v1.VertexRagDataService/UploadRagFile"
	VertexRagDataService_ImportRagFiles_FullMethodName        = "/google.cloud.aiplatform.v1.VertexRagDataService/ImportRagFiles"
	VertexRagDataService_GetRagFile_FullMethodName            = "/google.cloud.aiplatform.v1.VertexRagDataService/GetRagFile"
	VertexRagDataService_ListRagFiles_FullMethodName          = "/google.cloud.aiplatform.v1.VertexRagDataService/ListRagFiles"
	VertexRagDataService_DeleteRagFile_FullMethodName         = "/google.cloud.aiplatform.v1.VertexRagDataService/DeleteRagFile"
	VertexRagDataService_UpdateRagEngineConfig_FullMethodName = "/google.cloud.aiplatform.v1.VertexRagDataService/UpdateRagEngineConfig"
	VertexRagDataService_GetRagEngineConfig_FullMethodName    = "/google.cloud.aiplatform.v1.VertexRagDataService/GetRagEngineConfig"
)

// VertexRagDataServiceClient is the client API for VertexRagDataService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://pkg.go.dev/google.golang.org/grpc/?tab=doc#ClientConn.NewStream.
type VertexRagDataServiceClient interface {
	// Creates a RagCorpus.
	CreateRagCorpus(ctx context.Context, in *CreateRagCorpusRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Updates a RagCorpus.
	UpdateRagCorpus(ctx context.Context, in *UpdateRagCorpusRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Gets a RagCorpus.
	GetRagCorpus(ctx context.Context, in *GetRagCorpusRequest, opts ...grpc.CallOption) (*RagCorpus, error)
	// Lists RagCorpora in a Location.
	ListRagCorpora(ctx context.Context, in *ListRagCorporaRequest, opts ...grpc.CallOption) (*ListRagCorporaResponse, error)
	// Deletes a RagCorpus.
	DeleteRagCorpus(ctx context.Context, in *DeleteRagCorpusRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Upload a file into a RagCorpus.
	UploadRagFile(ctx context.Context, in *UploadRagFileRequest, opts ...grpc.CallOption) (*UploadRagFileResponse, error)
	// Import files from Google Cloud Storage or Google Drive into a RagCorpus.
	ImportRagFiles(ctx context.Context, in *ImportRagFilesRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Gets a RagFile.
	GetRagFile(ctx context.Context, in *GetRagFileRequest, opts ...grpc.CallOption) (*RagFile, error)
	// Lists RagFiles in a RagCorpus.
	ListRagFiles(ctx context.Context, in *ListRagFilesRequest, opts ...grpc.CallOption) (*ListRagFilesResponse, error)
	// Deletes a RagFile.
	DeleteRagFile(ctx context.Context, in *DeleteRagFileRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Updates a RagEngineConfig.
	UpdateRagEngineConfig(ctx context.Context, in *UpdateRagEngineConfigRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Gets a RagEngineConfig.
	GetRagEngineConfig(ctx context.Context, in *GetRagEngineConfigRequest, opts ...grpc.CallOption) (*RagEngineConfig, error)
}

type vertexRagDataServiceClient struct {
	cc grpc.ClientConnInterface
}

func NewVertexRagDataServiceClient(cc grpc.ClientConnInterface) VertexRagDataServiceClient {
	return &vertexRagDataServiceClient{cc}
}

func (c *vertexRagDataServiceClient) CreateRagCorpus(ctx context.Context, in *CreateRagCorpusRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, VertexRagDataService_CreateRagCorpus_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *vertexRagDataServiceClient) UpdateRagCorpus(ctx context.Context, in *UpdateRagCorpusRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, VertexRagDataService_UpdateRagCorpus_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *vertexRagDataServiceClient) GetRagCorpus(ctx context.Context, in *GetRagCorpusRequest, opts ...grpc.CallOption) (*RagCorpus, error) {
	out := new(RagCorpus)
	err := c.cc.Invoke(ctx, VertexRagDataService_GetRagCorpus_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *vertexRagDataServiceClient) ListRagCorpora(ctx context.Context, in *ListRagCorporaRequest, opts ...grpc.CallOption) (*ListRagCorporaResponse, error) {
	out := new(ListRagCorporaResponse)
	err := c.cc.Invoke(ctx, VertexRagDataService_ListRagCorpora_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *vertexRagDataServiceClient) DeleteRagCorpus(ctx context.Context, in *DeleteRagCorpusRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, VertexRagDataService_DeleteRagCorpus_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *vertexRagDataServiceClient) UploadRagFile(ctx context.Context, in *UploadRagFileRequest, opts ...grpc.CallOption) (*UploadRagFileResponse, error) {
	out := new(UploadRagFileResponse)
	err := c.cc.Invoke(ctx, VertexRagDataService_UploadRagFile_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *vertexRagDataServiceClient) ImportRagFiles(ctx context.Context, in *ImportRagFilesRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, VertexRagDataService_ImportRagFiles_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *vertexRagDataServiceClient) GetRagFile(ctx context.Context, in *GetRagFileRequest, opts ...grpc.CallOption) (*RagFile, error) {
	out := new(RagFile)
	err := c.cc.Invoke(ctx, VertexRagDataService_GetRagFile_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *vertexRagDataServiceClient) ListRagFiles(ctx context.Context, in *ListRagFilesRequest, opts ...grpc.CallOption) (*ListRagFilesResponse, error) {
	out := new(ListRagFilesResponse)
	err := c.cc.Invoke(ctx, VertexRagDataService_ListRagFiles_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *vertexRagDataServiceClient) DeleteRagFile(ctx context.Context, in *DeleteRagFileRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, VertexRagDataService_DeleteRagFile_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *vertexRagDataServiceClient) UpdateRagEngineConfig(ctx context.Context, in *UpdateRagEngineConfigRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, VertexRagDataService_UpdateRagEngineConfig_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *vertexRagDataServiceClient) GetRagEngineConfig(ctx context.Context, in *GetRagEngineConfigRequest, opts ...grpc.CallOption) (*RagEngineConfig, error) {
	out := new(RagEngineConfig)
	err := c.cc.Invoke(ctx, VertexRagDataService_GetRagEngineConfig_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// VertexRagDataServiceServer is the server API for VertexRagDataService service.
// All implementations should embed UnimplementedVertexRagDataServiceServer
// for forward compatibility
type VertexRagDataServiceServer interface {
	// Creates a RagCorpus.
	CreateRagCorpus(context.Context, *CreateRagCorpusRequest) (*longrunningpb.Operation, error)
	// Updates a RagCorpus.
	UpdateRagCorpus(context.Context, *UpdateRagCorpusRequest) (*longrunningpb.Operation, error)
	// Gets a RagCorpus.
	GetRagCorpus(context.Context, *GetRagCorpusRequest) (*RagCorpus, error)
	// Lists RagCorpora in a Location.
	ListRagCorpora(context.Context, *ListRagCorporaRequest) (*ListRagCorporaResponse, error)
	// Deletes a RagCorpus.
	DeleteRagCorpus(context.Context, *DeleteRagCorpusRequest) (*longrunningpb.Operation, error)
	// Upload a file into a RagCorpus.
	UploadRagFile(context.Context, *UploadRagFileRequest) (*UploadRagFileResponse, error)
	// Import files from Google Cloud Storage or Google Drive into a RagCorpus.
	ImportRagFiles(context.Context, *ImportRagFilesRequest) (*longrunningpb.Operation, error)
	// Gets a RagFile.
	GetRagFile(context.Context, *GetRagFileRequest) (*RagFile, error)
	// Lists RagFiles in a RagCorpus.
	ListRagFiles(context.Context, *ListRagFilesRequest) (*ListRagFilesResponse, error)
	// Deletes a RagFile.
	DeleteRagFile(context.Context, *DeleteRagFileRequest) (*longrunningpb.Operation, error)
	// Updates a RagEngineConfig.
	UpdateRagEngineConfig(context.Context, *UpdateRagEngineConfigRequest) (*longrunningpb.Operation, error)
	// Gets a RagEngineConfig.
	GetRagEngineConfig(context.Context, *GetRagEngineConfigRequest) (*RagEngineConfig, error)
}

// UnimplementedVertexRagDataServiceServer should be embedded to have forward compatible implementations.
type UnimplementedVertexRagDataServiceServer struct {
}

func (UnimplementedVertexRagDataServiceServer) CreateRagCorpus(context.Context, *CreateRagCorpusRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateRagCorpus not implemented")
}
func (UnimplementedVertexRagDataServiceServer) UpdateRagCorpus(context.Context, *UpdateRagCorpusRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateRagCorpus not implemented")
}
func (UnimplementedVertexRagDataServiceServer) GetRagCorpus(context.Context, *GetRagCorpusRequest) (*RagCorpus, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetRagCorpus not implemented")
}
func (UnimplementedVertexRagDataServiceServer) ListRagCorpora(context.Context, *ListRagCorporaRequest) (*ListRagCorporaResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListRagCorpora not implemented")
}
func (UnimplementedVertexRagDataServiceServer) DeleteRagCorpus(context.Context, *DeleteRagCorpusRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteRagCorpus not implemented")
}
func (UnimplementedVertexRagDataServiceServer) UploadRagFile(context.Context, *UploadRagFileRequest) (*UploadRagFileResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UploadRagFile not implemented")
}
func (UnimplementedVertexRagDataServiceServer) ImportRagFiles(context.Context, *ImportRagFilesRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ImportRagFiles not implemented")
}
func (UnimplementedVertexRagDataServiceServer) GetRagFile(context.Context, *GetRagFileRequest) (*RagFile, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetRagFile not implemented")
}
func (UnimplementedVertexRagDataServiceServer) ListRagFiles(context.Context, *ListRagFilesRequest) (*ListRagFilesResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListRagFiles not implemented")
}
func (UnimplementedVertexRagDataServiceServer) DeleteRagFile(context.Context, *DeleteRagFileRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteRagFile not implemented")
}
func (UnimplementedVertexRagDataServiceServer) UpdateRagEngineConfig(context.Context, *UpdateRagEngineConfigRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateRagEngineConfig not implemented")
}
func (UnimplementedVertexRagDataServiceServer) GetRagEngineConfig(context.Context, *GetRagEngineConfigRequest) (*RagEngineConfig, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetRagEngineConfig not implemented")
}

// UnsafeVertexRagDataServiceServer may be embedded to opt out of forward compatibility for this service.
// Use of this interface is not recommended, as added methods to VertexRagDataServiceServer will
// result in compilation errors.
type UnsafeVertexRagDataServiceServer interface {
	mustEmbedUnimplementedVertexRagDataServiceServer()
}

func RegisterVertexRagDataServiceServer(s grpc.ServiceRegistrar, srv VertexRagDataServiceServer) {
	s.RegisterService(&VertexRagDataService_ServiceDesc, srv)
}

func _VertexRagDataService_CreateRagCorpus_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateRagCorpusRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(VertexRagDataServiceServer).CreateRagCorpus(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: VertexRagDataService_CreateRagCorpus_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(VertexRagDataServiceServer).CreateRagCorpus(ctx, req.(*CreateRagCorpusRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _VertexRagDataService_UpdateRagCorpus_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateRagCorpusRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(VertexRagDataServiceServer).UpdateRagCorpus(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: VertexRagDataService_UpdateRagCorpus_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(VertexRagDataServiceServer).UpdateRagCorpus(ctx, req.(*UpdateRagCorpusRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _VertexRagDataService_GetRagCorpus_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetRagCorpusRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(VertexRagDataServiceServer).GetRagCorpus(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: VertexRagDataService_GetRagCorpus_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(VertexRagDataServiceServer).GetRagCorpus(ctx, req.(*GetRagCorpusRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _VertexRagDataService_ListRagCorpora_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListRagCorporaRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(VertexRagDataServiceServer).ListRagCorpora(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: VertexRagDataService_ListRagCorpora_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(VertexRagDataServiceServer).ListRagCorpora(ctx, req.(*ListRagCorporaRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _VertexRagDataService_DeleteRagCorpus_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteRagCorpusRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(VertexRagDataServiceServer).DeleteRagCorpus(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: VertexRagDataService_DeleteRagCorpus_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(VertexRagDataServiceServer).DeleteRagCorpus(ctx, req.(*DeleteRagCorpusRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _VertexRagDataService_UploadRagFile_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UploadRagFileRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(VertexRagDataServiceServer).UploadRagFile(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: VertexRagDataService_UploadRagFile_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(VertexRagDataServiceServer).UploadRagFile(ctx, req.(*UploadRagFileRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _VertexRagDataService_ImportRagFiles_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ImportRagFilesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(VertexRagDataServiceServer).ImportRagFiles(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: VertexRagDataService_ImportRagFiles_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(VertexRagDataServiceServer).ImportRagFiles(ctx, req.(*ImportRagFilesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _VertexRagDataService_GetRagFile_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetRagFileRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(VertexRagDataServiceServer).GetRagFile(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: VertexRagDataService_GetRagFile_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(VertexRagDataServiceServer).GetRagFile(ctx, req.(*GetRagFileRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _VertexRagDataService_ListRagFiles_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListRagFilesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(VertexRagDataServiceServer).ListRagFiles(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: VertexRagDataService_ListRagFiles_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(VertexRagDataServiceServer).ListRagFiles(ctx, req.(*ListRagFilesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _VertexRagDataService_DeleteRagFile_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteRagFileRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(VertexRagDataServiceServer).DeleteRagFile(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: VertexRagDataService_DeleteRagFile_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(VertexRagDataServiceServer).DeleteRagFile(ctx, req.(*DeleteRagFileRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _VertexRagDataService_UpdateRagEngineConfig_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateRagEngineConfigRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(VertexRagDataServiceServer).UpdateRagEngineConfig(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: VertexRagDataService_UpdateRagEngineConfig_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(VertexRagDataServiceServer).UpdateRagEngineConfig(ctx, req.(*UpdateRagEngineConfigRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _VertexRagDataService_GetRagEngineConfig_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetRagEngineConfigRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(VertexRagDataServiceServer).GetRagEngineConfig(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: VertexRagDataService_GetRagEngineConfig_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(VertexRagDataServiceServer).GetRagEngineConfig(ctx, req.(*GetRagEngineConfigRequest))
	}
	return interceptor(ctx, in, info, handler)
}

// VertexRagDataService_ServiceDesc is the grpc.ServiceDesc for VertexRagDataService service.
// It's only intended for direct use with grpc.RegisterService,
// and not to be introspected or modified (even as a copy)
var VertexRagDataService_ServiceDesc = grpc.ServiceDesc{
	ServiceName: "google.cloud.aiplatform.v1.VertexRagDataService",
	HandlerType: (*VertexRagDataServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "CreateRagCorpus",
			Handler:    _VertexRagDataService_CreateRagCorpus_Handler,
		},
		{
			MethodName: "UpdateRagCorpus",
			Handler:    _VertexRagDataService_UpdateRagCorpus_Handler,
		},
		{
			MethodName: "GetRagCorpus",
			Handler:    _VertexRagDataService_GetRagCorpus_Handler,
		},
		{
			MethodName: "ListRagCorpora",
			Handler:    _VertexRagDataService_ListRagCorpora_Handler,
		},
		{
			MethodName: "DeleteRagCorpus",
			Handler:    _VertexRagDataService_DeleteRagCorpus_Handler,
		},
		{
			MethodName: "UploadRagFile",
			Handler:    _VertexRagDataService_UploadRagFile_Handler,
		},
		{
			MethodName: "ImportRagFiles",
			Handler:    _VertexRagDataService_ImportRagFiles_Handler,
		},
		{
			MethodName: "GetRagFile",
			Handler:    _VertexRagDataService_GetRagFile_Handler,
		},
		{
			MethodName: "ListRagFiles",
			Handler:    _VertexRagDataService_ListRagFiles_Handler,
		},
		{
			MethodName: "DeleteRagFile",
			Handler:    _VertexRagDataService_DeleteRagFile_Handler,
		},
		{
			MethodName: "UpdateRagEngineConfig",
			Handler:    _VertexRagDataService_UpdateRagEngineConfig_Handler,
		},
		{
			MethodName: "GetRagEngineConfig",
			Handler:    _VertexRagDataService_GetRagEngineConfig_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/cloud/aiplatform/v1/vertex_rag_data_service.proto",
}
