/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.util.json;

import org.bson.BsonDouble;
import org.bson.json.JsonParseException;
import org.bson.types.Decimal128;
import org.springframework.data.mongodb.util.json.JsonTokenType;

class JsonToken {
    private final Object value;
    private final JsonTokenType type;

    JsonToken(JsonTokenType type, Object value) {
        this.value = value;
        this.type = type;
    }

    Object getValue() {
        return this.value;
    }

    <T> T getValue(Class<T> clazz) {
        try {
            if (Long.class == clazz) {
                Object object = this.value;
                if (object instanceof Integer) {
                    Integer integerValue = (Integer)object;
                    return clazz.cast(integerValue.longValue());
                }
                object = this.value;
                if (object instanceof String) {
                    String stringValue = (String)object;
                    return clazz.cast(Long.valueOf(stringValue));
                }
            } else if (Integer.class == clazz) {
                Object stringValue = this.value;
                if (stringValue instanceof String) {
                    String stringValue2 = (String)stringValue;
                    return clazz.cast(Integer.valueOf(stringValue2));
                }
            } else if (Double.class == clazz) {
                Object stringValue = this.value;
                if (stringValue instanceof String) {
                    String stringValue3 = (String)stringValue;
                    return clazz.cast(Double.valueOf(stringValue3));
                }
            } else if (Decimal128.class == clazz) {
                Object object = this.value;
                if (object instanceof Integer) {
                    Integer integerValue = (Integer)object;
                    return clazz.cast(new Decimal128((long)integerValue.intValue()));
                }
                object = this.value;
                if (object instanceof Long) {
                    Long longValue = (Long)object;
                    return clazz.cast(new Decimal128(longValue.longValue()));
                }
                object = this.value;
                if (object instanceof Double) {
                    Double doubleValue = (Double)object;
                    return clazz.cast(new BsonDouble(doubleValue.doubleValue()).decimal128Value());
                }
                object = this.value;
                if (object instanceof String) {
                    String stringValue = (String)object;
                    return clazz.cast(Decimal128.parse((String)stringValue));
                }
            }
            return clazz.cast(this.value);
        }
        catch (Exception e) {
            throw new JsonParseException(String.format("Exception converting value '%s' to type %s", this.value, clazz.getName()), (Throwable)e);
        }
    }

    public JsonTokenType getType() {
        return this.type;
    }
}

