/*
 * Decompiled with CFR 0.152.
 */
package com.ubnt.service.orchestration.template.wifi.validator;

import com.ubnt.data.WlanConf;
import com.ubnt.model.api.wlan.Security;
import com.ubnt.model.api.wlan.WlanBand;
import com.ubnt.ooOO.super.o0OO;
import com.ubnt.service.orchestration.dto.report.IssueDetailReportDto;
import com.ubnt.service.orchestration.template.wifi.validator.WifiOrchestrationError;
import com.ubnt.service.system.jA;
import com.ubnt.service.wifi.N;
import java.beans.ConstructorProperties;
import java.util.List;
import lombok.Generated;
import org.slf4j.Logger;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class WifiTemplateErrorValidator {
    private static final Logger LOGGER = jA.\u00f4\u00d20000;
    private static final int MIN_MLO_RADIO_BAND_SIZE = 2;
    private final N validator;

    public List<IssueDetailReportDto> checkTemplateForErrors(List<WlanConf> list) {
        return list.stream().flatMap(wlanConf -> this.\u00d600000((WlanConf)wlanConf).stream()).toList();
    }

    private List<IssueDetailReportDto> \u00d600000(WlanConf wlanConf) {
        o0OO o0OO2 = o0OO.Object();
        String string = wlanConf.getSiteId();
        this.super(wlanConf, (o0OO<IssueDetailReportDto>)o0OO2);
        this.validator.\u00d600000(string, wlanConf).stream().map(wifiTemplateProvisionException -> IssueDetailReportDto.builder().code(wifiTemplateProvisionException.getErrorCode()).issueDetail(wifiTemplateProvisionException.getMessage()).build()).forEach(arg_0 -> ((o0OO)o0OO2).\u00d400000(arg_0));
        return o0OO2.o00000();
    }

    private void super(WlanConf wlanConf, o0OO<IssueDetailReportDto> o0OO2) {
        if (wlanConf.isMloEnabled()) {
            List<WlanBand> list = wlanConf.getWlanBands();
            if (list.size() < 2) {
                o0OO2.\u00d400000((Object)IssueDetailReportDto.builder().code(WifiOrchestrationError.MLO_RADIOS_REQUIRED).issueDetail("MLO requires at least 2 radios.").build());
            }
            wlanConf.getSecurity().filter(security -> security != Security.WPA_PSK).ifPresent(security -> o0OO2.\u00d400000((Object)IssueDetailReportDto.builder().code(WifiOrchestrationError.WPA_PSK_REQUIRED).issueDetail("MLO requires a security profile that supports MLO.").build()));
        }
    }

    @ConstructorProperties(value={"validator"})
    @Generated
    public WifiTemplateErrorValidator(N n2) {
        this.validator = n2;
    }
}

