/*
 * Decompiled with CFR 0.152.
 */
package com.ubnt.service.analytics.api.devicereport.switches;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.ubnt.data.Device;
import com.ubnt.data.X;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class SwitchSettings {
    private Boolean mgmtVlanChanged;
    private Boolean isMgmtNetworkStatic;
    private Boolean jumboFrameEnabled;
    private Boolean dhcpSnoopEnabled;
    private Boolean dhcpGuardEnabled;
    private Boolean flowControlEnabled;
    private String stpMode;
    private Boolean dot1xEnabled;
    private Boolean snmpEnabled;
    private Boolean snmpv3Enabled;
    private Integer l3Networks;

    public SwitchSettings(Device device) {
        this.isMgmtNetworkStatic = !device.getX("config_network", X.\u00f4\u00d30000).getString("type", "dhcp").equals("dhcp");
        this.jumboFrameEnabled = device.is("jumboframe_enabled", false);
        this.flowControlEnabled = device.is("flowctrl_enabled", false);
        this.stpMode = device.getString("stp_version", "rstp");
        this.dot1xEnabled = device.is("dot1x_portctrl_enabled", false);
    }

    public Boolean getMgmtVlanChanged() {
        return this.mgmtVlanChanged;
    }

    public SwitchSettings setMgmtVlanChanged(boolean bl) {
        this.mgmtVlanChanged = bl;
        return this;
    }

    public Boolean getIsMgmtNetworkStatic() {
        return this.isMgmtNetworkStatic;
    }

    public Boolean getJumboFrameEnabled() {
        return this.jumboFrameEnabled;
    }

    public Boolean getDhcpSnoopEnabled() {
        return this.dhcpSnoopEnabled;
    }

    public Boolean getDhcpGuardEnabled() {
        return this.dhcpGuardEnabled;
    }

    public SwitchSettings setDhcpSnoopEnabled(boolean bl) {
        this.dhcpSnoopEnabled = bl;
        return this;
    }

    public SwitchSettings setDhcpGuardEnabled(boolean bl) {
        this.dhcpGuardEnabled = bl;
        return this;
    }

    public Boolean getFlowControlEnabled() {
        return this.flowControlEnabled;
    }

    public String getStpMode() {
        return this.stpMode;
    }

    public Boolean getDot1xEnabled() {
        return this.dot1xEnabled;
    }

    public Boolean getSnmpEnabled() {
        return this.snmpEnabled;
    }

    public SwitchSettings setSnmpEnabled(boolean bl) {
        this.snmpEnabled = bl;
        return this;
    }

    public Boolean getSnmpv3Enabled() {
        return this.snmpv3Enabled;
    }

    public SwitchSettings setSnmpv3Enabled(boolean bl) {
        this.snmpv3Enabled = bl;
        return this;
    }

    public Integer getL3Networks() {
        return this.l3Networks;
    }

    public SwitchSettings setLayer3Networks(int n2) {
        this.l3Networks = n2;
        return this;
    }
}

