/*
 * Decompiled with CFR 0.152.
 */
package com.ubnt.model.api.wan;

import com.ubnt.data.Device;
import com.ubnt.model.api.wan.WanNetworkGroup;
import com.ubnt.model.api.wan.WanNetworkInterfaces;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public final class WanNetworkGroupUtils {
    private WanNetworkGroupUtils() {
    }

    public static boolean isValidWanNetworkGroupAndNotLteWan(WanNetworkGroup wanNetworkGroup) {
        return WanNetworkGroup.WAN_NETWORK_GROUP_SET.contains(wanNetworkGroup);
    }

    public static boolean isValidWanNetworkGroupAndNotLteWan(String string) {
        return WanNetworkGroup.ofStringValueOptional(string).map(WanNetworkGroupUtils::isValidWanNetworkGroupAndNotLteWan).orElse(false);
    }

    public static Optional<WanNetworkGroup> findByWanDsLiteInterfaceName(String string) {
        return WanNetworkGroup.WAN_NETWORK_GROUPS.stream().filter(wanNetworkGroup -> wanNetworkGroup.wanNetworkInterfaces().flatMap(WanNetworkInterfaces::ipv4in6Interface).filter(wan4in6Interface -> StringUtils.equals((CharSequence)wan4in6Interface.interfaceName(), (CharSequence)string)).isPresent()).findFirst();
    }

    public static boolean isWanDsLiteInterface(String string) {
        return WanNetworkGroupUtils.findByWanDsLiteInterfaceName(string).isPresent();
    }

    public static Optional<WanNetworkGroup> getUplinkWanNetworkGroup(Device device) {
        return device.getUplink().flatMap(x2 -> device.getWanGroupName(x2.getString("name")));
    }

    public static Optional<WanNetworkGroup> getUnusedWanNetworkGroup(List<WanNetworkGroup> list) {
        int n2;
        List<Integer> list2 = list.stream().map(WanNetworkGroup::index).sorted().toList();
        int n3 = 0;
        Iterator<Integer> iterator = list2.iterator();
        while (iterator.hasNext() && (n2 = iterator.next().intValue()) - n3 <= 1) {
            n3 = n2;
        }
        return WanNetworkGroup.byWanNetworkGroupIndex(n3 + 1);
    }
}

