/*
 * Decompiled with CFR 0.152.
 */
package com.ubnt.model.api.dashboard;

import com.ubnt.model.api.wan.WanNetworkGroup;
import jakarta.annotation.Nullable;
import java.beans.ConstructorProperties;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.BinaryOperator;
import java.util.function.Function;
import java.util.stream.Collectors;
import lombok.Generated;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public final class WanActivityWidgetData {
    private final WanActivity total;
    private final Map<WanNetworkGroup, WanActivity> byNetworkGroup;

    public static WanActivityWidgetData empty(Collection<WanNetworkGroup> collection) {
        return WanActivityWidgetData.builder().total(WanActivity.empty()).byNetworkGroup(collection.stream().collect(Collectors.toMap(Function.identity(), wanNetworkGroup -> WanActivity.empty()))).build();
    }

    public boolean hasTraffic() {
        return this.total.summary.rxBytes + this.total.summary.txBytes > 0L;
    }

    @ConstructorProperties(value={"total", "byNetworkGroup"})
    @Generated
    WanActivityWidgetData(WanActivity wanActivity, Map<WanNetworkGroup, WanActivity> map) {
        this.total = wanActivity;
        this.byNetworkGroup = map;
    }

    @Generated
    public static WanActivityWidgetDataBuilder builder() {
        return new WanActivityWidgetDataBuilder();
    }

    @Generated
    public WanActivity getTotal() {
        return this.total;
    }

    @Generated
    public Map<WanNetworkGroup, WanActivity> getByNetworkGroup() {
        return this.byNetworkGroup;
    }

    @Generated
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof WanActivityWidgetData)) {
            return false;
        }
        WanActivityWidgetData wanActivityWidgetData = (WanActivityWidgetData)object;
        WanActivity wanActivity = this.getTotal();
        WanActivity wanActivity2 = wanActivityWidgetData.getTotal();
        if (wanActivity == null ? wanActivity2 != null : !((Object)wanActivity).equals(wanActivity2)) {
            return false;
        }
        Map<WanNetworkGroup, WanActivity> map = this.getByNetworkGroup();
        Map<WanNetworkGroup, WanActivity> map2 = wanActivityWidgetData.getByNetworkGroup();
        return !(map == null ? map2 != null : !((Object)map).equals(map2));
    }

    @Generated
    public int hashCode() {
        int n2 = 1;
        WanActivity wanActivity = this.getTotal();
        n2 = n2 * 59 + (wanActivity == null ? 43 : ((Object)wanActivity).hashCode());
        Map<WanNetworkGroup, WanActivity> map = this.getByNetworkGroup();
        n2 = n2 * 59 + (map == null ? 43 : ((Object)map).hashCode());
        return n2;
    }

    @Generated
    public String toString() {
        return "WanActivityWidgetData(total=" + String.valueOf(this.getTotal()) + ", byNetworkGroup=" + String.valueOf(this.getByNetworkGroup()) + ")";
    }

    @Generated
    public static class WanActivityWidgetDataBuilder {
        @Generated
        private WanActivity total;
        @Generated
        private Map<WanNetworkGroup, WanActivity> byNetworkGroup;

        @Generated
        WanActivityWidgetDataBuilder() {
        }

        @Generated
        public WanActivityWidgetDataBuilder total(WanActivity wanActivity) {
            this.total = wanActivity;
            return this;
        }

        @Generated
        public WanActivityWidgetDataBuilder byNetworkGroup(Map<WanNetworkGroup, WanActivity> map) {
            this.byNetworkGroup = map;
            return this;
        }

        @Generated
        public WanActivityWidgetData build() {
            return new WanActivityWidgetData(this.total, this.byNetworkGroup);
        }

        @Generated
        public String toString() {
            return "WanActivityWidgetData.WanActivityWidgetDataBuilder(total=" + String.valueOf(this.total) + ", byNetworkGroup=" + String.valueOf(this.byNetworkGroup) + ")";
        }
    }

    public static final class WanActivity {
        private final WanActivityStatistics summary;
        private final List<WanActivityHistoryEntry> history;

        public static WanActivity empty() {
            return new WanActivity(WanActivityStatistics.empty(), Collections.emptyList());
        }

        @ConstructorProperties(value={"summary", "history"})
        @Generated
        public WanActivity(WanActivityStatistics wanActivityStatistics, List<WanActivityHistoryEntry> list) {
            this.summary = wanActivityStatistics;
            this.history = list;
        }

        @Generated
        public WanActivityStatistics getSummary() {
            return this.summary;
        }

        @Generated
        public List<WanActivityHistoryEntry> getHistory() {
            return this.history;
        }

        @Generated
        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (!(object instanceof WanActivity)) {
                return false;
            }
            WanActivity wanActivity = (WanActivity)object;
            WanActivityStatistics wanActivityStatistics = this.getSummary();
            WanActivityStatistics wanActivityStatistics2 = wanActivity.getSummary();
            if (wanActivityStatistics == null ? wanActivityStatistics2 != null : !((Object)wanActivityStatistics).equals(wanActivityStatistics2)) {
                return false;
            }
            List<WanActivityHistoryEntry> list = this.getHistory();
            List<WanActivityHistoryEntry> list2 = wanActivity.getHistory();
            return !(list == null ? list2 != null : !((Object)list).equals(list2));
        }

        @Generated
        public int hashCode() {
            int n2 = 1;
            WanActivityStatistics wanActivityStatistics = this.getSummary();
            n2 = n2 * 59 + (wanActivityStatistics == null ? 43 : ((Object)wanActivityStatistics).hashCode());
            List<WanActivityHistoryEntry> list = this.getHistory();
            n2 = n2 * 59 + (list == null ? 43 : ((Object)list).hashCode());
            return n2;
        }

        @Generated
        public String toString() {
            return "WanActivityWidgetData.WanActivity(summary=" + String.valueOf(this.getSummary()) + ", history=" + String.valueOf(this.getHistory()) + ")";
        }
    }

    public static final class WanActivityStatistics {
        private final long rxBytes;
        private final long txBytes;
        private final WeightedAverage avgRxRateBps;
        private final WeightedAverage avgTxRateBps;
        @Nullable
        private final Double maxRxRateBps;
        @Nullable
        private final Double maxTxRateBps;
        private final WeightedAverage avgLatencyMs;
        @Nullable
        private final Double maxLatencyMs;
        @Nullable
        private final Double minLatencyMs;
        private final WeightedAverage avgAvailabilityPct;
        @Nullable
        private final Long clientCount;

        public static WanActivityStatistics empty() {
            return WanActivityStatistics.builder().avgRxRateBps(WeightedAverage.empty()).avgTxRateBps(WeightedAverage.empty()).avgLatencyMs(WeightedAverage.empty()).avgAvailabilityPct(WeightedAverage.empty()).build();
        }

        @Nullable
        public static <T> T addNullable(@Nullable T t2, @Nullable T t3, BinaryOperator<T> binaryOperator) {
            if (t2 == null) {
                return t3;
            }
            if (t3 == null) {
                return t2;
            }
            return (T)binaryOperator.apply(t2, t3);
        }

        public WanActivityStatistics add(WanActivityStatistics wanActivityStatistics) {
            return WanActivityStatistics.builder().rxBytes(this.rxBytes + wanActivityStatistics.rxBytes).txBytes(this.txBytes + wanActivityStatistics.txBytes).avgRxRateBps(this.avgRxRateBps.add(wanActivityStatistics.avgRxRateBps)).avgTxRateBps(this.avgTxRateBps.add(wanActivityStatistics.avgTxRateBps)).maxRxRateBps(WanActivityStatistics.addNullable(this.maxRxRateBps, wanActivityStatistics.maxRxRateBps, Math::max)).maxTxRateBps(WanActivityStatistics.addNullable(this.maxTxRateBps, wanActivityStatistics.maxTxRateBps, Math::max)).avgLatencyMs(this.avgLatencyMs.add(wanActivityStatistics.avgLatencyMs)).maxLatencyMs(WanActivityStatistics.addNullable(this.maxLatencyMs, wanActivityStatistics.maxLatencyMs, Math::max)).minLatencyMs(WanActivityStatistics.addNullable(this.minLatencyMs, wanActivityStatistics.minLatencyMs, Math::min)).avgAvailabilityPct(this.avgAvailabilityPct.add(wanActivityStatistics.avgAvailabilityPct)).build();
        }

        @ConstructorProperties(value={"rxBytes", "txBytes", "avgRxRateBps", "avgTxRateBps", "maxRxRateBps", "maxTxRateBps", "avgLatencyMs", "maxLatencyMs", "minLatencyMs", "avgAvailabilityPct", "clientCount"})
        @Generated
        WanActivityStatistics(long l2, long l3, WeightedAverage weightedAverage, WeightedAverage weightedAverage2, @Nullable Double d2, @Nullable Double d3, WeightedAverage weightedAverage3, @Nullable Double d4, @Nullable Double d5, WeightedAverage weightedAverage4, @Nullable Long l4) {
            this.rxBytes = l2;
            this.txBytes = l3;
            this.avgRxRateBps = weightedAverage;
            this.avgTxRateBps = weightedAverage2;
            this.maxRxRateBps = d2;
            this.maxTxRateBps = d3;
            this.avgLatencyMs = weightedAverage3;
            this.maxLatencyMs = d4;
            this.minLatencyMs = d5;
            this.avgAvailabilityPct = weightedAverage4;
            this.clientCount = l4;
        }

        @Generated
        public static WanActivityStatisticsBuilder builder() {
            return new WanActivityStatisticsBuilder();
        }

        @Generated
        public long getRxBytes() {
            return this.rxBytes;
        }

        @Generated
        public long getTxBytes() {
            return this.txBytes;
        }

        @Generated
        public WeightedAverage getAvgRxRateBps() {
            return this.avgRxRateBps;
        }

        @Generated
        public WeightedAverage getAvgTxRateBps() {
            return this.avgTxRateBps;
        }

        @Nullable
        @Generated
        public Double getMaxRxRateBps() {
            return this.maxRxRateBps;
        }

        @Nullable
        @Generated
        public Double getMaxTxRateBps() {
            return this.maxTxRateBps;
        }

        @Generated
        public WeightedAverage getAvgLatencyMs() {
            return this.avgLatencyMs;
        }

        @Nullable
        @Generated
        public Double getMaxLatencyMs() {
            return this.maxLatencyMs;
        }

        @Nullable
        @Generated
        public Double getMinLatencyMs() {
            return this.minLatencyMs;
        }

        @Generated
        public WeightedAverage getAvgAvailabilityPct() {
            return this.avgAvailabilityPct;
        }

        @Nullable
        @Generated
        public Long getClientCount() {
            return this.clientCount;
        }

        @Generated
        public String toString() {
            return "WanActivityWidgetData.WanActivityStatistics(rxBytes=" + this.getRxBytes() + ", txBytes=" + this.getTxBytes() + ", avgRxRateBps=" + String.valueOf(this.getAvgRxRateBps()) + ", avgTxRateBps=" + String.valueOf(this.getAvgTxRateBps()) + ", maxRxRateBps=" + this.getMaxRxRateBps() + ", maxTxRateBps=" + this.getMaxTxRateBps() + ", avgLatencyMs=" + String.valueOf(this.getAvgLatencyMs()) + ", maxLatencyMs=" + this.getMaxLatencyMs() + ", minLatencyMs=" + this.getMinLatencyMs() + ", avgAvailabilityPct=" + String.valueOf(this.getAvgAvailabilityPct()) + ", clientCount=" + this.getClientCount() + ")";
        }

        @Generated
        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (!(object instanceof WanActivityStatistics)) {
                return false;
            }
            WanActivityStatistics wanActivityStatistics = (WanActivityStatistics)object;
            if (this.rxBytes != wanActivityStatistics.rxBytes) {
                return false;
            }
            if (this.txBytes != wanActivityStatistics.txBytes) {
                return false;
            }
            Double d2 = this.maxRxRateBps;
            Double d3 = wanActivityStatistics.maxRxRateBps;
            if (d2 == null ? d3 != null : !((Object)d2).equals(d3)) {
                return false;
            }
            Double d4 = this.maxTxRateBps;
            Double d5 = wanActivityStatistics.maxTxRateBps;
            if (d4 == null ? d5 != null : !((Object)d4).equals(d5)) {
                return false;
            }
            Double d6 = this.maxLatencyMs;
            Double d7 = wanActivityStatistics.maxLatencyMs;
            if (d6 == null ? d7 != null : !((Object)d6).equals(d7)) {
                return false;
            }
            Double d8 = this.minLatencyMs;
            Double d9 = wanActivityStatistics.minLatencyMs;
            if (d8 == null ? d9 != null : !((Object)d8).equals(d9)) {
                return false;
            }
            Long l2 = this.clientCount;
            Long l3 = wanActivityStatistics.clientCount;
            if (l2 == null ? l3 != null : !((Object)l2).equals(l3)) {
                return false;
            }
            WeightedAverage weightedAverage = this.avgRxRateBps;
            WeightedAverage weightedAverage2 = wanActivityStatistics.avgRxRateBps;
            if (weightedAverage == null ? weightedAverage2 != null : !((Object)weightedAverage).equals(weightedAverage2)) {
                return false;
            }
            WeightedAverage weightedAverage3 = this.avgTxRateBps;
            WeightedAverage weightedAverage4 = wanActivityStatistics.avgTxRateBps;
            if (weightedAverage3 == null ? weightedAverage4 != null : !((Object)weightedAverage3).equals(weightedAverage4)) {
                return false;
            }
            WeightedAverage weightedAverage5 = this.avgLatencyMs;
            WeightedAverage weightedAverage6 = wanActivityStatistics.avgLatencyMs;
            if (weightedAverage5 == null ? weightedAverage6 != null : !((Object)weightedAverage5).equals(weightedAverage6)) {
                return false;
            }
            WeightedAverage weightedAverage7 = this.avgAvailabilityPct;
            WeightedAverage weightedAverage8 = wanActivityStatistics.avgAvailabilityPct;
            return !(weightedAverage7 == null ? weightedAverage8 != null : !((Object)weightedAverage7).equals(weightedAverage8));
        }

        @Generated
        public int hashCode() {
            int n2 = 1;
            long l2 = this.rxBytes;
            n2 = n2 * 59 + (int)(l2 >>> 32 ^ l2);
            long l3 = this.txBytes;
            n2 = n2 * 59 + (int)(l3 >>> 32 ^ l3);
            Double d2 = this.maxRxRateBps;
            n2 = n2 * 59 + (d2 == null ? 43 : ((Object)d2).hashCode());
            Double d3 = this.maxTxRateBps;
            n2 = n2 * 59 + (d3 == null ? 43 : ((Object)d3).hashCode());
            Double d4 = this.maxLatencyMs;
            n2 = n2 * 59 + (d4 == null ? 43 : ((Object)d4).hashCode());
            Double d5 = this.minLatencyMs;
            n2 = n2 * 59 + (d5 == null ? 43 : ((Object)d5).hashCode());
            Long l4 = this.clientCount;
            n2 = n2 * 59 + (l4 == null ? 43 : ((Object)l4).hashCode());
            WeightedAverage weightedAverage = this.avgRxRateBps;
            n2 = n2 * 59 + (weightedAverage == null ? 43 : ((Object)weightedAverage).hashCode());
            WeightedAverage weightedAverage2 = this.avgTxRateBps;
            n2 = n2 * 59 + (weightedAverage2 == null ? 43 : ((Object)weightedAverage2).hashCode());
            WeightedAverage weightedAverage3 = this.avgLatencyMs;
            n2 = n2 * 59 + (weightedAverage3 == null ? 43 : ((Object)weightedAverage3).hashCode());
            WeightedAverage weightedAverage4 = this.avgAvailabilityPct;
            n2 = n2 * 59 + (weightedAverage4 == null ? 43 : ((Object)weightedAverage4).hashCode());
            return n2;
        }

        @Generated
        public static class WanActivityStatisticsBuilder {
            @Generated
            private long rxBytes;
            @Generated
            private long txBytes;
            @Generated
            private WeightedAverage avgRxRateBps;
            @Generated
            private WeightedAverage avgTxRateBps;
            @Generated
            private Double maxRxRateBps;
            @Generated
            private Double maxTxRateBps;
            @Generated
            private WeightedAverage avgLatencyMs;
            @Generated
            private Double maxLatencyMs;
            @Generated
            private Double minLatencyMs;
            @Generated
            private WeightedAverage avgAvailabilityPct;
            @Generated
            private Long clientCount;

            @Generated
            WanActivityStatisticsBuilder() {
            }

            @Generated
            public WanActivityStatisticsBuilder rxBytes(long l2) {
                this.rxBytes = l2;
                return this;
            }

            @Generated
            public WanActivityStatisticsBuilder txBytes(long l2) {
                this.txBytes = l2;
                return this;
            }

            @Generated
            public WanActivityStatisticsBuilder avgRxRateBps(WeightedAverage weightedAverage) {
                this.avgRxRateBps = weightedAverage;
                return this;
            }

            @Generated
            public WanActivityStatisticsBuilder avgTxRateBps(WeightedAverage weightedAverage) {
                this.avgTxRateBps = weightedAverage;
                return this;
            }

            @Generated
            public WanActivityStatisticsBuilder maxRxRateBps(@Nullable Double d2) {
                this.maxRxRateBps = d2;
                return this;
            }

            @Generated
            public WanActivityStatisticsBuilder maxTxRateBps(@Nullable Double d2) {
                this.maxTxRateBps = d2;
                return this;
            }

            @Generated
            public WanActivityStatisticsBuilder avgLatencyMs(WeightedAverage weightedAverage) {
                this.avgLatencyMs = weightedAverage;
                return this;
            }

            @Generated
            public WanActivityStatisticsBuilder maxLatencyMs(@Nullable Double d2) {
                this.maxLatencyMs = d2;
                return this;
            }

            @Generated
            public WanActivityStatisticsBuilder minLatencyMs(@Nullable Double d2) {
                this.minLatencyMs = d2;
                return this;
            }

            @Generated
            public WanActivityStatisticsBuilder avgAvailabilityPct(WeightedAverage weightedAverage) {
                this.avgAvailabilityPct = weightedAverage;
                return this;
            }

            @Generated
            public WanActivityStatisticsBuilder clientCount(@Nullable Long l2) {
                this.clientCount = l2;
                return this;
            }

            @Generated
            public WanActivityStatistics build() {
                return new WanActivityStatistics(this.rxBytes, this.txBytes, this.avgRxRateBps, this.avgTxRateBps, this.maxRxRateBps, this.maxTxRateBps, this.avgLatencyMs, this.maxLatencyMs, this.minLatencyMs, this.avgAvailabilityPct, this.clientCount);
            }

            @Generated
            public String toString() {
                return "WanActivityWidgetData.WanActivityStatistics.WanActivityStatisticsBuilder(rxBytes=" + this.rxBytes + ", txBytes=" + this.txBytes + ", avgRxRateBps=" + String.valueOf(this.avgRxRateBps) + ", avgTxRateBps=" + String.valueOf(this.avgTxRateBps) + ", maxRxRateBps=" + this.maxRxRateBps + ", maxTxRateBps=" + this.maxTxRateBps + ", avgLatencyMs=" + String.valueOf(this.avgLatencyMs) + ", maxLatencyMs=" + this.maxLatencyMs + ", minLatencyMs=" + this.minLatencyMs + ", avgAvailabilityPct=" + String.valueOf(this.avgAvailabilityPct) + ", clientCount=" + this.clientCount + ")";
            }
        }
    }

    public static final class WeightedAverage {
        private final double value;
        private final long weight;

        public static WeightedAverage empty() {
            return new WeightedAverage(0.0, 0L);
        }

        @Nullable
        public Double getValue() {
            return this.weight == 0L ? null : Double.valueOf(this.value);
        }

        public WeightedAverage add(WeightedAverage weightedAverage) {
            long l2 = this.weight + weightedAverage.weight;
            double d2 = l2 == 0L ? 0.0 : (this.value * (double)this.weight + weightedAverage.value * (double)weightedAverage.weight) / (double)l2;
            return new WeightedAverage(d2, l2);
        }

        @ConstructorProperties(value={"value", "weight"})
        @Generated
        public WeightedAverage(double d2, long l2) {
            this.value = d2;
            this.weight = l2;
        }

        @Generated
        public long getWeight() {
            return this.weight;
        }

        @Generated
        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (!(object instanceof WeightedAverage)) {
                return false;
            }
            WeightedAverage weightedAverage = (WeightedAverage)object;
            Double d2 = this.getValue();
            Double d3 = weightedAverage.getValue();
            if (d2 == null ? d3 != null : !((Object)d2).equals(d3)) {
                return false;
            }
            return this.getWeight() == weightedAverage.getWeight();
        }

        @Generated
        public int hashCode() {
            int n2 = 1;
            Double d2 = this.getValue();
            n2 = n2 * 59 + (d2 == null ? 43 : ((Object)d2).hashCode());
            long l2 = this.getWeight();
            n2 = n2 * 59 + (int)(l2 >>> 32 ^ l2);
            return n2;
        }

        @Generated
        public String toString() {
            return "WanActivityWidgetData.WeightedAverage(value=" + this.getValue() + ", weight=" + this.getWeight() + ")";
        }
    }

    public static final class WanActivityHistoryEntry {
        private final long timestamp;
        private final WanActivityStatistics statistics;

        public static WanActivityHistoryEntry empty(long l2) {
            return new WanActivityHistoryEntry(l2, WanActivityStatistics.empty());
        }

        @ConstructorProperties(value={"timestamp", "statistics"})
        @Generated
        public WanActivityHistoryEntry(long l2, WanActivityStatistics wanActivityStatistics) {
            this.timestamp = l2;
            this.statistics = wanActivityStatistics;
        }

        @Generated
        public long getTimestamp() {
            return this.timestamp;
        }

        @Generated
        public WanActivityStatistics getStatistics() {
            return this.statistics;
        }

        @Generated
        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (!(object instanceof WanActivityHistoryEntry)) {
                return false;
            }
            WanActivityHistoryEntry wanActivityHistoryEntry = (WanActivityHistoryEntry)object;
            if (this.getTimestamp() != wanActivityHistoryEntry.getTimestamp()) {
                return false;
            }
            WanActivityStatistics wanActivityStatistics = this.getStatistics();
            WanActivityStatistics wanActivityStatistics2 = wanActivityHistoryEntry.getStatistics();
            return !(wanActivityStatistics == null ? wanActivityStatistics2 != null : !((Object)wanActivityStatistics).equals(wanActivityStatistics2));
        }

        @Generated
        public int hashCode() {
            int n2 = 1;
            long l2 = this.getTimestamp();
            n2 = n2 * 59 + (int)(l2 >>> 32 ^ l2);
            WanActivityStatistics wanActivityStatistics = this.getStatistics();
            n2 = n2 * 59 + (wanActivityStatistics == null ? 43 : ((Object)wanActivityStatistics).hashCode());
            return n2;
        }

        @Generated
        public String toString() {
            return "WanActivityWidgetData.WanActivityHistoryEntry(timestamp=" + this.getTimestamp() + ", statistics=" + String.valueOf(this.getStatistics()) + ")";
        }
    }
}

