// Copyright 2025 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by the Google Gen AI SDK generator DO NOT EDIT.

package genai

import (
	"fmt"
)

func createAuthTokenConfigToMldev(ac *apiClient, fromObject map[string]any, parentObject map[string]any, rootObject map[string]any) (toObject map[string]any, err error) {
	toObject = make(map[string]any)

	fromExpireTime := getValueByPath(fromObject, []string{"expireTime"})
	if fromExpireTime != nil {
		setValueByPath(parentObject, []string{"expireTime"}, fromExpireTime)
	}

	fromNewSessionExpireTime := getValueByPath(fromObject, []string{"newSessionExpireTime"})
	if fromNewSessionExpireTime != nil {
		setValueByPath(parentObject, []string{"newSessionExpireTime"}, fromNewSessionExpireTime)
	}

	fromUses := getValueByPath(fromObject, []string{"uses"})
	if fromUses != nil {
		setValueByPath(parentObject, []string{"uses"}, fromUses)
	}

	fromLiveConnectConstraints := getValueByPath(fromObject, []string{"liveConnectConstraints"})
	if fromLiveConnectConstraints != nil {
		fromLiveConnectConstraints, err = liveConnectConstraintsToMldev(ac, fromLiveConnectConstraints.(map[string]any), toObject, rootObject)
		if err != nil {
			return nil, err
		}

		setValueByPath(parentObject, []string{"bidiGenerateContentSetup"}, fromLiveConnectConstraints)
	}

	fromLockAdditionalFields := getValueByPath(fromObject, []string{"lockAdditionalFields"})
	if fromLockAdditionalFields != nil {
		setValueByPath(parentObject, []string{"fieldMask"}, fromLockAdditionalFields)
	}

	return toObject, nil
}

func createAuthTokenParametersToMldev(ac *apiClient, fromObject map[string]any, parentObject map[string]any, rootObject map[string]any) (toObject map[string]any, err error) {
	toObject = make(map[string]any)

	fromConfig := getValueByPath(fromObject, []string{"config"})
	if fromConfig != nil {
		fromConfig, err = createAuthTokenConfigToMldev(ac, fromConfig.(map[string]any), toObject, rootObject)
		if err != nil {
			return nil, err
		}

		setValueByPath(toObject, []string{"config"}, fromConfig)
	}

	return toObject, nil
}

func createAuthTokenParametersToVertex(fromObject map[string]any, parentObject map[string]any, rootObject map[string]any) (toObject map[string]any, err error) {
	toObject = make(map[string]any)
	if getValueByPath(fromObject, []string{"config"}) != nil {
		return nil, fmt.Errorf("config parameter is not supported in Vertex AI")
	}

	return toObject, nil
}

func liveConnectConstraintsToMldev(ac *apiClient, fromObject map[string]any, parentObject map[string]any, rootObject map[string]any) (toObject map[string]any, err error) {
	toObject = make(map[string]any)

	fromModel := getValueByPath(fromObject, []string{"model"})
	if fromModel != nil {
		fromModel, err = tModel(ac, fromModel)
		if err != nil {
			return nil, err
		}

		setValueByPath(toObject, []string{"setup", "model"}, fromModel)
	}

	fromConfig := getValueByPath(fromObject, []string{"config"})
	if fromConfig != nil {
		fromConfig, err = liveConnectConfigToMldev(fromConfig.(map[string]any), toObject, rootObject)
		if err != nil {
			return nil, err
		}

		setValueByPath(toObject, []string{"config"}, fromConfig)
	}

	return toObject, nil
}
