// Copyright The OpenTelemetry Authors
// SPDX-License-Identifier: Apache-2.0

// Code generated by "internal/cmd/pdatagen/main.go". DO NOT EDIT.
// To regenerate this file run "make genpdata".

package internal

import (
	"fmt"
	"sync"

	"go.opentelemetry.io/collector/pdata/internal/json"
	"go.opentelemetry.io/collector/pdata/internal/proto"
)

type TCPAddr struct {
	IP   []byte
	Port int64
	Zone string
}

var (
	protoPoolTCPAddr = sync.Pool{
		New: func() any {
			return &TCPAddr{}
		},
	}
)

func NewTCPAddr() *TCPAddr {
	if !UseProtoPooling.IsEnabled() {
		return &TCPAddr{}
	}
	return protoPoolTCPAddr.Get().(*TCPAddr)
}

func DeleteTCPAddr(orig *TCPAddr, nullable bool) {
	if orig == nil {
		return
	}

	if !UseProtoPooling.IsEnabled() {
		orig.Reset()
		return
	}

	orig.Reset()
	if nullable {
		protoPoolTCPAddr.Put(orig)
	}
}

func CopyTCPAddr(dest, src *TCPAddr) *TCPAddr {
	// If copying to same object, just return.
	if src == dest {
		return dest
	}

	if src == nil {
		return nil
	}

	if dest == nil {
		dest = NewTCPAddr()
	}
	dest.IP = src.IP

	dest.Port = src.Port

	dest.Zone = src.Zone

	return dest
}

func CopyTCPAddrSlice(dest, src []TCPAddr) []TCPAddr {
	var newDest []TCPAddr
	if cap(dest) < len(src) {
		newDest = make([]TCPAddr, len(src))
	} else {
		newDest = dest[:len(src)]
		// Cleanup the rest of the elements so GC can free the memory.
		// This can happen when len(src) < len(dest) < cap(dest).
		for i := len(src); i < len(dest); i++ {
			DeleteTCPAddr(&dest[i], false)
		}
	}
	for i := range src {
		CopyTCPAddr(&newDest[i], &src[i])
	}
	return newDest
}

func CopyTCPAddrPtrSlice(dest, src []*TCPAddr) []*TCPAddr {
	var newDest []*TCPAddr
	if cap(dest) < len(src) {
		newDest = make([]*TCPAddr, len(src))
		// Copy old pointers to re-use.
		copy(newDest, dest)
		// Add new pointers for missing elements from len(dest) to len(srt).
		for i := len(dest); i < len(src); i++ {
			newDest[i] = NewTCPAddr()
		}
	} else {
		newDest = dest[:len(src)]
		// Cleanup the rest of the elements so GC can free the memory.
		// This can happen when len(src) < len(dest) < cap(dest).
		for i := len(src); i < len(dest); i++ {
			DeleteTCPAddr(dest[i], true)
			dest[i] = nil
		}
		// Add new pointers for missing elements.
		// This can happen when len(dest) < len(src) < cap(dest).
		for i := len(dest); i < len(src); i++ {
			newDest[i] = NewTCPAddr()
		}
	}
	for i := range src {
		CopyTCPAddr(newDest[i], src[i])
	}
	return newDest
}

func (orig *TCPAddr) Reset() {
	*orig = TCPAddr{}
}

// MarshalJSON marshals all properties from the current struct to the destination stream.
func (orig *TCPAddr) MarshalJSON(dest *json.Stream) {
	dest.WriteObjectStart()

	if len(orig.IP) > 0 {
		dest.WriteObjectField("iP")
		dest.WriteBytes(orig.IP)
	}
	if orig.Port != int64(0) {
		dest.WriteObjectField("port")
		dest.WriteInt64(orig.Port)
	}
	if orig.Zone != "" {
		dest.WriteObjectField("zone")
		dest.WriteString(orig.Zone)
	}
	dest.WriteObjectEnd()
}

// UnmarshalJSON unmarshals all properties from the current struct from the source iterator.
func (orig *TCPAddr) UnmarshalJSON(iter *json.Iterator) {
	for f := iter.ReadObject(); f != ""; f = iter.ReadObject() {
		switch f {
		case "iP":
			orig.IP = iter.ReadBytes()
		case "port":
			orig.Port = iter.ReadInt64()
		case "zone":
			orig.Zone = iter.ReadString()
		default:
			iter.Skip()
		}
	}
}

func (orig *TCPAddr) SizeProto() int {
	var n int
	var l int
	_ = l
	l = len(orig.IP)
	if l > 0 {
		n += 1 + proto.Sov(uint64(l)) + l
	}
	if orig.Port != 0 {
		n += 1 + proto.Sov(uint64(orig.Port))
	}
	l = len(orig.Zone)
	if l > 0 {
		n += 1 + proto.Sov(uint64(l)) + l
	}
	return n
}

func (orig *TCPAddr) MarshalProto(buf []byte) int {
	pos := len(buf)
	var l int
	_ = l
	l = len(orig.IP)
	if l > 0 {
		pos -= l
		copy(buf[pos:], orig.IP)
		pos = proto.EncodeVarint(buf, pos, uint64(l))
		pos--
		buf[pos] = 0xa
	}
	if orig.Port != 0 {
		pos = proto.EncodeVarint(buf, pos, uint64(orig.Port))
		pos--
		buf[pos] = 0x10
	}
	l = len(orig.Zone)
	if l > 0 {
		pos -= l
		copy(buf[pos:], orig.Zone)
		pos = proto.EncodeVarint(buf, pos, uint64(l))
		pos--
		buf[pos] = 0x1a
	}
	return len(buf) - pos
}

func (orig *TCPAddr) UnmarshalProto(buf []byte) error {
	var err error
	var fieldNum int32
	var wireType proto.WireType

	l := len(buf)
	pos := 0
	for pos < l {
		// If in a group parsing, move to the next tag.
		fieldNum, wireType, pos, err = proto.ConsumeTag(buf, pos)
		if err != nil {
			return err
		}
		switch fieldNum {

		case 1:
			if wireType != proto.WireTypeLen {
				return fmt.Errorf("proto: wrong wireType = %d for field IP", wireType)
			}
			var length int
			length, pos, err = proto.ConsumeLen(buf, pos)
			if err != nil {
				return err
			}
			startPos := pos - length
			if length != 0 {
				orig.IP = make([]byte, length)
				copy(orig.IP, buf[startPos:pos])
			}

		case 2:
			if wireType != proto.WireTypeVarint {
				return fmt.Errorf("proto: wrong wireType = %d for field Port", wireType)
			}
			var num uint64
			num, pos, err = proto.ConsumeVarint(buf, pos)
			if err != nil {
				return err
			}

			orig.Port = int64(num)

		case 3:
			if wireType != proto.WireTypeLen {
				return fmt.Errorf("proto: wrong wireType = %d for field Zone", wireType)
			}
			var length int
			length, pos, err = proto.ConsumeLen(buf, pos)
			if err != nil {
				return err
			}
			startPos := pos - length
			orig.Zone = string(buf[startPos:pos])
		default:
			pos, err = proto.ConsumeUnknown(buf, pos, wireType)
			if err != nil {
				return err
			}
		}
	}
	return nil
}

func GenTestTCPAddr() *TCPAddr {
	orig := NewTCPAddr()
	orig.IP = []byte{1, 2, 3}
	orig.Port = int64(13)
	orig.Zone = "test_zone"
	return orig
}

func GenTestTCPAddrPtrSlice() []*TCPAddr {
	orig := make([]*TCPAddr, 5)
	orig[0] = NewTCPAddr()
	orig[1] = GenTestTCPAddr()
	orig[2] = NewTCPAddr()
	orig[3] = GenTestTCPAddr()
	orig[4] = NewTCPAddr()
	return orig
}

func GenTestTCPAddrSlice() []TCPAddr {
	orig := make([]TCPAddr, 5)
	orig[1] = *GenTestTCPAddr()
	orig[3] = *GenTestTCPAddr()
	return orig
}
