// Copyright The OpenTelemetry Authors
// SPDX-License-Identifier: Apache-2.0

// Code generated by "internal/cmd/pdatagen/main.go". DO NOT EDIT.
// To regenerate this file run "make genpdata".

package internal

import (
	"strconv"
	"testing"

	"github.com/stretchr/testify/assert"
	"github.com/stretchr/testify/require"
	gootlpresource "go.opentelemetry.io/proto/slim/otlp/resource/v1"
	"google.golang.org/protobuf/proto"

	"go.opentelemetry.io/collector/featuregate"
	"go.opentelemetry.io/collector/pdata/internal/json"
)

func TestCopyResource(t *testing.T) {
	for name, src := range genTestEncodingValuesResource() {
		for _, pooling := range []bool{true, false} {
			t.Run(name+"/Pooling="+strconv.FormatBool(pooling), func(t *testing.T) {
				prevPooling := UseProtoPooling.IsEnabled()
				require.NoError(t, featuregate.GlobalRegistry().Set(UseProtoPooling.ID(), pooling))
				defer func() {
					require.NoError(t, featuregate.GlobalRegistry().Set(UseProtoPooling.ID(), prevPooling))
				}()

				dest := NewResource()
				CopyResource(dest, src)
				assert.Equal(t, src, dest)
				CopyResource(dest, dest)
				assert.Equal(t, src, dest)
			})
		}
	}
}

func TestCopyResourceSlice(t *testing.T) {
	src := []Resource{}
	dest := []Resource{}
	// Test CopyTo empty
	dest = CopyResourceSlice(dest, src)
	assert.Equal(t, []Resource{}, dest)

	// Test CopyTo larger slice
	src = GenTestResourceSlice()
	dest = CopyResourceSlice(dest, src)
	assert.Equal(t, GenTestResourceSlice(), dest)

	// Test CopyTo same size slice
	dest = CopyResourceSlice(dest, src)
	assert.Equal(t, GenTestResourceSlice(), dest)

	// Test CopyTo smaller size slice
	dest = CopyResourceSlice(dest, []Resource{})
	assert.Len(t, dest, 0)

	// Test CopyTo larger slice with enough capacity
	dest = CopyResourceSlice(dest, src)
	assert.Equal(t, GenTestResourceSlice(), dest)
}

func TestCopyResourcePtrSlice(t *testing.T) {
	src := []*Resource{}
	dest := []*Resource{}
	// Test CopyTo empty
	dest = CopyResourcePtrSlice(dest, src)
	assert.Equal(t, []*Resource{}, dest)

	// Test CopyTo larger slice
	src = GenTestResourcePtrSlice()
	dest = CopyResourcePtrSlice(dest, src)
	assert.Equal(t, GenTestResourcePtrSlice(), dest)

	// Test CopyTo same size slice
	dest = CopyResourcePtrSlice(dest, src)
	assert.Equal(t, GenTestResourcePtrSlice(), dest)

	// Test CopyTo smaller size slice
	dest = CopyResourcePtrSlice(dest, []*Resource{})
	assert.Len(t, dest, 0)

	// Test CopyTo larger slice with enough capacity
	dest = CopyResourcePtrSlice(dest, src)
	assert.Equal(t, GenTestResourcePtrSlice(), dest)
}

func TestMarshalAndUnmarshalJSONResourceUnknown(t *testing.T) {
	iter := json.BorrowIterator([]byte(`{"unknown": "string"}`))
	defer json.ReturnIterator(iter)
	dest := NewResource()
	dest.UnmarshalJSON(iter)
	require.NoError(t, iter.Error())
	assert.Equal(t, NewResource(), dest)
}

func TestMarshalAndUnmarshalJSONResource(t *testing.T) {
	for name, src := range genTestEncodingValuesResource() {
		for _, pooling := range []bool{true, false} {
			t.Run(name+"/Pooling="+strconv.FormatBool(pooling), func(t *testing.T) {
				prevPooling := UseProtoPooling.IsEnabled()
				require.NoError(t, featuregate.GlobalRegistry().Set(UseProtoPooling.ID(), pooling))
				defer func() {
					require.NoError(t, featuregate.GlobalRegistry().Set(UseProtoPooling.ID(), prevPooling))
				}()

				stream := json.BorrowStream(nil)
				defer json.ReturnStream(stream)
				src.MarshalJSON(stream)
				require.NoError(t, stream.Error())

				iter := json.BorrowIterator(stream.Buffer())
				defer json.ReturnIterator(iter)
				dest := NewResource()
				dest.UnmarshalJSON(iter)
				require.NoError(t, iter.Error())

				assert.Equal(t, src, dest)
				DeleteResource(dest, true)
			})
		}
	}
}

func TestMarshalAndUnmarshalProtoResourceFailing(t *testing.T) {
	for name, buf := range genTestFailingUnmarshalProtoValuesResource() {
		t.Run(name, func(t *testing.T) {
			dest := NewResource()
			require.Error(t, dest.UnmarshalProto(buf))
		})
	}
}

func TestMarshalAndUnmarshalProtoResourceUnknown(t *testing.T) {
	dest := NewResource()
	// message Test { required int64 field = 1313; } encoding { "field": "1234" }
	require.NoError(t, dest.UnmarshalProto([]byte{0x88, 0x52, 0xD2, 0x09}))
	assert.Equal(t, NewResource(), dest)
}

func TestMarshalAndUnmarshalProtoResource(t *testing.T) {
	for name, src := range genTestEncodingValuesResource() {
		for _, pooling := range []bool{true, false} {
			t.Run(name+"/Pooling="+strconv.FormatBool(pooling), func(t *testing.T) {
				prevPooling := UseProtoPooling.IsEnabled()
				require.NoError(t, featuregate.GlobalRegistry().Set(UseProtoPooling.ID(), pooling))
				defer func() {
					require.NoError(t, featuregate.GlobalRegistry().Set(UseProtoPooling.ID(), prevPooling))
				}()

				buf := make([]byte, src.SizeProto())
				gotSize := src.MarshalProto(buf)
				assert.Equal(t, len(buf), gotSize)

				dest := NewResource()
				require.NoError(t, dest.UnmarshalProto(buf))

				assert.Equal(t, src, dest)
				DeleteResource(dest, true)
			})
		}
	}
}

func TestMarshalAndUnmarshalProtoViaProtobufResource(t *testing.T) {
	for name, src := range genTestEncodingValuesResource() {
		t.Run(name, func(t *testing.T) {
			buf := make([]byte, src.SizeProto())
			gotSize := src.MarshalProto(buf)
			assert.Equal(t, len(buf), gotSize)

			goDest := &gootlpresource.Resource{}
			require.NoError(t, proto.Unmarshal(buf, goDest))

			goBuf, err := proto.Marshal(goDest)
			require.NoError(t, err)

			dest := NewResource()
			require.NoError(t, dest.UnmarshalProto(goBuf))
			assert.Equal(t, src, dest)
		})
	}
}

func genTestFailingUnmarshalProtoValuesResource() map[string][]byte {
	return map[string][]byte{
		"invalid_field":                          {0x02},
		"Attributes/wrong_wire_type":             {0xc},
		"Attributes/missing_value":               {0xa},
		"DroppedAttributesCount/wrong_wire_type": {0x14},
		"DroppedAttributesCount/missing_value":   {0x10},
		"EntityRefs/wrong_wire_type":             {0x1c},
		"EntityRefs/missing_value":               {0x1a},
	}
}

func genTestEncodingValuesResource() map[string]*Resource {
	return map[string]*Resource{
		"empty":                       NewResource(),
		"Attributes/test":             {Attributes: []KeyValue{{}, *GenTestKeyValue()}},
		"DroppedAttributesCount/test": {DroppedAttributesCount: uint32(13)},
		"EntityRefs/test":             {EntityRefs: []*EntityRef{{}, GenTestEntityRef()}},
	}
}
