// Copyright The OpenTelemetry Authors
// SPDX-License-Identifier: Apache-2.0

// Code generated by "internal/cmd/pdatagen/main.go". DO NOT EDIT.
// To regenerate this file run "make genpdata".

package internal

import (
	"fmt"
	"sync"

	"go.opentelemetry.io/collector/pdata/internal/json"
	"go.opentelemetry.io/collector/pdata/internal/proto"
)

// Location describes function and line table debug information.
type Location struct {
	MappingIndex     int32
	Address          uint64
	Lines            []*Line
	AttributeIndices []int32
}

var (
	protoPoolLocation = sync.Pool{
		New: func() any {
			return &Location{}
		},
	}
)

func NewLocation() *Location {
	if !UseProtoPooling.IsEnabled() {
		return &Location{}
	}
	return protoPoolLocation.Get().(*Location)
}

func DeleteLocation(orig *Location, nullable bool) {
	if orig == nil {
		return
	}

	if !UseProtoPooling.IsEnabled() {
		orig.Reset()
		return
	}

	for i := range orig.Lines {
		DeleteLine(orig.Lines[i], true)
	}

	orig.Reset()
	if nullable {
		protoPoolLocation.Put(orig)
	}
}

func CopyLocation(dest, src *Location) *Location {
	// If copying to same object, just return.
	if src == dest {
		return dest
	}

	if src == nil {
		return nil
	}

	if dest == nil {
		dest = NewLocation()
	}
	dest.MappingIndex = src.MappingIndex

	dest.Address = src.Address

	dest.Lines = CopyLinePtrSlice(dest.Lines, src.Lines)

	dest.AttributeIndices = append(dest.AttributeIndices[:0], src.AttributeIndices...)

	return dest
}

func CopyLocationSlice(dest, src []Location) []Location {
	var newDest []Location
	if cap(dest) < len(src) {
		newDest = make([]Location, len(src))
	} else {
		newDest = dest[:len(src)]
		// Cleanup the rest of the elements so GC can free the memory.
		// This can happen when len(src) < len(dest) < cap(dest).
		for i := len(src); i < len(dest); i++ {
			DeleteLocation(&dest[i], false)
		}
	}
	for i := range src {
		CopyLocation(&newDest[i], &src[i])
	}
	return newDest
}

func CopyLocationPtrSlice(dest, src []*Location) []*Location {
	var newDest []*Location
	if cap(dest) < len(src) {
		newDest = make([]*Location, len(src))
		// Copy old pointers to re-use.
		copy(newDest, dest)
		// Add new pointers for missing elements from len(dest) to len(srt).
		for i := len(dest); i < len(src); i++ {
			newDest[i] = NewLocation()
		}
	} else {
		newDest = dest[:len(src)]
		// Cleanup the rest of the elements so GC can free the memory.
		// This can happen when len(src) < len(dest) < cap(dest).
		for i := len(src); i < len(dest); i++ {
			DeleteLocation(dest[i], true)
			dest[i] = nil
		}
		// Add new pointers for missing elements.
		// This can happen when len(dest) < len(src) < cap(dest).
		for i := len(dest); i < len(src); i++ {
			newDest[i] = NewLocation()
		}
	}
	for i := range src {
		CopyLocation(newDest[i], src[i])
	}
	return newDest
}

func (orig *Location) Reset() {
	*orig = Location{}
}

// MarshalJSON marshals all properties from the current struct to the destination stream.
func (orig *Location) MarshalJSON(dest *json.Stream) {
	dest.WriteObjectStart()
	if orig.MappingIndex != int32(0) {
		dest.WriteObjectField("mappingIndex")
		dest.WriteInt32(orig.MappingIndex)
	}
	if orig.Address != uint64(0) {
		dest.WriteObjectField("address")
		dest.WriteUint64(orig.Address)
	}
	if len(orig.Lines) > 0 {
		dest.WriteObjectField("lines")
		dest.WriteArrayStart()
		orig.Lines[0].MarshalJSON(dest)
		for i := 1; i < len(orig.Lines); i++ {
			dest.WriteMore()
			orig.Lines[i].MarshalJSON(dest)
		}
		dest.WriteArrayEnd()
	}
	if len(orig.AttributeIndices) > 0 {
		dest.WriteObjectField("attributeIndices")
		dest.WriteArrayStart()
		dest.WriteInt32(orig.AttributeIndices[0])
		for i := 1; i < len(orig.AttributeIndices); i++ {
			dest.WriteMore()
			dest.WriteInt32(orig.AttributeIndices[i])
		}
		dest.WriteArrayEnd()
	}
	dest.WriteObjectEnd()
}

// UnmarshalJSON unmarshals all properties from the current struct from the source iterator.
func (orig *Location) UnmarshalJSON(iter *json.Iterator) {
	for f := iter.ReadObject(); f != ""; f = iter.ReadObject() {
		switch f {
		case "mappingIndex", "mapping_index":
			orig.MappingIndex = iter.ReadInt32()
		case "address":
			orig.Address = iter.ReadUint64()
		case "lines":
			for iter.ReadArray() {
				orig.Lines = append(orig.Lines, NewLine())
				orig.Lines[len(orig.Lines)-1].UnmarshalJSON(iter)
			}

		case "attributeIndices", "attribute_indices":
			for iter.ReadArray() {
				orig.AttributeIndices = append(orig.AttributeIndices, iter.ReadInt32())
			}

		default:
			iter.Skip()
		}
	}
}

func (orig *Location) SizeProto() int {
	var n int
	var l int
	_ = l
	if orig.MappingIndex != 0 {
		n += 1 + proto.Sov(uint64(orig.MappingIndex))
	}
	if orig.Address != 0 {
		n += 1 + proto.Sov(uint64(orig.Address))
	}
	for i := range orig.Lines {
		l = orig.Lines[i].SizeProto()
		n += 1 + proto.Sov(uint64(l)) + l
	}
	if len(orig.AttributeIndices) > 0 {
		l = 0
		for _, e := range orig.AttributeIndices {
			l += proto.Sov(uint64(e))
		}
		n += 1 + proto.Sov(uint64(l)) + l
	}
	return n
}

func (orig *Location) MarshalProto(buf []byte) int {
	pos := len(buf)
	var l int
	_ = l
	if orig.MappingIndex != 0 {
		pos = proto.EncodeVarint(buf, pos, uint64(orig.MappingIndex))
		pos--
		buf[pos] = 0x8
	}
	if orig.Address != 0 {
		pos = proto.EncodeVarint(buf, pos, uint64(orig.Address))
		pos--
		buf[pos] = 0x10
	}
	for i := len(orig.Lines) - 1; i >= 0; i-- {
		l = orig.Lines[i].MarshalProto(buf[:pos])
		pos -= l
		pos = proto.EncodeVarint(buf, pos, uint64(l))
		pos--
		buf[pos] = 0x1a
	}
	l = len(orig.AttributeIndices)
	if l > 0 {
		endPos := pos
		for i := l - 1; i >= 0; i-- {
			pos = proto.EncodeVarint(buf, pos, uint64(orig.AttributeIndices[i]))
		}
		pos = proto.EncodeVarint(buf, pos, uint64(endPos-pos))
		pos--
		buf[pos] = 0x22
	}
	return len(buf) - pos
}

func (orig *Location) UnmarshalProto(buf []byte) error {
	var err error
	var fieldNum int32
	var wireType proto.WireType

	l := len(buf)
	pos := 0
	for pos < l {
		// If in a group parsing, move to the next tag.
		fieldNum, wireType, pos, err = proto.ConsumeTag(buf, pos)
		if err != nil {
			return err
		}
		switch fieldNum {

		case 1:
			if wireType != proto.WireTypeVarint {
				return fmt.Errorf("proto: wrong wireType = %d for field MappingIndex", wireType)
			}
			var num uint64
			num, pos, err = proto.ConsumeVarint(buf, pos)
			if err != nil {
				return err
			}

			orig.MappingIndex = int32(num)

		case 2:
			if wireType != proto.WireTypeVarint {
				return fmt.Errorf("proto: wrong wireType = %d for field Address", wireType)
			}
			var num uint64
			num, pos, err = proto.ConsumeVarint(buf, pos)
			if err != nil {
				return err
			}

			orig.Address = uint64(num)

		case 3:
			if wireType != proto.WireTypeLen {
				return fmt.Errorf("proto: wrong wireType = %d for field Lines", wireType)
			}
			var length int
			length, pos, err = proto.ConsumeLen(buf, pos)
			if err != nil {
				return err
			}
			startPos := pos - length
			orig.Lines = append(orig.Lines, NewLine())
			err = orig.Lines[len(orig.Lines)-1].UnmarshalProto(buf[startPos:pos])
			if err != nil {
				return err
			}
		case 4:
			switch wireType {
			case proto.WireTypeLen:
				var length int
				length, pos, err = proto.ConsumeLen(buf, pos)
				if err != nil {
					return err
				}
				startPos := pos - length
				var num uint64
				for startPos < pos {
					num, startPos, err = proto.ConsumeVarint(buf[:pos], startPos)
					if err != nil {
						return err
					}
					orig.AttributeIndices = append(orig.AttributeIndices, int32(num))
				}
				if startPos != pos {
					return fmt.Errorf("proto: invalid field len = %d for field AttributeIndices", pos-startPos)
				}
			case proto.WireTypeVarint:
				var num uint64
				num, pos, err = proto.ConsumeVarint(buf, pos)
				if err != nil {
					return err
				}
				orig.AttributeIndices = append(orig.AttributeIndices, int32(num))
			default:
				return fmt.Errorf("proto: wrong wireType = %d for field AttributeIndices", wireType)
			}
		default:
			pos, err = proto.ConsumeUnknown(buf, pos, wireType)
			if err != nil {
				return err
			}
		}
	}
	return nil
}

func GenTestLocation() *Location {
	orig := NewLocation()
	orig.MappingIndex = int32(13)
	orig.Address = uint64(13)
	orig.Lines = []*Line{{}, GenTestLine()}
	orig.AttributeIndices = []int32{int32(0), int32(13)}
	return orig
}

func GenTestLocationPtrSlice() []*Location {
	orig := make([]*Location, 5)
	orig[0] = NewLocation()
	orig[1] = GenTestLocation()
	orig[2] = NewLocation()
	orig[3] = GenTestLocation()
	orig[4] = NewLocation()
	return orig
}

func GenTestLocationSlice() []Location {
	orig := make([]Location, 5)
	orig[1] = *GenTestLocation()
	orig[3] = *GenTestLocation()
	return orig
}
