// Copyright The OpenTelemetry Authors
// SPDX-License-Identifier: Apache-2.0

// Code generated by "internal/cmd/pdatagen/main.go". DO NOT EDIT.
// To regenerate this file run "make genpdata".

package internal

import (
	"strconv"
	"testing"

	"github.com/stretchr/testify/assert"
	"github.com/stretchr/testify/require"
	gootlpprofiles "go.opentelemetry.io/proto/slim/otlp/profiles/v1development"
	"google.golang.org/protobuf/proto"

	"go.opentelemetry.io/collector/featuregate"
	"go.opentelemetry.io/collector/pdata/internal/json"
)

func TestCopyLine(t *testing.T) {
	for name, src := range genTestEncodingValuesLine() {
		for _, pooling := range []bool{true, false} {
			t.Run(name+"/Pooling="+strconv.FormatBool(pooling), func(t *testing.T) {
				prevPooling := UseProtoPooling.IsEnabled()
				require.NoError(t, featuregate.GlobalRegistry().Set(UseProtoPooling.ID(), pooling))
				defer func() {
					require.NoError(t, featuregate.GlobalRegistry().Set(UseProtoPooling.ID(), prevPooling))
				}()

				dest := NewLine()
				CopyLine(dest, src)
				assert.Equal(t, src, dest)
				CopyLine(dest, dest)
				assert.Equal(t, src, dest)
			})
		}
	}
}

func TestCopyLineSlice(t *testing.T) {
	src := []Line{}
	dest := []Line{}
	// Test CopyTo empty
	dest = CopyLineSlice(dest, src)
	assert.Equal(t, []Line{}, dest)

	// Test CopyTo larger slice
	src = GenTestLineSlice()
	dest = CopyLineSlice(dest, src)
	assert.Equal(t, GenTestLineSlice(), dest)

	// Test CopyTo same size slice
	dest = CopyLineSlice(dest, src)
	assert.Equal(t, GenTestLineSlice(), dest)

	// Test CopyTo smaller size slice
	dest = CopyLineSlice(dest, []Line{})
	assert.Len(t, dest, 0)

	// Test CopyTo larger slice with enough capacity
	dest = CopyLineSlice(dest, src)
	assert.Equal(t, GenTestLineSlice(), dest)
}

func TestCopyLinePtrSlice(t *testing.T) {
	src := []*Line{}
	dest := []*Line{}
	// Test CopyTo empty
	dest = CopyLinePtrSlice(dest, src)
	assert.Equal(t, []*Line{}, dest)

	// Test CopyTo larger slice
	src = GenTestLinePtrSlice()
	dest = CopyLinePtrSlice(dest, src)
	assert.Equal(t, GenTestLinePtrSlice(), dest)

	// Test CopyTo same size slice
	dest = CopyLinePtrSlice(dest, src)
	assert.Equal(t, GenTestLinePtrSlice(), dest)

	// Test CopyTo smaller size slice
	dest = CopyLinePtrSlice(dest, []*Line{})
	assert.Len(t, dest, 0)

	// Test CopyTo larger slice with enough capacity
	dest = CopyLinePtrSlice(dest, src)
	assert.Equal(t, GenTestLinePtrSlice(), dest)
}

func TestMarshalAndUnmarshalJSONLineUnknown(t *testing.T) {
	iter := json.BorrowIterator([]byte(`{"unknown": "string"}`))
	defer json.ReturnIterator(iter)
	dest := NewLine()
	dest.UnmarshalJSON(iter)
	require.NoError(t, iter.Error())
	assert.Equal(t, NewLine(), dest)
}

func TestMarshalAndUnmarshalJSONLine(t *testing.T) {
	for name, src := range genTestEncodingValuesLine() {
		for _, pooling := range []bool{true, false} {
			t.Run(name+"/Pooling="+strconv.FormatBool(pooling), func(t *testing.T) {
				prevPooling := UseProtoPooling.IsEnabled()
				require.NoError(t, featuregate.GlobalRegistry().Set(UseProtoPooling.ID(), pooling))
				defer func() {
					require.NoError(t, featuregate.GlobalRegistry().Set(UseProtoPooling.ID(), prevPooling))
				}()

				stream := json.BorrowStream(nil)
				defer json.ReturnStream(stream)
				src.MarshalJSON(stream)
				require.NoError(t, stream.Error())

				iter := json.BorrowIterator(stream.Buffer())
				defer json.ReturnIterator(iter)
				dest := NewLine()
				dest.UnmarshalJSON(iter)
				require.NoError(t, iter.Error())

				assert.Equal(t, src, dest)
				DeleteLine(dest, true)
			})
		}
	}
}

func TestMarshalAndUnmarshalProtoLineFailing(t *testing.T) {
	for name, buf := range genTestFailingUnmarshalProtoValuesLine() {
		t.Run(name, func(t *testing.T) {
			dest := NewLine()
			require.Error(t, dest.UnmarshalProto(buf))
		})
	}
}

func TestMarshalAndUnmarshalProtoLineUnknown(t *testing.T) {
	dest := NewLine()
	// message Test { required int64 field = 1313; } encoding { "field": "1234" }
	require.NoError(t, dest.UnmarshalProto([]byte{0x88, 0x52, 0xD2, 0x09}))
	assert.Equal(t, NewLine(), dest)
}

func TestMarshalAndUnmarshalProtoLine(t *testing.T) {
	for name, src := range genTestEncodingValuesLine() {
		for _, pooling := range []bool{true, false} {
			t.Run(name+"/Pooling="+strconv.FormatBool(pooling), func(t *testing.T) {
				prevPooling := UseProtoPooling.IsEnabled()
				require.NoError(t, featuregate.GlobalRegistry().Set(UseProtoPooling.ID(), pooling))
				defer func() {
					require.NoError(t, featuregate.GlobalRegistry().Set(UseProtoPooling.ID(), prevPooling))
				}()

				buf := make([]byte, src.SizeProto())
				gotSize := src.MarshalProto(buf)
				assert.Equal(t, len(buf), gotSize)

				dest := NewLine()
				require.NoError(t, dest.UnmarshalProto(buf))

				assert.Equal(t, src, dest)
				DeleteLine(dest, true)
			})
		}
	}
}

func TestMarshalAndUnmarshalProtoViaProtobufLine(t *testing.T) {
	for name, src := range genTestEncodingValuesLine() {
		t.Run(name, func(t *testing.T) {
			buf := make([]byte, src.SizeProto())
			gotSize := src.MarshalProto(buf)
			assert.Equal(t, len(buf), gotSize)

			goDest := &gootlpprofiles.Line{}
			require.NoError(t, proto.Unmarshal(buf, goDest))

			goBuf, err := proto.Marshal(goDest)
			require.NoError(t, err)

			dest := NewLine()
			require.NoError(t, dest.UnmarshalProto(goBuf))
			assert.Equal(t, src, dest)
		})
	}
}

func genTestFailingUnmarshalProtoValuesLine() map[string][]byte {
	return map[string][]byte{
		"invalid_field":                 {0x02},
		"FunctionIndex/wrong_wire_type": {0xc},
		"FunctionIndex/missing_value":   {0x8},
		"Line/wrong_wire_type":          {0x14},
		"Line/missing_value":            {0x10},
		"Column/wrong_wire_type":        {0x1c},
		"Column/missing_value":          {0x18},
	}
}

func genTestEncodingValuesLine() map[string]*Line {
	return map[string]*Line{
		"empty":              NewLine(),
		"FunctionIndex/test": {FunctionIndex: int32(13)},
		"Line/test":          {Line: int64(13)},
		"Column/test":        {Column: int64(13)},
	}
}
