// Copyright The OpenTelemetry Authors
// SPDX-License-Identifier: Apache-2.0

// Code generated by "internal/cmd/pdatagen/main.go". DO NOT EDIT.
// To regenerate this file run "make genpdata".

package internal

import (
	"fmt"
	"sync"

	"go.opentelemetry.io/collector/pdata/internal/json"
	"go.opentelemetry.io/collector/pdata/internal/proto"
)

type IPAddr struct {
	IP   []byte
	Zone string
}

var (
	protoPoolIPAddr = sync.Pool{
		New: func() any {
			return &IPAddr{}
		},
	}
)

func NewIPAddr() *IPAddr {
	if !UseProtoPooling.IsEnabled() {
		return &IPAddr{}
	}
	return protoPoolIPAddr.Get().(*IPAddr)
}

func DeleteIPAddr(orig *IPAddr, nullable bool) {
	if orig == nil {
		return
	}

	if !UseProtoPooling.IsEnabled() {
		orig.Reset()
		return
	}

	orig.Reset()
	if nullable {
		protoPoolIPAddr.Put(orig)
	}
}

func CopyIPAddr(dest, src *IPAddr) *IPAddr {
	// If copying to same object, just return.
	if src == dest {
		return dest
	}

	if src == nil {
		return nil
	}

	if dest == nil {
		dest = NewIPAddr()
	}
	dest.IP = src.IP

	dest.Zone = src.Zone

	return dest
}

func CopyIPAddrSlice(dest, src []IPAddr) []IPAddr {
	var newDest []IPAddr
	if cap(dest) < len(src) {
		newDest = make([]IPAddr, len(src))
	} else {
		newDest = dest[:len(src)]
		// Cleanup the rest of the elements so GC can free the memory.
		// This can happen when len(src) < len(dest) < cap(dest).
		for i := len(src); i < len(dest); i++ {
			DeleteIPAddr(&dest[i], false)
		}
	}
	for i := range src {
		CopyIPAddr(&newDest[i], &src[i])
	}
	return newDest
}

func CopyIPAddrPtrSlice(dest, src []*IPAddr) []*IPAddr {
	var newDest []*IPAddr
	if cap(dest) < len(src) {
		newDest = make([]*IPAddr, len(src))
		// Copy old pointers to re-use.
		copy(newDest, dest)
		// Add new pointers for missing elements from len(dest) to len(srt).
		for i := len(dest); i < len(src); i++ {
			newDest[i] = NewIPAddr()
		}
	} else {
		newDest = dest[:len(src)]
		// Cleanup the rest of the elements so GC can free the memory.
		// This can happen when len(src) < len(dest) < cap(dest).
		for i := len(src); i < len(dest); i++ {
			DeleteIPAddr(dest[i], true)
			dest[i] = nil
		}
		// Add new pointers for missing elements.
		// This can happen when len(dest) < len(src) < cap(dest).
		for i := len(dest); i < len(src); i++ {
			newDest[i] = NewIPAddr()
		}
	}
	for i := range src {
		CopyIPAddr(newDest[i], src[i])
	}
	return newDest
}

func (orig *IPAddr) Reset() {
	*orig = IPAddr{}
}

// MarshalJSON marshals all properties from the current struct to the destination stream.
func (orig *IPAddr) MarshalJSON(dest *json.Stream) {
	dest.WriteObjectStart()

	if len(orig.IP) > 0 {
		dest.WriteObjectField("iP")
		dest.WriteBytes(orig.IP)
	}
	if orig.Zone != "" {
		dest.WriteObjectField("zone")
		dest.WriteString(orig.Zone)
	}
	dest.WriteObjectEnd()
}

// UnmarshalJSON unmarshals all properties from the current struct from the source iterator.
func (orig *IPAddr) UnmarshalJSON(iter *json.Iterator) {
	for f := iter.ReadObject(); f != ""; f = iter.ReadObject() {
		switch f {
		case "iP":
			orig.IP = iter.ReadBytes()
		case "zone":
			orig.Zone = iter.ReadString()
		default:
			iter.Skip()
		}
	}
}

func (orig *IPAddr) SizeProto() int {
	var n int
	var l int
	_ = l
	l = len(orig.IP)
	if l > 0 {
		n += 1 + proto.Sov(uint64(l)) + l
	}
	l = len(orig.Zone)
	if l > 0 {
		n += 1 + proto.Sov(uint64(l)) + l
	}
	return n
}

func (orig *IPAddr) MarshalProto(buf []byte) int {
	pos := len(buf)
	var l int
	_ = l
	l = len(orig.IP)
	if l > 0 {
		pos -= l
		copy(buf[pos:], orig.IP)
		pos = proto.EncodeVarint(buf, pos, uint64(l))
		pos--
		buf[pos] = 0xa
	}
	l = len(orig.Zone)
	if l > 0 {
		pos -= l
		copy(buf[pos:], orig.Zone)
		pos = proto.EncodeVarint(buf, pos, uint64(l))
		pos--
		buf[pos] = 0x12
	}
	return len(buf) - pos
}

func (orig *IPAddr) UnmarshalProto(buf []byte) error {
	var err error
	var fieldNum int32
	var wireType proto.WireType

	l := len(buf)
	pos := 0
	for pos < l {
		// If in a group parsing, move to the next tag.
		fieldNum, wireType, pos, err = proto.ConsumeTag(buf, pos)
		if err != nil {
			return err
		}
		switch fieldNum {

		case 1:
			if wireType != proto.WireTypeLen {
				return fmt.Errorf("proto: wrong wireType = %d for field IP", wireType)
			}
			var length int
			length, pos, err = proto.ConsumeLen(buf, pos)
			if err != nil {
				return err
			}
			startPos := pos - length
			if length != 0 {
				orig.IP = make([]byte, length)
				copy(orig.IP, buf[startPos:pos])
			}

		case 2:
			if wireType != proto.WireTypeLen {
				return fmt.Errorf("proto: wrong wireType = %d for field Zone", wireType)
			}
			var length int
			length, pos, err = proto.ConsumeLen(buf, pos)
			if err != nil {
				return err
			}
			startPos := pos - length
			orig.Zone = string(buf[startPos:pos])
		default:
			pos, err = proto.ConsumeUnknown(buf, pos, wireType)
			if err != nil {
				return err
			}
		}
	}
	return nil
}

func GenTestIPAddr() *IPAddr {
	orig := NewIPAddr()
	orig.IP = []byte{1, 2, 3}
	orig.Zone = "test_zone"
	return orig
}

func GenTestIPAddrPtrSlice() []*IPAddr {
	orig := make([]*IPAddr, 5)
	orig[0] = NewIPAddr()
	orig[1] = GenTestIPAddr()
	orig[2] = NewIPAddr()
	orig[3] = GenTestIPAddr()
	orig[4] = NewIPAddr()
	return orig
}

func GenTestIPAddrSlice() []IPAddr {
	orig := make([]IPAddr, 5)
	orig[1] = *GenTestIPAddr()
	orig[3] = *GenTestIPAddr()
	return orig
}
