// Copyright The OpenTelemetry Authors
// SPDX-License-Identifier: Apache-2.0

// Code generated by "internal/cmd/pdatagen/main.go". DO NOT EDIT.
// To regenerate this file run "make genpdata".

package internal

import (
	"strconv"
	"testing"

	"github.com/stretchr/testify/assert"
	"github.com/stretchr/testify/require"
	gootlpcollectormetrics "go.opentelemetry.io/proto/slim/otlp/collector/metrics/v1"
	"google.golang.org/protobuf/proto"

	"go.opentelemetry.io/collector/featuregate"
	"go.opentelemetry.io/collector/pdata/internal/json"
)

func TestCopyExportMetricsPartialSuccess(t *testing.T) {
	for name, src := range genTestEncodingValuesExportMetricsPartialSuccess() {
		for _, pooling := range []bool{true, false} {
			t.Run(name+"/Pooling="+strconv.FormatBool(pooling), func(t *testing.T) {
				prevPooling := UseProtoPooling.IsEnabled()
				require.NoError(t, featuregate.GlobalRegistry().Set(UseProtoPooling.ID(), pooling))
				defer func() {
					require.NoError(t, featuregate.GlobalRegistry().Set(UseProtoPooling.ID(), prevPooling))
				}()

				dest := NewExportMetricsPartialSuccess()
				CopyExportMetricsPartialSuccess(dest, src)
				assert.Equal(t, src, dest)
				CopyExportMetricsPartialSuccess(dest, dest)
				assert.Equal(t, src, dest)
			})
		}
	}
}

func TestCopyExportMetricsPartialSuccessSlice(t *testing.T) {
	src := []ExportMetricsPartialSuccess{}
	dest := []ExportMetricsPartialSuccess{}
	// Test CopyTo empty
	dest = CopyExportMetricsPartialSuccessSlice(dest, src)
	assert.Equal(t, []ExportMetricsPartialSuccess{}, dest)

	// Test CopyTo larger slice
	src = GenTestExportMetricsPartialSuccessSlice()
	dest = CopyExportMetricsPartialSuccessSlice(dest, src)
	assert.Equal(t, GenTestExportMetricsPartialSuccessSlice(), dest)

	// Test CopyTo same size slice
	dest = CopyExportMetricsPartialSuccessSlice(dest, src)
	assert.Equal(t, GenTestExportMetricsPartialSuccessSlice(), dest)

	// Test CopyTo smaller size slice
	dest = CopyExportMetricsPartialSuccessSlice(dest, []ExportMetricsPartialSuccess{})
	assert.Len(t, dest, 0)

	// Test CopyTo larger slice with enough capacity
	dest = CopyExportMetricsPartialSuccessSlice(dest, src)
	assert.Equal(t, GenTestExportMetricsPartialSuccessSlice(), dest)
}

func TestCopyExportMetricsPartialSuccessPtrSlice(t *testing.T) {
	src := []*ExportMetricsPartialSuccess{}
	dest := []*ExportMetricsPartialSuccess{}
	// Test CopyTo empty
	dest = CopyExportMetricsPartialSuccessPtrSlice(dest, src)
	assert.Equal(t, []*ExportMetricsPartialSuccess{}, dest)

	// Test CopyTo larger slice
	src = GenTestExportMetricsPartialSuccessPtrSlice()
	dest = CopyExportMetricsPartialSuccessPtrSlice(dest, src)
	assert.Equal(t, GenTestExportMetricsPartialSuccessPtrSlice(), dest)

	// Test CopyTo same size slice
	dest = CopyExportMetricsPartialSuccessPtrSlice(dest, src)
	assert.Equal(t, GenTestExportMetricsPartialSuccessPtrSlice(), dest)

	// Test CopyTo smaller size slice
	dest = CopyExportMetricsPartialSuccessPtrSlice(dest, []*ExportMetricsPartialSuccess{})
	assert.Len(t, dest, 0)

	// Test CopyTo larger slice with enough capacity
	dest = CopyExportMetricsPartialSuccessPtrSlice(dest, src)
	assert.Equal(t, GenTestExportMetricsPartialSuccessPtrSlice(), dest)
}

func TestMarshalAndUnmarshalJSONExportMetricsPartialSuccessUnknown(t *testing.T) {
	iter := json.BorrowIterator([]byte(`{"unknown": "string"}`))
	defer json.ReturnIterator(iter)
	dest := NewExportMetricsPartialSuccess()
	dest.UnmarshalJSON(iter)
	require.NoError(t, iter.Error())
	assert.Equal(t, NewExportMetricsPartialSuccess(), dest)
}

func TestMarshalAndUnmarshalJSONExportMetricsPartialSuccess(t *testing.T) {
	for name, src := range genTestEncodingValuesExportMetricsPartialSuccess() {
		for _, pooling := range []bool{true, false} {
			t.Run(name+"/Pooling="+strconv.FormatBool(pooling), func(t *testing.T) {
				prevPooling := UseProtoPooling.IsEnabled()
				require.NoError(t, featuregate.GlobalRegistry().Set(UseProtoPooling.ID(), pooling))
				defer func() {
					require.NoError(t, featuregate.GlobalRegistry().Set(UseProtoPooling.ID(), prevPooling))
				}()

				stream := json.BorrowStream(nil)
				defer json.ReturnStream(stream)
				src.MarshalJSON(stream)
				require.NoError(t, stream.Error())

				iter := json.BorrowIterator(stream.Buffer())
				defer json.ReturnIterator(iter)
				dest := NewExportMetricsPartialSuccess()
				dest.UnmarshalJSON(iter)
				require.NoError(t, iter.Error())

				assert.Equal(t, src, dest)
				DeleteExportMetricsPartialSuccess(dest, true)
			})
		}
	}
}

func TestMarshalAndUnmarshalProtoExportMetricsPartialSuccessFailing(t *testing.T) {
	for name, buf := range genTestFailingUnmarshalProtoValuesExportMetricsPartialSuccess() {
		t.Run(name, func(t *testing.T) {
			dest := NewExportMetricsPartialSuccess()
			require.Error(t, dest.UnmarshalProto(buf))
		})
	}
}

func TestMarshalAndUnmarshalProtoExportMetricsPartialSuccessUnknown(t *testing.T) {
	dest := NewExportMetricsPartialSuccess()
	// message Test { required int64 field = 1313; } encoding { "field": "1234" }
	require.NoError(t, dest.UnmarshalProto([]byte{0x88, 0x52, 0xD2, 0x09}))
	assert.Equal(t, NewExportMetricsPartialSuccess(), dest)
}

func TestMarshalAndUnmarshalProtoExportMetricsPartialSuccess(t *testing.T) {
	for name, src := range genTestEncodingValuesExportMetricsPartialSuccess() {
		for _, pooling := range []bool{true, false} {
			t.Run(name+"/Pooling="+strconv.FormatBool(pooling), func(t *testing.T) {
				prevPooling := UseProtoPooling.IsEnabled()
				require.NoError(t, featuregate.GlobalRegistry().Set(UseProtoPooling.ID(), pooling))
				defer func() {
					require.NoError(t, featuregate.GlobalRegistry().Set(UseProtoPooling.ID(), prevPooling))
				}()

				buf := make([]byte, src.SizeProto())
				gotSize := src.MarshalProto(buf)
				assert.Equal(t, len(buf), gotSize)

				dest := NewExportMetricsPartialSuccess()
				require.NoError(t, dest.UnmarshalProto(buf))

				assert.Equal(t, src, dest)
				DeleteExportMetricsPartialSuccess(dest, true)
			})
		}
	}
}

func TestMarshalAndUnmarshalProtoViaProtobufExportMetricsPartialSuccess(t *testing.T) {
	for name, src := range genTestEncodingValuesExportMetricsPartialSuccess() {
		t.Run(name, func(t *testing.T) {
			buf := make([]byte, src.SizeProto())
			gotSize := src.MarshalProto(buf)
			assert.Equal(t, len(buf), gotSize)

			goDest := &gootlpcollectormetrics.ExportMetricsPartialSuccess{}
			require.NoError(t, proto.Unmarshal(buf, goDest))

			goBuf, err := proto.Marshal(goDest)
			require.NoError(t, err)

			dest := NewExportMetricsPartialSuccess()
			require.NoError(t, dest.UnmarshalProto(goBuf))
			assert.Equal(t, src, dest)
		})
	}
}

func genTestFailingUnmarshalProtoValuesExportMetricsPartialSuccess() map[string][]byte {
	return map[string][]byte{
		"invalid_field":                      {0x02},
		"RejectedDataPoints/wrong_wire_type": {0xc},
		"RejectedDataPoints/missing_value":   {0x8},
		"ErrorMessage/wrong_wire_type":       {0x14},
		"ErrorMessage/missing_value":         {0x12},
	}
}

func genTestEncodingValuesExportMetricsPartialSuccess() map[string]*ExportMetricsPartialSuccess {
	return map[string]*ExportMetricsPartialSuccess{
		"empty":                   NewExportMetricsPartialSuccess(),
		"RejectedDataPoints/test": {RejectedDataPoints: int64(13)},
		"ErrorMessage/test":       {ErrorMessage: "test_errormessage"},
	}
}
