// Copyright The OpenTelemetry Authors
// SPDX-License-Identifier: Apache-2.0

// Code generated by "internal/cmd/pdatagen/main.go". DO NOT EDIT.
// To regenerate this file run "make genpdata".

package internal

import (
	"strconv"
	"testing"

	"github.com/stretchr/testify/assert"
	"github.com/stretchr/testify/require"
	gootlpmetrics "go.opentelemetry.io/proto/slim/otlp/metrics/v1"
	"google.golang.org/protobuf/proto"

	"go.opentelemetry.io/collector/featuregate"
	"go.opentelemetry.io/collector/pdata/internal/json"
)

func TestCopyExponentialHistogramDataPoint(t *testing.T) {
	for name, src := range genTestEncodingValuesExponentialHistogramDataPoint() {
		for _, pooling := range []bool{true, false} {
			t.Run(name+"/Pooling="+strconv.FormatBool(pooling), func(t *testing.T) {
				prevPooling := UseProtoPooling.IsEnabled()
				require.NoError(t, featuregate.GlobalRegistry().Set(UseProtoPooling.ID(), pooling))
				defer func() {
					require.NoError(t, featuregate.GlobalRegistry().Set(UseProtoPooling.ID(), prevPooling))
				}()

				dest := NewExponentialHistogramDataPoint()
				CopyExponentialHistogramDataPoint(dest, src)
				assert.Equal(t, src, dest)
				CopyExponentialHistogramDataPoint(dest, dest)
				assert.Equal(t, src, dest)
			})
		}
	}
}

func TestCopyExponentialHistogramDataPointSlice(t *testing.T) {
	src := []ExponentialHistogramDataPoint{}
	dest := []ExponentialHistogramDataPoint{}
	// Test CopyTo empty
	dest = CopyExponentialHistogramDataPointSlice(dest, src)
	assert.Equal(t, []ExponentialHistogramDataPoint{}, dest)

	// Test CopyTo larger slice
	src = GenTestExponentialHistogramDataPointSlice()
	dest = CopyExponentialHistogramDataPointSlice(dest, src)
	assert.Equal(t, GenTestExponentialHistogramDataPointSlice(), dest)

	// Test CopyTo same size slice
	dest = CopyExponentialHistogramDataPointSlice(dest, src)
	assert.Equal(t, GenTestExponentialHistogramDataPointSlice(), dest)

	// Test CopyTo smaller size slice
	dest = CopyExponentialHistogramDataPointSlice(dest, []ExponentialHistogramDataPoint{})
	assert.Len(t, dest, 0)

	// Test CopyTo larger slice with enough capacity
	dest = CopyExponentialHistogramDataPointSlice(dest, src)
	assert.Equal(t, GenTestExponentialHistogramDataPointSlice(), dest)
}

func TestCopyExponentialHistogramDataPointPtrSlice(t *testing.T) {
	src := []*ExponentialHistogramDataPoint{}
	dest := []*ExponentialHistogramDataPoint{}
	// Test CopyTo empty
	dest = CopyExponentialHistogramDataPointPtrSlice(dest, src)
	assert.Equal(t, []*ExponentialHistogramDataPoint{}, dest)

	// Test CopyTo larger slice
	src = GenTestExponentialHistogramDataPointPtrSlice()
	dest = CopyExponentialHistogramDataPointPtrSlice(dest, src)
	assert.Equal(t, GenTestExponentialHistogramDataPointPtrSlice(), dest)

	// Test CopyTo same size slice
	dest = CopyExponentialHistogramDataPointPtrSlice(dest, src)
	assert.Equal(t, GenTestExponentialHistogramDataPointPtrSlice(), dest)

	// Test CopyTo smaller size slice
	dest = CopyExponentialHistogramDataPointPtrSlice(dest, []*ExponentialHistogramDataPoint{})
	assert.Len(t, dest, 0)

	// Test CopyTo larger slice with enough capacity
	dest = CopyExponentialHistogramDataPointPtrSlice(dest, src)
	assert.Equal(t, GenTestExponentialHistogramDataPointPtrSlice(), dest)
}

func TestMarshalAndUnmarshalJSONExponentialHistogramDataPointUnknown(t *testing.T) {
	iter := json.BorrowIterator([]byte(`{"unknown": "string"}`))
	defer json.ReturnIterator(iter)
	dest := NewExponentialHistogramDataPoint()
	dest.UnmarshalJSON(iter)
	require.NoError(t, iter.Error())
	assert.Equal(t, NewExponentialHistogramDataPoint(), dest)
}

func TestMarshalAndUnmarshalJSONExponentialHistogramDataPoint(t *testing.T) {
	for name, src := range genTestEncodingValuesExponentialHistogramDataPoint() {
		for _, pooling := range []bool{true, false} {
			t.Run(name+"/Pooling="+strconv.FormatBool(pooling), func(t *testing.T) {
				prevPooling := UseProtoPooling.IsEnabled()
				require.NoError(t, featuregate.GlobalRegistry().Set(UseProtoPooling.ID(), pooling))
				defer func() {
					require.NoError(t, featuregate.GlobalRegistry().Set(UseProtoPooling.ID(), prevPooling))
				}()

				stream := json.BorrowStream(nil)
				defer json.ReturnStream(stream)
				src.MarshalJSON(stream)
				require.NoError(t, stream.Error())

				iter := json.BorrowIterator(stream.Buffer())
				defer json.ReturnIterator(iter)
				dest := NewExponentialHistogramDataPoint()
				dest.UnmarshalJSON(iter)
				require.NoError(t, iter.Error())

				assert.Equal(t, src, dest)
				DeleteExponentialHistogramDataPoint(dest, true)
			})
		}
	}
}

func TestMarshalAndUnmarshalProtoExponentialHistogramDataPointFailing(t *testing.T) {
	for name, buf := range genTestFailingUnmarshalProtoValuesExponentialHistogramDataPoint() {
		t.Run(name, func(t *testing.T) {
			dest := NewExponentialHistogramDataPoint()
			require.Error(t, dest.UnmarshalProto(buf))
		})
	}
}

func TestMarshalAndUnmarshalProtoExponentialHistogramDataPointUnknown(t *testing.T) {
	dest := NewExponentialHistogramDataPoint()
	// message Test { required int64 field = 1313; } encoding { "field": "1234" }
	require.NoError(t, dest.UnmarshalProto([]byte{0x88, 0x52, 0xD2, 0x09}))
	assert.Equal(t, NewExponentialHistogramDataPoint(), dest)
}

func TestMarshalAndUnmarshalProtoExponentialHistogramDataPoint(t *testing.T) {
	for name, src := range genTestEncodingValuesExponentialHistogramDataPoint() {
		for _, pooling := range []bool{true, false} {
			t.Run(name+"/Pooling="+strconv.FormatBool(pooling), func(t *testing.T) {
				prevPooling := UseProtoPooling.IsEnabled()
				require.NoError(t, featuregate.GlobalRegistry().Set(UseProtoPooling.ID(), pooling))
				defer func() {
					require.NoError(t, featuregate.GlobalRegistry().Set(UseProtoPooling.ID(), prevPooling))
				}()

				buf := make([]byte, src.SizeProto())
				gotSize := src.MarshalProto(buf)
				assert.Equal(t, len(buf), gotSize)

				dest := NewExponentialHistogramDataPoint()
				require.NoError(t, dest.UnmarshalProto(buf))

				assert.Equal(t, src, dest)
				DeleteExponentialHistogramDataPoint(dest, true)
			})
		}
	}
}

func TestMarshalAndUnmarshalProtoViaProtobufExponentialHistogramDataPoint(t *testing.T) {
	for name, src := range genTestEncodingValuesExponentialHistogramDataPoint() {
		t.Run(name, func(t *testing.T) {
			buf := make([]byte, src.SizeProto())
			gotSize := src.MarshalProto(buf)
			assert.Equal(t, len(buf), gotSize)

			goDest := &gootlpmetrics.ExponentialHistogramDataPoint{}
			require.NoError(t, proto.Unmarshal(buf, goDest))

			goBuf, err := proto.Marshal(goDest)
			require.NoError(t, err)

			dest := NewExponentialHistogramDataPoint()
			require.NoError(t, dest.UnmarshalProto(goBuf))
			assert.Equal(t, src, dest)
		})
	}
}

func genTestFailingUnmarshalProtoValuesExponentialHistogramDataPoint() map[string][]byte {
	return map[string][]byte{
		"invalid_field":                     {0x02},
		"Attributes/wrong_wire_type":        {0xc},
		"Attributes/missing_value":          {0xa},
		"StartTimeUnixNano/wrong_wire_type": {0x14},
		"StartTimeUnixNano/missing_value":   {0x11},
		"TimeUnixNano/wrong_wire_type":      {0x1c},
		"TimeUnixNano/missing_value":        {0x19},
		"Count/wrong_wire_type":             {0x24},
		"Count/missing_value":               {0x21},
		"Sum/wrong_wire_type":               {0x2c},
		"Sum/missing_value":                 {0x29},
		"Scale/wrong_wire_type":             {0x34},
		"Scale/missing_value":               {0x30},
		"ZeroCount/wrong_wire_type":         {0x3c},
		"ZeroCount/missing_value":           {0x39},
		"Positive/wrong_wire_type":          {0x44},
		"Positive/missing_value":            {0x42},
		"Negative/wrong_wire_type":          {0x4c},
		"Negative/missing_value":            {0x4a},
		"Flags/wrong_wire_type":             {0x54},
		"Flags/missing_value":               {0x50},
		"Exemplars/wrong_wire_type":         {0x5c},
		"Exemplars/missing_value":           {0x5a},
		"Min/wrong_wire_type":               {0x64},
		"Min/missing_value":                 {0x61},
		"Max/wrong_wire_type":               {0x6c},
		"Max/missing_value":                 {0x69},
		"ZeroThreshold/wrong_wire_type":     {0x74},
		"ZeroThreshold/missing_value":       {0x71},
	}
}

func genTestEncodingValuesExponentialHistogramDataPoint() map[string]*ExponentialHistogramDataPoint {
	return map[string]*ExponentialHistogramDataPoint{
		"empty":                  NewExponentialHistogramDataPoint(),
		"Attributes/test":        {Attributes: []KeyValue{{}, *GenTestKeyValue()}},
		"StartTimeUnixNano/test": {StartTimeUnixNano: uint64(13)},
		"TimeUnixNano/test":      {TimeUnixNano: uint64(13)},
		"Count/test":             {Count: uint64(13)}, "Sum/default": {Sum_: &ExponentialHistogramDataPoint_Sum{Sum: float64(0)}},
		"Sum/test":       {Sum_: &ExponentialHistogramDataPoint_Sum{Sum: float64(3.1415926)}},
		"Scale/test":     {Scale: int32(13)},
		"ZeroCount/test": {ZeroCount: uint64(13)},
		"Positive/test":  {Positive: *GenTestExponentialHistogramDataPointBuckets()},
		"Negative/test":  {Negative: *GenTestExponentialHistogramDataPointBuckets()},
		"Flags/test":     {Flags: uint32(13)},
		"Exemplars/test": {Exemplars: []Exemplar{{}, *GenTestExemplar()}}, "Min/default": {Min_: &ExponentialHistogramDataPoint_Min{Min: float64(0)}},
		"Min/test": {Min_: &ExponentialHistogramDataPoint_Min{Min: float64(3.1415926)}}, "Max/default": {Max_: &ExponentialHistogramDataPoint_Max{Max: float64(0)}},
		"Max/test":           {Max_: &ExponentialHistogramDataPoint_Max{Max: float64(3.1415926)}},
		"ZeroThreshold/test": {ZeroThreshold: float64(3.1415926)},
	}
}
