// Copyright The OpenTelemetry Authors
// SPDX-License-Identifier: Apache-2.0

// Code generated by "internal/cmd/pdatagen/main.go". DO NOT EDIT.
// To regenerate this file run "make genpdata".

package internal

import (
	"encoding/binary"
	"fmt"
	"math"
	"sync"

	"go.opentelemetry.io/collector/pdata/internal/json"
	"go.opentelemetry.io/collector/pdata/internal/proto"
)

func (m *ExponentialHistogramDataPoint) GetSum_() any {
	if m != nil {
		return m.Sum_
	}
	return nil
}

type ExponentialHistogramDataPoint_Sum struct {
	Sum float64
}

func (m *ExponentialHistogramDataPoint) GetSum() float64 {
	if v, ok := m.GetSum_().(*ExponentialHistogramDataPoint_Sum); ok {
		return v.Sum
	}
	return float64(0)
}

func (m *ExponentialHistogramDataPoint) GetMin_() any {
	if m != nil {
		return m.Min_
	}
	return nil
}

type ExponentialHistogramDataPoint_Min struct {
	Min float64
}

func (m *ExponentialHistogramDataPoint) GetMin() float64 {
	if v, ok := m.GetMin_().(*ExponentialHistogramDataPoint_Min); ok {
		return v.Min
	}
	return float64(0)
}

func (m *ExponentialHistogramDataPoint) GetMax_() any {
	if m != nil {
		return m.Max_
	}
	return nil
}

type ExponentialHistogramDataPoint_Max struct {
	Max float64
}

func (m *ExponentialHistogramDataPoint) GetMax() float64 {
	if v, ok := m.GetMax_().(*ExponentialHistogramDataPoint_Max); ok {
		return v.Max
	}
	return float64(0)
}

// ExponentialHistogramDataPoint is a single data point in a timeseries that describes the
// time-varying values of a ExponentialHistogram of double values. A ExponentialHistogram contains
// summary statistics for a population of values, it may optionally contain the
// distribution of those values across a set of buckets.
type ExponentialHistogramDataPoint struct {
	Attributes        []KeyValue
	StartTimeUnixNano uint64
	TimeUnixNano      uint64
	Count             uint64
	Sum_              any
	Scale             int32
	ZeroCount         uint64
	Positive          ExponentialHistogramDataPointBuckets
	Negative          ExponentialHistogramDataPointBuckets
	Flags             uint32
	Exemplars         []Exemplar
	Min_              any
	Max_              any
	ZeroThreshold     float64
}

var (
	protoPoolExponentialHistogramDataPoint = sync.Pool{
		New: func() any {
			return &ExponentialHistogramDataPoint{}
		},
	}
	ProtoPoolExponentialHistogramDataPoint_Sum = sync.Pool{
		New: func() any {
			return &ExponentialHistogramDataPoint_Sum{}
		},
	}

	ProtoPoolExponentialHistogramDataPoint_Min = sync.Pool{
		New: func() any {
			return &ExponentialHistogramDataPoint_Min{}
		},
	}

	ProtoPoolExponentialHistogramDataPoint_Max = sync.Pool{
		New: func() any {
			return &ExponentialHistogramDataPoint_Max{}
		},
	}
)

func NewExponentialHistogramDataPoint() *ExponentialHistogramDataPoint {
	if !UseProtoPooling.IsEnabled() {
		return &ExponentialHistogramDataPoint{}
	}
	return protoPoolExponentialHistogramDataPoint.Get().(*ExponentialHistogramDataPoint)
}

func DeleteExponentialHistogramDataPoint(orig *ExponentialHistogramDataPoint, nullable bool) {
	if orig == nil {
		return
	}

	if !UseProtoPooling.IsEnabled() {
		orig.Reset()
		return
	}

	for i := range orig.Attributes {
		DeleteKeyValue(&orig.Attributes[i], false)
	}
	switch ov := orig.Sum_.(type) {
	case *ExponentialHistogramDataPoint_Sum:
		if UseProtoPooling.IsEnabled() {
			ov.Sum = float64(0)
			ProtoPoolExponentialHistogramDataPoint_Sum.Put(ov)
		}

	}
	DeleteExponentialHistogramDataPointBuckets(&orig.Positive, false)
	DeleteExponentialHistogramDataPointBuckets(&orig.Negative, false)
	for i := range orig.Exemplars {
		DeleteExemplar(&orig.Exemplars[i], false)
	}
	switch ov := orig.Min_.(type) {
	case *ExponentialHistogramDataPoint_Min:
		if UseProtoPooling.IsEnabled() {
			ov.Min = float64(0)
			ProtoPoolExponentialHistogramDataPoint_Min.Put(ov)
		}

	}
	switch ov := orig.Max_.(type) {
	case *ExponentialHistogramDataPoint_Max:
		if UseProtoPooling.IsEnabled() {
			ov.Max = float64(0)
			ProtoPoolExponentialHistogramDataPoint_Max.Put(ov)
		}

	}

	orig.Reset()
	if nullable {
		protoPoolExponentialHistogramDataPoint.Put(orig)
	}
}

func CopyExponentialHistogramDataPoint(dest, src *ExponentialHistogramDataPoint) *ExponentialHistogramDataPoint {
	// If copying to same object, just return.
	if src == dest {
		return dest
	}

	if src == nil {
		return nil
	}

	if dest == nil {
		dest = NewExponentialHistogramDataPoint()
	}
	dest.Attributes = CopyKeyValueSlice(dest.Attributes, src.Attributes)

	dest.StartTimeUnixNano = src.StartTimeUnixNano

	dest.TimeUnixNano = src.TimeUnixNano

	dest.Count = src.Count

	switch t := src.Sum_.(type) {
	case *ExponentialHistogramDataPoint_Sum:
		var ov *ExponentialHistogramDataPoint_Sum
		if !UseProtoPooling.IsEnabled() {
			ov = &ExponentialHistogramDataPoint_Sum{}
		} else {
			ov = ProtoPoolExponentialHistogramDataPoint_Sum.Get().(*ExponentialHistogramDataPoint_Sum)
		}
		ov.Sum = t.Sum
		dest.Sum_ = ov
	default:
		dest.Sum_ = nil
	}

	dest.Scale = src.Scale

	dest.ZeroCount = src.ZeroCount

	CopyExponentialHistogramDataPointBuckets(&dest.Positive, &src.Positive)

	CopyExponentialHistogramDataPointBuckets(&dest.Negative, &src.Negative)

	dest.Flags = src.Flags

	dest.Exemplars = CopyExemplarSlice(dest.Exemplars, src.Exemplars)

	switch t := src.Min_.(type) {
	case *ExponentialHistogramDataPoint_Min:
		var ov *ExponentialHistogramDataPoint_Min
		if !UseProtoPooling.IsEnabled() {
			ov = &ExponentialHistogramDataPoint_Min{}
		} else {
			ov = ProtoPoolExponentialHistogramDataPoint_Min.Get().(*ExponentialHistogramDataPoint_Min)
		}
		ov.Min = t.Min
		dest.Min_ = ov
	default:
		dest.Min_ = nil
	}

	switch t := src.Max_.(type) {
	case *ExponentialHistogramDataPoint_Max:
		var ov *ExponentialHistogramDataPoint_Max
		if !UseProtoPooling.IsEnabled() {
			ov = &ExponentialHistogramDataPoint_Max{}
		} else {
			ov = ProtoPoolExponentialHistogramDataPoint_Max.Get().(*ExponentialHistogramDataPoint_Max)
		}
		ov.Max = t.Max
		dest.Max_ = ov
	default:
		dest.Max_ = nil
	}

	dest.ZeroThreshold = src.ZeroThreshold

	return dest
}

func CopyExponentialHistogramDataPointSlice(dest, src []ExponentialHistogramDataPoint) []ExponentialHistogramDataPoint {
	var newDest []ExponentialHistogramDataPoint
	if cap(dest) < len(src) {
		newDest = make([]ExponentialHistogramDataPoint, len(src))
	} else {
		newDest = dest[:len(src)]
		// Cleanup the rest of the elements so GC can free the memory.
		// This can happen when len(src) < len(dest) < cap(dest).
		for i := len(src); i < len(dest); i++ {
			DeleteExponentialHistogramDataPoint(&dest[i], false)
		}
	}
	for i := range src {
		CopyExponentialHistogramDataPoint(&newDest[i], &src[i])
	}
	return newDest
}

func CopyExponentialHistogramDataPointPtrSlice(dest, src []*ExponentialHistogramDataPoint) []*ExponentialHistogramDataPoint {
	var newDest []*ExponentialHistogramDataPoint
	if cap(dest) < len(src) {
		newDest = make([]*ExponentialHistogramDataPoint, len(src))
		// Copy old pointers to re-use.
		copy(newDest, dest)
		// Add new pointers for missing elements from len(dest) to len(srt).
		for i := len(dest); i < len(src); i++ {
			newDest[i] = NewExponentialHistogramDataPoint()
		}
	} else {
		newDest = dest[:len(src)]
		// Cleanup the rest of the elements so GC can free the memory.
		// This can happen when len(src) < len(dest) < cap(dest).
		for i := len(src); i < len(dest); i++ {
			DeleteExponentialHistogramDataPoint(dest[i], true)
			dest[i] = nil
		}
		// Add new pointers for missing elements.
		// This can happen when len(dest) < len(src) < cap(dest).
		for i := len(dest); i < len(src); i++ {
			newDest[i] = NewExponentialHistogramDataPoint()
		}
	}
	for i := range src {
		CopyExponentialHistogramDataPoint(newDest[i], src[i])
	}
	return newDest
}

func (orig *ExponentialHistogramDataPoint) Reset() {
	*orig = ExponentialHistogramDataPoint{}
}

// MarshalJSON marshals all properties from the current struct to the destination stream.
func (orig *ExponentialHistogramDataPoint) MarshalJSON(dest *json.Stream) {
	dest.WriteObjectStart()
	if len(orig.Attributes) > 0 {
		dest.WriteObjectField("attributes")
		dest.WriteArrayStart()
		orig.Attributes[0].MarshalJSON(dest)
		for i := 1; i < len(orig.Attributes); i++ {
			dest.WriteMore()
			orig.Attributes[i].MarshalJSON(dest)
		}
		dest.WriteArrayEnd()
	}
	if orig.StartTimeUnixNano != uint64(0) {
		dest.WriteObjectField("startTimeUnixNano")
		dest.WriteUint64(orig.StartTimeUnixNano)
	}
	if orig.TimeUnixNano != uint64(0) {
		dest.WriteObjectField("timeUnixNano")
		dest.WriteUint64(orig.TimeUnixNano)
	}
	if orig.Count != uint64(0) {
		dest.WriteObjectField("count")
		dest.WriteUint64(orig.Count)
	}
	if orig, ok := orig.Sum_.(*ExponentialHistogramDataPoint_Sum); ok {
		dest.WriteObjectField("sum")
		dest.WriteFloat64(orig.Sum)
	}
	if orig.Scale != int32(0) {
		dest.WriteObjectField("scale")
		dest.WriteInt32(orig.Scale)
	}
	if orig.ZeroCount != uint64(0) {
		dest.WriteObjectField("zeroCount")
		dest.WriteUint64(orig.ZeroCount)
	}
	dest.WriteObjectField("positive")
	orig.Positive.MarshalJSON(dest)
	dest.WriteObjectField("negative")
	orig.Negative.MarshalJSON(dest)
	if orig.Flags != uint32(0) {
		dest.WriteObjectField("flags")
		dest.WriteUint32(orig.Flags)
	}
	if len(orig.Exemplars) > 0 {
		dest.WriteObjectField("exemplars")
		dest.WriteArrayStart()
		orig.Exemplars[0].MarshalJSON(dest)
		for i := 1; i < len(orig.Exemplars); i++ {
			dest.WriteMore()
			orig.Exemplars[i].MarshalJSON(dest)
		}
		dest.WriteArrayEnd()
	}
	if orig, ok := orig.Min_.(*ExponentialHistogramDataPoint_Min); ok {
		dest.WriteObjectField("min")
		dest.WriteFloat64(orig.Min)
	}
	if orig, ok := orig.Max_.(*ExponentialHistogramDataPoint_Max); ok {
		dest.WriteObjectField("max")
		dest.WriteFloat64(orig.Max)
	}
	if orig.ZeroThreshold != float64(0) {
		dest.WriteObjectField("zeroThreshold")
		dest.WriteFloat64(orig.ZeroThreshold)
	}
	dest.WriteObjectEnd()
}

// UnmarshalJSON unmarshals all properties from the current struct from the source iterator.
func (orig *ExponentialHistogramDataPoint) UnmarshalJSON(iter *json.Iterator) {
	for f := iter.ReadObject(); f != ""; f = iter.ReadObject() {
		switch f {
		case "attributes":
			for iter.ReadArray() {
				orig.Attributes = append(orig.Attributes, KeyValue{})
				orig.Attributes[len(orig.Attributes)-1].UnmarshalJSON(iter)
			}

		case "startTimeUnixNano", "start_time_unix_nano":
			orig.StartTimeUnixNano = iter.ReadUint64()
		case "timeUnixNano", "time_unix_nano":
			orig.TimeUnixNano = iter.ReadUint64()
		case "count":
			orig.Count = iter.ReadUint64()
		case "sum":
			{
				var ov *ExponentialHistogramDataPoint_Sum
				if !UseProtoPooling.IsEnabled() {
					ov = &ExponentialHistogramDataPoint_Sum{}
				} else {
					ov = ProtoPoolExponentialHistogramDataPoint_Sum.Get().(*ExponentialHistogramDataPoint_Sum)
				}
				ov.Sum = iter.ReadFloat64()
				orig.Sum_ = ov
			}

		case "scale":
			orig.Scale = iter.ReadInt32()
		case "zeroCount", "zero_count":
			orig.ZeroCount = iter.ReadUint64()
		case "positive":

			orig.Positive.UnmarshalJSON(iter)
		case "negative":

			orig.Negative.UnmarshalJSON(iter)
		case "flags":
			orig.Flags = iter.ReadUint32()
		case "exemplars":
			for iter.ReadArray() {
				orig.Exemplars = append(orig.Exemplars, Exemplar{})
				orig.Exemplars[len(orig.Exemplars)-1].UnmarshalJSON(iter)
			}

		case "min":
			{
				var ov *ExponentialHistogramDataPoint_Min
				if !UseProtoPooling.IsEnabled() {
					ov = &ExponentialHistogramDataPoint_Min{}
				} else {
					ov = ProtoPoolExponentialHistogramDataPoint_Min.Get().(*ExponentialHistogramDataPoint_Min)
				}
				ov.Min = iter.ReadFloat64()
				orig.Min_ = ov
			}

		case "max":
			{
				var ov *ExponentialHistogramDataPoint_Max
				if !UseProtoPooling.IsEnabled() {
					ov = &ExponentialHistogramDataPoint_Max{}
				} else {
					ov = ProtoPoolExponentialHistogramDataPoint_Max.Get().(*ExponentialHistogramDataPoint_Max)
				}
				ov.Max = iter.ReadFloat64()
				orig.Max_ = ov
			}

		case "zeroThreshold", "zero_threshold":
			orig.ZeroThreshold = iter.ReadFloat64()
		default:
			iter.Skip()
		}
	}
}

func (orig *ExponentialHistogramDataPoint) SizeProto() int {
	var n int
	var l int
	_ = l
	for i := range orig.Attributes {
		l = orig.Attributes[i].SizeProto()
		n += 1 + proto.Sov(uint64(l)) + l
	}
	if orig.StartTimeUnixNano != 0 {
		n += 9
	}
	if orig.TimeUnixNano != 0 {
		n += 9
	}
	if orig.Count != 0 {
		n += 9
	}
	if orig, ok := orig.Sum_.(*ExponentialHistogramDataPoint_Sum); ok {
		_ = orig
		n += 9
	}
	if orig.Scale != 0 {
		n += 1 + proto.Soz(uint64(orig.Scale))
	}
	if orig.ZeroCount != 0 {
		n += 9
	}
	l = orig.Positive.SizeProto()
	n += 1 + proto.Sov(uint64(l)) + l
	l = orig.Negative.SizeProto()
	n += 1 + proto.Sov(uint64(l)) + l
	if orig.Flags != 0 {
		n += 1 + proto.Sov(uint64(orig.Flags))
	}
	for i := range orig.Exemplars {
		l = orig.Exemplars[i].SizeProto()
		n += 1 + proto.Sov(uint64(l)) + l
	}
	if orig, ok := orig.Min_.(*ExponentialHistogramDataPoint_Min); ok {
		_ = orig
		n += 9
	}
	if orig, ok := orig.Max_.(*ExponentialHistogramDataPoint_Max); ok {
		_ = orig
		n += 9
	}
	if orig.ZeroThreshold != 0 {
		n += 9
	}
	return n
}

func (orig *ExponentialHistogramDataPoint) MarshalProto(buf []byte) int {
	pos := len(buf)
	var l int
	_ = l
	for i := len(orig.Attributes) - 1; i >= 0; i-- {
		l = orig.Attributes[i].MarshalProto(buf[:pos])
		pos -= l
		pos = proto.EncodeVarint(buf, pos, uint64(l))
		pos--
		buf[pos] = 0xa
	}
	if orig.StartTimeUnixNano != 0 {
		pos -= 8
		binary.LittleEndian.PutUint64(buf[pos:], uint64(orig.StartTimeUnixNano))
		pos--
		buf[pos] = 0x11
	}
	if orig.TimeUnixNano != 0 {
		pos -= 8
		binary.LittleEndian.PutUint64(buf[pos:], uint64(orig.TimeUnixNano))
		pos--
		buf[pos] = 0x19
	}
	if orig.Count != 0 {
		pos -= 8
		binary.LittleEndian.PutUint64(buf[pos:], uint64(orig.Count))
		pos--
		buf[pos] = 0x21
	}
	if orig, ok := orig.Sum_.(*ExponentialHistogramDataPoint_Sum); ok {
		pos -= 8
		binary.LittleEndian.PutUint64(buf[pos:], math.Float64bits(orig.Sum))
		pos--
		buf[pos] = 0x29
	}
	if orig.Scale != 0 {
		pos = proto.EncodeVarint(buf, pos, uint64((uint32(orig.Scale)<<1)^uint32(orig.Scale>>31)))
		pos--
		buf[pos] = 0x30
	}
	if orig.ZeroCount != 0 {
		pos -= 8
		binary.LittleEndian.PutUint64(buf[pos:], uint64(orig.ZeroCount))
		pos--
		buf[pos] = 0x39
	}
	l = orig.Positive.MarshalProto(buf[:pos])
	pos -= l
	pos = proto.EncodeVarint(buf, pos, uint64(l))
	pos--
	buf[pos] = 0x42

	l = orig.Negative.MarshalProto(buf[:pos])
	pos -= l
	pos = proto.EncodeVarint(buf, pos, uint64(l))
	pos--
	buf[pos] = 0x4a

	if orig.Flags != 0 {
		pos = proto.EncodeVarint(buf, pos, uint64(orig.Flags))
		pos--
		buf[pos] = 0x50
	}
	for i := len(orig.Exemplars) - 1; i >= 0; i-- {
		l = orig.Exemplars[i].MarshalProto(buf[:pos])
		pos -= l
		pos = proto.EncodeVarint(buf, pos, uint64(l))
		pos--
		buf[pos] = 0x5a
	}
	if orig, ok := orig.Min_.(*ExponentialHistogramDataPoint_Min); ok {
		pos -= 8
		binary.LittleEndian.PutUint64(buf[pos:], math.Float64bits(orig.Min))
		pos--
		buf[pos] = 0x61
	}
	if orig, ok := orig.Max_.(*ExponentialHistogramDataPoint_Max); ok {
		pos -= 8
		binary.LittleEndian.PutUint64(buf[pos:], math.Float64bits(orig.Max))
		pos--
		buf[pos] = 0x69
	}
	if orig.ZeroThreshold != 0 {
		pos -= 8
		binary.LittleEndian.PutUint64(buf[pos:], math.Float64bits(orig.ZeroThreshold))
		pos--
		buf[pos] = 0x71
	}
	return len(buf) - pos
}

func (orig *ExponentialHistogramDataPoint) UnmarshalProto(buf []byte) error {
	var err error
	var fieldNum int32
	var wireType proto.WireType

	l := len(buf)
	pos := 0
	for pos < l {
		// If in a group parsing, move to the next tag.
		fieldNum, wireType, pos, err = proto.ConsumeTag(buf, pos)
		if err != nil {
			return err
		}
		switch fieldNum {

		case 1:
			if wireType != proto.WireTypeLen {
				return fmt.Errorf("proto: wrong wireType = %d for field Attributes", wireType)
			}
			var length int
			length, pos, err = proto.ConsumeLen(buf, pos)
			if err != nil {
				return err
			}
			startPos := pos - length
			orig.Attributes = append(orig.Attributes, KeyValue{})
			err = orig.Attributes[len(orig.Attributes)-1].UnmarshalProto(buf[startPos:pos])
			if err != nil {
				return err
			}

		case 2:
			if wireType != proto.WireTypeI64 {
				return fmt.Errorf("proto: wrong wireType = %d for field StartTimeUnixNano", wireType)
			}
			var num uint64
			num, pos, err = proto.ConsumeI64(buf, pos)
			if err != nil {
				return err
			}

			orig.StartTimeUnixNano = uint64(num)

		case 3:
			if wireType != proto.WireTypeI64 {
				return fmt.Errorf("proto: wrong wireType = %d for field TimeUnixNano", wireType)
			}
			var num uint64
			num, pos, err = proto.ConsumeI64(buf, pos)
			if err != nil {
				return err
			}

			orig.TimeUnixNano = uint64(num)

		case 4:
			if wireType != proto.WireTypeI64 {
				return fmt.Errorf("proto: wrong wireType = %d for field Count", wireType)
			}
			var num uint64
			num, pos, err = proto.ConsumeI64(buf, pos)
			if err != nil {
				return err
			}

			orig.Count = uint64(num)

		case 5:
			if wireType != proto.WireTypeI64 {
				return fmt.Errorf("proto: wrong wireType = %d for field Sum", wireType)
			}
			var num uint64
			num, pos, err = proto.ConsumeI64(buf, pos)
			if err != nil {
				return err
			}
			var ov *ExponentialHistogramDataPoint_Sum
			if !UseProtoPooling.IsEnabled() {
				ov = &ExponentialHistogramDataPoint_Sum{}
			} else {
				ov = ProtoPoolExponentialHistogramDataPoint_Sum.Get().(*ExponentialHistogramDataPoint_Sum)
			}
			ov.Sum = math.Float64frombits(num)
			orig.Sum_ = ov

		case 6:
			if wireType != proto.WireTypeVarint {
				return fmt.Errorf("proto: wrong wireType = %d for field Scale", wireType)
			}
			var num uint64
			num, pos, err = proto.ConsumeVarint(buf, pos)
			if err != nil {
				return err
			}

			orig.Scale = int32(uint32(num>>1) ^ uint32(int32((num&1)<<31)>>31))

		case 7:
			if wireType != proto.WireTypeI64 {
				return fmt.Errorf("proto: wrong wireType = %d for field ZeroCount", wireType)
			}
			var num uint64
			num, pos, err = proto.ConsumeI64(buf, pos)
			if err != nil {
				return err
			}

			orig.ZeroCount = uint64(num)

		case 8:
			if wireType != proto.WireTypeLen {
				return fmt.Errorf("proto: wrong wireType = %d for field Positive", wireType)
			}
			var length int
			length, pos, err = proto.ConsumeLen(buf, pos)
			if err != nil {
				return err
			}
			startPos := pos - length

			err = orig.Positive.UnmarshalProto(buf[startPos:pos])
			if err != nil {
				return err
			}

		case 9:
			if wireType != proto.WireTypeLen {
				return fmt.Errorf("proto: wrong wireType = %d for field Negative", wireType)
			}
			var length int
			length, pos, err = proto.ConsumeLen(buf, pos)
			if err != nil {
				return err
			}
			startPos := pos - length

			err = orig.Negative.UnmarshalProto(buf[startPos:pos])
			if err != nil {
				return err
			}

		case 10:
			if wireType != proto.WireTypeVarint {
				return fmt.Errorf("proto: wrong wireType = %d for field Flags", wireType)
			}
			var num uint64
			num, pos, err = proto.ConsumeVarint(buf, pos)
			if err != nil {
				return err
			}

			orig.Flags = uint32(num)

		case 11:
			if wireType != proto.WireTypeLen {
				return fmt.Errorf("proto: wrong wireType = %d for field Exemplars", wireType)
			}
			var length int
			length, pos, err = proto.ConsumeLen(buf, pos)
			if err != nil {
				return err
			}
			startPos := pos - length
			orig.Exemplars = append(orig.Exemplars, Exemplar{})
			err = orig.Exemplars[len(orig.Exemplars)-1].UnmarshalProto(buf[startPos:pos])
			if err != nil {
				return err
			}

		case 12:
			if wireType != proto.WireTypeI64 {
				return fmt.Errorf("proto: wrong wireType = %d for field Min", wireType)
			}
			var num uint64
			num, pos, err = proto.ConsumeI64(buf, pos)
			if err != nil {
				return err
			}
			var ov *ExponentialHistogramDataPoint_Min
			if !UseProtoPooling.IsEnabled() {
				ov = &ExponentialHistogramDataPoint_Min{}
			} else {
				ov = ProtoPoolExponentialHistogramDataPoint_Min.Get().(*ExponentialHistogramDataPoint_Min)
			}
			ov.Min = math.Float64frombits(num)
			orig.Min_ = ov

		case 13:
			if wireType != proto.WireTypeI64 {
				return fmt.Errorf("proto: wrong wireType = %d for field Max", wireType)
			}
			var num uint64
			num, pos, err = proto.ConsumeI64(buf, pos)
			if err != nil {
				return err
			}
			var ov *ExponentialHistogramDataPoint_Max
			if !UseProtoPooling.IsEnabled() {
				ov = &ExponentialHistogramDataPoint_Max{}
			} else {
				ov = ProtoPoolExponentialHistogramDataPoint_Max.Get().(*ExponentialHistogramDataPoint_Max)
			}
			ov.Max = math.Float64frombits(num)
			orig.Max_ = ov

		case 14:
			if wireType != proto.WireTypeI64 {
				return fmt.Errorf("proto: wrong wireType = %d for field ZeroThreshold", wireType)
			}
			var num uint64
			num, pos, err = proto.ConsumeI64(buf, pos)
			if err != nil {
				return err
			}

			orig.ZeroThreshold = math.Float64frombits(num)
		default:
			pos, err = proto.ConsumeUnknown(buf, pos, wireType)
			if err != nil {
				return err
			}
		}
	}
	return nil
}

func GenTestExponentialHistogramDataPoint() *ExponentialHistogramDataPoint {
	orig := NewExponentialHistogramDataPoint()
	orig.Attributes = []KeyValue{{}, *GenTestKeyValue()}
	orig.StartTimeUnixNano = uint64(13)
	orig.TimeUnixNano = uint64(13)
	orig.Count = uint64(13)
	orig.Sum_ = &ExponentialHistogramDataPoint_Sum{Sum: float64(3.1415926)}
	orig.Scale = int32(13)
	orig.ZeroCount = uint64(13)
	orig.Positive = *GenTestExponentialHistogramDataPointBuckets()
	orig.Negative = *GenTestExponentialHistogramDataPointBuckets()
	orig.Flags = uint32(13)
	orig.Exemplars = []Exemplar{{}, *GenTestExemplar()}
	orig.Min_ = &ExponentialHistogramDataPoint_Min{Min: float64(3.1415926)}
	orig.Max_ = &ExponentialHistogramDataPoint_Max{Max: float64(3.1415926)}
	orig.ZeroThreshold = float64(3.1415926)
	return orig
}

func GenTestExponentialHistogramDataPointPtrSlice() []*ExponentialHistogramDataPoint {
	orig := make([]*ExponentialHistogramDataPoint, 5)
	orig[0] = NewExponentialHistogramDataPoint()
	orig[1] = GenTestExponentialHistogramDataPoint()
	orig[2] = NewExponentialHistogramDataPoint()
	orig[3] = GenTestExponentialHistogramDataPoint()
	orig[4] = NewExponentialHistogramDataPoint()
	return orig
}

func GenTestExponentialHistogramDataPointSlice() []ExponentialHistogramDataPoint {
	orig := make([]ExponentialHistogramDataPoint, 5)
	orig[1] = *GenTestExponentialHistogramDataPoint()
	orig[3] = *GenTestExponentialHistogramDataPoint()
	return orig
}
