// Copyright The OpenTelemetry Authors
// SPDX-License-Identifier: Apache-2.0

// Code generated by "internal/cmd/pdatagen/main.go". DO NOT EDIT.
// To regenerate this file run "make genpdata".

package internal

import (
	"strconv"
	"testing"

	"github.com/stretchr/testify/assert"
	"github.com/stretchr/testify/require"
	gootlpmetrics "go.opentelemetry.io/proto/slim/otlp/metrics/v1"
	"google.golang.org/protobuf/proto"

	"go.opentelemetry.io/collector/featuregate"
	"go.opentelemetry.io/collector/pdata/internal/json"
)

func TestCopyExemplar(t *testing.T) {
	for name, src := range genTestEncodingValuesExemplar() {
		for _, pooling := range []bool{true, false} {
			t.Run(name+"/Pooling="+strconv.FormatBool(pooling), func(t *testing.T) {
				prevPooling := UseProtoPooling.IsEnabled()
				require.NoError(t, featuregate.GlobalRegistry().Set(UseProtoPooling.ID(), pooling))
				defer func() {
					require.NoError(t, featuregate.GlobalRegistry().Set(UseProtoPooling.ID(), prevPooling))
				}()

				dest := NewExemplar()
				CopyExemplar(dest, src)
				assert.Equal(t, src, dest)
				CopyExemplar(dest, dest)
				assert.Equal(t, src, dest)
			})
		}
	}
}

func TestCopyExemplarSlice(t *testing.T) {
	src := []Exemplar{}
	dest := []Exemplar{}
	// Test CopyTo empty
	dest = CopyExemplarSlice(dest, src)
	assert.Equal(t, []Exemplar{}, dest)

	// Test CopyTo larger slice
	src = GenTestExemplarSlice()
	dest = CopyExemplarSlice(dest, src)
	assert.Equal(t, GenTestExemplarSlice(), dest)

	// Test CopyTo same size slice
	dest = CopyExemplarSlice(dest, src)
	assert.Equal(t, GenTestExemplarSlice(), dest)

	// Test CopyTo smaller size slice
	dest = CopyExemplarSlice(dest, []Exemplar{})
	assert.Len(t, dest, 0)

	// Test CopyTo larger slice with enough capacity
	dest = CopyExemplarSlice(dest, src)
	assert.Equal(t, GenTestExemplarSlice(), dest)
}

func TestCopyExemplarPtrSlice(t *testing.T) {
	src := []*Exemplar{}
	dest := []*Exemplar{}
	// Test CopyTo empty
	dest = CopyExemplarPtrSlice(dest, src)
	assert.Equal(t, []*Exemplar{}, dest)

	// Test CopyTo larger slice
	src = GenTestExemplarPtrSlice()
	dest = CopyExemplarPtrSlice(dest, src)
	assert.Equal(t, GenTestExemplarPtrSlice(), dest)

	// Test CopyTo same size slice
	dest = CopyExemplarPtrSlice(dest, src)
	assert.Equal(t, GenTestExemplarPtrSlice(), dest)

	// Test CopyTo smaller size slice
	dest = CopyExemplarPtrSlice(dest, []*Exemplar{})
	assert.Len(t, dest, 0)

	// Test CopyTo larger slice with enough capacity
	dest = CopyExemplarPtrSlice(dest, src)
	assert.Equal(t, GenTestExemplarPtrSlice(), dest)
}

func TestMarshalAndUnmarshalJSONExemplarUnknown(t *testing.T) {
	iter := json.BorrowIterator([]byte(`{"unknown": "string"}`))
	defer json.ReturnIterator(iter)
	dest := NewExemplar()
	dest.UnmarshalJSON(iter)
	require.NoError(t, iter.Error())
	assert.Equal(t, NewExemplar(), dest)
}

func TestMarshalAndUnmarshalJSONExemplar(t *testing.T) {
	for name, src := range genTestEncodingValuesExemplar() {
		for _, pooling := range []bool{true, false} {
			t.Run(name+"/Pooling="+strconv.FormatBool(pooling), func(t *testing.T) {
				prevPooling := UseProtoPooling.IsEnabled()
				require.NoError(t, featuregate.GlobalRegistry().Set(UseProtoPooling.ID(), pooling))
				defer func() {
					require.NoError(t, featuregate.GlobalRegistry().Set(UseProtoPooling.ID(), prevPooling))
				}()

				stream := json.BorrowStream(nil)
				defer json.ReturnStream(stream)
				src.MarshalJSON(stream)
				require.NoError(t, stream.Error())

				iter := json.BorrowIterator(stream.Buffer())
				defer json.ReturnIterator(iter)
				dest := NewExemplar()
				dest.UnmarshalJSON(iter)
				require.NoError(t, iter.Error())

				assert.Equal(t, src, dest)
				DeleteExemplar(dest, true)
			})
		}
	}
}

func TestMarshalAndUnmarshalProtoExemplarFailing(t *testing.T) {
	for name, buf := range genTestFailingUnmarshalProtoValuesExemplar() {
		t.Run(name, func(t *testing.T) {
			dest := NewExemplar()
			require.Error(t, dest.UnmarshalProto(buf))
		})
	}
}

func TestMarshalAndUnmarshalProtoExemplarUnknown(t *testing.T) {
	dest := NewExemplar()
	// message Test { required int64 field = 1313; } encoding { "field": "1234" }
	require.NoError(t, dest.UnmarshalProto([]byte{0x88, 0x52, 0xD2, 0x09}))
	assert.Equal(t, NewExemplar(), dest)
}

func TestMarshalAndUnmarshalProtoExemplar(t *testing.T) {
	for name, src := range genTestEncodingValuesExemplar() {
		for _, pooling := range []bool{true, false} {
			t.Run(name+"/Pooling="+strconv.FormatBool(pooling), func(t *testing.T) {
				prevPooling := UseProtoPooling.IsEnabled()
				require.NoError(t, featuregate.GlobalRegistry().Set(UseProtoPooling.ID(), pooling))
				defer func() {
					require.NoError(t, featuregate.GlobalRegistry().Set(UseProtoPooling.ID(), prevPooling))
				}()

				buf := make([]byte, src.SizeProto())
				gotSize := src.MarshalProto(buf)
				assert.Equal(t, len(buf), gotSize)

				dest := NewExemplar()
				require.NoError(t, dest.UnmarshalProto(buf))

				assert.Equal(t, src, dest)
				DeleteExemplar(dest, true)
			})
		}
	}
}

func TestMarshalAndUnmarshalProtoViaProtobufExemplar(t *testing.T) {
	for name, src := range genTestEncodingValuesExemplar() {
		t.Run(name, func(t *testing.T) {
			buf := make([]byte, src.SizeProto())
			gotSize := src.MarshalProto(buf)
			assert.Equal(t, len(buf), gotSize)

			goDest := &gootlpmetrics.Exemplar{}
			require.NoError(t, proto.Unmarshal(buf, goDest))

			goBuf, err := proto.Marshal(goDest)
			require.NoError(t, err)

			dest := NewExemplar()
			require.NoError(t, dest.UnmarshalProto(goBuf))
			assert.Equal(t, src, dest)
		})
	}
}

func genTestFailingUnmarshalProtoValuesExemplar() map[string][]byte {
	return map[string][]byte{
		"invalid_field":                      {0x02},
		"FilteredAttributes/wrong_wire_type": {0x3c},
		"FilteredAttributes/missing_value":   {0x3a},
		"TimeUnixNano/wrong_wire_type":       {0x14},
		"TimeUnixNano/missing_value":         {0x11},

		"AsDouble/wrong_wire_type": {0x1c},
		"AsDouble/missing_value":   {0x19},

		"AsInt/wrong_wire_type":   {0x34},
		"AsInt/missing_value":     {0x31},
		"TraceId/wrong_wire_type": {0x2c},
		"TraceId/missing_value":   {0x2a},
		"SpanId/wrong_wire_type":  {0x24},
		"SpanId/missing_value":    {0x22},
	}
}

func genTestEncodingValuesExemplar() map[string]*Exemplar {
	return map[string]*Exemplar{
		"empty":                   NewExemplar(),
		"FilteredAttributes/test": {FilteredAttributes: []KeyValue{{}, *GenTestKeyValue()}},
		"TimeUnixNano/test":       {TimeUnixNano: uint64(13)},
		"AsDouble/default":        {Value: &Exemplar_AsDouble{AsDouble: float64(0)}},
		"AsDouble/test":           {Value: &Exemplar_AsDouble{AsDouble: float64(3.1415926)}},
		"AsInt/default":           {Value: &Exemplar_AsInt{AsInt: int64(0)}},
		"AsInt/test":              {Value: &Exemplar_AsInt{AsInt: int64(13)}},
		"TraceId/test":            {TraceId: *GenTestTraceID()},
		"SpanId/test":             {SpanId: *GenTestSpanID()},
	}
}
