// Copyright 2026 Google LLC.
// Use of this source code is governed by a BSD-style
// license that can be found in the LICENSE file.

// Code generated file. DO NOT EDIT.

// Package dlp provides access to the Sensitive Data Protection (DLP).
//
// This package is DEPRECATED. Use package cloud.google.com/go/dlp/apiv2 instead.
//
// For product documentation, see: https://cloud.google.com/sensitive-data-protection/docs/
//
// # Library status
//
// These client libraries are officially supported by Google. However, this
// library is considered complete and is in maintenance mode. This means
// that we will address critical bugs and security issues but will not add
// any new features.
//
// When possible, we recommend using our newer
// [Cloud Client Libraries for Go](https://pkg.go.dev/cloud.google.com/go)
// that are still actively being worked and iterated on.
//
// # Creating a client
//
// Usage example:
//
//	import "google.golang.org/api/dlp/v2"
//	...
//	ctx := context.Background()
//	dlpService, err := dlp.NewService(ctx)
//
// In this example, Google Application Default Credentials are used for
// authentication. For information on how to create and obtain Application
// Default Credentials, see https://developers.google.com/identity/protocols/application-default-credentials.
//
// # Other authentication options
//
// To use an API key for authentication (note: some APIs do not support API
// keys), use [google.golang.org/api/option.WithAPIKey]:
//
//	dlpService, err := dlp.NewService(ctx, option.WithAPIKey("AIza..."))
//
// To use an OAuth token (e.g., a user token obtained via a three-legged OAuth
// flow, use [google.golang.org/api/option.WithTokenSource]:
//
//	config := &oauth2.Config{...}
//	// ...
//	token, err := config.Exchange(ctx, ...)
//	dlpService, err := dlp.NewService(ctx, option.WithTokenSource(config.TokenSource(ctx, token)))
//
// See [google.golang.org/api/option.ClientOption] for details on options.
package dlp // import "google.golang.org/api/dlp/v2"

import (
	"bytes"
	"context"
	"encoding/json"
	"errors"
	"fmt"
	"io"
	"log/slog"
	"net/http"
	"net/url"
	"strconv"
	"strings"

	"github.com/googleapis/gax-go/v2/internallog"
	googleapi "google.golang.org/api/googleapi"
	internal "google.golang.org/api/internal"
	gensupport "google.golang.org/api/internal/gensupport"
	option "google.golang.org/api/option"
	internaloption "google.golang.org/api/option/internaloption"
	htransport "google.golang.org/api/transport/http"
)

// Always reference these packages, just in case the auto-generated code
// below doesn't.
var _ = bytes.NewBuffer
var _ = strconv.Itoa
var _ = fmt.Sprintf
var _ = json.NewDecoder
var _ = io.Copy
var _ = url.Parse
var _ = gensupport.MarshalJSON
var _ = googleapi.Version
var _ = errors.New
var _ = strings.Replace
var _ = context.Canceled
var _ = internaloption.WithDefaultEndpoint
var _ = internal.Version
var _ = internallog.New

const apiId = "dlp:v2"
const apiName = "dlp"
const apiVersion = "v2"
const basePath = "https://dlp.googleapis.com/"
const basePathTemplate = "https://dlp.UNIVERSE_DOMAIN/"
const mtlsBasePath = "https://dlp.mtls.googleapis.com/"

// OAuth2 scopes used by this API.
const (
	// See, edit, configure, and delete your Google Cloud data and see the email
	// address for your Google Account.
	CloudPlatformScope = "https://www.googleapis.com/auth/cloud-platform"
)

// NewService creates a new Service.
func NewService(ctx context.Context, opts ...option.ClientOption) (*Service, error) {
	scopesOption := internaloption.WithDefaultScopes(
		"https://www.googleapis.com/auth/cloud-platform",
	)
	// NOTE: prepend, so we don't override user-specified scopes.
	opts = append([]option.ClientOption{scopesOption}, opts...)
	opts = append(opts, internaloption.WithDefaultEndpoint(basePath))
	opts = append(opts, internaloption.WithDefaultEndpointTemplate(basePathTemplate))
	opts = append(opts, internaloption.WithDefaultMTLSEndpoint(mtlsBasePath))
	opts = append(opts, internaloption.EnableNewAuthLibrary())
	client, endpoint, err := htransport.NewClient(ctx, opts...)
	if err != nil {
		return nil, err
	}
	s := &Service{client: client, BasePath: basePath, logger: internaloption.GetLogger(opts)}
	s.InfoTypes = NewInfoTypesService(s)
	s.Locations = NewLocationsService(s)
	s.Organizations = NewOrganizationsService(s)
	s.Projects = NewProjectsService(s)
	if endpoint != "" {
		s.BasePath = endpoint
	}
	return s, nil
}

// New creates a new Service. It uses the provided http.Client for requests.
//
// Deprecated: please use NewService instead.
// To provide a custom HTTP client, use option.WithHTTPClient.
// If you are using google.golang.org/api/googleapis/transport.APIKey, use option.WithAPIKey with NewService instead.
func New(client *http.Client) (*Service, error) {
	if client == nil {
		return nil, errors.New("client is nil")
	}
	return NewService(context.TODO(), option.WithHTTPClient(client))
}

type Service struct {
	client    *http.Client
	logger    *slog.Logger
	BasePath  string // API endpoint base URL
	UserAgent string // optional additional User-Agent fragment

	InfoTypes *InfoTypesService

	Locations *LocationsService

	Organizations *OrganizationsService

	Projects *ProjectsService
}

func (s *Service) userAgent() string {
	if s.UserAgent == "" {
		return googleapi.UserAgent
	}
	return googleapi.UserAgent + " " + s.UserAgent
}

func NewInfoTypesService(s *Service) *InfoTypesService {
	rs := &InfoTypesService{s: s}
	return rs
}

type InfoTypesService struct {
	s *Service
}

func NewLocationsService(s *Service) *LocationsService {
	rs := &LocationsService{s: s}
	rs.InfoTypes = NewLocationsInfoTypesService(s)
	return rs
}

type LocationsService struct {
	s *Service

	InfoTypes *LocationsInfoTypesService
}

func NewLocationsInfoTypesService(s *Service) *LocationsInfoTypesService {
	rs := &LocationsInfoTypesService{s: s}
	return rs
}

type LocationsInfoTypesService struct {
	s *Service
}

func NewOrganizationsService(s *Service) *OrganizationsService {
	rs := &OrganizationsService{s: s}
	rs.DeidentifyTemplates = NewOrganizationsDeidentifyTemplatesService(s)
	rs.InspectTemplates = NewOrganizationsInspectTemplatesService(s)
	rs.Locations = NewOrganizationsLocationsService(s)
	rs.StoredInfoTypes = NewOrganizationsStoredInfoTypesService(s)
	return rs
}

type OrganizationsService struct {
	s *Service

	DeidentifyTemplates *OrganizationsDeidentifyTemplatesService

	InspectTemplates *OrganizationsInspectTemplatesService

	Locations *OrganizationsLocationsService

	StoredInfoTypes *OrganizationsStoredInfoTypesService
}

func NewOrganizationsDeidentifyTemplatesService(s *Service) *OrganizationsDeidentifyTemplatesService {
	rs := &OrganizationsDeidentifyTemplatesService{s: s}
	return rs
}

type OrganizationsDeidentifyTemplatesService struct {
	s *Service
}

func NewOrganizationsInspectTemplatesService(s *Service) *OrganizationsInspectTemplatesService {
	rs := &OrganizationsInspectTemplatesService{s: s}
	return rs
}

type OrganizationsInspectTemplatesService struct {
	s *Service
}

func NewOrganizationsLocationsService(s *Service) *OrganizationsLocationsService {
	rs := &OrganizationsLocationsService{s: s}
	rs.ColumnDataProfiles = NewOrganizationsLocationsColumnDataProfilesService(s)
	rs.Connections = NewOrganizationsLocationsConnectionsService(s)
	rs.DeidentifyTemplates = NewOrganizationsLocationsDeidentifyTemplatesService(s)
	rs.DiscoveryConfigs = NewOrganizationsLocationsDiscoveryConfigsService(s)
	rs.DlpJobs = NewOrganizationsLocationsDlpJobsService(s)
	rs.FileStoreDataProfiles = NewOrganizationsLocationsFileStoreDataProfilesService(s)
	rs.InfoTypes = NewOrganizationsLocationsInfoTypesService(s)
	rs.InspectTemplates = NewOrganizationsLocationsInspectTemplatesService(s)
	rs.JobTriggers = NewOrganizationsLocationsJobTriggersService(s)
	rs.ProjectDataProfiles = NewOrganizationsLocationsProjectDataProfilesService(s)
	rs.StoredInfoTypes = NewOrganizationsLocationsStoredInfoTypesService(s)
	rs.TableDataProfiles = NewOrganizationsLocationsTableDataProfilesService(s)
	return rs
}

type OrganizationsLocationsService struct {
	s *Service

	ColumnDataProfiles *OrganizationsLocationsColumnDataProfilesService

	Connections *OrganizationsLocationsConnectionsService

	DeidentifyTemplates *OrganizationsLocationsDeidentifyTemplatesService

	DiscoveryConfigs *OrganizationsLocationsDiscoveryConfigsService

	DlpJobs *OrganizationsLocationsDlpJobsService

	FileStoreDataProfiles *OrganizationsLocationsFileStoreDataProfilesService

	InfoTypes *OrganizationsLocationsInfoTypesService

	InspectTemplates *OrganizationsLocationsInspectTemplatesService

	JobTriggers *OrganizationsLocationsJobTriggersService

	ProjectDataProfiles *OrganizationsLocationsProjectDataProfilesService

	StoredInfoTypes *OrganizationsLocationsStoredInfoTypesService

	TableDataProfiles *OrganizationsLocationsTableDataProfilesService
}

func NewOrganizationsLocationsColumnDataProfilesService(s *Service) *OrganizationsLocationsColumnDataProfilesService {
	rs := &OrganizationsLocationsColumnDataProfilesService{s: s}
	return rs
}

type OrganizationsLocationsColumnDataProfilesService struct {
	s *Service
}

func NewOrganizationsLocationsConnectionsService(s *Service) *OrganizationsLocationsConnectionsService {
	rs := &OrganizationsLocationsConnectionsService{s: s}
	return rs
}

type OrganizationsLocationsConnectionsService struct {
	s *Service
}

func NewOrganizationsLocationsDeidentifyTemplatesService(s *Service) *OrganizationsLocationsDeidentifyTemplatesService {
	rs := &OrganizationsLocationsDeidentifyTemplatesService{s: s}
	return rs
}

type OrganizationsLocationsDeidentifyTemplatesService struct {
	s *Service
}

func NewOrganizationsLocationsDiscoveryConfigsService(s *Service) *OrganizationsLocationsDiscoveryConfigsService {
	rs := &OrganizationsLocationsDiscoveryConfigsService{s: s}
	return rs
}

type OrganizationsLocationsDiscoveryConfigsService struct {
	s *Service
}

func NewOrganizationsLocationsDlpJobsService(s *Service) *OrganizationsLocationsDlpJobsService {
	rs := &OrganizationsLocationsDlpJobsService{s: s}
	return rs
}

type OrganizationsLocationsDlpJobsService struct {
	s *Service
}

func NewOrganizationsLocationsFileStoreDataProfilesService(s *Service) *OrganizationsLocationsFileStoreDataProfilesService {
	rs := &OrganizationsLocationsFileStoreDataProfilesService{s: s}
	return rs
}

type OrganizationsLocationsFileStoreDataProfilesService struct {
	s *Service
}

func NewOrganizationsLocationsInfoTypesService(s *Service) *OrganizationsLocationsInfoTypesService {
	rs := &OrganizationsLocationsInfoTypesService{s: s}
	return rs
}

type OrganizationsLocationsInfoTypesService struct {
	s *Service
}

func NewOrganizationsLocationsInspectTemplatesService(s *Service) *OrganizationsLocationsInspectTemplatesService {
	rs := &OrganizationsLocationsInspectTemplatesService{s: s}
	return rs
}

type OrganizationsLocationsInspectTemplatesService struct {
	s *Service
}

func NewOrganizationsLocationsJobTriggersService(s *Service) *OrganizationsLocationsJobTriggersService {
	rs := &OrganizationsLocationsJobTriggersService{s: s}
	return rs
}

type OrganizationsLocationsJobTriggersService struct {
	s *Service
}

func NewOrganizationsLocationsProjectDataProfilesService(s *Service) *OrganizationsLocationsProjectDataProfilesService {
	rs := &OrganizationsLocationsProjectDataProfilesService{s: s}
	return rs
}

type OrganizationsLocationsProjectDataProfilesService struct {
	s *Service
}

func NewOrganizationsLocationsStoredInfoTypesService(s *Service) *OrganizationsLocationsStoredInfoTypesService {
	rs := &OrganizationsLocationsStoredInfoTypesService{s: s}
	return rs
}

type OrganizationsLocationsStoredInfoTypesService struct {
	s *Service
}

func NewOrganizationsLocationsTableDataProfilesService(s *Service) *OrganizationsLocationsTableDataProfilesService {
	rs := &OrganizationsLocationsTableDataProfilesService{s: s}
	return rs
}

type OrganizationsLocationsTableDataProfilesService struct {
	s *Service
}

func NewOrganizationsStoredInfoTypesService(s *Service) *OrganizationsStoredInfoTypesService {
	rs := &OrganizationsStoredInfoTypesService{s: s}
	return rs
}

type OrganizationsStoredInfoTypesService struct {
	s *Service
}

func NewProjectsService(s *Service) *ProjectsService {
	rs := &ProjectsService{s: s}
	rs.Content = NewProjectsContentService(s)
	rs.DeidentifyTemplates = NewProjectsDeidentifyTemplatesService(s)
	rs.DlpJobs = NewProjectsDlpJobsService(s)
	rs.Image = NewProjectsImageService(s)
	rs.InspectTemplates = NewProjectsInspectTemplatesService(s)
	rs.JobTriggers = NewProjectsJobTriggersService(s)
	rs.Locations = NewProjectsLocationsService(s)
	rs.StoredInfoTypes = NewProjectsStoredInfoTypesService(s)
	return rs
}

type ProjectsService struct {
	s *Service

	Content *ProjectsContentService

	DeidentifyTemplates *ProjectsDeidentifyTemplatesService

	DlpJobs *ProjectsDlpJobsService

	Image *ProjectsImageService

	InspectTemplates *ProjectsInspectTemplatesService

	JobTriggers *ProjectsJobTriggersService

	Locations *ProjectsLocationsService

	StoredInfoTypes *ProjectsStoredInfoTypesService
}

func NewProjectsContentService(s *Service) *ProjectsContentService {
	rs := &ProjectsContentService{s: s}
	return rs
}

type ProjectsContentService struct {
	s *Service
}

func NewProjectsDeidentifyTemplatesService(s *Service) *ProjectsDeidentifyTemplatesService {
	rs := &ProjectsDeidentifyTemplatesService{s: s}
	return rs
}

type ProjectsDeidentifyTemplatesService struct {
	s *Service
}

func NewProjectsDlpJobsService(s *Service) *ProjectsDlpJobsService {
	rs := &ProjectsDlpJobsService{s: s}
	return rs
}

type ProjectsDlpJobsService struct {
	s *Service
}

func NewProjectsImageService(s *Service) *ProjectsImageService {
	rs := &ProjectsImageService{s: s}
	return rs
}

type ProjectsImageService struct {
	s *Service
}

func NewProjectsInspectTemplatesService(s *Service) *ProjectsInspectTemplatesService {
	rs := &ProjectsInspectTemplatesService{s: s}
	return rs
}

type ProjectsInspectTemplatesService struct {
	s *Service
}

func NewProjectsJobTriggersService(s *Service) *ProjectsJobTriggersService {
	rs := &ProjectsJobTriggersService{s: s}
	return rs
}

type ProjectsJobTriggersService struct {
	s *Service
}

func NewProjectsLocationsService(s *Service) *ProjectsLocationsService {
	rs := &ProjectsLocationsService{s: s}
	rs.ColumnDataProfiles = NewProjectsLocationsColumnDataProfilesService(s)
	rs.Connections = NewProjectsLocationsConnectionsService(s)
	rs.Content = NewProjectsLocationsContentService(s)
	rs.DeidentifyTemplates = NewProjectsLocationsDeidentifyTemplatesService(s)
	rs.DiscoveryConfigs = NewProjectsLocationsDiscoveryConfigsService(s)
	rs.DlpJobs = NewProjectsLocationsDlpJobsService(s)
	rs.FileStoreDataProfiles = NewProjectsLocationsFileStoreDataProfilesService(s)
	rs.Image = NewProjectsLocationsImageService(s)
	rs.InfoTypes = NewProjectsLocationsInfoTypesService(s)
	rs.InspectTemplates = NewProjectsLocationsInspectTemplatesService(s)
	rs.JobTriggers = NewProjectsLocationsJobTriggersService(s)
	rs.ProjectDataProfiles = NewProjectsLocationsProjectDataProfilesService(s)
	rs.StoredInfoTypes = NewProjectsLocationsStoredInfoTypesService(s)
	rs.TableDataProfiles = NewProjectsLocationsTableDataProfilesService(s)
	return rs
}

type ProjectsLocationsService struct {
	s *Service

	ColumnDataProfiles *ProjectsLocationsColumnDataProfilesService

	Connections *ProjectsLocationsConnectionsService

	Content *ProjectsLocationsContentService

	DeidentifyTemplates *ProjectsLocationsDeidentifyTemplatesService

	DiscoveryConfigs *ProjectsLocationsDiscoveryConfigsService

	DlpJobs *ProjectsLocationsDlpJobsService

	FileStoreDataProfiles *ProjectsLocationsFileStoreDataProfilesService

	Image *ProjectsLocationsImageService

	InfoTypes *ProjectsLocationsInfoTypesService

	InspectTemplates *ProjectsLocationsInspectTemplatesService

	JobTriggers *ProjectsLocationsJobTriggersService

	ProjectDataProfiles *ProjectsLocationsProjectDataProfilesService

	StoredInfoTypes *ProjectsLocationsStoredInfoTypesService

	TableDataProfiles *ProjectsLocationsTableDataProfilesService
}

func NewProjectsLocationsColumnDataProfilesService(s *Service) *ProjectsLocationsColumnDataProfilesService {
	rs := &ProjectsLocationsColumnDataProfilesService{s: s}
	return rs
}

type ProjectsLocationsColumnDataProfilesService struct {
	s *Service
}

func NewProjectsLocationsConnectionsService(s *Service) *ProjectsLocationsConnectionsService {
	rs := &ProjectsLocationsConnectionsService{s: s}
	return rs
}

type ProjectsLocationsConnectionsService struct {
	s *Service
}

func NewProjectsLocationsContentService(s *Service) *ProjectsLocationsContentService {
	rs := &ProjectsLocationsContentService{s: s}
	return rs
}

type ProjectsLocationsContentService struct {
	s *Service
}

func NewProjectsLocationsDeidentifyTemplatesService(s *Service) *ProjectsLocationsDeidentifyTemplatesService {
	rs := &ProjectsLocationsDeidentifyTemplatesService{s: s}
	return rs
}

type ProjectsLocationsDeidentifyTemplatesService struct {
	s *Service
}

func NewProjectsLocationsDiscoveryConfigsService(s *Service) *ProjectsLocationsDiscoveryConfigsService {
	rs := &ProjectsLocationsDiscoveryConfigsService{s: s}
	return rs
}

type ProjectsLocationsDiscoveryConfigsService struct {
	s *Service
}

func NewProjectsLocationsDlpJobsService(s *Service) *ProjectsLocationsDlpJobsService {
	rs := &ProjectsLocationsDlpJobsService{s: s}
	return rs
}

type ProjectsLocationsDlpJobsService struct {
	s *Service
}

func NewProjectsLocationsFileStoreDataProfilesService(s *Service) *ProjectsLocationsFileStoreDataProfilesService {
	rs := &ProjectsLocationsFileStoreDataProfilesService{s: s}
	return rs
}

type ProjectsLocationsFileStoreDataProfilesService struct {
	s *Service
}

func NewProjectsLocationsImageService(s *Service) *ProjectsLocationsImageService {
	rs := &ProjectsLocationsImageService{s: s}
	return rs
}

type ProjectsLocationsImageService struct {
	s *Service
}

func NewProjectsLocationsInfoTypesService(s *Service) *ProjectsLocationsInfoTypesService {
	rs := &ProjectsLocationsInfoTypesService{s: s}
	return rs
}

type ProjectsLocationsInfoTypesService struct {
	s *Service
}

func NewProjectsLocationsInspectTemplatesService(s *Service) *ProjectsLocationsInspectTemplatesService {
	rs := &ProjectsLocationsInspectTemplatesService{s: s}
	return rs
}

type ProjectsLocationsInspectTemplatesService struct {
	s *Service
}

func NewProjectsLocationsJobTriggersService(s *Service) *ProjectsLocationsJobTriggersService {
	rs := &ProjectsLocationsJobTriggersService{s: s}
	return rs
}

type ProjectsLocationsJobTriggersService struct {
	s *Service
}

func NewProjectsLocationsProjectDataProfilesService(s *Service) *ProjectsLocationsProjectDataProfilesService {
	rs := &ProjectsLocationsProjectDataProfilesService{s: s}
	return rs
}

type ProjectsLocationsProjectDataProfilesService struct {
	s *Service
}

func NewProjectsLocationsStoredInfoTypesService(s *Service) *ProjectsLocationsStoredInfoTypesService {
	rs := &ProjectsLocationsStoredInfoTypesService{s: s}
	return rs
}

type ProjectsLocationsStoredInfoTypesService struct {
	s *Service
}

func NewProjectsLocationsTableDataProfilesService(s *Service) *ProjectsLocationsTableDataProfilesService {
	rs := &ProjectsLocationsTableDataProfilesService{s: s}
	return rs
}

type ProjectsLocationsTableDataProfilesService struct {
	s *Service
}

func NewProjectsStoredInfoTypesService(s *Service) *ProjectsStoredInfoTypesService {
	rs := &ProjectsStoredInfoTypesService{s: s}
	return rs
}

type ProjectsStoredInfoTypesService struct {
	s *Service
}

// GooglePrivacyDlpV2Action: A task to execute on the completion of a job. See
// https://cloud.google.com/sensitive-data-protection/docs/concepts-actions to
// learn more.
type GooglePrivacyDlpV2Action struct {
	// Deidentify: Create a de-identified copy of the input data.
	Deidentify *GooglePrivacyDlpV2Deidentify `json:"deidentify,omitempty"`
	// JobNotificationEmails: Sends an email when the job completes. The email goes
	// to IAM project owners and technical Essential Contacts
	// (https://cloud.google.com/resource-manager/docs/managing-notification-contacts).
	JobNotificationEmails *GooglePrivacyDlpV2JobNotificationEmails `json:"jobNotificationEmails,omitempty"`
	// PubSub: Publish a notification to a Pub/Sub topic.
	PubSub *GooglePrivacyDlpV2PublishToPubSub `json:"pubSub,omitempty"`
	// PublishFindingsToCloudDataCatalog: Deprecated because Data Catalog is being
	// turned down. Use publish_findings_to_dataplex_catalog to publish findings to
	// Dataplex Universal Catalog.
	PublishFindingsToCloudDataCatalog *GooglePrivacyDlpV2PublishFindingsToCloudDataCatalog `json:"publishFindingsToCloudDataCatalog,omitempty"`
	// PublishFindingsToDataplexCatalog: Publish findings as an aspect to Dataplex
	// Universal Catalog.
	PublishFindingsToDataplexCatalog *GooglePrivacyDlpV2PublishFindingsToDataplexCatalog `json:"publishFindingsToDataplexCatalog,omitempty"`
	// PublishSummaryToCscc: Publish summary to Cloud Security Command Center
	// (Alpha).
	PublishSummaryToCscc *GooglePrivacyDlpV2PublishSummaryToCscc `json:"publishSummaryToCscc,omitempty"`
	// PublishToStackdriver: Enable Stackdriver metric
	// dlp.googleapis.com/finding_count.
	PublishToStackdriver *GooglePrivacyDlpV2PublishToStackdriver `json:"publishToStackdriver,omitempty"`
	// SaveFindings: Save resulting findings in a provided location.
	SaveFindings *GooglePrivacyDlpV2SaveFindings `json:"saveFindings,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Deidentify") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Deidentify") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GooglePrivacyDlpV2Action) MarshalJSON() ([]byte, error) {
	type NoMethod GooglePrivacyDlpV2Action
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GooglePrivacyDlpV2ActionDetails: The results of an Action.
type GooglePrivacyDlpV2ActionDetails struct {
	// DeidentifyDetails: Outcome of a de-identification action.
	DeidentifyDetails *GooglePrivacyDlpV2DeidentifyDataSourceDetails `json:"deidentifyDetails,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DeidentifyDetails") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DeidentifyDetails") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GooglePrivacyDlpV2ActionDetails) MarshalJSON() ([]byte, error) {
	type NoMethod GooglePrivacyDlpV2ActionDetails
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GooglePrivacyDlpV2ActivateJobTriggerRequest: Request message for
// ActivateJobTrigger.
type GooglePrivacyDlpV2ActivateJobTriggerRequest struct {
}

// GooglePrivacyDlpV2AdjustByImageFindings: AdjustmentRule condition for image
// findings. This rule is silently ignored if the content being inspected is
// not an image.
type GooglePrivacyDlpV2AdjustByImageFindings struct {
	// ImageContainmentType: Specifies the required spatial relationship between
	// the bounding boxes of the target finding and the context infoType findings.
	ImageContainmentType *GooglePrivacyDlpV2ImageContainmentType `json:"imageContainmentType,omitempty"`
	// InfoTypes: A list of image-supported infoTypes—excluding document
	// infoTypes
	// (https://cloud.google.com/sensitive-data-protection/docs/infotypes-reference#documents)—to
	// be used as context for the adjustment rule. Sensitive Data Protection
	// adjusts the likelihood of an image finding if its bounding box has the
	// specified spatial relationship (defined by `image_containment_type`) with a
	// finding of an infoType in this list. For example, you can create a rule to
	// adjust the likelihood of a `US_PASSPORT` finding if it is enclosed by a
	// finding of `OBJECT_TYPE/PERSON/PASSPORT`. To configure this, set
	// `US_PASSPORT` in `InspectionRuleSet.info_types`. Add an `adjustment_rule`
	// with an `adjust_by_image_findings.info_types` that contains
	// `OBJECT_TYPE/PERSON/PASSPORT` and `image_containment_type` set to
	// `encloses`. In this case, the likelihood of the `US_PASSPORT` finding is
	// adjusted, but the likelihood of the `OBJECT_TYPE/PERSON/PASSPORT` finding is
	// not.
	InfoTypes []*GooglePrivacyDlpV2InfoType `json:"infoTypes,omitempty"`
	// MinLikelihood: Required. Minimum likelihood of the
	// `adjust_by_image_findings.info_types` finding. If the likelihood is lower
	// than this value, Sensitive Data Protection doesn't adjust the likelihood of
	// the `InspectionRuleSet.info_types` finding.
	//
	// Possible values:
	//   "LIKELIHOOD_UNSPECIFIED" - Default value; same as POSSIBLE.
	//   "VERY_UNLIKELY" - Highest chance of a false positive.
	//   "UNLIKELY" - High chance of a false positive.
	//   "POSSIBLE" - Some matching signals. The default value.
	//   "LIKELY" - Low chance of a false positive.
	//   "VERY_LIKELY" - Confidence level is high. Lowest chance of a false
	// positive.
	MinLikelihood string `json:"minLikelihood,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ImageContainmentType") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ImageContainmentType") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GooglePrivacyDlpV2AdjustByImageFindings) MarshalJSON() ([]byte, error) {
	type NoMethod GooglePrivacyDlpV2AdjustByImageFindings
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GooglePrivacyDlpV2AdjustByMatchingInfoTypes: AdjustmentRule condition for
// matching infoTypes.
type GooglePrivacyDlpV2AdjustByMatchingInfoTypes struct {
	// InfoTypes: Sensitive Data Protection adjusts the likelihood of a finding if
	// that finding also matches one of these infoTypes. For example, you can
	// create a rule to adjust the likelihood of a `PHONE_NUMBER` finding if the
	// string is found within a document that is classified as
	// `DOCUMENT_TYPE/HR/RESUME`. To configure this, set `PHONE_NUMBER` in
	// `InspectionRuleSet.info_types`. Add an `adjustment_rule` with an
	// `adjust_by_matching_info_types.info_types` that contains
	// `DOCUMENT_TYPE/HR/RESUME`. In this case, the likelihood of the
	// `PHONE_NUMBER` finding is adjusted, but the likelihood of the
	// `DOCUMENT_TYPE/HR/RESUME` finding is not.
	InfoTypes []*GooglePrivacyDlpV2InfoType `json:"infoTypes,omitempty"`
	// MatchingType: How the adjustment rule is applied. Only
	// MATCHING_TYPE_PARTIAL_MATCH is supported: - Partial match: adjusts the
	// findings of infoTypes specified in the inspection rule when they have a
	// nonempty intersection with a finding of an infoType specified in this
	// adjustment rule.
	//
	// Possible values:
	//   "MATCHING_TYPE_UNSPECIFIED" - Invalid.
	//   "MATCHING_TYPE_FULL_MATCH" - Full match. - Dictionary: join of Dictionary
	// results matched the complete finding quote - Regex: all regex matches fill a
	// finding quote from start to end - Exclude infoType: completely inside
	// affecting infoTypes findings
	//   "MATCHING_TYPE_PARTIAL_MATCH" - Partial match. - Dictionary: at least one
	// of the tokens in the finding matches - Regex: substring of the finding
	// matches - Exclude infoType: intersects with affecting infoTypes findings
	//   "MATCHING_TYPE_INVERSE_MATCH" - Inverse match. - Dictionary: no tokens in
	// the finding match the dictionary - Regex: finding doesn't match the regex -
	// Exclude infoType: no intersection with affecting infoTypes findings
	//   "MATCHING_TYPE_RULE_SPECIFIC" - Rule-specific match. The matching logic is
	// based on the specific rule being used. This is required for rules where the
	// matching behavior is not a simple string comparison (e.g., image
	// containment). This matching type can only be used with the
	// `ExcludeByImageFindings` rule. - Exclude by image findings: The matching
	// logic is defined within `ExcludeByImageFindings` based on spatial
	// relationships between bounding boxes.
	MatchingType string `json:"matchingType,omitempty"`
	// MinLikelihood: Required. Minimum likelihood of the
	// `adjust_by_matching_info_types.info_types` finding. If the likelihood is
	// lower than this value, Sensitive Data Protection doesn't adjust the
	// likelihood of the `InspectionRuleSet.info_types` finding.
	//
	// Possible values:
	//   "LIKELIHOOD_UNSPECIFIED" - Default value; same as POSSIBLE.
	//   "VERY_UNLIKELY" - Highest chance of a false positive.
	//   "UNLIKELY" - High chance of a false positive.
	//   "POSSIBLE" - Some matching signals. The default value.
	//   "LIKELY" - Low chance of a false positive.
	//   "VERY_LIKELY" - Confidence level is high. Lowest chance of a false
	// positive.
	MinLikelihood string `json:"minLikelihood,omitempty"`
	// ForceSendFields is a list of field names (e.g. "InfoTypes") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "InfoTypes") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GooglePrivacyDlpV2AdjustByMatchingInfoTypes) MarshalJSON() ([]byte, error) {
	type NoMethod GooglePrivacyDlpV2AdjustByMatchingInfoTypes
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GooglePrivacyDlpV2AdjustmentRule: Rule that specifies conditions when a
// certain infoType's finding details should be adjusted.
type GooglePrivacyDlpV2AdjustmentRule struct {
	// AdjustByImageFindings: AdjustmentRule condition for image findings.
	AdjustByImageFindings *GooglePrivacyDlpV2AdjustByImageFindings `json:"adjustByImageFindings,omitempty"`
	// AdjustByMatchingInfoTypes: Set of infoTypes for which findings would affect
	// this rule.
	AdjustByMatchingInfoTypes *GooglePrivacyDlpV2AdjustByMatchingInfoTypes `json:"adjustByMatchingInfoTypes,omitempty"`
	// LikelihoodAdjustment: Likelihood adjustment to apply to the infoType.
	LikelihoodAdjustment *GooglePrivacyDlpV2LikelihoodAdjustment `json:"likelihoodAdjustment,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AdjustByImageFindings") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AdjustByImageFindings") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GooglePrivacyDlpV2AdjustmentRule) MarshalJSON() ([]byte, error) {
	type NoMethod GooglePrivacyDlpV2AdjustmentRule
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GooglePrivacyDlpV2AllInfoTypes: Apply transformation to all findings.
type GooglePrivacyDlpV2AllInfoTypes struct {
}

// GooglePrivacyDlpV2AllOtherBigQueryTables: Catch-all for all other tables not
// specified by other filters. Should always be last, except for single-table
// configurations, which will only have a TableReference target.
type GooglePrivacyDlpV2AllOtherBigQueryTables struct {
}

// GooglePrivacyDlpV2AllOtherDatabaseResources: Match database resources not
// covered by any other filter.
type GooglePrivacyDlpV2AllOtherDatabaseResources struct {
}

// GooglePrivacyDlpV2AllOtherResources: Match discovery resources not covered
// by any other filter.
type GooglePrivacyDlpV2AllOtherResources struct {
}

// GooglePrivacyDlpV2AllText: Apply to all text.
type GooglePrivacyDlpV2AllText struct {
}

// GooglePrivacyDlpV2AmazonS3Bucket: Amazon S3 bucket.
type GooglePrivacyDlpV2AmazonS3Bucket struct {
	// AwsAccount: The AWS account.
	AwsAccount *GooglePrivacyDlpV2AwsAccount `json:"awsAccount,omitempty"`
	// BucketName: Required. The bucket name.
	BucketName string `json:"bucketName,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AwsAccount") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AwsAccount") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GooglePrivacyDlpV2AmazonS3Bucket) MarshalJSON() ([]byte, error) {
	type NoMethod GooglePrivacyDlpV2AmazonS3Bucket
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GooglePrivacyDlpV2AmazonS3BucketConditions: Amazon S3 bucket conditions.
type GooglePrivacyDlpV2AmazonS3BucketConditions struct {
	// BucketTypes: Optional. Bucket types that should be profiled. Optional.
	// Defaults to TYPE_ALL_SUPPORTED if unspecified.
	//
	// Possible values:
	//   "TYPE_UNSPECIFIED" - Unused.
	//   "TYPE_ALL_SUPPORTED" - All supported classes.
	//   "TYPE_GENERAL_PURPOSE" - A general purpose Amazon S3 bucket.
	BucketTypes []string `json:"bucketTypes,omitempty"`
	// ObjectStorageClasses: Optional. Object classes that should be profiled.
	// Optional. Defaults to ALL_SUPPORTED_CLASSES if unspecified.
	//
	// Possible values:
	//   "UNSPECIFIED" - Unused.
	//   "ALL_SUPPORTED_CLASSES" - All supported classes.
	//   "STANDARD" - Standard object class.
	//   "STANDARD_INFREQUENT_ACCESS" - Standard - infrequent access object class.
	//   "GLACIER_INSTANT_RETRIEVAL" - Glacier - instant retrieval object class.
	//   "INTELLIGENT_TIERING" - Objects in the S3 Intelligent-Tiering access
	// tiers.
	ObjectStorageClasses []string `json:"objectStorageClasses,omitempty"`
	// ForceSendFields is a list of field names (e.g. "BucketTypes") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "BucketTypes") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GooglePrivacyDlpV2AmazonS3BucketConditions) MarshalJSON() ([]byte, error) {
	type NoMethod GooglePrivacyDlpV2AmazonS3BucketConditions
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GooglePrivacyDlpV2AmazonS3BucketRegex: Amazon S3 bucket regex.
type GooglePrivacyDlpV2AmazonS3BucketRegex struct {
	// AwsAccountRegex: The AWS account regex.
	AwsAccountRegex *GooglePrivacyDlpV2AwsAccountRegex `json:"awsAccountRegex,omitempty"`
	// BucketNameRegex: Optional. Regex to test the bucket name against. If empty,
	// all buckets match.
	BucketNameRegex string `json:"bucketNameRegex,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AwsAccountRegex") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AwsAccountRegex") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GooglePrivacyDlpV2AmazonS3BucketRegex) MarshalJSON() ([]byte, error) {
	type NoMethod GooglePrivacyDlpV2AmazonS3BucketRegex
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GooglePrivacyDlpV2AnalyzeDataSourceRiskDetails: Result of a risk analysis
// operation request.
type GooglePrivacyDlpV2AnalyzeDataSourceRiskDetails struct {
	// CategoricalStatsResult: Categorical stats result
	CategoricalStatsResult *GooglePrivacyDlpV2CategoricalStatsResult `json:"categoricalStatsResult,omitempty"`
	// DeltaPresenceEstimationResult: Delta-presence result
	DeltaPresenceEstimationResult *GooglePrivacyDlpV2DeltaPresenceEstimationResult `json:"deltaPresenceEstimationResult,omitempty"`
	// KAnonymityResult: K-anonymity result
	KAnonymityResult *GooglePrivacyDlpV2KAnonymityResult `json:"kAnonymityResult,omitempty"`
	// KMapEstimationResult: K-map result
	KMapEstimationResult *GooglePrivacyDlpV2KMapEstimationResult `json:"kMapEstimationResult,omitempty"`
	// LDiversityResult: L-divesity result
	LDiversityResult *GooglePrivacyDlpV2LDiversityResult `json:"lDiversityResult,omitempty"`
	// NumericalStatsResult: Numerical stats result
	NumericalStatsResult *GooglePrivacyDlpV2NumericalStatsResult `json:"numericalStatsResult,omitempty"`
	// RequestedOptions: The configuration used for this job.
	RequestedOptions *GooglePrivacyDlpV2RequestedRiskAnalysisOptions `json:"requestedOptions,omitempty"`
	// RequestedPrivacyMetric: Privacy metric to compute.
	RequestedPrivacyMetric *GooglePrivacyDlpV2PrivacyMetric `json:"requestedPrivacyMetric,omitempty"`
	// RequestedSourceTable: Input dataset to compute metrics over.
	RequestedSourceTable *GooglePrivacyDlpV2BigQueryTable `json:"requestedSourceTable,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CategoricalStatsResult") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CategoricalStatsResult") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GooglePrivacyDlpV2AnalyzeDataSourceRiskDetails) MarshalJSON() ([]byte, error) {
	type NoMethod GooglePrivacyDlpV2AnalyzeDataSourceRiskDetails
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GooglePrivacyDlpV2AuxiliaryTable: An auxiliary table contains statistical
// information on the relative frequency of different quasi-identifiers values.
// It has one or several quasi-identifiers columns, and one column that
// indicates the relative frequency of each quasi-identifier tuple. If a tuple
// is present in the data but not in the auxiliary table, the corresponding
// relative frequency is assumed to be zero (and thus, the tuple is highly
// reidentifiable).
type GooglePrivacyDlpV2AuxiliaryTable struct {
	// QuasiIds: Required. Quasi-identifier columns.
	QuasiIds []*GooglePrivacyDlpV2QuasiIdField `json:"quasiIds,omitempty"`
	// RelativeFrequency: Required. The relative frequency column must contain a
	// floating-point number between 0 and 1 (inclusive). Null values are assumed
	// to be zero.
	RelativeFrequency *GooglePrivacyDlpV2FieldId `json:"relativeFrequency,omitempty"`
	// Table: Required. Auxiliary table location.
	Table *GooglePrivacyDlpV2BigQueryTable `json:"table,omitempty"`
	// ForceSendFields is a list of field names (e.g. "QuasiIds") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "QuasiIds") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GooglePrivacyDlpV2AuxiliaryTable) MarshalJSON() ([]byte, error) {
	type NoMethod GooglePrivacyDlpV2AuxiliaryTable
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GooglePrivacyDlpV2AwsAccount: AWS account.
type GooglePrivacyDlpV2AwsAccount struct {
	// AccountId: Required. AWS account ID.
	AccountId string `json:"accountId,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AccountId") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AccountId") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GooglePrivacyDlpV2AwsAccount) MarshalJSON() ([]byte, error) {
	type NoMethod GooglePrivacyDlpV2AwsAccount
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GooglePrivacyDlpV2AwsAccountRegex: AWS account regex.
type GooglePrivacyDlpV2AwsAccountRegex struct {
	// AccountIdRegex: Optional. Regex to test the AWS account ID against. If
	// empty, all accounts match.
	AccountIdRegex string `json:"accountIdRegex,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AccountIdRegex") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AccountIdRegex") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GooglePrivacyDlpV2AwsAccountRegex) MarshalJSON() ([]byte, error) {
	type NoMethod GooglePrivacyDlpV2AwsAccountRegex
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GooglePrivacyDlpV2AwsDiscoveryStartingLocation: The AWS starting location
// for discovery.
type GooglePrivacyDlpV2AwsDiscoveryStartingLocation struct {
	// AccountId: The AWS account ID that this discovery config applies to. Within
	// an AWS organization, you can find the AWS account ID inside an AWS account
	// ARN. Example:
	// arn:{partition}:organizations::{management_account_id}:account/{org_id}/{acco
	// unt_id}
	AccountId string `json:"accountId,omitempty"`
	// AllAssetInventoryAssets: All AWS assets stored in Asset Inventory that
	// didn't match other AWS discovery configs.
	AllAssetInventoryAssets bool `json:"allAssetInventoryAssets,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AccountId") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AccountId") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GooglePrivacyDlpV2AwsDiscoveryStartingLocation) MarshalJSON() ([]byte, error) {
	type NoMethod GooglePrivacyDlpV2AwsDiscoveryStartingLocation
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GooglePrivacyDlpV2BigQueryDiscoveryTarget: Target used to match against for
// discovery with BigQuery tables
type GooglePrivacyDlpV2BigQueryDiscoveryTarget struct {
	// Cadence: How often and when to update profiles. New tables that match both
	// the filter and conditions are scanned as quickly as possible depending on
	// system capacity.
	Cadence *GooglePrivacyDlpV2DiscoveryGenerationCadence `json:"cadence,omitempty"`
	// Conditions: In addition to matching the filter, these conditions must be
	// true before a profile is generated.
	Conditions *GooglePrivacyDlpV2DiscoveryBigQueryConditions `json:"conditions,omitempty"`
	// Disabled: Tables that match this filter will not have profiles created.
	Disabled *GooglePrivacyDlpV2Disabled `json:"disabled,omitempty"`
	// Filter: Required. The tables the discovery cadence applies to. The first
	// target with a matching filter will be the one to apply to a table.
	Filter *GooglePrivacyDlpV2DiscoveryBigQueryFilter `json:"filter,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Cadence") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Cadence") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GooglePrivacyDlpV2BigQueryDiscoveryTarget) MarshalJSON() ([]byte, error) {
	type NoMethod GooglePrivacyDlpV2BigQueryDiscoveryTarget
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GooglePrivacyDlpV2BigQueryField: Message defining a field of a BigQuery
// table.
type GooglePrivacyDlpV2BigQueryField struct {
	// Field: Designated field in the BigQuery table.
	Field *GooglePrivacyDlpV2FieldId `json:"field,omitempty"`
	// Table: Source table of the field.
	Table *GooglePrivacyDlpV2BigQueryTable `json:"table,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Field") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Field") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GooglePrivacyDlpV2BigQueryField) MarshalJSON() ([]byte, error) {
	type NoMethod GooglePrivacyDlpV2BigQueryField
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GooglePrivacyDlpV2BigQueryKey: Row key for identifying a record in BigQuery
// table.
type GooglePrivacyDlpV2BigQueryKey struct {
	// RowNumber: Row number inferred at the time the table was scanned. This value
	// is nondeterministic, cannot be queried, and may be null for inspection jobs.
	// To locate findings within a table, specify
	// `inspect_job.storage_config.big_query_options.identifying_fields` in
	// `CreateDlpJobRequest`.
	RowNumber int64 `json:"rowNumber,omitempty,string"`
	// TableReference: Complete BigQuery table reference.
	TableReference *GooglePrivacyDlpV2BigQueryTable `json:"tableReference,omitempty"`
	// ForceSendFields is a list of field names (e.g. "RowNumber") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "RowNumber") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GooglePrivacyDlpV2BigQueryKey) MarshalJSON() ([]byte, error) {
	type NoMethod GooglePrivacyDlpV2BigQueryKey
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GooglePrivacyDlpV2BigQueryOptions: Options defining BigQuery table and row
// identifiers.
type GooglePrivacyDlpV2BigQueryOptions struct {
	// ExcludedFields: References to fields excluded from scanning. This allows you
	// to skip inspection of entire columns which you know have no findings. When
	// inspecting a table, we recommend that you inspect all columns. Otherwise,
	// findings might be affected because hints from excluded columns will not be
	// used.
	ExcludedFields []*GooglePrivacyDlpV2FieldId `json:"excludedFields,omitempty"`
	// IdentifyingFields: Table fields that may uniquely identify a row within the
	// table. When `actions.saveFindings.outputConfig.table` is specified, the
	// values of columns specified here are available in the output table under
	// `location.content_locations.record_location.record_key.id_values`. Nested
	// fields such as `person.birthdate.year` are allowed.
	IdentifyingFields []*GooglePrivacyDlpV2FieldId `json:"identifyingFields,omitempty"`
	// IncludedFields: Limit scanning only to these fields. When inspecting a
	// table, we recommend that you inspect all columns. Otherwise, findings might
	// be affected because hints from excluded columns will not be used.
	IncludedFields []*GooglePrivacyDlpV2FieldId `json:"includedFields,omitempty"`
	// RowsLimit: Max number of rows to scan. If the table has more rows than this
	// value, the rest of the rows are omitted. If not set, or if set to 0, all
	// rows will be scanned. Only one of rows_limit and rows_limit_percent can be
	// specified. Cannot be used in conjunction with TimespanConfig.
	RowsLimit int64 `json:"rowsLimit,omitempty,string"`
	// RowsLimitPercent: Max percentage of rows to scan. The rest are omitted. The
	// number of rows scanned is rounded down. Must be between 0 and 100,
	// inclusively. Both 0 and 100 means no limit. Defaults to 0. Only one of
	// rows_limit and rows_limit_percent can be specified. Cannot be used in
	// conjunction with TimespanConfig. Caution: A known issue
	// (https://cloud.google.com/sensitive-data-protection/docs/known-issues#bq-sampling)
	// is causing the `rowsLimitPercent` field to behave unexpectedly. We recommend
	// using `rowsLimit` instead.
	RowsLimitPercent int64 `json:"rowsLimitPercent,omitempty"`
	// SampleMethod: How to sample the data.
	//
	// Possible values:
	//   "SAMPLE_METHOD_UNSPECIFIED" - No sampling.
	//   "TOP" - Scan groups of rows in the order BigQuery provides (default).
	// Multiple groups of rows may be scanned in parallel, so results may not
	// appear in the same order the rows are read.
	//   "RANDOM_START" - Randomly pick groups of rows to scan.
	SampleMethod string `json:"sampleMethod,omitempty"`
	// TableReference: Complete BigQuery table reference.
	TableReference *GooglePrivacyDlpV2BigQueryTable `json:"tableReference,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ExcludedFields") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ExcludedFields") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GooglePrivacyDlpV2BigQueryOptions) MarshalJSON() ([]byte, error) {
	type NoMethod GooglePrivacyDlpV2BigQueryOptions
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GooglePrivacyDlpV2BigQueryRegex: A pattern to match against one or more
// tables, datasets, or projects that contain BigQuery tables. At least one
// pattern must be specified. Regular expressions use RE2 syntax
// (https://github.com/google/re2/wiki/Syntax); a guide can be found under the
// google/re2 repository on GitHub.
type GooglePrivacyDlpV2BigQueryRegex struct {
	// DatasetIdRegex: If unset, this property matches all datasets.
	DatasetIdRegex string `json:"datasetIdRegex,omitempty"`
	// ProjectIdRegex: For organizations, if unset, will match all projects. Has no
	// effect for data profile configurations created within a project.
	ProjectIdRegex string `json:"projectIdRegex,omitempty"`
	// TableIdRegex: If unset, this property matches all tables.
	TableIdRegex string `json:"tableIdRegex,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DatasetIdRegex") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DatasetIdRegex") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GooglePrivacyDlpV2BigQueryRegex) MarshalJSON() ([]byte, error) {
	type NoMethod GooglePrivacyDlpV2BigQueryRegex
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GooglePrivacyDlpV2BigQueryRegexes: A collection of regular expressions to
// determine what tables to match against.
type GooglePrivacyDlpV2BigQueryRegexes struct {
	// Patterns: A single BigQuery regular expression pattern to match against one
	// or more tables, datasets, or projects that contain BigQuery tables.
	Patterns []*GooglePrivacyDlpV2BigQueryRegex `json:"patterns,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Patterns") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Patterns") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GooglePrivacyDlpV2BigQueryRegexes) MarshalJSON() ([]byte, error) {
	type NoMethod GooglePrivacyDlpV2BigQueryRegexes
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GooglePrivacyDlpV2BigQueryTable: Message defining the location of a BigQuery
// table. A table is uniquely identified by its project_id, dataset_id, and
// table_name. Within a query a table is often referenced with a string in the
// format of: `:.` or `..`.
type GooglePrivacyDlpV2BigQueryTable struct {
	// DatasetId: Dataset ID of the table.
	DatasetId string `json:"datasetId,omitempty"`
	// ProjectId: The Google Cloud project ID of the project containing the table.
	// If omitted, project ID is inferred from the API call.
	ProjectId string `json:"projectId,omitempty"`
	// TableId: Name of the table.
	TableId string `json:"tableId,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DatasetId") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DatasetId") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GooglePrivacyDlpV2BigQueryTable) MarshalJSON() ([]byte, error) {
	type NoMethod GooglePrivacyDlpV2BigQueryTable
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GooglePrivacyDlpV2BigQueryTableCollection: Specifies a collection of
// BigQuery tables. Used for Discovery.
type GooglePrivacyDlpV2BigQueryTableCollection struct {
	// IncludeRegexes: A collection of regular expressions to match a BigQuery
	// table against.
	IncludeRegexes *GooglePrivacyDlpV2BigQueryRegexes `json:"includeRegexes,omitempty"`
	// ForceSendFields is a list of field names (e.g. "IncludeRegexes") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "IncludeRegexes") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GooglePrivacyDlpV2BigQueryTableCollection) MarshalJSON() ([]byte, error) {
	type NoMethod GooglePrivacyDlpV2BigQueryTableCollection
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GooglePrivacyDlpV2BigQueryTableTypes: The types of BigQuery tables supported
// by Cloud DLP.
type GooglePrivacyDlpV2BigQueryTableTypes struct {
	// Types: A set of BigQuery table types.
	//
	// Possible values:
	//   "BIG_QUERY_TABLE_TYPE_UNSPECIFIED" - Unused.
	//   "BIG_QUERY_TABLE_TYPE_TABLE" - A normal BigQuery table.
	//   "BIG_QUERY_TABLE_TYPE_EXTERNAL_BIG_LAKE" - A table that references data
	// stored in Cloud Storage.
	//   "BIG_QUERY_TABLE_TYPE_SNAPSHOT" - A snapshot of a BigQuery table.
	Types []string `json:"types,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Types") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Types") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GooglePrivacyDlpV2BigQueryTableTypes) MarshalJSON() ([]byte, error) {
	type NoMethod GooglePrivacyDlpV2BigQueryTableTypes
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GooglePrivacyDlpV2BoundingBox: Bounding box encompassing detected text
// within an image.
type GooglePrivacyDlpV2BoundingBox struct {
	// Height: Height of the bounding box in pixels.
	Height int64 `json:"height,omitempty"`
	// Left: Left coordinate of the bounding box. (0,0) is upper left.
	Left int64 `json:"left,omitempty"`
	// Top: Top coordinate of the bounding box. (0,0) is upper left.
	Top int64 `json:"top,omitempty"`
	// Width: Width of the bounding box in pixels.
	Width int64 `json:"width,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Height") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Height") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GooglePrivacyDlpV2BoundingBox) MarshalJSON() ([]byte, error) {
	type NoMethod GooglePrivacyDlpV2BoundingBox
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GooglePrivacyDlpV2Bucket: Bucket is represented as a range, along with
// replacement values.
type GooglePrivacyDlpV2Bucket struct {
	// Max: Upper bound of the range, exclusive; type must match min.
	Max *GooglePrivacyDlpV2Value `json:"max,omitempty"`
	// Min: Lower bound of the range, inclusive. Type should be the same as max if
	// used.
	Min *GooglePrivacyDlpV2Value `json:"min,omitempty"`
	// ReplacementValue: Required. Replacement value for this bucket.
	ReplacementValue *GooglePrivacyDlpV2Value `json:"replacementValue,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Max") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Max") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GooglePrivacyDlpV2Bucket) MarshalJSON() ([]byte, error) {
	type NoMethod GooglePrivacyDlpV2Bucket
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GooglePrivacyDlpV2BucketingConfig: Generalization function that buckets
// values based on ranges. The ranges and replacement values are dynamically
// provided by the user for custom behavior, such as 1-30 -> LOW, 31-65 ->
// MEDIUM, 66-100 -> HIGH. This can be used on data of type: number, long,
// string, timestamp. If the bound `Value` type differs from the type of data
// being transformed, we will first attempt converting the type of the data to
// be transformed to match the type of the bound before comparing. See
// https://cloud.google.com/sensitive-data-protection/docs/concepts-bucketing
// to learn more.
type GooglePrivacyDlpV2BucketingConfig struct {
	// Buckets: Set of buckets. Ranges must be non-overlapping.
	Buckets []*GooglePrivacyDlpV2Bucket `json:"buckets,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Buckets") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Buckets") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GooglePrivacyDlpV2BucketingConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GooglePrivacyDlpV2BucketingConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GooglePrivacyDlpV2ByteContentItem: Container for bytes to inspect or redact.
type GooglePrivacyDlpV2ByteContentItem struct {
	// Data: Content data to inspect or redact.
	Data string `json:"data,omitempty"`
	// Type: The type of data stored in the bytes string. Default will be
	// TEXT_UTF8.
	//
	// Possible values:
	//   "BYTES_TYPE_UNSPECIFIED" - Unused
	//   "IMAGE" - Any image type.
	//   "IMAGE_JPEG" - jpeg
	//   "IMAGE_BMP" - bmp
	//   "IMAGE_PNG" - png
	//   "IMAGE_SVG" - svg
	//   "TEXT_UTF8" - plain text
	//   "WORD_DOCUMENT" - docx, docm, dotx, dotm
	//   "PDF" - pdf
	//   "POWERPOINT_DOCUMENT" - pptx, pptm, potx, potm, pot
	//   "EXCEL_DOCUMENT" - xlsx, xlsm, xltx, xltm
	//   "AVRO" - avro
	//   "CSV" - csv
	//   "TSV" - tsv
	//   "AUDIO" - Audio file types. Only used for profiling.
	//   "VIDEO" - Video file types. Only used for profiling.
	//   "EXECUTABLE" - Executable file types. Only used for profiling.
	//   "AI_MODEL" - AI model file types. Only used for profiling.
	Type string `json:"type,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Data") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Data") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GooglePrivacyDlpV2ByteContentItem) MarshalJSON() ([]byte, error) {
	type NoMethod GooglePrivacyDlpV2ByteContentItem
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GooglePrivacyDlpV2CancelDlpJobRequest: The request message for canceling a
// DLP job.
type GooglePrivacyDlpV2CancelDlpJobRequest struct {
}

// GooglePrivacyDlpV2CategoricalStatsConfig: Compute numerical stats over an
// individual column, including number of distinct values and value count
// distribution.
type GooglePrivacyDlpV2CategoricalStatsConfig struct {
	// Field: Field to compute categorical stats on. All column types are supported
	// except for arrays and structs. However, it may be more informative to use
	// NumericalStats when the field type is supported, depending on the data.
	Field *GooglePrivacyDlpV2FieldId `json:"field,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Field") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Field") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GooglePrivacyDlpV2CategoricalStatsConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GooglePrivacyDlpV2CategoricalStatsConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GooglePrivacyDlpV2CategoricalStatsHistogramBucket: Histogram of value
// frequencies in the column.
type GooglePrivacyDlpV2CategoricalStatsHistogramBucket struct {
	// BucketSize: Total number of values in this bucket.
	BucketSize int64 `json:"bucketSize,omitempty,string"`
	// BucketValueCount: Total number of distinct values in this bucket.
	BucketValueCount int64 `json:"bucketValueCount,omitempty,string"`
	// BucketValues: Sample of value frequencies in this bucket. The total number
	// of values returned per bucket is capped at 20.
	BucketValues []*GooglePrivacyDlpV2ValueFrequency `json:"bucketValues,omitempty"`
	// ValueFrequencyLowerBound: Lower bound on the value frequency of the values
	// in this bucket.
	ValueFrequencyLowerBound int64 `json:"valueFrequencyLowerBound,omitempty,string"`
	// ValueFrequencyUpperBound: Upper bound on the value frequency of the values
	// in this bucket.
	ValueFrequencyUpperBound int64 `json:"valueFrequencyUpperBound,omitempty,string"`
	// ForceSendFields is a list of field names (e.g. "BucketSize") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "BucketSize") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GooglePrivacyDlpV2CategoricalStatsHistogramBucket) MarshalJSON() ([]byte, error) {
	type NoMethod GooglePrivacyDlpV2CategoricalStatsHistogramBucket
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GooglePrivacyDlpV2CategoricalStatsResult: Result of the categorical stats
// computation.
type GooglePrivacyDlpV2CategoricalStatsResult struct {
	// ValueFrequencyHistogramBuckets: Histogram of value frequencies in the
	// column.
	ValueFrequencyHistogramBuckets []*GooglePrivacyDlpV2CategoricalStatsHistogramBucket `json:"valueFrequencyHistogramBuckets,omitempty"`
	// ForceSendFields is a list of field names (e.g.
	// "ValueFrequencyHistogramBuckets") to unconditionally include in API
	// requests. By default, fields with empty or default values are omitted from
	// API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ValueFrequencyHistogramBuckets")
	// to include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GooglePrivacyDlpV2CategoricalStatsResult) MarshalJSON() ([]byte, error) {
	type NoMethod GooglePrivacyDlpV2CategoricalStatsResult
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GooglePrivacyDlpV2CharacterMaskConfig: Partially mask a string by replacing
// a given number of characters with a fixed character. Masking can start from
// the beginning or end of the string. This can be used on data of any type
// (numbers, longs, and so on) and when de-identifying structured data we'll
// attempt to preserve the original data's type. (This allows you to take a
// long like 123 and modify it to a string like **3.
type GooglePrivacyDlpV2CharacterMaskConfig struct {
	// CharactersToIgnore: When masking a string, items in this list will be
	// skipped when replacing characters. For example, if the input string is
	// `555-555-5555` and you instruct Cloud DLP to skip `-` and mask 5 characters
	// with `*`, Cloud DLP returns `***-**5-5555`.
	CharactersToIgnore []*GooglePrivacyDlpV2CharsToIgnore `json:"charactersToIgnore,omitempty"`
	// MaskingCharacter: Character to use to mask the sensitive values—for
	// example, `*` for an alphabetic string such as a name, or `0` for a numeric
	// string such as ZIP code or credit card number. This string must have a
	// length of 1. If not supplied, this value defaults to `*` for strings, and
	// `0` for digits.
	MaskingCharacter string `json:"maskingCharacter,omitempty"`
	// NumberToMask: Number of characters to mask. If not set, all matching chars
	// will be masked. Skipped characters do not count towards this tally. If
	// `number_to_mask` is negative, this denotes inverse masking. Cloud DLP masks
	// all but a number of characters. For example, suppose you have the following
	// values: - `masking_character` is `*` - `number_to_mask` is `-4` -
	// `reverse_order` is `false` - `CharsToIgnore` includes `-` - Input string is
	// `1234-5678-9012-3456` The resulting de-identified string is
	// `****-****-****-3456`. Cloud DLP masks all but the last four characters. If
	// `reverse_order` is `true`, all but the first four characters are masked as
	// `1234-****-****-****`.
	NumberToMask int64 `json:"numberToMask,omitempty"`
	// ReverseOrder: Mask characters in reverse order. For example, if
	// `masking_character` is `0`, `number_to_mask` is `14`, and `reverse_order` is
	// `false`, then the input string `1234-5678-9012-3456` is masked as
	// `00000000000000-3456`. If `masking_character` is `*`, `number_to_mask` is
	// `3`, and `reverse_order` is `true`, then the string `12345` is masked as
	// `12***`.
	ReverseOrder bool `json:"reverseOrder,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CharactersToIgnore") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CharactersToIgnore") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GooglePrivacyDlpV2CharacterMaskConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GooglePrivacyDlpV2CharacterMaskConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GooglePrivacyDlpV2CharsToIgnore: Characters to skip when doing
// deidentification of a value. These will be left alone and skipped.
type GooglePrivacyDlpV2CharsToIgnore struct {
	// CharactersToSkip: Characters to not transform when masking.
	CharactersToSkip string `json:"charactersToSkip,omitempty"`
	// CommonCharactersToIgnore: Common characters to not transform when masking.
	// Useful to avoid removing punctuation.
	//
	// Possible values:
	//   "COMMON_CHARS_TO_IGNORE_UNSPECIFIED" - Unused.
	//   "NUMERIC" - 0-9
	//   "ALPHA_UPPER_CASE" - A-Z
	//   "ALPHA_LOWER_CASE" - a-z
	//   "PUNCTUATION" - US Punctuation, one of !"#$%&'()*+,-./:;<=>?@[\]^_`{|}~
	//   "WHITESPACE" - Whitespace character, one of [ \t\n\x0B\f\r]
	CommonCharactersToIgnore string `json:"commonCharactersToIgnore,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CharactersToSkip") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CharactersToSkip") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GooglePrivacyDlpV2CharsToIgnore) MarshalJSON() ([]byte, error) {
	type NoMethod GooglePrivacyDlpV2CharsToIgnore
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GooglePrivacyDlpV2CloudSqlDiscoveryTarget: Target used to match against for
// discovery with Cloud SQL tables.
type GooglePrivacyDlpV2CloudSqlDiscoveryTarget struct {
	// Conditions: In addition to matching the filter, these conditions must be
	// true before a profile is generated.
	Conditions *GooglePrivacyDlpV2DiscoveryCloudSqlConditions `json:"conditions,omitempty"`
	// Disabled: Disable profiling for database resources that match this filter.
	Disabled *GooglePrivacyDlpV2Disabled `json:"disabled,omitempty"`
	// Filter: Required. The tables the discovery cadence applies to. The first
	// target with a matching filter will be the one to apply to a table.
	Filter *GooglePrivacyDlpV2DiscoveryCloudSqlFilter `json:"filter,omitempty"`
	// GenerationCadence: How often and when to update profiles. New tables that
	// match both the filter and conditions are scanned as quickly as possible
	// depending on system capacity.
	GenerationCadence *GooglePrivacyDlpV2DiscoveryCloudSqlGenerationCadence `json:"generationCadence,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Conditions") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Conditions") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GooglePrivacyDlpV2CloudSqlDiscoveryTarget) MarshalJSON() ([]byte, error) {
	type NoMethod GooglePrivacyDlpV2CloudSqlDiscoveryTarget
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GooglePrivacyDlpV2CloudSqlIamCredential: Use IAM authentication to connect.
// This requires the Cloud SQL IAM feature to be enabled on the instance, which
// is not the default for Cloud SQL. See
// https://cloud.google.com/sql/docs/postgres/authentication and
// https://cloud.google.com/sql/docs/mysql/authentication.
type GooglePrivacyDlpV2CloudSqlIamCredential struct {
}

// GooglePrivacyDlpV2CloudSqlProperties: Cloud SQL connection properties.
type GooglePrivacyDlpV2CloudSqlProperties struct {
	// CloudSqlIam: Built-in IAM authentication (must be configured in Cloud SQL).
	CloudSqlIam *GooglePrivacyDlpV2CloudSqlIamCredential `json:"cloudSqlIam,omitempty"`
	// ConnectionName: Optional. Immutable. The Cloud SQL instance for which the
	// connection is defined. Only one connection per instance is allowed. This can
	// only be set at creation time, and cannot be updated. It is an error to use a
	// connection_name from different project or region than the one that holds the
	// connection. For example, a Connection resource for Cloud SQL connection_name
	// `project-id:us-central1:sql-instance` must be created under the parent
	// `projects/project-id/locations/us-central1`
	ConnectionName string `json:"connectionName,omitempty"`
	// DatabaseEngine: Required. The database engine used by the Cloud SQL instance
	// that this connection configures.
	//
	// Possible values:
	//   "DATABASE_ENGINE_UNKNOWN" - An engine that is not currently supported by
	// Sensitive Data Protection.
	//   "DATABASE_ENGINE_MYSQL" - Cloud SQL for MySQL instance.
	//   "DATABASE_ENGINE_POSTGRES" - Cloud SQL for PostgreSQL instance.
	DatabaseEngine string `json:"databaseEngine,omitempty"`
	// MaxConnections: Required. The DLP API will limit its connections to
	// max_connections. Must be 2 or greater.
	MaxConnections int64 `json:"maxConnections,omitempty"`
	// UsernamePassword: A username and password stored in Secret Manager.
	UsernamePassword *GooglePrivacyDlpV2SecretManagerCredential `json:"usernamePassword,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CloudSqlIam") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CloudSqlIam") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GooglePrivacyDlpV2CloudSqlProperties) MarshalJSON() ([]byte, error) {
	type NoMethod GooglePrivacyDlpV2CloudSqlProperties
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GooglePrivacyDlpV2CloudStorageDiscoveryTarget: Target used to match against
// for discovery with Cloud Storage buckets.
type GooglePrivacyDlpV2CloudStorageDiscoveryTarget struct {
	// Conditions: Optional. In addition to matching the filter, these conditions
	// must be true before a profile is generated.
	Conditions *GooglePrivacyDlpV2DiscoveryFileStoreConditions `json:"conditions,omitempty"`
	// Disabled: Optional. Disable profiling for buckets that match this filter.
	Disabled *GooglePrivacyDlpV2Disabled `json:"disabled,omitempty"`
	// Filter: Required. The buckets the generation_cadence applies to. The first
	// target with a matching filter will be the one to apply to a bucket.
	Filter *GooglePrivacyDlpV2DiscoveryCloudStorageFilter `json:"filter,omitempty"`
	// GenerationCadence: Optional. How often and when to update profiles. New
	// buckets that match both the filter and conditions are scanned as quickly as
	// possible depending on system capacity.
	GenerationCadence *GooglePrivacyDlpV2DiscoveryCloudStorageGenerationCadence `json:"generationCadence,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Conditions") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Conditions") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GooglePrivacyDlpV2CloudStorageDiscoveryTarget) MarshalJSON() ([]byte, error) {
	type NoMethod GooglePrivacyDlpV2CloudStorageDiscoveryTarget
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GooglePrivacyDlpV2CloudStorageFileSet: Message representing a set of files
// in Cloud Storage.
type GooglePrivacyDlpV2CloudStorageFileSet struct {
	// Url: The url, in the format `gs:///`. Trailing wildcard in the path is
	// allowed.
	Url string `json:"url,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Url") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Url") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GooglePrivacyDlpV2CloudStorageFileSet) MarshalJSON() ([]byte, error) {
	type NoMethod GooglePrivacyDlpV2CloudStorageFileSet
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GooglePrivacyDlpV2CloudStorageOptions: Options defining a file or a set of
// files within a Cloud Storage bucket.
type GooglePrivacyDlpV2CloudStorageOptions struct {
	// BytesLimitPerFile: Max number of bytes to scan from a file. If a scanned
	// file's size is bigger than this value then the rest of the bytes are
	// omitted. Only one of `bytes_limit_per_file` and
	// `bytes_limit_per_file_percent` can be specified. This field can't be set if
	// de-identification is requested. For certain file types, setting this field
	// has no effect. For more information, see Limits on bytes scanned per file
	// (https://cloud.google.com/sensitive-data-protection/docs/supported-file-types#max-byte-size-per-file).
	BytesLimitPerFile int64 `json:"bytesLimitPerFile,omitempty,string"`
	// BytesLimitPerFilePercent: Max percentage of bytes to scan from a file. The
	// rest are omitted. The number of bytes scanned is rounded down. Must be
	// between 0 and 100, inclusively. Both 0 and 100 means no limit. Defaults to
	// 0. Only one of bytes_limit_per_file and bytes_limit_per_file_percent can be
	// specified. This field can't be set if de-identification is requested. For
	// certain file types, setting this field has no effect. For more information,
	// see Limits on bytes scanned per file
	// (https://cloud.google.com/sensitive-data-protection/docs/supported-file-types#max-byte-size-per-file).
	BytesLimitPerFilePercent int64 `json:"bytesLimitPerFilePercent,omitempty"`
	// FileSet: The set of one or more files to scan.
	FileSet *GooglePrivacyDlpV2FileSet `json:"fileSet,omitempty"`
	// FileTypes: List of file type groups to include in the scan. If empty, all
	// files are scanned and available data format processors are applied. In
	// addition, the binary content of the selected files is always scanned as
	// well. Images are scanned only as binary if the specified region does not
	// support image inspection and no file_types were specified. Image inspection
	// is restricted to 'global', 'us', 'asia', and 'europe'.
	//
	// Possible values:
	//   "FILE_TYPE_UNSPECIFIED" - Includes all files.
	//   "BINARY_FILE" - Includes all file extensions not covered by another entry.
	// Binary scanning attempts to convert the content of the file to utf_8 to scan
	// the file. If you wish to avoid this fall back, specify one or more of the
	// other file types in your storage scan.
	//   "TEXT_FILE" - Included file extensions: asc,asp, aspx, brf, c, cc,cfm,
	// cgi, cpp, csv, cxx, c++, cs, css, dart, dat, dot, eml,, epbub, ged, go, h,
	// hh, hpp, hxx, h++, hs, html, htm, mkd, markdown, m, ml, mli, perl, pl,
	// plist, pm, php, phtml, pht, properties, py, pyw, rb, rbw, rs, rss, rc,
	// scala, sh, sql, swift, tex, shtml, shtm, xhtml, lhs, ics, ini, java, js,
	// json, jsonl, kix, kml, ocaml, md, txt, text, tsv, vb, vcard, vcs, wml,
	// xcodeproj, xml, xsl, xsd, yml, yaml.
	//   "IMAGE" - Included file extensions: bmp, gif, jpg, jpeg, jpe, png. Setting
	// bytes_limit_per_file or bytes_limit_per_file_percent has no effect on image
	// files. Image inspection is restricted to the `global`, `us`, `asia`, and
	// `europe` regions.
	//   "WORD" - Microsoft Word files larger than 30 MB will be scanned as binary
	// files. Included file extensions: docx, dotx, docm, dotm. Setting
	// `bytes_limit_per_file` or `bytes_limit_per_file_percent` has no effect on
	// Word files.
	//   "PDF" - PDF files larger than 30 MB will be scanned as binary files.
	// Included file extensions: pdf. Setting `bytes_limit_per_file` or
	// `bytes_limit_per_file_percent` has no effect on PDF files.
	//   "AVRO" - Included file extensions: avro
	//   "CSV" - Included file extensions: csv
	//   "TSV" - Included file extensions: tsv
	//   "POWERPOINT" - Microsoft PowerPoint files larger than 30 MB will be
	// scanned as binary files. Included file extensions: pptx, pptm, potx, potm,
	// pot. Setting `bytes_limit_per_file` or `bytes_limit_per_file_percent` has no
	// effect on PowerPoint files.
	//   "EXCEL" - Microsoft Excel files larger than 30 MB will be scanned as
	// binary files. Included file extensions: xlsx, xlsm, xltx, xltm. Setting
	// `bytes_limit_per_file` or `bytes_limit_per_file_percent` has no effect on
	// Excel files.
	FileTypes []string `json:"fileTypes,omitempty"`
	// FilesLimitPercent: Limits the number of files to scan to this percentage of
	// the input FileSet. Number of files scanned is rounded down. Must be between
	// 0 and 100, inclusively. Both 0 and 100 means no limit. Defaults to 0.
	FilesLimitPercent int64 `json:"filesLimitPercent,omitempty"`
	// SampleMethod: How to sample the data.
	//
	// Possible values:
	//   "SAMPLE_METHOD_UNSPECIFIED" - No sampling.
	//   "TOP" - Scan from the top (default).
	//   "RANDOM_START" - For each file larger than bytes_limit_per_file, randomly
	// pick the offset to start scanning. The scanned bytes are contiguous.
	SampleMethod string `json:"sampleMethod,omitempty"`
	// ForceSendFields is a list of field names (e.g. "BytesLimitPerFile") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "BytesLimitPerFile") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GooglePrivacyDlpV2CloudStorageOptions) MarshalJSON() ([]byte, error) {
	type NoMethod GooglePrivacyDlpV2CloudStorageOptions
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GooglePrivacyDlpV2CloudStoragePath: Message representing a single file or
// path in Cloud Storage.
type GooglePrivacyDlpV2CloudStoragePath struct {
	// Path: A URL representing a file or path (no wildcards) in Cloud Storage.
	// Example: `gs://[BUCKET_NAME]/dictionary.txt`
	Path string `json:"path,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Path") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Path") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GooglePrivacyDlpV2CloudStoragePath) MarshalJSON() ([]byte, error) {
	type NoMethod GooglePrivacyDlpV2CloudStoragePath
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GooglePrivacyDlpV2CloudStorageRegex: A pattern to match against one or more
// file stores. At least one pattern must be specified. Regular expressions use
// RE2 syntax (https://github.com/google/re2/wiki/Syntax); a guide can be found
// under the google/re2 repository on GitHub.
type GooglePrivacyDlpV2CloudStorageRegex struct {
	// BucketNameRegex: Optional. Regex to test the bucket name against. If empty,
	// all buckets match. Example: "marketing2021" or "(marketing)\d{4}" will both
	// match the bucket gs://marketing2021
	BucketNameRegex string `json:"bucketNameRegex,omitempty"`
	// ProjectIdRegex: Optional. For organizations, if unset, will match all
	// projects.
	ProjectIdRegex string `json:"projectIdRegex,omitempty"`
	// ForceSendFields is a list of field names (e.g. "BucketNameRegex") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "BucketNameRegex") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GooglePrivacyDlpV2CloudStorageRegex) MarshalJSON() ([]byte, error) {
	type NoMethod GooglePrivacyDlpV2CloudStorageRegex
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GooglePrivacyDlpV2CloudStorageRegexFileSet: Message representing a set of
// files in a Cloud Storage bucket. Regular expressions are used to allow
// fine-grained control over which files in the bucket to include. Included
// files are those that match at least one item in `include_regex` and do not
// match any items in `exclude_regex`. Note that a file that matches items from
// both lists will _not_ be included. For a match to occur, the entire file
// path (i.e., everything in the url after the bucket name) must match the
// regular expression. For example, given the input `{bucket_name: "mybucket",
// include_regex: ["directory1/.*"], exclude_regex:
// ["directory1/excluded.*"]}`: * `gs://mybucket/directory1/myfile` will be
// included * `gs://mybucket/directory1/directory2/myfile` will be included
// (`.*` matches across `/`) * `gs://mybucket/directory0/directory1/myfile`
// will _not_ be included (the full path doesn't match any items in
// `include_regex`) * `gs://mybucket/directory1/excludedfile` will _not_ be
// included (the path matches an item in `exclude_regex`) If `include_regex` is
// left empty, it will match all files by default (this is equivalent to
// setting `include_regex: [".*"]`). Some other common use cases: *
// `{bucket_name: "mybucket", exclude_regex: [".*\.pdf"]}` will include all
// files in `mybucket` except for .pdf files * `{bucket_name: "mybucket",
// include_regex: ["directory/[^/]+"]}` will include all files directly under
// `gs://mybucket/directory/`, without matching across `/`
type GooglePrivacyDlpV2CloudStorageRegexFileSet struct {
	// BucketName: The name of a Cloud Storage bucket. Required.
	BucketName string `json:"bucketName,omitempty"`
	// ExcludeRegex: A list of regular expressions matching file paths to exclude.
	// All files in the bucket that match at least one of these regular expressions
	// will be excluded from the scan. Regular expressions use RE2 syntax
	// (https://github.com/google/re2/wiki/Syntax); a guide can be found under the
	// google/re2 repository on GitHub.
	ExcludeRegex []string `json:"excludeRegex,omitempty"`
	// IncludeRegex: A list of regular expressions matching file paths to include.
	// All files in the bucket that match at least one of these regular expressions
	// will be included in the set of files, except for those that also match an
	// item in `exclude_regex`. Leaving this field empty will match all files by
	// default (this is equivalent to including `.*` in the list). Regular
	// expressions use RE2 syntax (https://github.com/google/re2/wiki/Syntax); a
	// guide can be found under the google/re2 repository on GitHub.
	IncludeRegex []string `json:"includeRegex,omitempty"`
	// ForceSendFields is a list of field names (e.g. "BucketName") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "BucketName") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GooglePrivacyDlpV2CloudStorageRegexFileSet) MarshalJSON() ([]byte, error) {
	type NoMethod GooglePrivacyDlpV2CloudStorageRegexFileSet
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GooglePrivacyDlpV2CloudStorageResourceReference: Identifies a single Cloud
// Storage bucket.
type GooglePrivacyDlpV2CloudStorageResourceReference struct {
	// BucketName: Required. The bucket to scan.
	BucketName string `json:"bucketName,omitempty"`
	// ProjectId: Required. If within a project-level config, then this must match
	// the config's project id.
	ProjectId string `json:"projectId,omitempty"`
	// ForceSendFields is a list of field names (e.g. "BucketName") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "BucketName") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GooglePrivacyDlpV2CloudStorageResourceReference) MarshalJSON() ([]byte, error) {
	type NoMethod GooglePrivacyDlpV2CloudStorageResourceReference
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GooglePrivacyDlpV2Color: Represents a color in the RGB color space.
type GooglePrivacyDlpV2Color struct {
	// Blue: The amount of blue in the color as a value in the interval [0, 1].
	Blue float64 `json:"blue,omitempty"`
	// Green: The amount of green in the color as a value in the interval [0, 1].
	Green float64 `json:"green,omitempty"`
	// Red: The amount of red in the color as a value in the interval [0, 1].
	Red float64 `json:"red,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Blue") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Blue") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GooglePrivacyDlpV2Color) MarshalJSON() ([]byte, error) {
	type NoMethod GooglePrivacyDlpV2Color
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *GooglePrivacyDlpV2Color) UnmarshalJSON(data []byte) error {
	type NoMethod GooglePrivacyDlpV2Color
	var s1 struct {
		Blue  gensupport.JSONFloat64 `json:"blue"`
		Green gensupport.JSONFloat64 `json:"green"`
		Red   gensupport.JSONFloat64 `json:"red"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.Blue = float64(s1.Blue)
	s.Green = float64(s1.Green)
	s.Red = float64(s1.Red)
	return nil
}

// GooglePrivacyDlpV2ColumnDataProfile: The profile for a scanned column within
// a table.
type GooglePrivacyDlpV2ColumnDataProfile struct {
	// Column: The name of the column.
	Column string `json:"column,omitempty"`
	// ColumnInfoType: If it's been determined this column can be identified as a
	// single type, this will be set. Otherwise the column either has
	// unidentifiable content or mixed types.
	ColumnInfoType *GooglePrivacyDlpV2InfoTypeSummary `json:"columnInfoType,omitempty"`
	// ColumnType: The data type of a given column.
	//
	// Possible values:
	//   "COLUMN_DATA_TYPE_UNSPECIFIED" - Invalid type.
	//   "TYPE_INT64" - Encoded as a string in decimal format.
	//   "TYPE_BOOL" - Encoded as a boolean "false" or "true".
	//   "TYPE_FLOAT64" - Encoded as a number, or string "NaN", "Infinity" or
	// "-Infinity".
	//   "TYPE_STRING" - Encoded as a string value.
	//   "TYPE_BYTES" - Encoded as a base64 string per RFC 4648, section 4.
	//   "TYPE_TIMESTAMP" - Encoded as an RFC 3339 timestamp with mandatory "Z"
	// time zone string: 1985-04-12T23:20:50.52Z
	//   "TYPE_DATE" - Encoded as RFC 3339 full-date format string: 1985-04-12
	//   "TYPE_TIME" - Encoded as RFC 3339 partial-time format string: 23:20:50.52
	//   "TYPE_DATETIME" - Encoded as RFC 3339 full-date "T" partial-time:
	// 1985-04-12T23:20:50.52
	//   "TYPE_GEOGRAPHY" - Encoded as WKT
	//   "TYPE_NUMERIC" - Encoded as a decimal string.
	//   "TYPE_RECORD" - Container of ordered fields, each with a type and field
	// name.
	//   "TYPE_BIGNUMERIC" - Decimal type.
	//   "TYPE_JSON" - Json type.
	//   "TYPE_INTERVAL" - Interval type.
	//   "TYPE_RANGE_DATE" - `Range` type.
	//   "TYPE_RANGE_DATETIME" - `Range` type.
	//   "TYPE_RANGE_TIMESTAMP" - `Range` type.
	ColumnType string `json:"columnType,omitempty"`
	// DataRiskLevel: The data risk level for this column.
	DataRiskLevel *GooglePrivacyDlpV2DataRiskLevel `json:"dataRiskLevel,omitempty"`
	// DatasetId: The BigQuery dataset ID, if the resource profiled is a BigQuery
	// table.
	DatasetId string `json:"datasetId,omitempty"`
	// DatasetLocation: If supported, the location where the dataset's data is
	// stored. See https://cloud.google.com/bigquery/docs/locations for supported
	// BigQuery locations.
	DatasetLocation string `json:"datasetLocation,omitempty"`
	// DatasetProjectId: The Google Cloud project ID that owns the profiled
	// resource.
	DatasetProjectId string `json:"datasetProjectId,omitempty"`
	// EstimatedNullPercentage: Approximate percentage of entries being null in the
	// column.
	//
	// Possible values:
	//   "NULL_PERCENTAGE_LEVEL_UNSPECIFIED" - Unused.
	//   "NULL_PERCENTAGE_VERY_LOW" - Very few null entries.
	//   "NULL_PERCENTAGE_LOW" - Some null entries.
	//   "NULL_PERCENTAGE_MEDIUM" - A few null entries.
	//   "NULL_PERCENTAGE_HIGH" - A lot of null entries.
	EstimatedNullPercentage string `json:"estimatedNullPercentage,omitempty"`
	// EstimatedUniquenessScore: Approximate uniqueness of the column.
	//
	// Possible values:
	//   "UNIQUENESS_SCORE_LEVEL_UNSPECIFIED" - Some columns do not have estimated
	// uniqueness. Possible reasons include having too few values.
	//   "UNIQUENESS_SCORE_LOW" - Low uniqueness, possibly a boolean, enum or
	// similiarly typed column.
	//   "UNIQUENESS_SCORE_MEDIUM" - Medium uniqueness.
	//   "UNIQUENESS_SCORE_HIGH" - High uniqueness, possibly a column of free text
	// or unique identifiers.
	EstimatedUniquenessScore string `json:"estimatedUniquenessScore,omitempty"`
	// FreeTextScore: The likelihood that this column contains free-form text. A
	// value close to 1 may indicate the column is likely to contain free-form or
	// natural language text. Range in 0-1.
	FreeTextScore float64 `json:"freeTextScore,omitempty"`
	// Name: The name of the profile.
	Name string `json:"name,omitempty"`
	// OtherMatches: Other types found within this column. List will be unordered.
	OtherMatches []*GooglePrivacyDlpV2OtherInfoTypeSummary `json:"otherMatches,omitempty"`
	// PolicyState: Indicates if a policy tag has been applied to the column.
	//
	// Possible values:
	//   "COLUMN_POLICY_STATE_UNSPECIFIED" - No policy tags.
	//   "COLUMN_POLICY_TAGGED" - Column has policy tag applied.
	PolicyState string `json:"policyState,omitempty"`
	// ProfileLastGenerated: The last time the profile was generated.
	ProfileLastGenerated string `json:"profileLastGenerated,omitempty"`
	// ProfileStatus: Success or error status from the most recent profile
	// generation attempt. May be empty if the profile is still being generated.
	ProfileStatus *GooglePrivacyDlpV2ProfileStatus `json:"profileStatus,omitempty"`
	// SensitivityScore: The sensitivity of this column.
	SensitivityScore *GooglePrivacyDlpV2SensitivityScore `json:"sensitivityScore,omitempty"`
	// State: State of a profile.
	//
	// Possible values:
	//   "STATE_UNSPECIFIED" - Unused.
	//   "RUNNING" - The profile is currently running. Once a profile has finished
	// it will transition to DONE.
	//   "DONE" - The profile is no longer generating. If
	// profile_status.status.code is 0, the profile succeeded, otherwise, it
	// failed.
	State string `json:"state,omitempty"`
	// TableDataProfile: The resource name of the table data profile.
	TableDataProfile string `json:"tableDataProfile,omitempty"`
	// TableFullResource: The resource name of the resource this column is within.
	TableFullResource string `json:"tableFullResource,omitempty"`
	// TableId: The table ID.
	TableId string `json:"tableId,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Column") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Column") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GooglePrivacyDlpV2ColumnDataProfile) MarshalJSON() ([]byte, error) {
	type NoMethod GooglePrivacyDlpV2ColumnDataProfile
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *GooglePrivacyDlpV2ColumnDataProfile) UnmarshalJSON(data []byte) error {
	type NoMethod GooglePrivacyDlpV2ColumnDataProfile
	var s1 struct {
		FreeTextScore gensupport.JSONFloat64 `json:"freeTextScore"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.FreeTextScore = float64(s1.FreeTextScore)
	return nil
}

// GooglePrivacyDlpV2Condition: The field type of `value` and `field` do not
// need to match to be considered equal, but not all comparisons are possible.
// EQUAL_TO and NOT_EQUAL_TO attempt to compare even with incompatible types,
// but all other comparisons are invalid with incompatible types. A `value` of
// type: - `string` can be compared against all other types - `boolean` can
// only be compared against other booleans - `integer` can be compared against
// doubles or a string if the string value can be parsed as an integer. -
// `double` can be compared against integers or a string if the string can be
// parsed as a double. - `Timestamp` can be compared against strings in RFC
// 3339 date string format. - `TimeOfDay` can be compared against timestamps
// and strings in the format of 'HH:mm:ss'. If we fail to compare do to type
// mismatch, a warning will be given and the condition will evaluate to false.
type GooglePrivacyDlpV2Condition struct {
	// Field: Required. Field within the record this condition is evaluated
	// against.
	Field *GooglePrivacyDlpV2FieldId `json:"field,omitempty"`
	// Operator: Required. Operator used to compare the field or infoType to the
	// value.
	//
	// Possible values:
	//   "RELATIONAL_OPERATOR_UNSPECIFIED" - Unused
	//   "EQUAL_TO" - Equal. Attempts to match even with incompatible types.
	//   "NOT_EQUAL_TO" - Not equal to. Attempts to match even with incompatible
	// types.
	//   "GREATER_THAN" - Greater than.
	//   "LESS_THAN" - Less than.
	//   "GREATER_THAN_OR_EQUALS" - Greater than or equals.
	//   "LESS_THAN_OR_EQUALS" - Less than or equals.
	//   "EXISTS" - Exists
	Operator string `json:"operator,omitempty"`
	// Value: Value to compare against. [Mandatory, except for `EXISTS` tests.]
	Value *GooglePrivacyDlpV2Value `json:"value,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Field") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Field") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GooglePrivacyDlpV2Condition) MarshalJSON() ([]byte, error) {
	type NoMethod GooglePrivacyDlpV2Condition
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GooglePrivacyDlpV2Conditions: A collection of conditions.
type GooglePrivacyDlpV2Conditions struct {
	// Conditions: A collection of conditions.
	Conditions []*GooglePrivacyDlpV2Condition `json:"conditions,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Conditions") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Conditions") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GooglePrivacyDlpV2Conditions) MarshalJSON() ([]byte, error) {
	type NoMethod GooglePrivacyDlpV2Conditions
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GooglePrivacyDlpV2Connection: A data connection to allow the DLP API to
// profile data in locations that require additional configuration.
type GooglePrivacyDlpV2Connection struct {
	// CloudSql: Connect to a Cloud SQL instance.
	CloudSql *GooglePrivacyDlpV2CloudSqlProperties `json:"cloudSql,omitempty"`
	// Errors: Output only. Set if status == ERROR, to provide additional details.
	// Will store the last 10 errors sorted with the most recent first.
	Errors []*GooglePrivacyDlpV2Error `json:"errors,omitempty"`
	// Name: Output only. Name of the connection:
	// `projects/{project}/locations/{location}/connections/{name}`.
	Name string `json:"name,omitempty"`
	// State: Required. The connection's state in its lifecycle.
	//
	// Possible values:
	//   "CONNECTION_STATE_UNSPECIFIED" - Unused
	//   "MISSING_CREDENTIALS" - The DLP API automatically created this connection
	// during an initial scan, and it is awaiting full configuration by a user.
	//   "AVAILABLE" - A configured connection that has not encountered any errors.
	//   "ERROR" - A configured connection that encountered errors during its last
	// use. It will not be used again until it is set to AVAILABLE. If the
	// resolution requires external action, then the client must send a request to
	// set the status to AVAILABLE when the connection is ready for use. If the
	// resolution doesn't require external action, then any changes to the
	// connection properties will automatically mark it as AVAILABLE.
	State string `json:"state,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "CloudSql") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CloudSql") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GooglePrivacyDlpV2Connection) MarshalJSON() ([]byte, error) {
	type NoMethod GooglePrivacyDlpV2Connection
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GooglePrivacyDlpV2Container: Represents a container that may contain DLP
// findings. Examples of a container include a file, table, or database record.
type GooglePrivacyDlpV2Container struct {
	// FullPath: A string representation of the full container name. Examples: -
	// BigQuery: 'Project:DataSetId.TableId' - Cloud Storage:
	// 'gs://Bucket/folders/filename.txt'
	FullPath string `json:"fullPath,omitempty"`
	// ProjectId: Project where the finding was found. Can be different from the
	// project that owns the finding.
	ProjectId string `json:"projectId,omitempty"`
	// RelativePath: The rest of the path after the root. Examples: - For BigQuery
	// table `project_id:dataset_id.table_id`, the relative path is `table_id` -
	// For Cloud Storage file `gs://bucket/folder/filename.txt`, the relative path
	// is `folder/filename.txt`
	RelativePath string `json:"relativePath,omitempty"`
	// RootPath: The root of the container. Examples: - For BigQuery table
	// `project_id:dataset_id.table_id`, the root is `dataset_id` - For Cloud
	// Storage file `gs://bucket/folder/filename.txt`, the root is `gs://bucket`
	RootPath string `json:"rootPath,omitempty"`
	// Type: Container type, for example BigQuery or Cloud Storage.
	Type string `json:"type,omitempty"`
	// UpdateTime: Findings container modification timestamp, if applicable. For
	// Cloud Storage, this field contains the last file modification timestamp. For
	// a BigQuery table, this field contains the last_modified_time property. For
	// Datastore, this field isn't populated.
	UpdateTime string `json:"updateTime,omitempty"`
	// Version: Findings container version, if available ("generation" for Cloud
	// Storage).
	Version string `json:"version,omitempty"`
	// ForceSendFields is a list of field names (e.g. "FullPath") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "FullPath") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GooglePrivacyDlpV2Container) MarshalJSON() ([]byte, error) {
	type NoMethod GooglePrivacyDlpV2Container
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GooglePrivacyDlpV2ContentItem: Type of content to inspect.
type GooglePrivacyDlpV2ContentItem struct {
	// ByteItem: Content data to inspect or redact. Replaces `type` and `data`.
	ByteItem *GooglePrivacyDlpV2ByteContentItem `json:"byteItem,omitempty"`
	// Table: Structured content for inspection. See
	// https://cloud.google.com/sensitive-data-protection/docs/inspecting-text#inspecting_a_table
	// to learn more.
	Table *GooglePrivacyDlpV2Table `json:"table,omitempty"`
	// Value: String data to inspect or redact.
	Value string `json:"value,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ByteItem") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ByteItem") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GooglePrivacyDlpV2ContentItem) MarshalJSON() ([]byte, error) {
	type NoMethod GooglePrivacyDlpV2ContentItem
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GooglePrivacyDlpV2ContentLocation: Precise location of the finding within a
// document, record, image, or metadata container.
type GooglePrivacyDlpV2ContentLocation struct {
	// ContainerName: Name of the container where the finding is located. The top
	// level name is the source file name or table name. Names of some common
	// storage containers are formatted as follows: * BigQuery tables:
	// `{project_id}:{dataset_id}.{table_id}` * Cloud Storage files:
	// `gs://{bucket}/{path}` * Datastore namespace: {namespace} Nested names could
	// be absent if the embedded object has no string identifier (for example, an
	// image contained within a document).
	ContainerName string `json:"containerName,omitempty"`
	// ContainerTimestamp: Finding container modification timestamp, if applicable.
	// For Cloud Storage, this field contains the last file modification timestamp.
	// For a BigQuery table, this field contains the last_modified_time property.
	// For Datastore, this field isn't populated.
	ContainerTimestamp string `json:"containerTimestamp,omitempty"`
	// ContainerVersion: Finding container version, if available ("generation" for
	// Cloud Storage).
	ContainerVersion string `json:"containerVersion,omitempty"`
	// DocumentLocation: Location data for document files.
	DocumentLocation *GooglePrivacyDlpV2DocumentLocation `json:"documentLocation,omitempty"`
	// ImageLocation: Location within an image's pixels.
	ImageLocation *GooglePrivacyDlpV2ImageLocation `json:"imageLocation,omitempty"`
	// MetadataLocation: Location within the metadata for inspected content.
	MetadataLocation *GooglePrivacyDlpV2MetadataLocation `json:"metadataLocation,omitempty"`
	// RecordLocation: Location within a row or record of a database table.
	RecordLocation *GooglePrivacyDlpV2RecordLocation `json:"recordLocation,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ContainerName") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ContainerName") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GooglePrivacyDlpV2ContentLocation) MarshalJSON() ([]byte, error) {
	type NoMethod GooglePrivacyDlpV2ContentLocation
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GooglePrivacyDlpV2CreateConnectionRequest: Request message for
// CreateConnection.
type GooglePrivacyDlpV2CreateConnectionRequest struct {
	// Connection: Required. The connection resource.
	Connection *GooglePrivacyDlpV2Connection `json:"connection,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Connection") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Connection") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GooglePrivacyDlpV2CreateConnectionRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GooglePrivacyDlpV2CreateConnectionRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GooglePrivacyDlpV2CreateDeidentifyTemplateRequest: Request message for
// CreateDeidentifyTemplate.
type GooglePrivacyDlpV2CreateDeidentifyTemplateRequest struct {
	// DeidentifyTemplate: Required. The DeidentifyTemplate to create.
	DeidentifyTemplate *GooglePrivacyDlpV2DeidentifyTemplate `json:"deidentifyTemplate,omitempty"`
	// LocationId: Deprecated. This field has no effect.
	LocationId string `json:"locationId,omitempty"`
	// TemplateId: The template id can contain uppercase and lowercase letters,
	// numbers, and hyphens; that is, it must match the regular expression:
	// `[a-zA-Z\d-_]+`. The maximum length is 100 characters. Can be empty to allow
	// the system to generate one.
	TemplateId string `json:"templateId,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DeidentifyTemplate") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DeidentifyTemplate") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GooglePrivacyDlpV2CreateDeidentifyTemplateRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GooglePrivacyDlpV2CreateDeidentifyTemplateRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GooglePrivacyDlpV2CreateDiscoveryConfigRequest: Request message for
// CreateDiscoveryConfig.
type GooglePrivacyDlpV2CreateDiscoveryConfigRequest struct {
	// ConfigId: The config ID can contain uppercase and lowercase letters,
	// numbers, and hyphens; that is, it must match the regular expression:
	// `[a-zA-Z\d-_]+`. The maximum length is 100 characters. Can be empty to allow
	// the system to generate one.
	ConfigId string `json:"configId,omitempty"`
	// DiscoveryConfig: Required. The DiscoveryConfig to create.
	DiscoveryConfig *GooglePrivacyDlpV2DiscoveryConfig `json:"discoveryConfig,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ConfigId") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ConfigId") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GooglePrivacyDlpV2CreateDiscoveryConfigRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GooglePrivacyDlpV2CreateDiscoveryConfigRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GooglePrivacyDlpV2CreateDlpJobRequest: Request message for
// CreateDlpJobRequest. Used to initiate long running jobs such as calculating
// risk metrics or inspecting Google Cloud Storage.
type GooglePrivacyDlpV2CreateDlpJobRequest struct {
	// InspectJob: An inspection job scans a storage repository for InfoTypes.
	InspectJob *GooglePrivacyDlpV2InspectJobConfig `json:"inspectJob,omitempty"`
	// JobId: The job id can contain uppercase and lowercase letters, numbers, and
	// hyphens; that is, it must match the regular expression: `[a-zA-Z\d-_]+`. The
	// maximum length is 100 characters. Can be empty to allow the system to
	// generate one.
	JobId string `json:"jobId,omitempty"`
	// LocationId: Deprecated. This field has no effect.
	LocationId string `json:"locationId,omitempty"`
	// RiskJob: A risk analysis job calculates re-identification risk metrics for a
	// BigQuery table.
	RiskJob *GooglePrivacyDlpV2RiskAnalysisJobConfig `json:"riskJob,omitempty"`
	// ForceSendFields is a list of field names (e.g. "InspectJob") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "InspectJob") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GooglePrivacyDlpV2CreateDlpJobRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GooglePrivacyDlpV2CreateDlpJobRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GooglePrivacyDlpV2CreateInspectTemplateRequest: Request message for
// CreateInspectTemplate.
type GooglePrivacyDlpV2CreateInspectTemplateRequest struct {
	// InspectTemplate: Required. The InspectTemplate to create.
	InspectTemplate *GooglePrivacyDlpV2InspectTemplate `json:"inspectTemplate,omitempty"`
	// LocationId: Deprecated. This field has no effect.
	LocationId string `json:"locationId,omitempty"`
	// TemplateId: The template id can contain uppercase and lowercase letters,
	// numbers, and hyphens; that is, it must match the regular expression:
	// `[a-zA-Z\d-_]+`. The maximum length is 100 characters. Can be empty to allow
	// the system to generate one.
	TemplateId string `json:"templateId,omitempty"`
	// ForceSendFields is a list of field names (e.g. "InspectTemplate") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "InspectTemplate") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GooglePrivacyDlpV2CreateInspectTemplateRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GooglePrivacyDlpV2CreateInspectTemplateRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GooglePrivacyDlpV2CreateJobTriggerRequest: Request message for
// CreateJobTrigger.
type GooglePrivacyDlpV2CreateJobTriggerRequest struct {
	// JobTrigger: Required. The JobTrigger to create.
	JobTrigger *GooglePrivacyDlpV2JobTrigger `json:"jobTrigger,omitempty"`
	// LocationId: Deprecated. This field has no effect.
	LocationId string `json:"locationId,omitempty"`
	// TriggerId: The trigger id can contain uppercase and lowercase letters,
	// numbers, and hyphens; that is, it must match the regular expression:
	// `[a-zA-Z\d-_]+`. The maximum length is 100 characters. Can be empty to allow
	// the system to generate one.
	TriggerId string `json:"triggerId,omitempty"`
	// ForceSendFields is a list of field names (e.g. "JobTrigger") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "JobTrigger") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GooglePrivacyDlpV2CreateJobTriggerRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GooglePrivacyDlpV2CreateJobTriggerRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GooglePrivacyDlpV2CreateStoredInfoTypeRequest: Request message for
// CreateStoredInfoType.
type GooglePrivacyDlpV2CreateStoredInfoTypeRequest struct {
	// Config: Required. Configuration of the storedInfoType to create.
	Config *GooglePrivacyDlpV2StoredInfoTypeConfig `json:"config,omitempty"`
	// LocationId: Deprecated. This field has no effect.
	LocationId string `json:"locationId,omitempty"`
	// StoredInfoTypeId: The storedInfoType ID can contain uppercase and lowercase
	// letters, numbers, and hyphens; that is, it must match the regular
	// expression: `[a-zA-Z\d-_]+`. The maximum length is 100 characters. Can be
	// empty to allow the system to generate one.
	StoredInfoTypeId string `json:"storedInfoTypeId,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Config") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Config") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GooglePrivacyDlpV2CreateStoredInfoTypeRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GooglePrivacyDlpV2CreateStoredInfoTypeRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GooglePrivacyDlpV2CryptoDeterministicConfig: Pseudonymization method that
// generates deterministic encryption for the given input. Outputs a base64
// encoded representation of the encrypted output. Uses AES-SIV based on the
// RFC https://tools.ietf.org/html/rfc5297.
type GooglePrivacyDlpV2CryptoDeterministicConfig struct {
	// Context: A context may be used for higher security and maintaining
	// referential integrity such that the same identifier in two different
	// contexts will be given a distinct surrogate. The context is appended to
	// plaintext value being encrypted. On decryption the provided context is
	// validated against the value used during encryption. If a context was
	// provided during encryption, same context must be provided during decryption
	// as well. If the context is not set, plaintext would be used as is for
	// encryption. If the context is set but: 1. there is no record present when
	// transforming a given value or 2. the field is not present when transforming
	// a given value, plaintext would be used as is for encryption. Note that case
	// (1) is expected when an `InfoTypeTransformation` is applied to both
	// structured and unstructured `ContentItem`s.
	Context *GooglePrivacyDlpV2FieldId `json:"context,omitempty"`
	// CryptoKey: The key used by the encryption function. For deterministic
	// encryption using AES-SIV, the provided key is internally expanded to 64
	// bytes prior to use.
	CryptoKey *GooglePrivacyDlpV2CryptoKey `json:"cryptoKey,omitempty"`
	// SurrogateInfoType: The custom info type to annotate the surrogate with. This
	// annotation will be applied to the surrogate by prefixing it with the name of
	// the custom info type followed by the number of characters comprising the
	// surrogate. The following scheme defines the format: {info type
	// name}({surrogate character count}):{surrogate} For example, if the name of
	// custom info type is 'MY_TOKEN_INFO_TYPE' and the surrogate is 'abc', the
	// full replacement value will be: 'MY_TOKEN_INFO_TYPE(3):abc' This annotation
	// identifies the surrogate when inspecting content using the custom info type
	// 'Surrogate'. This facilitates reversal of the surrogate when it occurs in
	// free text. Note: For record transformations where the entire cell in a table
	// is being transformed, surrogates are not mandatory. Surrogates are used to
	// denote the location of the token and are necessary for re-identification in
	// free form text. In order for inspection to work properly, the name of this
	// info type must not occur naturally anywhere in your data; otherwise,
	// inspection may either - reverse a surrogate that does not correspond to an
	// actual identifier - be unable to parse the surrogate and result in an error
	// Therefore, choose your custom info type name carefully after considering
	// what your data looks like. One way to select a name that has a high chance
	// of yielding reliable detection is to include one or more unicode characters
	// that are highly improbable to exist in your data. For example, assuming your
	// data is entered from a regular ASCII keyboard, the symbol with the hex code
	// point 29DD might be used like so: ⧝MY_TOKEN_TYPE.
	SurrogateInfoType *GooglePrivacyDlpV2InfoType `json:"surrogateInfoType,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Context") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Context") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GooglePrivacyDlpV2CryptoDeterministicConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GooglePrivacyDlpV2CryptoDeterministicConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GooglePrivacyDlpV2CryptoHashConfig: Pseudonymization method that generates
// surrogates via cryptographic hashing. Uses SHA-256. The key size must be
// either 32 or 64 bytes. Outputs a base64 encoded representation of the hashed
// output (for example, L7k0BHmF1ha5U3NfGykjro4xWi1MPVQPjhMAZbSV9mM=).
// Currently, only string and integer values can be hashed. See
// https://cloud.google.com/sensitive-data-protection/docs/pseudonymization to
// learn more.
type GooglePrivacyDlpV2CryptoHashConfig struct {
	// CryptoKey: The key used by the hash function.
	CryptoKey *GooglePrivacyDlpV2CryptoKey `json:"cryptoKey,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CryptoKey") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CryptoKey") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GooglePrivacyDlpV2CryptoHashConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GooglePrivacyDlpV2CryptoHashConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GooglePrivacyDlpV2CryptoKey: This is a data encryption key (DEK) (as opposed
// to a key encryption key (KEK) stored by Cloud Key Management Service (Cloud
// KMS). When using Cloud KMS to wrap or unwrap a DEK, be sure to set an
// appropriate IAM policy on the KEK to ensure an attacker cannot unwrap the
// DEK.
type GooglePrivacyDlpV2CryptoKey struct {
	// KmsWrapped: Key wrapped using Cloud KMS
	KmsWrapped *GooglePrivacyDlpV2KmsWrappedCryptoKey `json:"kmsWrapped,omitempty"`
	// Transient: Transient crypto key
	Transient *GooglePrivacyDlpV2TransientCryptoKey `json:"transient,omitempty"`
	// Unwrapped: Unwrapped crypto key
	Unwrapped *GooglePrivacyDlpV2UnwrappedCryptoKey `json:"unwrapped,omitempty"`
	// ForceSendFields is a list of field names (e.g. "KmsWrapped") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "KmsWrapped") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GooglePrivacyDlpV2CryptoKey) MarshalJSON() ([]byte, error) {
	type NoMethod GooglePrivacyDlpV2CryptoKey
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GooglePrivacyDlpV2CryptoReplaceFfxFpeConfig: Replaces an identifier with a
// surrogate using Format Preserving Encryption (FPE) with the FFX mode of
// operation; however when used in the `ReidentifyContent` API method, it
// serves the opposite function by reversing the surrogate back into the
// original identifier. The identifier must be encoded as ASCII. For a given
// crypto key and context, the same identifier will be replaced with the same
// surrogate. Identifiers must be at least two characters long. In the case
// that the identifier is the empty string, it will be skipped. See
// https://cloud.google.com/sensitive-data-protection/docs/pseudonymization to
// learn more. Note: We recommend using CryptoDeterministicConfig for all use
// cases which do not require preserving the input alphabet space and size,
// plus warrant referential integrity. FPE incurs significant latency costs.
type GooglePrivacyDlpV2CryptoReplaceFfxFpeConfig struct {
	// CommonAlphabet: Common alphabets.
	//
	// Possible values:
	//   "FFX_COMMON_NATIVE_ALPHABET_UNSPECIFIED" - Unused.
	//   "NUMERIC" - `[0-9]` (radix of 10)
	//   "HEXADECIMAL" - `[0-9A-F]` (radix of 16)
	//   "UPPER_CASE_ALPHA_NUMERIC" - `[0-9A-Z]` (radix of 36)
	//   "ALPHA_NUMERIC" - `[0-9A-Za-z]` (radix of 62)
	CommonAlphabet string `json:"commonAlphabet,omitempty"`
	// Context: The 'tweak', a context may be used for higher security since the
	// same identifier in two different contexts won't be given the same surrogate.
	// If the context is not set, a default tweak will be used. If the context is
	// set but: 1. there is no record present when transforming a given value or 1.
	// the field is not present when transforming a given value, a default tweak
	// will be used. Note that case (1) is expected when an
	// `InfoTypeTransformation` is applied to both structured and unstructured
	// `ContentItem`s. Currently, the referenced field may be of value type integer
	// or string. The tweak is constructed as a sequence of bytes in big endian
	// byte order such that: - a 64 bit integer is encoded followed by a single
	// byte of value 1 - a string is encoded in UTF-8 format followed by a single
	// byte of value 2
	Context *GooglePrivacyDlpV2FieldId `json:"context,omitempty"`
	// CryptoKey: Required. The key used by the encryption algorithm.
	CryptoKey *GooglePrivacyDlpV2CryptoKey `json:"cryptoKey,omitempty"`
	// CustomAlphabet: This is supported by mapping these to the alphanumeric
	// characters that the FFX mode natively supports. This happens before/after
	// encryption/decryption. Each character listed must appear only once. Number
	// of characters must be in the range [2, 95]. This must be encoded as ASCII.
	// The order of characters does not matter. The full list of allowed characters
	// is:
	// ``0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz~`!@#$%^&*()_
	// -+={[}]|\:;"'<,>.?/``
	CustomAlphabet string `json:"customAlphabet,omitempty"`
	// Radix: The native way to select the alphabet. Must be in the range [2, 95].
	Radix int64 `json:"radix,omitempty"`
	// SurrogateInfoType: The custom infoType to annotate the surrogate with. This
	// annotation will be applied to the surrogate by prefixing it with the name of
	// the custom infoType followed by the number of characters comprising the
	// surrogate. The following scheme defines the format:
	// info_type_name(surrogate_character_count):surrogate For example, if the name
	// of custom infoType is 'MY_TOKEN_INFO_TYPE' and the surrogate is 'abc', the
	// full replacement value will be: 'MY_TOKEN_INFO_TYPE(3):abc' This annotation
	// identifies the surrogate when inspecting content using the custom infoType
	// `SurrogateType`
	// (https://cloud.google.com/sensitive-data-protection/docs/reference/rest/v2/InspectConfig#surrogatetype).
	// This facilitates reversal of the surrogate when it occurs in free text. In
	// order for inspection to work properly, the name of this infoType must not
	// occur naturally anywhere in your data; otherwise, inspection may find a
	// surrogate that does not correspond to an actual identifier. Therefore,
	// choose your custom infoType name carefully after considering what your data
	// looks like. One way to select a name that has a high chance of yielding
	// reliable detection is to include one or more unicode characters that are
	// highly improbable to exist in your data. For example, assuming your data is
	// entered from a regular ASCII keyboard, the symbol with the hex code point
	// 29DD might be used like so: ⧝MY_TOKEN_TYPE
	SurrogateInfoType *GooglePrivacyDlpV2InfoType `json:"surrogateInfoType,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CommonAlphabet") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CommonAlphabet") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GooglePrivacyDlpV2CryptoReplaceFfxFpeConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GooglePrivacyDlpV2CryptoReplaceFfxFpeConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GooglePrivacyDlpV2CustomInfoType: Custom information type provided by the
// user. Used to find domain-specific sensitive information configurable to the
// data in question.
type GooglePrivacyDlpV2CustomInfoType struct {
	// DetectionRules: Set of detection rules to apply to all findings of this
	// CustomInfoType. Rules are applied in order that they are specified. Not
	// supported for the `surrogate_type`, `metadata_key_value_expression`, and
	// `prompt` CustomInfoType.
	DetectionRules []*GooglePrivacyDlpV2DetectionRule `json:"detectionRules,omitempty"`
	// Dictionary: A list of phrases to detect as a CustomInfoType.
	Dictionary *GooglePrivacyDlpV2Dictionary `json:"dictionary,omitempty"`
	// ExclusionType: If set to EXCLUSION_TYPE_EXCLUDE this infoType will not cause
	// a finding to be returned. It still can be used for rules matching. Not
	// supported for the `metadata_key_value_expression` and `prompt`
	// CustomInfoType.
	//
	// Possible values:
	//   "EXCLUSION_TYPE_UNSPECIFIED" - A finding of this custom info type will not
	// be excluded from results.
	//   "EXCLUSION_TYPE_EXCLUDE" - A finding of this custom info type will be
	// excluded from final results, but can still affect rule execution.
	ExclusionType string `json:"exclusionType,omitempty"`
	// InfoType: CustomInfoType can either be a new infoType, or an extension of
	// built-in infoType, when the name matches one of existing infoTypes and that
	// infoType is specified in `InspectContent.info_types` field. Specifying the
	// latter adds findings to the one detected by the system. If built-in info
	// type is not specified in `InspectContent.info_types` list then the name is
	// treated as a custom info type.
	InfoType *GooglePrivacyDlpV2InfoType `json:"infoType,omitempty"`
	// Likelihood: Likelihood to return for this CustomInfoType. This base value
	// can be altered by a detection rule if the finding meets the criteria
	// specified by the rule. Defaults to `VERY_LIKELY` if not specified.
	//
	// Possible values:
	//   "LIKELIHOOD_UNSPECIFIED" - Default value; same as POSSIBLE.
	//   "VERY_UNLIKELY" - Highest chance of a false positive.
	//   "UNLIKELY" - High chance of a false positive.
	//   "POSSIBLE" - Some matching signals. The default value.
	//   "LIKELY" - Low chance of a false positive.
	//   "VERY_LIKELY" - Confidence level is high. Lowest chance of a false
	// positive.
	Likelihood string `json:"likelihood,omitempty"`
	// Regex: Regular expression based CustomInfoType.
	Regex *GooglePrivacyDlpV2Regex `json:"regex,omitempty"`
	// SensitivityScore: Sensitivity for this CustomInfoType. If this
	// CustomInfoType extends an existing InfoType, the sensitivity here will take
	// precedence over that of the original InfoType. If unset for a
	// CustomInfoType, it will default to HIGH. This only applies to data
	// profiling.
	SensitivityScore *GooglePrivacyDlpV2SensitivityScore `json:"sensitivityScore,omitempty"`
	// StoredType: Loads an existing `StoredInfoType` resource.
	StoredType *GooglePrivacyDlpV2StoredType `json:"storedType,omitempty"`
	// SurrogateType: Message for detecting output from deidentification
	// transformations that support reversing.
	SurrogateType *GooglePrivacyDlpV2SurrogateType `json:"surrogateType,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DetectionRules") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DetectionRules") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GooglePrivacyDlpV2CustomInfoType) MarshalJSON() ([]byte, error) {
	type NoMethod GooglePrivacyDlpV2CustomInfoType
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GooglePrivacyDlpV2DataProfileAction: A task to execute when a data profile
// has been generated.
type GooglePrivacyDlpV2DataProfileAction struct {
	// ExportData: Export data profiles into a provided location.
	ExportData *GooglePrivacyDlpV2Export `json:"exportData,omitempty"`
	// PubSubNotification: Publish a message into the Pub/Sub topic.
	PubSubNotification *GooglePrivacyDlpV2PubSubNotification `json:"pubSubNotification,omitempty"`
	// PublishToChronicle: Publishes generated data profiles to Google Security
	// Operations. For more information, see Use Sensitive Data Protection data in
	// context-aware analytics
	// (https://cloud.google.com/chronicle/docs/detection/usecase-dlp-high-risk-user-download).
	PublishToChronicle *GooglePrivacyDlpV2PublishToChronicle `json:"publishToChronicle,omitempty"`
	// PublishToDataplexCatalog: Publishes a portion of each profile to Dataplex
	// Universal Catalog with the aspect type Sensitive Data Protection Profile.
	PublishToDataplexCatalog *GooglePrivacyDlpV2PublishToDataplexCatalog `json:"publishToDataplexCatalog,omitempty"`
	// PublishToScc: Publishes findings to Security Command Center for each data
	// profile.
	PublishToScc *GooglePrivacyDlpV2PublishToSecurityCommandCenter `json:"publishToScc,omitempty"`
	// TagResources: Tags the profiled resources with the specified tag values.
	TagResources *GooglePrivacyDlpV2TagResources `json:"tagResources,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ExportData") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ExportData") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GooglePrivacyDlpV2DataProfileAction) MarshalJSON() ([]byte, error) {
	type NoMethod GooglePrivacyDlpV2DataProfileAction
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GooglePrivacyDlpV2DataProfileBigQueryRowSchema: The schema of data to be
// saved to the BigQuery table when the `DataProfileAction` is enabled.
type GooglePrivacyDlpV2DataProfileBigQueryRowSchema struct {
	// ColumnProfile: Column data profile column
	ColumnProfile *GooglePrivacyDlpV2ColumnDataProfile `json:"columnProfile,omitempty"`
	// FileStoreProfile: File store data profile column.
	FileStoreProfile *GooglePrivacyDlpV2FileStoreDataProfile `json:"fileStoreProfile,omitempty"`
	// TableProfile: Table data profile column
	TableProfile *GooglePrivacyDlpV2TableDataProfile `json:"tableProfile,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ColumnProfile") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ColumnProfile") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GooglePrivacyDlpV2DataProfileBigQueryRowSchema) MarshalJSON() ([]byte, error) {
	type NoMethod GooglePrivacyDlpV2DataProfileBigQueryRowSchema
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GooglePrivacyDlpV2DataProfileConfigSnapshot: Snapshot of the configurations
// used to generate the profile.
type GooglePrivacyDlpV2DataProfileConfigSnapshot struct {
	// DataProfileJob: A copy of the configuration used to generate this profile.
	// This is deprecated, and the DiscoveryConfig field is preferred moving
	// forward. DataProfileJobConfig will still be written here for Discovery in
	// BigQuery for backwards compatibility, but will not be updated with new
	// fields, while DiscoveryConfig will.
	DataProfileJob *GooglePrivacyDlpV2DataProfileJobConfig `json:"dataProfileJob,omitempty"`
	// DiscoveryConfig: A copy of the configuration used to generate this profile.
	DiscoveryConfig *GooglePrivacyDlpV2DiscoveryConfig `json:"discoveryConfig,omitempty"`
	// InspectConfig: A copy of the inspection config used to generate this
	// profile. This is a copy of the inspect_template specified in
	// `DataProfileJobConfig`.
	InspectConfig *GooglePrivacyDlpV2InspectConfig `json:"inspectConfig,omitempty"`
	// InspectTemplateModifiedTime: Timestamp when the template was modified
	InspectTemplateModifiedTime string `json:"inspectTemplateModifiedTime,omitempty"`
	// InspectTemplateName: Name of the inspection template used to generate this
	// profile
	InspectTemplateName string `json:"inspectTemplateName,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DataProfileJob") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DataProfileJob") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GooglePrivacyDlpV2DataProfileConfigSnapshot) MarshalJSON() ([]byte, error) {
	type NoMethod GooglePrivacyDlpV2DataProfileConfigSnapshot
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GooglePrivacyDlpV2DataProfileFinding: Details about a piece of potentially
// sensitive information that was detected when the data resource was profiled.
type GooglePrivacyDlpV2DataProfileFinding struct {
	// DataProfileResourceName: Resource name of the data profile associated with
	// the finding.
	DataProfileResourceName string `json:"dataProfileResourceName,omitempty"`
	// DataSourceType: The type of the resource that was profiled.
	DataSourceType *GooglePrivacyDlpV2DataSourceType `json:"dataSourceType,omitempty"`
	// FindingId: A unique identifier for the finding.
	FindingId string `json:"findingId,omitempty"`
	// FullResourceName: The full resource name
	// (https://cloud.google.com/apis/design/resource_names#full_resource_name) of
	// the resource profiled for this finding.
	FullResourceName string `json:"fullResourceName,omitempty"`
	// Infotype: The type of content
	// (https://cloud.google.com/sensitive-data-protection/docs/infotypes-reference)
	// that might have been found.
	Infotype *GooglePrivacyDlpV2InfoType `json:"infotype,omitempty"`
	// Location: Where the content was found.
	Location *GooglePrivacyDlpV2DataProfileFindingLocation `json:"location,omitempty"`
	// Quote: The content that was found. Even if the content is not textual, it
	// may be converted to a textual representation here. If the finding exceeds
	// 4096 bytes in length, the quote may be omitted.
	Quote string `json:"quote,omitempty"`
	// QuoteInfo: Contains data parsed from quotes. Currently supported infoTypes:
	// DATE, DATE_OF_BIRTH, and TIME.
	QuoteInfo *GooglePrivacyDlpV2QuoteInfo `json:"quoteInfo,omitempty"`
	// ResourceVisibility: How broadly a resource has been shared.
	//
	// Possible values:
	//   "RESOURCE_VISIBILITY_UNSPECIFIED" - Unused.
	//   "RESOURCE_VISIBILITY_PUBLIC" - Visible to any user.
	//   "RESOURCE_VISIBILITY_INCONCLUSIVE" - May contain public items. For
	// example, if a Cloud Storage bucket has uniform bucket level access disabled,
	// some objects inside it may be public, but none are known yet.
	//   "RESOURCE_VISIBILITY_RESTRICTED" - Visible only to specific users.
	ResourceVisibility string `json:"resourceVisibility,omitempty"`
	// Timestamp: Timestamp when the finding was detected.
	Timestamp string `json:"timestamp,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DataProfileResourceName") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DataProfileResourceName") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GooglePrivacyDlpV2DataProfileFinding) MarshalJSON() ([]byte, error) {
	type NoMethod GooglePrivacyDlpV2DataProfileFinding
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GooglePrivacyDlpV2DataProfileFindingLocation: Location of a data profile
// finding within a resource.
type GooglePrivacyDlpV2DataProfileFindingLocation struct {
	// ContainerName: Name of the container where the finding is located. The
	// top-level name is the source file name or table name. Names of some common
	// storage containers are formatted as follows: * BigQuery tables:
	// `{project_id}:{dataset_id}.{table_id}` * Cloud Storage files:
	// `gs://{bucket}/{path}`
	ContainerName string `json:"containerName,omitempty"`
	// DataProfileFindingRecordLocation: Location of a finding within a resource
	// that produces a table data profile.
	DataProfileFindingRecordLocation *GooglePrivacyDlpV2DataProfileFindingRecordLocation `json:"dataProfileFindingRecordLocation,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ContainerName") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ContainerName") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GooglePrivacyDlpV2DataProfileFindingLocation) MarshalJSON() ([]byte, error) {
	type NoMethod GooglePrivacyDlpV2DataProfileFindingLocation
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GooglePrivacyDlpV2DataProfileFindingRecordLocation: Location of a finding
// within a resource that produces a table data profile.
type GooglePrivacyDlpV2DataProfileFindingRecordLocation struct {
	// Field: Field ID of the column containing the finding.
	Field *GooglePrivacyDlpV2FieldId `json:"field,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Field") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Field") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GooglePrivacyDlpV2DataProfileFindingRecordLocation) MarshalJSON() ([]byte, error) {
	type NoMethod GooglePrivacyDlpV2DataProfileFindingRecordLocation
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GooglePrivacyDlpV2DataProfileJobConfig: Configuration for setting up a job
// to scan resources for profile generation. Only one data profile
// configuration may exist per organization, folder, or project. The generated
// data profiles are retained according to the [data retention policy]
// (https://cloud.google.com/sensitive-data-protection/docs/data-profiles#retention).
type GooglePrivacyDlpV2DataProfileJobConfig struct {
	// DataProfileActions: Actions to execute at the completion of the job.
	DataProfileActions []*GooglePrivacyDlpV2DataProfileAction `json:"dataProfileActions,omitempty"`
	// InspectTemplates: Detection logic for profile generation. Not all template
	// features are used by profiles. FindingLimits, include_quote and
	// exclude_info_types have no impact on data profiling. Multiple templates may
	// be provided if there is data in multiple regions. At most one template must
	// be specified per-region (including "global"). Each region is scanned using
	// the applicable template. If no region-specific template is specified, but a
	// "global" template is specified, it will be copied to that region and used
	// instead. If no global or region-specific template is provided for a region
	// with data, that region's data will not be scanned. For more information, see
	// https://cloud.google.com/sensitive-data-protection/docs/data-profiles#data-residency.
	InspectTemplates []string `json:"inspectTemplates,omitempty"`
	// Location: The data to scan.
	Location *GooglePrivacyDlpV2DataProfileLocation `json:"location,omitempty"`
	// OtherCloudStartingLocation: Must be set only when scanning other clouds.
	OtherCloudStartingLocation *GooglePrivacyDlpV2OtherCloudDiscoveryStartingLocation `json:"otherCloudStartingLocation,omitempty"`
	// ProjectId: The project that will run the scan. The DLP service account that
	// exists within this project must have access to all resources that are
	// profiled, and the DLP API must be enabled.
	ProjectId string `json:"projectId,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DataProfileActions") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DataProfileActions") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GooglePrivacyDlpV2DataProfileJobConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GooglePrivacyDlpV2DataProfileJobConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GooglePrivacyDlpV2DataProfileLocation: The data that will be profiled.
type GooglePrivacyDlpV2DataProfileLocation struct {
	// FolderId: The ID of the folder within an organization to scan.
	FolderId int64 `json:"folderId,omitempty,string"`
	// OrganizationId: The ID of an organization to scan.
	OrganizationId int64 `json:"organizationId,omitempty,string"`
	// ForceSendFields is a list of field names (e.g. "FolderId") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "FolderId") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GooglePrivacyDlpV2DataProfileLocation) MarshalJSON() ([]byte, error) {
	type NoMethod GooglePrivacyDlpV2DataProfileLocation
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GooglePrivacyDlpV2DataProfilePubSubCondition: A condition for determining
// whether a Pub/Sub should be triggered.
type GooglePrivacyDlpV2DataProfilePubSubCondition struct {
	// Expressions: An expression.
	Expressions *GooglePrivacyDlpV2PubSubExpressions `json:"expressions,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Expressions") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Expressions") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GooglePrivacyDlpV2DataProfilePubSubCondition) MarshalJSON() ([]byte, error) {
	type NoMethod GooglePrivacyDlpV2DataProfilePubSubCondition
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GooglePrivacyDlpV2DataProfilePubSubMessage: Pub/Sub topic message for a
// DataProfileAction.PubSubNotification event. To receive a message of protocol
// buffer schema type, convert the message data to an object of this proto
// class.
type GooglePrivacyDlpV2DataProfilePubSubMessage struct {
	// Event: The event that caused the Pub/Sub message to be sent.
	//
	// Possible values:
	//   "EVENT_TYPE_UNSPECIFIED" - Unused.
	//   "NEW_PROFILE" - New profile (not a re-profile).
	//   "CHANGED_PROFILE" - One of the following profile metrics changed: Data
	// risk score, Sensitivity score, Resource visibility, Encryption type,
	// Predicted infoTypes, Other infoTypes
	//   "SCORE_INCREASED" - Table data risk score or sensitivity score increased.
	//   "ERROR_CHANGED" - A user (non-internal) error occurred.
	Event string `json:"event,omitempty"`
	// FileStoreProfile: If `DetailLevel` is `FILE_STORE_PROFILE` this will be
	// fully populated. Otherwise, if `DetailLevel` is `RESOURCE_NAME`, then only
	// `name` and `file_store_path` will be populated.
	FileStoreProfile *GooglePrivacyDlpV2FileStoreDataProfile `json:"fileStoreProfile,omitempty"`
	// Profile: If `DetailLevel` is `TABLE_PROFILE` this will be fully populated.
	// Otherwise, if `DetailLevel` is `RESOURCE_NAME`, then only `name` and
	// `full_resource` will be populated.
	Profile *GooglePrivacyDlpV2TableDataProfile `json:"profile,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Event") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Event") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GooglePrivacyDlpV2DataProfilePubSubMessage) MarshalJSON() ([]byte, error) {
	type NoMethod GooglePrivacyDlpV2DataProfilePubSubMessage
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GooglePrivacyDlpV2DataRiskLevel: Score is a summary of all elements in the
// data profile. A higher number means more risk.
type GooglePrivacyDlpV2DataRiskLevel struct {
	// Score: The score applied to the resource.
	//
	// Possible values:
	//   "RISK_SCORE_UNSPECIFIED" - Unused.
	//   "RISK_LOW" - Low risk - Lower indication of sensitive data that appears to
	// have additional access restrictions in place or no indication of sensitive
	// data found.
	//   "RISK_UNKNOWN" - Unable to determine risk.
	//   "RISK_MODERATE" - Medium risk - Sensitive data may be present but
	// additional access or fine grain access restrictions appear to be present.
	// Consider limiting access even further or transform data to mask.
	//   "RISK_HIGH" - High risk – SPII may be present. Access controls may
	// include public ACLs. Exfiltration of data may lead to user data loss.
	// Re-identification of users may be possible. Consider limiting usage and or
	// removing SPII.
	Score string `json:"score,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Score") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Score") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GooglePrivacyDlpV2DataRiskLevel) MarshalJSON() ([]byte, error) {
	type NoMethod GooglePrivacyDlpV2DataRiskLevel
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GooglePrivacyDlpV2DataSourceType: Message used to identify the type of
// resource being profiled.
type GooglePrivacyDlpV2DataSourceType struct {
	// DataSource: A string that identifies the type of resource being profiled.
	// Current values: * google/bigquery/table * google/project * google/sql/table
	// * google/gcs/bucket
	DataSource string `json:"dataSource,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DataSource") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DataSource") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GooglePrivacyDlpV2DataSourceType) MarshalJSON() ([]byte, error) {
	type NoMethod GooglePrivacyDlpV2DataSourceType
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GooglePrivacyDlpV2DatabaseResourceCollection: Match database resources using
// regex filters. Examples of database resources are tables, views, and stored
// procedures.
type GooglePrivacyDlpV2DatabaseResourceCollection struct {
	// IncludeRegexes: A collection of regular expressions to match a database
	// resource against.
	IncludeRegexes *GooglePrivacyDlpV2DatabaseResourceRegexes `json:"includeRegexes,omitempty"`
	// ForceSendFields is a list of field names (e.g. "IncludeRegexes") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "IncludeRegexes") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GooglePrivacyDlpV2DatabaseResourceCollection) MarshalJSON() ([]byte, error) {
	type NoMethod GooglePrivacyDlpV2DatabaseResourceCollection
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GooglePrivacyDlpV2DatabaseResourceReference: Identifies a single database
// resource, like a table within a database.
type GooglePrivacyDlpV2DatabaseResourceReference struct {
	// Database: Required. Name of a database within the instance.
	Database string `json:"database,omitempty"`
	// DatabaseResource: Required. Name of a database resource, for example, a
	// table within the database.
	DatabaseResource string `json:"databaseResource,omitempty"`
	// Instance: Required. The instance where this resource is located. For
	// example: Cloud SQL instance ID.
	Instance string `json:"instance,omitempty"`
	// ProjectId: Required. If within a project-level config, then this must match
	// the config's project ID.
	ProjectId string `json:"projectId,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Database") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Database") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GooglePrivacyDlpV2DatabaseResourceReference) MarshalJSON() ([]byte, error) {
	type NoMethod GooglePrivacyDlpV2DatabaseResourceReference
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GooglePrivacyDlpV2DatabaseResourceRegex: A pattern to match against one or
// more database resources. At least one pattern must be specified. Regular
// expressions use RE2 syntax (https://github.com/google/re2/wiki/Syntax); a
// guide can be found under the google/re2 repository on GitHub.
type GooglePrivacyDlpV2DatabaseResourceRegex struct {
	// DatabaseRegex: Regex to test the database name against. If empty, all
	// databases match.
	DatabaseRegex string `json:"databaseRegex,omitempty"`
	// DatabaseResourceNameRegex: Regex to test the database resource's name
	// against. An example of a database resource name is a table's name. Other
	// database resource names like view names could be included in the future. If
	// empty, all database resources match.
	DatabaseResourceNameRegex string `json:"databaseResourceNameRegex,omitempty"`
	// InstanceRegex: Regex to test the instance name against. If empty, all
	// instances match.
	InstanceRegex string `json:"instanceRegex,omitempty"`
	// ProjectIdRegex: For organizations, if unset, will match all projects. Has no
	// effect for configurations created within a project.
	ProjectIdRegex string `json:"projectIdRegex,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DatabaseRegex") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DatabaseRegex") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GooglePrivacyDlpV2DatabaseResourceRegex) MarshalJSON() ([]byte, error) {
	type NoMethod GooglePrivacyDlpV2DatabaseResourceRegex
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GooglePrivacyDlpV2DatabaseResourceRegexes: A collection of regular
// expressions to determine what database resources to match against.
type GooglePrivacyDlpV2DatabaseResourceRegexes struct {
	// Patterns: A group of regular expression patterns to match against one or
	// more database resources. Maximum of 100 entries. The sum of all regular
	// expression's length can't exceed 10 KiB.
	Patterns []*GooglePrivacyDlpV2DatabaseResourceRegex `json:"patterns,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Patterns") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Patterns") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GooglePrivacyDlpV2DatabaseResourceRegexes) MarshalJSON() ([]byte, error) {
	type NoMethod GooglePrivacyDlpV2DatabaseResourceRegexes
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GooglePrivacyDlpV2DatastoreKey: Record key for a finding in Cloud Datastore.
type GooglePrivacyDlpV2DatastoreKey struct {
	// EntityKey: Datastore entity key.
	EntityKey *GooglePrivacyDlpV2Key `json:"entityKey,omitempty"`
	// ForceSendFields is a list of field names (e.g. "EntityKey") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "EntityKey") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GooglePrivacyDlpV2DatastoreKey) MarshalJSON() ([]byte, error) {
	type NoMethod GooglePrivacyDlpV2DatastoreKey
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GooglePrivacyDlpV2DatastoreOptions: Options defining a data set within
// Google Cloud Datastore.
type GooglePrivacyDlpV2DatastoreOptions struct {
	// Kind: The kind to process.
	Kind *GooglePrivacyDlpV2KindExpression `json:"kind,omitempty"`
	// PartitionId: A partition ID identifies a grouping of entities. The grouping
	// is always by project and namespace, however the namespace ID may be empty.
	PartitionId *GooglePrivacyDlpV2PartitionId `json:"partitionId,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Kind") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Kind") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GooglePrivacyDlpV2DatastoreOptions) MarshalJSON() ([]byte, error) {
	type NoMethod GooglePrivacyDlpV2DatastoreOptions
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GooglePrivacyDlpV2DateShiftConfig: Shifts dates by random number of days,
// with option to be consistent for the same context. See
// https://cloud.google.com/sensitive-data-protection/docs/concepts-date-shifting
// to learn more.
type GooglePrivacyDlpV2DateShiftConfig struct {
	// Context: Points to the field that contains the context, for example, an
	// entity id. If set, must also set cryptoKey. If set, shift will be consistent
	// for the given context.
	Context *GooglePrivacyDlpV2FieldId `json:"context,omitempty"`
	// CryptoKey: Causes the shift to be computed based on this key and the
	// context. This results in the same shift for the same context and crypto_key.
	// If set, must also set context. Can only be applied to table items.
	CryptoKey *GooglePrivacyDlpV2CryptoKey `json:"cryptoKey,omitempty"`
	// LowerBoundDays: Required. For example, -5 means shift date to at most 5 days
	// back in the past.
	LowerBoundDays int64 `json:"lowerBoundDays,omitempty"`
	// UpperBoundDays: Required. Range of shift in days. Actual shift will be
	// selected at random within this range (inclusive ends). Negative means shift
	// to earlier in time. Must not be more than 365250 days (1000 years) each
	// direction. For example, 3 means shift date to at most 3 days into the
	// future.
	UpperBoundDays int64 `json:"upperBoundDays,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Context") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Context") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GooglePrivacyDlpV2DateShiftConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GooglePrivacyDlpV2DateShiftConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GooglePrivacyDlpV2DateTime: Message for a date time object. e.g. 2018-01-01,
// 5th August.
type GooglePrivacyDlpV2DateTime struct {
	// Date: One or more of the following must be set. Must be a valid date or time
	// value.
	Date *GoogleTypeDate `json:"date,omitempty"`
	// DayOfWeek: Day of week
	//
	// Possible values:
	//   "DAY_OF_WEEK_UNSPECIFIED" - The day of the week is unspecified.
	//   "MONDAY" - Monday
	//   "TUESDAY" - Tuesday
	//   "WEDNESDAY" - Wednesday
	//   "THURSDAY" - Thursday
	//   "FRIDAY" - Friday
	//   "SATURDAY" - Saturday
	//   "SUNDAY" - Sunday
	DayOfWeek string `json:"dayOfWeek,omitempty"`
	// Time: Time of day
	Time *GoogleTypeTimeOfDay `json:"time,omitempty"`
	// TimeZone: Time zone
	TimeZone *GooglePrivacyDlpV2TimeZone `json:"timeZone,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Date") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Date") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GooglePrivacyDlpV2DateTime) MarshalJSON() ([]byte, error) {
	type NoMethod GooglePrivacyDlpV2DateTime
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GooglePrivacyDlpV2Deidentify: Create a de-identified copy of a storage
// bucket. Only compatible with Cloud Storage buckets. A TransformationDetail
// will be created for each transformation. Compatible with: Inspection of
// Cloud Storage
type GooglePrivacyDlpV2Deidentify struct {
	// CloudStorageOutput: Required. User settable Cloud Storage bucket and folders
	// to store de-identified files. This field must be set for Cloud Storage
	// deidentification. The output Cloud Storage bucket must be different from the
	// input bucket. De-identified files will overwrite files in the output path.
	// Form of: gs://bucket/folder/ or gs://bucket
	CloudStorageOutput string `json:"cloudStorageOutput,omitempty"`
	// FileTypesToTransform: List of user-specified file type groups to transform.
	// If specified, only the files with these file types are transformed. If
	// empty, all supported files are transformed. Supported types may be
	// automatically added over time. Any unsupported file types that are set in
	// this field are excluded from de-identification. An error is recorded for
	// each unsupported file in the TransformationDetails output table. Currently
	// the only file types supported are: IMAGES, TEXT_FILES, CSV, TSV.
	//
	// Possible values:
	//   "FILE_TYPE_UNSPECIFIED" - Includes all files.
	//   "BINARY_FILE" - Includes all file extensions not covered by another entry.
	// Binary scanning attempts to convert the content of the file to utf_8 to scan
	// the file. If you wish to avoid this fall back, specify one or more of the
	// other file types in your storage scan.
	//   "TEXT_FILE" - Included file extensions: asc,asp, aspx, brf, c, cc,cfm,
	// cgi, cpp, csv, cxx, c++, cs, css, dart, dat, dot, eml,, epbub, ged, go, h,
	// hh, hpp, hxx, h++, hs, html, htm, mkd, markdown, m, ml, mli, perl, pl,
	// plist, pm, php, phtml, pht, properties, py, pyw, rb, rbw, rs, rss, rc,
	// scala, sh, sql, swift, tex, shtml, shtm, xhtml, lhs, ics, ini, java, js,
	// json, jsonl, kix, kml, ocaml, md, txt, text, tsv, vb, vcard, vcs, wml,
	// xcodeproj, xml, xsl, xsd, yml, yaml.
	//   "IMAGE" - Included file extensions: bmp, gif, jpg, jpeg, jpe, png. Setting
	// bytes_limit_per_file or bytes_limit_per_file_percent has no effect on image
	// files. Image inspection is restricted to the `global`, `us`, `asia`, and
	// `europe` regions.
	//   "WORD" - Microsoft Word files larger than 30 MB will be scanned as binary
	// files. Included file extensions: docx, dotx, docm, dotm. Setting
	// `bytes_limit_per_file` or `bytes_limit_per_file_percent` has no effect on
	// Word files.
	//   "PDF" - PDF files larger than 30 MB will be scanned as binary files.
	// Included file extensions: pdf. Setting `bytes_limit_per_file` or
	// `bytes_limit_per_file_percent` has no effect on PDF files.
	//   "AVRO" - Included file extensions: avro
	//   "CSV" - Included file extensions: csv
	//   "TSV" - Included file extensions: tsv
	//   "POWERPOINT" - Microsoft PowerPoint files larger than 30 MB will be
	// scanned as binary files. Included file extensions: pptx, pptm, potx, potm,
	// pot. Setting `bytes_limit_per_file` or `bytes_limit_per_file_percent` has no
	// effect on PowerPoint files.
	//   "EXCEL" - Microsoft Excel files larger than 30 MB will be scanned as
	// binary files. Included file extensions: xlsx, xlsm, xltx, xltm. Setting
	// `bytes_limit_per_file` or `bytes_limit_per_file_percent` has no effect on
	// Excel files.
	FileTypesToTransform []string `json:"fileTypesToTransform,omitempty"`
	// TransformationConfig: User specified deidentify templates and configs for
	// structured, unstructured, and image files.
	TransformationConfig *GooglePrivacyDlpV2TransformationConfig `json:"transformationConfig,omitempty"`
	// TransformationDetailsStorageConfig: Config for storing transformation
	// details. This field specifies the configuration for storing detailed
	// metadata about each transformation performed during a de-identification
	// process. The metadata is stored separately from the de-identified content
	// itself and provides a granular record of both successful transformations and
	// any failures that occurred. Enabling this configuration is essential for
	// users who need to access comprehensive information about the status,
	// outcome, and specifics of each transformation. The details are captured in
	// the TransformationDetails message for each operation. Key use cases: *
	// **Auditing and compliance** * Provides a verifiable audit trail of
	// de-identification activities, which is crucial for meeting regulatory
	// requirements and internal data governance policies. * Logs what data was
	// transformed, what transformations were applied, when they occurred, and
	// their success status. This helps demonstrate accountability and due
	// diligence in protecting sensitive data. * **Troubleshooting and debugging**
	// * Offers detailed error messages and context if a transformation fails. This
	// information is useful for diagnosing and resolving issues in the
	// de-identification pipeline. * Helps pinpoint the exact location and nature
	// of failures, speeding up the debugging process. * **Process verification and
	// quality assurance** * Allows users to confirm that de-identification rules
	// and transformations were applied correctly and consistently across the
	// dataset as intended. * Helps in verifying the effectiveness of the chosen
	// de-identification strategies. * **Data lineage and impact analysis** *
	// Creates a record of how data elements were modified, contributing to data
	// lineage. This is useful for understanding the provenance of de-identified
	// data. * Aids in assessing the potential impact of de-identification choices
	// on downstream analytical processes or data usability. * **Reporting and
	// operational insights** * You can analyze the metadata stored in a queryable
	// BigQuery table to generate reports on transformation success rates, common
	// error types, processing volumes (e.g., transformedBytes), and the types of
	// transformations applied. * These insights can inform optimization of
	// de-identification configurations and resource planning. To take advantage of
	// these benefits, set this configuration. The stored details include a
	// description of the transformation, success or error codes, error messages,
	// the number of bytes transformed, the location of the transformed content,
	// and identifiers for the job and source data.
	TransformationDetailsStorageConfig *GooglePrivacyDlpV2TransformationDetailsStorageConfig `json:"transformationDetailsStorageConfig,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CloudStorageOutput") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CloudStorageOutput") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GooglePrivacyDlpV2Deidentify) MarshalJSON() ([]byte, error) {
	type NoMethod GooglePrivacyDlpV2Deidentify
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GooglePrivacyDlpV2DeidentifyConfig: The configuration that controls how the
// data will change.
type GooglePrivacyDlpV2DeidentifyConfig struct {
	// ImageTransformations: Treat the dataset as an image and redact.
	ImageTransformations *GooglePrivacyDlpV2ImageTransformations `json:"imageTransformations,omitempty"`
	// InfoTypeTransformations: Treat the dataset as free-form text and apply the
	// same free text transformation everywhere.
	InfoTypeTransformations *GooglePrivacyDlpV2InfoTypeTransformations `json:"infoTypeTransformations,omitempty"`
	// RecordTransformations: Treat the dataset as structured. Transformations can
	// be applied to specific locations within structured datasets, such as
	// transforming a column within a table.
	RecordTransformations *GooglePrivacyDlpV2RecordTransformations `json:"recordTransformations,omitempty"`
	// TransformationErrorHandling: Mode for handling transformation errors. If
	// left unspecified, the default mode is
	// `TransformationErrorHandling.ThrowError`.
	TransformationErrorHandling *GooglePrivacyDlpV2TransformationErrorHandling `json:"transformationErrorHandling,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ImageTransformations") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ImageTransformations") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GooglePrivacyDlpV2DeidentifyConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GooglePrivacyDlpV2DeidentifyConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GooglePrivacyDlpV2DeidentifyContentRequest: Request to de-identify a
// ContentItem.
type GooglePrivacyDlpV2DeidentifyContentRequest struct {
	// DeidentifyConfig: Configuration for the de-identification of the content
	// item. Items specified here will override the template referenced by the
	// deidentify_template_name argument.
	DeidentifyConfig *GooglePrivacyDlpV2DeidentifyConfig `json:"deidentifyConfig,omitempty"`
	// DeidentifyTemplateName: Template to use. Any configuration directly
	// specified in deidentify_config will override those set in the template.
	// Singular fields that are set in this request will replace their
	// corresponding fields in the template. Repeated fields are appended. Singular
	// sub-messages and groups are recursively merged.
	DeidentifyTemplateName string `json:"deidentifyTemplateName,omitempty"`
	// InspectConfig: Configuration for the inspector. Items specified here will
	// override the template referenced by the inspect_template_name argument.
	InspectConfig *GooglePrivacyDlpV2InspectConfig `json:"inspectConfig,omitempty"`
	// InspectTemplateName: Template to use. Any configuration directly specified
	// in inspect_config will override those set in the template. Singular fields
	// that are set in this request will replace their corresponding fields in the
	// template. Repeated fields are appended. Singular sub-messages and groups are
	// recursively merged.
	InspectTemplateName string `json:"inspectTemplateName,omitempty"`
	// Item: The item to de-identify. Will be treated as text. This value must be
	// of type Table if your deidentify_config is a RecordTransformations object.
	Item *GooglePrivacyDlpV2ContentItem `json:"item,omitempty"`
	// LocationId: Deprecated. This field has no effect.
	LocationId string `json:"locationId,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DeidentifyConfig") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DeidentifyConfig") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GooglePrivacyDlpV2DeidentifyContentRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GooglePrivacyDlpV2DeidentifyContentRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GooglePrivacyDlpV2DeidentifyContentResponse: Results of de-identifying a
// ContentItem.
type GooglePrivacyDlpV2DeidentifyContentResponse struct {
	// Item: The de-identified item.
	Item *GooglePrivacyDlpV2ContentItem `json:"item,omitempty"`
	// Overview: An overview of the changes that were made on the `item`.
	Overview *GooglePrivacyDlpV2TransformationOverview `json:"overview,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Item") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Item") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GooglePrivacyDlpV2DeidentifyContentResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GooglePrivacyDlpV2DeidentifyContentResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GooglePrivacyDlpV2DeidentifyDataSourceDetails: The results of a Deidentify
// action from an inspect job.
type GooglePrivacyDlpV2DeidentifyDataSourceDetails struct {
	// DeidentifyStats: Stats about the de-identification operation.
	DeidentifyStats *GooglePrivacyDlpV2DeidentifyDataSourceStats `json:"deidentifyStats,omitempty"`
	// RequestedOptions: De-identification config used for the request.
	RequestedOptions *GooglePrivacyDlpV2RequestedDeidentifyOptions `json:"requestedOptions,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DeidentifyStats") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DeidentifyStats") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GooglePrivacyDlpV2DeidentifyDataSourceDetails) MarshalJSON() ([]byte, error) {
	type NoMethod GooglePrivacyDlpV2DeidentifyDataSourceDetails
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GooglePrivacyDlpV2DeidentifyDataSourceStats: Summary of what was modified
// during a transformation.
type GooglePrivacyDlpV2DeidentifyDataSourceStats struct {
	// TransformationCount: Number of successfully applied transformations.
	TransformationCount int64 `json:"transformationCount,omitempty,string"`
	// TransformationErrorCount: Number of errors encountered while trying to apply
	// transformations.
	TransformationErrorCount int64 `json:"transformationErrorCount,omitempty,string"`
	// TransformedBytes: Total size in bytes that were transformed in some way.
	TransformedBytes int64 `json:"transformedBytes,omitempty,string"`
	// ForceSendFields is a list of field names (e.g. "TransformationCount") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "TransformationCount") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GooglePrivacyDlpV2DeidentifyDataSourceStats) MarshalJSON() ([]byte, error) {
	type NoMethod GooglePrivacyDlpV2DeidentifyDataSourceStats
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GooglePrivacyDlpV2DeidentifyTemplate: DeidentifyTemplates contains
// instructions on how to de-identify content. See
// https://cloud.google.com/sensitive-data-protection/docs/concepts-templates
// to learn more.
type GooglePrivacyDlpV2DeidentifyTemplate struct {
	// CreateTime: Output only. The creation timestamp of an inspectTemplate.
	CreateTime string `json:"createTime,omitempty"`
	// DeidentifyConfig: The core content of the template.
	DeidentifyConfig *GooglePrivacyDlpV2DeidentifyConfig `json:"deidentifyConfig,omitempty"`
	// Description: Short description (max 256 chars).
	Description string `json:"description,omitempty"`
	// DisplayName: Display name (max 256 chars).
	DisplayName string `json:"displayName,omitempty"`
	// Name: Output only. The template name. The template will have one of the
	// following formats: `projects/PROJECT_ID/deidentifyTemplates/TEMPLATE_ID` OR
	// `organizations/ORGANIZATION_ID/deidentifyTemplates/TEMPLATE_ID`
	Name string `json:"name,omitempty"`
	// UpdateTime: Output only. The last update timestamp of an inspectTemplate.
	UpdateTime string `json:"updateTime,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "CreateTime") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CreateTime") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GooglePrivacyDlpV2DeidentifyTemplate) MarshalJSON() ([]byte, error) {
	type NoMethod GooglePrivacyDlpV2DeidentifyTemplate
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GooglePrivacyDlpV2DeltaPresenceEstimationConfig: δ-presence metric, used to
// estimate how likely it is for an attacker to figure out that one given
// individual appears in a de-identified dataset. Similarly to the k-map
// metric, we cannot compute δ-presence exactly without knowing the attack
// dataset, so we use a statistical model instead.
type GooglePrivacyDlpV2DeltaPresenceEstimationConfig struct {
	// AuxiliaryTables: Several auxiliary tables can be used in the analysis. Each
	// custom_tag used to tag a quasi-identifiers field must appear in exactly one
	// field of one auxiliary table.
	AuxiliaryTables []*GooglePrivacyDlpV2StatisticalTable `json:"auxiliaryTables,omitempty"`
	// QuasiIds: Required. Fields considered to be quasi-identifiers. No two fields
	// can have the same tag.
	QuasiIds []*GooglePrivacyDlpV2QuasiId `json:"quasiIds,omitempty"`
	// RegionCode: ISO 3166-1 alpha-2 region code to use in the statistical
	// modeling. Set if no column is tagged with a region-specific InfoType (like
	// US_ZIP_5) or a region code.
	RegionCode string `json:"regionCode,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AuxiliaryTables") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AuxiliaryTables") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GooglePrivacyDlpV2DeltaPresenceEstimationConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GooglePrivacyDlpV2DeltaPresenceEstimationConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GooglePrivacyDlpV2DeltaPresenceEstimationHistogramBucket: A
// DeltaPresenceEstimationHistogramBucket message with the following values:
// min_probability: 0.1 max_probability: 0.2 frequency: 42 means that there are
// 42 records for which δ is in [0.1, 0.2). An important particular case is
// when min_probability = max_probability = 1: then, every individual who
// shares this quasi-identifier combination is in the dataset.
type GooglePrivacyDlpV2DeltaPresenceEstimationHistogramBucket struct {
	// BucketSize: Number of records within these probability bounds.
	BucketSize int64 `json:"bucketSize,omitempty,string"`
	// BucketValueCount: Total number of distinct quasi-identifier tuple values in
	// this bucket.
	BucketValueCount int64 `json:"bucketValueCount,omitempty,string"`
	// BucketValues: Sample of quasi-identifier tuple values in this bucket. The
	// total number of classes returned per bucket is capped at 20.
	BucketValues []*GooglePrivacyDlpV2DeltaPresenceEstimationQuasiIdValues `json:"bucketValues,omitempty"`
	// MaxProbability: Always greater than or equal to min_probability.
	MaxProbability float64 `json:"maxProbability,omitempty"`
	// MinProbability: Between 0 and 1.
	MinProbability float64 `json:"minProbability,omitempty"`
	// ForceSendFields is a list of field names (e.g. "BucketSize") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "BucketSize") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GooglePrivacyDlpV2DeltaPresenceEstimationHistogramBucket) MarshalJSON() ([]byte, error) {
	type NoMethod GooglePrivacyDlpV2DeltaPresenceEstimationHistogramBucket
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *GooglePrivacyDlpV2DeltaPresenceEstimationHistogramBucket) UnmarshalJSON(data []byte) error {
	type NoMethod GooglePrivacyDlpV2DeltaPresenceEstimationHistogramBucket
	var s1 struct {
		MaxProbability gensupport.JSONFloat64 `json:"maxProbability"`
		MinProbability gensupport.JSONFloat64 `json:"minProbability"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.MaxProbability = float64(s1.MaxProbability)
	s.MinProbability = float64(s1.MinProbability)
	return nil
}

// GooglePrivacyDlpV2DeltaPresenceEstimationQuasiIdValues: A tuple of values
// for the quasi-identifier columns.
type GooglePrivacyDlpV2DeltaPresenceEstimationQuasiIdValues struct {
	// EstimatedProbability: The estimated probability that a given individual
	// sharing these quasi-identifier values is in the dataset. This value,
	// typically called δ, is the ratio between the number of records in the
	// dataset with these quasi-identifier values, and the total number of
	// individuals (inside *and* outside the dataset) with these quasi-identifier
	// values. For example, if there are 15 individuals in the dataset who share
	// the same quasi-identifier values, and an estimated 100 people in the entire
	// population with these values, then δ is 0.15.
	EstimatedProbability float64 `json:"estimatedProbability,omitempty"`
	// QuasiIdsValues: The quasi-identifier values.
	QuasiIdsValues []*GooglePrivacyDlpV2Value `json:"quasiIdsValues,omitempty"`
	// ForceSendFields is a list of field names (e.g. "EstimatedProbability") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "EstimatedProbability") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GooglePrivacyDlpV2DeltaPresenceEstimationQuasiIdValues) MarshalJSON() ([]byte, error) {
	type NoMethod GooglePrivacyDlpV2DeltaPresenceEstimationQuasiIdValues
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *GooglePrivacyDlpV2DeltaPresenceEstimationQuasiIdValues) UnmarshalJSON(data []byte) error {
	type NoMethod GooglePrivacyDlpV2DeltaPresenceEstimationQuasiIdValues
	var s1 struct {
		EstimatedProbability gensupport.JSONFloat64 `json:"estimatedProbability"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.EstimatedProbability = float64(s1.EstimatedProbability)
	return nil
}

// GooglePrivacyDlpV2DeltaPresenceEstimationResult: Result of the δ-presence
// computation. Note that these results are an estimation, not exact values.
type GooglePrivacyDlpV2DeltaPresenceEstimationResult struct {
	// DeltaPresenceEstimationHistogram: The intervals [min_probability,
	// max_probability) do not overlap. If a value doesn't correspond to any such
	// interval, the associated frequency is zero. For example, the following
	// records: {min_probability: 0, max_probability: 0.1, frequency: 17}
	// {min_probability: 0.2, max_probability: 0.3, frequency: 42}
	// {min_probability: 0.3, max_probability: 0.4, frequency: 99} mean that there
	// are no record with an estimated probability in [0.1, 0.2) nor larger or
	// equal to 0.4.
	DeltaPresenceEstimationHistogram []*GooglePrivacyDlpV2DeltaPresenceEstimationHistogramBucket `json:"deltaPresenceEstimationHistogram,omitempty"`
	// ForceSendFields is a list of field names (e.g.
	// "DeltaPresenceEstimationHistogram") to unconditionally include in API
	// requests. By default, fields with empty or default values are omitted from
	// API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g.
	// "DeltaPresenceEstimationHistogram") to include in API requests with the JSON
	// null value. By default, fields with empty values are omitted from API
	// requests. See https://pkg.go.dev/google.golang.org/api#hdr-NullFields for
	// more details.
	NullFields []string `json:"-"`
}

func (s GooglePrivacyDlpV2DeltaPresenceEstimationResult) MarshalJSON() ([]byte, error) {
	type NoMethod GooglePrivacyDlpV2DeltaPresenceEstimationResult
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GooglePrivacyDlpV2DetectionRule: Deprecated; use `InspectionRuleSet`
// instead. Rule for modifying a `CustomInfoType` to alter behavior under
// certain circumstances, depending on the specific details of the rule. Not
// supported for the `surrogate_type` custom infoType.
type GooglePrivacyDlpV2DetectionRule struct {
	// HotwordRule: Hotword-based detection rule.
	HotwordRule *GooglePrivacyDlpV2HotwordRule `json:"hotwordRule,omitempty"`
	// ForceSendFields is a list of field names (e.g. "HotwordRule") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "HotwordRule") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GooglePrivacyDlpV2DetectionRule) MarshalJSON() ([]byte, error) {
	type NoMethod GooglePrivacyDlpV2DetectionRule
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GooglePrivacyDlpV2Dictionary: Custom information type based on a dictionary
// of words or phrases. This can be used to match sensitive information
// specific to the data, such as a list of employee IDs or job titles.
// Dictionary words are case-insensitive and all characters other than letters
// and digits in the unicode Basic Multilingual Plane
// (https://en.wikipedia.org/wiki/Plane_%28Unicode%29#Basic_Multilingual_Plane)
// will be replaced with whitespace when scanning for matches, so the
// dictionary phrase "Sam Johnson" will match all three phrases "sam johnson",
// "Sam, Johnson", and "Sam (Johnson)". Additionally, the characters
// surrounding any match must be of a different type than the adjacent
// characters within the word, so letters must be next to non-letters and
// digits next to non-digits. For example, the dictionary word "jen" will match
// the first three letters of the text "jen123" but will return no matches for
// "jennifer". Dictionary words containing a large number of characters that
// are not letters or digits may result in unexpected findings because such
// characters are treated as whitespace. The limits
// (https://cloud.google.com/sensitive-data-protection/limits) page contains
// details about the size limits of dictionaries. For dictionaries that do not
// fit within these constraints, consider using `LargeCustomDictionaryConfig`
// in the `StoredInfoType` API.
type GooglePrivacyDlpV2Dictionary struct {
	// CloudStoragePath: Newline-delimited file of words in Cloud Storage. Only a
	// single file is accepted.
	CloudStoragePath *GooglePrivacyDlpV2CloudStoragePath `json:"cloudStoragePath,omitempty"`
	// WordList: List of words or phrases to search for.
	WordList *GooglePrivacyDlpV2WordList `json:"wordList,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CloudStoragePath") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CloudStoragePath") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GooglePrivacyDlpV2Dictionary) MarshalJSON() ([]byte, error) {
	type NoMethod GooglePrivacyDlpV2Dictionary
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GooglePrivacyDlpV2Disabled: Do not profile the tables.
type GooglePrivacyDlpV2Disabled struct {
}

// GooglePrivacyDlpV2DiscoveryBigQueryConditions: Requirements that must be
// true before a table is scanned in discovery for the first time. There is an
// AND relationship between the top-level attributes. Additionally, minimum
// conditions with an OR relationship that must be met before Cloud DLP scans a
// table can be set (like a minimum row count or a minimum table age).
type GooglePrivacyDlpV2DiscoveryBigQueryConditions struct {
	// CreatedAfter: BigQuery table must have been created after this date. Used to
	// avoid backfilling.
	CreatedAfter string `json:"createdAfter,omitempty"`
	// OrConditions: At least one of the conditions must be true for a table to be
	// scanned.
	OrConditions *GooglePrivacyDlpV2OrConditions `json:"orConditions,omitempty"`
	// TypeCollection: Restrict discovery to categories of table types.
	//
	// Possible values:
	//   "BIG_QUERY_COLLECTION_UNSPECIFIED" - Unused.
	//   "BIG_QUERY_COLLECTION_ALL_TYPES" - Automatically generate profiles for all
	// tables, even if the table type is not yet fully supported for analysis.
	// Profiles for unsupported tables will be generated with errors to indicate
	// their partial support. When full support is added, the tables will
	// automatically be profiled during the next scheduled run.
	//   "BIG_QUERY_COLLECTION_ONLY_SUPPORTED_TYPES" - Only those types fully
	// supported will be profiled. Will expand automatically as Cloud DLP adds
	// support for new table types. Unsupported table types will not have partial
	// profiles generated.
	TypeCollection string `json:"typeCollection,omitempty"`
	// Types: Restrict discovery to specific table types.
	Types *GooglePrivacyDlpV2BigQueryTableTypes `json:"types,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CreatedAfter") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CreatedAfter") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GooglePrivacyDlpV2DiscoveryBigQueryConditions) MarshalJSON() ([]byte, error) {
	type NoMethod GooglePrivacyDlpV2DiscoveryBigQueryConditions
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GooglePrivacyDlpV2DiscoveryBigQueryFilter: Determines what tables will have
// profiles generated within an organization or project. Includes the ability
// to filter by regular expression patterns on project ID, dataset ID, and
// table ID.
type GooglePrivacyDlpV2DiscoveryBigQueryFilter struct {
	// OtherTables: Catch-all. This should always be the last filter in the list
	// because anything above it will apply first. Should only appear once in a
	// configuration. If none is specified, a default one will be added
	// automatically.
	OtherTables *GooglePrivacyDlpV2AllOtherBigQueryTables `json:"otherTables,omitempty"`
	// TableReference: The table to scan. Discovery configurations including this
	// can only include one DiscoveryTarget (the DiscoveryTarget with this
	// TableReference).
	TableReference *GooglePrivacyDlpV2TableReference `json:"tableReference,omitempty"`
	// Tables: A specific set of tables for this filter to apply to. A table
	// collection must be specified in only one filter per config. If a table id or
	// dataset is empty, Cloud DLP assumes all tables in that collection must be
	// profiled. Must specify a project ID.
	Tables *GooglePrivacyDlpV2BigQueryTableCollection `json:"tables,omitempty"`
	// ForceSendFields is a list of field names (e.g. "OtherTables") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "OtherTables") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GooglePrivacyDlpV2DiscoveryBigQueryFilter) MarshalJSON() ([]byte, error) {
	type NoMethod GooglePrivacyDlpV2DiscoveryBigQueryFilter
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GooglePrivacyDlpV2DiscoveryCloudSqlConditions: Requirements that must be
// true before a table is profiled for the first time.
type GooglePrivacyDlpV2DiscoveryCloudSqlConditions struct {
	// DatabaseEngines: Optional. Database engines that should be profiled.
	// Optional. Defaults to ALL_SUPPORTED_DATABASE_ENGINES if unspecified.
	//
	// Possible values:
	//   "DATABASE_ENGINE_UNSPECIFIED" - Unused.
	//   "ALL_SUPPORTED_DATABASE_ENGINES" - Include all supported database engines.
	//   "MYSQL" - MySQL database.
	//   "POSTGRES" - PostgreSQL database.
	DatabaseEngines []string `json:"databaseEngines,omitempty"`
	// Types: Data profiles will only be generated for the database resource types
	// specified in this field. If not specified, defaults to
	// [DATABASE_RESOURCE_TYPE_ALL_SUPPORTED_TYPES].
	//
	// Possible values:
	//   "DATABASE_RESOURCE_TYPE_UNSPECIFIED" - Unused.
	//   "DATABASE_RESOURCE_TYPE_ALL_SUPPORTED_TYPES" - Includes database resource
	// types that become supported at a later time.
	//   "DATABASE_RESOURCE_TYPE_TABLE" - Tables.
	Types []string `json:"types,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DatabaseEngines") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DatabaseEngines") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GooglePrivacyDlpV2DiscoveryCloudSqlConditions) MarshalJSON() ([]byte, error) {
	type NoMethod GooglePrivacyDlpV2DiscoveryCloudSqlConditions
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GooglePrivacyDlpV2DiscoveryCloudSqlFilter: Determines what tables will have
// profiles generated within an organization or project. Includes the ability
// to filter by regular expression patterns on project ID, location, instance,
// database, and database resource name.
type GooglePrivacyDlpV2DiscoveryCloudSqlFilter struct {
	// Collection: A specific set of database resources for this filter to apply
	// to.
	Collection *GooglePrivacyDlpV2DatabaseResourceCollection `json:"collection,omitempty"`
	// DatabaseResourceReference: The database resource to scan. Targets including
	// this can only include one target (the target with this database resource
	// reference).
	DatabaseResourceReference *GooglePrivacyDlpV2DatabaseResourceReference `json:"databaseResourceReference,omitempty"`
	// Others: Catch-all. This should always be the last target in the list because
	// anything above it will apply first. Should only appear once in a
	// configuration. If none is specified, a default one will be added
	// automatically.
	Others *GooglePrivacyDlpV2AllOtherDatabaseResources `json:"others,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Collection") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Collection") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GooglePrivacyDlpV2DiscoveryCloudSqlFilter) MarshalJSON() ([]byte, error) {
	type NoMethod GooglePrivacyDlpV2DiscoveryCloudSqlFilter
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GooglePrivacyDlpV2DiscoveryCloudSqlGenerationCadence: How often existing
// tables should have their profiles refreshed. New tables are scanned as
// quickly as possible depending on system capacity.
type GooglePrivacyDlpV2DiscoveryCloudSqlGenerationCadence struct {
	// InspectTemplateModifiedCadence: Governs when to update data profiles when
	// the inspection rules defined by the `InspectTemplate` change. If not set,
	// changing the template will not cause a data profile to update.
	InspectTemplateModifiedCadence *GooglePrivacyDlpV2DiscoveryInspectTemplateModifiedCadence `json:"inspectTemplateModifiedCadence,omitempty"`
	// RefreshFrequency: Data changes (non-schema changes) in Cloud SQL tables
	// can't trigger reprofiling. If you set this field, profiles are refreshed at
	// this frequency regardless of whether the underlying tables have changed.
	// Defaults to never.
	//
	// Possible values:
	//   "UPDATE_FREQUENCY_UNSPECIFIED" - Unspecified.
	//   "UPDATE_FREQUENCY_NEVER" - After the data profile is created, it will
	// never be updated.
	//   "UPDATE_FREQUENCY_DAILY" - The data profile can be updated up to once
	// every 24 hours.
	//   "UPDATE_FREQUENCY_MONTHLY" - The data profile can be updated up to once
	// every 30 days. Default.
	RefreshFrequency string `json:"refreshFrequency,omitempty"`
	// SchemaModifiedCadence: When to reprofile if the schema has changed.
	SchemaModifiedCadence *GooglePrivacyDlpV2SchemaModifiedCadence `json:"schemaModifiedCadence,omitempty"`
	// ForceSendFields is a list of field names (e.g.
	// "InspectTemplateModifiedCadence") to unconditionally include in API
	// requests. By default, fields with empty or default values are omitted from
	// API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "InspectTemplateModifiedCadence")
	// to include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GooglePrivacyDlpV2DiscoveryCloudSqlGenerationCadence) MarshalJSON() ([]byte, error) {
	type NoMethod GooglePrivacyDlpV2DiscoveryCloudSqlGenerationCadence
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GooglePrivacyDlpV2DiscoveryCloudStorageConditions: Requirements that must be
// true before a Cloud Storage bucket or object is scanned in discovery for the
// first time. There is an AND relationship between the top-level attributes.
type GooglePrivacyDlpV2DiscoveryCloudStorageConditions struct {
	// IncludedBucketAttributes: Required. Only objects with the specified
	// attributes will be scanned. Defaults to [ALL_SUPPORTED_BUCKETS] if unset.
	//
	// Possible values:
	//   "CLOUD_STORAGE_BUCKET_ATTRIBUTE_UNSPECIFIED" - Unused.
	//   "ALL_SUPPORTED_BUCKETS" - Scan buckets regardless of the attribute.
	//   "AUTOCLASS_DISABLED" - Buckets with
	// [Autoclass](https://cloud.google.com/storage/docs/autoclass) disabled. Only
	// one of AUTOCLASS_DISABLED or AUTOCLASS_ENABLED should be set.
	//   "AUTOCLASS_ENABLED" - Buckets with
	// [Autoclass](https://cloud.google.com/storage/docs/autoclass) enabled. Only
	// one of AUTOCLASS_DISABLED or AUTOCLASS_ENABLED should be set. Scanning
	// Autoclass-enabled buckets can affect object storage classes.
	IncludedBucketAttributes []string `json:"includedBucketAttributes,omitempty"`
	// IncludedObjectAttributes: Required. Only objects with the specified
	// attributes will be scanned. If an object has one of the specified attributes
	// but is inside an excluded bucket, it will not be scanned. Defaults to
	// [ALL_SUPPORTED_OBJECTS]. A profile will be created even if no objects match
	// the included_object_attributes.
	//
	// Possible values:
	//   "CLOUD_STORAGE_OBJECT_ATTRIBUTE_UNSPECIFIED" - Unused.
	//   "ALL_SUPPORTED_OBJECTS" - Scan objects regardless of the attribute.
	//   "STANDARD" - Scan objects with the standard storage class.
	//   "NEARLINE" - Scan objects with the nearline storage class. This will incur
	// retrieval fees.
	//   "COLDLINE" - Scan objects with the coldline storage class. This will incur
	// retrieval fees.
	//   "ARCHIVE" - Scan objects with the archive storage class. This will incur
	// retrieval fees.
	//   "REGIONAL" - Scan objects with the regional storage class.
	//   "MULTI_REGIONAL" - Scan objects with the multi-regional storage class.
	//   "DURABLE_REDUCED_AVAILABILITY" - Scan objects with the dual-regional
	// storage class. This will incur retrieval fees.
	IncludedObjectAttributes []string `json:"includedObjectAttributes,omitempty"`
	// ForceSendFields is a list of field names (e.g. "IncludedBucketAttributes")
	// to unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "IncludedBucketAttributes") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GooglePrivacyDlpV2DiscoveryCloudStorageConditions) MarshalJSON() ([]byte, error) {
	type NoMethod GooglePrivacyDlpV2DiscoveryCloudStorageConditions
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GooglePrivacyDlpV2DiscoveryCloudStorageFilter: Determines which buckets will
// have profiles generated within an organization or project. Includes the
// ability to filter by regular expression patterns on project ID and bucket
// name.
type GooglePrivacyDlpV2DiscoveryCloudStorageFilter struct {
	// CloudStorageResourceReference: Optional. The bucket to scan. Targets
	// including this can only include one target (the target with this bucket).
	// This enables profiling the contents of a single bucket, while the other
	// options allow for easy profiling of many bucets within a project or an
	// organization.
	CloudStorageResourceReference *GooglePrivacyDlpV2CloudStorageResourceReference `json:"cloudStorageResourceReference,omitempty"`
	// Collection: Optional. A specific set of buckets for this filter to apply to.
	Collection *GooglePrivacyDlpV2FileStoreCollection `json:"collection,omitempty"`
	// Others: Optional. Catch-all. This should always be the last target in the
	// list because anything above it will apply first. Should only appear once in
	// a configuration. If none is specified, a default one will be added
	// automatically.
	Others *GooglePrivacyDlpV2AllOtherResources `json:"others,omitempty"`
	// ForceSendFields is a list of field names (e.g.
	// "CloudStorageResourceReference") to unconditionally include in API requests.
	// By default, fields with empty or default values are omitted from API
	// requests. See https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields
	// for more details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CloudStorageResourceReference")
	// to include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GooglePrivacyDlpV2DiscoveryCloudStorageFilter) MarshalJSON() ([]byte, error) {
	type NoMethod GooglePrivacyDlpV2DiscoveryCloudStorageFilter
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GooglePrivacyDlpV2DiscoveryCloudStorageGenerationCadence: How often existing
// buckets should have their profiles refreshed. New buckets are scanned as
// quickly as possible depending on system capacity.
type GooglePrivacyDlpV2DiscoveryCloudStorageGenerationCadence struct {
	// InspectTemplateModifiedCadence: Optional. Governs when to update data
	// profiles when the inspection rules defined by the `InspectTemplate` change.
	// If not set, changing the template will not cause a data profile to update.
	InspectTemplateModifiedCadence *GooglePrivacyDlpV2DiscoveryInspectTemplateModifiedCadence `json:"inspectTemplateModifiedCadence,omitempty"`
	// RefreshFrequency: Optional. Data changes in Cloud Storage can't trigger
	// reprofiling. If you set this field, profiles are refreshed at this frequency
	// regardless of whether the underlying buckets have changed. Defaults to
	// never.
	//
	// Possible values:
	//   "UPDATE_FREQUENCY_UNSPECIFIED" - Unspecified.
	//   "UPDATE_FREQUENCY_NEVER" - After the data profile is created, it will
	// never be updated.
	//   "UPDATE_FREQUENCY_DAILY" - The data profile can be updated up to once
	// every 24 hours.
	//   "UPDATE_FREQUENCY_MONTHLY" - The data profile can be updated up to once
	// every 30 days. Default.
	RefreshFrequency string `json:"refreshFrequency,omitempty"`
	// ForceSendFields is a list of field names (e.g.
	// "InspectTemplateModifiedCadence") to unconditionally include in API
	// requests. By default, fields with empty or default values are omitted from
	// API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "InspectTemplateModifiedCadence")
	// to include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GooglePrivacyDlpV2DiscoveryCloudStorageGenerationCadence) MarshalJSON() ([]byte, error) {
	type NoMethod GooglePrivacyDlpV2DiscoveryCloudStorageGenerationCadence
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GooglePrivacyDlpV2DiscoveryConfig: Configuration for discovery to scan
// resources for profile generation. Only one discovery configuration may exist
// per organization, folder, or project. The generated data profiles are
// retained according to the [data retention policy]
// (https://cloud.google.com/sensitive-data-protection/docs/data-profiles#retention).
type GooglePrivacyDlpV2DiscoveryConfig struct {
	// Actions: Actions to execute at the completion of scanning.
	Actions []*GooglePrivacyDlpV2DataProfileAction `json:"actions,omitempty"`
	// CreateTime: Output only. The creation timestamp of a DiscoveryConfig.
	CreateTime string `json:"createTime,omitempty"`
	// DisplayName: Display name (max 100 chars)
	DisplayName string `json:"displayName,omitempty"`
	// Errors: Output only. A stream of errors encountered when the config was
	// activated. Repeated errors may result in the config automatically being
	// paused. Output only field. Will return the last 100 errors. Whenever the
	// config is modified this list will be cleared.
	Errors []*GooglePrivacyDlpV2Error `json:"errors,omitempty"`
	// InspectTemplates: Detection logic for profile generation. Not all template
	// features are used by Discovery. FindingLimits, include_quote and
	// exclude_info_types have no impact on Discovery. Multiple templates may be
	// provided if there is data in multiple regions. At most one template must be
	// specified per-region (including "global"). Each region is scanned using the
	// applicable template. If no region-specific template is specified, but a
	// "global" template is specified, it will be copied to that region and used
	// instead. If no global or region-specific template is provided for a region
	// with data, that region's data will not be scanned. For more information, see
	// https://cloud.google.com/sensitive-data-protection/docs/data-profiles#data-residency.
	InspectTemplates []string `json:"inspectTemplates,omitempty"`
	// LastRunTime: Output only. The timestamp of the last time this config was
	// executed.
	LastRunTime string `json:"lastRunTime,omitempty"`
	// Name: Unique resource name for the DiscoveryConfig, assigned by the service
	// when the DiscoveryConfig is created, for example
	// `projects/dlp-test-project/locations/global/discoveryConfigs/53234423`.
	Name string `json:"name,omitempty"`
	// OrgConfig: Only set when the parent is an org.
	OrgConfig *GooglePrivacyDlpV2OrgConfig `json:"orgConfig,omitempty"`
	// OtherCloudStartingLocation: Must be set only when scanning other clouds.
	OtherCloudStartingLocation *GooglePrivacyDlpV2OtherCloudDiscoveryStartingLocation `json:"otherCloudStartingLocation,omitempty"`
	// ProcessingLocation: Optional. Processing location configuration. Vertex AI
	// dataset scanning will set processing_location.image_fallback_type to
	// MultiRegionProcessing by default.
	ProcessingLocation *GooglePrivacyDlpV2ProcessingLocation `json:"processingLocation,omitempty"`
	// Status: Required. A status for this configuration.
	//
	// Possible values:
	//   "STATUS_UNSPECIFIED" - Unused
	//   "RUNNING" - The discovery config is currently active.
	//   "PAUSED" - The discovery config is paused temporarily.
	Status string `json:"status,omitempty"`
	// Targets: Target to match against for determining what to scan and how
	// frequently.
	Targets []*GooglePrivacyDlpV2DiscoveryTarget `json:"targets,omitempty"`
	// UpdateTime: Output only. The last update timestamp of a DiscoveryConfig.
	UpdateTime string `json:"updateTime,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Actions") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Actions") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GooglePrivacyDlpV2DiscoveryConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GooglePrivacyDlpV2DiscoveryConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GooglePrivacyDlpV2DiscoveryFileStoreConditions: Requirements that must be
// true before a file store is scanned in discovery for the first time. There
// is an AND relationship between the top-level attributes.
type GooglePrivacyDlpV2DiscoveryFileStoreConditions struct {
	// CloudStorageConditions: Optional. Cloud Storage conditions.
	CloudStorageConditions *GooglePrivacyDlpV2DiscoveryCloudStorageConditions `json:"cloudStorageConditions,omitempty"`
	// CreatedAfter: Optional. File store must have been created after this date.
	// Used to avoid backfilling.
	CreatedAfter string `json:"createdAfter,omitempty"`
	// MinAge: Optional. Minimum age a file store must have. If set, the value must
	// be 1 hour or greater.
	MinAge string `json:"minAge,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CloudStorageConditions") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CloudStorageConditions") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GooglePrivacyDlpV2DiscoveryFileStoreConditions) MarshalJSON() ([]byte, error) {
	type NoMethod GooglePrivacyDlpV2DiscoveryFileStoreConditions
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GooglePrivacyDlpV2DiscoveryGenerationCadence: What must take place for a
// profile to be updated and how frequently it should occur. New tables are
// scanned as quickly as possible depending on system capacity.
type GooglePrivacyDlpV2DiscoveryGenerationCadence struct {
	// InspectTemplateModifiedCadence: Governs when to update data profiles when
	// the inspection rules defined by the `InspectTemplate` change. If not set,
	// changing the template will not cause a data profile to update.
	InspectTemplateModifiedCadence *GooglePrivacyDlpV2DiscoveryInspectTemplateModifiedCadence `json:"inspectTemplateModifiedCadence,omitempty"`
	// RefreshFrequency: Frequency at which profiles should be updated, regardless
	// of whether the underlying resource has changed. Defaults to never.
	//
	// Possible values:
	//   "UPDATE_FREQUENCY_UNSPECIFIED" - Unspecified.
	//   "UPDATE_FREQUENCY_NEVER" - After the data profile is created, it will
	// never be updated.
	//   "UPDATE_FREQUENCY_DAILY" - The data profile can be updated up to once
	// every 24 hours.
	//   "UPDATE_FREQUENCY_MONTHLY" - The data profile can be updated up to once
	// every 30 days. Default.
	RefreshFrequency string `json:"refreshFrequency,omitempty"`
	// SchemaModifiedCadence: Governs when to update data profiles when a schema is
	// modified.
	SchemaModifiedCadence *GooglePrivacyDlpV2DiscoverySchemaModifiedCadence `json:"schemaModifiedCadence,omitempty"`
	// TableModifiedCadence: Governs when to update data profiles when a table is
	// modified.
	TableModifiedCadence *GooglePrivacyDlpV2DiscoveryTableModifiedCadence `json:"tableModifiedCadence,omitempty"`
	// ForceSendFields is a list of field names (e.g.
	// "InspectTemplateModifiedCadence") to unconditionally include in API
	// requests. By default, fields with empty or default values are omitted from
	// API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "InspectTemplateModifiedCadence")
	// to include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GooglePrivacyDlpV2DiscoveryGenerationCadence) MarshalJSON() ([]byte, error) {
	type NoMethod GooglePrivacyDlpV2DiscoveryGenerationCadence
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GooglePrivacyDlpV2DiscoveryInspectTemplateModifiedCadence: The cadence at
// which to update data profiles when the inspection rules defined by the
// `InspectTemplate` change.
type GooglePrivacyDlpV2DiscoveryInspectTemplateModifiedCadence struct {
	// Frequency: How frequently data profiles can be updated when the template is
	// modified. Defaults to never.
	//
	// Possible values:
	//   "UPDATE_FREQUENCY_UNSPECIFIED" - Unspecified.
	//   "UPDATE_FREQUENCY_NEVER" - After the data profile is created, it will
	// never be updated.
	//   "UPDATE_FREQUENCY_DAILY" - The data profile can be updated up to once
	// every 24 hours.
	//   "UPDATE_FREQUENCY_MONTHLY" - The data profile can be updated up to once
	// every 30 days. Default.
	Frequency string `json:"frequency,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Frequency") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Frequency") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GooglePrivacyDlpV2DiscoveryInspectTemplateModifiedCadence) MarshalJSON() ([]byte, error) {
	type NoMethod GooglePrivacyDlpV2DiscoveryInspectTemplateModifiedCadence
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GooglePrivacyDlpV2DiscoveryOtherCloudConditions: Requirements that must be
// true before a resource is profiled for the first time.
type GooglePrivacyDlpV2DiscoveryOtherCloudConditions struct {
	// AmazonS3BucketConditions: Amazon S3 bucket conditions.
	AmazonS3BucketConditions *GooglePrivacyDlpV2AmazonS3BucketConditions `json:"amazonS3BucketConditions,omitempty"`
	// MinAge: Minimum age a resource must be before Cloud DLP can profile it.
	// Value must be 1 hour or greater.
	MinAge string `json:"minAge,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AmazonS3BucketConditions")
	// to unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AmazonS3BucketConditions") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GooglePrivacyDlpV2DiscoveryOtherCloudConditions) MarshalJSON() ([]byte, error) {
	type NoMethod GooglePrivacyDlpV2DiscoveryOtherCloudConditions
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GooglePrivacyDlpV2DiscoveryOtherCloudFilter: Determines which resources from
// the other cloud will have profiles generated. Includes the ability to filter
// by resource names.
type GooglePrivacyDlpV2DiscoveryOtherCloudFilter struct {
	// Collection: A collection of resources for this filter to apply to.
	Collection *GooglePrivacyDlpV2OtherCloudResourceCollection `json:"collection,omitempty"`
	// Others: Optional. Catch-all. This should always be the last target in the
	// list because anything above it will apply first. Should only appear once in
	// a configuration. If none is specified, a default one will be added
	// automatically.
	Others *GooglePrivacyDlpV2AllOtherResources `json:"others,omitempty"`
	// SingleResource: The resource to scan. Configs using this filter can only
	// have one target (the target with this single resource reference).
	SingleResource *GooglePrivacyDlpV2OtherCloudSingleResourceReference `json:"singleResource,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Collection") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Collection") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GooglePrivacyDlpV2DiscoveryOtherCloudFilter) MarshalJSON() ([]byte, error) {
	type NoMethod GooglePrivacyDlpV2DiscoveryOtherCloudFilter
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GooglePrivacyDlpV2DiscoveryOtherCloudGenerationCadence: How often existing
// resources should have their profiles refreshed. New resources are scanned as
// quickly as possible depending on system capacity.
type GooglePrivacyDlpV2DiscoveryOtherCloudGenerationCadence struct {
	// InspectTemplateModifiedCadence: Optional. Governs when to update data
	// profiles when the inspection rules defined by the `InspectTemplate` change.
	// If not set, changing the template will not cause a data profile to update.
	InspectTemplateModifiedCadence *GooglePrivacyDlpV2DiscoveryInspectTemplateModifiedCadence `json:"inspectTemplateModifiedCadence,omitempty"`
	// RefreshFrequency: Optional. Frequency to update profiles regardless of
	// whether the underlying resource has changes. Defaults to never.
	//
	// Possible values:
	//   "UPDATE_FREQUENCY_UNSPECIFIED" - Unspecified.
	//   "UPDATE_FREQUENCY_NEVER" - After the data profile is created, it will
	// never be updated.
	//   "UPDATE_FREQUENCY_DAILY" - The data profile can be updated up to once
	// every 24 hours.
	//   "UPDATE_FREQUENCY_MONTHLY" - The data profile can be updated up to once
	// every 30 days. Default.
	RefreshFrequency string `json:"refreshFrequency,omitempty"`
	// ForceSendFields is a list of field names (e.g.
	// "InspectTemplateModifiedCadence") to unconditionally include in API
	// requests. By default, fields with empty or default values are omitted from
	// API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "InspectTemplateModifiedCadence")
	// to include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GooglePrivacyDlpV2DiscoveryOtherCloudGenerationCadence) MarshalJSON() ([]byte, error) {
	type NoMethod GooglePrivacyDlpV2DiscoveryOtherCloudGenerationCadence
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GooglePrivacyDlpV2DiscoverySchemaModifiedCadence: The cadence at which to
// update data profiles when a schema is modified.
type GooglePrivacyDlpV2DiscoverySchemaModifiedCadence struct {
	// Frequency: How frequently profiles may be updated when schemas are modified.
	// Defaults to monthly.
	//
	// Possible values:
	//   "UPDATE_FREQUENCY_UNSPECIFIED" - Unspecified.
	//   "UPDATE_FREQUENCY_NEVER" - After the data profile is created, it will
	// never be updated.
	//   "UPDATE_FREQUENCY_DAILY" - The data profile can be updated up to once
	// every 24 hours.
	//   "UPDATE_FREQUENCY_MONTHLY" - The data profile can be updated up to once
	// every 30 days. Default.
	Frequency string `json:"frequency,omitempty"`
	// Types: The type of events to consider when deciding if the table's schema
	// has been modified and should have the profile updated. Defaults to
	// NEW_COLUMNS.
	//
	// Possible values:
	//   "SCHEMA_MODIFICATION_UNSPECIFIED" - Unused
	//   "SCHEMA_NEW_COLUMNS" - Profiles should be regenerated when new columns are
	// added to the table. Default.
	//   "SCHEMA_REMOVED_COLUMNS" - Profiles should be regenerated when columns are
	// removed from the table.
	Types []string `json:"types,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Frequency") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Frequency") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GooglePrivacyDlpV2DiscoverySchemaModifiedCadence) MarshalJSON() ([]byte, error) {
	type NoMethod GooglePrivacyDlpV2DiscoverySchemaModifiedCadence
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GooglePrivacyDlpV2DiscoveryStartingLocation: The location to begin a
// discovery scan. Denotes an organization ID or folder ID within an
// organization.
type GooglePrivacyDlpV2DiscoveryStartingLocation struct {
	// FolderId: The ID of the folder within an organization to be scanned.
	FolderId int64 `json:"folderId,omitempty,string"`
	// OrganizationId: The ID of an organization to scan.
	OrganizationId int64 `json:"organizationId,omitempty,string"`
	// ForceSendFields is a list of field names (e.g. "FolderId") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "FolderId") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GooglePrivacyDlpV2DiscoveryStartingLocation) MarshalJSON() ([]byte, error) {
	type NoMethod GooglePrivacyDlpV2DiscoveryStartingLocation
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GooglePrivacyDlpV2DiscoveryTableModifiedCadence: The cadence at which to
// update data profiles when a table is modified.
type GooglePrivacyDlpV2DiscoveryTableModifiedCadence struct {
	// Frequency: How frequently data profiles can be updated when tables are
	// modified. Defaults to never.
	//
	// Possible values:
	//   "UPDATE_FREQUENCY_UNSPECIFIED" - Unspecified.
	//   "UPDATE_FREQUENCY_NEVER" - After the data profile is created, it will
	// never be updated.
	//   "UPDATE_FREQUENCY_DAILY" - The data profile can be updated up to once
	// every 24 hours.
	//   "UPDATE_FREQUENCY_MONTHLY" - The data profile can be updated up to once
	// every 30 days. Default.
	Frequency string `json:"frequency,omitempty"`
	// Types: The type of events to consider when deciding if the table has been
	// modified and should have the profile updated. Defaults to
	// MODIFIED_TIMESTAMP.
	//
	// Possible values:
	//   "TABLE_MODIFICATION_UNSPECIFIED" - Unused.
	//   "TABLE_MODIFIED_TIMESTAMP" - A table will be considered modified when the
	// last_modified_time from BigQuery has been updated.
	Types []string `json:"types,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Frequency") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Frequency") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GooglePrivacyDlpV2DiscoveryTableModifiedCadence) MarshalJSON() ([]byte, error) {
	type NoMethod GooglePrivacyDlpV2DiscoveryTableModifiedCadence
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GooglePrivacyDlpV2DiscoveryTarget: Target used to match against for
// Discovery.
type GooglePrivacyDlpV2DiscoveryTarget struct {
	// BigQueryTarget: BigQuery target for Discovery. The first target to match a
	// table will be the one applied.
	BigQueryTarget *GooglePrivacyDlpV2BigQueryDiscoveryTarget `json:"bigQueryTarget,omitempty"`
	// CloudSqlTarget: Cloud SQL target for Discovery. The first target to match a
	// table will be the one applied.
	CloudSqlTarget *GooglePrivacyDlpV2CloudSqlDiscoveryTarget `json:"cloudSqlTarget,omitempty"`
	// CloudStorageTarget: Cloud Storage target for Discovery. The first target to
	// match a table will be the one applied.
	CloudStorageTarget *GooglePrivacyDlpV2CloudStorageDiscoveryTarget `json:"cloudStorageTarget,omitempty"`
	// OtherCloudTarget: Other clouds target for discovery. The first target to
	// match a resource will be the one applied.
	OtherCloudTarget *GooglePrivacyDlpV2OtherCloudDiscoveryTarget `json:"otherCloudTarget,omitempty"`
	// SecretsTarget: Discovery target that looks for credentials and secrets
	// stored in cloud resource metadata and reports them as vulnerabilities to
	// Security Command Center. Only one target of this type is allowed.
	SecretsTarget *GooglePrivacyDlpV2SecretsDiscoveryTarget `json:"secretsTarget,omitempty"`
	// VertexDatasetTarget: Vertex AI dataset target for Discovery. The first
	// target to match a dataset will be the one applied. Note that discovery for
	// Vertex AI can incur Cloud Storage Class B operation charges for
	// storage.objects.get operations and retrieval fees. For more information, see
	// Cloud Storage pricing
	// (https://cloud.google.com/storage/pricing#price-tables). Note that discovery
	// for Vertex AI dataset will not be able to scan images unless
	// DiscoveryConfig.processing_location.image_fallback_location has
	// multi_region_processing or global_processing configured.
	VertexDatasetTarget *GooglePrivacyDlpV2VertexDatasetDiscoveryTarget `json:"vertexDatasetTarget,omitempty"`
	// ForceSendFields is a list of field names (e.g. "BigQueryTarget") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "BigQueryTarget") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GooglePrivacyDlpV2DiscoveryTarget) MarshalJSON() ([]byte, error) {
	type NoMethod GooglePrivacyDlpV2DiscoveryTarget
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GooglePrivacyDlpV2DiscoveryVertexDatasetConditions: Requirements that must
// be true before a dataset is profiled for the first time.
type GooglePrivacyDlpV2DiscoveryVertexDatasetConditions struct {
	// CreatedAfter: Vertex AI dataset must have been created after this date. Used
	// to avoid backfilling.
	CreatedAfter string `json:"createdAfter,omitempty"`
	// MinAge: Minimum age a Vertex AI dataset must have. If set, the value must be
	// 1 hour or greater.
	MinAge string `json:"minAge,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CreatedAfter") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CreatedAfter") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GooglePrivacyDlpV2DiscoveryVertexDatasetConditions) MarshalJSON() ([]byte, error) {
	type NoMethod GooglePrivacyDlpV2DiscoveryVertexDatasetConditions
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GooglePrivacyDlpV2DiscoveryVertexDatasetFilter: Determines what datasets
// will have profiles generated within an organization or project. Includes the
// ability to filter by regular expression patterns on project ID or dataset
// regex.
type GooglePrivacyDlpV2DiscoveryVertexDatasetFilter struct {
	// Collection: A specific set of Vertex AI datasets for this filter to apply
	// to.
	Collection *GooglePrivacyDlpV2VertexDatasetCollection `json:"collection,omitempty"`
	// Others: Catch-all. This should always be the last target in the list because
	// anything above it will apply first. Should only appear once in a
	// configuration. If none is specified, a default one will be added
	// automatically.
	Others *GooglePrivacyDlpV2AllOtherResources `json:"others,omitempty"`
	// VertexDatasetResourceReference: The dataset resource to scan. Targets
	// including this can only include one target (the target with this dataset
	// resource reference).
	VertexDatasetResourceReference *GooglePrivacyDlpV2VertexDatasetResourceReference `json:"vertexDatasetResourceReference,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Collection") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Collection") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GooglePrivacyDlpV2DiscoveryVertexDatasetFilter) MarshalJSON() ([]byte, error) {
	type NoMethod GooglePrivacyDlpV2DiscoveryVertexDatasetFilter
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GooglePrivacyDlpV2DiscoveryVertexDatasetGenerationCadence: How often
// existing datasets should have their profiles refreshed. New datasets are
// scanned as quickly as possible depending on system capacity.
type GooglePrivacyDlpV2DiscoveryVertexDatasetGenerationCadence struct {
	// InspectTemplateModifiedCadence: Governs when to update data profiles when
	// the inspection rules defined by the `InspectTemplate` change. If not set,
	// changing the template will not cause a data profile to be updated.
	InspectTemplateModifiedCadence *GooglePrivacyDlpV2DiscoveryInspectTemplateModifiedCadence `json:"inspectTemplateModifiedCadence,omitempty"`
	// RefreshFrequency: If you set this field, profiles are refreshed at this
	// frequency regardless of whether the underlying datasets have changed.
	// Defaults to never.
	//
	// Possible values:
	//   "UPDATE_FREQUENCY_UNSPECIFIED" - Unspecified.
	//   "UPDATE_FREQUENCY_NEVER" - After the data profile is created, it will
	// never be updated.
	//   "UPDATE_FREQUENCY_DAILY" - The data profile can be updated up to once
	// every 24 hours.
	//   "UPDATE_FREQUENCY_MONTHLY" - The data profile can be updated up to once
	// every 30 days. Default.
	RefreshFrequency string `json:"refreshFrequency,omitempty"`
	// ForceSendFields is a list of field names (e.g.
	// "InspectTemplateModifiedCadence") to unconditionally include in API
	// requests. By default, fields with empty or default values are omitted from
	// API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "InspectTemplateModifiedCadence")
	// to include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GooglePrivacyDlpV2DiscoveryVertexDatasetGenerationCadence) MarshalJSON() ([]byte, error) {
	type NoMethod GooglePrivacyDlpV2DiscoveryVertexDatasetGenerationCadence
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GooglePrivacyDlpV2DlpJob: Combines all of the information about a DLP job.
type GooglePrivacyDlpV2DlpJob struct {
	// ActionDetails: Events that should occur after the job has completed.
	ActionDetails []*GooglePrivacyDlpV2ActionDetails `json:"actionDetails,omitempty"`
	// CreateTime: Time when the job was created.
	CreateTime string `json:"createTime,omitempty"`
	// EndTime: Time when the job finished.
	EndTime string `json:"endTime,omitempty"`
	// Errors: A stream of errors encountered running the job.
	Errors []*GooglePrivacyDlpV2Error `json:"errors,omitempty"`
	// InspectDetails: Results from inspecting a data source.
	InspectDetails *GooglePrivacyDlpV2InspectDataSourceDetails `json:"inspectDetails,omitempty"`
	// JobTriggerName: If created by a job trigger, the resource name of the
	// trigger that instantiated the job.
	JobTriggerName string `json:"jobTriggerName,omitempty"`
	// LastModified: Time when the job was last modified by the system.
	LastModified string `json:"lastModified,omitempty"`
	// Name: The server-assigned name.
	Name string `json:"name,omitempty"`
	// RiskDetails: Results from analyzing risk of a data source.
	RiskDetails *GooglePrivacyDlpV2AnalyzeDataSourceRiskDetails `json:"riskDetails,omitempty"`
	// StartTime: Time when the job started.
	StartTime string `json:"startTime,omitempty"`
	// State: State of a job.
	//
	// Possible values:
	//   "JOB_STATE_UNSPECIFIED" - Unused.
	//   "PENDING" - The job has not yet started.
	//   "RUNNING" - The job is currently running. Once a job has finished it will
	// transition to FAILED or DONE.
	//   "DONE" - The job is no longer running.
	//   "CANCELED" - The job was canceled before it could be completed.
	//   "FAILED" - The job had an error and did not complete.
	//   "ACTIVE" - The job is currently accepting findings via hybridInspect. A
	// hybrid job in ACTIVE state may continue to have findings added to it through
	// the calling of hybridInspect. After the job has finished no more calls to
	// hybridInspect may be made. ACTIVE jobs can transition to DONE.
	State string `json:"state,omitempty"`
	// Type: The type of job.
	//
	// Possible values:
	//   "DLP_JOB_TYPE_UNSPECIFIED" - Defaults to INSPECT_JOB.
	//   "INSPECT_JOB" - The job inspected Google Cloud for sensitive data.
	//   "RISK_ANALYSIS_JOB" - The job executed a Risk Analysis computation.
	Type string `json:"type,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "ActionDetails") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ActionDetails") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GooglePrivacyDlpV2DlpJob) MarshalJSON() ([]byte, error) {
	type NoMethod GooglePrivacyDlpV2DlpJob
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GooglePrivacyDlpV2DocumentFallbackLocation: Configure document processing to
// fall back to any of the following processing options if document processing
// is unavailable in the original request location.
type GooglePrivacyDlpV2DocumentFallbackLocation struct {
	// GlobalProcessing: Processing occurs in the global region.
	GlobalProcessing *GooglePrivacyDlpV2GlobalProcessing `json:"globalProcessing,omitempty"`
	// MultiRegionProcessing: Processing occurs in a multi-region that contains the
	// current region if available.
	MultiRegionProcessing *GooglePrivacyDlpV2MultiRegionProcessing `json:"multiRegionProcessing,omitempty"`
	// ForceSendFields is a list of field names (e.g. "GlobalProcessing") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "GlobalProcessing") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GooglePrivacyDlpV2DocumentFallbackLocation) MarshalJSON() ([]byte, error) {
	type NoMethod GooglePrivacyDlpV2DocumentFallbackLocation
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GooglePrivacyDlpV2DocumentLocation: Location of a finding within a document.
type GooglePrivacyDlpV2DocumentLocation struct {
	// FileOffset: Offset of the line, from the beginning of the file, where the
	// finding is located.
	FileOffset int64 `json:"fileOffset,omitempty,string"`
	// ForceSendFields is a list of field names (e.g. "FileOffset") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "FileOffset") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GooglePrivacyDlpV2DocumentLocation) MarshalJSON() ([]byte, error) {
	type NoMethod GooglePrivacyDlpV2DocumentLocation
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GooglePrivacyDlpV2Domain: A domain represents a thematic category that a
// data profile can fall under.
type GooglePrivacyDlpV2Domain struct {
	// Category: A domain category that this profile is related to.
	//
	// Possible values:
	//   "CATEGORY_UNSPECIFIED" - Category unspecified.
	//   "AI" - Indicates that the data profile is related to artificial
	// intelligence. When set, all findings stored to Security Command Center will
	// set the corresponding AI domain field of `Finding` objects.
	//   "CODE" - Indicates that the data profile is related to code.
	Category string `json:"category,omitempty"`
	// Signals: The collection of signals that influenced selection of the
	// category.
	//
	// Possible values:
	//   "SIGNAL_UNSPECIFIED" - Unused.
	//   "MODEL" - One or more machine learning models are present.
	//   "TEXT_EMBEDDING" - A table appears to be a text embedding.
	//   "VERTEX_PLUGIN" - The [Cloud SQL Vertex
	// AI](https://cloud.google.com/sql/docs/postgres/integrate-cloud-sql-with-verte
	// x-ai) plugin is installed on the database.
	//   "VECTOR_PLUGIN" - Support for [Cloud SQL vector
	// embeddings](https://cloud.google.com/sql/docs/mysql/enable-vector-search) is
	// enabled on the database.
	//   "SOURCE_CODE" - Source code is present.
	//   "SERVICE" - If the service determines the category type. For example,
	// Vertex AI assets would always have a `Category` of `AI`.
	Signals []string `json:"signals,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Category") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Category") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GooglePrivacyDlpV2Domain) MarshalJSON() ([]byte, error) {
	type NoMethod GooglePrivacyDlpV2Domain
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GooglePrivacyDlpV2Encloses: Defines a condition where one bounding box
// encloses another.
type GooglePrivacyDlpV2Encloses struct {
}

// GooglePrivacyDlpV2EntityId: An entity in a dataset is a field or set of
// fields that correspond to a single person. For example, in medical records
// the `EntityId` might be a patient identifier, or for financial records it
// might be an account identifier. This message is used when generalizations or
// analysis must take into account that multiple rows correspond to the same
// entity.
type GooglePrivacyDlpV2EntityId struct {
	// Field: Composite key indicating which field contains the entity identifier.
	Field *GooglePrivacyDlpV2FieldId `json:"field,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Field") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Field") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GooglePrivacyDlpV2EntityId) MarshalJSON() ([]byte, error) {
	type NoMethod GooglePrivacyDlpV2EntityId
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GooglePrivacyDlpV2Error: Details information about an error encountered
// during job execution or the results of an unsuccessful activation of the
// JobTrigger.
type GooglePrivacyDlpV2Error struct {
	// Details: Detailed error codes and messages.
	Details *GoogleRpcStatus `json:"details,omitempty"`
	// ExtraInfo: Additional information about the error.
	//
	// Possible values:
	//   "ERROR_INFO_UNSPECIFIED" - Unused.
	//   "IMAGE_SCAN_UNAVAILABLE_IN_REGION" - Image scan is not available in the
	// region.
	//   "FILE_STORE_CLUSTER_UNSUPPORTED" - File store cluster is not supported for
	// profile generation.
	ExtraInfo string `json:"extraInfo,omitempty"`
	// Timestamps: The times the error occurred. List includes the oldest timestamp
	// and the last 9 timestamps.
	Timestamps []string `json:"timestamps,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Details") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Details") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GooglePrivacyDlpV2Error) MarshalJSON() ([]byte, error) {
	type NoMethod GooglePrivacyDlpV2Error
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GooglePrivacyDlpV2ExcludeByHotword: The rule to exclude findings based on a
// hotword. For record inspection of tables, column names are considered
// hotwords. An example of this is to exclude a finding if it belongs to a
// BigQuery column that matches a specific pattern.
type GooglePrivacyDlpV2ExcludeByHotword struct {
	// HotwordRegex: Regular expression pattern defining what qualifies as a
	// hotword.
	HotwordRegex *GooglePrivacyDlpV2Regex `json:"hotwordRegex,omitempty"`
	// Proximity: Range of characters within which the entire hotword must reside.
	// The total length of the window cannot exceed 1000 characters. The
	// windowBefore property in proximity should be set to 1 if the hotword needs
	// to be included in a column header.
	Proximity *GooglePrivacyDlpV2Proximity `json:"proximity,omitempty"`
	// ForceSendFields is a list of field names (e.g. "HotwordRegex") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "HotwordRegex") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GooglePrivacyDlpV2ExcludeByHotword) MarshalJSON() ([]byte, error) {
	type NoMethod GooglePrivacyDlpV2ExcludeByHotword
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GooglePrivacyDlpV2ExcludeByImageFindings: The rule to exclude image findings
// based on spatial relationships with other image findings. For example,
// exclude an image finding if it overlaps with another image finding. This
// rule is silently ignored if the content being inspected is not an image.
type GooglePrivacyDlpV2ExcludeByImageFindings struct {
	// ImageContainmentType: Specifies the required spatial relationship between
	// the bounding boxes of the target finding and the context infoType findings.
	ImageContainmentType *GooglePrivacyDlpV2ImageContainmentType `json:"imageContainmentType,omitempty"`
	// InfoTypes: A list of image-supported infoTypes—excluding document
	// infoTypes
	// (https://cloud.google.com/sensitive-data-protection/docs/infotypes-reference#documents)—to
	// be used as context for the exclusion rule. A finding is excluded if its
	// bounding box has the specified spatial relationship (defined by
	// `image_containment_type`) with a finding of an infoType in this list. For
	// example, if `InspectionRuleSet.info_types` includes `OBJECT_TYPE/PERSON` and
	// this `exclusion_rule` specifies `info_types` as
	// `OBJECT_TYPE/PERSON/PASSPORT` with `image_containment_type` set to
	// `encloses`, then `OBJECT_TYPE/PERSON` findings will be excluded if they are
	// fully contained within the bounding box of an `OBJECT_TYPE/PERSON/PASSPORT`
	// finding.
	InfoTypes []*GooglePrivacyDlpV2InfoType `json:"infoTypes,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ImageContainmentType") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ImageContainmentType") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GooglePrivacyDlpV2ExcludeByImageFindings) MarshalJSON() ([]byte, error) {
	type NoMethod GooglePrivacyDlpV2ExcludeByImageFindings
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GooglePrivacyDlpV2ExcludeInfoTypes: List of excluded infoTypes.
type GooglePrivacyDlpV2ExcludeInfoTypes struct {
	// InfoTypes: InfoType list in ExclusionRule rule drops a finding when it
	// overlaps or contained within with a finding of an infoType from this list.
	// For example, for `InspectionRuleSet.info_types` containing "PHONE_NUMBER"
	// and `exclusion_rule` containing `exclude_info_types.info_types` with
	// "EMAIL_ADDRESS" the phone number findings are dropped if they overlap with
	// EMAIL_ADDRESS finding. That leads to "555-222-2222@example.org" to generate
	// only a single finding, namely email address.
	InfoTypes []*GooglePrivacyDlpV2InfoType `json:"infoTypes,omitempty"`
	// ForceSendFields is a list of field names (e.g. "InfoTypes") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "InfoTypes") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GooglePrivacyDlpV2ExcludeInfoTypes) MarshalJSON() ([]byte, error) {
	type NoMethod GooglePrivacyDlpV2ExcludeInfoTypes
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GooglePrivacyDlpV2ExclusionRule: The rule that specifies conditions when
// findings of infoTypes specified in `InspectionRuleSet` are removed from
// results.
type GooglePrivacyDlpV2ExclusionRule struct {
	// Dictionary: Dictionary which defines the rule.
	Dictionary *GooglePrivacyDlpV2Dictionary `json:"dictionary,omitempty"`
	// ExcludeByHotword: Drop if the hotword rule is contained in the proximate
	// context. For tabular data, the context includes the column name.
	ExcludeByHotword *GooglePrivacyDlpV2ExcludeByHotword `json:"excludeByHotword,omitempty"`
	// ExcludeByImageFindings: Exclude findings based on image containment rules.
	// For example, exclude an image finding if it overlaps with another image
	// finding.
	ExcludeByImageFindings *GooglePrivacyDlpV2ExcludeByImageFindings `json:"excludeByImageFindings,omitempty"`
	// ExcludeInfoTypes: Set of infoTypes for which findings would affect this
	// rule.
	ExcludeInfoTypes *GooglePrivacyDlpV2ExcludeInfoTypes `json:"excludeInfoTypes,omitempty"`
	// MatchingType: How the rule is applied, see MatchingType documentation for
	// details.
	//
	// Possible values:
	//   "MATCHING_TYPE_UNSPECIFIED" - Invalid.
	//   "MATCHING_TYPE_FULL_MATCH" - Full match. - Dictionary: join of Dictionary
	// results matched the complete finding quote - Regex: all regex matches fill a
	// finding quote from start to end - Exclude infoType: completely inside
	// affecting infoTypes findings
	//   "MATCHING_TYPE_PARTIAL_MATCH" - Partial match. - Dictionary: at least one
	// of the tokens in the finding matches - Regex: substring of the finding
	// matches - Exclude infoType: intersects with affecting infoTypes findings
	//   "MATCHING_TYPE_INVERSE_MATCH" - Inverse match. - Dictionary: no tokens in
	// the finding match the dictionary - Regex: finding doesn't match the regex -
	// Exclude infoType: no intersection with affecting infoTypes findings
	//   "MATCHING_TYPE_RULE_SPECIFIC" - Rule-specific match. The matching logic is
	// based on the specific rule being used. This is required for rules where the
	// matching behavior is not a simple string comparison (e.g., image
	// containment). This matching type can only be used with the
	// `ExcludeByImageFindings` rule. - Exclude by image findings: The matching
	// logic is defined within `ExcludeByImageFindings` based on spatial
	// relationships between bounding boxes.
	MatchingType string `json:"matchingType,omitempty"`
	// Regex: Regular expression which defines the rule.
	Regex *GooglePrivacyDlpV2Regex `json:"regex,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Dictionary") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Dictionary") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GooglePrivacyDlpV2ExclusionRule) MarshalJSON() ([]byte, error) {
	type NoMethod GooglePrivacyDlpV2ExclusionRule
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GooglePrivacyDlpV2Export: If set, the detailed data profiles will be
// persisted to the location of your choice whenever updated.
type GooglePrivacyDlpV2Export struct {
	// ProfileTable: Store all profiles to BigQuery. * The system will create a new
	// dataset and table for you if none are are provided. The dataset will be
	// named `sensitive_data_protection_discovery` and table will be named
	// `discovery_profiles`. This table will be placed in the same project as the
	// container project running the scan. After the first profile is generated and
	// the dataset and table are created, the discovery scan configuration will be
	// updated with the dataset and table names. * See Analyze data profiles stored
	// in BigQuery
	// (https://cloud.google.com/sensitive-data-protection/docs/analyze-data-profiles).
	// * See Sample queries for your BigQuery table
	// (https://cloud.google.com/sensitive-data-protection/docs/analyze-data-profiles#sample_sql_queries).
	// * Data is inserted using streaming insert
	// (https://cloud.google.com/blog/products/bigquery/life-of-a-bigquery-streaming-insert)
	// and so data may be in the buffer for a period of time after the profile has
	// finished. * The Pub/Sub notification is sent before the streaming buffer is
	// guaranteed to be written, so data may not be instantly visible to queries by
	// the time your topic receives the Pub/Sub notification. * The best practice
	// is to use the same table for an entire organization so that you can take
	// advantage of the provided Looker reports
	// (https://cloud.google.com/sensitive-data-protection/docs/analyze-data-profiles#use_a_premade_report).
	// If you use VPC Service Controls to define security perimeters, then you must
	// use a separate table for each boundary.
	ProfileTable *GooglePrivacyDlpV2BigQueryTable `json:"profileTable,omitempty"`
	// SampleFindingsTable: Store sample data profile findings in an existing table
	// or a new table in an existing dataset. Each regeneration will result in new
	// rows in BigQuery. Data is inserted using streaming insert
	// (https://cloud.google.com/blog/products/bigquery/life-of-a-bigquery-streaming-insert)
	// and so data may be in the buffer for a period of time after the profile has
	// finished.
	SampleFindingsTable *GooglePrivacyDlpV2BigQueryTable `json:"sampleFindingsTable,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ProfileTable") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ProfileTable") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GooglePrivacyDlpV2Export) MarshalJSON() ([]byte, error) {
	type NoMethod GooglePrivacyDlpV2Export
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GooglePrivacyDlpV2Expressions: An expression, consisting of an operator and
// conditions.
type GooglePrivacyDlpV2Expressions struct {
	// Conditions: Conditions to apply to the expression.
	Conditions *GooglePrivacyDlpV2Conditions `json:"conditions,omitempty"`
	// LogicalOperator: The operator to apply to the result of conditions. Default
	// and currently only supported value is `AND`.
	//
	// Possible values:
	//   "LOGICAL_OPERATOR_UNSPECIFIED" - Unused
	//   "AND" - Conditional AND
	LogicalOperator string `json:"logicalOperator,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Conditions") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Conditions") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GooglePrivacyDlpV2Expressions) MarshalJSON() ([]byte, error) {
	type NoMethod GooglePrivacyDlpV2Expressions
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GooglePrivacyDlpV2FieldId: General identifier of a data field in a storage
// service.
type GooglePrivacyDlpV2FieldId struct {
	// Name: Name describing the field.
	Name string `json:"name,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Name") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Name") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GooglePrivacyDlpV2FieldId) MarshalJSON() ([]byte, error) {
	type NoMethod GooglePrivacyDlpV2FieldId
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GooglePrivacyDlpV2FieldTransformation: The transformation to apply to the
// field.
type GooglePrivacyDlpV2FieldTransformation struct {
	// Condition: Only apply the transformation if the condition evaluates to true
	// for the given `RecordCondition`. The conditions are allowed to reference
	// fields that are not used in the actual transformation. Example Use Cases: -
	// Apply a different bucket transformation to an age column if the zip code
	// column for the same record is within a specific range. - Redact a field if
	// the date of birth field is greater than 85.
	Condition *GooglePrivacyDlpV2RecordCondition `json:"condition,omitempty"`
	// Fields: Required. Input field(s) to apply the transformation to. When you
	// have columns that reference their position within a list, omit the index
	// from the FieldId. FieldId name matching ignores the index. For example,
	// instead of "contact.nums[0].type", use "contact.nums.type".
	Fields []*GooglePrivacyDlpV2FieldId `json:"fields,omitempty"`
	// InfoTypeTransformations: Treat the contents of the field as free text, and
	// selectively transform content that matches an `InfoType`.
	InfoTypeTransformations *GooglePrivacyDlpV2InfoTypeTransformations `json:"infoTypeTransformations,omitempty"`
	// PrimitiveTransformation: Apply the transformation to the entire field.
	PrimitiveTransformation *GooglePrivacyDlpV2PrimitiveTransformation `json:"primitiveTransformation,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Condition") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Condition") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GooglePrivacyDlpV2FieldTransformation) MarshalJSON() ([]byte, error) {
	type NoMethod GooglePrivacyDlpV2FieldTransformation
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GooglePrivacyDlpV2FileClusterSummary: The file cluster summary.
type GooglePrivacyDlpV2FileClusterSummary struct {
	// DataRiskLevel: The data risk level of this cluster. RISK_LOW if nothing has
	// been scanned.
	DataRiskLevel *GooglePrivacyDlpV2DataRiskLevel `json:"dataRiskLevel,omitempty"`
	// Errors: A list of errors detected while scanning this cluster. The list is
	// truncated to 10 per cluster.
	Errors []*GooglePrivacyDlpV2Error `json:"errors,omitempty"`
	// FileClusterType: The file cluster type.
	FileClusterType *GooglePrivacyDlpV2FileClusterType `json:"fileClusterType,omitempty"`
	// FileExtensionsScanned: A sample of file types scanned in this cluster. Empty
	// if no files were scanned. File extensions can be derived from the file name
	// or the file content.
	FileExtensionsScanned []*GooglePrivacyDlpV2FileExtensionInfo `json:"fileExtensionsScanned,omitempty"`
	// FileExtensionsSeen: A sample of file types seen in this cluster. Empty if no
	// files were seen. File extensions can be derived from the file name or the
	// file content.
	FileExtensionsSeen []*GooglePrivacyDlpV2FileExtensionInfo `json:"fileExtensionsSeen,omitempty"`
	// FileStoreInfoTypeSummaries: InfoTypes detected in this cluster.
	FileStoreInfoTypeSummaries []*GooglePrivacyDlpV2FileStoreInfoTypeSummary `json:"fileStoreInfoTypeSummaries,omitempty"`
	// NoFilesExist: True if no files exist in this cluster. If the file store had
	// more files than could be listed, this will be false even if no files for
	// this cluster were seen and file_extensions_seen is empty.
	NoFilesExist bool `json:"noFilesExist,omitempty"`
	// SensitivityScore: The sensitivity score of this cluster. The score will be
	// SENSITIVITY_LOW if nothing has been scanned.
	SensitivityScore *GooglePrivacyDlpV2SensitivityScore `json:"sensitivityScore,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DataRiskLevel") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DataRiskLevel") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GooglePrivacyDlpV2FileClusterSummary) MarshalJSON() ([]byte, error) {
	type NoMethod GooglePrivacyDlpV2FileClusterSummary
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GooglePrivacyDlpV2FileClusterType: Message used to identify file cluster
// type being profiled.
type GooglePrivacyDlpV2FileClusterType struct {
	// Cluster: Cluster type.
	//
	// Possible values:
	//   "CLUSTER_UNSPECIFIED" - Unused.
	//   "CLUSTER_UNKNOWN" - Unsupported files.
	//   "CLUSTER_TEXT" - Plain text.
	//   "CLUSTER_STRUCTURED_DATA" - Structured data like CSV, TSV etc.
	//   "CLUSTER_SOURCE_CODE" - Source code.
	//   "CLUSTER_RICH_DOCUMENT" - Rich document like docx, xlsx etc.
	//   "CLUSTER_IMAGE" - Images like jpeg, bmp.
	//   "CLUSTER_ARCHIVE" - Archives and containers like .zip, .tar etc.
	//   "CLUSTER_MULTIMEDIA" - Multimedia like .mp4, .avi etc.
	//   "CLUSTER_EXECUTABLE" - Executable files like .exe, .class, .apk etc.
	//   "CLUSTER_AI_MODEL" - AI models like .tflite etc.
	Cluster string `json:"cluster,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Cluster") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Cluster") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GooglePrivacyDlpV2FileClusterType) MarshalJSON() ([]byte, error) {
	type NoMethod GooglePrivacyDlpV2FileClusterType
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GooglePrivacyDlpV2FileExtensionInfo: Information regarding the discovered
// file extension.
type GooglePrivacyDlpV2FileExtensionInfo struct {
	// FileExtension: The file extension if set. (aka .pdf, .jpg, .txt)
	FileExtension string `json:"fileExtension,omitempty"`
	// ForceSendFields is a list of field names (e.g. "FileExtension") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "FileExtension") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GooglePrivacyDlpV2FileExtensionInfo) MarshalJSON() ([]byte, error) {
	type NoMethod GooglePrivacyDlpV2FileExtensionInfo
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GooglePrivacyDlpV2FileSet: Set of files to scan.
type GooglePrivacyDlpV2FileSet struct {
	// RegexFileSet: The regex-filtered set of files to scan. Exactly one of `url`
	// or `regex_file_set` must be set.
	RegexFileSet *GooglePrivacyDlpV2CloudStorageRegexFileSet `json:"regexFileSet,omitempty"`
	// Url: The Cloud Storage url of the file(s) to scan, in the format `gs:///`.
	// Trailing wildcard in the path is allowed. If the url ends in a trailing
	// slash, the bucket or directory represented by the url will be scanned
	// non-recursively (content in sub-directories will not be scanned). This means
	// that `gs://mybucket/` is equivalent to `gs://mybucket/*`, and
	// `gs://mybucket/directory/` is equivalent to `gs://mybucket/directory/*`.
	// Exactly one of `url` or `regex_file_set` must be set.
	Url string `json:"url,omitempty"`
	// ForceSendFields is a list of field names (e.g. "RegexFileSet") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "RegexFileSet") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GooglePrivacyDlpV2FileSet) MarshalJSON() ([]byte, error) {
	type NoMethod GooglePrivacyDlpV2FileSet
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GooglePrivacyDlpV2FileStoreCollection: Match file stores (e.g. buckets)
// using filters.
type GooglePrivacyDlpV2FileStoreCollection struct {
	// IncludeRegexes: Optional. A collection of regular expressions to match a
	// file store against.
	IncludeRegexes *GooglePrivacyDlpV2FileStoreRegexes `json:"includeRegexes,omitempty"`
	// IncludeTags: Optional. To be included in the collection, a resource must
	// meet all of the following requirements: - If tag filters are provided, match
	// all provided tag filters. - If one or more patterns are specified, match at
	// least one pattern. For a resource to match the tag filters, the resource
	// must have all of the provided tags attached. Tags refer to Resource Manager
	// tags bound to the resource or its ancestors. For more information, see
	// Manage schedules
	// (https://cloud.google.com/sensitive-data-protection/docs/profile-project-cloud-storage#manage-schedules).
	IncludeTags *GooglePrivacyDlpV2TagFilters `json:"includeTags,omitempty"`
	// ForceSendFields is a list of field names (e.g. "IncludeRegexes") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "IncludeRegexes") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GooglePrivacyDlpV2FileStoreCollection) MarshalJSON() ([]byte, error) {
	type NoMethod GooglePrivacyDlpV2FileStoreCollection
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GooglePrivacyDlpV2FileStoreDataProfile: The profile for a file store. *
// Cloud Storage: maps 1:1 with a bucket. * Amazon S3: maps 1:1 with a bucket.
type GooglePrivacyDlpV2FileStoreDataProfile struct {
	// ConfigSnapshot: The snapshot of the configurations used to generate the
	// profile.
	ConfigSnapshot *GooglePrivacyDlpV2DataProfileConfigSnapshot `json:"configSnapshot,omitempty"`
	// CreateTime: The time the file store was first created.
	CreateTime string `json:"createTime,omitempty"`
	// DataRiskLevel: The data risk level of this resource.
	DataRiskLevel *GooglePrivacyDlpV2DataRiskLevel `json:"dataRiskLevel,omitempty"`
	// DataSourceType: The resource type that was profiled.
	DataSourceType *GooglePrivacyDlpV2DataSourceType `json:"dataSourceType,omitempty"`
	// DataStorageLocations: For resources that have multiple storage locations,
	// these are those regions. For Cloud Storage this is the list of regions
	// chosen for dual-region storage. `file_store_location` will normally be the
	// corresponding multi-region for the list of individual locations. The first
	// region is always picked as the processing and storage location for the data
	// profile.
	DataStorageLocations []string `json:"dataStorageLocations,omitempty"`
	// Domains: Domains associated with the profile.
	Domains []*GooglePrivacyDlpV2Domain `json:"domains,omitempty"`
	// FileClusterSummaries: FileClusterSummary per each cluster.
	FileClusterSummaries []*GooglePrivacyDlpV2FileClusterSummary `json:"fileClusterSummaries,omitempty"`
	// FileStoreInfoTypeSummaries: InfoTypes detected in this file store.
	FileStoreInfoTypeSummaries []*GooglePrivacyDlpV2FileStoreInfoTypeSummary `json:"fileStoreInfoTypeSummaries,omitempty"`
	// FileStoreIsEmpty: The file store does not have any files. If the profiling
	// operation failed, this is false.
	FileStoreIsEmpty bool `json:"fileStoreIsEmpty,omitempty"`
	// FileStoreLocation: The location of the file store. * Cloud Storage:
	// https://cloud.google.com/storage/docs/locations#available-locations * Amazon
	// S3:
	// https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints
	FileStoreLocation string `json:"fileStoreLocation,omitempty"`
	// FileStorePath: The file store path. * Cloud Storage: `gs://{bucket}` *
	// Amazon S3: `s3://{bucket}` * Vertex AI dataset:
	// `projects/{project_number}/locations/{location}/datasets/{dataset_id}`
	FileStorePath string `json:"fileStorePath,omitempty"`
	// FullResource: The resource name of the resource profiled.
	// https://cloud.google.com/apis/design/resource_names#full_resource_name
	// Example format of an S3 bucket full resource name:
	// `//cloudasset.googleapis.com/organizations/{org_id}/otherCloudConnections/aws
	// /arn:aws:s3:::{bucket_name}`
	FullResource string `json:"fullResource,omitempty"`
	// LastModifiedTime: The time the file store was last modified.
	LastModifiedTime string `json:"lastModifiedTime,omitempty"`
	// LocationType: The location type of the file store (region, dual-region,
	// multi-region, etc). If dual-region, expect data_storage_locations to be
	// populated.
	LocationType string `json:"locationType,omitempty"`
	// Name: The name of the profile.
	Name string `json:"name,omitempty"`
	// ProfileLastGenerated: The last time the profile was generated.
	ProfileLastGenerated string `json:"profileLastGenerated,omitempty"`
	// ProfileStatus: Success or error status from the most recent profile
	// generation attempt. May be empty if the profile is still being generated.
	ProfileStatus *GooglePrivacyDlpV2ProfileStatus `json:"profileStatus,omitempty"`
	// ProjectDataProfile: The resource name of the project data profile for this
	// file store.
	ProjectDataProfile string `json:"projectDataProfile,omitempty"`
	// ProjectId: The Google Cloud project ID that owns the resource. For Amazon S3
	// buckets, this is the AWS Account Id.
	ProjectId string `json:"projectId,omitempty"`
	// RelatedResources: Resources related to this profile.
	RelatedResources []*GooglePrivacyDlpV2RelatedResource `json:"relatedResources,omitempty"`
	// ResourceAttributes: Attributes of the resource being profiled. Currently
	// used attributes: * customer_managed_encryption: boolean - true: the resource
	// is encrypted with a customer-managed key. - false: the resource is encrypted
	// with a provider-managed key.
	ResourceAttributes map[string]GooglePrivacyDlpV2Value `json:"resourceAttributes,omitempty"`
	// ResourceLabels: The labels applied to the resource at the time the profile
	// was generated.
	ResourceLabels map[string]string `json:"resourceLabels,omitempty"`
	// ResourceVisibility: How broadly a resource has been shared.
	//
	// Possible values:
	//   "RESOURCE_VISIBILITY_UNSPECIFIED" - Unused.
	//   "RESOURCE_VISIBILITY_PUBLIC" - Visible to any user.
	//   "RESOURCE_VISIBILITY_INCONCLUSIVE" - May contain public items. For
	// example, if a Cloud Storage bucket has uniform bucket level access disabled,
	// some objects inside it may be public, but none are known yet.
	//   "RESOURCE_VISIBILITY_RESTRICTED" - Visible only to specific users.
	ResourceVisibility string `json:"resourceVisibility,omitempty"`
	// SampleFindingsTable: The BigQuery table to which the sample findings are
	// written.
	SampleFindingsTable *GooglePrivacyDlpV2BigQueryTable `json:"sampleFindingsTable,omitempty"`
	// SensitivityScore: The sensitivity score of this resource.
	SensitivityScore *GooglePrivacyDlpV2SensitivityScore `json:"sensitivityScore,omitempty"`
	// State: State of a profile.
	//
	// Possible values:
	//   "STATE_UNSPECIFIED" - Unused.
	//   "RUNNING" - The profile is currently running. Once a profile has finished
	// it will transition to DONE.
	//   "DONE" - The profile is no longer generating. If
	// profile_status.status.code is 0, the profile succeeded, otherwise, it
	// failed.
	State string `json:"state,omitempty"`
	// Tags: The tags attached to the resource, including any tags attached during
	// profiling.
	Tags []*GooglePrivacyDlpV2Tag `json:"tags,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "ConfigSnapshot") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ConfigSnapshot") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GooglePrivacyDlpV2FileStoreDataProfile) MarshalJSON() ([]byte, error) {
	type NoMethod GooglePrivacyDlpV2FileStoreDataProfile
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GooglePrivacyDlpV2FileStoreInfoTypeSummary: Information regarding the
// discovered InfoType.
type GooglePrivacyDlpV2FileStoreInfoTypeSummary struct {
	// InfoType: The InfoType seen.
	InfoType *GooglePrivacyDlpV2InfoType `json:"infoType,omitempty"`
	// ForceSendFields is a list of field names (e.g. "InfoType") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "InfoType") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GooglePrivacyDlpV2FileStoreInfoTypeSummary) MarshalJSON() ([]byte, error) {
	type NoMethod GooglePrivacyDlpV2FileStoreInfoTypeSummary
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GooglePrivacyDlpV2FileStoreRegex: A pattern to match against one or more
// file stores.
type GooglePrivacyDlpV2FileStoreRegex struct {
	// CloudStorageRegex: Optional. Regex for Cloud Storage.
	CloudStorageRegex *GooglePrivacyDlpV2CloudStorageRegex `json:"cloudStorageRegex,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CloudStorageRegex") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CloudStorageRegex") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GooglePrivacyDlpV2FileStoreRegex) MarshalJSON() ([]byte, error) {
	type NoMethod GooglePrivacyDlpV2FileStoreRegex
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GooglePrivacyDlpV2FileStoreRegexes: A collection of regular expressions to
// determine what file store to match against.
type GooglePrivacyDlpV2FileStoreRegexes struct {
	// Patterns: Required. The group of regular expression patterns to match
	// against one or more file stores. Maximum of 100 entries. The sum of all
	// regular expression's length can't exceed 10 KiB.
	Patterns []*GooglePrivacyDlpV2FileStoreRegex `json:"patterns,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Patterns") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Patterns") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GooglePrivacyDlpV2FileStoreRegexes) MarshalJSON() ([]byte, error) {
	type NoMethod GooglePrivacyDlpV2FileStoreRegexes
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GooglePrivacyDlpV2Finding: Represents a piece of potentially sensitive
// content.
type GooglePrivacyDlpV2Finding struct {
	// CreateTime: Timestamp when finding was detected.
	CreateTime string `json:"createTime,omitempty"`
	// FindingId: The unique finding id.
	FindingId string `json:"findingId,omitempty"`
	// InfoType: The type of content that might have been found. Provided if
	// `excluded_types` is false.
	InfoType *GooglePrivacyDlpV2InfoType `json:"infoType,omitempty"`
	// JobCreateTime: Time the job started that produced this finding.
	JobCreateTime string `json:"jobCreateTime,omitempty"`
	// JobName: The job that stored the finding.
	JobName string `json:"jobName,omitempty"`
	// Labels: The labels associated with this `Finding`. Label keys must be
	// between 1 and 63 characters long and must conform to the following regular
	// expression: `a-z ([-a-z0-9]*[a-z0-9])?`. Label values must be between 0 and
	// 63 characters long and must conform to the regular expression
	// `([a-z]([-a-z0-9]*[a-z0-9])?)?`. No more than 10 labels can be associated
	// with a given finding. Examples: * "environment" : "production" *
	// "pipeline" : "etl"
	Labels map[string]string `json:"labels,omitempty"`
	// Likelihood: Confidence of how likely it is that the `info_type` is correct.
	//
	// Possible values:
	//   "LIKELIHOOD_UNSPECIFIED" - Default value; same as POSSIBLE.
	//   "VERY_UNLIKELY" - Highest chance of a false positive.
	//   "UNLIKELY" - High chance of a false positive.
	//   "POSSIBLE" - Some matching signals. The default value.
	//   "LIKELY" - Low chance of a false positive.
	//   "VERY_LIKELY" - Confidence level is high. Lowest chance of a false
	// positive.
	Likelihood string `json:"likelihood,omitempty"`
	// Location: Where the content was found.
	Location *GooglePrivacyDlpV2Location `json:"location,omitempty"`
	// Name: Resource name in format
	// projects/{project}/locations/{location}/findings/{finding} Populated only
	// when viewing persisted findings.
	Name string `json:"name,omitempty"`
	// Quote: The content that was found. Even if the content is not textual, it
	// may be converted to a textual representation here. Provided if
	// `include_quote` is true and the finding is less than or equal to 4096 bytes
	// long. If the finding exceeds 4096 bytes in length, the quote may be omitted.
	Quote string `json:"quote,omitempty"`
	// QuoteInfo: Contains data parsed from quotes. Only populated if include_quote
	// was set to true and a supported infoType was requested. Currently supported
	// infoTypes: DATE, DATE_OF_BIRTH and TIME.
	QuoteInfo *GooglePrivacyDlpV2QuoteInfo `json:"quoteInfo,omitempty"`
	// ResourceName: The job that stored the finding.
	ResourceName string `json:"resourceName,omitempty"`
	// TriggerName: Job trigger name, if applicable, for this finding.
	TriggerName string `json:"triggerName,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CreateTime") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CreateTime") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GooglePrivacyDlpV2Finding) MarshalJSON() ([]byte, error) {
	type NoMethod GooglePrivacyDlpV2Finding
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GooglePrivacyDlpV2FindingLimits: Configuration to control the number of
// findings returned for inspection. This is not used for de-identification or
// data profiling. When redacting sensitive data from images, finding limits
// don't apply. They can cause unexpected or inconsistent results, where only
// some data is redacted. Don't include finding limits in RedactImage requests.
// Otherwise, Cloud DLP returns an error.
type GooglePrivacyDlpV2FindingLimits struct {
	// MaxFindingsPerInfoType: Configuration of findings limit given for specified
	// infoTypes.
	MaxFindingsPerInfoType []*GooglePrivacyDlpV2InfoTypeLimit `json:"maxFindingsPerInfoType,omitempty"`
	// MaxFindingsPerItem: Max number of findings that are returned for each item
	// scanned. When set within an InspectContentRequest, this field is ignored.
	// This value isn't a hard limit. If the number of findings for an item reaches
	// this limit, the inspection of that item ends gradually, not abruptly.
	// Therefore, the actual number of findings that Cloud DLP returns for the item
	// can be multiple times higher than this value.
	MaxFindingsPerItem int64 `json:"maxFindingsPerItem,omitempty"`
	// MaxFindingsPerRequest: Max number of findings that are returned per request
	// or job. If you set this field in an InspectContentRequest, the resulting
	// maximum value is the value that you set or 3,000, whichever is lower. This
	// value isn't a hard limit. If an inspection reaches this limit, the
	// inspection ends gradually, not abruptly. Therefore, the actual number of
	// findings that Cloud DLP returns can be multiple times higher than this
	// value.
	MaxFindingsPerRequest int64 `json:"maxFindingsPerRequest,omitempty"`
	// ForceSendFields is a list of field names (e.g. "MaxFindingsPerInfoType") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "MaxFindingsPerInfoType") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GooglePrivacyDlpV2FindingLimits) MarshalJSON() ([]byte, error) {
	type NoMethod GooglePrivacyDlpV2FindingLimits
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GooglePrivacyDlpV2FinishDlpJobRequest: The request message for finishing a
// DLP hybrid job.
type GooglePrivacyDlpV2FinishDlpJobRequest struct {
}

// GooglePrivacyDlpV2FixedSizeBucketingConfig: Buckets values based on fixed
// size ranges. The Bucketing transformation can provide all of this
// functionality, but requires more configuration. This message is provided as
// a convenience to the user for simple bucketing strategies. The transformed
// value will be a hyphenated string of {lower_bound}-{upper_bound}. For
// example, if lower_bound = 10 and upper_bound = 20, all values that are
// within this bucket will be replaced with "10-20". This can be used on data
// of type: double, long. If the bound Value type differs from the type of data
// being transformed, we will first attempt converting the type of the data to
// be transformed to match the type of the bound before comparing. See
// https://cloud.google.com/sensitive-data-protection/docs/concepts-bucketing
// to learn more.
type GooglePrivacyDlpV2FixedSizeBucketingConfig struct {
	// BucketSize: Required. Size of each bucket (except for minimum and maximum
	// buckets). So if `lower_bound` = 10, `upper_bound` = 89, and `bucket_size` =
	// 10, then the following buckets would be used: -10, 10-20, 20-30, 30-40,
	// 40-50, 50-60, 60-70, 70-80, 80-89, 89+. Precision up to 2 decimals works.
	BucketSize float64 `json:"bucketSize,omitempty"`
	// LowerBound: Required. Lower bound value of buckets. All values less than
	// `lower_bound` are grouped together into a single bucket; for example if
	// `lower_bound` = 10, then all values less than 10 are replaced with the value
	// "-10".
	LowerBound *GooglePrivacyDlpV2Value `json:"lowerBound,omitempty"`
	// UpperBound: Required. Upper bound value of buckets. All values greater than
	// upper_bound are grouped together into a single bucket; for example if
	// `upper_bound` = 89, then all values greater than 89 are replaced with the
	// value "89+".
	UpperBound *GooglePrivacyDlpV2Value `json:"upperBound,omitempty"`
	// ForceSendFields is a list of field names (e.g. "BucketSize") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "BucketSize") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GooglePrivacyDlpV2FixedSizeBucketingConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GooglePrivacyDlpV2FixedSizeBucketingConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *GooglePrivacyDlpV2FixedSizeBucketingConfig) UnmarshalJSON(data []byte) error {
	type NoMethod GooglePrivacyDlpV2FixedSizeBucketingConfig
	var s1 struct {
		BucketSize gensupport.JSONFloat64 `json:"bucketSize"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.BucketSize = float64(s1.BucketSize)
	return nil
}

// GooglePrivacyDlpV2FullyInside: Defines a condition where one bounding box is
// fully inside another.
type GooglePrivacyDlpV2FullyInside struct {
}

// GooglePrivacyDlpV2GlobalProcessing: Processing occurs in the global region.
type GooglePrivacyDlpV2GlobalProcessing struct {
}

// GooglePrivacyDlpV2HotwordRule: The rule that adjusts the likelihood of
// findings within a certain proximity of hotwords.
type GooglePrivacyDlpV2HotwordRule struct {
	// HotwordRegex: Regular expression pattern defining what qualifies as a
	// hotword.
	HotwordRegex *GooglePrivacyDlpV2Regex `json:"hotwordRegex,omitempty"`
	// LikelihoodAdjustment: Likelihood adjustment to apply to all matching
	// findings.
	LikelihoodAdjustment *GooglePrivacyDlpV2LikelihoodAdjustment `json:"likelihoodAdjustment,omitempty"`
	// Proximity: Range of characters within which the entire hotword must reside.
	// The total length of the window cannot exceed 1000 characters. The finding
	// itself will be included in the window, so that hotwords can be used to match
	// substrings of the finding itself. Suppose you want Cloud DLP to promote the
	// likelihood of the phone number regex "\(\d{3}\) \d{3}-\d{4}" if the area
	// code is known to be the area code of a company's office. In this case, use
	// the hotword regex "\(xxx\)", where "xxx" is the area code in question. For
	// tabular data, if you want to modify the likelihood of an entire column of
	// findngs, see [Hotword example: Set the match likelihood of a table column]
	// (https://cloud.google.com/sensitive-data-protection/docs/creating-custom-infotypes-likelihood#match-column-values).
	Proximity *GooglePrivacyDlpV2Proximity `json:"proximity,omitempty"`
	// ForceSendFields is a list of field names (e.g. "HotwordRegex") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "HotwordRegex") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GooglePrivacyDlpV2HotwordRule) MarshalJSON() ([]byte, error) {
	type NoMethod GooglePrivacyDlpV2HotwordRule
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GooglePrivacyDlpV2HybridContentItem: An individual hybrid item to inspect.
// Will be stored temporarily during processing.
type GooglePrivacyDlpV2HybridContentItem struct {
	// FindingDetails: Supplementary information that will be added to each
	// finding.
	FindingDetails *GooglePrivacyDlpV2HybridFindingDetails `json:"findingDetails,omitempty"`
	// Item: The item to inspect.
	Item *GooglePrivacyDlpV2ContentItem `json:"item,omitempty"`
	// ForceSendFields is a list of field names (e.g. "FindingDetails") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "FindingDetails") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GooglePrivacyDlpV2HybridContentItem) MarshalJSON() ([]byte, error) {
	type NoMethod GooglePrivacyDlpV2HybridContentItem
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GooglePrivacyDlpV2HybridFindingDetails: Populate to associate additional
// data with each finding.
type GooglePrivacyDlpV2HybridFindingDetails struct {
	// ContainerDetails: Details about the container where the content being
	// inspected is from.
	ContainerDetails *GooglePrivacyDlpV2Container `json:"containerDetails,omitempty"`
	// FileOffset: Offset in bytes of the line, from the beginning of the file,
	// where the finding is located. Populate if the item being scanned is only
	// part of a bigger item, such as a shard of a file and you want to track the
	// absolute position of the finding.
	FileOffset int64 `json:"fileOffset,omitempty,string"`
	// Labels: Labels to represent user provided metadata about the data being
	// inspected. If configured by the job, some key values may be required. The
	// labels associated with `Finding`'s produced by hybrid inspection. Label keys
	// must be between 1 and 63 characters long and must conform to the following
	// regular expression: `a-z ([-a-z0-9]*[a-z0-9])?`. Label values must be
	// between 0 and 63 characters long and must conform to the regular expression
	// `([a-z]([-a-z0-9]*[a-z0-9])?)?`. No more than 10 labels can be associated
	// with a given finding. Examples: * "environment" : "production" *
	// "pipeline" : "etl"
	Labels map[string]string `json:"labels,omitempty"`
	// RowOffset: Offset of the row for tables. Populate if the row(s) being
	// scanned are part of a bigger dataset and you want to keep track of their
	// absolute position.
	RowOffset int64 `json:"rowOffset,omitempty,string"`
	// TableOptions: If the container is a table, additional information to make
	// findings meaningful such as the columns that are primary keys. If not known
	// ahead of time, can also be set within each inspect hybrid call and the two
	// will be merged. Note that identifying_fields will only be stored to
	// BigQuery, and only if the BigQuery action has been included.
	TableOptions *GooglePrivacyDlpV2TableOptions `json:"tableOptions,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ContainerDetails") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ContainerDetails") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GooglePrivacyDlpV2HybridFindingDetails) MarshalJSON() ([]byte, error) {
	type NoMethod GooglePrivacyDlpV2HybridFindingDetails
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GooglePrivacyDlpV2HybridInspectDlpJobRequest: Request to search for
// potentially sensitive info in a custom location.
type GooglePrivacyDlpV2HybridInspectDlpJobRequest struct {
	// HybridItem: The item to inspect.
	HybridItem *GooglePrivacyDlpV2HybridContentItem `json:"hybridItem,omitempty"`
	// ForceSendFields is a list of field names (e.g. "HybridItem") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "HybridItem") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GooglePrivacyDlpV2HybridInspectDlpJobRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GooglePrivacyDlpV2HybridInspectDlpJobRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GooglePrivacyDlpV2HybridInspectJobTriggerRequest: Request to search for
// potentially sensitive info in a custom location.
type GooglePrivacyDlpV2HybridInspectJobTriggerRequest struct {
	// HybridItem: The item to inspect.
	HybridItem *GooglePrivacyDlpV2HybridContentItem `json:"hybridItem,omitempty"`
	// ForceSendFields is a list of field names (e.g. "HybridItem") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "HybridItem") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GooglePrivacyDlpV2HybridInspectJobTriggerRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GooglePrivacyDlpV2HybridInspectJobTriggerRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GooglePrivacyDlpV2HybridInspectResponse: Quota exceeded errors will be
// thrown once quota has been met.
type GooglePrivacyDlpV2HybridInspectResponse struct {
	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
}

// GooglePrivacyDlpV2HybridInspectStatistics: Statistics related to processing
// hybrid inspect requests.
type GooglePrivacyDlpV2HybridInspectStatistics struct {
	// AbortedCount: The number of hybrid inspection requests aborted because the
	// job ran out of quota or was ended before they could be processed.
	AbortedCount int64 `json:"abortedCount,omitempty,string"`
	// PendingCount: The number of hybrid requests currently being processed. Only
	// populated when called via method `getDlpJob`. A burst of traffic may cause
	// hybrid inspect requests to be enqueued. Processing will take place as
	// quickly as possible, but resource limitations may impact how long a request
	// is enqueued for.
	PendingCount int64 `json:"pendingCount,omitempty,string"`
	// ProcessedCount: The number of hybrid inspection requests processed within
	// this job.
	ProcessedCount int64 `json:"processedCount,omitempty,string"`
	// ForceSendFields is a list of field names (e.g. "AbortedCount") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AbortedCount") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GooglePrivacyDlpV2HybridInspectStatistics) MarshalJSON() ([]byte, error) {
	type NoMethod GooglePrivacyDlpV2HybridInspectStatistics
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GooglePrivacyDlpV2HybridOptions: Configuration to control jobs where the
// content being inspected is outside of Google Cloud Platform.
type GooglePrivacyDlpV2HybridOptions struct {
	// Description: A short description of where the data is coming from. Will be
	// stored once in the job. 256 max length.
	Description string `json:"description,omitempty"`
	// Labels: To organize findings, these labels will be added to each finding.
	// Label keys must be between 1 and 63 characters long and must conform to the
	// following regular expression: `a-z ([-a-z0-9]*[a-z0-9])?`. Label values must
	// be between 0 and 63 characters long and must conform to the regular
	// expression `([a-z]([-a-z0-9]*[a-z0-9])?)?`. No more than 10 labels can be
	// associated with a given finding. Examples: * "environment" : "production"
	// * "pipeline" : "etl"
	Labels map[string]string `json:"labels,omitempty"`
	// RequiredFindingLabelKeys: These are labels that each inspection request must
	// include within their 'finding_labels' map. Request may contain others, but
	// any missing one of these will be rejected. Label keys must be between 1 and
	// 63 characters long and must conform to the following regular expression:
	// `[a-z]([-a-z0-9]*[a-z0-9])?`. No more than 10 keys can be required.
	RequiredFindingLabelKeys []string `json:"requiredFindingLabelKeys,omitempty"`
	// TableOptions: If the container is a table, additional information to make
	// findings meaningful such as the columns that are primary keys.
	TableOptions *GooglePrivacyDlpV2TableOptions `json:"tableOptions,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Description") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Description") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GooglePrivacyDlpV2HybridOptions) MarshalJSON() ([]byte, error) {
	type NoMethod GooglePrivacyDlpV2HybridOptions
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GooglePrivacyDlpV2ImageContainmentType: Specifies the relationship between
// bounding boxes for image findings.
type GooglePrivacyDlpV2ImageContainmentType struct {
	// Encloses: The context finding's bounding box must fully contain the target
	// finding's bounding box.
	Encloses *GooglePrivacyDlpV2Encloses `json:"encloses,omitempty"`
	// FullyInside: The context finding's bounding box must be fully inside the
	// target finding's bounding box.
	FullyInside *GooglePrivacyDlpV2FullyInside `json:"fullyInside,omitempty"`
	// Overlaps: The context finding's bounding box and the target finding's
	// bounding box must have a non-zero intersection.
	Overlaps *GooglePrivacyDlpV2Overlap `json:"overlaps,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Encloses") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Encloses") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GooglePrivacyDlpV2ImageContainmentType) MarshalJSON() ([]byte, error) {
	type NoMethod GooglePrivacyDlpV2ImageContainmentType
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GooglePrivacyDlpV2ImageFallbackLocation: Configure image processing to fall
// back to any of the following processing options if image processing is
// unavailable in the original request location.
type GooglePrivacyDlpV2ImageFallbackLocation struct {
	// GlobalProcessing: Processing occurs in the global region.
	GlobalProcessing *GooglePrivacyDlpV2GlobalProcessing `json:"globalProcessing,omitempty"`
	// MultiRegionProcessing: Processing occurs in a multi-region that contains the
	// current region if available.
	MultiRegionProcessing *GooglePrivacyDlpV2MultiRegionProcessing `json:"multiRegionProcessing,omitempty"`
	// ForceSendFields is a list of field names (e.g. "GlobalProcessing") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "GlobalProcessing") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GooglePrivacyDlpV2ImageFallbackLocation) MarshalJSON() ([]byte, error) {
	type NoMethod GooglePrivacyDlpV2ImageFallbackLocation
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GooglePrivacyDlpV2ImageLocation: Location of the finding within an image.
type GooglePrivacyDlpV2ImageLocation struct {
	// BoundingBoxes: Bounding boxes locating the pixels within the image
	// containing the finding.
	BoundingBoxes []*GooglePrivacyDlpV2BoundingBox `json:"boundingBoxes,omitempty"`
	// ForceSendFields is a list of field names (e.g. "BoundingBoxes") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "BoundingBoxes") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GooglePrivacyDlpV2ImageLocation) MarshalJSON() ([]byte, error) {
	type NoMethod GooglePrivacyDlpV2ImageLocation
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GooglePrivacyDlpV2ImageRedactionConfig: Configuration for determining how
// redaction of images should occur.
type GooglePrivacyDlpV2ImageRedactionConfig struct {
	// InfoType: Only one per info_type should be provided per request. If not
	// specified, and redact_all_text is false, the DLP API will redact all text
	// that it matches against all info_types that are found, but not specified in
	// another ImageRedactionConfig.
	InfoType *GooglePrivacyDlpV2InfoType `json:"infoType,omitempty"`
	// RedactAllText: If true, all text found in the image, regardless whether it
	// matches an info_type, is redacted. Only one should be provided.
	RedactAllText bool `json:"redactAllText,omitempty"`
	// RedactionColor: The color to use when redacting content from an image. If
	// not specified, the default is black.
	RedactionColor *GooglePrivacyDlpV2Color `json:"redactionColor,omitempty"`
	// ForceSendFields is a list of field names (e.g. "InfoType") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "InfoType") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GooglePrivacyDlpV2ImageRedactionConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GooglePrivacyDlpV2ImageRedactionConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GooglePrivacyDlpV2ImageTransformation: Configuration for determining how
// redaction of images should occur.
type GooglePrivacyDlpV2ImageTransformation struct {
	// AllInfoTypes: Apply transformation to all findings not specified in other
	// ImageTransformation's selected_info_types. Only one instance is allowed
	// within the ImageTransformations message.
	AllInfoTypes *GooglePrivacyDlpV2AllInfoTypes `json:"allInfoTypes,omitempty"`
	// AllText: Apply transformation to all text that doesn't match an infoType.
	// Only one instance is allowed within the ImageTransformations message.
	AllText *GooglePrivacyDlpV2AllText `json:"allText,omitempty"`
	// RedactionColor: The color to use when redacting content from an image. If
	// not specified, the default is black.
	RedactionColor *GooglePrivacyDlpV2Color `json:"redactionColor,omitempty"`
	// SelectedInfoTypes: Apply transformation to the selected info_types.
	SelectedInfoTypes *GooglePrivacyDlpV2SelectedInfoTypes `json:"selectedInfoTypes,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AllInfoTypes") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AllInfoTypes") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GooglePrivacyDlpV2ImageTransformation) MarshalJSON() ([]byte, error) {
	type NoMethod GooglePrivacyDlpV2ImageTransformation
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GooglePrivacyDlpV2ImageTransformations: A type of transformation that is
// applied over images.
type GooglePrivacyDlpV2ImageTransformations struct {
	// Transforms: List of transforms to make.
	Transforms []*GooglePrivacyDlpV2ImageTransformation `json:"transforms,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Transforms") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Transforms") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GooglePrivacyDlpV2ImageTransformations) MarshalJSON() ([]byte, error) {
	type NoMethod GooglePrivacyDlpV2ImageTransformations
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GooglePrivacyDlpV2InfoType: Type of information detected by the API.
type GooglePrivacyDlpV2InfoType struct {
	// Name: Name of the information type. Either a name of your choosing when
	// creating a CustomInfoType, or one of the names listed at
	// https://cloud.google.com/sensitive-data-protection/docs/infotypes-reference
	// when specifying a built-in type. When sending Cloud DLP results to Data
	// Catalog, infoType names should conform to the pattern
	// `[A-Za-z0-9$_-]{1,64}`.
	Name string `json:"name,omitempty"`
	// SensitivityScore: Optional custom sensitivity for this InfoType. This only
	// applies to data profiling.
	SensitivityScore *GooglePrivacyDlpV2SensitivityScore `json:"sensitivityScore,omitempty"`
	// Version: Optional version name for this InfoType.
	Version string `json:"version,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Name") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Name") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GooglePrivacyDlpV2InfoType) MarshalJSON() ([]byte, error) {
	type NoMethod GooglePrivacyDlpV2InfoType
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GooglePrivacyDlpV2InfoTypeCategory: Classification of infoTypes to organize
// them according to geographic location, industry, and data type.
type GooglePrivacyDlpV2InfoTypeCategory struct {
	// IndustryCategory: The group of relevant businesses where this infoType is
	// commonly used
	//
	// Possible values:
	//   "INDUSTRY_UNSPECIFIED" - Unused industry
	//   "FINANCE" - The infoType is typically used in the finance industry.
	//   "HEALTH" - The infoType is typically used in the health industry.
	//   "TELECOMMUNICATIONS" - The infoType is typically used in the
	// telecommunications industry.
	IndustryCategory string `json:"industryCategory,omitempty"`
	// LocationCategory: The region or country that issued the ID or document
	// represented by the infoType.
	//
	// Possible values:
	//   "LOCATION_UNSPECIFIED" - Unused location
	//   "GLOBAL" - The infoType is not issued by or tied to a specific region, but
	// is used almost everywhere.
	//   "ARGENTINA" - The infoType is typically used in Argentina.
	//   "ARMENIA" - The infoType is typically used in Armenia.
	//   "AUSTRALIA" - The infoType is typically used in Australia.
	//   "AUSTRIA" - The infoType is typically used in Austria.
	//   "AZERBAIJAN" - The infoType is typically used in Azerbaijan.
	//   "BELARUS" - The infoType is typically used in Belarus.
	//   "BELGIUM" - The infoType is typically used in Belgium.
	//   "BRAZIL" - The infoType is typically used in Brazil.
	//   "CANADA" - The infoType is typically used in Canada.
	//   "CHILE" - The infoType is typically used in Chile.
	//   "CHINA" - The infoType is typically used in China.
	//   "COLOMBIA" - The infoType is typically used in Colombia.
	//   "CROATIA" - The infoType is typically used in Croatia.
	//   "CZECHIA" - The infoType is typically used in Czechia.
	//   "DENMARK" - The infoType is typically used in Denmark.
	//   "FRANCE" - The infoType is typically used in France.
	//   "FINLAND" - The infoType is typically used in Finland.
	//   "GERMANY" - The infoType is typically used in Germany.
	//   "HONG_KONG" - The infoType is typically used in Hong Kong.
	//   "INDIA" - The infoType is typically used in India.
	//   "INDONESIA" - The infoType is typically used in Indonesia.
	//   "IRELAND" - The infoType is typically used in Ireland.
	//   "ISRAEL" - The infoType is typically used in Israel.
	//   "ITALY" - The infoType is typically used in Italy.
	//   "JAPAN" - The infoType is typically used in Japan.
	//   "KAZAKHSTAN" - The infoType is typically used in Kazakhstan.
	//   "KOREA" - The infoType is typically used in Korea.
	//   "MEXICO" - The infoType is typically used in Mexico.
	//   "THE_NETHERLANDS" - The infoType is typically used in the Netherlands.
	//   "NEW_ZEALAND" - The infoType is typically used in New Zealand.
	//   "NORWAY" - The infoType is typically used in Norway.
	//   "PARAGUAY" - The infoType is typically used in Paraguay.
	//   "PERU" - The infoType is typically used in Peru.
	//   "POLAND" - The infoType is typically used in Poland.
	//   "PORTUGAL" - The infoType is typically used in Portugal.
	//   "RUSSIA" - The infoType is typically used in Russia.
	//   "SINGAPORE" - The infoType is typically used in Singapore.
	//   "SOUTH_AFRICA" - The infoType is typically used in South Africa.
	//   "SPAIN" - The infoType is typically used in Spain.
	//   "SWEDEN" - The infoType is typically used in Sweden.
	//   "SWITZERLAND" - The infoType is typically used in Switzerland.
	//   "TAIWAN" - The infoType is typically used in Taiwan.
	//   "THAILAND" - The infoType is typically used in Thailand.
	//   "TURKEY" - The infoType is typically used in Turkey.
	//   "UKRAINE" - The infoType is typically used in Ukraine.
	//   "UNITED_KINGDOM" - The infoType is typically used in the United Kingdom.
	//   "UNITED_STATES" - The infoType is typically used in the United States.
	//   "URUGUAY" - The infoType is typically used in Uruguay.
	//   "UZBEKISTAN" - The infoType is typically used in Uzbekistan.
	//   "VENEZUELA" - The infoType is typically used in Venezuela.
	//   "INTERNAL" - The infoType is typically used in Google internally.
	LocationCategory string `json:"locationCategory,omitempty"`
	// TypeCategory: The class of identifiers where this infoType belongs
	//
	// Possible values:
	//   "TYPE_UNSPECIFIED" - Unused type
	//   "PII" - Personally identifiable information, for example, a name or phone
	// number
	//   "SPII" - Personally identifiable information that is especially sensitive,
	// for example, a passport number.
	//   "DEMOGRAPHIC" - Attributes that can partially identify someone, especially
	// in combination with other attributes, like age, height, and gender.
	//   "CREDENTIAL" - Confidential or secret information, for example, a
	// password.
	//   "GOVERNMENT_ID" - An identification document issued by a government.
	//   "DOCUMENT" - A document, for example, a resume or source code.
	//   "CONTEXTUAL_INFORMATION" - Information that is not sensitive on its own,
	// but provides details about the circumstances surrounding an entity or an
	// event.
	//   "CUSTOM" - Category for `CustomInfoType` types.
	TypeCategory string `json:"typeCategory,omitempty"`
	// ForceSendFields is a list of field names (e.g. "IndustryCategory") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "IndustryCategory") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GooglePrivacyDlpV2InfoTypeCategory) MarshalJSON() ([]byte, error) {
	type NoMethod GooglePrivacyDlpV2InfoTypeCategory
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GooglePrivacyDlpV2InfoTypeDescription: InfoType description.
type GooglePrivacyDlpV2InfoTypeDescription struct {
	// Categories: The category of the infoType.
	Categories []*GooglePrivacyDlpV2InfoTypeCategory `json:"categories,omitempty"`
	// Description: Description of the infotype. Translated when language is
	// provided in the request.
	Description string `json:"description,omitempty"`
	// DisplayName: Human readable form of the infoType name.
	DisplayName string `json:"displayName,omitempty"`
	// Example: A sample that is a true positive for this infoType.
	Example string `json:"example,omitempty"`
	// LaunchStatus: The launch status of the infoType.
	//
	// Possible values:
	//   "INFO_TYPE_LAUNCH_STATUS_UNSPECIFIED" - Unspecified.
	//   "GENERAL_AVAILABILITY" - InfoType is generally available.
	//   "PUBLIC_PREVIEW" - InfoType is in public preview.
	//   "PRIVATE_PREVIEW" - InfoType is in private preview.
	LaunchStatus string `json:"launchStatus,omitempty"`
	// LocationSupport: Locations at which this feature can be used. May change
	// over time.
	LocationSupport *GooglePrivacyDlpV2LocationSupport `json:"locationSupport,omitempty"`
	// Name: Internal name of the infoType.
	Name string `json:"name,omitempty"`
	// SensitivityScore: The default sensitivity of the infoType.
	SensitivityScore *GooglePrivacyDlpV2SensitivityScore `json:"sensitivityScore,omitempty"`
	// SpecificInfoTypes: If this field is set, this infoType is a general infoType
	// and these specific infoTypes are contained within it. General infoTypes are
	// infoTypes that encompass multiple specific infoTypes. For example, the
	// "GEOGRAPHIC_DATA" general infoType would have set for this field "LOCATION",
	// "LOCATION_COORDINATES", and "STREET_ADDRESS".
	SpecificInfoTypes []string `json:"specificInfoTypes,omitempty"`
	// SupportedBy: Which parts of the API supports this InfoType.
	//
	// Possible values:
	//   "ENUM_TYPE_UNSPECIFIED" - Unused.
	//   "INSPECT" - Supported by the inspect operations.
	//   "RISK_ANALYSIS" - Supported by the risk analysis operations.
	SupportedBy []string `json:"supportedBy,omitempty"`
	// Versions: A list of available versions for the infotype.
	Versions []*GooglePrivacyDlpV2VersionDescription `json:"versions,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Categories") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Categories") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GooglePrivacyDlpV2InfoTypeDescription) MarshalJSON() ([]byte, error) {
	type NoMethod GooglePrivacyDlpV2InfoTypeDescription
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GooglePrivacyDlpV2InfoTypeLikelihood: Configuration for setting a minimum
// likelihood per infotype. Used to customize the minimum likelihood level for
// specific infotypes in the request. For example, use this if you want to
// lower the precision for PERSON_NAME without lowering the precision for the
// other infotypes in the request.
type GooglePrivacyDlpV2InfoTypeLikelihood struct {
	// InfoType: Type of information the likelihood threshold applies to. Only one
	// likelihood per info_type should be provided. If InfoTypeLikelihood does not
	// have an info_type, the configuration fails.
	InfoType *GooglePrivacyDlpV2InfoType `json:"infoType,omitempty"`
	// MinLikelihood: Only returns findings equal to or above this threshold. This
	// field is required or else the configuration fails.
	//
	// Possible values:
	//   "LIKELIHOOD_UNSPECIFIED" - Default value; same as POSSIBLE.
	//   "VERY_UNLIKELY" - Highest chance of a false positive.
	//   "UNLIKELY" - High chance of a false positive.
	//   "POSSIBLE" - Some matching signals. The default value.
	//   "LIKELY" - Low chance of a false positive.
	//   "VERY_LIKELY" - Confidence level is high. Lowest chance of a false
	// positive.
	MinLikelihood string `json:"minLikelihood,omitempty"`
	// ForceSendFields is a list of field names (e.g. "InfoType") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "InfoType") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GooglePrivacyDlpV2InfoTypeLikelihood) MarshalJSON() ([]byte, error) {
	type NoMethod GooglePrivacyDlpV2InfoTypeLikelihood
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GooglePrivacyDlpV2InfoTypeLimit: Max findings configuration per infoType,
// per content item or long running DlpJob.
type GooglePrivacyDlpV2InfoTypeLimit struct {
	// InfoType: Type of information the findings limit applies to. Only one limit
	// per info_type should be provided. If InfoTypeLimit does not have an
	// info_type, the DLP API applies the limit against all info_types that are
	// found but not specified in another InfoTypeLimit.
	InfoType *GooglePrivacyDlpV2InfoType `json:"infoType,omitempty"`
	// MaxFindings: Max findings limit for the given infoType.
	MaxFindings int64 `json:"maxFindings,omitempty"`
	// ForceSendFields is a list of field names (e.g. "InfoType") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "InfoType") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GooglePrivacyDlpV2InfoTypeLimit) MarshalJSON() ([]byte, error) {
	type NoMethod GooglePrivacyDlpV2InfoTypeLimit
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GooglePrivacyDlpV2InfoTypeStats: Statistics regarding a specific InfoType.
type GooglePrivacyDlpV2InfoTypeStats struct {
	// Count: Number of findings for this infoType.
	Count int64 `json:"count,omitempty,string"`
	// InfoType: The type of finding this stat is for.
	InfoType *GooglePrivacyDlpV2InfoType `json:"infoType,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Count") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Count") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GooglePrivacyDlpV2InfoTypeStats) MarshalJSON() ([]byte, error) {
	type NoMethod GooglePrivacyDlpV2InfoTypeStats
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GooglePrivacyDlpV2InfoTypeSummary: The infoType details for this column.
type GooglePrivacyDlpV2InfoTypeSummary struct {
	// EstimatedPrevalence: Not populated for predicted infotypes.
	EstimatedPrevalence int64 `json:"estimatedPrevalence,omitempty"`
	// InfoType: The infoType.
	InfoType *GooglePrivacyDlpV2InfoType `json:"infoType,omitempty"`
	// ForceSendFields is a list of field names (e.g. "EstimatedPrevalence") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "EstimatedPrevalence") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GooglePrivacyDlpV2InfoTypeSummary) MarshalJSON() ([]byte, error) {
	type NoMethod GooglePrivacyDlpV2InfoTypeSummary
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GooglePrivacyDlpV2InfoTypeTransformation: A transformation to apply to text
// that is identified as a specific info_type.
type GooglePrivacyDlpV2InfoTypeTransformation struct {
	// InfoTypes: InfoTypes to apply the transformation to. An empty list will
	// cause this transformation to apply to all findings that correspond to
	// infoTypes that were requested in `InspectConfig`.
	InfoTypes []*GooglePrivacyDlpV2InfoType `json:"infoTypes,omitempty"`
	// PrimitiveTransformation: Required. Primitive transformation to apply to the
	// infoType.
	PrimitiveTransformation *GooglePrivacyDlpV2PrimitiveTransformation `json:"primitiveTransformation,omitempty"`
	// ForceSendFields is a list of field names (e.g. "InfoTypes") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "InfoTypes") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GooglePrivacyDlpV2InfoTypeTransformation) MarshalJSON() ([]byte, error) {
	type NoMethod GooglePrivacyDlpV2InfoTypeTransformation
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GooglePrivacyDlpV2InfoTypeTransformations: A type of transformation that
// will scan unstructured text and apply various `PrimitiveTransformation`s to
// each finding, where the transformation is applied to only values that were
// identified as a specific info_type.
type GooglePrivacyDlpV2InfoTypeTransformations struct {
	// Transformations: Required. Transformation for each infoType. Cannot specify
	// more than one for a given infoType.
	Transformations []*GooglePrivacyDlpV2InfoTypeTransformation `json:"transformations,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Transformations") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Transformations") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GooglePrivacyDlpV2InfoTypeTransformations) MarshalJSON() ([]byte, error) {
	type NoMethod GooglePrivacyDlpV2InfoTypeTransformations
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GooglePrivacyDlpV2InspectConfig: Configuration description of the scanning
// process. When used with redactContent only info_types and min_likelihood are
// currently used.
type GooglePrivacyDlpV2InspectConfig struct {
	// ContentOptions: Deprecated and unused.
	//
	// Possible values:
	//   "CONTENT_UNSPECIFIED" - Includes entire content of a file or a data
	// stream.
	//   "CONTENT_TEXT" - Text content within the data, excluding any metadata.
	//   "CONTENT_IMAGE" - Images found in the data.
	ContentOptions []string `json:"contentOptions,omitempty"`
	// CustomInfoTypes: CustomInfoTypes provided by the user. See
	// https://cloud.google.com/sensitive-data-protection/docs/creating-custom-infotypes
	// to learn more.
	CustomInfoTypes []*GooglePrivacyDlpV2CustomInfoType `json:"customInfoTypes,omitempty"`
	// ExcludeInfoTypes: When true, excludes type information of the findings. This
	// is not used for data profiling.
	ExcludeInfoTypes bool `json:"excludeInfoTypes,omitempty"`
	// IncludeQuote: When true, a contextual quote from the data that triggered a
	// finding is included in the response; see Finding.quote. This is not used for
	// data profiling.
	IncludeQuote bool `json:"includeQuote,omitempty"`
	// InfoTypes: Restricts what info_types to look for. The values must correspond
	// to InfoType values returned by ListInfoTypes or listed at
	// https://cloud.google.com/sensitive-data-protection/docs/infotypes-reference.
	// When no InfoTypes or CustomInfoTypes are specified in a request, the system
	// may automatically choose a default list of detectors to run, which may
	// change over time. If you need precise control and predictability as to what
	// detectors are run you should specify specific InfoTypes listed in the
	// reference, otherwise a default list will be used, which may change over
	// time.
	InfoTypes []*GooglePrivacyDlpV2InfoType `json:"infoTypes,omitempty"`
	// Limits: Configuration to control the number of findings returned. This is
	// not used for data profiling. When redacting sensitive data from images,
	// finding limits don't apply. They can cause unexpected or inconsistent
	// results, where only some data is redacted. Don't include finding limits in
	// RedactImage requests. Otherwise, Cloud DLP returns an error. When set within
	// an InspectJobConfig, the specified maximum values aren't hard limits. If an
	// inspection job reaches these limits, the job ends gradually, not abruptly.
	// Therefore, the actual number of findings that Cloud DLP returns can be
	// multiple times higher than these maximum values.
	Limits *GooglePrivacyDlpV2FindingLimits `json:"limits,omitempty"`
	// MinLikelihood: Only returns findings equal to or above this threshold. The
	// default is POSSIBLE. In general, the highest likelihood setting yields the
	// fewest findings in results and the lowest chance of a false positive. For
	// more information, see Match likelihood
	// (https://cloud.google.com/sensitive-data-protection/docs/likelihood).
	//
	// Possible values:
	//   "LIKELIHOOD_UNSPECIFIED" - Default value; same as POSSIBLE.
	//   "VERY_UNLIKELY" - Highest chance of a false positive.
	//   "UNLIKELY" - High chance of a false positive.
	//   "POSSIBLE" - Some matching signals. The default value.
	//   "LIKELY" - Low chance of a false positive.
	//   "VERY_LIKELY" - Confidence level is high. Lowest chance of a false
	// positive.
	MinLikelihood string `json:"minLikelihood,omitempty"`
	// MinLikelihoodPerInfoType: Minimum likelihood per infotype. For each
	// infotype, a user can specify a minimum likelihood. The system only returns a
	// finding if its likelihood is above this threshold. If this field is not set,
	// the system uses the InspectConfig min_likelihood.
	MinLikelihoodPerInfoType []*GooglePrivacyDlpV2InfoTypeLikelihood `json:"minLikelihoodPerInfoType,omitempty"`
	// RuleSet: Set of rules to apply to the findings for this InspectConfig.
	// Exclusion rules, contained in the set are executed in the end, other rules
	// are executed in the order they are specified for each info type.
	RuleSet []*GooglePrivacyDlpV2InspectionRuleSet `json:"ruleSet,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ContentOptions") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ContentOptions") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GooglePrivacyDlpV2InspectConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GooglePrivacyDlpV2InspectConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GooglePrivacyDlpV2InspectContentRequest: Request to search for potentially
// sensitive info in a ContentItem.
type GooglePrivacyDlpV2InspectContentRequest struct {
	// InspectConfig: Configuration for the inspector. What specified here will
	// override the template referenced by the inspect_template_name argument.
	InspectConfig *GooglePrivacyDlpV2InspectConfig `json:"inspectConfig,omitempty"`
	// InspectTemplateName: Template to use. Any configuration directly specified
	// in inspect_config will override those set in the template. Singular fields
	// that are set in this request will replace their corresponding fields in the
	// template. Repeated fields are appended. Singular sub-messages and groups are
	// recursively merged.
	InspectTemplateName string `json:"inspectTemplateName,omitempty"`
	// Item: The item to inspect.
	Item *GooglePrivacyDlpV2ContentItem `json:"item,omitempty"`
	// LocationId: Deprecated. This field has no effect.
	LocationId string `json:"locationId,omitempty"`
	// ForceSendFields is a list of field names (e.g. "InspectConfig") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "InspectConfig") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GooglePrivacyDlpV2InspectContentRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GooglePrivacyDlpV2InspectContentRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GooglePrivacyDlpV2InspectContentResponse: Results of inspecting an item.
type GooglePrivacyDlpV2InspectContentResponse struct {
	// Result: The findings.
	Result *GooglePrivacyDlpV2InspectResult `json:"result,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Result") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Result") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GooglePrivacyDlpV2InspectContentResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GooglePrivacyDlpV2InspectContentResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GooglePrivacyDlpV2InspectDataSourceDetails: The results of an inspect
// DataSource job.
type GooglePrivacyDlpV2InspectDataSourceDetails struct {
	// RequestedOptions: The configuration used for this job.
	RequestedOptions *GooglePrivacyDlpV2RequestedOptions `json:"requestedOptions,omitempty"`
	// Result: A summary of the outcome of this inspection job.
	Result *GooglePrivacyDlpV2Result `json:"result,omitempty"`
	// ForceSendFields is a list of field names (e.g. "RequestedOptions") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "RequestedOptions") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GooglePrivacyDlpV2InspectDataSourceDetails) MarshalJSON() ([]byte, error) {
	type NoMethod GooglePrivacyDlpV2InspectDataSourceDetails
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GooglePrivacyDlpV2InspectJobConfig: Controls what and how to inspect for
// findings.
type GooglePrivacyDlpV2InspectJobConfig struct {
	// Actions: Actions to execute at the completion of the job.
	Actions []*GooglePrivacyDlpV2Action `json:"actions,omitempty"`
	// InspectConfig: How and what to scan for.
	InspectConfig *GooglePrivacyDlpV2InspectConfig `json:"inspectConfig,omitempty"`
	// InspectTemplateName: If provided, will be used as the default for all values
	// in InspectConfig. `inspect_config` will be merged into the values persisted
	// as part of the template.
	InspectTemplateName string `json:"inspectTemplateName,omitempty"`
	// StorageConfig: The data to scan.
	StorageConfig *GooglePrivacyDlpV2StorageConfig `json:"storageConfig,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Actions") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Actions") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GooglePrivacyDlpV2InspectJobConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GooglePrivacyDlpV2InspectJobConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GooglePrivacyDlpV2InspectResult: All the findings for a single scanned item.
type GooglePrivacyDlpV2InspectResult struct {
	// Findings: List of findings for an item.
	Findings []*GooglePrivacyDlpV2Finding `json:"findings,omitempty"`
	// FindingsTruncated: If true, then this item might have more findings than
	// were returned, and the findings returned are an arbitrary subset of all
	// findings. The findings list might be truncated because the input items were
	// too large, or because the server reached the maximum amount of resources
	// allowed for a single API call. For best results, divide the input into
	// smaller batches.
	FindingsTruncated bool `json:"findingsTruncated,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Findings") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Findings") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GooglePrivacyDlpV2InspectResult) MarshalJSON() ([]byte, error) {
	type NoMethod GooglePrivacyDlpV2InspectResult
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GooglePrivacyDlpV2InspectTemplate: The inspectTemplate contains a
// configuration (set of types of sensitive data to be detected) to be used
// anywhere you otherwise would normally specify InspectConfig. See
// https://cloud.google.com/sensitive-data-protection/docs/concepts-templates
// to learn more.
type GooglePrivacyDlpV2InspectTemplate struct {
	// CreateTime: Output only. The creation timestamp of an inspectTemplate.
	CreateTime string `json:"createTime,omitempty"`
	// Description: Short description (max 256 chars).
	Description string `json:"description,omitempty"`
	// DisplayName: Display name (max 256 chars).
	DisplayName string `json:"displayName,omitempty"`
	// InspectConfig: The core content of the template. Configuration of the
	// scanning process.
	InspectConfig *GooglePrivacyDlpV2InspectConfig `json:"inspectConfig,omitempty"`
	// Name: Output only. The template name. The template will have one of the
	// following formats: `projects/PROJECT_ID/inspectTemplates/TEMPLATE_ID` OR
	// `organizations/ORGANIZATION_ID/inspectTemplates/TEMPLATE_ID`;
	Name string `json:"name,omitempty"`
	// UpdateTime: Output only. The last update timestamp of an inspectTemplate.
	UpdateTime string `json:"updateTime,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "CreateTime") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CreateTime") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GooglePrivacyDlpV2InspectTemplate) MarshalJSON() ([]byte, error) {
	type NoMethod GooglePrivacyDlpV2InspectTemplate
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GooglePrivacyDlpV2InspectionRule: A single inspection rule to be applied to
// infoTypes, specified in `InspectionRuleSet`.
type GooglePrivacyDlpV2InspectionRule struct {
	// AdjustmentRule: Adjustment rule.
	AdjustmentRule *GooglePrivacyDlpV2AdjustmentRule `json:"adjustmentRule,omitempty"`
	// ExclusionRule: Exclusion rule.
	ExclusionRule *GooglePrivacyDlpV2ExclusionRule `json:"exclusionRule,omitempty"`
	// HotwordRule: Hotword-based detection rule.
	HotwordRule *GooglePrivacyDlpV2HotwordRule `json:"hotwordRule,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AdjustmentRule") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AdjustmentRule") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GooglePrivacyDlpV2InspectionRule) MarshalJSON() ([]byte, error) {
	type NoMethod GooglePrivacyDlpV2InspectionRule
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GooglePrivacyDlpV2InspectionRuleSet: Rule set for modifying a set of
// infoTypes to alter behavior under certain circumstances, depending on the
// specific details of the rules within the set.
type GooglePrivacyDlpV2InspectionRuleSet struct {
	// InfoTypes: List of infoTypes this rule set is applied to.
	InfoTypes []*GooglePrivacyDlpV2InfoType `json:"infoTypes,omitempty"`
	// Rules: Set of rules to be applied to infoTypes. The rules are applied in
	// order.
	Rules []*GooglePrivacyDlpV2InspectionRule `json:"rules,omitempty"`
	// ForceSendFields is a list of field names (e.g. "InfoTypes") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "InfoTypes") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GooglePrivacyDlpV2InspectionRuleSet) MarshalJSON() ([]byte, error) {
	type NoMethod GooglePrivacyDlpV2InspectionRuleSet
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GooglePrivacyDlpV2JobNotificationEmails: Sends an email when the job
// completes. The email goes to IAM project owners and technical Essential
// Contacts
// (https://cloud.google.com/resource-manager/docs/managing-notification-contacts).
type GooglePrivacyDlpV2JobNotificationEmails struct {
}

// GooglePrivacyDlpV2JobTrigger: Contains a configuration to make API calls on
// a repeating basis. See
// https://cloud.google.com/sensitive-data-protection/docs/concepts-job-triggers
// to learn more.
type GooglePrivacyDlpV2JobTrigger struct {
	// CreateTime: Output only. The creation timestamp of a triggeredJob.
	CreateTime string `json:"createTime,omitempty"`
	// Description: User provided description (max 256 chars)
	Description string `json:"description,omitempty"`
	// DisplayName: Display name (max 100 chars)
	DisplayName string `json:"displayName,omitempty"`
	// Errors: Output only. A stream of errors encountered when the trigger was
	// activated. Repeated errors may result in the JobTrigger automatically being
	// paused. Will return the last 100 errors. Whenever the JobTrigger is modified
	// this list will be cleared.
	Errors []*GooglePrivacyDlpV2Error `json:"errors,omitempty"`
	// InspectJob: For inspect jobs, a snapshot of the configuration.
	InspectJob *GooglePrivacyDlpV2InspectJobConfig `json:"inspectJob,omitempty"`
	// LastRunTime: Output only. The timestamp of the last time this trigger
	// executed.
	LastRunTime string `json:"lastRunTime,omitempty"`
	// Name: Unique resource name for the triggeredJob, assigned by the service
	// when the triggeredJob is created, for example
	// `projects/dlp-test-project/jobTriggers/53234423`.
	Name string `json:"name,omitempty"`
	// Status: Required. A status for this trigger.
	//
	// Possible values:
	//   "STATUS_UNSPECIFIED" - Unused.
	//   "HEALTHY" - Trigger is healthy.
	//   "PAUSED" - Trigger is temporarily paused.
	//   "CANCELLED" - Trigger is cancelled and can not be resumed.
	Status string `json:"status,omitempty"`
	// Triggers: A list of triggers which will be OR'ed together. Only one in the
	// list needs to trigger for a job to be started. The list may contain only a
	// single Schedule trigger and must have at least one object.
	Triggers []*GooglePrivacyDlpV2Trigger `json:"triggers,omitempty"`
	// UpdateTime: Output only. The last update timestamp of a triggeredJob.
	UpdateTime string `json:"updateTime,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "CreateTime") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CreateTime") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GooglePrivacyDlpV2JobTrigger) MarshalJSON() ([]byte, error) {
	type NoMethod GooglePrivacyDlpV2JobTrigger
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GooglePrivacyDlpV2KAnonymityConfig: k-anonymity metric, used for analysis of
// reidentification risk.
type GooglePrivacyDlpV2KAnonymityConfig struct {
	// EntityId: Message indicating that multiple rows might be associated to a
	// single individual. If the same entity_id is associated to multiple
	// quasi-identifier tuples over distinct rows, we consider the entire
	// collection of tuples as the composite quasi-identifier. This collection is a
	// multiset: the order in which the different tuples appear in the dataset is
	// ignored, but their frequency is taken into account. Important note: a
	// maximum of 1000 rows can be associated to a single entity ID. If more rows
	// are associated with the same entity ID, some might be ignored.
	EntityId *GooglePrivacyDlpV2EntityId `json:"entityId,omitempty"`
	// QuasiIds: Set of fields to compute k-anonymity over. When multiple fields
	// are specified, they are considered a single composite key. Structs and
	// repeated data types are not supported; however, nested fields are supported
	// so long as they are not structs themselves or nested within a repeated
	// field.
	QuasiIds []*GooglePrivacyDlpV2FieldId `json:"quasiIds,omitempty"`
	// ForceSendFields is a list of field names (e.g. "EntityId") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "EntityId") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GooglePrivacyDlpV2KAnonymityConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GooglePrivacyDlpV2KAnonymityConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GooglePrivacyDlpV2KAnonymityEquivalenceClass: The set of columns' values
// that share the same ldiversity value
type GooglePrivacyDlpV2KAnonymityEquivalenceClass struct {
	// EquivalenceClassSize: Size of the equivalence class, for example number of
	// rows with the above set of values.
	EquivalenceClassSize int64 `json:"equivalenceClassSize,omitempty,string"`
	// QuasiIdsValues: Set of values defining the equivalence class. One value per
	// quasi-identifier column in the original KAnonymity metric message. The order
	// is always the same as the original request.
	QuasiIdsValues []*GooglePrivacyDlpV2Value `json:"quasiIdsValues,omitempty"`
	// ForceSendFields is a list of field names (e.g. "EquivalenceClassSize") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "EquivalenceClassSize") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GooglePrivacyDlpV2KAnonymityEquivalenceClass) MarshalJSON() ([]byte, error) {
	type NoMethod GooglePrivacyDlpV2KAnonymityEquivalenceClass
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GooglePrivacyDlpV2KAnonymityHistogramBucket: Histogram of k-anonymity
// equivalence classes.
type GooglePrivacyDlpV2KAnonymityHistogramBucket struct {
	// BucketSize: Total number of equivalence classes in this bucket.
	BucketSize int64 `json:"bucketSize,omitempty,string"`
	// BucketValueCount: Total number of distinct equivalence classes in this
	// bucket.
	BucketValueCount int64 `json:"bucketValueCount,omitempty,string"`
	// BucketValues: Sample of equivalence classes in this bucket. The total number
	// of classes returned per bucket is capped at 20.
	BucketValues []*GooglePrivacyDlpV2KAnonymityEquivalenceClass `json:"bucketValues,omitempty"`
	// EquivalenceClassSizeLowerBound: Lower bound on the size of the equivalence
	// classes in this bucket.
	EquivalenceClassSizeLowerBound int64 `json:"equivalenceClassSizeLowerBound,omitempty,string"`
	// EquivalenceClassSizeUpperBound: Upper bound on the size of the equivalence
	// classes in this bucket.
	EquivalenceClassSizeUpperBound int64 `json:"equivalenceClassSizeUpperBound,omitempty,string"`
	// ForceSendFields is a list of field names (e.g. "BucketSize") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "BucketSize") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GooglePrivacyDlpV2KAnonymityHistogramBucket) MarshalJSON() ([]byte, error) {
	type NoMethod GooglePrivacyDlpV2KAnonymityHistogramBucket
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GooglePrivacyDlpV2KAnonymityResult: Result of the k-anonymity computation.
type GooglePrivacyDlpV2KAnonymityResult struct {
	// EquivalenceClassHistogramBuckets: Histogram of k-anonymity equivalence
	// classes.
	EquivalenceClassHistogramBuckets []*GooglePrivacyDlpV2KAnonymityHistogramBucket `json:"equivalenceClassHistogramBuckets,omitempty"`
	// ForceSendFields is a list of field names (e.g.
	// "EquivalenceClassHistogramBuckets") to unconditionally include in API
	// requests. By default, fields with empty or default values are omitted from
	// API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g.
	// "EquivalenceClassHistogramBuckets") to include in API requests with the JSON
	// null value. By default, fields with empty values are omitted from API
	// requests. See https://pkg.go.dev/google.golang.org/api#hdr-NullFields for
	// more details.
	NullFields []string `json:"-"`
}

func (s GooglePrivacyDlpV2KAnonymityResult) MarshalJSON() ([]byte, error) {
	type NoMethod GooglePrivacyDlpV2KAnonymityResult
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GooglePrivacyDlpV2KMapEstimationConfig: Reidentifiability metric. This
// corresponds to a risk model similar to what is called "journalist risk" in
// the literature, except the attack dataset is statistically modeled instead
// of being perfectly known. This can be done using publicly available data
// (like the US Census), or using a custom statistical model (indicated as one
// or several BigQuery tables), or by extrapolating from the distribution of
// values in the input dataset.
type GooglePrivacyDlpV2KMapEstimationConfig struct {
	// AuxiliaryTables: Several auxiliary tables can be used in the analysis. Each
	// custom_tag used to tag a quasi-identifiers column must appear in exactly one
	// column of one auxiliary table.
	AuxiliaryTables []*GooglePrivacyDlpV2AuxiliaryTable `json:"auxiliaryTables,omitempty"`
	// QuasiIds: Required. Fields considered to be quasi-identifiers. No two
	// columns can have the same tag.
	QuasiIds []*GooglePrivacyDlpV2TaggedField `json:"quasiIds,omitempty"`
	// RegionCode: ISO 3166-1 alpha-2 region code to use in the statistical
	// modeling. Set if no column is tagged with a region-specific InfoType (like
	// US_ZIP_5) or a region code.
	RegionCode string `json:"regionCode,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AuxiliaryTables") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AuxiliaryTables") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GooglePrivacyDlpV2KMapEstimationConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GooglePrivacyDlpV2KMapEstimationConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GooglePrivacyDlpV2KMapEstimationHistogramBucket: A
// KMapEstimationHistogramBucket message with the following values:
// min_anonymity: 3 max_anonymity: 5 frequency: 42 means that there are 42
// records whose quasi-identifier values correspond to 3, 4 or 5 people in the
// overlying population. An important particular case is when min_anonymity =
// max_anonymity = 1: the frequency field then corresponds to the number of
// uniquely identifiable records.
type GooglePrivacyDlpV2KMapEstimationHistogramBucket struct {
	// BucketSize: Number of records within these anonymity bounds.
	BucketSize int64 `json:"bucketSize,omitempty,string"`
	// BucketValueCount: Total number of distinct quasi-identifier tuple values in
	// this bucket.
	BucketValueCount int64 `json:"bucketValueCount,omitempty,string"`
	// BucketValues: Sample of quasi-identifier tuple values in this bucket. The
	// total number of classes returned per bucket is capped at 20.
	BucketValues []*GooglePrivacyDlpV2KMapEstimationQuasiIdValues `json:"bucketValues,omitempty"`
	// MaxAnonymity: Always greater than or equal to min_anonymity.
	MaxAnonymity int64 `json:"maxAnonymity,omitempty,string"`
	// MinAnonymity: Always positive.
	MinAnonymity int64 `json:"minAnonymity,omitempty,string"`
	// ForceSendFields is a list of field names (e.g. "BucketSize") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "BucketSize") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GooglePrivacyDlpV2KMapEstimationHistogramBucket) MarshalJSON() ([]byte, error) {
	type NoMethod GooglePrivacyDlpV2KMapEstimationHistogramBucket
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GooglePrivacyDlpV2KMapEstimationQuasiIdValues: A tuple of values for the
// quasi-identifier columns.
type GooglePrivacyDlpV2KMapEstimationQuasiIdValues struct {
	// EstimatedAnonymity: The estimated anonymity for these quasi-identifier
	// values.
	EstimatedAnonymity int64 `json:"estimatedAnonymity,omitempty,string"`
	// QuasiIdsValues: The quasi-identifier values.
	QuasiIdsValues []*GooglePrivacyDlpV2Value `json:"quasiIdsValues,omitempty"`
	// ForceSendFields is a list of field names (e.g. "EstimatedAnonymity") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "EstimatedAnonymity") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GooglePrivacyDlpV2KMapEstimationQuasiIdValues) MarshalJSON() ([]byte, error) {
	type NoMethod GooglePrivacyDlpV2KMapEstimationQuasiIdValues
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GooglePrivacyDlpV2KMapEstimationResult: Result of the reidentifiability
// analysis. Note that these results are an estimation, not exact values.
type GooglePrivacyDlpV2KMapEstimationResult struct {
	// KMapEstimationHistogram: The intervals [min_anonymity, max_anonymity] do not
	// overlap. If a value doesn't correspond to any such interval, the associated
	// frequency is zero. For example, the following records: {min_anonymity: 1,
	// max_anonymity: 1, frequency: 17} {min_anonymity: 2, max_anonymity: 3,
	// frequency: 42} {min_anonymity: 5, max_anonymity: 10, frequency: 99} mean
	// that there are no record with an estimated anonymity of 4, 5, or larger than
	// 10.
	KMapEstimationHistogram []*GooglePrivacyDlpV2KMapEstimationHistogramBucket `json:"kMapEstimationHistogram,omitempty"`
	// ForceSendFields is a list of field names (e.g. "KMapEstimationHistogram") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "KMapEstimationHistogram") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GooglePrivacyDlpV2KMapEstimationResult) MarshalJSON() ([]byte, error) {
	type NoMethod GooglePrivacyDlpV2KMapEstimationResult
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GooglePrivacyDlpV2Key: A unique identifier for a Datastore entity. If a
// key's partition ID or any of its path kinds or names are reserved/read-only,
// the key is reserved/read-only. A reserved/read-only key is forbidden in
// certain documented contexts.
type GooglePrivacyDlpV2Key struct {
	// PartitionId: Entities are partitioned into subsets, currently identified by
	// a project ID and namespace ID. Queries are scoped to a single partition.
	PartitionId *GooglePrivacyDlpV2PartitionId `json:"partitionId,omitempty"`
	// Path: The entity path. An entity path consists of one or more elements
	// composed of a kind and a string or numerical identifier, which identify
	// entities. The first element identifies a _root entity_, the second element
	// identifies a _child_ of the root entity, the third element identifies a
	// child of the second entity, and so forth. The entities identified by all
	// prefixes of the path are called the element's _ancestors_. A path can never
	// be empty, and a path can have at most 100 elements.
	Path []*GooglePrivacyDlpV2PathElement `json:"path,omitempty"`
	// ForceSendFields is a list of field names (e.g. "PartitionId") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "PartitionId") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GooglePrivacyDlpV2Key) MarshalJSON() ([]byte, error) {
	type NoMethod GooglePrivacyDlpV2Key
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GooglePrivacyDlpV2KindExpression: A representation of a Datastore kind.
type GooglePrivacyDlpV2KindExpression struct {
	// Name: The name of the kind.
	Name string `json:"name,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Name") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Name") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GooglePrivacyDlpV2KindExpression) MarshalJSON() ([]byte, error) {
	type NoMethod GooglePrivacyDlpV2KindExpression
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GooglePrivacyDlpV2KmsWrappedCryptoKey: Include to use an existing data
// crypto key wrapped by KMS. The wrapped key must be a 128-, 192-, or 256-bit
// key. Authorization requires the following IAM permissions when sending a
// request to perform a crypto transformation using a KMS-wrapped crypto key:
// dlp.kms.encrypt For more information, see [Creating a wrapped key]
// (https://cloud.google.com/sensitive-data-protection/docs/create-wrapped-key).
// Note: When you use Cloud KMS for cryptographic operations, charges apply
// (https://cloud.google.com/kms/pricing).
type GooglePrivacyDlpV2KmsWrappedCryptoKey struct {
	// CryptoKeyName: Required. The resource name of the KMS CryptoKey to use for
	// unwrapping.
	CryptoKeyName string `json:"cryptoKeyName,omitempty"`
	// WrappedKey: Required. The wrapped data crypto key.
	WrappedKey string `json:"wrappedKey,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CryptoKeyName") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CryptoKeyName") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GooglePrivacyDlpV2KmsWrappedCryptoKey) MarshalJSON() ([]byte, error) {
	type NoMethod GooglePrivacyDlpV2KmsWrappedCryptoKey
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GooglePrivacyDlpV2LDiversityConfig: l-diversity metric, used for analysis of
// reidentification risk.
type GooglePrivacyDlpV2LDiversityConfig struct {
	// QuasiIds: Set of quasi-identifiers indicating how equivalence classes are
	// defined for the l-diversity computation. When multiple fields are specified,
	// they are considered a single composite key.
	QuasiIds []*GooglePrivacyDlpV2FieldId `json:"quasiIds,omitempty"`
	// SensitiveAttribute: Sensitive field for computing the l-value.
	SensitiveAttribute *GooglePrivacyDlpV2FieldId `json:"sensitiveAttribute,omitempty"`
	// ForceSendFields is a list of field names (e.g. "QuasiIds") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "QuasiIds") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GooglePrivacyDlpV2LDiversityConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GooglePrivacyDlpV2LDiversityConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GooglePrivacyDlpV2LDiversityEquivalenceClass: The set of columns' values
// that share the same ldiversity value.
type GooglePrivacyDlpV2LDiversityEquivalenceClass struct {
	// EquivalenceClassSize: Size of the k-anonymity equivalence class.
	EquivalenceClassSize int64 `json:"equivalenceClassSize,omitempty,string"`
	// NumDistinctSensitiveValues: Number of distinct sensitive values in this
	// equivalence class.
	NumDistinctSensitiveValues int64 `json:"numDistinctSensitiveValues,omitempty,string"`
	// QuasiIdsValues: Quasi-identifier values defining the k-anonymity equivalence
	// class. The order is always the same as the original request.
	QuasiIdsValues []*GooglePrivacyDlpV2Value `json:"quasiIdsValues,omitempty"`
	// TopSensitiveValues: Estimated frequencies of top sensitive values.
	TopSensitiveValues []*GooglePrivacyDlpV2ValueFrequency `json:"topSensitiveValues,omitempty"`
	// ForceSendFields is a list of field names (e.g. "EquivalenceClassSize") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "EquivalenceClassSize") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GooglePrivacyDlpV2LDiversityEquivalenceClass) MarshalJSON() ([]byte, error) {
	type NoMethod GooglePrivacyDlpV2LDiversityEquivalenceClass
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GooglePrivacyDlpV2LDiversityHistogramBucket: Histogram of l-diversity
// equivalence class sensitive value frequencies.
type GooglePrivacyDlpV2LDiversityHistogramBucket struct {
	// BucketSize: Total number of equivalence classes in this bucket.
	BucketSize int64 `json:"bucketSize,omitempty,string"`
	// BucketValueCount: Total number of distinct equivalence classes in this
	// bucket.
	BucketValueCount int64 `json:"bucketValueCount,omitempty,string"`
	// BucketValues: Sample of equivalence classes in this bucket. The total number
	// of classes returned per bucket is capped at 20.
	BucketValues []*GooglePrivacyDlpV2LDiversityEquivalenceClass `json:"bucketValues,omitempty"`
	// SensitiveValueFrequencyLowerBound: Lower bound on the sensitive value
	// frequencies of the equivalence classes in this bucket.
	SensitiveValueFrequencyLowerBound int64 `json:"sensitiveValueFrequencyLowerBound,omitempty,string"`
	// SensitiveValueFrequencyUpperBound: Upper bound on the sensitive value
	// frequencies of the equivalence classes in this bucket.
	SensitiveValueFrequencyUpperBound int64 `json:"sensitiveValueFrequencyUpperBound,omitempty,string"`
	// ForceSendFields is a list of field names (e.g. "BucketSize") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "BucketSize") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GooglePrivacyDlpV2LDiversityHistogramBucket) MarshalJSON() ([]byte, error) {
	type NoMethod GooglePrivacyDlpV2LDiversityHistogramBucket
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GooglePrivacyDlpV2LDiversityResult: Result of the l-diversity computation.
type GooglePrivacyDlpV2LDiversityResult struct {
	// SensitiveValueFrequencyHistogramBuckets: Histogram of l-diversity
	// equivalence class sensitive value frequencies.
	SensitiveValueFrequencyHistogramBuckets []*GooglePrivacyDlpV2LDiversityHistogramBucket `json:"sensitiveValueFrequencyHistogramBuckets,omitempty"`
	// ForceSendFields is a list of field names (e.g.
	// "SensitiveValueFrequencyHistogramBuckets") to unconditionally include in API
	// requests. By default, fields with empty or default values are omitted from
	// API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g.
	// "SensitiveValueFrequencyHistogramBuckets") to include in API requests with
	// the JSON null value. By default, fields with empty values are omitted from
	// API requests. See https://pkg.go.dev/google.golang.org/api#hdr-NullFields
	// for more details.
	NullFields []string `json:"-"`
}

func (s GooglePrivacyDlpV2LDiversityResult) MarshalJSON() ([]byte, error) {
	type NoMethod GooglePrivacyDlpV2LDiversityResult
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GooglePrivacyDlpV2LargeCustomDictionaryConfig: Configuration for a custom
// dictionary created from a data source of any size up to the maximum size
// defined in the limits
// (https://cloud.google.com/sensitive-data-protection/limits) page. The
// artifacts of dictionary creation are stored in the specified Cloud Storage
// location. Consider using `CustomInfoType.Dictionary` for smaller
// dictionaries that satisfy the size requirements.
type GooglePrivacyDlpV2LargeCustomDictionaryConfig struct {
	// BigQueryField: Field in a BigQuery table where each cell represents a
	// dictionary phrase.
	BigQueryField *GooglePrivacyDlpV2BigQueryField `json:"bigQueryField,omitempty"`
	// CloudStorageFileSet: Set of files containing newline-delimited lists of
	// dictionary phrases.
	CloudStorageFileSet *GooglePrivacyDlpV2CloudStorageFileSet `json:"cloudStorageFileSet,omitempty"`
	// OutputPath: Location to store dictionary artifacts in Cloud Storage. These
	// files will only be accessible by project owners and the DLP API. If any of
	// these artifacts are modified, the dictionary is considered invalid and can
	// no longer be used.
	OutputPath *GooglePrivacyDlpV2CloudStoragePath `json:"outputPath,omitempty"`
	// ForceSendFields is a list of field names (e.g. "BigQueryField") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "BigQueryField") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GooglePrivacyDlpV2LargeCustomDictionaryConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GooglePrivacyDlpV2LargeCustomDictionaryConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GooglePrivacyDlpV2LargeCustomDictionaryStats: Summary statistics of a custom
// dictionary.
type GooglePrivacyDlpV2LargeCustomDictionaryStats struct {
	// ApproxNumPhrases: Approximate number of distinct phrases in the dictionary.
	ApproxNumPhrases int64 `json:"approxNumPhrases,omitempty,string"`
	// ForceSendFields is a list of field names (e.g. "ApproxNumPhrases") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ApproxNumPhrases") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GooglePrivacyDlpV2LargeCustomDictionaryStats) MarshalJSON() ([]byte, error) {
	type NoMethod GooglePrivacyDlpV2LargeCustomDictionaryStats
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GooglePrivacyDlpV2LeaveUntransformed: Skips the data without modifying it if
// the requested transformation would cause an error. For example, if a
// `DateShift` transformation were applied an an IP address, this mode would
// leave the IP address unchanged in the response.
type GooglePrivacyDlpV2LeaveUntransformed struct {
}

// GooglePrivacyDlpV2LikelihoodAdjustment: Message for specifying an adjustment
// to the likelihood of a finding as part of a detection rule.
type GooglePrivacyDlpV2LikelihoodAdjustment struct {
	// FixedLikelihood: Set the likelihood of a finding to a fixed value.
	//
	// Possible values:
	//   "LIKELIHOOD_UNSPECIFIED" - Default value; same as POSSIBLE.
	//   "VERY_UNLIKELY" - Highest chance of a false positive.
	//   "UNLIKELY" - High chance of a false positive.
	//   "POSSIBLE" - Some matching signals. The default value.
	//   "LIKELY" - Low chance of a false positive.
	//   "VERY_LIKELY" - Confidence level is high. Lowest chance of a false
	// positive.
	FixedLikelihood string `json:"fixedLikelihood,omitempty"`
	// RelativeLikelihood: Increase or decrease the likelihood by the specified
	// number of levels. For example, if a finding would be `POSSIBLE` without the
	// detection rule and `relative_likelihood` is 1, then it is upgraded to
	// `LIKELY`, while a value of -1 would downgrade it to `UNLIKELY`. Likelihood
	// may never drop below `VERY_UNLIKELY` or exceed `VERY_LIKELY`, so applying an
	// adjustment of 1 followed by an adjustment of -1 when base likelihood is
	// `VERY_LIKELY` will result in a final likelihood of `LIKELY`.
	RelativeLikelihood int64 `json:"relativeLikelihood,omitempty"`
	// ForceSendFields is a list of field names (e.g. "FixedLikelihood") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "FixedLikelihood") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GooglePrivacyDlpV2LikelihoodAdjustment) MarshalJSON() ([]byte, error) {
	type NoMethod GooglePrivacyDlpV2LikelihoodAdjustment
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GooglePrivacyDlpV2ListColumnDataProfilesResponse: List of profiles generated
// for a given organization or project.
type GooglePrivacyDlpV2ListColumnDataProfilesResponse struct {
	// ColumnDataProfiles: List of data profiles.
	ColumnDataProfiles []*GooglePrivacyDlpV2ColumnDataProfile `json:"columnDataProfiles,omitempty"`
	// NextPageToken: The next page token.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "ColumnDataProfiles") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ColumnDataProfiles") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GooglePrivacyDlpV2ListColumnDataProfilesResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GooglePrivacyDlpV2ListColumnDataProfilesResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GooglePrivacyDlpV2ListConnectionsResponse: Response message for
// ListConnections.
type GooglePrivacyDlpV2ListConnectionsResponse struct {
	// Connections: List of connections.
	Connections []*GooglePrivacyDlpV2Connection `json:"connections,omitempty"`
	// NextPageToken: Token to retrieve the next page of results. An empty value
	// means there are no more results.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Connections") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Connections") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GooglePrivacyDlpV2ListConnectionsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GooglePrivacyDlpV2ListConnectionsResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GooglePrivacyDlpV2ListDeidentifyTemplatesResponse: Response message for
// ListDeidentifyTemplates.
type GooglePrivacyDlpV2ListDeidentifyTemplatesResponse struct {
	// DeidentifyTemplates: List of deidentify templates, up to page_size in
	// ListDeidentifyTemplatesRequest.
	DeidentifyTemplates []*GooglePrivacyDlpV2DeidentifyTemplate `json:"deidentifyTemplates,omitempty"`
	// NextPageToken: If the next page is available then the next page token to be
	// used in the following ListDeidentifyTemplates request.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "DeidentifyTemplates") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DeidentifyTemplates") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GooglePrivacyDlpV2ListDeidentifyTemplatesResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GooglePrivacyDlpV2ListDeidentifyTemplatesResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GooglePrivacyDlpV2ListDiscoveryConfigsResponse: Response message for
// ListDiscoveryConfigs.
type GooglePrivacyDlpV2ListDiscoveryConfigsResponse struct {
	// DiscoveryConfigs: List of configs, up to page_size in
	// ListDiscoveryConfigsRequest.
	DiscoveryConfigs []*GooglePrivacyDlpV2DiscoveryConfig `json:"discoveryConfigs,omitempty"`
	// NextPageToken: If the next page is available then this value is the next
	// page token to be used in the following ListDiscoveryConfigs request.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "DiscoveryConfigs") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DiscoveryConfigs") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GooglePrivacyDlpV2ListDiscoveryConfigsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GooglePrivacyDlpV2ListDiscoveryConfigsResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GooglePrivacyDlpV2ListDlpJobsResponse: The response message for listing DLP
// jobs.
type GooglePrivacyDlpV2ListDlpJobsResponse struct {
	// Jobs: A list of DlpJobs that matches the specified filter in the request.
	Jobs []*GooglePrivacyDlpV2DlpJob `json:"jobs,omitempty"`
	// NextPageToken: The standard List next-page token.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Jobs") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Jobs") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GooglePrivacyDlpV2ListDlpJobsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GooglePrivacyDlpV2ListDlpJobsResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GooglePrivacyDlpV2ListFileStoreDataProfilesResponse: List of file store data
// profiles generated for a given organization or project.
type GooglePrivacyDlpV2ListFileStoreDataProfilesResponse struct {
	// FileStoreDataProfiles: List of data profiles.
	FileStoreDataProfiles []*GooglePrivacyDlpV2FileStoreDataProfile `json:"fileStoreDataProfiles,omitempty"`
	// NextPageToken: The next page token.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "FileStoreDataProfiles") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "FileStoreDataProfiles") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GooglePrivacyDlpV2ListFileStoreDataProfilesResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GooglePrivacyDlpV2ListFileStoreDataProfilesResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GooglePrivacyDlpV2ListInfoTypesResponse: Response to the ListInfoTypes
// request.
type GooglePrivacyDlpV2ListInfoTypesResponse struct {
	// InfoTypes: Set of sensitive infoTypes.
	InfoTypes []*GooglePrivacyDlpV2InfoTypeDescription `json:"infoTypes,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "InfoTypes") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "InfoTypes") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GooglePrivacyDlpV2ListInfoTypesResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GooglePrivacyDlpV2ListInfoTypesResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GooglePrivacyDlpV2ListInspectTemplatesResponse: Response message for
// ListInspectTemplates.
type GooglePrivacyDlpV2ListInspectTemplatesResponse struct {
	// InspectTemplates: List of inspectTemplates, up to page_size in
	// ListInspectTemplatesRequest.
	InspectTemplates []*GooglePrivacyDlpV2InspectTemplate `json:"inspectTemplates,omitempty"`
	// NextPageToken: If the next page is available then the next page token to be
	// used in the following ListInspectTemplates request.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "InspectTemplates") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "InspectTemplates") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GooglePrivacyDlpV2ListInspectTemplatesResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GooglePrivacyDlpV2ListInspectTemplatesResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GooglePrivacyDlpV2ListJobTriggersResponse: Response message for
// ListJobTriggers.
type GooglePrivacyDlpV2ListJobTriggersResponse struct {
	// JobTriggers: List of triggeredJobs, up to page_size in
	// ListJobTriggersRequest.
	JobTriggers []*GooglePrivacyDlpV2JobTrigger `json:"jobTriggers,omitempty"`
	// NextPageToken: If the next page is available then this value is the next
	// page token to be used in the following ListJobTriggers request.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "JobTriggers") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "JobTriggers") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GooglePrivacyDlpV2ListJobTriggersResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GooglePrivacyDlpV2ListJobTriggersResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GooglePrivacyDlpV2ListProjectDataProfilesResponse: List of profiles
// generated for a given organization or project.
type GooglePrivacyDlpV2ListProjectDataProfilesResponse struct {
	// NextPageToken: The next page token.
	NextPageToken string `json:"nextPageToken,omitempty"`
	// ProjectDataProfiles: List of data profiles.
	ProjectDataProfiles []*GooglePrivacyDlpV2ProjectDataProfile `json:"projectDataProfiles,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "NextPageToken") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "NextPageToken") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GooglePrivacyDlpV2ListProjectDataProfilesResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GooglePrivacyDlpV2ListProjectDataProfilesResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GooglePrivacyDlpV2ListStoredInfoTypesResponse: Response message for
// ListStoredInfoTypes.
type GooglePrivacyDlpV2ListStoredInfoTypesResponse struct {
	// NextPageToken: If the next page is available then the next page token to be
	// used in the following ListStoredInfoTypes request.
	NextPageToken string `json:"nextPageToken,omitempty"`
	// StoredInfoTypes: List of storedInfoTypes, up to page_size in
	// ListStoredInfoTypesRequest.
	StoredInfoTypes []*GooglePrivacyDlpV2StoredInfoType `json:"storedInfoTypes,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "NextPageToken") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "NextPageToken") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GooglePrivacyDlpV2ListStoredInfoTypesResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GooglePrivacyDlpV2ListStoredInfoTypesResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GooglePrivacyDlpV2ListTableDataProfilesResponse: List of profiles generated
// for a given organization or project.
type GooglePrivacyDlpV2ListTableDataProfilesResponse struct {
	// NextPageToken: The next page token.
	NextPageToken string `json:"nextPageToken,omitempty"`
	// TableDataProfiles: List of data profiles.
	TableDataProfiles []*GooglePrivacyDlpV2TableDataProfile `json:"tableDataProfiles,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "NextPageToken") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "NextPageToken") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GooglePrivacyDlpV2ListTableDataProfilesResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GooglePrivacyDlpV2ListTableDataProfilesResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GooglePrivacyDlpV2Location: Specifies the location of the finding.
type GooglePrivacyDlpV2Location struct {
	// ByteRange: Zero-based byte offsets delimiting the finding. These are
	// relative to the finding's containing element. Note that when the content is
	// not textual, this references the UTF-8 encoded textual representation of the
	// content. Omitted if content is an image.
	ByteRange *GooglePrivacyDlpV2Range `json:"byteRange,omitempty"`
	// CodepointRange: Unicode character offsets delimiting the finding. These are
	// relative to the finding's containing element. Provided when the content is
	// text.
	CodepointRange *GooglePrivacyDlpV2Range `json:"codepointRange,omitempty"`
	// Container: Information about the container where this finding occurred, if
	// available.
	Container *GooglePrivacyDlpV2Container `json:"container,omitempty"`
	// ContentLocations: List of nested objects pointing to the precise location of
	// the finding within the file or record.
	ContentLocations []*GooglePrivacyDlpV2ContentLocation `json:"contentLocations,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ByteRange") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ByteRange") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GooglePrivacyDlpV2Location) MarshalJSON() ([]byte, error) {
	type NoMethod GooglePrivacyDlpV2Location
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GooglePrivacyDlpV2LocationSupport: Locations at which a feature can be used.
type GooglePrivacyDlpV2LocationSupport struct {
	// Locations: Specific locations where the feature may be used. Examples:
	// us-central1, us, asia, global If scope is ANY_LOCATION, no regions will be
	// listed.
	Locations []string `json:"locations,omitempty"`
	// RegionalizationScope: The current scope for location on this feature. This
	// may expand over time.
	//
	// Possible values:
	//   "REGIONALIZATION_SCOPE_UNSPECIFIED" - Invalid.
	//   "REGIONAL" - Feature may be used with one or more regions. See locations
	// for details.
	//   "ANY_LOCATION" - Feature may be used anywhere. Default value.
	RegionalizationScope string `json:"regionalizationScope,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Locations") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Locations") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GooglePrivacyDlpV2LocationSupport) MarshalJSON() ([]byte, error) {
	type NoMethod GooglePrivacyDlpV2LocationSupport
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GooglePrivacyDlpV2Manual: Job trigger option for hybrid jobs. Jobs must be
// manually created and finished.
type GooglePrivacyDlpV2Manual struct {
}

// GooglePrivacyDlpV2MetadataLocation: Metadata Location
type GooglePrivacyDlpV2MetadataLocation struct {
	// StorageLabel: Storage metadata.
	StorageLabel *GooglePrivacyDlpV2StorageMetadataLabel `json:"storageLabel,omitempty"`
	// Type: Type of metadata containing the finding.
	//
	// Possible values:
	//   "METADATATYPE_UNSPECIFIED" - Unused
	//   "STORAGE_METADATA" - General file metadata provided by Cloud Storage.
	Type string `json:"type,omitempty"`
	// ForceSendFields is a list of field names (e.g. "StorageLabel") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "StorageLabel") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GooglePrivacyDlpV2MetadataLocation) MarshalJSON() ([]byte, error) {
	type NoMethod GooglePrivacyDlpV2MetadataLocation
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GooglePrivacyDlpV2MultiRegionProcessing: Processing occurs in a multi-region
// that contains the current region if available.
type GooglePrivacyDlpV2MultiRegionProcessing struct {
}

// GooglePrivacyDlpV2NumericalStatsConfig: Compute numerical stats over an
// individual column, including min, max, and quantiles.
type GooglePrivacyDlpV2NumericalStatsConfig struct {
	// Field: Field to compute numerical stats on. Supported types are integer,
	// float, date, datetime, timestamp, time.
	Field *GooglePrivacyDlpV2FieldId `json:"field,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Field") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Field") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GooglePrivacyDlpV2NumericalStatsConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GooglePrivacyDlpV2NumericalStatsConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GooglePrivacyDlpV2NumericalStatsResult: Result of the numerical stats
// computation.
type GooglePrivacyDlpV2NumericalStatsResult struct {
	// MaxValue: Maximum value appearing in the column.
	MaxValue *GooglePrivacyDlpV2Value `json:"maxValue,omitempty"`
	// MinValue: Minimum value appearing in the column.
	MinValue *GooglePrivacyDlpV2Value `json:"minValue,omitempty"`
	// QuantileValues: List of 99 values that partition the set of field values
	// into 100 equal sized buckets.
	QuantileValues []*GooglePrivacyDlpV2Value `json:"quantileValues,omitempty"`
	// ForceSendFields is a list of field names (e.g. "MaxValue") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "MaxValue") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GooglePrivacyDlpV2NumericalStatsResult) MarshalJSON() ([]byte, error) {
	type NoMethod GooglePrivacyDlpV2NumericalStatsResult
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GooglePrivacyDlpV2OrConditions: There is an OR relationship between these
// attributes. They are used to determine if a table should be scanned or not
// in Discovery.
type GooglePrivacyDlpV2OrConditions struct {
	// MinAge: Minimum age a table must have before Cloud DLP can profile it. Value
	// must be 1 hour or greater.
	MinAge string `json:"minAge,omitempty"`
	// MinRowCount: Minimum number of rows that should be present before Cloud DLP
	// profiles a table
	MinRowCount int64 `json:"minRowCount,omitempty"`
	// ForceSendFields is a list of field names (e.g. "MinAge") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "MinAge") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GooglePrivacyDlpV2OrConditions) MarshalJSON() ([]byte, error) {
	type NoMethod GooglePrivacyDlpV2OrConditions
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GooglePrivacyDlpV2OrgConfig: Project and scan location information. Only set
// when the parent is an org.
type GooglePrivacyDlpV2OrgConfig struct {
	// Location: The data to scan: folder, org, or project
	Location *GooglePrivacyDlpV2DiscoveryStartingLocation `json:"location,omitempty"`
	// ProjectId: The project that will run the scan. The DLP service account that
	// exists within this project must have access to all resources that are
	// profiled, and the DLP API must be enabled.
	ProjectId string `json:"projectId,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Location") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Location") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GooglePrivacyDlpV2OrgConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GooglePrivacyDlpV2OrgConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GooglePrivacyDlpV2OtherCloudDiscoveryStartingLocation: The other cloud
// starting location for discovery.
type GooglePrivacyDlpV2OtherCloudDiscoveryStartingLocation struct {
	// AwsLocation: The AWS starting location for discovery.
	AwsLocation *GooglePrivacyDlpV2AwsDiscoveryStartingLocation `json:"awsLocation,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AwsLocation") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AwsLocation") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GooglePrivacyDlpV2OtherCloudDiscoveryStartingLocation) MarshalJSON() ([]byte, error) {
	type NoMethod GooglePrivacyDlpV2OtherCloudDiscoveryStartingLocation
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GooglePrivacyDlpV2OtherCloudDiscoveryTarget: Target used to match against
// for discovery of resources from other clouds. An AWS connector in Security
// Command Center (Enterprise
// (https://cloud.google.com/security-command-center/docs/connect-scc-to-aws)
// is required to use this feature.
type GooglePrivacyDlpV2OtherCloudDiscoveryTarget struct {
	// Conditions: Optional. In addition to matching the filter, these conditions
	// must be true before a profile is generated.
	Conditions *GooglePrivacyDlpV2DiscoveryOtherCloudConditions `json:"conditions,omitempty"`
	// DataSourceType: Required. The type of data profiles generated by this
	// discovery target. Supported values are: * aws/s3/bucket
	DataSourceType *GooglePrivacyDlpV2DataSourceType `json:"dataSourceType,omitempty"`
	// Disabled: Disable profiling for resources that match this filter.
	Disabled *GooglePrivacyDlpV2Disabled `json:"disabled,omitempty"`
	// Filter: Required. The resources that the discovery cadence applies to. The
	// first target with a matching filter will be the one to apply to a resource.
	Filter *GooglePrivacyDlpV2DiscoveryOtherCloudFilter `json:"filter,omitempty"`
	// GenerationCadence: How often and when to update data profiles. New resources
	// that match both the filter and conditions are scanned as quickly as possible
	// depending on system capacity.
	GenerationCadence *GooglePrivacyDlpV2DiscoveryOtherCloudGenerationCadence `json:"generationCadence,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Conditions") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Conditions") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GooglePrivacyDlpV2OtherCloudDiscoveryTarget) MarshalJSON() ([]byte, error) {
	type NoMethod GooglePrivacyDlpV2OtherCloudDiscoveryTarget
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GooglePrivacyDlpV2OtherCloudResourceCollection: Match resources using regex
// filters.
type GooglePrivacyDlpV2OtherCloudResourceCollection struct {
	// IncludeRegexes: A collection of regular expressions to match a resource
	// against.
	IncludeRegexes *GooglePrivacyDlpV2OtherCloudResourceRegexes `json:"includeRegexes,omitempty"`
	// ForceSendFields is a list of field names (e.g. "IncludeRegexes") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "IncludeRegexes") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GooglePrivacyDlpV2OtherCloudResourceCollection) MarshalJSON() ([]byte, error) {
	type NoMethod GooglePrivacyDlpV2OtherCloudResourceCollection
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GooglePrivacyDlpV2OtherCloudResourceRegex: A pattern to match against one or
// more resources. At least one pattern must be specified. Regular expressions
// use RE2 syntax (https://github.com/google/re2/wiki/Syntax); a guide can be
// found under the google/re2 repository on GitHub.
type GooglePrivacyDlpV2OtherCloudResourceRegex struct {
	// AmazonS3BucketRegex: Regex for Amazon S3 buckets.
	AmazonS3BucketRegex *GooglePrivacyDlpV2AmazonS3BucketRegex `json:"amazonS3BucketRegex,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AmazonS3BucketRegex") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AmazonS3BucketRegex") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GooglePrivacyDlpV2OtherCloudResourceRegex) MarshalJSON() ([]byte, error) {
	type NoMethod GooglePrivacyDlpV2OtherCloudResourceRegex
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GooglePrivacyDlpV2OtherCloudResourceRegexes: A collection of regular
// expressions to determine what resources to match against.
type GooglePrivacyDlpV2OtherCloudResourceRegexes struct {
	// Patterns: A group of regular expression patterns to match against one or
	// more resources. Maximum of 100 entries. The sum of all regular expression's
	// length can't exceed 10 KiB.
	Patterns []*GooglePrivacyDlpV2OtherCloudResourceRegex `json:"patterns,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Patterns") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Patterns") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GooglePrivacyDlpV2OtherCloudResourceRegexes) MarshalJSON() ([]byte, error) {
	type NoMethod GooglePrivacyDlpV2OtherCloudResourceRegexes
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GooglePrivacyDlpV2OtherCloudSingleResourceReference: Identifies a single
// resource, like a single Amazon S3 bucket.
type GooglePrivacyDlpV2OtherCloudSingleResourceReference struct {
	// AmazonS3Bucket: Amazon S3 bucket.
	AmazonS3Bucket *GooglePrivacyDlpV2AmazonS3Bucket `json:"amazonS3Bucket,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AmazonS3Bucket") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AmazonS3Bucket") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GooglePrivacyDlpV2OtherCloudSingleResourceReference) MarshalJSON() ([]byte, error) {
	type NoMethod GooglePrivacyDlpV2OtherCloudSingleResourceReference
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GooglePrivacyDlpV2OtherInfoTypeSummary: Infotype details for other infoTypes
// found within a column.
type GooglePrivacyDlpV2OtherInfoTypeSummary struct {
	// EstimatedPrevalence: Approximate percentage of non-null rows that contained
	// data detected by this infotype.
	EstimatedPrevalence int64 `json:"estimatedPrevalence,omitempty"`
	// ExcludedFromAnalysis: Whether this infoType was excluded from sensitivity
	// and risk analysis due to factors such as low prevalence (subject to change).
	ExcludedFromAnalysis bool `json:"excludedFromAnalysis,omitempty"`
	// InfoType: The other infoType.
	InfoType *GooglePrivacyDlpV2InfoType `json:"infoType,omitempty"`
	// ForceSendFields is a list of field names (e.g. "EstimatedPrevalence") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "EstimatedPrevalence") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GooglePrivacyDlpV2OtherInfoTypeSummary) MarshalJSON() ([]byte, error) {
	type NoMethod GooglePrivacyDlpV2OtherInfoTypeSummary
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GooglePrivacyDlpV2OutputStorageConfig: Cloud repository for storing output.
type GooglePrivacyDlpV2OutputStorageConfig struct {
	// OutputSchema: Schema used for writing the findings for Inspect jobs. This
	// field is only used for Inspect and must be unspecified for Risk jobs.
	// Columns are derived from the `Finding` object. If appending to an existing
	// table, any columns from the predefined schema that are missing will be
	// added. No columns in the existing table will be deleted. If unspecified,
	// then all available columns will be used for a new table or an (existing)
	// table with no schema, and no changes will be made to an existing table that
	// has a schema. Only for use with external storage.
	//
	// Possible values:
	//   "OUTPUT_SCHEMA_UNSPECIFIED" - Unused.
	//   "BASIC_COLUMNS" - Basic schema including only `info_type`, `quote`,
	// `certainty`, and `timestamp`.
	//   "GCS_COLUMNS" - Schema tailored to findings from scanning Cloud Storage.
	//   "DATASTORE_COLUMNS" - Schema tailored to findings from scanning Google
	// Datastore.
	//   "BIG_QUERY_COLUMNS" - Schema tailored to findings from scanning Google
	// BigQuery.
	//   "ALL_COLUMNS" - Schema containing all columns.
	OutputSchema string `json:"outputSchema,omitempty"`
	// StoragePath: Store findings in an existing Cloud Storage bucket. Files will
	// be generated with the job ID and file part number as the filename and will
	// contain findings in textproto format as SaveToGcsFindingsOutput. The
	// filename will follow the naming convention `-`. Example: `my-job-id-2`.
	// Supported for Inspect jobs. The bucket must not be the same as the bucket
	// being inspected. If storing findings to Cloud Storage, the output schema
	// field should not be set. If set, it will be ignored.
	StoragePath *GooglePrivacyDlpV2CloudStoragePath `json:"storagePath,omitempty"`
	// Table: Store findings in an existing table or a new table in an existing
	// dataset. If table_id is not set a new one will be generated for you with the
	// following format: dlp_googleapis_yyyy_mm_dd_[dlp_job_id]. Pacific time zone
	// will be used for generating the date details. For Inspect, each column in an
	// existing output table must have the same name, type, and mode of a field in
	// the `Finding` object. For Risk, an existing output table should be the
	// output of a previous Risk analysis job run on the same source table, with
	// the same privacy metric and quasi-identifiers. Risk jobs that analyze the
	// same table but compute a different privacy metric, or use different sets of
	// quasi-identifiers, cannot store their results in the same table.
	Table *GooglePrivacyDlpV2BigQueryTable `json:"table,omitempty"`
	// ForceSendFields is a list of field names (e.g. "OutputSchema") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "OutputSchema") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GooglePrivacyDlpV2OutputStorageConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GooglePrivacyDlpV2OutputStorageConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GooglePrivacyDlpV2Overlap: Defines a condition for overlapping bounding
// boxes.
type GooglePrivacyDlpV2Overlap struct {
}

// GooglePrivacyDlpV2PartitionId: Datastore partition ID. A partition ID
// identifies a grouping of entities. The grouping is always by project and
// namespace, however the namespace ID may be empty. A partition ID contains
// several dimensions: project ID and namespace ID.
type GooglePrivacyDlpV2PartitionId struct {
	// NamespaceId: If not empty, the ID of the namespace to which the entities
	// belong.
	NamespaceId string `json:"namespaceId,omitempty"`
	// ProjectId: The ID of the project to which the entities belong.
	ProjectId string `json:"projectId,omitempty"`
	// ForceSendFields is a list of field names (e.g. "NamespaceId") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "NamespaceId") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GooglePrivacyDlpV2PartitionId) MarshalJSON() ([]byte, error) {
	type NoMethod GooglePrivacyDlpV2PartitionId
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GooglePrivacyDlpV2PathElement: A (kind, ID/name) pair used to construct a
// key path. If either name or ID is set, the element is complete. If neither
// is set, the element is incomplete.
type GooglePrivacyDlpV2PathElement struct {
	// Id: The auto-allocated ID of the entity. Never equal to zero. Values less
	// than zero are discouraged and may not be supported in the future.
	Id int64 `json:"id,omitempty,string"`
	// Kind: The kind of the entity. A kind matching regex `__.*__` is
	// reserved/read-only. A kind must not contain more than 1500 bytes when UTF-8
	// encoded. Cannot be "".
	Kind string `json:"kind,omitempty"`
	// Name: The name of the entity. A name matching regex `__.*__` is
	// reserved/read-only. A name must not be more than 1500 bytes when UTF-8
	// encoded. Cannot be "".
	Name string `json:"name,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Id") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Id") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GooglePrivacyDlpV2PathElement) MarshalJSON() ([]byte, error) {
	type NoMethod GooglePrivacyDlpV2PathElement
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GooglePrivacyDlpV2PrimitiveTransformation: A rule for transforming a value.
type GooglePrivacyDlpV2PrimitiveTransformation struct {
	// BucketingConfig: Bucketing
	BucketingConfig *GooglePrivacyDlpV2BucketingConfig `json:"bucketingConfig,omitempty"`
	// CharacterMaskConfig: Mask
	CharacterMaskConfig *GooglePrivacyDlpV2CharacterMaskConfig `json:"characterMaskConfig,omitempty"`
	// CryptoDeterministicConfig: Deterministic Crypto
	CryptoDeterministicConfig *GooglePrivacyDlpV2CryptoDeterministicConfig `json:"cryptoDeterministicConfig,omitempty"`
	// CryptoHashConfig: Crypto
	CryptoHashConfig *GooglePrivacyDlpV2CryptoHashConfig `json:"cryptoHashConfig,omitempty"`
	// CryptoReplaceFfxFpeConfig: Ffx-Fpe. Strongly discouraged, consider using
	// CryptoDeterministicConfig instead. Fpe is computationally expensive
	// incurring latency costs.
	CryptoReplaceFfxFpeConfig *GooglePrivacyDlpV2CryptoReplaceFfxFpeConfig `json:"cryptoReplaceFfxFpeConfig,omitempty"`
	// DateShiftConfig: Date Shift
	DateShiftConfig *GooglePrivacyDlpV2DateShiftConfig `json:"dateShiftConfig,omitempty"`
	// FixedSizeBucketingConfig: Fixed size bucketing
	FixedSizeBucketingConfig *GooglePrivacyDlpV2FixedSizeBucketingConfig `json:"fixedSizeBucketingConfig,omitempty"`
	// RedactConfig: Redact
	RedactConfig *GooglePrivacyDlpV2RedactConfig `json:"redactConfig,omitempty"`
	// ReplaceConfig: Replace with a specified value.
	ReplaceConfig *GooglePrivacyDlpV2ReplaceValueConfig `json:"replaceConfig,omitempty"`
	// ReplaceDictionaryConfig: Replace with a value randomly drawn (with
	// replacement) from a dictionary.
	ReplaceDictionaryConfig *GooglePrivacyDlpV2ReplaceDictionaryConfig `json:"replaceDictionaryConfig,omitempty"`
	// ReplaceWithInfoTypeConfig: Replace with infotype
	ReplaceWithInfoTypeConfig *GooglePrivacyDlpV2ReplaceWithInfoTypeConfig `json:"replaceWithInfoTypeConfig,omitempty"`
	// TimePartConfig: Time extraction
	TimePartConfig *GooglePrivacyDlpV2TimePartConfig `json:"timePartConfig,omitempty"`
	// ForceSendFields is a list of field names (e.g. "BucketingConfig") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "BucketingConfig") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GooglePrivacyDlpV2PrimitiveTransformation) MarshalJSON() ([]byte, error) {
	type NoMethod GooglePrivacyDlpV2PrimitiveTransformation
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GooglePrivacyDlpV2PrivacyMetric: Privacy metric to compute for
// reidentification risk analysis.
type GooglePrivacyDlpV2PrivacyMetric struct {
	// CategoricalStatsConfig: Categorical stats
	CategoricalStatsConfig *GooglePrivacyDlpV2CategoricalStatsConfig `json:"categoricalStatsConfig,omitempty"`
	// DeltaPresenceEstimationConfig: delta-presence
	DeltaPresenceEstimationConfig *GooglePrivacyDlpV2DeltaPresenceEstimationConfig `json:"deltaPresenceEstimationConfig,omitempty"`
	// KAnonymityConfig: K-anonymity
	KAnonymityConfig *GooglePrivacyDlpV2KAnonymityConfig `json:"kAnonymityConfig,omitempty"`
	// KMapEstimationConfig: k-map
	KMapEstimationConfig *GooglePrivacyDlpV2KMapEstimationConfig `json:"kMapEstimationConfig,omitempty"`
	// LDiversityConfig: l-diversity
	LDiversityConfig *GooglePrivacyDlpV2LDiversityConfig `json:"lDiversityConfig,omitempty"`
	// NumericalStatsConfig: Numerical stats
	NumericalStatsConfig *GooglePrivacyDlpV2NumericalStatsConfig `json:"numericalStatsConfig,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CategoricalStatsConfig") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CategoricalStatsConfig") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GooglePrivacyDlpV2PrivacyMetric) MarshalJSON() ([]byte, error) {
	type NoMethod GooglePrivacyDlpV2PrivacyMetric
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GooglePrivacyDlpV2ProcessingLocation: Configure processing location for
// discovery and inspection. For example, image OCR is only provided in limited
// regions but configuring ProcessingLocation will redirect OCR to a location
// where OCR is provided.
type GooglePrivacyDlpV2ProcessingLocation struct {
	// DocumentFallbackLocation: Document processing falls back using this
	// configuration.
	DocumentFallbackLocation *GooglePrivacyDlpV2DocumentFallbackLocation `json:"documentFallbackLocation,omitempty"`
	// ImageFallbackLocation: Image processing falls back using this configuration.
	ImageFallbackLocation *GooglePrivacyDlpV2ImageFallbackLocation `json:"imageFallbackLocation,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DocumentFallbackLocation")
	// to unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DocumentFallbackLocation") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GooglePrivacyDlpV2ProcessingLocation) MarshalJSON() ([]byte, error) {
	type NoMethod GooglePrivacyDlpV2ProcessingLocation
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GooglePrivacyDlpV2ProfileStatus: Success or errors for the profile
// generation.
type GooglePrivacyDlpV2ProfileStatus struct {
	// Status: Profiling status code and optional message. The `status.code` value
	// is 0 (default value) for OK.
	Status *GoogleRpcStatus `json:"status,omitempty"`
	// Timestamp: Time when the profile generation status was updated
	Timestamp string `json:"timestamp,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Status") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Status") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GooglePrivacyDlpV2ProfileStatus) MarshalJSON() ([]byte, error) {
	type NoMethod GooglePrivacyDlpV2ProfileStatus
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GooglePrivacyDlpV2ProjectDataProfile: An aggregated profile for this
// project, based on the resources profiled within it.
type GooglePrivacyDlpV2ProjectDataProfile struct {
	// DataRiskLevel: The data risk level of this project.
	DataRiskLevel *GooglePrivacyDlpV2DataRiskLevel `json:"dataRiskLevel,omitempty"`
	// FileStoreDataProfileCount: The number of file store data profiles generated
	// for this project.
	FileStoreDataProfileCount int64 `json:"fileStoreDataProfileCount,omitempty,string"`
	// Name: The resource name of the profile.
	Name string `json:"name,omitempty"`
	// ProfileLastGenerated: The last time the profile was generated.
	ProfileLastGenerated string `json:"profileLastGenerated,omitempty"`
	// ProfileStatus: Success or error status of the last attempt to profile the
	// project.
	ProfileStatus *GooglePrivacyDlpV2ProfileStatus `json:"profileStatus,omitempty"`
	// ProjectId: Project ID or account that was profiled.
	ProjectId string `json:"projectId,omitempty"`
	// SensitivityScore: The sensitivity score of this project.
	SensitivityScore *GooglePrivacyDlpV2SensitivityScore `json:"sensitivityScore,omitempty"`
	// TableDataProfileCount: The number of table data profiles generated for this
	// project.
	TableDataProfileCount int64 `json:"tableDataProfileCount,omitempty,string"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "DataRiskLevel") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DataRiskLevel") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GooglePrivacyDlpV2ProjectDataProfile) MarshalJSON() ([]byte, error) {
	type NoMethod GooglePrivacyDlpV2ProjectDataProfile
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GooglePrivacyDlpV2Proximity: Message for specifying a window around a
// finding to apply a detection rule.
type GooglePrivacyDlpV2Proximity struct {
	// WindowAfter: Number of characters after the finding to consider.
	WindowAfter int64 `json:"windowAfter,omitempty"`
	// WindowBefore: Number of characters before the finding to consider. For
	// tabular data, if you want to modify the likelihood of an entire column of
	// findngs, set this to 1. For more information, see [Hotword example: Set the
	// match likelihood of a table column]
	// (https://cloud.google.com/sensitive-data-protection/docs/creating-custom-infotypes-likelihood#match-column-values).
	WindowBefore int64 `json:"windowBefore,omitempty"`
	// ForceSendFields is a list of field names (e.g. "WindowAfter") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "WindowAfter") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GooglePrivacyDlpV2Proximity) MarshalJSON() ([]byte, error) {
	type NoMethod GooglePrivacyDlpV2Proximity
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GooglePrivacyDlpV2PubSubCondition: A condition consisting of a value.
type GooglePrivacyDlpV2PubSubCondition struct {
	// MinimumRiskScore: The minimum data risk score that triggers the condition.
	//
	// Possible values:
	//   "PROFILE_SCORE_BUCKET_UNSPECIFIED" - Unused.
	//   "HIGH" - High risk/sensitivity detected.
	//   "MEDIUM_OR_HIGH" - Medium or high risk/sensitivity detected.
	MinimumRiskScore string `json:"minimumRiskScore,omitempty"`
	// MinimumSensitivityScore: The minimum sensitivity level that triggers the
	// condition.
	//
	// Possible values:
	//   "PROFILE_SCORE_BUCKET_UNSPECIFIED" - Unused.
	//   "HIGH" - High risk/sensitivity detected.
	//   "MEDIUM_OR_HIGH" - Medium or high risk/sensitivity detected.
	MinimumSensitivityScore string `json:"minimumSensitivityScore,omitempty"`
	// ForceSendFields is a list of field names (e.g. "MinimumRiskScore") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "MinimumRiskScore") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GooglePrivacyDlpV2PubSubCondition) MarshalJSON() ([]byte, error) {
	type NoMethod GooglePrivacyDlpV2PubSubCondition
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GooglePrivacyDlpV2PubSubExpressions: An expression, consisting of an
// operator and conditions.
type GooglePrivacyDlpV2PubSubExpressions struct {
	// Conditions: Conditions to apply to the expression.
	Conditions []*GooglePrivacyDlpV2PubSubCondition `json:"conditions,omitempty"`
	// LogicalOperator: The operator to apply to the collection of conditions.
	//
	// Possible values:
	//   "LOGICAL_OPERATOR_UNSPECIFIED" - Unused.
	//   "OR" - Conditional OR.
	//   "AND" - Conditional AND.
	LogicalOperator string `json:"logicalOperator,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Conditions") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Conditions") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GooglePrivacyDlpV2PubSubExpressions) MarshalJSON() ([]byte, error) {
	type NoMethod GooglePrivacyDlpV2PubSubExpressions
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GooglePrivacyDlpV2PubSubNotification: Send a Pub/Sub message into the given
// Pub/Sub topic to connect other systems to data profile generation. The
// message payload data will be the byte serialization of
// `DataProfilePubSubMessage`.
type GooglePrivacyDlpV2PubSubNotification struct {
	// DetailOfMessage: How much data to include in the Pub/Sub message. If the
	// user wishes to limit the size of the message, they can use resource_name and
	// fetch the profile fields they wish to. Per table profile (not per column).
	//
	// Possible values:
	//   "DETAIL_LEVEL_UNSPECIFIED" - Unused.
	//   "TABLE_PROFILE" - The full table data profile.
	//   "RESOURCE_NAME" - The name of the profiled resource.
	//   "FILE_STORE_PROFILE" - The full file store data profile.
	DetailOfMessage string `json:"detailOfMessage,omitempty"`
	// Event: The type of event that triggers a Pub/Sub. At most one
	// `PubSubNotification` per EventType is permitted.
	//
	// Possible values:
	//   "EVENT_TYPE_UNSPECIFIED" - Unused.
	//   "NEW_PROFILE" - New profile (not a re-profile).
	//   "CHANGED_PROFILE" - One of the following profile metrics changed: Data
	// risk score, Sensitivity score, Resource visibility, Encryption type,
	// Predicted infoTypes, Other infoTypes
	//   "SCORE_INCREASED" - Table data risk score or sensitivity score increased.
	//   "ERROR_CHANGED" - A user (non-internal) error occurred.
	Event string `json:"event,omitempty"`
	// PubsubCondition: Conditions (e.g., data risk or sensitivity level) for
	// triggering a Pub/Sub.
	PubsubCondition *GooglePrivacyDlpV2DataProfilePubSubCondition `json:"pubsubCondition,omitempty"`
	// Topic: Cloud Pub/Sub topic to send notifications to. Format is
	// projects/{project}/topics/{topic}.
	Topic string `json:"topic,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DetailOfMessage") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DetailOfMessage") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GooglePrivacyDlpV2PubSubNotification) MarshalJSON() ([]byte, error) {
	type NoMethod GooglePrivacyDlpV2PubSubNotification
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GooglePrivacyDlpV2PublishFindingsToCloudDataCatalog: Publish findings of a
// DlpJob to Data Catalog. In Data Catalog, tag templates are applied to the
// resource that Cloud DLP scanned. Data Catalog tag templates are stored in
// the same project and region where the BigQuery table exists. For Cloud DLP
// to create and apply the tag template, the Cloud DLP service agent must have
// the `roles/datacatalog.tagTemplateOwner` permission on the project. The tag
// template contains fields summarizing the results of the DlpJob. Any field
// values previously written by another DlpJob are deleted. InfoType naming
// patterns are strictly enforced when using this feature. Findings are
// persisted in Data Catalog storage and are governed by service-specific
// policies for Data Catalog. For more information, see Service Specific Terms
// (https://cloud.google.com/terms/service-terms). Only a single instance of
// this action can be specified. This action is allowed only if all resources
// being scanned are BigQuery tables. Compatible with: Inspect
type GooglePrivacyDlpV2PublishFindingsToCloudDataCatalog struct {
}

// GooglePrivacyDlpV2PublishFindingsToDataplexCatalog: Publish findings of a
// DlpJob to Dataplex Universal Catalog as a
// `sensitive-data-protection-job-result` aspect. For more information, see
// Send inspection results to Dataplex Universal Catalog as aspects
// (https://cloud.google.com/sensitive-data-protection/docs/add-aspects-inspection-job).
// Aspects are stored in Dataplex Universal Catalog storage and are governed by
// service-specific policies for Dataplex Universal Catalog. For more
// information, see Service Specific Terms
// (https://cloud.google.com/terms/service-terms). Only a single instance of
// this action can be specified. This action is allowed only if all resources
// being scanned are BigQuery tables. Compatible with: Inspect
type GooglePrivacyDlpV2PublishFindingsToDataplexCatalog struct {
}

// GooglePrivacyDlpV2PublishSummaryToCscc: Publish the result summary of a
// DlpJob to Security Command Center
// (https://cloud.google.com/security-command-center). This action is available
// for only projects that belong to an organization. This action publishes the
// count of finding instances and their infoTypes. The summary of findings are
// persisted in Security Command Center and are governed by service-specific
// policies for Security Command Center
// (https://cloud.google.com/terms/service-terms). Only a single instance of
// this action can be specified. Compatible with: Inspect
type GooglePrivacyDlpV2PublishSummaryToCscc struct {
}

// GooglePrivacyDlpV2PublishToChronicle: Message expressing intention to
// publish to Google Security Operations.
type GooglePrivacyDlpV2PublishToChronicle struct {
}

// GooglePrivacyDlpV2PublishToDataplexCatalog: Create Dataplex Universal
// Catalog aspects for profiled resources with the aspect type Sensitive Data
// Protection Profile. To learn more about aspects, see
// https://cloud.google.com/sensitive-data-protection/docs/add-aspects.
type GooglePrivacyDlpV2PublishToDataplexCatalog struct {
	// LowerDataRiskToLow: Whether creating a Dataplex Universal Catalog aspect for
	// a profiled resource should lower the risk of the profile for that resource.
	// This also lowers the data risk of resources at the lower levels of the
	// resource hierarchy. For example, reducing the data risk of a table data
	// profile also reduces the data risk of the constituent column data profiles.
	LowerDataRiskToLow bool `json:"lowerDataRiskToLow,omitempty"`
	// ForceSendFields is a list of field names (e.g. "LowerDataRiskToLow") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "LowerDataRiskToLow") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GooglePrivacyDlpV2PublishToDataplexCatalog) MarshalJSON() ([]byte, error) {
	type NoMethod GooglePrivacyDlpV2PublishToDataplexCatalog
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GooglePrivacyDlpV2PublishToPubSub: Publish a message into a given Pub/Sub
// topic when DlpJob has completed. The message contains a single field,
// `DlpJobName`, which is equal to the finished job's `DlpJob.name`
// (https://cloud.google.com/sensitive-data-protection/docs/reference/rest/v2/projects.dlpJobs#DlpJob).
// Compatible with: Inspect, Risk
type GooglePrivacyDlpV2PublishToPubSub struct {
	// Topic: Cloud Pub/Sub topic to send notifications to. The topic must have
	// given publishing access rights to the DLP API service account executing the
	// long running DlpJob sending the notifications. Format is
	// projects/{project}/topics/{topic}.
	Topic string `json:"topic,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Topic") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Topic") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GooglePrivacyDlpV2PublishToPubSub) MarshalJSON() ([]byte, error) {
	type NoMethod GooglePrivacyDlpV2PublishToPubSub
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GooglePrivacyDlpV2PublishToSecurityCommandCenter: If set, a summary finding
// will be created or updated in Security Command Center for each profile.
type GooglePrivacyDlpV2PublishToSecurityCommandCenter struct {
}

// GooglePrivacyDlpV2PublishToStackdriver: Enable Stackdriver metric
// dlp.googleapis.com/finding_count. This will publish a metric to stack driver
// on each infotype requested and how many findings were found for it.
// CustomDetectors will be bucketed as 'Custom' under the Stackdriver label
// 'info_type'.
type GooglePrivacyDlpV2PublishToStackdriver struct {
}

// GooglePrivacyDlpV2QuasiId: A column with a semantic tag attached.
type GooglePrivacyDlpV2QuasiId struct {
	// CustomTag: A column can be tagged with a custom tag. In this case, the user
	// must indicate an auxiliary table that contains statistical information on
	// the possible values of this column.
	CustomTag string `json:"customTag,omitempty"`
	// Field: Required. Identifies the column.
	Field *GooglePrivacyDlpV2FieldId `json:"field,omitempty"`
	// Inferred: If no semantic tag is indicated, we infer the statistical model
	// from the distribution of values in the input data
	Inferred *GoogleProtobufEmpty `json:"inferred,omitempty"`
	// InfoType: A column can be tagged with a InfoType to use the relevant public
	// dataset as a statistical model of population, if available. We currently
	// support US ZIP codes, region codes, ages and genders. To programmatically
	// obtain the list of supported InfoTypes, use ListInfoTypes with the
	// supported_by=RISK_ANALYSIS filter.
	InfoType *GooglePrivacyDlpV2InfoType `json:"infoType,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CustomTag") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CustomTag") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GooglePrivacyDlpV2QuasiId) MarshalJSON() ([]byte, error) {
	type NoMethod GooglePrivacyDlpV2QuasiId
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GooglePrivacyDlpV2QuasiIdField: A quasi-identifier column has a custom_tag,
// used to know which column in the data corresponds to which column in the
// statistical model.
type GooglePrivacyDlpV2QuasiIdField struct {
	// CustomTag: A auxiliary field.
	CustomTag string `json:"customTag,omitempty"`
	// Field: Identifies the column.
	Field *GooglePrivacyDlpV2FieldId `json:"field,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CustomTag") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CustomTag") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GooglePrivacyDlpV2QuasiIdField) MarshalJSON() ([]byte, error) {
	type NoMethod GooglePrivacyDlpV2QuasiIdField
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GooglePrivacyDlpV2QuasiIdentifierField: A quasi-identifier column has a
// custom_tag, used to know which column in the data corresponds to which
// column in the statistical model.
type GooglePrivacyDlpV2QuasiIdentifierField struct {
	// CustomTag: A column can be tagged with a custom tag. In this case, the user
	// must indicate an auxiliary table that contains statistical information on
	// the possible values of this column.
	CustomTag string `json:"customTag,omitempty"`
	// Field: Identifies the column.
	Field *GooglePrivacyDlpV2FieldId `json:"field,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CustomTag") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CustomTag") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GooglePrivacyDlpV2QuasiIdentifierField) MarshalJSON() ([]byte, error) {
	type NoMethod GooglePrivacyDlpV2QuasiIdentifierField
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GooglePrivacyDlpV2QuoteInfo: Message for infoType-dependent details parsed
// from quote.
type GooglePrivacyDlpV2QuoteInfo struct {
	// DateTime: The date time indicated by the quote.
	DateTime *GooglePrivacyDlpV2DateTime `json:"dateTime,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DateTime") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DateTime") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GooglePrivacyDlpV2QuoteInfo) MarshalJSON() ([]byte, error) {
	type NoMethod GooglePrivacyDlpV2QuoteInfo
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GooglePrivacyDlpV2Range: Generic half-open interval [start, end)
type GooglePrivacyDlpV2Range struct {
	// End: Index of the last character of the range (exclusive).
	End int64 `json:"end,omitempty,string"`
	// Start: Index of the first character of the range (inclusive).
	Start int64 `json:"start,omitempty,string"`
	// ForceSendFields is a list of field names (e.g. "End") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "End") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GooglePrivacyDlpV2Range) MarshalJSON() ([]byte, error) {
	type NoMethod GooglePrivacyDlpV2Range
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GooglePrivacyDlpV2RecordCondition: A condition for determining whether a
// transformation should be applied to a field.
type GooglePrivacyDlpV2RecordCondition struct {
	// Expressions: An expression.
	Expressions *GooglePrivacyDlpV2Expressions `json:"expressions,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Expressions") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Expressions") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GooglePrivacyDlpV2RecordCondition) MarshalJSON() ([]byte, error) {
	type NoMethod GooglePrivacyDlpV2RecordCondition
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GooglePrivacyDlpV2RecordKey: Message for a unique key indicating a record
// that contains a finding.
type GooglePrivacyDlpV2RecordKey struct {
	// BigQueryKey: Datastore key
	BigQueryKey *GooglePrivacyDlpV2BigQueryKey `json:"bigQueryKey,omitempty"`
	// DatastoreKey: BigQuery key
	DatastoreKey *GooglePrivacyDlpV2DatastoreKey `json:"datastoreKey,omitempty"`
	// IdValues: Values of identifying columns in the given row. Order of values
	// matches the order of `identifying_fields` specified in the scanning request.
	IdValues []string `json:"idValues,omitempty"`
	// ForceSendFields is a list of field names (e.g. "BigQueryKey") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "BigQueryKey") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GooglePrivacyDlpV2RecordKey) MarshalJSON() ([]byte, error) {
	type NoMethod GooglePrivacyDlpV2RecordKey
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GooglePrivacyDlpV2RecordLocation: Location of a finding within a row or
// record.
type GooglePrivacyDlpV2RecordLocation struct {
	// FieldId: Field id of the field containing the finding.
	FieldId *GooglePrivacyDlpV2FieldId `json:"fieldId,omitempty"`
	// RecordKey: Key of the finding.
	RecordKey *GooglePrivacyDlpV2RecordKey `json:"recordKey,omitempty"`
	// TableLocation: Location within a `ContentItem.Table`.
	TableLocation *GooglePrivacyDlpV2TableLocation `json:"tableLocation,omitempty"`
	// ForceSendFields is a list of field names (e.g. "FieldId") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "FieldId") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GooglePrivacyDlpV2RecordLocation) MarshalJSON() ([]byte, error) {
	type NoMethod GooglePrivacyDlpV2RecordLocation
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GooglePrivacyDlpV2RecordSuppression: Configuration to suppress records whose
// suppression conditions evaluate to true.
type GooglePrivacyDlpV2RecordSuppression struct {
	// Condition: A condition that when it evaluates to true will result in the
	// record being evaluated to be suppressed from the transformed content.
	Condition *GooglePrivacyDlpV2RecordCondition `json:"condition,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Condition") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Condition") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GooglePrivacyDlpV2RecordSuppression) MarshalJSON() ([]byte, error) {
	type NoMethod GooglePrivacyDlpV2RecordSuppression
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GooglePrivacyDlpV2RecordTransformation: The field in a record to transform.
type GooglePrivacyDlpV2RecordTransformation struct {
	// ContainerTimestamp: Findings container modification timestamp, if
	// applicable.
	ContainerTimestamp string `json:"containerTimestamp,omitempty"`
	// ContainerVersion: Container version, if available ("generation" for Cloud
	// Storage).
	ContainerVersion string `json:"containerVersion,omitempty"`
	// FieldId: For record transformations, provide a field.
	FieldId *GooglePrivacyDlpV2FieldId `json:"fieldId,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ContainerTimestamp") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ContainerTimestamp") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GooglePrivacyDlpV2RecordTransformation) MarshalJSON() ([]byte, error) {
	type NoMethod GooglePrivacyDlpV2RecordTransformation
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GooglePrivacyDlpV2RecordTransformations: A type of transformation that is
// applied over structured data such as a table.
type GooglePrivacyDlpV2RecordTransformations struct {
	// FieldTransformations: Transform the record by applying various field
	// transformations.
	FieldTransformations []*GooglePrivacyDlpV2FieldTransformation `json:"fieldTransformations,omitempty"`
	// RecordSuppressions: Configuration defining which records get suppressed
	// entirely. Records that match any suppression rule are omitted from the
	// output.
	RecordSuppressions []*GooglePrivacyDlpV2RecordSuppression `json:"recordSuppressions,omitempty"`
	// ForceSendFields is a list of field names (e.g. "FieldTransformations") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "FieldTransformations") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GooglePrivacyDlpV2RecordTransformations) MarshalJSON() ([]byte, error) {
	type NoMethod GooglePrivacyDlpV2RecordTransformations
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GooglePrivacyDlpV2RedactConfig: Redact a given value. For example, if used
// with an `InfoTypeTransformation` transforming PHONE_NUMBER, and input 'My
// phone number is 206-555-0123', the output would be 'My phone number is '.
type GooglePrivacyDlpV2RedactConfig struct {
}

// GooglePrivacyDlpV2RedactImageRequest: Request to search for potentially
// sensitive info in an image and redact it by covering it with a colored
// rectangle.
type GooglePrivacyDlpV2RedactImageRequest struct {
	// ByteItem: The content must be PNG, JPEG, SVG or BMP.
	ByteItem *GooglePrivacyDlpV2ByteContentItem `json:"byteItem,omitempty"`
	// DeidentifyTemplate: The full resource name of the de-identification template
	// to use. Settings in the main `image_redaction_configs` field override the
	// corresponding settings in this de-identification template. The request fails
	// if the type of the template's deidentify_config is not
	// image_transformations.
	DeidentifyTemplate string `json:"deidentifyTemplate,omitempty"`
	// ImageRedactionConfigs: The configuration for specifying what content to
	// redact from images.
	ImageRedactionConfigs []*GooglePrivacyDlpV2ImageRedactionConfig `json:"imageRedactionConfigs,omitempty"`
	// IncludeFindings: Whether the response should include findings along with the
	// redacted image.
	IncludeFindings bool `json:"includeFindings,omitempty"`
	// InspectConfig: Configuration for the inspector.
	InspectConfig *GooglePrivacyDlpV2InspectConfig `json:"inspectConfig,omitempty"`
	// InspectTemplate: The full resource name of the inspection template to use.
	// Settings in the main `inspect_config` field override the corresponding
	// settings in this inspection template. The merge behavior is as follows: -
	// Singular field: The main field's value replaces the value of the
	// corresponding field in the template. - Repeated fields: The field values are
	// appended to the list defined in the template. - Sub-messages and groups: The
	// fields are recursively merged.
	InspectTemplate string `json:"inspectTemplate,omitempty"`
	// LocationId: Deprecated. This field has no effect.
	LocationId string `json:"locationId,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ByteItem") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ByteItem") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GooglePrivacyDlpV2RedactImageRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GooglePrivacyDlpV2RedactImageRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GooglePrivacyDlpV2RedactImageResponse: Results of redacting an image.
type GooglePrivacyDlpV2RedactImageResponse struct {
	// ExtractedText: If an image was being inspected and the InspectConfig's
	// include_quote was set to true, then this field will include all text, if
	// any, that was found in the image.
	ExtractedText string `json:"extractedText,omitempty"`
	// InspectResult: The findings. Populated when include_findings in the request
	// is true.
	InspectResult *GooglePrivacyDlpV2InspectResult `json:"inspectResult,omitempty"`
	// RedactedImage: The redacted image. The type will be the same as the original
	// image.
	RedactedImage string `json:"redactedImage,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "ExtractedText") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ExtractedText") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GooglePrivacyDlpV2RedactImageResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GooglePrivacyDlpV2RedactImageResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GooglePrivacyDlpV2Regex: Message defining a custom regular expression.
type GooglePrivacyDlpV2Regex struct {
	// GroupIndexes: The index of the submatch to extract as findings. When not
	// specified, the entire match is returned. No more than 3 may be included.
	GroupIndexes []int64 `json:"groupIndexes,omitempty"`
	// Pattern: Pattern defining the regular expression. Its syntax
	// (https://github.com/google/re2/wiki/Syntax) can be found under the
	// google/re2 repository on GitHub.
	Pattern string `json:"pattern,omitempty"`
	// ForceSendFields is a list of field names (e.g. "GroupIndexes") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "GroupIndexes") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GooglePrivacyDlpV2Regex) MarshalJSON() ([]byte, error) {
	type NoMethod GooglePrivacyDlpV2Regex
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GooglePrivacyDlpV2ReidentifyContentRequest: Request to re-identify an item.
type GooglePrivacyDlpV2ReidentifyContentRequest struct {
	// InspectConfig: Configuration for the inspector.
	InspectConfig *GooglePrivacyDlpV2InspectConfig `json:"inspectConfig,omitempty"`
	// InspectTemplateName: Template to use. Any configuration directly specified
	// in `inspect_config` will override those set in the template. Singular fields
	// that are set in this request will replace their corresponding fields in the
	// template. Repeated fields are appended. Singular sub-messages and groups are
	// recursively merged.
	InspectTemplateName string `json:"inspectTemplateName,omitempty"`
	// Item: The item to re-identify. Will be treated as text.
	Item *GooglePrivacyDlpV2ContentItem `json:"item,omitempty"`
	// LocationId: Deprecated. This field has no effect.
	LocationId string `json:"locationId,omitempty"`
	// ReidentifyConfig: Configuration for the re-identification of the content
	// item. This field shares the same proto message type that is used for
	// de-identification, however its usage here is for the reversal of the
	// previous de-identification. Re-identification is performed by examining the
	// transformations used to de-identify the items and executing the reverse.
	// This requires that only reversible transformations be provided here. The
	// reversible transformations are: - `CryptoDeterministicConfig` -
	// `CryptoReplaceFfxFpeConfig`
	ReidentifyConfig *GooglePrivacyDlpV2DeidentifyConfig `json:"reidentifyConfig,omitempty"`
	// ReidentifyTemplateName: Template to use. References an instance of
	// `DeidentifyTemplate`. Any configuration directly specified in
	// `reidentify_config` or `inspect_config` will override those set in the
	// template. The `DeidentifyTemplate` used must include only reversible
	// transformations. Singular fields that are set in this request will replace
	// their corresponding fields in the template. Repeated fields are appended.
	// Singular sub-messages and groups are recursively merged.
	ReidentifyTemplateName string `json:"reidentifyTemplateName,omitempty"`
	// ForceSendFields is a list of field names (e.g. "InspectConfig") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "InspectConfig") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GooglePrivacyDlpV2ReidentifyContentRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GooglePrivacyDlpV2ReidentifyContentRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GooglePrivacyDlpV2ReidentifyContentResponse: Results of re-identifying an
// item.
type GooglePrivacyDlpV2ReidentifyContentResponse struct {
	// Item: The re-identified item.
	Item *GooglePrivacyDlpV2ContentItem `json:"item,omitempty"`
	// Overview: An overview of the changes that were made to the `item`.
	Overview *GooglePrivacyDlpV2TransformationOverview `json:"overview,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Item") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Item") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GooglePrivacyDlpV2ReidentifyContentResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GooglePrivacyDlpV2ReidentifyContentResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GooglePrivacyDlpV2RelatedResource: A related resource. Examples: * The
// source BigQuery table for a Vertex AI dataset. * The source Cloud Storage
// bucket for a Vertex AI dataset.
type GooglePrivacyDlpV2RelatedResource struct {
	// FullResource: The full resource name of the related resource.
	FullResource string `json:"fullResource,omitempty"`
	// ForceSendFields is a list of field names (e.g. "FullResource") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "FullResource") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GooglePrivacyDlpV2RelatedResource) MarshalJSON() ([]byte, error) {
	type NoMethod GooglePrivacyDlpV2RelatedResource
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GooglePrivacyDlpV2ReplaceDictionaryConfig: Replace each input value with a
// value randomly selected from the dictionary.
type GooglePrivacyDlpV2ReplaceDictionaryConfig struct {
	// WordList: A list of words to select from for random replacement. The limits
	// (https://cloud.google.com/sensitive-data-protection/limits) page contains
	// details about the size limits of dictionaries.
	WordList *GooglePrivacyDlpV2WordList `json:"wordList,omitempty"`
	// ForceSendFields is a list of field names (e.g. "WordList") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "WordList") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GooglePrivacyDlpV2ReplaceDictionaryConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GooglePrivacyDlpV2ReplaceDictionaryConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GooglePrivacyDlpV2ReplaceValueConfig: Replace each input value with a given
// `Value`.
type GooglePrivacyDlpV2ReplaceValueConfig struct {
	// NewValue: Value to replace it with.
	NewValue *GooglePrivacyDlpV2Value `json:"newValue,omitempty"`
	// ForceSendFields is a list of field names (e.g. "NewValue") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "NewValue") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GooglePrivacyDlpV2ReplaceValueConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GooglePrivacyDlpV2ReplaceValueConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GooglePrivacyDlpV2ReplaceWithInfoTypeConfig: Replace each matching finding
// with the name of the info_type.
type GooglePrivacyDlpV2ReplaceWithInfoTypeConfig struct {
}

// GooglePrivacyDlpV2RequestedDeidentifyOptions: De-identification options.
type GooglePrivacyDlpV2RequestedDeidentifyOptions struct {
	// SnapshotDeidentifyTemplate: Snapshot of the state of the
	// `DeidentifyTemplate` from the Deidentify action at the time this job was
	// run.
	SnapshotDeidentifyTemplate *GooglePrivacyDlpV2DeidentifyTemplate `json:"snapshotDeidentifyTemplate,omitempty"`
	// SnapshotImageRedactTemplate: Snapshot of the state of the image
	// transformation `DeidentifyTemplate` from the `Deidentify` action at the time
	// this job was run.
	SnapshotImageRedactTemplate *GooglePrivacyDlpV2DeidentifyTemplate `json:"snapshotImageRedactTemplate,omitempty"`
	// SnapshotStructuredDeidentifyTemplate: Snapshot of the state of the
	// structured `DeidentifyTemplate` from the `Deidentify` action at the time
	// this job was run.
	SnapshotStructuredDeidentifyTemplate *GooglePrivacyDlpV2DeidentifyTemplate `json:"snapshotStructuredDeidentifyTemplate,omitempty"`
	// ForceSendFields is a list of field names (e.g. "SnapshotDeidentifyTemplate")
	// to unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "SnapshotDeidentifyTemplate") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GooglePrivacyDlpV2RequestedDeidentifyOptions) MarshalJSON() ([]byte, error) {
	type NoMethod GooglePrivacyDlpV2RequestedDeidentifyOptions
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GooglePrivacyDlpV2RequestedOptions: Snapshot of the inspection
// configuration.
type GooglePrivacyDlpV2RequestedOptions struct {
	// JobConfig: Inspect config.
	JobConfig *GooglePrivacyDlpV2InspectJobConfig `json:"jobConfig,omitempty"`
	// SnapshotInspectTemplate: If run with an InspectTemplate, a snapshot of its
	// state at the time of this run.
	SnapshotInspectTemplate *GooglePrivacyDlpV2InspectTemplate `json:"snapshotInspectTemplate,omitempty"`
	// ForceSendFields is a list of field names (e.g. "JobConfig") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "JobConfig") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GooglePrivacyDlpV2RequestedOptions) MarshalJSON() ([]byte, error) {
	type NoMethod GooglePrivacyDlpV2RequestedOptions
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GooglePrivacyDlpV2RequestedRiskAnalysisOptions: Risk analysis options.
type GooglePrivacyDlpV2RequestedRiskAnalysisOptions struct {
	// JobConfig: The job config for the risk job.
	JobConfig *GooglePrivacyDlpV2RiskAnalysisJobConfig `json:"jobConfig,omitempty"`
	// ForceSendFields is a list of field names (e.g. "JobConfig") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "JobConfig") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GooglePrivacyDlpV2RequestedRiskAnalysisOptions) MarshalJSON() ([]byte, error) {
	type NoMethod GooglePrivacyDlpV2RequestedRiskAnalysisOptions
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GooglePrivacyDlpV2Result: All Result fields are updated while the job is
// processing.
type GooglePrivacyDlpV2Result struct {
	// HybridStats: Statistics related to the processing of hybrid inspect.
	HybridStats *GooglePrivacyDlpV2HybridInspectStatistics `json:"hybridStats,omitempty"`
	// InfoTypeStats: Statistics of how many instances of each info type were found
	// during inspect job.
	InfoTypeStats []*GooglePrivacyDlpV2InfoTypeStats `json:"infoTypeStats,omitempty"`
	// NumRowsProcessed: Number of rows scanned after sampling and time filtering
	// (applicable for row based stores such as BigQuery).
	NumRowsProcessed int64 `json:"numRowsProcessed,omitempty,string"`
	// ProcessedBytes: Total size in bytes that were processed.
	ProcessedBytes int64 `json:"processedBytes,omitempty,string"`
	// TotalEstimatedBytes: Estimate of the number of bytes to process.
	TotalEstimatedBytes int64 `json:"totalEstimatedBytes,omitempty,string"`
	// ForceSendFields is a list of field names (e.g. "HybridStats") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "HybridStats") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GooglePrivacyDlpV2Result) MarshalJSON() ([]byte, error) {
	type NoMethod GooglePrivacyDlpV2Result
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GooglePrivacyDlpV2RiskAnalysisJobConfig: Configuration for a risk analysis
// job. See
// https://cloud.google.com/sensitive-data-protection/docs/concepts-risk-analysis
// to learn more.
type GooglePrivacyDlpV2RiskAnalysisJobConfig struct {
	// Actions: Actions to execute at the completion of the job. Are executed in
	// the order provided.
	Actions []*GooglePrivacyDlpV2Action `json:"actions,omitempty"`
	// PrivacyMetric: Privacy metric to compute.
	PrivacyMetric *GooglePrivacyDlpV2PrivacyMetric `json:"privacyMetric,omitempty"`
	// SourceTable: Input dataset to compute metrics over.
	SourceTable *GooglePrivacyDlpV2BigQueryTable `json:"sourceTable,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Actions") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Actions") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GooglePrivacyDlpV2RiskAnalysisJobConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GooglePrivacyDlpV2RiskAnalysisJobConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GooglePrivacyDlpV2Row: Values of the row.
type GooglePrivacyDlpV2Row struct {
	// Values: Individual cells.
	Values []*GooglePrivacyDlpV2Value `json:"values,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Values") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Values") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GooglePrivacyDlpV2Row) MarshalJSON() ([]byte, error) {
	type NoMethod GooglePrivacyDlpV2Row
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GooglePrivacyDlpV2SaveFindings: If set, the detailed findings will be
// persisted to the specified OutputStorageConfig. Only a single instance of
// this action can be specified. Compatible with: Inspect, Risk
type GooglePrivacyDlpV2SaveFindings struct {
	// OutputConfig: Location to store findings outside of DLP.
	OutputConfig *GooglePrivacyDlpV2OutputStorageConfig `json:"outputConfig,omitempty"`
	// ForceSendFields is a list of field names (e.g. "OutputConfig") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "OutputConfig") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GooglePrivacyDlpV2SaveFindings) MarshalJSON() ([]byte, error) {
	type NoMethod GooglePrivacyDlpV2SaveFindings
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GooglePrivacyDlpV2SaveToGcsFindingsOutput: Collection of findings saved to a
// Cloud Storage bucket. This is used as the proto schema for textproto files
// created when specifying a cloud storage path to save Inspect findings.
type GooglePrivacyDlpV2SaveToGcsFindingsOutput struct {
	// Findings: List of findings.
	Findings []*GooglePrivacyDlpV2Finding `json:"findings,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Findings") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Findings") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GooglePrivacyDlpV2SaveToGcsFindingsOutput) MarshalJSON() ([]byte, error) {
	type NoMethod GooglePrivacyDlpV2SaveToGcsFindingsOutput
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GooglePrivacyDlpV2Schedule: Schedule for inspect job triggers.
type GooglePrivacyDlpV2Schedule struct {
	// RecurrencePeriodDuration: With this option a job is started on a regular
	// periodic basis. For example: every day (86400 seconds). A scheduled start
	// time will be skipped if the previous execution has not ended when its
	// scheduled time occurs. This value must be set to a time duration greater
	// than or equal to 1 day and can be no longer than 60 days.
	RecurrencePeriodDuration string `json:"recurrencePeriodDuration,omitempty"`
	// ForceSendFields is a list of field names (e.g. "RecurrencePeriodDuration")
	// to unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "RecurrencePeriodDuration") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GooglePrivacyDlpV2Schedule) MarshalJSON() ([]byte, error) {
	type NoMethod GooglePrivacyDlpV2Schedule
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GooglePrivacyDlpV2SchemaModifiedCadence: How frequently to modify the
// profile when the table's schema is modified.
type GooglePrivacyDlpV2SchemaModifiedCadence struct {
	// Frequency: Frequency to regenerate data profiles when the schema is
	// modified. Defaults to monthly.
	//
	// Possible values:
	//   "UPDATE_FREQUENCY_UNSPECIFIED" - Unspecified.
	//   "UPDATE_FREQUENCY_NEVER" - After the data profile is created, it will
	// never be updated.
	//   "UPDATE_FREQUENCY_DAILY" - The data profile can be updated up to once
	// every 24 hours.
	//   "UPDATE_FREQUENCY_MONTHLY" - The data profile can be updated up to once
	// every 30 days. Default.
	Frequency string `json:"frequency,omitempty"`
	// Types: The types of schema modifications to consider. Defaults to
	// NEW_COLUMNS.
	//
	// Possible values:
	//   "SQL_SCHEMA_MODIFICATION_UNSPECIFIED" - Unused.
	//   "NEW_COLUMNS" - New columns have appeared.
	//   "REMOVED_COLUMNS" - Columns have been removed from the table.
	Types []string `json:"types,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Frequency") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Frequency") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GooglePrivacyDlpV2SchemaModifiedCadence) MarshalJSON() ([]byte, error) {
	type NoMethod GooglePrivacyDlpV2SchemaModifiedCadence
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GooglePrivacyDlpV2SearchConnectionsResponse: Response message for
// SearchConnections.
type GooglePrivacyDlpV2SearchConnectionsResponse struct {
	// Connections: List of connections that match the search query. Note that only
	// a subset of the fields will be populated, and only "name" is guaranteed to
	// be set. For full details of a Connection, call GetConnection with the name.
	Connections []*GooglePrivacyDlpV2Connection `json:"connections,omitempty"`
	// NextPageToken: Token to retrieve the next page of results. An empty value
	// means there are no more results.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Connections") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Connections") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GooglePrivacyDlpV2SearchConnectionsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GooglePrivacyDlpV2SearchConnectionsResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GooglePrivacyDlpV2SecretManagerCredential: A credential consisting of a
// username and password, where the password is stored in a Secret Manager
// resource. Note: Secret Manager charges apply
// (https://cloud.google.com/secret-manager/pricing).
type GooglePrivacyDlpV2SecretManagerCredential struct {
	// PasswordSecretVersionName: Required. The name of the Secret Manager resource
	// that stores the password, in the form
	// `projects/project-id/secrets/secret-name/versions/version`.
	PasswordSecretVersionName string `json:"passwordSecretVersionName,omitempty"`
	// Username: Required. The username.
	Username string `json:"username,omitempty"`
	// ForceSendFields is a list of field names (e.g. "PasswordSecretVersionName")
	// to unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "PasswordSecretVersionName") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GooglePrivacyDlpV2SecretManagerCredential) MarshalJSON() ([]byte, error) {
	type NoMethod GooglePrivacyDlpV2SecretManagerCredential
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GooglePrivacyDlpV2SecretsDiscoveryTarget: Discovery target for credentials
// and secrets in cloud resource metadata. This target does not include any
// filtering or frequency controls. Cloud DLP will scan cloud resource metadata
// for secrets daily. No inspect template should be included in the discovery
// config for a security benchmarks scan. Instead, the built-in list of secrets
// and credentials infoTypes will be used (see
// https://cloud.google.com/sensitive-data-protection/docs/infotypes-reference#credentials_and_secrets).
// Credentials and secrets discovered will be reported as vulnerabilities to
// Security Command Center.
type GooglePrivacyDlpV2SecretsDiscoveryTarget struct {
}

// GooglePrivacyDlpV2SelectedInfoTypes: Apply transformation to the selected
// info_types.
type GooglePrivacyDlpV2SelectedInfoTypes struct {
	// InfoTypes: Required. InfoTypes to apply the transformation to. Required.
	// Provided InfoType must be unique within the ImageTransformations message.
	InfoTypes []*GooglePrivacyDlpV2InfoType `json:"infoTypes,omitempty"`
	// ForceSendFields is a list of field names (e.g. "InfoTypes") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "InfoTypes") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GooglePrivacyDlpV2SelectedInfoTypes) MarshalJSON() ([]byte, error) {
	type NoMethod GooglePrivacyDlpV2SelectedInfoTypes
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GooglePrivacyDlpV2SensitivityScore: Score is calculated from of all elements
// in the data profile. A higher level means the data is more sensitive.
type GooglePrivacyDlpV2SensitivityScore struct {
	// Score: The sensitivity score applied to the resource.
	//
	// Possible values:
	//   "SENSITIVITY_SCORE_UNSPECIFIED" - Unused.
	//   "SENSITIVITY_LOW" - No sensitive information detected. The resource isn't
	// publicly accessible.
	//   "SENSITIVITY_UNKNOWN" - Unable to determine sensitivity.
	//   "SENSITIVITY_MODERATE" - Medium risk. Contains personally identifiable
	// information (PII), potentially sensitive data, or fields with free-text data
	// that are at a higher risk of having intermittent sensitive data. Consider
	// limiting access.
	//   "SENSITIVITY_HIGH" - High risk. Sensitive personally identifiable
	// information (SPII) can be present. Exfiltration of data can lead to user
	// data loss. Re-identification of users might be possible. Consider limiting
	// usage and or removing SPII.
	Score string `json:"score,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Score") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Score") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GooglePrivacyDlpV2SensitivityScore) MarshalJSON() ([]byte, error) {
	type NoMethod GooglePrivacyDlpV2SensitivityScore
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GooglePrivacyDlpV2StatisticalTable: An auxiliary table containing
// statistical information on the relative frequency of different
// quasi-identifiers values. It has one or several quasi-identifiers columns,
// and one column that indicates the relative frequency of each
// quasi-identifier tuple. If a tuple is present in the data but not in the
// auxiliary table, the corresponding relative frequency is assumed to be zero
// (and thus, the tuple is highly reidentifiable).
type GooglePrivacyDlpV2StatisticalTable struct {
	// QuasiIds: Required. Quasi-identifier columns.
	QuasiIds []*GooglePrivacyDlpV2QuasiIdentifierField `json:"quasiIds,omitempty"`
	// RelativeFrequency: Required. The relative frequency column must contain a
	// floating-point number between 0 and 1 (inclusive). Null values are assumed
	// to be zero.
	RelativeFrequency *GooglePrivacyDlpV2FieldId `json:"relativeFrequency,omitempty"`
	// Table: Required. Auxiliary table location.
	Table *GooglePrivacyDlpV2BigQueryTable `json:"table,omitempty"`
	// ForceSendFields is a list of field names (e.g. "QuasiIds") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "QuasiIds") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GooglePrivacyDlpV2StatisticalTable) MarshalJSON() ([]byte, error) {
	type NoMethod GooglePrivacyDlpV2StatisticalTable
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GooglePrivacyDlpV2StorageConfig: Shared message indicating Cloud storage
// type.
type GooglePrivacyDlpV2StorageConfig struct {
	// BigQueryOptions: BigQuery options.
	BigQueryOptions *GooglePrivacyDlpV2BigQueryOptions `json:"bigQueryOptions,omitempty"`
	// CloudStorageOptions: Cloud Storage options.
	CloudStorageOptions *GooglePrivacyDlpV2CloudStorageOptions `json:"cloudStorageOptions,omitempty"`
	// DatastoreOptions: Google Cloud Datastore options.
	DatastoreOptions *GooglePrivacyDlpV2DatastoreOptions `json:"datastoreOptions,omitempty"`
	// HybridOptions: Hybrid inspection options.
	HybridOptions *GooglePrivacyDlpV2HybridOptions `json:"hybridOptions,omitempty"`
	// TimespanConfig: Configuration of the timespan of the items to include in
	// scanning.
	TimespanConfig *GooglePrivacyDlpV2TimespanConfig `json:"timespanConfig,omitempty"`
	// ForceSendFields is a list of field names (e.g. "BigQueryOptions") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "BigQueryOptions") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GooglePrivacyDlpV2StorageConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GooglePrivacyDlpV2StorageConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GooglePrivacyDlpV2StorageMetadataLabel: Storage metadata label to indicate
// which metadata entry contains findings.
type GooglePrivacyDlpV2StorageMetadataLabel struct {
	// Key: Label name.
	Key string `json:"key,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Key") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Key") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GooglePrivacyDlpV2StorageMetadataLabel) MarshalJSON() ([]byte, error) {
	type NoMethod GooglePrivacyDlpV2StorageMetadataLabel
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GooglePrivacyDlpV2StoredInfoType: StoredInfoType resource message that
// contains information about the current version and any pending updates.
type GooglePrivacyDlpV2StoredInfoType struct {
	// CurrentVersion: Current version of the stored info type.
	CurrentVersion *GooglePrivacyDlpV2StoredInfoTypeVersion `json:"currentVersion,omitempty"`
	// Name: Resource name.
	Name string `json:"name,omitempty"`
	// PendingVersions: Pending versions of the stored info type. Empty if no
	// versions are pending.
	PendingVersions []*GooglePrivacyDlpV2StoredInfoTypeVersion `json:"pendingVersions,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "CurrentVersion") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CurrentVersion") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GooglePrivacyDlpV2StoredInfoType) MarshalJSON() ([]byte, error) {
	type NoMethod GooglePrivacyDlpV2StoredInfoType
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GooglePrivacyDlpV2StoredInfoTypeConfig: Configuration for stored infoTypes.
// All fields and subfield are provided by the user. For more information, see
// https://cloud.google.com/sensitive-data-protection/docs/creating-custom-infotypes.
type GooglePrivacyDlpV2StoredInfoTypeConfig struct {
	// Description: Description of the StoredInfoType (max 256 characters).
	Description string `json:"description,omitempty"`
	// Dictionary: Store dictionary-based CustomInfoType.
	Dictionary *GooglePrivacyDlpV2Dictionary `json:"dictionary,omitempty"`
	// DisplayName: Display name of the StoredInfoType (max 256 characters).
	DisplayName string `json:"displayName,omitempty"`
	// LargeCustomDictionary: StoredInfoType where findings are defined by a
	// dictionary of phrases.
	LargeCustomDictionary *GooglePrivacyDlpV2LargeCustomDictionaryConfig `json:"largeCustomDictionary,omitempty"`
	// Regex: Store regular expression-based StoredInfoType.
	Regex *GooglePrivacyDlpV2Regex `json:"regex,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Description") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Description") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GooglePrivacyDlpV2StoredInfoTypeConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GooglePrivacyDlpV2StoredInfoTypeConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GooglePrivacyDlpV2StoredInfoTypeStats: Statistics for a StoredInfoType.
type GooglePrivacyDlpV2StoredInfoTypeStats struct {
	// LargeCustomDictionary: StoredInfoType where findings are defined by a
	// dictionary of phrases.
	LargeCustomDictionary *GooglePrivacyDlpV2LargeCustomDictionaryStats `json:"largeCustomDictionary,omitempty"`
	// ForceSendFields is a list of field names (e.g. "LargeCustomDictionary") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "LargeCustomDictionary") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GooglePrivacyDlpV2StoredInfoTypeStats) MarshalJSON() ([]byte, error) {
	type NoMethod GooglePrivacyDlpV2StoredInfoTypeStats
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GooglePrivacyDlpV2StoredInfoTypeVersion: Version of a StoredInfoType,
// including the configuration used to build it, create timestamp, and current
// state.
type GooglePrivacyDlpV2StoredInfoTypeVersion struct {
	// Config: StoredInfoType configuration.
	Config *GooglePrivacyDlpV2StoredInfoTypeConfig `json:"config,omitempty"`
	// CreateTime: Create timestamp of the version. Read-only, determined by the
	// system when the version is created.
	CreateTime string `json:"createTime,omitempty"`
	// Errors: Errors that occurred when creating this storedInfoType version, or
	// anomalies detected in the storedInfoType data that render it unusable. Only
	// the five most recent errors will be displayed, with the most recent error
	// appearing first. For example, some of the data for stored custom
	// dictionaries is put in the user's Cloud Storage bucket, and if this data is
	// modified or deleted by the user or another system, the dictionary becomes
	// invalid. If any errors occur, fix the problem indicated by the error message
	// and use the UpdateStoredInfoType API method to create another version of the
	// storedInfoType to continue using it, reusing the same `config` if it was not
	// the source of the error.
	Errors []*GooglePrivacyDlpV2Error `json:"errors,omitempty"`
	// State: Stored info type version state. Read-only, updated by the system
	// during dictionary creation.
	//
	// Possible values:
	//   "STORED_INFO_TYPE_STATE_UNSPECIFIED" - Unused
	//   "PENDING" - StoredInfoType version is being created.
	//   "READY" - StoredInfoType version is ready for use.
	//   "FAILED" - StoredInfoType creation failed. All relevant error messages are
	// returned in the `StoredInfoTypeVersion` message.
	//   "INVALID" - StoredInfoType is no longer valid because artifacts stored in
	// user-controlled storage were modified. To fix an invalid StoredInfoType, use
	// the `UpdateStoredInfoType` method to create a new version.
	State string `json:"state,omitempty"`
	// Stats: Statistics about this storedInfoType version.
	Stats *GooglePrivacyDlpV2StoredInfoTypeStats `json:"stats,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Config") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Config") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GooglePrivacyDlpV2StoredInfoTypeVersion) MarshalJSON() ([]byte, error) {
	type NoMethod GooglePrivacyDlpV2StoredInfoTypeVersion
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GooglePrivacyDlpV2StoredType: A reference to a StoredInfoType to use with
// scanning.
type GooglePrivacyDlpV2StoredType struct {
	// CreateTime: Timestamp indicating when the version of the `StoredInfoType`
	// used for inspection was created. Output-only field, populated by the system.
	CreateTime string `json:"createTime,omitempty"`
	// Name: Resource name of the requested `StoredInfoType`, for example
	// `organizations/433245324/storedInfoTypes/432452342` or
	// `projects/project-id/storedInfoTypes/432452342`.
	Name string `json:"name,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CreateTime") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CreateTime") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GooglePrivacyDlpV2StoredType) MarshalJSON() ([]byte, error) {
	type NoMethod GooglePrivacyDlpV2StoredType
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GooglePrivacyDlpV2SummaryResult: A collection that informs the user the
// number of times a particular `TransformationResultCode` and error details
// occurred.
type GooglePrivacyDlpV2SummaryResult struct {
	// Code: Outcome of the transformation.
	//
	// Possible values:
	//   "TRANSFORMATION_RESULT_CODE_UNSPECIFIED" - Unused
	//   "SUCCESS" - Transformation completed without an error.
	//   "ERROR" - Transformation had an error.
	Code string `json:"code,omitempty"`
	// Count: Number of transformations counted by this result.
	Count int64 `json:"count,omitempty,string"`
	// Details: A place for warnings or errors to show up if a transformation
	// didn't work as expected.
	Details string `json:"details,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Code") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Code") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GooglePrivacyDlpV2SummaryResult) MarshalJSON() ([]byte, error) {
	type NoMethod GooglePrivacyDlpV2SummaryResult
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GooglePrivacyDlpV2SurrogateType: Message for detecting output from
// deidentification transformations such as `CryptoReplaceFfxFpeConfig`
// (https://cloud.google.com/sensitive-data-protection/docs/reference/rest/v2/organizations.deidentifyTemplates#cryptoreplaceffxfpeconfig).
// These types of transformations are those that perform pseudonymization,
// thereby producing a "surrogate" as output. This should be used in
// conjunction with a field on the transformation such as
// `surrogate_info_type`. This CustomInfoType does not support the use of
// `detection_rules`.
type GooglePrivacyDlpV2SurrogateType struct {
}

// GooglePrivacyDlpV2Table: Structured content to inspect. Up to 50,000
// `Value`s per request allowed. See
// https://cloud.google.com/sensitive-data-protection/docs/inspecting-structured-text#inspecting_a_table
// to learn more.
type GooglePrivacyDlpV2Table struct {
	// Headers: Headers of the table.
	Headers []*GooglePrivacyDlpV2FieldId `json:"headers,omitempty"`
	// Rows: Rows of the table.
	Rows []*GooglePrivacyDlpV2Row `json:"rows,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Headers") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Headers") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GooglePrivacyDlpV2Table) MarshalJSON() ([]byte, error) {
	type NoMethod GooglePrivacyDlpV2Table
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GooglePrivacyDlpV2TableDataProfile: The profile for a scanned table.
type GooglePrivacyDlpV2TableDataProfile struct {
	// ConfigSnapshot: The snapshot of the configurations used to generate the
	// profile.
	ConfigSnapshot *GooglePrivacyDlpV2DataProfileConfigSnapshot `json:"configSnapshot,omitempty"`
	// CreateTime: The time at which the table was created.
	CreateTime string `json:"createTime,omitempty"`
	// DataRiskLevel: The data risk level of this table.
	DataRiskLevel *GooglePrivacyDlpV2DataRiskLevel `json:"dataRiskLevel,omitempty"`
	// DataSourceType: The resource type that was profiled.
	DataSourceType *GooglePrivacyDlpV2DataSourceType `json:"dataSourceType,omitempty"`
	// DatasetId: If the resource is BigQuery, the dataset ID.
	DatasetId string `json:"datasetId,omitempty"`
	// DatasetLocation: If supported, the location where the dataset's data is
	// stored. See https://cloud.google.com/bigquery/docs/locations for supported
	// locations.
	DatasetLocation string `json:"datasetLocation,omitempty"`
	// DatasetProjectId: The Google Cloud project ID that owns the resource.
	DatasetProjectId string `json:"datasetProjectId,omitempty"`
	// Domains: Domains associated with the profile.
	Domains []*GooglePrivacyDlpV2Domain `json:"domains,omitempty"`
	// EncryptionStatus: How the table is encrypted.
	//
	// Possible values:
	//   "ENCRYPTION_STATUS_UNSPECIFIED" - Unused.
	//   "ENCRYPTION_GOOGLE_MANAGED" - Google manages server-side encryption keys
	// on your behalf.
	//   "ENCRYPTION_CUSTOMER_MANAGED" - Customer provides the key.
	EncryptionStatus string `json:"encryptionStatus,omitempty"`
	// ExpirationTime: Optional. The time when this table expires.
	ExpirationTime string `json:"expirationTime,omitempty"`
	// FailedColumnCount: The number of columns skipped in the table because of an
	// error.
	FailedColumnCount int64 `json:"failedColumnCount,omitempty,string"`
	// FullResource: The Cloud Asset Inventory resource that was profiled in order
	// to generate this TableDataProfile.
	// https://cloud.google.com/apis/design/resource_names#full_resource_name
	FullResource string `json:"fullResource,omitempty"`
	// LastModifiedTime: The time when this table was last modified
	LastModifiedTime string `json:"lastModifiedTime,omitempty"`
	// Name: The name of the profile.
	Name string `json:"name,omitempty"`
	// OtherInfoTypes: Other infoTypes found in this table's data.
	OtherInfoTypes []*GooglePrivacyDlpV2OtherInfoTypeSummary `json:"otherInfoTypes,omitempty"`
	// PredictedInfoTypes: The infoTypes predicted from this table's data.
	PredictedInfoTypes []*GooglePrivacyDlpV2InfoTypeSummary `json:"predictedInfoTypes,omitempty"`
	// ProfileLastGenerated: The last time the profile was generated.
	ProfileLastGenerated string `json:"profileLastGenerated,omitempty"`
	// ProfileStatus: Success or error status from the most recent profile
	// generation attempt. May be empty if the profile is still being generated.
	ProfileStatus *GooglePrivacyDlpV2ProfileStatus `json:"profileStatus,omitempty"`
	// ProjectDataProfile: The resource name of the project data profile for this
	// table.
	ProjectDataProfile string `json:"projectDataProfile,omitempty"`
	// RelatedResources: Resources related to this profile.
	RelatedResources []*GooglePrivacyDlpV2RelatedResource `json:"relatedResources,omitempty"`
	// ResourceLabels: The labels applied to the resource at the time the profile
	// was generated.
	ResourceLabels map[string]string `json:"resourceLabels,omitempty"`
	// ResourceVisibility: How broadly a resource has been shared.
	//
	// Possible values:
	//   "RESOURCE_VISIBILITY_UNSPECIFIED" - Unused.
	//   "RESOURCE_VISIBILITY_PUBLIC" - Visible to any user.
	//   "RESOURCE_VISIBILITY_INCONCLUSIVE" - May contain public items. For
	// example, if a Cloud Storage bucket has uniform bucket level access disabled,
	// some objects inside it may be public, but none are known yet.
	//   "RESOURCE_VISIBILITY_RESTRICTED" - Visible only to specific users.
	ResourceVisibility string `json:"resourceVisibility,omitempty"`
	// RowCount: Number of rows in the table when the profile was generated. This
	// will not be populated for BigLake tables.
	RowCount int64 `json:"rowCount,omitempty,string"`
	// SampleFindingsTable: The BigQuery table to which the sample findings are
	// written.
	SampleFindingsTable *GooglePrivacyDlpV2BigQueryTable `json:"sampleFindingsTable,omitempty"`
	// ScannedColumnCount: The number of columns profiled in the table.
	ScannedColumnCount int64 `json:"scannedColumnCount,omitempty,string"`
	// SensitivityScore: The sensitivity score of this table.
	SensitivityScore *GooglePrivacyDlpV2SensitivityScore `json:"sensitivityScore,omitempty"`
	// State: State of a profile. This will always be set to DONE when the table
	// data profile is written to another service like BigQuery or Pub/Sub.
	//
	// Possible values:
	//   "STATE_UNSPECIFIED" - Unused.
	//   "RUNNING" - The profile is currently running. Once a profile has finished
	// it will transition to DONE.
	//   "DONE" - The profile is no longer generating. If
	// profile_status.status.code is 0, the profile succeeded, otherwise, it
	// failed.
	State string `json:"state,omitempty"`
	// TableId: The table ID.
	TableId string `json:"tableId,omitempty"`
	// TableSizeBytes: The size of the table when the profile was generated.
	TableSizeBytes int64 `json:"tableSizeBytes,omitempty,string"`
	// Tags: The tags attached to the table, including any tags attached during
	// profiling. Because tags are attached to Cloud SQL instances rather than
	// Cloud SQL tables, this field is empty for Cloud SQL table profiles.
	Tags []*GooglePrivacyDlpV2Tag `json:"tags,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "ConfigSnapshot") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ConfigSnapshot") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GooglePrivacyDlpV2TableDataProfile) MarshalJSON() ([]byte, error) {
	type NoMethod GooglePrivacyDlpV2TableDataProfile
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GooglePrivacyDlpV2TableLocation: Location of a finding within a table.
type GooglePrivacyDlpV2TableLocation struct {
	// RowIndex: The zero-based index of the row where the finding is located. Only
	// populated for resources that have a natural ordering, not BigQuery. In
	// BigQuery, to identify the row a finding came from, populate
	// BigQueryOptions.identifying_fields with your primary key column names and
	// when you store the findings the value of those columns will be stored inside
	// of Finding.
	RowIndex int64 `json:"rowIndex,omitempty,string"`
	// ForceSendFields is a list of field names (e.g. "RowIndex") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "RowIndex") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GooglePrivacyDlpV2TableLocation) MarshalJSON() ([]byte, error) {
	type NoMethod GooglePrivacyDlpV2TableLocation
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GooglePrivacyDlpV2TableOptions: Instructions regarding the table content
// being inspected.
type GooglePrivacyDlpV2TableOptions struct {
	// IdentifyingFields: The columns that are the primary keys for table objects
	// included in ContentItem. A copy of this cell's value will stored alongside
	// alongside each finding so that the finding can be traced to the specific row
	// it came from. No more than 3 may be provided.
	IdentifyingFields []*GooglePrivacyDlpV2FieldId `json:"identifyingFields,omitempty"`
	// ForceSendFields is a list of field names (e.g. "IdentifyingFields") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "IdentifyingFields") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GooglePrivacyDlpV2TableOptions) MarshalJSON() ([]byte, error) {
	type NoMethod GooglePrivacyDlpV2TableOptions
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GooglePrivacyDlpV2TableReference: Message defining the location of a
// BigQuery table with the projectId inferred from the parent project.
type GooglePrivacyDlpV2TableReference struct {
	// DatasetId: Dataset ID of the table.
	DatasetId string `json:"datasetId,omitempty"`
	// ProjectId: The Google Cloud project ID of the project containing the table.
	// If omitted, the project ID is inferred from the parent project. This field
	// is required if the parent resource is an organization.
	ProjectId string `json:"projectId,omitempty"`
	// TableId: Name of the table.
	TableId string `json:"tableId,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DatasetId") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DatasetId") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GooglePrivacyDlpV2TableReference) MarshalJSON() ([]byte, error) {
	type NoMethod GooglePrivacyDlpV2TableReference
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GooglePrivacyDlpV2Tag: A tag associated with a resource.
type GooglePrivacyDlpV2Tag struct {
	// Key: The key of a tag key-value pair. For Google Cloud resources, this is
	// the resource name of the key, for example, "tagKeys/123456".
	Key string `json:"key,omitempty"`
	// NamespacedTagValue: The namespaced name for the tag value to attach to
	// Google Cloud resources. Must be in the format
	// `{parent_id}/{tag_key_short_name}/{short_name}`, for example,
	// "123456/environment/prod" for an organization parent, or
	// "my-project/environment/prod" for a project parent. This is only set for
	// Google Cloud resources.
	NamespacedTagValue string `json:"namespacedTagValue,omitempty"`
	// Value: The value of a tag key-value pair. For Google Cloud resources, this
	// is the resource name of the value, for example, "tagValues/123456".
	Value string `json:"value,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Key") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Key") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GooglePrivacyDlpV2Tag) MarshalJSON() ([]byte, error) {
	type NoMethod GooglePrivacyDlpV2Tag
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GooglePrivacyDlpV2TagCondition: The tag to attach to profiles matching the
// condition. At most one `TagCondition` can be specified per sensitivity
// level.
type GooglePrivacyDlpV2TagCondition struct {
	// SensitivityScore: Conditions attaching the tag to a resource on its profile
	// having this sensitivity score.
	SensitivityScore *GooglePrivacyDlpV2SensitivityScore `json:"sensitivityScore,omitempty"`
	// Tag: The tag value to attach to resources.
	Tag *GooglePrivacyDlpV2TagValue `json:"tag,omitempty"`
	// ForceSendFields is a list of field names (e.g. "SensitivityScore") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "SensitivityScore") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GooglePrivacyDlpV2TagCondition) MarshalJSON() ([]byte, error) {
	type NoMethod GooglePrivacyDlpV2TagCondition
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GooglePrivacyDlpV2TagFilter: A single tag to filter against.
type GooglePrivacyDlpV2TagFilter struct {
	// NamespacedTagKey: The namespaced name for the tag key. Must be in the format
	// `{parent_id}/{tag_key_short_name}`, for example, "123456/sensitive" for an
	// organization parent, or "my-project/sensitive" for a project parent.
	NamespacedTagKey string `json:"namespacedTagKey,omitempty"`
	// NamespacedTagValue: The namespaced name for the tag value. Must be in the
	// format `{parent_id}/{tag_key_short_name}/{short_name}`, for example,
	// "123456/environment/prod" for an organization parent, or
	// "my-project/environment/prod" for a project parent.
	NamespacedTagValue string `json:"namespacedTagValue,omitempty"`
	// ForceSendFields is a list of field names (e.g. "NamespacedTagKey") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "NamespacedTagKey") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GooglePrivacyDlpV2TagFilter) MarshalJSON() ([]byte, error) {
	type NoMethod GooglePrivacyDlpV2TagFilter
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GooglePrivacyDlpV2TagFilters: Tags to match against for filtering.
type GooglePrivacyDlpV2TagFilters struct {
	// TagFilters: Required. A resource must match ALL of the specified tag filters
	// to be included in the collection.
	TagFilters []*GooglePrivacyDlpV2TagFilter `json:"tagFilters,omitempty"`
	// ForceSendFields is a list of field names (e.g. "TagFilters") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "TagFilters") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GooglePrivacyDlpV2TagFilters) MarshalJSON() ([]byte, error) {
	type NoMethod GooglePrivacyDlpV2TagFilters
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GooglePrivacyDlpV2TagResources: If set, attaches the [tags]
// (https://cloud.google.com/resource-manager/docs/tags/tags-overview) provided
// to profiled resources. Tags support access control
// (https://cloud.google.com/iam/docs/tags-access-control). You can
// conditionally grant or deny access to a resource based on whether the
// resource has a specific tag.
type GooglePrivacyDlpV2TagResources struct {
	// LowerDataRiskToLow: Whether applying a tag to a resource should lower the
	// risk of the profile for that resource. For example, in conjunction with an
	// IAM deny policy (https://cloud.google.com/iam/docs/deny-overview), you can
	// deny all principals a permission if a tag value is present, mitigating the
	// risk of the resource. This also lowers the data risk of resources at the
	// lower levels of the resource hierarchy. For example, reducing the data risk
	// of a table data profile also reduces the data risk of the constituent column
	// data profiles.
	LowerDataRiskToLow bool `json:"lowerDataRiskToLow,omitempty"`
	// ProfileGenerationsToTag: The profile generations for which the tag should be
	// attached to resources. If you attach a tag to only new profiles, then if the
	// sensitivity score of a profile subsequently changes, its tag doesn't change.
	// By default, this field includes only new profiles. To include both new and
	// updated profiles for tagging, this field should explicitly include both
	// `PROFILE_GENERATION_NEW` and `PROFILE_GENERATION_UPDATE`.
	//
	// Possible values:
	//   "PROFILE_GENERATION_UNSPECIFIED" - Unused.
	//   "PROFILE_GENERATION_NEW" - The profile is the first profile for the
	// resource.
	//   "PROFILE_GENERATION_UPDATE" - The profile is an update to a previous
	// profile.
	ProfileGenerationsToTag []string `json:"profileGenerationsToTag,omitempty"`
	// TagConditions: The tags to associate with different conditions.
	TagConditions []*GooglePrivacyDlpV2TagCondition `json:"tagConditions,omitempty"`
	// ForceSendFields is a list of field names (e.g. "LowerDataRiskToLow") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "LowerDataRiskToLow") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GooglePrivacyDlpV2TagResources) MarshalJSON() ([]byte, error) {
	type NoMethod GooglePrivacyDlpV2TagResources
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GooglePrivacyDlpV2TagValue: A value of a tag.
type GooglePrivacyDlpV2TagValue struct {
	// NamespacedValue: The namespaced name for the tag value to attach to
	// resources. Must be in the format
	// `{parent_id}/{tag_key_short_name}/{short_name}`, for example,
	// "123456/environment/prod" for an organization parent, or
	// "my-project/environment/prod" for a project parent.
	NamespacedValue string `json:"namespacedValue,omitempty"`
	// ForceSendFields is a list of field names (e.g. "NamespacedValue") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "NamespacedValue") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GooglePrivacyDlpV2TagValue) MarshalJSON() ([]byte, error) {
	type NoMethod GooglePrivacyDlpV2TagValue
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GooglePrivacyDlpV2TaggedField: A column with a semantic tag attached.
type GooglePrivacyDlpV2TaggedField struct {
	// CustomTag: A column can be tagged with a custom tag. In this case, the user
	// must indicate an auxiliary table that contains statistical information on
	// the possible values of this column.
	CustomTag string `json:"customTag,omitempty"`
	// Field: Required. Identifies the column.
	Field *GooglePrivacyDlpV2FieldId `json:"field,omitempty"`
	// Inferred: If no semantic tag is indicated, we infer the statistical model
	// from the distribution of values in the input data
	Inferred *GoogleProtobufEmpty `json:"inferred,omitempty"`
	// InfoType: A column can be tagged with a InfoType to use the relevant public
	// dataset as a statistical model of population, if available. We currently
	// support US ZIP codes, region codes, ages and genders. To programmatically
	// obtain the list of supported InfoTypes, use ListInfoTypes with the
	// supported_by=RISK_ANALYSIS filter.
	InfoType *GooglePrivacyDlpV2InfoType `json:"infoType,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CustomTag") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CustomTag") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GooglePrivacyDlpV2TaggedField) MarshalJSON() ([]byte, error) {
	type NoMethod GooglePrivacyDlpV2TaggedField
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GooglePrivacyDlpV2ThrowError: Throw an error and fail the request when a
// transformation error occurs.
type GooglePrivacyDlpV2ThrowError struct {
}

// GooglePrivacyDlpV2TimePartConfig: For use with `Date`, `Timestamp`, and
// `TimeOfDay`, extract or preserve a portion of the value.
type GooglePrivacyDlpV2TimePartConfig struct {
	// PartToExtract: The part of the time to keep.
	//
	// Possible values:
	//   "TIME_PART_UNSPECIFIED" - Unused
	//   "YEAR" - [0-9999]
	//   "MONTH" - [1-12]
	//   "DAY_OF_MONTH" - [1-31]
	//   "DAY_OF_WEEK" - [1-7]
	//   "WEEK_OF_YEAR" - [1-53]
	//   "HOUR_OF_DAY" - [0-23]
	PartToExtract string `json:"partToExtract,omitempty"`
	// ForceSendFields is a list of field names (e.g. "PartToExtract") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "PartToExtract") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GooglePrivacyDlpV2TimePartConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GooglePrivacyDlpV2TimePartConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GooglePrivacyDlpV2TimeZone: Time zone of the date time object.
type GooglePrivacyDlpV2TimeZone struct {
	// OffsetMinutes: Set only if the offset can be determined. Positive for time
	// ahead of UTC. E.g. For "UTC-9", this value is -540.
	OffsetMinutes int64 `json:"offsetMinutes,omitempty"`
	// ForceSendFields is a list of field names (e.g. "OffsetMinutes") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "OffsetMinutes") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GooglePrivacyDlpV2TimeZone) MarshalJSON() ([]byte, error) {
	type NoMethod GooglePrivacyDlpV2TimeZone
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GooglePrivacyDlpV2TimespanConfig: Configuration of the timespan of the items
// to include in scanning. Currently only supported when inspecting Cloud
// Storage and BigQuery.
type GooglePrivacyDlpV2TimespanConfig struct {
	// EnableAutoPopulationOfTimespanConfig: When the job is started by a
	// JobTrigger we will automatically figure out a valid start_time to avoid
	// scanning files that have not been modified since the last time the
	// JobTrigger executed. This will be based on the time of the execution of the
	// last run of the JobTrigger or the timespan end_time used in the last run of
	// the JobTrigger. **For BigQuery** Inspect jobs triggered by automatic
	// population will scan data that is at least three hours old when the job
	// starts. This is because streaming buffer rows are not read during inspection
	// and reading up to the current timestamp will result in skipped rows. See the
	// known issue
	// (https://cloud.google.com/sensitive-data-protection/docs/known-issues#recently-streamed-data)
	// related to this operation.
	EnableAutoPopulationOfTimespanConfig bool `json:"enableAutoPopulationOfTimespanConfig,omitempty"`
	// EndTime: Exclude files, tables, or rows newer than this value. If not set,
	// no upper time limit is applied.
	EndTime string `json:"endTime,omitempty"`
	// StartTime: Exclude files, tables, or rows older than this value. If not set,
	// no lower time limit is applied.
	StartTime string `json:"startTime,omitempty"`
	// TimestampField: Specification of the field containing the timestamp of
	// scanned items. Used for data sources like Datastore and BigQuery. **For
	// BigQuery** If this value is not specified and the table was modified between
	// the given start and end times, the entire table will be scanned. If this
	// value is specified, then rows are filtered based on the given start and end
	// times. Rows with a `NULL` value in the provided BigQuery column are skipped.
	// Valid data types of the provided BigQuery column are: `INTEGER`, `DATE`,
	// `TIMESTAMP`, and `DATETIME`. If your BigQuery table is partitioned at
	// ingestion time
	// (https://cloud.google.com/bigquery/docs/partitioned-tables#ingestion_time),
	// you can use any of the following pseudo-columns as your timestamp field.
	// When used with Cloud DLP, these pseudo-column names are case sensitive. -
	// `_PARTITIONTIME` - `_PARTITIONDATE` - `_PARTITION_LOAD_TIME` **For
	// Datastore** If this value is specified, then entities are filtered based on
	// the given start and end times. If an entity does not contain the provided
	// timestamp property or contains empty or invalid values, then it is included.
	// Valid data types of the provided timestamp property are: `TIMESTAMP`. See
	// the known issue
	// (https://cloud.google.com/sensitive-data-protection/docs/known-issues#bq-timespan)
	// related to this operation.
	TimestampField *GooglePrivacyDlpV2FieldId `json:"timestampField,omitempty"`
	// ForceSendFields is a list of field names (e.g.
	// "EnableAutoPopulationOfTimespanConfig") to unconditionally include in API
	// requests. By default, fields with empty or default values are omitted from
	// API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g.
	// "EnableAutoPopulationOfTimespanConfig") to include in API requests with the
	// JSON null value. By default, fields with empty values are omitted from API
	// requests. See https://pkg.go.dev/google.golang.org/api#hdr-NullFields for
	// more details.
	NullFields []string `json:"-"`
}

func (s GooglePrivacyDlpV2TimespanConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GooglePrivacyDlpV2TimespanConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GooglePrivacyDlpV2TransformationConfig: User specified templates and configs
// for how to deidentify structured, unstructures, and image files. User must
// provide either a unstructured deidentify template or at least one redact
// image config.
type GooglePrivacyDlpV2TransformationConfig struct {
	// DeidentifyTemplate: De-identify template. If this template is specified, it
	// will serve as the default de-identify template. This template cannot contain
	// `record_transformations` since it can be used for unstructured content such
	// as free-form text files. If this template is not set, a default
	// `ReplaceWithInfoTypeConfig` will be used to de-identify unstructured
	// content.
	DeidentifyTemplate string `json:"deidentifyTemplate,omitempty"`
	// ImageRedactTemplate: Image redact template. If this template is specified,
	// it will serve as the de-identify template for images. If this template is
	// not set, all findings in the image will be redacted with a black box.
	ImageRedactTemplate string `json:"imageRedactTemplate,omitempty"`
	// StructuredDeidentifyTemplate: Structured de-identify template. If this
	// template is specified, it will serve as the de-identify template for
	// structured content such as delimited files and tables. If this template is
	// not set but the `deidentify_template` is set, then `deidentify_template`
	// will also apply to the structured content. If neither template is set, a
	// default `ReplaceWithInfoTypeConfig` will be used to de-identify structured
	// content.
	StructuredDeidentifyTemplate string `json:"structuredDeidentifyTemplate,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DeidentifyTemplate") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DeidentifyTemplate") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GooglePrivacyDlpV2TransformationConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GooglePrivacyDlpV2TransformationConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GooglePrivacyDlpV2TransformationDescription: A flattened description of a
// `PrimitiveTransformation` or `RecordSuppression`.
type GooglePrivacyDlpV2TransformationDescription struct {
	// Condition: A human-readable string representation of the `RecordCondition`
	// corresponding to this transformation. Set if a `RecordCondition` was used to
	// determine whether or not to apply this transformation. Examples: *
	// (age_field > 85) * (age_field <= 18) * (zip_field exists) * (zip_field ==
	// 01234) && (city_field != "Springville") * (zip_field == 01234) && (age_field
	// <= 18) && (city_field exists)
	Condition string `json:"condition,omitempty"`
	// Description: A description of the transformation. This is empty for a
	// RECORD_SUPPRESSION, or is the output of calling toString() on the
	// `PrimitiveTransformation` protocol buffer message for any other type of
	// transformation.
	Description string `json:"description,omitempty"`
	// InfoType: Set if the transformation was limited to a specific `InfoType`.
	InfoType *GooglePrivacyDlpV2InfoType `json:"infoType,omitempty"`
	// Type: The transformation type.
	//
	// Possible values:
	//   "TRANSFORMATION_TYPE_UNSPECIFIED" - Unused
	//   "RECORD_SUPPRESSION" - Record suppression
	//   "REPLACE_VALUE" - Replace value
	//   "REPLACE_DICTIONARY" - Replace value using a dictionary.
	//   "REDACT" - Redact
	//   "CHARACTER_MASK" - Character mask
	//   "CRYPTO_REPLACE_FFX_FPE" - FFX-FPE
	//   "FIXED_SIZE_BUCKETING" - Fixed size bucketing
	//   "BUCKETING" - Bucketing
	//   "REPLACE_WITH_INFO_TYPE" - Replace with info type
	//   "TIME_PART" - Time part
	//   "CRYPTO_HASH" - Crypto hash
	//   "DATE_SHIFT" - Date shift
	//   "CRYPTO_DETERMINISTIC_CONFIG" - Deterministic crypto
	//   "REDACT_IMAGE" - Redact image
	Type string `json:"type,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Condition") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Condition") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GooglePrivacyDlpV2TransformationDescription) MarshalJSON() ([]byte, error) {
	type NoMethod GooglePrivacyDlpV2TransformationDescription
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GooglePrivacyDlpV2TransformationDetails: Details about a single
// transformation. This object contains a description of the transformation,
// information about whether the transformation was successfully applied, and
// the precise location where the transformation occurred. These details are
// stored in a user-specified BigQuery table.
type GooglePrivacyDlpV2TransformationDetails struct {
	// ContainerName: The top level name of the container where the transformation
	// is located (this will be the source file name or table name).
	ContainerName string `json:"containerName,omitempty"`
	// ResourceName: The name of the job that completed the transformation.
	ResourceName string `json:"resourceName,omitempty"`
	// StatusDetails: Status of the transformation, if transformation was not
	// successful, this will specify what caused it to fail, otherwise it will show
	// that the transformation was successful.
	StatusDetails *GooglePrivacyDlpV2TransformationResultStatus `json:"statusDetails,omitempty"`
	// Transformation: Description of transformation. This would only contain more
	// than one element if there were multiple matching transformations and which
	// one to apply was ambiguous. Not set for states that contain no
	// transformation, currently only state that contains no transformation is
	// TransformationResultStateType.METADATA_UNRETRIEVABLE.
	Transformation []*GooglePrivacyDlpV2TransformationDescription `json:"transformation,omitempty"`
	// TransformationLocation: The precise location of the transformed content in
	// the original container.
	TransformationLocation *GooglePrivacyDlpV2TransformationLocation `json:"transformationLocation,omitempty"`
	// TransformedBytes: The number of bytes that were transformed. If
	// transformation was unsuccessful or did not take place because there was no
	// content to transform, this will be zero.
	TransformedBytes int64 `json:"transformedBytes,omitempty,string"`
	// ForceSendFields is a list of field names (e.g. "ContainerName") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ContainerName") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GooglePrivacyDlpV2TransformationDetails) MarshalJSON() ([]byte, error) {
	type NoMethod GooglePrivacyDlpV2TransformationDetails
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GooglePrivacyDlpV2TransformationDetailsStorageConfig: Config for storing
// transformation details.
type GooglePrivacyDlpV2TransformationDetailsStorageConfig struct {
	// Table: The BigQuery table in which to store the output. This may be an
	// existing table or in a new table in an existing dataset. If table_id is not
	// set a new one will be generated for you with the following format:
	// dlp_googleapis_transformation_details_yyyy_mm_dd_[dlp_job_id]. Pacific time
	// zone will be used for generating the date details.
	Table *GooglePrivacyDlpV2BigQueryTable `json:"table,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Table") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Table") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GooglePrivacyDlpV2TransformationDetailsStorageConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GooglePrivacyDlpV2TransformationDetailsStorageConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GooglePrivacyDlpV2TransformationErrorHandling: How to handle transformation
// errors during de-identification. A transformation error occurs when the
// requested transformation is incompatible with the data. For example, trying
// to de-identify an IP address using a `DateShift` transformation would result
// in a transformation error, since date info cannot be extracted from an IP
// address. Information about any incompatible transformations, and how they
// were handled, is returned in the response as part of the
// `TransformationOverviews`.
type GooglePrivacyDlpV2TransformationErrorHandling struct {
	// LeaveUntransformed: Ignore errors
	LeaveUntransformed *GooglePrivacyDlpV2LeaveUntransformed `json:"leaveUntransformed,omitempty"`
	// ThrowError: Throw an error
	ThrowError *GooglePrivacyDlpV2ThrowError `json:"throwError,omitempty"`
	// ForceSendFields is a list of field names (e.g. "LeaveUntransformed") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "LeaveUntransformed") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GooglePrivacyDlpV2TransformationErrorHandling) MarshalJSON() ([]byte, error) {
	type NoMethod GooglePrivacyDlpV2TransformationErrorHandling
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GooglePrivacyDlpV2TransformationLocation: Specifies the location of a
// transformation.
type GooglePrivacyDlpV2TransformationLocation struct {
	// ContainerType: Information about the functionality of the container where
	// this finding occurred, if available.
	//
	// Possible values:
	//   "TRANSFORM_UNKNOWN_CONTAINER" - Unused.
	//   "TRANSFORM_BODY" - Body of a file.
	//   "TRANSFORM_METADATA" - Metadata for a file.
	//   "TRANSFORM_TABLE" - A table.
	ContainerType string `json:"containerType,omitempty"`
	// FindingId: For infotype transformations, link to the corresponding findings
	// ID so that location information does not need to be duplicated. Each
	// findings ID correlates to an entry in the findings output table, this table
	// only gets created when users specify to save findings (add the save findings
	// action to the request).
	FindingId string `json:"findingId,omitempty"`
	// RecordTransformation: For record transformations, provide a field and
	// container information.
	RecordTransformation *GooglePrivacyDlpV2RecordTransformation `json:"recordTransformation,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ContainerType") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ContainerType") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GooglePrivacyDlpV2TransformationLocation) MarshalJSON() ([]byte, error) {
	type NoMethod GooglePrivacyDlpV2TransformationLocation
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GooglePrivacyDlpV2TransformationOverview: Overview of the modifications that
// occurred.
type GooglePrivacyDlpV2TransformationOverview struct {
	// TransformationSummaries: Transformations applied to the dataset.
	TransformationSummaries []*GooglePrivacyDlpV2TransformationSummary `json:"transformationSummaries,omitempty"`
	// TransformedBytes: Total size in bytes that were transformed in some way.
	TransformedBytes int64 `json:"transformedBytes,omitempty,string"`
	// ForceSendFields is a list of field names (e.g. "TransformationSummaries") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "TransformationSummaries") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GooglePrivacyDlpV2TransformationOverview) MarshalJSON() ([]byte, error) {
	type NoMethod GooglePrivacyDlpV2TransformationOverview
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GooglePrivacyDlpV2TransformationResultStatus: The outcome of a
// transformation.
type GooglePrivacyDlpV2TransformationResultStatus struct {
	// Details: Detailed error codes and messages
	Details *GoogleRpcStatus `json:"details,omitempty"`
	// ResultStatusType: Transformation result status type, this will be either
	// SUCCESS, or it will be the reason for why the transformation was not
	// completely successful.
	//
	// Possible values:
	//   "STATE_TYPE_UNSPECIFIED" - Unused.
	//   "INVALID_TRANSFORM" - This will be set when a finding could not be
	// transformed (i.e. outside user set bucket range).
	//   "BIGQUERY_MAX_ROW_SIZE_EXCEEDED" - This will be set when a BigQuery
	// transformation was successful but could not be stored back in BigQuery
	// because the transformed row exceeds BigQuery's max row size.
	//   "METADATA_UNRETRIEVABLE" - This will be set when there is a finding in the
	// custom metadata of a file, but at the write time of the transformed file,
	// this key / value pair is unretrievable.
	//   "SUCCESS" - This will be set when the transformation and storing of it is
	// successful.
	ResultStatusType string `json:"resultStatusType,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Details") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Details") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GooglePrivacyDlpV2TransformationResultStatus) MarshalJSON() ([]byte, error) {
	type NoMethod GooglePrivacyDlpV2TransformationResultStatus
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GooglePrivacyDlpV2TransformationSummary: Summary of a single transformation.
// Only one of 'transformation', 'field_transformation', or 'record_suppress'
// will be set.
type GooglePrivacyDlpV2TransformationSummary struct {
	// Field: Set if the transformation was limited to a specific FieldId.
	Field *GooglePrivacyDlpV2FieldId `json:"field,omitempty"`
	// FieldTransformations: The field transformation that was applied. If multiple
	// field transformations are requested for a single field, this list will
	// contain all of them; otherwise, only one is supplied.
	FieldTransformations []*GooglePrivacyDlpV2FieldTransformation `json:"fieldTransformations,omitempty"`
	// InfoType: Set if the transformation was limited to a specific InfoType.
	InfoType *GooglePrivacyDlpV2InfoType `json:"infoType,omitempty"`
	// RecordSuppress: The specific suppression option these stats apply to.
	RecordSuppress *GooglePrivacyDlpV2RecordSuppression `json:"recordSuppress,omitempty"`
	// Results: Collection of all transformations that took place or had an error.
	Results []*GooglePrivacyDlpV2SummaryResult `json:"results,omitempty"`
	// Transformation: The specific transformation these stats apply to.
	Transformation *GooglePrivacyDlpV2PrimitiveTransformation `json:"transformation,omitempty"`
	// TransformedBytes: Total size in bytes that were transformed in some way.
	TransformedBytes int64 `json:"transformedBytes,omitempty,string"`
	// ForceSendFields is a list of field names (e.g. "Field") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Field") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GooglePrivacyDlpV2TransformationSummary) MarshalJSON() ([]byte, error) {
	type NoMethod GooglePrivacyDlpV2TransformationSummary
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GooglePrivacyDlpV2TransientCryptoKey: Use this to have a random data crypto
// key generated. It will be discarded after the request finishes.
type GooglePrivacyDlpV2TransientCryptoKey struct {
	// Name: Required. Name of the key. This is an arbitrary string used to
	// differentiate different keys. A unique key is generated per name: two
	// separate `TransientCryptoKey` protos share the same generated key if their
	// names are the same. When the data crypto key is generated, this name is not
	// used in any way (repeating the api call will result in a different key being
	// generated).
	Name string `json:"name,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Name") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Name") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GooglePrivacyDlpV2TransientCryptoKey) MarshalJSON() ([]byte, error) {
	type NoMethod GooglePrivacyDlpV2TransientCryptoKey
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GooglePrivacyDlpV2Trigger: What event needs to occur for a new job to be
// started.
type GooglePrivacyDlpV2Trigger struct {
	// Manual: For use with hybrid jobs. Jobs must be manually created and
	// finished.
	Manual *GooglePrivacyDlpV2Manual `json:"manual,omitempty"`
	// Schedule: Create a job on a repeating basis based on the elapse of time.
	Schedule *GooglePrivacyDlpV2Schedule `json:"schedule,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Manual") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Manual") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GooglePrivacyDlpV2Trigger) MarshalJSON() ([]byte, error) {
	type NoMethod GooglePrivacyDlpV2Trigger
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GooglePrivacyDlpV2UnwrappedCryptoKey: Using raw keys is prone to security
// risks due to accidentally leaking the key. Choose another type of key if
// possible.
type GooglePrivacyDlpV2UnwrappedCryptoKey struct {
	// Key: Required. A 128/192/256 bit key.
	Key string `json:"key,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Key") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Key") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GooglePrivacyDlpV2UnwrappedCryptoKey) MarshalJSON() ([]byte, error) {
	type NoMethod GooglePrivacyDlpV2UnwrappedCryptoKey
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GooglePrivacyDlpV2UpdateConnectionRequest: Request message for
// UpdateConnection.
type GooglePrivacyDlpV2UpdateConnectionRequest struct {
	// Connection: Required. The connection with new values for the relevant
	// fields.
	Connection *GooglePrivacyDlpV2Connection `json:"connection,omitempty"`
	// UpdateMask: Optional. Mask to control which fields get updated.
	UpdateMask string `json:"updateMask,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Connection") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Connection") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GooglePrivacyDlpV2UpdateConnectionRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GooglePrivacyDlpV2UpdateConnectionRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GooglePrivacyDlpV2UpdateDeidentifyTemplateRequest: Request message for
// UpdateDeidentifyTemplate.
type GooglePrivacyDlpV2UpdateDeidentifyTemplateRequest struct {
	// DeidentifyTemplate: New DeidentifyTemplate value.
	DeidentifyTemplate *GooglePrivacyDlpV2DeidentifyTemplate `json:"deidentifyTemplate,omitempty"`
	// UpdateMask: Mask to control which fields get updated.
	UpdateMask string `json:"updateMask,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DeidentifyTemplate") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DeidentifyTemplate") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GooglePrivacyDlpV2UpdateDeidentifyTemplateRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GooglePrivacyDlpV2UpdateDeidentifyTemplateRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GooglePrivacyDlpV2UpdateDiscoveryConfigRequest: Request message for
// UpdateDiscoveryConfig.
type GooglePrivacyDlpV2UpdateDiscoveryConfigRequest struct {
	// DiscoveryConfig: Required. New DiscoveryConfig value.
	DiscoveryConfig *GooglePrivacyDlpV2DiscoveryConfig `json:"discoveryConfig,omitempty"`
	// UpdateMask: Mask to control which fields get updated.
	UpdateMask string `json:"updateMask,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DiscoveryConfig") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DiscoveryConfig") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GooglePrivacyDlpV2UpdateDiscoveryConfigRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GooglePrivacyDlpV2UpdateDiscoveryConfigRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GooglePrivacyDlpV2UpdateInspectTemplateRequest: Request message for
// UpdateInspectTemplate.
type GooglePrivacyDlpV2UpdateInspectTemplateRequest struct {
	// InspectTemplate: New InspectTemplate value.
	InspectTemplate *GooglePrivacyDlpV2InspectTemplate `json:"inspectTemplate,omitempty"`
	// UpdateMask: Mask to control which fields get updated.
	UpdateMask string `json:"updateMask,omitempty"`
	// ForceSendFields is a list of field names (e.g. "InspectTemplate") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "InspectTemplate") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GooglePrivacyDlpV2UpdateInspectTemplateRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GooglePrivacyDlpV2UpdateInspectTemplateRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GooglePrivacyDlpV2UpdateJobTriggerRequest: Request message for
// UpdateJobTrigger.
type GooglePrivacyDlpV2UpdateJobTriggerRequest struct {
	// JobTrigger: New JobTrigger value.
	JobTrigger *GooglePrivacyDlpV2JobTrigger `json:"jobTrigger,omitempty"`
	// UpdateMask: Mask to control which fields get updated.
	UpdateMask string `json:"updateMask,omitempty"`
	// ForceSendFields is a list of field names (e.g. "JobTrigger") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "JobTrigger") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GooglePrivacyDlpV2UpdateJobTriggerRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GooglePrivacyDlpV2UpdateJobTriggerRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GooglePrivacyDlpV2UpdateStoredInfoTypeRequest: Request message for
// UpdateStoredInfoType.
type GooglePrivacyDlpV2UpdateStoredInfoTypeRequest struct {
	// Config: Updated configuration for the storedInfoType. If not provided, a new
	// version of the storedInfoType will be created with the existing
	// configuration.
	Config *GooglePrivacyDlpV2StoredInfoTypeConfig `json:"config,omitempty"`
	// UpdateMask: Mask to control which fields get updated.
	UpdateMask string `json:"updateMask,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Config") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Config") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GooglePrivacyDlpV2UpdateStoredInfoTypeRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GooglePrivacyDlpV2UpdateStoredInfoTypeRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GooglePrivacyDlpV2Value: Set of primitive values supported by the system.
// Note that for the purposes of inspection or transformation, the number of
// bytes considered to comprise a 'Value' is based on its representation as a
// UTF-8 encoded string. For example, if 'integer_value' is set to 123456789,
// the number of bytes would be counted as 9, even though an int64 only holds
// up to 8 bytes of data.
type GooglePrivacyDlpV2Value struct {
	// BooleanValue: boolean
	BooleanValue bool `json:"booleanValue,omitempty"`
	// DateValue: date
	DateValue *GoogleTypeDate `json:"dateValue,omitempty"`
	// DayOfWeekValue: day of week
	//
	// Possible values:
	//   "DAY_OF_WEEK_UNSPECIFIED" - The day of the week is unspecified.
	//   "MONDAY" - Monday
	//   "TUESDAY" - Tuesday
	//   "WEDNESDAY" - Wednesday
	//   "THURSDAY" - Thursday
	//   "FRIDAY" - Friday
	//   "SATURDAY" - Saturday
	//   "SUNDAY" - Sunday
	DayOfWeekValue string `json:"dayOfWeekValue,omitempty"`
	// FloatValue: float
	FloatValue float64 `json:"floatValue,omitempty"`
	// IntegerValue: integer
	IntegerValue int64 `json:"integerValue,omitempty,string"`
	// StringValue: string
	StringValue string `json:"stringValue,omitempty"`
	// TimeValue: time of day
	TimeValue *GoogleTypeTimeOfDay `json:"timeValue,omitempty"`
	// TimestampValue: timestamp
	TimestampValue string `json:"timestampValue,omitempty"`
	// ForceSendFields is a list of field names (e.g. "BooleanValue") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "BooleanValue") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GooglePrivacyDlpV2Value) MarshalJSON() ([]byte, error) {
	type NoMethod GooglePrivacyDlpV2Value
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *GooglePrivacyDlpV2Value) UnmarshalJSON(data []byte) error {
	type NoMethod GooglePrivacyDlpV2Value
	var s1 struct {
		FloatValue gensupport.JSONFloat64 `json:"floatValue"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.FloatValue = float64(s1.FloatValue)
	return nil
}

// GooglePrivacyDlpV2ValueFrequency: A value of a field, including its
// frequency.
type GooglePrivacyDlpV2ValueFrequency struct {
	// Count: How many times the value is contained in the field.
	Count int64 `json:"count,omitempty,string"`
	// Value: A value contained in the field in question.
	Value *GooglePrivacyDlpV2Value `json:"value,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Count") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Count") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GooglePrivacyDlpV2ValueFrequency) MarshalJSON() ([]byte, error) {
	type NoMethod GooglePrivacyDlpV2ValueFrequency
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GooglePrivacyDlpV2VersionDescription: Details about each available version
// for an infotype.
type GooglePrivacyDlpV2VersionDescription struct {
	// Description: Description of the version.
	Description string `json:"description,omitempty"`
	// Version: Name of the version
	Version string `json:"version,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Description") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Description") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GooglePrivacyDlpV2VersionDescription) MarshalJSON() ([]byte, error) {
	type NoMethod GooglePrivacyDlpV2VersionDescription
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GooglePrivacyDlpV2VertexDatasetCollection: Match dataset resources using
// regex filters.
type GooglePrivacyDlpV2VertexDatasetCollection struct {
	// VertexDatasetRegexes: The regex used to filter dataset resources.
	VertexDatasetRegexes *GooglePrivacyDlpV2VertexDatasetRegexes `json:"vertexDatasetRegexes,omitempty"`
	// ForceSendFields is a list of field names (e.g. "VertexDatasetRegexes") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "VertexDatasetRegexes") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GooglePrivacyDlpV2VertexDatasetCollection) MarshalJSON() ([]byte, error) {
	type NoMethod GooglePrivacyDlpV2VertexDatasetCollection
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GooglePrivacyDlpV2VertexDatasetDiscoveryTarget: Target used to match against
// for discovery with Vertex AI datasets.
type GooglePrivacyDlpV2VertexDatasetDiscoveryTarget struct {
	// Conditions: In addition to matching the filter, these conditions must be
	// true before a profile is generated.
	Conditions *GooglePrivacyDlpV2DiscoveryVertexDatasetConditions `json:"conditions,omitempty"`
	// Disabled: Disable profiling for datasets that match this filter.
	Disabled *GooglePrivacyDlpV2Disabled `json:"disabled,omitempty"`
	// Filter: Required. The datasets the discovery cadence applies to. The first
	// target with a matching filter will be the one to apply to a dataset.
	Filter *GooglePrivacyDlpV2DiscoveryVertexDatasetFilter `json:"filter,omitempty"`
	// GenerationCadence: How often and when to update profiles. New datasets that
	// match both the filter and conditions are scanned as quickly as possible
	// depending on system capacity.
	GenerationCadence *GooglePrivacyDlpV2DiscoveryVertexDatasetGenerationCadence `json:"generationCadence,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Conditions") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Conditions") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GooglePrivacyDlpV2VertexDatasetDiscoveryTarget) MarshalJSON() ([]byte, error) {
	type NoMethod GooglePrivacyDlpV2VertexDatasetDiscoveryTarget
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GooglePrivacyDlpV2VertexDatasetRegex: A pattern to match against one or more
// dataset resources.
type GooglePrivacyDlpV2VertexDatasetRegex struct {
	// ProjectIdRegex: For organizations, if unset, will match all projects. Has no
	// effect for configurations created within a project.
	ProjectIdRegex string `json:"projectIdRegex,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ProjectIdRegex") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ProjectIdRegex") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GooglePrivacyDlpV2VertexDatasetRegex) MarshalJSON() ([]byte, error) {
	type NoMethod GooglePrivacyDlpV2VertexDatasetRegex
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GooglePrivacyDlpV2VertexDatasetRegexes: A collection of regular expressions
// to determine what datasets to match against.
type GooglePrivacyDlpV2VertexDatasetRegexes struct {
	// Patterns: Required. The group of regular expression patterns to match
	// against one or more datasets. Maximum of 100 entries. The sum of the lengths
	// of all regular expressions can't exceed 10 KiB.
	Patterns []*GooglePrivacyDlpV2VertexDatasetRegex `json:"patterns,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Patterns") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Patterns") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GooglePrivacyDlpV2VertexDatasetRegexes) MarshalJSON() ([]byte, error) {
	type NoMethod GooglePrivacyDlpV2VertexDatasetRegexes
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GooglePrivacyDlpV2VertexDatasetResourceReference: Identifies a single Vertex
// AI resource. Only datasets are supported.
type GooglePrivacyDlpV2VertexDatasetResourceReference struct {
	// DatasetResourceName: Required. The name of the Vertex AI resource. If set
	// within a project-level configuration, the specified resource must be within
	// the project. Examples: *
	// `projects/{project}/locations/{location}/datasets/{dataset}`
	DatasetResourceName string `json:"datasetResourceName,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DatasetResourceName") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DatasetResourceName") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GooglePrivacyDlpV2VertexDatasetResourceReference) MarshalJSON() ([]byte, error) {
	type NoMethod GooglePrivacyDlpV2VertexDatasetResourceReference
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GooglePrivacyDlpV2WordList: Message defining a list of words or phrases to
// search for in the data.
type GooglePrivacyDlpV2WordList struct {
	// Words: Words or phrases defining the dictionary. The dictionary must contain
	// at least one phrase and every phrase must contain at least 2 characters that
	// are letters or digits. [required]
	Words []string `json:"words,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Words") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Words") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GooglePrivacyDlpV2WordList) MarshalJSON() ([]byte, error) {
	type NoMethod GooglePrivacyDlpV2WordList
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleProtobufEmpty: A generic empty message that you can re-use to avoid
// defining duplicated empty messages in your APIs. A typical example is to use
// it as the request or the response type of an API method. For instance:
// service Foo { rpc Bar(google.protobuf.Empty) returns
// (google.protobuf.Empty); }
type GoogleProtobufEmpty struct {
	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
}

// GoogleRpcStatus: The `Status` type defines a logical error model that is
// suitable for different programming environments, including REST APIs and RPC
// APIs. It is used by gRPC (https://github.com/grpc). Each `Status` message
// contains three pieces of data: error code, error message, and error details.
// You can find out more about this error model and how to work with it in the
// API Design Guide (https://cloud.google.com/apis/design/errors).
type GoogleRpcStatus struct {
	// Code: The status code, which should be an enum value of google.rpc.Code.
	Code int64 `json:"code,omitempty"`
	// Details: A list of messages that carry the error details. There is a common
	// set of message types for APIs to use.
	Details []googleapi.RawMessage `json:"details,omitempty"`
	// Message: A developer-facing error message, which should be in English. Any
	// user-facing error message should be localized and sent in the
	// google.rpc.Status.details field, or localized by the client.
	Message string `json:"message,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Code") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Code") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleRpcStatus) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleRpcStatus
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleTypeDate: Represents a whole or partial calendar date, such as a
// birthday. The time of day and time zone are either specified elsewhere or
// are insignificant. The date is relative to the Gregorian Calendar. This can
// represent one of the following: * A full date, with non-zero year, month,
// and day values. * A month and day, with a zero year (for example, an
// anniversary). * A year on its own, with a zero month and a zero day. * A
// year and month, with a zero day (for example, a credit card expiration
// date). Related types: * google.type.TimeOfDay * google.type.DateTime *
// google.protobuf.Timestamp
type GoogleTypeDate struct {
	// Day: Day of a month. Must be from 1 to 31 and valid for the year and month,
	// or 0 to specify a year by itself or a year and month where the day isn't
	// significant.
	Day int64 `json:"day,omitempty"`
	// Month: Month of a year. Must be from 1 to 12, or 0 to specify a year without
	// a month and day.
	Month int64 `json:"month,omitempty"`
	// Year: Year of the date. Must be from 1 to 9999, or 0 to specify a date
	// without a year.
	Year int64 `json:"year,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Day") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Day") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleTypeDate) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleTypeDate
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleTypeTimeOfDay: Represents a time of day. The date and time zone are
// either not significant or are specified elsewhere. An API may choose to
// allow leap seconds. Related types are google.type.Date and
// `google.protobuf.Timestamp`.
type GoogleTypeTimeOfDay struct {
	// Hours: Hours of a day in 24 hour format. Must be greater than or equal to 0
	// and typically must be less than or equal to 23. An API may choose to allow
	// the value "24:00:00" for scenarios like business closing time.
	Hours int64 `json:"hours,omitempty"`
	// Minutes: Minutes of an hour. Must be greater than or equal to 0 and less
	// than or equal to 59.
	Minutes int64 `json:"minutes,omitempty"`
	// Nanos: Fractions of seconds, in nanoseconds. Must be greater than or equal
	// to 0 and less than or equal to 999,999,999.
	Nanos int64 `json:"nanos,omitempty"`
	// Seconds: Seconds of a minute. Must be greater than or equal to 0 and
	// typically must be less than or equal to 59. An API may allow the value 60 if
	// it allows leap-seconds.
	Seconds int64 `json:"seconds,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Hours") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Hours") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleTypeTimeOfDay) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleTypeTimeOfDay
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// Proto2BridgeMessageSet: This is proto2's version of MessageSet. DEPRECATED:
// DO NOT USE FOR NEW FIELDS. If you are using editions or proto2, please make
// your own extendable messages for your use case. If you are using proto3,
// please use `Any` instead. MessageSet was the implementation of extensions
// for proto1. When proto2 was introduced, extensions were implemented as a
// first-class feature. This schema for MessageSet was meant to be a "bridge"
// solution to migrate MessageSet-bearing messages from proto1 to proto2. This
// schema has been open-sourced only to facilitate the migration of Google
// products with MessageSet-bearing messages to open-source environments.
type Proto2BridgeMessageSet struct {
}

// UtilStatusProto: Wire-format for a Status object
type UtilStatusProto struct {
	// CanonicalCode: copybara:strip_begin(b/383363683)
	// copybara:strip_end_and_replace optional int32 canonical_code = 6;
	CanonicalCode int64 `json:"canonicalCode,omitempty"`
	// Code: Numeric code drawn from the space specified below. Often, this is the
	// canonical error space, and code is drawn from google3/util/task/codes.proto
	// copybara:strip_begin(b/383363683) copybara:strip_end_and_replace optional
	// int32 code = 1;
	Code int64 `json:"code,omitempty"`
	// Message: Detail message copybara:strip_begin(b/383363683)
	// copybara:strip_end_and_replace optional string message = 3;
	Message string `json:"message,omitempty"`
	// MessageSet: message_set associates an arbitrary proto message with the
	// status. copybara:strip_begin(b/383363683) copybara:strip_end_and_replace
	// optional proto2.bridge.MessageSet message_set = 5;
	MessageSet *Proto2BridgeMessageSet `json:"messageSet,omitempty"`
	// Space: copybara:strip_begin(b/383363683) Space to which this status belongs
	// copybara:strip_end_and_replace optional string space = 2; // Space to which
	// this status belongs
	Space string `json:"space,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CanonicalCode") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CanonicalCode") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s UtilStatusProto) MarshalJSON() ([]byte, error) {
	type NoMethod UtilStatusProto
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type InfoTypesListCall struct {
	s            *Service
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Returns a list of the sensitive information types that the DLP API
// supports. See
// https://cloud.google.com/sensitive-data-protection/docs/infotypes-reference
// to learn more.
func (r *InfoTypesService) List() *InfoTypesListCall {
	c := &InfoTypesListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	return c
}

// Filter sets the optional parameter "filter": filter to only return infoTypes
// supported by certain parts of the API. Defaults to supported_by=INSPECT.
func (c *InfoTypesListCall) Filter(filter string) *InfoTypesListCall {
	c.urlParams_.Set("filter", filter)
	return c
}

// LanguageCode sets the optional parameter "languageCode": BCP-47 language
// code for localized infoType friendly names. If omitted, or if localized
// strings are not available, en-US strings will be returned.
func (c *InfoTypesListCall) LanguageCode(languageCode string) *InfoTypesListCall {
	c.urlParams_.Set("languageCode", languageCode)
	return c
}

// LocationId sets the optional parameter "locationId": Deprecated. This field
// has no effect.
func (c *InfoTypesListCall) LocationId(locationId string) *InfoTypesListCall {
	c.urlParams_.Set("locationId", locationId)
	return c
}

// Parent sets the optional parameter "parent": The parent resource name. The
// format of this value is as follows: `locations/{location_id}`
func (c *InfoTypesListCall) Parent(parent string) *InfoTypesListCall {
	c.urlParams_.Set("parent", parent)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *InfoTypesListCall) Fields(s ...googleapi.Field) *InfoTypesListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *InfoTypesListCall) IfNoneMatch(entityTag string) *InfoTypesListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *InfoTypesListCall) Context(ctx context.Context) *InfoTypesListCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *InfoTypesListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *InfoTypesListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v2/infoTypes")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "dlp.infoTypes.list", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "dlp.infoTypes.list" call.
// Any non-2xx status code is an error. Response headers are in either
// *GooglePrivacyDlpV2ListInfoTypesResponse.ServerResponse.Header or (if a
// response was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *InfoTypesListCall) Do(opts ...googleapi.CallOption) (*GooglePrivacyDlpV2ListInfoTypesResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GooglePrivacyDlpV2ListInfoTypesResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "dlp.infoTypes.list", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type LocationsInfoTypesListCall struct {
	s            *Service
	parent       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Returns a list of the sensitive information types that the DLP API
// supports. See
// https://cloud.google.com/sensitive-data-protection/docs/infotypes-reference
// to learn more.
//
//   - parent: The parent resource name. The format of this value is as follows:
//     `locations/{location_id}`.
func (r *LocationsInfoTypesService) List(parent string) *LocationsInfoTypesListCall {
	c := &LocationsInfoTypesListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	return c
}

// Filter sets the optional parameter "filter": filter to only return infoTypes
// supported by certain parts of the API. Defaults to supported_by=INSPECT.
func (c *LocationsInfoTypesListCall) Filter(filter string) *LocationsInfoTypesListCall {
	c.urlParams_.Set("filter", filter)
	return c
}

// LanguageCode sets the optional parameter "languageCode": BCP-47 language
// code for localized infoType friendly names. If omitted, or if localized
// strings are not available, en-US strings will be returned.
func (c *LocationsInfoTypesListCall) LanguageCode(languageCode string) *LocationsInfoTypesListCall {
	c.urlParams_.Set("languageCode", languageCode)
	return c
}

// LocationId sets the optional parameter "locationId": Deprecated. This field
// has no effect.
func (c *LocationsInfoTypesListCall) LocationId(locationId string) *LocationsInfoTypesListCall {
	c.urlParams_.Set("locationId", locationId)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *LocationsInfoTypesListCall) Fields(s ...googleapi.Field) *LocationsInfoTypesListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *LocationsInfoTypesListCall) IfNoneMatch(entityTag string) *LocationsInfoTypesListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *LocationsInfoTypesListCall) Context(ctx context.Context) *LocationsInfoTypesListCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *LocationsInfoTypesListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *LocationsInfoTypesListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v2/{+parent}/infoTypes")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "dlp.locations.infoTypes.list", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "dlp.locations.infoTypes.list" call.
// Any non-2xx status code is an error. Response headers are in either
// *GooglePrivacyDlpV2ListInfoTypesResponse.ServerResponse.Header or (if a
// response was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *LocationsInfoTypesListCall) Do(opts ...googleapi.CallOption) (*GooglePrivacyDlpV2ListInfoTypesResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GooglePrivacyDlpV2ListInfoTypesResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "dlp.locations.infoTypes.list", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type OrganizationsDeidentifyTemplatesCreateCall struct {
	s                                                 *Service
	parentid                                          string
	googleprivacydlpv2createdeidentifytemplaterequest *GooglePrivacyDlpV2CreateDeidentifyTemplateRequest
	urlParams_                                        gensupport.URLParams
	ctx_                                              context.Context
	header_                                           http.Header
}

// Create: Creates a DeidentifyTemplate for reusing frequently used
// configuration for de-identifying content, images, and storage. See
// https://cloud.google.com/sensitive-data-protection/docs/creating-templates-deid
// to learn more.
//
//   - parent: Parent resource name. The format of this value varies depending on
//     the scope of the request (project or organization) and whether you have
//     specified a processing location
//     (https://cloud.google.com/sensitive-data-protection/docs/specifying-location):
//   - Projects scope, location specified:
//     `projects/{project_id}/locations/{location_id}` + Projects scope, no
//     location specified (defaults to global): `projects/{project_id}` +
//     Organizations scope, location specified:
//     `organizations/{org_id}/locations/{location_id}` + Organizations scope, no
//     location specified (defaults to global): `organizations/{org_id}` The
//     following example `parent` string specifies a parent project with the
//     identifier `example-project`, and specifies the `europe-west3` location
//     for processing data:
//     parent=projects/example-project/locations/europe-west3.
func (r *OrganizationsDeidentifyTemplatesService) Create(parentid string, googleprivacydlpv2createdeidentifytemplaterequest *GooglePrivacyDlpV2CreateDeidentifyTemplateRequest) *OrganizationsDeidentifyTemplatesCreateCall {
	c := &OrganizationsDeidentifyTemplatesCreateCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parentid = parentid
	c.googleprivacydlpv2createdeidentifytemplaterequest = googleprivacydlpv2createdeidentifytemplaterequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *OrganizationsDeidentifyTemplatesCreateCall) Fields(s ...googleapi.Field) *OrganizationsDeidentifyTemplatesCreateCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *OrganizationsDeidentifyTemplatesCreateCall) Context(ctx context.Context) *OrganizationsDeidentifyTemplatesCreateCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *OrganizationsDeidentifyTemplatesCreateCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *OrganizationsDeidentifyTemplatesCreateCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.googleprivacydlpv2createdeidentifytemplaterequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v2/{+parent}/deidentifyTemplates")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parentid,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "dlp.organizations.deidentifyTemplates.create", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "dlp.organizations.deidentifyTemplates.create" call.
// Any non-2xx status code is an error. Response headers are in either
// *GooglePrivacyDlpV2DeidentifyTemplate.ServerResponse.Header or (if a
// response was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *OrganizationsDeidentifyTemplatesCreateCall) Do(opts ...googleapi.CallOption) (*GooglePrivacyDlpV2DeidentifyTemplate, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GooglePrivacyDlpV2DeidentifyTemplate{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "dlp.organizations.deidentifyTemplates.create", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type OrganizationsDeidentifyTemplatesDeleteCall struct {
	s          *Service
	name       string
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Delete: Deletes a DeidentifyTemplate. See
// https://cloud.google.com/sensitive-data-protection/docs/creating-templates-deid
// to learn more.
//
//   - name: Resource name of the organization and deidentify template to be
//     deleted, for example
//     `organizations/433245324/deidentifyTemplates/432452342` or
//     projects/project-id/deidentifyTemplates/432452342.
func (r *OrganizationsDeidentifyTemplatesService) Delete(name string) *OrganizationsDeidentifyTemplatesDeleteCall {
	c := &OrganizationsDeidentifyTemplatesDeleteCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *OrganizationsDeidentifyTemplatesDeleteCall) Fields(s ...googleapi.Field) *OrganizationsDeidentifyTemplatesDeleteCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *OrganizationsDeidentifyTemplatesDeleteCall) Context(ctx context.Context) *OrganizationsDeidentifyTemplatesDeleteCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *OrganizationsDeidentifyTemplatesDeleteCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *OrganizationsDeidentifyTemplatesDeleteCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v2/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("DELETE", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "dlp.organizations.deidentifyTemplates.delete", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "dlp.organizations.deidentifyTemplates.delete" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleProtobufEmpty.ServerResponse.Header or (if a response was returned at
// all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified was
// returned.
func (c *OrganizationsDeidentifyTemplatesDeleteCall) Do(opts ...googleapi.CallOption) (*GoogleProtobufEmpty, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleProtobufEmpty{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "dlp.organizations.deidentifyTemplates.delete", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type OrganizationsDeidentifyTemplatesGetCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Gets a DeidentifyTemplate. See
// https://cloud.google.com/sensitive-data-protection/docs/creating-templates-deid
// to learn more.
//
//   - name: Resource name of the organization and deidentify template to be
//     read, for example `organizations/433245324/deidentifyTemplates/432452342`
//     or projects/project-id/deidentifyTemplates/432452342.
func (r *OrganizationsDeidentifyTemplatesService) Get(name string) *OrganizationsDeidentifyTemplatesGetCall {
	c := &OrganizationsDeidentifyTemplatesGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *OrganizationsDeidentifyTemplatesGetCall) Fields(s ...googleapi.Field) *OrganizationsDeidentifyTemplatesGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *OrganizationsDeidentifyTemplatesGetCall) IfNoneMatch(entityTag string) *OrganizationsDeidentifyTemplatesGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *OrganizationsDeidentifyTemplatesGetCall) Context(ctx context.Context) *OrganizationsDeidentifyTemplatesGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *OrganizationsDeidentifyTemplatesGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *OrganizationsDeidentifyTemplatesGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v2/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "dlp.organizations.deidentifyTemplates.get", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "dlp.organizations.deidentifyTemplates.get" call.
// Any non-2xx status code is an error. Response headers are in either
// *GooglePrivacyDlpV2DeidentifyTemplate.ServerResponse.Header or (if a
// response was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *OrganizationsDeidentifyTemplatesGetCall) Do(opts ...googleapi.CallOption) (*GooglePrivacyDlpV2DeidentifyTemplate, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GooglePrivacyDlpV2DeidentifyTemplate{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "dlp.organizations.deidentifyTemplates.get", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type OrganizationsDeidentifyTemplatesListCall struct {
	s            *Service
	parentid     string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Lists DeidentifyTemplates. See
// https://cloud.google.com/sensitive-data-protection/docs/creating-templates-deid
// to learn more.
//
//   - parent: Parent resource name. The format of this value varies depending on
//     the scope of the request (project or organization) and whether you have
//     specified a processing location
//     (https://cloud.google.com/sensitive-data-protection/docs/specifying-location):
//   - Projects scope, location specified:
//     `projects/{project_id}/locations/{location_id}` + Projects scope, no
//     location specified (defaults to global): `projects/{project_id}` +
//     Organizations scope, location specified:
//     `organizations/{org_id}/locations/{location_id}` + Organizations scope, no
//     location specified (defaults to global): `organizations/{org_id}` The
//     following example `parent` string specifies a parent project with the
//     identifier `example-project`, and specifies the `europe-west3` location
//     for processing data:
//     parent=projects/example-project/locations/europe-west3.
func (r *OrganizationsDeidentifyTemplatesService) List(parentid string) *OrganizationsDeidentifyTemplatesListCall {
	c := &OrganizationsDeidentifyTemplatesListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parentid = parentid
	return c
}

// LocationId sets the optional parameter "locationId": Deprecated. This field
// has no effect.
func (c *OrganizationsDeidentifyTemplatesListCall) LocationId(locationId string) *OrganizationsDeidentifyTemplatesListCall {
	c.urlParams_.Set("locationId", locationId)
	return c
}

// OrderBy sets the optional parameter "orderBy": Comma-separated list of
// fields to order by, followed by `asc` or `desc` postfix. This list is case
// insensitive. The default sorting order is ascending. Redundant space
// characters are insignificant. Example: `name asc,update_time, create_time
// desc` Supported fields are: - `create_time`: corresponds to the time the
// template was created. - `update_time`: corresponds to the time the template
// was last updated. - `name`: corresponds to the template's name. -
// `display_name`: corresponds to the template's display name.
func (c *OrganizationsDeidentifyTemplatesListCall) OrderBy(orderBy string) *OrganizationsDeidentifyTemplatesListCall {
	c.urlParams_.Set("orderBy", orderBy)
	return c
}

// PageSize sets the optional parameter "pageSize": Size of the page. This
// value can be limited by the server. If zero server returns a page of max
// size 100.
func (c *OrganizationsDeidentifyTemplatesListCall) PageSize(pageSize int64) *OrganizationsDeidentifyTemplatesListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": Page token to continue
// retrieval. Comes from the previous call to `ListDeidentifyTemplates`.
func (c *OrganizationsDeidentifyTemplatesListCall) PageToken(pageToken string) *OrganizationsDeidentifyTemplatesListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *OrganizationsDeidentifyTemplatesListCall) Fields(s ...googleapi.Field) *OrganizationsDeidentifyTemplatesListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *OrganizationsDeidentifyTemplatesListCall) IfNoneMatch(entityTag string) *OrganizationsDeidentifyTemplatesListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *OrganizationsDeidentifyTemplatesListCall) Context(ctx context.Context) *OrganizationsDeidentifyTemplatesListCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *OrganizationsDeidentifyTemplatesListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *OrganizationsDeidentifyTemplatesListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v2/{+parent}/deidentifyTemplates")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parentid,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "dlp.organizations.deidentifyTemplates.list", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "dlp.organizations.deidentifyTemplates.list" call.
// Any non-2xx status code is an error. Response headers are in either
// *GooglePrivacyDlpV2ListDeidentifyTemplatesResponse.ServerResponse.Header or
// (if a response was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *OrganizationsDeidentifyTemplatesListCall) Do(opts ...googleapi.CallOption) (*GooglePrivacyDlpV2ListDeidentifyTemplatesResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GooglePrivacyDlpV2ListDeidentifyTemplatesResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "dlp.organizations.deidentifyTemplates.list", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *OrganizationsDeidentifyTemplatesListCall) Pages(ctx context.Context, f func(*GooglePrivacyDlpV2ListDeidentifyTemplatesResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken"))
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

type OrganizationsDeidentifyTemplatesPatchCall struct {
	s                                                 *Service
	name                                              string
	googleprivacydlpv2updatedeidentifytemplaterequest *GooglePrivacyDlpV2UpdateDeidentifyTemplateRequest
	urlParams_                                        gensupport.URLParams
	ctx_                                              context.Context
	header_                                           http.Header
}

// Patch: Updates the DeidentifyTemplate. See
// https://cloud.google.com/sensitive-data-protection/docs/creating-templates-deid
// to learn more.
//
//   - name: Resource name of organization and deidentify template to be updated,
//     for example `organizations/433245324/deidentifyTemplates/432452342` or
//     projects/project-id/deidentifyTemplates/432452342.
func (r *OrganizationsDeidentifyTemplatesService) Patch(name string, googleprivacydlpv2updatedeidentifytemplaterequest *GooglePrivacyDlpV2UpdateDeidentifyTemplateRequest) *OrganizationsDeidentifyTemplatesPatchCall {
	c := &OrganizationsDeidentifyTemplatesPatchCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.googleprivacydlpv2updatedeidentifytemplaterequest = googleprivacydlpv2updatedeidentifytemplaterequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *OrganizationsDeidentifyTemplatesPatchCall) Fields(s ...googleapi.Field) *OrganizationsDeidentifyTemplatesPatchCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *OrganizationsDeidentifyTemplatesPatchCall) Context(ctx context.Context) *OrganizationsDeidentifyTemplatesPatchCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *OrganizationsDeidentifyTemplatesPatchCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *OrganizationsDeidentifyTemplatesPatchCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.googleprivacydlpv2updatedeidentifytemplaterequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v2/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("PATCH", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "dlp.organizations.deidentifyTemplates.patch", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "dlp.organizations.deidentifyTemplates.patch" call.
// Any non-2xx status code is an error. Response headers are in either
// *GooglePrivacyDlpV2DeidentifyTemplate.ServerResponse.Header or (if a
// response was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *OrganizationsDeidentifyTemplatesPatchCall) Do(opts ...googleapi.CallOption) (*GooglePrivacyDlpV2DeidentifyTemplate, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GooglePrivacyDlpV2DeidentifyTemplate{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "dlp.organizations.deidentifyTemplates.patch", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type OrganizationsInspectTemplatesCreateCall struct {
	s                                              *Service
	parentid                                       string
	googleprivacydlpv2createinspecttemplaterequest *GooglePrivacyDlpV2CreateInspectTemplateRequest
	urlParams_                                     gensupport.URLParams
	ctx_                                           context.Context
	header_                                        http.Header
}

// Create: Creates an InspectTemplate for reusing frequently used configuration
// for inspecting content, images, and storage. See
// https://cloud.google.com/sensitive-data-protection/docs/creating-templates
// to learn more.
//
//   - parent: Parent resource name. The format of this value varies depending on
//     the scope of the request (project or organization) and whether you have
//     specified a processing location
//     (https://cloud.google.com/sensitive-data-protection/docs/specifying-location):
//   - Projects scope, location specified:
//     `projects/{project_id}/locations/{location_id}` + Projects scope, no
//     location specified (defaults to global): `projects/{project_id}` +
//     Organizations scope, location specified:
//     `organizations/{org_id}/locations/{location_id}` + Organizations scope, no
//     location specified (defaults to global): `organizations/{org_id}` The
//     following example `parent` string specifies a parent project with the
//     identifier `example-project`, and specifies the `europe-west3` location
//     for processing data:
//     parent=projects/example-project/locations/europe-west3.
func (r *OrganizationsInspectTemplatesService) Create(parentid string, googleprivacydlpv2createinspecttemplaterequest *GooglePrivacyDlpV2CreateInspectTemplateRequest) *OrganizationsInspectTemplatesCreateCall {
	c := &OrganizationsInspectTemplatesCreateCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parentid = parentid
	c.googleprivacydlpv2createinspecttemplaterequest = googleprivacydlpv2createinspecttemplaterequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *OrganizationsInspectTemplatesCreateCall) Fields(s ...googleapi.Field) *OrganizationsInspectTemplatesCreateCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *OrganizationsInspectTemplatesCreateCall) Context(ctx context.Context) *OrganizationsInspectTemplatesCreateCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *OrganizationsInspectTemplatesCreateCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *OrganizationsInspectTemplatesCreateCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.googleprivacydlpv2createinspecttemplaterequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v2/{+parent}/inspectTemplates")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parentid,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "dlp.organizations.inspectTemplates.create", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "dlp.organizations.inspectTemplates.create" call.
// Any non-2xx status code is an error. Response headers are in either
// *GooglePrivacyDlpV2InspectTemplate.ServerResponse.Header or (if a response
// was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *OrganizationsInspectTemplatesCreateCall) Do(opts ...googleapi.CallOption) (*GooglePrivacyDlpV2InspectTemplate, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GooglePrivacyDlpV2InspectTemplate{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "dlp.organizations.inspectTemplates.create", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type OrganizationsInspectTemplatesDeleteCall struct {
	s          *Service
	name       string
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Delete: Deletes an InspectTemplate. See
// https://cloud.google.com/sensitive-data-protection/docs/creating-templates
// to learn more.
//
//   - name: Resource name of the organization and inspectTemplate to be deleted,
//     for example `organizations/433245324/inspectTemplates/432452342` or
//     projects/project-id/inspectTemplates/432452342.
func (r *OrganizationsInspectTemplatesService) Delete(name string) *OrganizationsInspectTemplatesDeleteCall {
	c := &OrganizationsInspectTemplatesDeleteCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *OrganizationsInspectTemplatesDeleteCall) Fields(s ...googleapi.Field) *OrganizationsInspectTemplatesDeleteCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *OrganizationsInspectTemplatesDeleteCall) Context(ctx context.Context) *OrganizationsInspectTemplatesDeleteCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *OrganizationsInspectTemplatesDeleteCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *OrganizationsInspectTemplatesDeleteCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v2/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("DELETE", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "dlp.organizations.inspectTemplates.delete", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "dlp.organizations.inspectTemplates.delete" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleProtobufEmpty.ServerResponse.Header or (if a response was returned at
// all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified was
// returned.
func (c *OrganizationsInspectTemplatesDeleteCall) Do(opts ...googleapi.CallOption) (*GoogleProtobufEmpty, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleProtobufEmpty{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "dlp.organizations.inspectTemplates.delete", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type OrganizationsInspectTemplatesGetCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Gets an InspectTemplate. See
// https://cloud.google.com/sensitive-data-protection/docs/creating-templates
// to learn more.
//
//   - name: Resource name of the organization and inspectTemplate to be read,
//     for example `organizations/433245324/inspectTemplates/432452342` or
//     projects/project-id/inspectTemplates/432452342.
func (r *OrganizationsInspectTemplatesService) Get(name string) *OrganizationsInspectTemplatesGetCall {
	c := &OrganizationsInspectTemplatesGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *OrganizationsInspectTemplatesGetCall) Fields(s ...googleapi.Field) *OrganizationsInspectTemplatesGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *OrganizationsInspectTemplatesGetCall) IfNoneMatch(entityTag string) *OrganizationsInspectTemplatesGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *OrganizationsInspectTemplatesGetCall) Context(ctx context.Context) *OrganizationsInspectTemplatesGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *OrganizationsInspectTemplatesGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *OrganizationsInspectTemplatesGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v2/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "dlp.organizations.inspectTemplates.get", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "dlp.organizations.inspectTemplates.get" call.
// Any non-2xx status code is an error. Response headers are in either
// *GooglePrivacyDlpV2InspectTemplate.ServerResponse.Header or (if a response
// was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *OrganizationsInspectTemplatesGetCall) Do(opts ...googleapi.CallOption) (*GooglePrivacyDlpV2InspectTemplate, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GooglePrivacyDlpV2InspectTemplate{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "dlp.organizations.inspectTemplates.get", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type OrganizationsInspectTemplatesListCall struct {
	s            *Service
	parentid     string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Lists InspectTemplates. See
// https://cloud.google.com/sensitive-data-protection/docs/creating-templates
// to learn more.
//
//   - parent: Parent resource name. The format of this value varies depending on
//     the scope of the request (project or organization) and whether you have
//     specified a processing location
//     (https://cloud.google.com/sensitive-data-protection/docs/specifying-location):
//   - Projects scope, location specified:
//     `projects/{project_id}/locations/{location_id}` + Projects scope, no
//     location specified (defaults to global): `projects/{project_id}` +
//     Organizations scope, location specified:
//     `organizations/{org_id}/locations/{location_id}` + Organizations scope, no
//     location specified (defaults to global): `organizations/{org_id}` The
//     following example `parent` string specifies a parent project with the
//     identifier `example-project`, and specifies the `europe-west3` location
//     for processing data:
//     parent=projects/example-project/locations/europe-west3.
func (r *OrganizationsInspectTemplatesService) List(parentid string) *OrganizationsInspectTemplatesListCall {
	c := &OrganizationsInspectTemplatesListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parentid = parentid
	return c
}

// LocationId sets the optional parameter "locationId": Deprecated. This field
// has no effect.
func (c *OrganizationsInspectTemplatesListCall) LocationId(locationId string) *OrganizationsInspectTemplatesListCall {
	c.urlParams_.Set("locationId", locationId)
	return c
}

// OrderBy sets the optional parameter "orderBy": Comma-separated list of
// fields to order by, followed by `asc` or `desc` postfix. This list is case
// insensitive. The default sorting order is ascending. Redundant space
// characters are insignificant. Example: `name asc,update_time, create_time
// desc` Supported fields are: - `create_time`: corresponds to the time the
// template was created. - `update_time`: corresponds to the time the template
// was last updated. - `name`: corresponds to the template's name. -
// `display_name`: corresponds to the template's display name.
func (c *OrganizationsInspectTemplatesListCall) OrderBy(orderBy string) *OrganizationsInspectTemplatesListCall {
	c.urlParams_.Set("orderBy", orderBy)
	return c
}

// PageSize sets the optional parameter "pageSize": Size of the page. This
// value can be limited by the server. If zero server returns a page of max
// size 100.
func (c *OrganizationsInspectTemplatesListCall) PageSize(pageSize int64) *OrganizationsInspectTemplatesListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": Page token to continue
// retrieval. Comes from the previous call to `ListInspectTemplates`.
func (c *OrganizationsInspectTemplatesListCall) PageToken(pageToken string) *OrganizationsInspectTemplatesListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *OrganizationsInspectTemplatesListCall) Fields(s ...googleapi.Field) *OrganizationsInspectTemplatesListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *OrganizationsInspectTemplatesListCall) IfNoneMatch(entityTag string) *OrganizationsInspectTemplatesListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *OrganizationsInspectTemplatesListCall) Context(ctx context.Context) *OrganizationsInspectTemplatesListCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *OrganizationsInspectTemplatesListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *OrganizationsInspectTemplatesListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v2/{+parent}/inspectTemplates")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parentid,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "dlp.organizations.inspectTemplates.list", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "dlp.organizations.inspectTemplates.list" call.
// Any non-2xx status code is an error. Response headers are in either
// *GooglePrivacyDlpV2ListInspectTemplatesResponse.ServerResponse.Header or (if
// a response was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *OrganizationsInspectTemplatesListCall) Do(opts ...googleapi.CallOption) (*GooglePrivacyDlpV2ListInspectTemplatesResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GooglePrivacyDlpV2ListInspectTemplatesResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "dlp.organizations.inspectTemplates.list", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *OrganizationsInspectTemplatesListCall) Pages(ctx context.Context, f func(*GooglePrivacyDlpV2ListInspectTemplatesResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken"))
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

type OrganizationsInspectTemplatesPatchCall struct {
	s                                              *Service
	name                                           string
	googleprivacydlpv2updateinspecttemplaterequest *GooglePrivacyDlpV2UpdateInspectTemplateRequest
	urlParams_                                     gensupport.URLParams
	ctx_                                           context.Context
	header_                                        http.Header
}

// Patch: Updates the InspectTemplate. See
// https://cloud.google.com/sensitive-data-protection/docs/creating-templates
// to learn more.
//
//   - name: Resource name of organization and inspectTemplate to be updated, for
//     example `organizations/433245324/inspectTemplates/432452342` or
//     projects/project-id/inspectTemplates/432452342.
func (r *OrganizationsInspectTemplatesService) Patch(name string, googleprivacydlpv2updateinspecttemplaterequest *GooglePrivacyDlpV2UpdateInspectTemplateRequest) *OrganizationsInspectTemplatesPatchCall {
	c := &OrganizationsInspectTemplatesPatchCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.googleprivacydlpv2updateinspecttemplaterequest = googleprivacydlpv2updateinspecttemplaterequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *OrganizationsInspectTemplatesPatchCall) Fields(s ...googleapi.Field) *OrganizationsInspectTemplatesPatchCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *OrganizationsInspectTemplatesPatchCall) Context(ctx context.Context) *OrganizationsInspectTemplatesPatchCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *OrganizationsInspectTemplatesPatchCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *OrganizationsInspectTemplatesPatchCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.googleprivacydlpv2updateinspecttemplaterequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v2/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("PATCH", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "dlp.organizations.inspectTemplates.patch", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "dlp.organizations.inspectTemplates.patch" call.
// Any non-2xx status code is an error. Response headers are in either
// *GooglePrivacyDlpV2InspectTemplate.ServerResponse.Header or (if a response
// was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *OrganizationsInspectTemplatesPatchCall) Do(opts ...googleapi.CallOption) (*GooglePrivacyDlpV2InspectTemplate, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GooglePrivacyDlpV2InspectTemplate{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "dlp.organizations.inspectTemplates.patch", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type OrganizationsLocationsColumnDataProfilesGetCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Gets a column data profile.
//
//   - name: Resource name, for example
//     `organizations/12345/locations/us/columnDataProfiles/53234423`.
func (r *OrganizationsLocationsColumnDataProfilesService) Get(name string) *OrganizationsLocationsColumnDataProfilesGetCall {
	c := &OrganizationsLocationsColumnDataProfilesGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *OrganizationsLocationsColumnDataProfilesGetCall) Fields(s ...googleapi.Field) *OrganizationsLocationsColumnDataProfilesGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *OrganizationsLocationsColumnDataProfilesGetCall) IfNoneMatch(entityTag string) *OrganizationsLocationsColumnDataProfilesGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *OrganizationsLocationsColumnDataProfilesGetCall) Context(ctx context.Context) *OrganizationsLocationsColumnDataProfilesGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *OrganizationsLocationsColumnDataProfilesGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *OrganizationsLocationsColumnDataProfilesGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v2/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "dlp.organizations.locations.columnDataProfiles.get", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "dlp.organizations.locations.columnDataProfiles.get" call.
// Any non-2xx status code is an error. Response headers are in either
// *GooglePrivacyDlpV2ColumnDataProfile.ServerResponse.Header or (if a response
// was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *OrganizationsLocationsColumnDataProfilesGetCall) Do(opts ...googleapi.CallOption) (*GooglePrivacyDlpV2ColumnDataProfile, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GooglePrivacyDlpV2ColumnDataProfile{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "dlp.organizations.locations.columnDataProfiles.get", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type OrganizationsLocationsColumnDataProfilesListCall struct {
	s            *Service
	parent       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Lists column data profiles for an organization.
//
//   - parent: Resource name of the organization or project, for example
//     `organizations/433245324/locations/europe` or
//     `projects/project-id/locations/asia`.
func (r *OrganizationsLocationsColumnDataProfilesService) List(parent string) *OrganizationsLocationsColumnDataProfilesListCall {
	c := &OrganizationsLocationsColumnDataProfilesListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	return c
}

// Filter sets the optional parameter "filter": Allows filtering. Supported
// syntax: * Filter expressions are made up of one or more restrictions. *
// Restrictions can be combined by `AND` or `OR` logical operators. A sequence
// of restrictions implicitly uses `AND`. * A restriction has the form of
// `{field} {operator} {value}`. * Supported fields: -
// `table_data_profile_name`: The name of the related table data profile -
// `project_id`: The Google Cloud project ID (REQUIRED) - `dataset_id`: The
// BigQuery dataset ID (REQUIRED) - `table_id`: The BigQuery table ID
// (REQUIRED) - `field_id`: The ID of the BigQuery field - `info_type`: The
// infotype detected in the resource - `sensitivity_level`: HIGH|MEDIUM|LOW -
// `data_risk_level`: How much risk is associated with this data -
// `status_code`: An RPC status code as defined in
// https://github.com/googleapis/googleapis/blob/master/google/rpc/code.proto -
// `profile_last_generated`: Date and time the profile was last generated * The
// operator must be `=` for project_id, dataset_id, and table_id. Other filters
// also support `!=`. The `profile_last_generated` filter also supports `<` and
// `>`. The syntax is based on https://google.aip.dev/160. Examples: *
// project_id = 12345 AND status_code = 1 * project_id = 12345 AND
// sensitivity_level = HIGH * project_id = 12345 AND info_type = STREET_ADDRESS
// * profile_last_generated < "2025-01-01T00:00:00.000Z" The length of this
// field should be no more than 500 characters.
func (c *OrganizationsLocationsColumnDataProfilesListCall) Filter(filter string) *OrganizationsLocationsColumnDataProfilesListCall {
	c.urlParams_.Set("filter", filter)
	return c
}

// OrderBy sets the optional parameter "orderBy": Comma-separated list of
// fields to order by, followed by `asc` or `desc` postfix. This list is case
// insensitive. The default sorting order is ascending. Redundant space
// characters are insignificant. Only one order field at a time is allowed.
// Examples: * `project_id asc` * `table_id` * `sensitivity_level desc`
// Supported fields are: - `project_id`: The Google Cloud project ID. -
// `dataset_id`: The ID of a BigQuery dataset. - `table_id`: The ID of a
// BigQuery table. - `sensitivity_level`: How sensitive the data in a column
// is, at most. - `data_risk_level`: How much risk is associated with this
// data. - `profile_last_generated`: When the profile was last updated in epoch
// seconds.
func (c *OrganizationsLocationsColumnDataProfilesListCall) OrderBy(orderBy string) *OrganizationsLocationsColumnDataProfilesListCall {
	c.urlParams_.Set("orderBy", orderBy)
	return c
}

// PageSize sets the optional parameter "pageSize": Size of the page. This
// value can be limited by the server. If zero, server returns a page of max
// size 100.
func (c *OrganizationsLocationsColumnDataProfilesListCall) PageSize(pageSize int64) *OrganizationsLocationsColumnDataProfilesListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": Page token to continue
// retrieval.
func (c *OrganizationsLocationsColumnDataProfilesListCall) PageToken(pageToken string) *OrganizationsLocationsColumnDataProfilesListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *OrganizationsLocationsColumnDataProfilesListCall) Fields(s ...googleapi.Field) *OrganizationsLocationsColumnDataProfilesListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *OrganizationsLocationsColumnDataProfilesListCall) IfNoneMatch(entityTag string) *OrganizationsLocationsColumnDataProfilesListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *OrganizationsLocationsColumnDataProfilesListCall) Context(ctx context.Context) *OrganizationsLocationsColumnDataProfilesListCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *OrganizationsLocationsColumnDataProfilesListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *OrganizationsLocationsColumnDataProfilesListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v2/{+parent}/columnDataProfiles")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "dlp.organizations.locations.columnDataProfiles.list", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "dlp.organizations.locations.columnDataProfiles.list" call.
// Any non-2xx status code is an error. Response headers are in either
// *GooglePrivacyDlpV2ListColumnDataProfilesResponse.ServerResponse.Header or
// (if a response was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *OrganizationsLocationsColumnDataProfilesListCall) Do(opts ...googleapi.CallOption) (*GooglePrivacyDlpV2ListColumnDataProfilesResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GooglePrivacyDlpV2ListColumnDataProfilesResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "dlp.organizations.locations.columnDataProfiles.list", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *OrganizationsLocationsColumnDataProfilesListCall) Pages(ctx context.Context, f func(*GooglePrivacyDlpV2ListColumnDataProfilesResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken"))
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

type OrganizationsLocationsConnectionsCreateCall struct {
	s                                         *Service
	parent                                    string
	googleprivacydlpv2createconnectionrequest *GooglePrivacyDlpV2CreateConnectionRequest
	urlParams_                                gensupport.URLParams
	ctx_                                      context.Context
	header_                                   http.Header
}

// Create: Create a Connection to an external data source.
//
//   - parent: Parent resource name. The format of this value varies depending on
//     the scope of the request (project or organization): + Projects scope:
//     `projects/{project_id}/locations/{location_id}` + Organizations scope:
//     `organizations/{org_id}/locations/{location_id}`.
func (r *OrganizationsLocationsConnectionsService) Create(parent string, googleprivacydlpv2createconnectionrequest *GooglePrivacyDlpV2CreateConnectionRequest) *OrganizationsLocationsConnectionsCreateCall {
	c := &OrganizationsLocationsConnectionsCreateCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	c.googleprivacydlpv2createconnectionrequest = googleprivacydlpv2createconnectionrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *OrganizationsLocationsConnectionsCreateCall) Fields(s ...googleapi.Field) *OrganizationsLocationsConnectionsCreateCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *OrganizationsLocationsConnectionsCreateCall) Context(ctx context.Context) *OrganizationsLocationsConnectionsCreateCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *OrganizationsLocationsConnectionsCreateCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *OrganizationsLocationsConnectionsCreateCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.googleprivacydlpv2createconnectionrequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v2/{+parent}/connections")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "dlp.organizations.locations.connections.create", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "dlp.organizations.locations.connections.create" call.
// Any non-2xx status code is an error. Response headers are in either
// *GooglePrivacyDlpV2Connection.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *OrganizationsLocationsConnectionsCreateCall) Do(opts ...googleapi.CallOption) (*GooglePrivacyDlpV2Connection, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GooglePrivacyDlpV2Connection{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "dlp.organizations.locations.connections.create", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type OrganizationsLocationsConnectionsDeleteCall struct {
	s          *Service
	name       string
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Delete: Delete a Connection.
//
//   - name: Resource name of the Connection to be deleted, in the format:
//     `projects/{project}/locations/{location}/connections/{connection}`.
func (r *OrganizationsLocationsConnectionsService) Delete(name string) *OrganizationsLocationsConnectionsDeleteCall {
	c := &OrganizationsLocationsConnectionsDeleteCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *OrganizationsLocationsConnectionsDeleteCall) Fields(s ...googleapi.Field) *OrganizationsLocationsConnectionsDeleteCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *OrganizationsLocationsConnectionsDeleteCall) Context(ctx context.Context) *OrganizationsLocationsConnectionsDeleteCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *OrganizationsLocationsConnectionsDeleteCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *OrganizationsLocationsConnectionsDeleteCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v2/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("DELETE", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "dlp.organizations.locations.connections.delete", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "dlp.organizations.locations.connections.delete" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleProtobufEmpty.ServerResponse.Header or (if a response was returned at
// all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified was
// returned.
func (c *OrganizationsLocationsConnectionsDeleteCall) Do(opts ...googleapi.CallOption) (*GoogleProtobufEmpty, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleProtobufEmpty{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "dlp.organizations.locations.connections.delete", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type OrganizationsLocationsConnectionsGetCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Get a Connection by name.
//
//   - name: Resource name in the format:
//     `projects/{project}/locations/{location}/connections/{connection}`.
func (r *OrganizationsLocationsConnectionsService) Get(name string) *OrganizationsLocationsConnectionsGetCall {
	c := &OrganizationsLocationsConnectionsGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *OrganizationsLocationsConnectionsGetCall) Fields(s ...googleapi.Field) *OrganizationsLocationsConnectionsGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *OrganizationsLocationsConnectionsGetCall) IfNoneMatch(entityTag string) *OrganizationsLocationsConnectionsGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *OrganizationsLocationsConnectionsGetCall) Context(ctx context.Context) *OrganizationsLocationsConnectionsGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *OrganizationsLocationsConnectionsGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *OrganizationsLocationsConnectionsGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v2/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "dlp.organizations.locations.connections.get", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "dlp.organizations.locations.connections.get" call.
// Any non-2xx status code is an error. Response headers are in either
// *GooglePrivacyDlpV2Connection.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *OrganizationsLocationsConnectionsGetCall) Do(opts ...googleapi.CallOption) (*GooglePrivacyDlpV2Connection, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GooglePrivacyDlpV2Connection{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "dlp.organizations.locations.connections.get", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type OrganizationsLocationsConnectionsListCall struct {
	s            *Service
	parent       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Lists Connections in a parent. Use SearchConnections to see all
// connections within an organization.
//
//   - parent: Resource name of the organization or project, for example,
//     `organizations/433245324/locations/europe` or
//     `projects/project-id/locations/asia`.
func (r *OrganizationsLocationsConnectionsService) List(parent string) *OrganizationsLocationsConnectionsListCall {
	c := &OrganizationsLocationsConnectionsListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	return c
}

// Filter sets the optional parameter "filter": Supported field/value: `state`
// - MISSING|AVAILABLE|ERROR The syntax is based on https://google.aip.dev/160.
func (c *OrganizationsLocationsConnectionsListCall) Filter(filter string) *OrganizationsLocationsConnectionsListCall {
	c.urlParams_.Set("filter", filter)
	return c
}

// PageSize sets the optional parameter "pageSize": Number of results per page,
// max 1000.
func (c *OrganizationsLocationsConnectionsListCall) PageSize(pageSize int64) *OrganizationsLocationsConnectionsListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": Page token from a
// previous page to return the next set of results. If set, all other request
// fields must match the original request.
func (c *OrganizationsLocationsConnectionsListCall) PageToken(pageToken string) *OrganizationsLocationsConnectionsListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *OrganizationsLocationsConnectionsListCall) Fields(s ...googleapi.Field) *OrganizationsLocationsConnectionsListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *OrganizationsLocationsConnectionsListCall) IfNoneMatch(entityTag string) *OrganizationsLocationsConnectionsListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *OrganizationsLocationsConnectionsListCall) Context(ctx context.Context) *OrganizationsLocationsConnectionsListCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *OrganizationsLocationsConnectionsListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *OrganizationsLocationsConnectionsListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v2/{+parent}/connections")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "dlp.organizations.locations.connections.list", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "dlp.organizations.locations.connections.list" call.
// Any non-2xx status code is an error. Response headers are in either
// *GooglePrivacyDlpV2ListConnectionsResponse.ServerResponse.Header or (if a
// response was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *OrganizationsLocationsConnectionsListCall) Do(opts ...googleapi.CallOption) (*GooglePrivacyDlpV2ListConnectionsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GooglePrivacyDlpV2ListConnectionsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "dlp.organizations.locations.connections.list", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *OrganizationsLocationsConnectionsListCall) Pages(ctx context.Context, f func(*GooglePrivacyDlpV2ListConnectionsResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken"))
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

type OrganizationsLocationsConnectionsPatchCall struct {
	s                                         *Service
	name                                      string
	googleprivacydlpv2updateconnectionrequest *GooglePrivacyDlpV2UpdateConnectionRequest
	urlParams_                                gensupport.URLParams
	ctx_                                      context.Context
	header_                                   http.Header
}

// Patch: Update a Connection.
//
//   - name: Resource name in the format:
//     `projects/{project}/locations/{location}/connections/{connection}`.
func (r *OrganizationsLocationsConnectionsService) Patch(name string, googleprivacydlpv2updateconnectionrequest *GooglePrivacyDlpV2UpdateConnectionRequest) *OrganizationsLocationsConnectionsPatchCall {
	c := &OrganizationsLocationsConnectionsPatchCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.googleprivacydlpv2updateconnectionrequest = googleprivacydlpv2updateconnectionrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *OrganizationsLocationsConnectionsPatchCall) Fields(s ...googleapi.Field) *OrganizationsLocationsConnectionsPatchCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *OrganizationsLocationsConnectionsPatchCall) Context(ctx context.Context) *OrganizationsLocationsConnectionsPatchCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *OrganizationsLocationsConnectionsPatchCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *OrganizationsLocationsConnectionsPatchCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.googleprivacydlpv2updateconnectionrequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v2/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("PATCH", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "dlp.organizations.locations.connections.patch", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "dlp.organizations.locations.connections.patch" call.
// Any non-2xx status code is an error. Response headers are in either
// *GooglePrivacyDlpV2Connection.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *OrganizationsLocationsConnectionsPatchCall) Do(opts ...googleapi.CallOption) (*GooglePrivacyDlpV2Connection, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GooglePrivacyDlpV2Connection{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "dlp.organizations.locations.connections.patch", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type OrganizationsLocationsConnectionsSearchCall struct {
	s            *Service
	parent       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Search: Searches for Connections in a parent.
//
//   - parent: Resource name of the organization or project with a wildcard
//     location, for example, `organizations/433245324/locations/-` or
//     `projects/project-id/locations/-`.
func (r *OrganizationsLocationsConnectionsService) Search(parent string) *OrganizationsLocationsConnectionsSearchCall {
	c := &OrganizationsLocationsConnectionsSearchCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	return c
}

// Filter sets the optional parameter "filter": Supported field/value: -
// `state` - MISSING|AVAILABLE|ERROR The syntax is based on
// https://google.aip.dev/160.
func (c *OrganizationsLocationsConnectionsSearchCall) Filter(filter string) *OrganizationsLocationsConnectionsSearchCall {
	c.urlParams_.Set("filter", filter)
	return c
}

// PageSize sets the optional parameter "pageSize": Number of results per page,
// max 1000.
func (c *OrganizationsLocationsConnectionsSearchCall) PageSize(pageSize int64) *OrganizationsLocationsConnectionsSearchCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": Page token from a
// previous page to return the next set of results. If set, all other request
// fields must match the original request.
func (c *OrganizationsLocationsConnectionsSearchCall) PageToken(pageToken string) *OrganizationsLocationsConnectionsSearchCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *OrganizationsLocationsConnectionsSearchCall) Fields(s ...googleapi.Field) *OrganizationsLocationsConnectionsSearchCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *OrganizationsLocationsConnectionsSearchCall) IfNoneMatch(entityTag string) *OrganizationsLocationsConnectionsSearchCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *OrganizationsLocationsConnectionsSearchCall) Context(ctx context.Context) *OrganizationsLocationsConnectionsSearchCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *OrganizationsLocationsConnectionsSearchCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *OrganizationsLocationsConnectionsSearchCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v2/{+parent}/connections:search")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "dlp.organizations.locations.connections.search", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "dlp.organizations.locations.connections.search" call.
// Any non-2xx status code is an error. Response headers are in either
// *GooglePrivacyDlpV2SearchConnectionsResponse.ServerResponse.Header or (if a
// response was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *OrganizationsLocationsConnectionsSearchCall) Do(opts ...googleapi.CallOption) (*GooglePrivacyDlpV2SearchConnectionsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GooglePrivacyDlpV2SearchConnectionsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "dlp.organizations.locations.connections.search", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *OrganizationsLocationsConnectionsSearchCall) Pages(ctx context.Context, f func(*GooglePrivacyDlpV2SearchConnectionsResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken"))
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

type OrganizationsLocationsDeidentifyTemplatesCreateCall struct {
	s                                                 *Service
	parentid                                          string
	googleprivacydlpv2createdeidentifytemplaterequest *GooglePrivacyDlpV2CreateDeidentifyTemplateRequest
	urlParams_                                        gensupport.URLParams
	ctx_                                              context.Context
	header_                                           http.Header
}

// Create: Creates a DeidentifyTemplate for reusing frequently used
// configuration for de-identifying content, images, and storage. See
// https://cloud.google.com/sensitive-data-protection/docs/creating-templates-deid
// to learn more.
//
//   - parent: Parent resource name. The format of this value varies depending on
//     the scope of the request (project or organization) and whether you have
//     specified a processing location
//     (https://cloud.google.com/sensitive-data-protection/docs/specifying-location):
//   - Projects scope, location specified:
//     `projects/{project_id}/locations/{location_id}` + Projects scope, no
//     location specified (defaults to global): `projects/{project_id}` +
//     Organizations scope, location specified:
//     `organizations/{org_id}/locations/{location_id}` + Organizations scope, no
//     location specified (defaults to global): `organizations/{org_id}` The
//     following example `parent` string specifies a parent project with the
//     identifier `example-project`, and specifies the `europe-west3` location
//     for processing data:
//     parent=projects/example-project/locations/europe-west3.
func (r *OrganizationsLocationsDeidentifyTemplatesService) Create(parentid string, googleprivacydlpv2createdeidentifytemplaterequest *GooglePrivacyDlpV2CreateDeidentifyTemplateRequest) *OrganizationsLocationsDeidentifyTemplatesCreateCall {
	c := &OrganizationsLocationsDeidentifyTemplatesCreateCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parentid = parentid
	c.googleprivacydlpv2createdeidentifytemplaterequest = googleprivacydlpv2createdeidentifytemplaterequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *OrganizationsLocationsDeidentifyTemplatesCreateCall) Fields(s ...googleapi.Field) *OrganizationsLocationsDeidentifyTemplatesCreateCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *OrganizationsLocationsDeidentifyTemplatesCreateCall) Context(ctx context.Context) *OrganizationsLocationsDeidentifyTemplatesCreateCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *OrganizationsLocationsDeidentifyTemplatesCreateCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *OrganizationsLocationsDeidentifyTemplatesCreateCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.googleprivacydlpv2createdeidentifytemplaterequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v2/{+parent}/deidentifyTemplates")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parentid,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "dlp.organizations.locations.deidentifyTemplates.create", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "dlp.organizations.locations.deidentifyTemplates.create" call.
// Any non-2xx status code is an error. Response headers are in either
// *GooglePrivacyDlpV2DeidentifyTemplate.ServerResponse.Header or (if a
// response was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *OrganizationsLocationsDeidentifyTemplatesCreateCall) Do(opts ...googleapi.CallOption) (*GooglePrivacyDlpV2DeidentifyTemplate, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GooglePrivacyDlpV2DeidentifyTemplate{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "dlp.organizations.locations.deidentifyTemplates.create", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type OrganizationsLocationsDeidentifyTemplatesDeleteCall struct {
	s          *Service
	name       string
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Delete: Deletes a DeidentifyTemplate. See
// https://cloud.google.com/sensitive-data-protection/docs/creating-templates-deid
// to learn more.
//
//   - name: Resource name of the organization and deidentify template to be
//     deleted, for example
//     `organizations/433245324/deidentifyTemplates/432452342` or
//     projects/project-id/deidentifyTemplates/432452342.
func (r *OrganizationsLocationsDeidentifyTemplatesService) Delete(name string) *OrganizationsLocationsDeidentifyTemplatesDeleteCall {
	c := &OrganizationsLocationsDeidentifyTemplatesDeleteCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *OrganizationsLocationsDeidentifyTemplatesDeleteCall) Fields(s ...googleapi.Field) *OrganizationsLocationsDeidentifyTemplatesDeleteCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *OrganizationsLocationsDeidentifyTemplatesDeleteCall) Context(ctx context.Context) *OrganizationsLocationsDeidentifyTemplatesDeleteCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *OrganizationsLocationsDeidentifyTemplatesDeleteCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *OrganizationsLocationsDeidentifyTemplatesDeleteCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v2/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("DELETE", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "dlp.organizations.locations.deidentifyTemplates.delete", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "dlp.organizations.locations.deidentifyTemplates.delete" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleProtobufEmpty.ServerResponse.Header or (if a response was returned at
// all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified was
// returned.
func (c *OrganizationsLocationsDeidentifyTemplatesDeleteCall) Do(opts ...googleapi.CallOption) (*GoogleProtobufEmpty, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleProtobufEmpty{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "dlp.organizations.locations.deidentifyTemplates.delete", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type OrganizationsLocationsDeidentifyTemplatesGetCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Gets a DeidentifyTemplate. See
// https://cloud.google.com/sensitive-data-protection/docs/creating-templates-deid
// to learn more.
//
//   - name: Resource name of the organization and deidentify template to be
//     read, for example `organizations/433245324/deidentifyTemplates/432452342`
//     or projects/project-id/deidentifyTemplates/432452342.
func (r *OrganizationsLocationsDeidentifyTemplatesService) Get(name string) *OrganizationsLocationsDeidentifyTemplatesGetCall {
	c := &OrganizationsLocationsDeidentifyTemplatesGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *OrganizationsLocationsDeidentifyTemplatesGetCall) Fields(s ...googleapi.Field) *OrganizationsLocationsDeidentifyTemplatesGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *OrganizationsLocationsDeidentifyTemplatesGetCall) IfNoneMatch(entityTag string) *OrganizationsLocationsDeidentifyTemplatesGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *OrganizationsLocationsDeidentifyTemplatesGetCall) Context(ctx context.Context) *OrganizationsLocationsDeidentifyTemplatesGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *OrganizationsLocationsDeidentifyTemplatesGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *OrganizationsLocationsDeidentifyTemplatesGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v2/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "dlp.organizations.locations.deidentifyTemplates.get", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "dlp.organizations.locations.deidentifyTemplates.get" call.
// Any non-2xx status code is an error. Response headers are in either
// *GooglePrivacyDlpV2DeidentifyTemplate.ServerResponse.Header or (if a
// response was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *OrganizationsLocationsDeidentifyTemplatesGetCall) Do(opts ...googleapi.CallOption) (*GooglePrivacyDlpV2DeidentifyTemplate, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GooglePrivacyDlpV2DeidentifyTemplate{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "dlp.organizations.locations.deidentifyTemplates.get", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type OrganizationsLocationsDeidentifyTemplatesListCall struct {
	s            *Service
	parentid     string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Lists DeidentifyTemplates. See
// https://cloud.google.com/sensitive-data-protection/docs/creating-templates-deid
// to learn more.
//
//   - parent: Parent resource name. The format of this value varies depending on
//     the scope of the request (project or organization) and whether you have
//     specified a processing location
//     (https://cloud.google.com/sensitive-data-protection/docs/specifying-location):
//   - Projects scope, location specified:
//     `projects/{project_id}/locations/{location_id}` + Projects scope, no
//     location specified (defaults to global): `projects/{project_id}` +
//     Organizations scope, location specified:
//     `organizations/{org_id}/locations/{location_id}` + Organizations scope, no
//     location specified (defaults to global): `organizations/{org_id}` The
//     following example `parent` string specifies a parent project with the
//     identifier `example-project`, and specifies the `europe-west3` location
//     for processing data:
//     parent=projects/example-project/locations/europe-west3.
func (r *OrganizationsLocationsDeidentifyTemplatesService) List(parentid string) *OrganizationsLocationsDeidentifyTemplatesListCall {
	c := &OrganizationsLocationsDeidentifyTemplatesListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parentid = parentid
	return c
}

// LocationId sets the optional parameter "locationId": Deprecated. This field
// has no effect.
func (c *OrganizationsLocationsDeidentifyTemplatesListCall) LocationId(locationId string) *OrganizationsLocationsDeidentifyTemplatesListCall {
	c.urlParams_.Set("locationId", locationId)
	return c
}

// OrderBy sets the optional parameter "orderBy": Comma-separated list of
// fields to order by, followed by `asc` or `desc` postfix. This list is case
// insensitive. The default sorting order is ascending. Redundant space
// characters are insignificant. Example: `name asc,update_time, create_time
// desc` Supported fields are: - `create_time`: corresponds to the time the
// template was created. - `update_time`: corresponds to the time the template
// was last updated. - `name`: corresponds to the template's name. -
// `display_name`: corresponds to the template's display name.
func (c *OrganizationsLocationsDeidentifyTemplatesListCall) OrderBy(orderBy string) *OrganizationsLocationsDeidentifyTemplatesListCall {
	c.urlParams_.Set("orderBy", orderBy)
	return c
}

// PageSize sets the optional parameter "pageSize": Size of the page. This
// value can be limited by the server. If zero server returns a page of max
// size 100.
func (c *OrganizationsLocationsDeidentifyTemplatesListCall) PageSize(pageSize int64) *OrganizationsLocationsDeidentifyTemplatesListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": Page token to continue
// retrieval. Comes from the previous call to `ListDeidentifyTemplates`.
func (c *OrganizationsLocationsDeidentifyTemplatesListCall) PageToken(pageToken string) *OrganizationsLocationsDeidentifyTemplatesListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *OrganizationsLocationsDeidentifyTemplatesListCall) Fields(s ...googleapi.Field) *OrganizationsLocationsDeidentifyTemplatesListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *OrganizationsLocationsDeidentifyTemplatesListCall) IfNoneMatch(entityTag string) *OrganizationsLocationsDeidentifyTemplatesListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *OrganizationsLocationsDeidentifyTemplatesListCall) Context(ctx context.Context) *OrganizationsLocationsDeidentifyTemplatesListCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *OrganizationsLocationsDeidentifyTemplatesListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *OrganizationsLocationsDeidentifyTemplatesListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v2/{+parent}/deidentifyTemplates")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parentid,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "dlp.organizations.locations.deidentifyTemplates.list", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "dlp.organizations.locations.deidentifyTemplates.list" call.
// Any non-2xx status code is an error. Response headers are in either
// *GooglePrivacyDlpV2ListDeidentifyTemplatesResponse.ServerResponse.Header or
// (if a response was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *OrganizationsLocationsDeidentifyTemplatesListCall) Do(opts ...googleapi.CallOption) (*GooglePrivacyDlpV2ListDeidentifyTemplatesResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GooglePrivacyDlpV2ListDeidentifyTemplatesResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "dlp.organizations.locations.deidentifyTemplates.list", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *OrganizationsLocationsDeidentifyTemplatesListCall) Pages(ctx context.Context, f func(*GooglePrivacyDlpV2ListDeidentifyTemplatesResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken"))
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

type OrganizationsLocationsDeidentifyTemplatesPatchCall struct {
	s                                                 *Service
	name                                              string
	googleprivacydlpv2updatedeidentifytemplaterequest *GooglePrivacyDlpV2UpdateDeidentifyTemplateRequest
	urlParams_                                        gensupport.URLParams
	ctx_                                              context.Context
	header_                                           http.Header
}

// Patch: Updates the DeidentifyTemplate. See
// https://cloud.google.com/sensitive-data-protection/docs/creating-templates-deid
// to learn more.
//
//   - name: Resource name of organization and deidentify template to be updated,
//     for example `organizations/433245324/deidentifyTemplates/432452342` or
//     projects/project-id/deidentifyTemplates/432452342.
func (r *OrganizationsLocationsDeidentifyTemplatesService) Patch(name string, googleprivacydlpv2updatedeidentifytemplaterequest *GooglePrivacyDlpV2UpdateDeidentifyTemplateRequest) *OrganizationsLocationsDeidentifyTemplatesPatchCall {
	c := &OrganizationsLocationsDeidentifyTemplatesPatchCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.googleprivacydlpv2updatedeidentifytemplaterequest = googleprivacydlpv2updatedeidentifytemplaterequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *OrganizationsLocationsDeidentifyTemplatesPatchCall) Fields(s ...googleapi.Field) *OrganizationsLocationsDeidentifyTemplatesPatchCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *OrganizationsLocationsDeidentifyTemplatesPatchCall) Context(ctx context.Context) *OrganizationsLocationsDeidentifyTemplatesPatchCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *OrganizationsLocationsDeidentifyTemplatesPatchCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *OrganizationsLocationsDeidentifyTemplatesPatchCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.googleprivacydlpv2updatedeidentifytemplaterequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v2/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("PATCH", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "dlp.organizations.locations.deidentifyTemplates.patch", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "dlp.organizations.locations.deidentifyTemplates.patch" call.
// Any non-2xx status code is an error. Response headers are in either
// *GooglePrivacyDlpV2DeidentifyTemplate.ServerResponse.Header or (if a
// response was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *OrganizationsLocationsDeidentifyTemplatesPatchCall) Do(opts ...googleapi.CallOption) (*GooglePrivacyDlpV2DeidentifyTemplate, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GooglePrivacyDlpV2DeidentifyTemplate{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "dlp.organizations.locations.deidentifyTemplates.patch", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type OrganizationsLocationsDiscoveryConfigsCreateCall struct {
	s                                              *Service
	parentid                                       string
	googleprivacydlpv2creatediscoveryconfigrequest *GooglePrivacyDlpV2CreateDiscoveryConfigRequest
	urlParams_                                     gensupport.URLParams
	ctx_                                           context.Context
	header_                                        http.Header
}

// Create: Creates a config for discovery to scan and profile storage.
//
//   - parent: Parent resource name. The format of this value varies depending on
//     the scope of the request (project or organization): + Projects scope:
//     `projects/{project_id}/locations/{location_id}` + Organizations scope:
//     `organizations/{org_id}/locations/{location_id}` The following example
//     `parent` string specifies a parent project with the identifier
//     `example-project`, and specifies the `europe-west3` location for
//     processing data: parent=projects/example-project/locations/europe-west3.
func (r *OrganizationsLocationsDiscoveryConfigsService) Create(parentid string, googleprivacydlpv2creatediscoveryconfigrequest *GooglePrivacyDlpV2CreateDiscoveryConfigRequest) *OrganizationsLocationsDiscoveryConfigsCreateCall {
	c := &OrganizationsLocationsDiscoveryConfigsCreateCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parentid = parentid
	c.googleprivacydlpv2creatediscoveryconfigrequest = googleprivacydlpv2creatediscoveryconfigrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *OrganizationsLocationsDiscoveryConfigsCreateCall) Fields(s ...googleapi.Field) *OrganizationsLocationsDiscoveryConfigsCreateCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *OrganizationsLocationsDiscoveryConfigsCreateCall) Context(ctx context.Context) *OrganizationsLocationsDiscoveryConfigsCreateCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *OrganizationsLocationsDiscoveryConfigsCreateCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *OrganizationsLocationsDiscoveryConfigsCreateCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.googleprivacydlpv2creatediscoveryconfigrequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v2/{+parent}/discoveryConfigs")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parentid,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "dlp.organizations.locations.discoveryConfigs.create", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "dlp.organizations.locations.discoveryConfigs.create" call.
// Any non-2xx status code is an error. Response headers are in either
// *GooglePrivacyDlpV2DiscoveryConfig.ServerResponse.Header or (if a response
// was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *OrganizationsLocationsDiscoveryConfigsCreateCall) Do(opts ...googleapi.CallOption) (*GooglePrivacyDlpV2DiscoveryConfig, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GooglePrivacyDlpV2DiscoveryConfig{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "dlp.organizations.locations.discoveryConfigs.create", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type OrganizationsLocationsDiscoveryConfigsDeleteCall struct {
	s          *Service
	name       string
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Delete: Deletes a discovery configuration.
//
//   - name: Resource name of the project and the config, for example
//     `projects/dlp-test-project/discoveryConfigs/53234423`.
func (r *OrganizationsLocationsDiscoveryConfigsService) Delete(name string) *OrganizationsLocationsDiscoveryConfigsDeleteCall {
	c := &OrganizationsLocationsDiscoveryConfigsDeleteCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *OrganizationsLocationsDiscoveryConfigsDeleteCall) Fields(s ...googleapi.Field) *OrganizationsLocationsDiscoveryConfigsDeleteCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *OrganizationsLocationsDiscoveryConfigsDeleteCall) Context(ctx context.Context) *OrganizationsLocationsDiscoveryConfigsDeleteCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *OrganizationsLocationsDiscoveryConfigsDeleteCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *OrganizationsLocationsDiscoveryConfigsDeleteCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v2/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("DELETE", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "dlp.organizations.locations.discoveryConfigs.delete", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "dlp.organizations.locations.discoveryConfigs.delete" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleProtobufEmpty.ServerResponse.Header or (if a response was returned at
// all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified was
// returned.
func (c *OrganizationsLocationsDiscoveryConfigsDeleteCall) Do(opts ...googleapi.CallOption) (*GoogleProtobufEmpty, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleProtobufEmpty{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "dlp.organizations.locations.discoveryConfigs.delete", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type OrganizationsLocationsDiscoveryConfigsGetCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Gets a discovery configuration.
//
//   - name: Resource name of the project and the configuration, for example
//     `projects/dlp-test-project/discoveryConfigs/53234423`.
func (r *OrganizationsLocationsDiscoveryConfigsService) Get(name string) *OrganizationsLocationsDiscoveryConfigsGetCall {
	c := &OrganizationsLocationsDiscoveryConfigsGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *OrganizationsLocationsDiscoveryConfigsGetCall) Fields(s ...googleapi.Field) *OrganizationsLocationsDiscoveryConfigsGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *OrganizationsLocationsDiscoveryConfigsGetCall) IfNoneMatch(entityTag string) *OrganizationsLocationsDiscoveryConfigsGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *OrganizationsLocationsDiscoveryConfigsGetCall) Context(ctx context.Context) *OrganizationsLocationsDiscoveryConfigsGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *OrganizationsLocationsDiscoveryConfigsGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *OrganizationsLocationsDiscoveryConfigsGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v2/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "dlp.organizations.locations.discoveryConfigs.get", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "dlp.organizations.locations.discoveryConfigs.get" call.
// Any non-2xx status code is an error. Response headers are in either
// *GooglePrivacyDlpV2DiscoveryConfig.ServerResponse.Header or (if a response
// was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *OrganizationsLocationsDiscoveryConfigsGetCall) Do(opts ...googleapi.CallOption) (*GooglePrivacyDlpV2DiscoveryConfig, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GooglePrivacyDlpV2DiscoveryConfig{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "dlp.organizations.locations.discoveryConfigs.get", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type OrganizationsLocationsDiscoveryConfigsListCall struct {
	s            *Service
	parentid     string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Lists discovery configurations.
//
//   - parent: Parent resource name. The format of this value is as follows:
//     `projects/{project_id}/locations/{location_id}` The following example
//     `parent` string specifies a parent project with the identifier
//     `example-project`, and specifies the `europe-west3` location for
//     processing data: parent=projects/example-project/locations/europe-west3.
func (r *OrganizationsLocationsDiscoveryConfigsService) List(parentid string) *OrganizationsLocationsDiscoveryConfigsListCall {
	c := &OrganizationsLocationsDiscoveryConfigsListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parentid = parentid
	return c
}

// OrderBy sets the optional parameter "orderBy": Comma-separated list of
// config fields to order by, followed by `asc` or `desc` postfix. This list is
// case insensitive. The default sorting order is ascending. Redundant space
// characters are insignificant. Example: `name asc,update_time, create_time
// desc` Supported fields are: - `last_run_time`: corresponds to the last time
// the DiscoveryConfig ran. - `name`: corresponds to the DiscoveryConfig's
// name. - `status`: corresponds to DiscoveryConfig's status.
func (c *OrganizationsLocationsDiscoveryConfigsListCall) OrderBy(orderBy string) *OrganizationsLocationsDiscoveryConfigsListCall {
	c.urlParams_.Set("orderBy", orderBy)
	return c
}

// PageSize sets the optional parameter "pageSize": Size of the page. This
// value can be limited by a server.
func (c *OrganizationsLocationsDiscoveryConfigsListCall) PageSize(pageSize int64) *OrganizationsLocationsDiscoveryConfigsListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": Page token to continue
// retrieval. Comes from the previous call to ListDiscoveryConfigs. `order_by`
// field must not change for subsequent calls.
func (c *OrganizationsLocationsDiscoveryConfigsListCall) PageToken(pageToken string) *OrganizationsLocationsDiscoveryConfigsListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *OrganizationsLocationsDiscoveryConfigsListCall) Fields(s ...googleapi.Field) *OrganizationsLocationsDiscoveryConfigsListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *OrganizationsLocationsDiscoveryConfigsListCall) IfNoneMatch(entityTag string) *OrganizationsLocationsDiscoveryConfigsListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *OrganizationsLocationsDiscoveryConfigsListCall) Context(ctx context.Context) *OrganizationsLocationsDiscoveryConfigsListCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *OrganizationsLocationsDiscoveryConfigsListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *OrganizationsLocationsDiscoveryConfigsListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v2/{+parent}/discoveryConfigs")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parentid,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "dlp.organizations.locations.discoveryConfigs.list", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "dlp.organizations.locations.discoveryConfigs.list" call.
// Any non-2xx status code is an error. Response headers are in either
// *GooglePrivacyDlpV2ListDiscoveryConfigsResponse.ServerResponse.Header or (if
// a response was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *OrganizationsLocationsDiscoveryConfigsListCall) Do(opts ...googleapi.CallOption) (*GooglePrivacyDlpV2ListDiscoveryConfigsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GooglePrivacyDlpV2ListDiscoveryConfigsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "dlp.organizations.locations.discoveryConfigs.list", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *OrganizationsLocationsDiscoveryConfigsListCall) Pages(ctx context.Context, f func(*GooglePrivacyDlpV2ListDiscoveryConfigsResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken"))
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

type OrganizationsLocationsDiscoveryConfigsPatchCall struct {
	s                                              *Service
	name                                           string
	googleprivacydlpv2updatediscoveryconfigrequest *GooglePrivacyDlpV2UpdateDiscoveryConfigRequest
	urlParams_                                     gensupport.URLParams
	ctx_                                           context.Context
	header_                                        http.Header
}

// Patch: Updates a discovery configuration.
//
//   - name: Resource name of the project and the configuration, for example
//     `projects/dlp-test-project/discoveryConfigs/53234423`.
func (r *OrganizationsLocationsDiscoveryConfigsService) Patch(name string, googleprivacydlpv2updatediscoveryconfigrequest *GooglePrivacyDlpV2UpdateDiscoveryConfigRequest) *OrganizationsLocationsDiscoveryConfigsPatchCall {
	c := &OrganizationsLocationsDiscoveryConfigsPatchCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.googleprivacydlpv2updatediscoveryconfigrequest = googleprivacydlpv2updatediscoveryconfigrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *OrganizationsLocationsDiscoveryConfigsPatchCall) Fields(s ...googleapi.Field) *OrganizationsLocationsDiscoveryConfigsPatchCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *OrganizationsLocationsDiscoveryConfigsPatchCall) Context(ctx context.Context) *OrganizationsLocationsDiscoveryConfigsPatchCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *OrganizationsLocationsDiscoveryConfigsPatchCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *OrganizationsLocationsDiscoveryConfigsPatchCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.googleprivacydlpv2updatediscoveryconfigrequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v2/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("PATCH", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "dlp.organizations.locations.discoveryConfigs.patch", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "dlp.organizations.locations.discoveryConfigs.patch" call.
// Any non-2xx status code is an error. Response headers are in either
// *GooglePrivacyDlpV2DiscoveryConfig.ServerResponse.Header or (if a response
// was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *OrganizationsLocationsDiscoveryConfigsPatchCall) Do(opts ...googleapi.CallOption) (*GooglePrivacyDlpV2DiscoveryConfig, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GooglePrivacyDlpV2DiscoveryConfig{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "dlp.organizations.locations.discoveryConfigs.patch", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type OrganizationsLocationsDlpJobsListCall struct {
	s            *Service
	parentid     string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Lists DlpJobs that match the specified filter in the request. See
// https://cloud.google.com/sensitive-data-protection/docs/inspecting-storage
// and
// https://cloud.google.com/sensitive-data-protection/docs/compute-risk-analysis
// to learn more.
//
//   - parent: Parent resource name. The format of this value varies depending on
//     whether you have specified a processing location
//     (https://cloud.google.com/sensitive-data-protection/docs/specifying-location):
//   - Projects scope, location specified:
//     `projects/{project_id}/locations/{location_id}` + Projects scope, no
//     location specified (defaults to global): `projects/{project_id}` The
//     following example `parent` string specifies a parent project with the
//     identifier `example-project`, and specifies the `europe-west3` location
//     for processing data:
//     parent=projects/example-project/locations/europe-west3.
func (r *OrganizationsLocationsDlpJobsService) List(parentid string) *OrganizationsLocationsDlpJobsListCall {
	c := &OrganizationsLocationsDlpJobsListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parentid = parentid
	return c
}

// Filter sets the optional parameter "filter": Allows filtering. Supported
// syntax: * Filter expressions are made up of one or more restrictions. *
// Restrictions can be combined by `AND` or `OR` logical operators. A sequence
// of restrictions implicitly uses `AND`. * A restriction has the form of
// `{field} {operator} {value}`. * Supported fields/values for inspect jobs: -
// `state` - PENDING|RUNNING|CANCELED|FINISHED|FAILED - `inspected_storage` -
// DATASTORE|CLOUD_STORAGE|BIGQUERY - `trigger_name` - The name of the trigger
// that created the job. - 'end_time` - Corresponds to the time the job
// finished. - 'start_time` - Corresponds to the time the job finished. *
// Supported fields for risk analysis jobs: - `state` -
// RUNNING|CANCELED|FINISHED|FAILED - 'end_time` - Corresponds to the time the
// job finished. - 'start_time` - Corresponds to the time the job finished. *
// The operator must be `=` or `!=`. The syntax is based on
// https://google.aip.dev/160. Examples: * inspected_storage = cloud_storage
// AND state = done * inspected_storage = cloud_storage OR inspected_storage =
// bigquery * inspected_storage = cloud_storage AND (state = done OR state =
// canceled) * end_time > \"2017-12-12T00:00:00+00:00\" The length of this
// field should be no more than 500 characters.
func (c *OrganizationsLocationsDlpJobsListCall) Filter(filter string) *OrganizationsLocationsDlpJobsListCall {
	c.urlParams_.Set("filter", filter)
	return c
}

// LocationId sets the optional parameter "locationId": Deprecated. This field
// has no effect.
func (c *OrganizationsLocationsDlpJobsListCall) LocationId(locationId string) *OrganizationsLocationsDlpJobsListCall {
	c.urlParams_.Set("locationId", locationId)
	return c
}

// OrderBy sets the optional parameter "orderBy": Comma-separated list of
// fields to order by, followed by `asc` or `desc` postfix. This list is case
// insensitive. The default sorting order is ascending. Redundant space
// characters are insignificant. Example: `name asc, end_time asc, create_time
// desc` Supported fields are: - `create_time`: corresponds to the time the job
// was created. - `end_time`: corresponds to the time the job ended. - `name`:
// corresponds to the job's name. - `state`: corresponds to `state`
func (c *OrganizationsLocationsDlpJobsListCall) OrderBy(orderBy string) *OrganizationsLocationsDlpJobsListCall {
	c.urlParams_.Set("orderBy", orderBy)
	return c
}

// PageSize sets the optional parameter "pageSize": The standard list page
// size.
func (c *OrganizationsLocationsDlpJobsListCall) PageSize(pageSize int64) *OrganizationsLocationsDlpJobsListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": The standard list page
// token.
func (c *OrganizationsLocationsDlpJobsListCall) PageToken(pageToken string) *OrganizationsLocationsDlpJobsListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Type sets the optional parameter "type": The type of job. Defaults to
// `DlpJobType.INSPECT`
//
// Possible values:
//
//	"DLP_JOB_TYPE_UNSPECIFIED" - Defaults to INSPECT_JOB.
//	"INSPECT_JOB" - The job inspected Google Cloud for sensitive data.
//	"RISK_ANALYSIS_JOB" - The job executed a Risk Analysis computation.
func (c *OrganizationsLocationsDlpJobsListCall) Type(type_ string) *OrganizationsLocationsDlpJobsListCall {
	c.urlParams_.Set("type", type_)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *OrganizationsLocationsDlpJobsListCall) Fields(s ...googleapi.Field) *OrganizationsLocationsDlpJobsListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *OrganizationsLocationsDlpJobsListCall) IfNoneMatch(entityTag string) *OrganizationsLocationsDlpJobsListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *OrganizationsLocationsDlpJobsListCall) Context(ctx context.Context) *OrganizationsLocationsDlpJobsListCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *OrganizationsLocationsDlpJobsListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *OrganizationsLocationsDlpJobsListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v2/{+parent}/dlpJobs")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parentid,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "dlp.organizations.locations.dlpJobs.list", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "dlp.organizations.locations.dlpJobs.list" call.
// Any non-2xx status code is an error. Response headers are in either
// *GooglePrivacyDlpV2ListDlpJobsResponse.ServerResponse.Header or (if a
// response was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *OrganizationsLocationsDlpJobsListCall) Do(opts ...googleapi.CallOption) (*GooglePrivacyDlpV2ListDlpJobsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GooglePrivacyDlpV2ListDlpJobsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "dlp.organizations.locations.dlpJobs.list", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *OrganizationsLocationsDlpJobsListCall) Pages(ctx context.Context, f func(*GooglePrivacyDlpV2ListDlpJobsResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken"))
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

type OrganizationsLocationsFileStoreDataProfilesDeleteCall struct {
	s          *Service
	name       string
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Delete: Delete a FileStoreDataProfile. Will not prevent the profile from
// being regenerated if the resource is still included in a discovery
// configuration.
//
// - name: Resource name of the file store data profile.
func (r *OrganizationsLocationsFileStoreDataProfilesService) Delete(name string) *OrganizationsLocationsFileStoreDataProfilesDeleteCall {
	c := &OrganizationsLocationsFileStoreDataProfilesDeleteCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *OrganizationsLocationsFileStoreDataProfilesDeleteCall) Fields(s ...googleapi.Field) *OrganizationsLocationsFileStoreDataProfilesDeleteCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *OrganizationsLocationsFileStoreDataProfilesDeleteCall) Context(ctx context.Context) *OrganizationsLocationsFileStoreDataProfilesDeleteCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *OrganizationsLocationsFileStoreDataProfilesDeleteCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *OrganizationsLocationsFileStoreDataProfilesDeleteCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v2/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("DELETE", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "dlp.organizations.locations.fileStoreDataProfiles.delete", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "dlp.organizations.locations.fileStoreDataProfiles.delete" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleProtobufEmpty.ServerResponse.Header or (if a response was returned at
// all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified was
// returned.
func (c *OrganizationsLocationsFileStoreDataProfilesDeleteCall) Do(opts ...googleapi.CallOption) (*GoogleProtobufEmpty, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleProtobufEmpty{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "dlp.organizations.locations.fileStoreDataProfiles.delete", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type OrganizationsLocationsFileStoreDataProfilesGetCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Gets a file store data profile.
//
//   - name: Resource name, for example
//     `organizations/12345/locations/us/fileStoreDataProfiles/53234423`.
func (r *OrganizationsLocationsFileStoreDataProfilesService) Get(name string) *OrganizationsLocationsFileStoreDataProfilesGetCall {
	c := &OrganizationsLocationsFileStoreDataProfilesGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *OrganizationsLocationsFileStoreDataProfilesGetCall) Fields(s ...googleapi.Field) *OrganizationsLocationsFileStoreDataProfilesGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *OrganizationsLocationsFileStoreDataProfilesGetCall) IfNoneMatch(entityTag string) *OrganizationsLocationsFileStoreDataProfilesGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *OrganizationsLocationsFileStoreDataProfilesGetCall) Context(ctx context.Context) *OrganizationsLocationsFileStoreDataProfilesGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *OrganizationsLocationsFileStoreDataProfilesGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *OrganizationsLocationsFileStoreDataProfilesGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v2/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "dlp.organizations.locations.fileStoreDataProfiles.get", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "dlp.organizations.locations.fileStoreDataProfiles.get" call.
// Any non-2xx status code is an error. Response headers are in either
// *GooglePrivacyDlpV2FileStoreDataProfile.ServerResponse.Header or (if a
// response was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *OrganizationsLocationsFileStoreDataProfilesGetCall) Do(opts ...googleapi.CallOption) (*GooglePrivacyDlpV2FileStoreDataProfile, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GooglePrivacyDlpV2FileStoreDataProfile{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "dlp.organizations.locations.fileStoreDataProfiles.get", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type OrganizationsLocationsFileStoreDataProfilesListCall struct {
	s            *Service
	parent       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Lists file store data profiles for an organization.
//
//   - parent: Resource name of the organization or project, for example
//     `organizations/433245324/locations/europe` or
//     `projects/project-id/locations/asia`.
func (r *OrganizationsLocationsFileStoreDataProfilesService) List(parent string) *OrganizationsLocationsFileStoreDataProfilesListCall {
	c := &OrganizationsLocationsFileStoreDataProfilesListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	return c
}

// Filter sets the optional parameter "filter": Allows filtering. Supported
// syntax: * Filter expressions are made up of one or more restrictions. *
// Restrictions can be combined by `AND` or `OR` logical operators. A sequence
// of restrictions implicitly uses `AND`. * A restriction has the form of
// `{field} {operator} {value}`. * Supported fields: - `project_id`: The Google
// Cloud project ID - `account_id`: The AWS account ID - `file_store_path`: The
// path like "gs://bucket" - `data_source_type`: The profile's data source
// type, like "google/storage/bucket" - `data_storage_location`: The location
// where the file store's data is stored, like "us-central1" -
// `sensitivity_level`: HIGH|MODERATE|LOW - `data_risk_level`:
// HIGH|MODERATE|LOW - `resource_visibility`: PUBLIC|RESTRICTED -
// `status_code`: an RPC status code as defined in
// https://github.com/googleapis/googleapis/blob/master/google/rpc/code.proto -
// `profile_last_generated`: Date and time the profile was last generated * The
// operator must be `=` or `!=`. The `profile_last_generated` filter also
// supports `<` and `>`. The syntax is based on https://google.aip.dev/160.
// Examples: * `project_id = 12345 AND status_code = 1` * `project_id = 12345
// AND sensitivity_level = HIGH` * `project_id = 12345 AND resource_visibility
// = PUBLIC` * `file_store_path = "gs://mybucket" * `profile_last_generated <
// "2025-01-01T00:00:00.000Z" The length of this field should be no more than
// 500 characters.
func (c *OrganizationsLocationsFileStoreDataProfilesListCall) Filter(filter string) *OrganizationsLocationsFileStoreDataProfilesListCall {
	c.urlParams_.Set("filter", filter)
	return c
}

// OrderBy sets the optional parameter "orderBy": Comma-separated list of
// fields to order by, followed by `asc` or `desc` postfix. This list is case
// insensitive. The default sorting order is ascending. Redundant space
// characters are insignificant. Only one order field at a time is allowed.
// Examples: * `project_id asc` * `name` * `sensitivity_level desc` Supported
// fields are: - `project_id`: The Google Cloud project ID. -
// `sensitivity_level`: How sensitive the data in a table is, at most. -
// `data_risk_level`: How much risk is associated with this data. -
// `profile_last_generated`: When the profile was last updated in epoch
// seconds. - `last_modified`: The last time the resource was modified. -
// `resource_visibility`: Visibility restriction for this resource. - `name`:
// The name of the profile. - `create_time`: The time the file store was first
// created.
func (c *OrganizationsLocationsFileStoreDataProfilesListCall) OrderBy(orderBy string) *OrganizationsLocationsFileStoreDataProfilesListCall {
	c.urlParams_.Set("orderBy", orderBy)
	return c
}

// PageSize sets the optional parameter "pageSize": Size of the page. This
// value can be limited by the server. If zero, server returns a page of max
// size 100.
func (c *OrganizationsLocationsFileStoreDataProfilesListCall) PageSize(pageSize int64) *OrganizationsLocationsFileStoreDataProfilesListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": Page token to continue
// retrieval.
func (c *OrganizationsLocationsFileStoreDataProfilesListCall) PageToken(pageToken string) *OrganizationsLocationsFileStoreDataProfilesListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *OrganizationsLocationsFileStoreDataProfilesListCall) Fields(s ...googleapi.Field) *OrganizationsLocationsFileStoreDataProfilesListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *OrganizationsLocationsFileStoreDataProfilesListCall) IfNoneMatch(entityTag string) *OrganizationsLocationsFileStoreDataProfilesListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *OrganizationsLocationsFileStoreDataProfilesListCall) Context(ctx context.Context) *OrganizationsLocationsFileStoreDataProfilesListCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *OrganizationsLocationsFileStoreDataProfilesListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *OrganizationsLocationsFileStoreDataProfilesListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v2/{+parent}/fileStoreDataProfiles")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "dlp.organizations.locations.fileStoreDataProfiles.list", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "dlp.organizations.locations.fileStoreDataProfiles.list" call.
// Any non-2xx status code is an error. Response headers are in either
// *GooglePrivacyDlpV2ListFileStoreDataProfilesResponse.ServerResponse.Header
// or (if a response was returned at all) in error.(*googleapi.Error).Header.
// Use googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *OrganizationsLocationsFileStoreDataProfilesListCall) Do(opts ...googleapi.CallOption) (*GooglePrivacyDlpV2ListFileStoreDataProfilesResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GooglePrivacyDlpV2ListFileStoreDataProfilesResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "dlp.organizations.locations.fileStoreDataProfiles.list", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *OrganizationsLocationsFileStoreDataProfilesListCall) Pages(ctx context.Context, f func(*GooglePrivacyDlpV2ListFileStoreDataProfilesResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken"))
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

type OrganizationsLocationsInfoTypesListCall struct {
	s            *Service
	parent       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Returns a list of the sensitive information types that the DLP API
// supports. See
// https://cloud.google.com/sensitive-data-protection/docs/infotypes-reference
// to learn more.
//
//   - parent: The parent resource name. The format of this value is as follows:
//     `locations/{location_id}`.
func (r *OrganizationsLocationsInfoTypesService) List(parent string) *OrganizationsLocationsInfoTypesListCall {
	c := &OrganizationsLocationsInfoTypesListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	return c
}

// Filter sets the optional parameter "filter": filter to only return infoTypes
// supported by certain parts of the API. Defaults to supported_by=INSPECT.
func (c *OrganizationsLocationsInfoTypesListCall) Filter(filter string) *OrganizationsLocationsInfoTypesListCall {
	c.urlParams_.Set("filter", filter)
	return c
}

// LanguageCode sets the optional parameter "languageCode": BCP-47 language
// code for localized infoType friendly names. If omitted, or if localized
// strings are not available, en-US strings will be returned.
func (c *OrganizationsLocationsInfoTypesListCall) LanguageCode(languageCode string) *OrganizationsLocationsInfoTypesListCall {
	c.urlParams_.Set("languageCode", languageCode)
	return c
}

// LocationId sets the optional parameter "locationId": Deprecated. This field
// has no effect.
func (c *OrganizationsLocationsInfoTypesListCall) LocationId(locationId string) *OrganizationsLocationsInfoTypesListCall {
	c.urlParams_.Set("locationId", locationId)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *OrganizationsLocationsInfoTypesListCall) Fields(s ...googleapi.Field) *OrganizationsLocationsInfoTypesListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *OrganizationsLocationsInfoTypesListCall) IfNoneMatch(entityTag string) *OrganizationsLocationsInfoTypesListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *OrganizationsLocationsInfoTypesListCall) Context(ctx context.Context) *OrganizationsLocationsInfoTypesListCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *OrganizationsLocationsInfoTypesListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *OrganizationsLocationsInfoTypesListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v2/{+parent}/infoTypes")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "dlp.organizations.locations.infoTypes.list", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "dlp.organizations.locations.infoTypes.list" call.
// Any non-2xx status code is an error. Response headers are in either
// *GooglePrivacyDlpV2ListInfoTypesResponse.ServerResponse.Header or (if a
// response was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *OrganizationsLocationsInfoTypesListCall) Do(opts ...googleapi.CallOption) (*GooglePrivacyDlpV2ListInfoTypesResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GooglePrivacyDlpV2ListInfoTypesResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "dlp.organizations.locations.infoTypes.list", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type OrganizationsLocationsInspectTemplatesCreateCall struct {
	s                                              *Service
	parentid                                       string
	googleprivacydlpv2createinspecttemplaterequest *GooglePrivacyDlpV2CreateInspectTemplateRequest
	urlParams_                                     gensupport.URLParams
	ctx_                                           context.Context
	header_                                        http.Header
}

// Create: Creates an InspectTemplate for reusing frequently used configuration
// for inspecting content, images, and storage. See
// https://cloud.google.com/sensitive-data-protection/docs/creating-templates
// to learn more.
//
//   - parent: Parent resource name. The format of this value varies depending on
//     the scope of the request (project or organization) and whether you have
//     specified a processing location
//     (https://cloud.google.com/sensitive-data-protection/docs/specifying-location):
//   - Projects scope, location specified:
//     `projects/{project_id}/locations/{location_id}` + Projects scope, no
//     location specified (defaults to global): `projects/{project_id}` +
//     Organizations scope, location specified:
//     `organizations/{org_id}/locations/{location_id}` + Organizations scope, no
//     location specified (defaults to global): `organizations/{org_id}` The
//     following example `parent` string specifies a parent project with the
//     identifier `example-project`, and specifies the `europe-west3` location
//     for processing data:
//     parent=projects/example-project/locations/europe-west3.
func (r *OrganizationsLocationsInspectTemplatesService) Create(parentid string, googleprivacydlpv2createinspecttemplaterequest *GooglePrivacyDlpV2CreateInspectTemplateRequest) *OrganizationsLocationsInspectTemplatesCreateCall {
	c := &OrganizationsLocationsInspectTemplatesCreateCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parentid = parentid
	c.googleprivacydlpv2createinspecttemplaterequest = googleprivacydlpv2createinspecttemplaterequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *OrganizationsLocationsInspectTemplatesCreateCall) Fields(s ...googleapi.Field) *OrganizationsLocationsInspectTemplatesCreateCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *OrganizationsLocationsInspectTemplatesCreateCall) Context(ctx context.Context) *OrganizationsLocationsInspectTemplatesCreateCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *OrganizationsLocationsInspectTemplatesCreateCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *OrganizationsLocationsInspectTemplatesCreateCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.googleprivacydlpv2createinspecttemplaterequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v2/{+parent}/inspectTemplates")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parentid,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "dlp.organizations.locations.inspectTemplates.create", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "dlp.organizations.locations.inspectTemplates.create" call.
// Any non-2xx status code is an error. Response headers are in either
// *GooglePrivacyDlpV2InspectTemplate.ServerResponse.Header or (if a response
// was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *OrganizationsLocationsInspectTemplatesCreateCall) Do(opts ...googleapi.CallOption) (*GooglePrivacyDlpV2InspectTemplate, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GooglePrivacyDlpV2InspectTemplate{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "dlp.organizations.locations.inspectTemplates.create", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type OrganizationsLocationsInspectTemplatesDeleteCall struct {
	s          *Service
	name       string
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Delete: Deletes an InspectTemplate. See
// https://cloud.google.com/sensitive-data-protection/docs/creating-templates
// to learn more.
//
//   - name: Resource name of the organization and inspectTemplate to be deleted,
//     for example `organizations/433245324/inspectTemplates/432452342` or
//     projects/project-id/inspectTemplates/432452342.
func (r *OrganizationsLocationsInspectTemplatesService) Delete(name string) *OrganizationsLocationsInspectTemplatesDeleteCall {
	c := &OrganizationsLocationsInspectTemplatesDeleteCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *OrganizationsLocationsInspectTemplatesDeleteCall) Fields(s ...googleapi.Field) *OrganizationsLocationsInspectTemplatesDeleteCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *OrganizationsLocationsInspectTemplatesDeleteCall) Context(ctx context.Context) *OrganizationsLocationsInspectTemplatesDeleteCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *OrganizationsLocationsInspectTemplatesDeleteCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *OrganizationsLocationsInspectTemplatesDeleteCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v2/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("DELETE", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "dlp.organizations.locations.inspectTemplates.delete", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "dlp.organizations.locations.inspectTemplates.delete" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleProtobufEmpty.ServerResponse.Header or (if a response was returned at
// all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified was
// returned.
func (c *OrganizationsLocationsInspectTemplatesDeleteCall) Do(opts ...googleapi.CallOption) (*GoogleProtobufEmpty, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleProtobufEmpty{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "dlp.organizations.locations.inspectTemplates.delete", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type OrganizationsLocationsInspectTemplatesGetCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Gets an InspectTemplate. See
// https://cloud.google.com/sensitive-data-protection/docs/creating-templates
// to learn more.
//
//   - name: Resource name of the organization and inspectTemplate to be read,
//     for example `organizations/433245324/inspectTemplates/432452342` or
//     projects/project-id/inspectTemplates/432452342.
func (r *OrganizationsLocationsInspectTemplatesService) Get(name string) *OrganizationsLocationsInspectTemplatesGetCall {
	c := &OrganizationsLocationsInspectTemplatesGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *OrganizationsLocationsInspectTemplatesGetCall) Fields(s ...googleapi.Field) *OrganizationsLocationsInspectTemplatesGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *OrganizationsLocationsInspectTemplatesGetCall) IfNoneMatch(entityTag string) *OrganizationsLocationsInspectTemplatesGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *OrganizationsLocationsInspectTemplatesGetCall) Context(ctx context.Context) *OrganizationsLocationsInspectTemplatesGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *OrganizationsLocationsInspectTemplatesGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *OrganizationsLocationsInspectTemplatesGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v2/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "dlp.organizations.locations.inspectTemplates.get", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "dlp.organizations.locations.inspectTemplates.get" call.
// Any non-2xx status code is an error. Response headers are in either
// *GooglePrivacyDlpV2InspectTemplate.ServerResponse.Header or (if a response
// was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *OrganizationsLocationsInspectTemplatesGetCall) Do(opts ...googleapi.CallOption) (*GooglePrivacyDlpV2InspectTemplate, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GooglePrivacyDlpV2InspectTemplate{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "dlp.organizations.locations.inspectTemplates.get", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type OrganizationsLocationsInspectTemplatesListCall struct {
	s            *Service
	parentid     string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Lists InspectTemplates. See
// https://cloud.google.com/sensitive-data-protection/docs/creating-templates
// to learn more.
//
//   - parent: Parent resource name. The format of this value varies depending on
//     the scope of the request (project or organization) and whether you have
//     specified a processing location
//     (https://cloud.google.com/sensitive-data-protection/docs/specifying-location):
//   - Projects scope, location specified:
//     `projects/{project_id}/locations/{location_id}` + Projects scope, no
//     location specified (defaults to global): `projects/{project_id}` +
//     Organizations scope, location specified:
//     `organizations/{org_id}/locations/{location_id}` + Organizations scope, no
//     location specified (defaults to global): `organizations/{org_id}` The
//     following example `parent` string specifies a parent project with the
//     identifier `example-project`, and specifies the `europe-west3` location
//     for processing data:
//     parent=projects/example-project/locations/europe-west3.
func (r *OrganizationsLocationsInspectTemplatesService) List(parentid string) *OrganizationsLocationsInspectTemplatesListCall {
	c := &OrganizationsLocationsInspectTemplatesListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parentid = parentid
	return c
}

// LocationId sets the optional parameter "locationId": Deprecated. This field
// has no effect.
func (c *OrganizationsLocationsInspectTemplatesListCall) LocationId(locationId string) *OrganizationsLocationsInspectTemplatesListCall {
	c.urlParams_.Set("locationId", locationId)
	return c
}

// OrderBy sets the optional parameter "orderBy": Comma-separated list of
// fields to order by, followed by `asc` or `desc` postfix. This list is case
// insensitive. The default sorting order is ascending. Redundant space
// characters are insignificant. Example: `name asc,update_time, create_time
// desc` Supported fields are: - `create_time`: corresponds to the time the
// template was created. - `update_time`: corresponds to the time the template
// was last updated. - `name`: corresponds to the template's name. -
// `display_name`: corresponds to the template's display name.
func (c *OrganizationsLocationsInspectTemplatesListCall) OrderBy(orderBy string) *OrganizationsLocationsInspectTemplatesListCall {
	c.urlParams_.Set("orderBy", orderBy)
	return c
}

// PageSize sets the optional parameter "pageSize": Size of the page. This
// value can be limited by the server. If zero server returns a page of max
// size 100.
func (c *OrganizationsLocationsInspectTemplatesListCall) PageSize(pageSize int64) *OrganizationsLocationsInspectTemplatesListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": Page token to continue
// retrieval. Comes from the previous call to `ListInspectTemplates`.
func (c *OrganizationsLocationsInspectTemplatesListCall) PageToken(pageToken string) *OrganizationsLocationsInspectTemplatesListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *OrganizationsLocationsInspectTemplatesListCall) Fields(s ...googleapi.Field) *OrganizationsLocationsInspectTemplatesListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *OrganizationsLocationsInspectTemplatesListCall) IfNoneMatch(entityTag string) *OrganizationsLocationsInspectTemplatesListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *OrganizationsLocationsInspectTemplatesListCall) Context(ctx context.Context) *OrganizationsLocationsInspectTemplatesListCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *OrganizationsLocationsInspectTemplatesListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *OrganizationsLocationsInspectTemplatesListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v2/{+parent}/inspectTemplates")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parentid,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "dlp.organizations.locations.inspectTemplates.list", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "dlp.organizations.locations.inspectTemplates.list" call.
// Any non-2xx status code is an error. Response headers are in either
// *GooglePrivacyDlpV2ListInspectTemplatesResponse.ServerResponse.Header or (if
// a response was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *OrganizationsLocationsInspectTemplatesListCall) Do(opts ...googleapi.CallOption) (*GooglePrivacyDlpV2ListInspectTemplatesResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GooglePrivacyDlpV2ListInspectTemplatesResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "dlp.organizations.locations.inspectTemplates.list", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *OrganizationsLocationsInspectTemplatesListCall) Pages(ctx context.Context, f func(*GooglePrivacyDlpV2ListInspectTemplatesResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken"))
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

type OrganizationsLocationsInspectTemplatesPatchCall struct {
	s                                              *Service
	name                                           string
	googleprivacydlpv2updateinspecttemplaterequest *GooglePrivacyDlpV2UpdateInspectTemplateRequest
	urlParams_                                     gensupport.URLParams
	ctx_                                           context.Context
	header_                                        http.Header
}

// Patch: Updates the InspectTemplate. See
// https://cloud.google.com/sensitive-data-protection/docs/creating-templates
// to learn more.
//
//   - name: Resource name of organization and inspectTemplate to be updated, for
//     example `organizations/433245324/inspectTemplates/432452342` or
//     projects/project-id/inspectTemplates/432452342.
func (r *OrganizationsLocationsInspectTemplatesService) Patch(name string, googleprivacydlpv2updateinspecttemplaterequest *GooglePrivacyDlpV2UpdateInspectTemplateRequest) *OrganizationsLocationsInspectTemplatesPatchCall {
	c := &OrganizationsLocationsInspectTemplatesPatchCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.googleprivacydlpv2updateinspecttemplaterequest = googleprivacydlpv2updateinspecttemplaterequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *OrganizationsLocationsInspectTemplatesPatchCall) Fields(s ...googleapi.Field) *OrganizationsLocationsInspectTemplatesPatchCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *OrganizationsLocationsInspectTemplatesPatchCall) Context(ctx context.Context) *OrganizationsLocationsInspectTemplatesPatchCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *OrganizationsLocationsInspectTemplatesPatchCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *OrganizationsLocationsInspectTemplatesPatchCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.googleprivacydlpv2updateinspecttemplaterequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v2/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("PATCH", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "dlp.organizations.locations.inspectTemplates.patch", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "dlp.organizations.locations.inspectTemplates.patch" call.
// Any non-2xx status code is an error. Response headers are in either
// *GooglePrivacyDlpV2InspectTemplate.ServerResponse.Header or (if a response
// was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *OrganizationsLocationsInspectTemplatesPatchCall) Do(opts ...googleapi.CallOption) (*GooglePrivacyDlpV2InspectTemplate, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GooglePrivacyDlpV2InspectTemplate{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "dlp.organizations.locations.inspectTemplates.patch", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type OrganizationsLocationsJobTriggersCreateCall struct {
	s                                         *Service
	parentid                                  string
	googleprivacydlpv2createjobtriggerrequest *GooglePrivacyDlpV2CreateJobTriggerRequest
	urlParams_                                gensupport.URLParams
	ctx_                                      context.Context
	header_                                   http.Header
}

// Create: Creates a job trigger to run DLP actions such as scanning storage
// for sensitive information on a set schedule. See
// https://cloud.google.com/sensitive-data-protection/docs/creating-job-triggers
// to learn more.
//
//   - parent: Parent resource name. The format of this value varies depending on
//     whether you have specified a processing location
//     (https://cloud.google.com/sensitive-data-protection/docs/specifying-location):
//   - Projects scope, location specified:
//     `projects/{project_id}/locations/{location_id}` + Projects scope, no
//     location specified (defaults to global): `projects/{project_id}` The
//     following example `parent` string specifies a parent project with the
//     identifier `example-project`, and specifies the `europe-west3` location
//     for processing data:
//     parent=projects/example-project/locations/europe-west3.
func (r *OrganizationsLocationsJobTriggersService) Create(parentid string, googleprivacydlpv2createjobtriggerrequest *GooglePrivacyDlpV2CreateJobTriggerRequest) *OrganizationsLocationsJobTriggersCreateCall {
	c := &OrganizationsLocationsJobTriggersCreateCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parentid = parentid
	c.googleprivacydlpv2createjobtriggerrequest = googleprivacydlpv2createjobtriggerrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *OrganizationsLocationsJobTriggersCreateCall) Fields(s ...googleapi.Field) *OrganizationsLocationsJobTriggersCreateCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *OrganizationsLocationsJobTriggersCreateCall) Context(ctx context.Context) *OrganizationsLocationsJobTriggersCreateCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *OrganizationsLocationsJobTriggersCreateCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *OrganizationsLocationsJobTriggersCreateCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.googleprivacydlpv2createjobtriggerrequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v2/{+parent}/jobTriggers")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parentid,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "dlp.organizations.locations.jobTriggers.create", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "dlp.organizations.locations.jobTriggers.create" call.
// Any non-2xx status code is an error. Response headers are in either
// *GooglePrivacyDlpV2JobTrigger.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *OrganizationsLocationsJobTriggersCreateCall) Do(opts ...googleapi.CallOption) (*GooglePrivacyDlpV2JobTrigger, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GooglePrivacyDlpV2JobTrigger{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "dlp.organizations.locations.jobTriggers.create", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type OrganizationsLocationsJobTriggersDeleteCall struct {
	s          *Service
	name       string
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Delete: Deletes a job trigger. See
// https://cloud.google.com/sensitive-data-protection/docs/creating-job-triggers
// to learn more.
//
//   - name: Resource name of the project and the triggeredJob, for example
//     `projects/dlp-test-project/jobTriggers/53234423`.
func (r *OrganizationsLocationsJobTriggersService) Delete(name string) *OrganizationsLocationsJobTriggersDeleteCall {
	c := &OrganizationsLocationsJobTriggersDeleteCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *OrganizationsLocationsJobTriggersDeleteCall) Fields(s ...googleapi.Field) *OrganizationsLocationsJobTriggersDeleteCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *OrganizationsLocationsJobTriggersDeleteCall) Context(ctx context.Context) *OrganizationsLocationsJobTriggersDeleteCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *OrganizationsLocationsJobTriggersDeleteCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *OrganizationsLocationsJobTriggersDeleteCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v2/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("DELETE", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "dlp.organizations.locations.jobTriggers.delete", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "dlp.organizations.locations.jobTriggers.delete" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleProtobufEmpty.ServerResponse.Header or (if a response was returned at
// all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified was
// returned.
func (c *OrganizationsLocationsJobTriggersDeleteCall) Do(opts ...googleapi.CallOption) (*GoogleProtobufEmpty, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleProtobufEmpty{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "dlp.organizations.locations.jobTriggers.delete", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type OrganizationsLocationsJobTriggersGetCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Gets a job trigger. See
// https://cloud.google.com/sensitive-data-protection/docs/creating-job-triggers
// to learn more.
//
//   - name: Resource name of the project and the triggeredJob, for example
//     `projects/dlp-test-project/jobTriggers/53234423`.
func (r *OrganizationsLocationsJobTriggersService) Get(name string) *OrganizationsLocationsJobTriggersGetCall {
	c := &OrganizationsLocationsJobTriggersGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *OrganizationsLocationsJobTriggersGetCall) Fields(s ...googleapi.Field) *OrganizationsLocationsJobTriggersGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *OrganizationsLocationsJobTriggersGetCall) IfNoneMatch(entityTag string) *OrganizationsLocationsJobTriggersGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *OrganizationsLocationsJobTriggersGetCall) Context(ctx context.Context) *OrganizationsLocationsJobTriggersGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *OrganizationsLocationsJobTriggersGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *OrganizationsLocationsJobTriggersGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v2/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "dlp.organizations.locations.jobTriggers.get", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "dlp.organizations.locations.jobTriggers.get" call.
// Any non-2xx status code is an error. Response headers are in either
// *GooglePrivacyDlpV2JobTrigger.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *OrganizationsLocationsJobTriggersGetCall) Do(opts ...googleapi.CallOption) (*GooglePrivacyDlpV2JobTrigger, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GooglePrivacyDlpV2JobTrigger{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "dlp.organizations.locations.jobTriggers.get", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type OrganizationsLocationsJobTriggersListCall struct {
	s            *Service
	parentid     string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Lists job triggers. See
// https://cloud.google.com/sensitive-data-protection/docs/creating-job-triggers
// to learn more.
//
//   - parent: Parent resource name. The format of this value varies depending on
//     whether you have specified a processing location
//     (https://cloud.google.com/sensitive-data-protection/docs/specifying-location):
//   - Projects scope, location specified:
//     `projects/{project_id}/locations/{location_id}` + Projects scope, no
//     location specified (defaults to global): `projects/{project_id}` The
//     following example `parent` string specifies a parent project with the
//     identifier `example-project`, and specifies the `europe-west3` location
//     for processing data:
//     parent=projects/example-project/locations/europe-west3.
func (r *OrganizationsLocationsJobTriggersService) List(parentid string) *OrganizationsLocationsJobTriggersListCall {
	c := &OrganizationsLocationsJobTriggersListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parentid = parentid
	return c
}

// Filter sets the optional parameter "filter": Allows filtering. Supported
// syntax: * Filter expressions are made up of one or more restrictions. *
// Restrictions can be combined by `AND` or `OR` logical operators. A sequence
// of restrictions implicitly uses `AND`. * A restriction has the form of
// `{field} {operator} {value}`. * Supported fields/values for inspect
// triggers: - `status` - HEALTHY|PAUSED|CANCELLED - `inspected_storage` -
// DATASTORE|CLOUD_STORAGE|BIGQUERY - 'last_run_time` - RFC 3339 formatted
// timestamp, surrounded by quotation marks. Nanoseconds are ignored. -
// 'error_count' - Number of errors that have occurred while running. * The
// operator must be `=` or `!=` for status and inspected_storage. The syntax is
// based on https://google.aip.dev/160. Examples: * inspected_storage =
// cloud_storage AND status = HEALTHY * inspected_storage = cloud_storage OR
// inspected_storage = bigquery * inspected_storage = cloud_storage AND (state
// = PAUSED OR state = HEALTHY) * last_run_time > \"2017-12-12T00:00:00+00:00\"
// The length of this field should be no more than 500 characters.
func (c *OrganizationsLocationsJobTriggersListCall) Filter(filter string) *OrganizationsLocationsJobTriggersListCall {
	c.urlParams_.Set("filter", filter)
	return c
}

// LocationId sets the optional parameter "locationId": Deprecated. This field
// has no effect.
func (c *OrganizationsLocationsJobTriggersListCall) LocationId(locationId string) *OrganizationsLocationsJobTriggersListCall {
	c.urlParams_.Set("locationId", locationId)
	return c
}

// OrderBy sets the optional parameter "orderBy": Comma-separated list of
// triggeredJob fields to order by, followed by `asc` or `desc` postfix. This
// list is case insensitive. The default sorting order is ascending. Redundant
// space characters are insignificant. Example: `name asc,update_time,
// create_time desc` Supported fields are: - `create_time`: corresponds to the
// time the JobTrigger was created. - `update_time`: corresponds to the time
// the JobTrigger was last updated. - `last_run_time`: corresponds to the last
// time the JobTrigger ran. - `name`: corresponds to the JobTrigger's name. -
// `display_name`: corresponds to the JobTrigger's display name. - `status`:
// corresponds to JobTrigger's status.
func (c *OrganizationsLocationsJobTriggersListCall) OrderBy(orderBy string) *OrganizationsLocationsJobTriggersListCall {
	c.urlParams_.Set("orderBy", orderBy)
	return c
}

// PageSize sets the optional parameter "pageSize": Size of the page. This
// value can be limited by a server.
func (c *OrganizationsLocationsJobTriggersListCall) PageSize(pageSize int64) *OrganizationsLocationsJobTriggersListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": Page token to continue
// retrieval. Comes from the previous call to ListJobTriggers. `order_by` field
// must not change for subsequent calls.
func (c *OrganizationsLocationsJobTriggersListCall) PageToken(pageToken string) *OrganizationsLocationsJobTriggersListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Type sets the optional parameter "type": The type of jobs. Will use
// `DlpJobType.INSPECT` if not set.
//
// Possible values:
//
//	"DLP_JOB_TYPE_UNSPECIFIED" - Defaults to INSPECT_JOB.
//	"INSPECT_JOB" - The job inspected Google Cloud for sensitive data.
//	"RISK_ANALYSIS_JOB" - The job executed a Risk Analysis computation.
func (c *OrganizationsLocationsJobTriggersListCall) Type(type_ string) *OrganizationsLocationsJobTriggersListCall {
	c.urlParams_.Set("type", type_)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *OrganizationsLocationsJobTriggersListCall) Fields(s ...googleapi.Field) *OrganizationsLocationsJobTriggersListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *OrganizationsLocationsJobTriggersListCall) IfNoneMatch(entityTag string) *OrganizationsLocationsJobTriggersListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *OrganizationsLocationsJobTriggersListCall) Context(ctx context.Context) *OrganizationsLocationsJobTriggersListCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *OrganizationsLocationsJobTriggersListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *OrganizationsLocationsJobTriggersListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v2/{+parent}/jobTriggers")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parentid,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "dlp.organizations.locations.jobTriggers.list", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "dlp.organizations.locations.jobTriggers.list" call.
// Any non-2xx status code is an error. Response headers are in either
// *GooglePrivacyDlpV2ListJobTriggersResponse.ServerResponse.Header or (if a
// response was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *OrganizationsLocationsJobTriggersListCall) Do(opts ...googleapi.CallOption) (*GooglePrivacyDlpV2ListJobTriggersResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GooglePrivacyDlpV2ListJobTriggersResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "dlp.organizations.locations.jobTriggers.list", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *OrganizationsLocationsJobTriggersListCall) Pages(ctx context.Context, f func(*GooglePrivacyDlpV2ListJobTriggersResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken"))
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

type OrganizationsLocationsJobTriggersPatchCall struct {
	s                                         *Service
	name                                      string
	googleprivacydlpv2updatejobtriggerrequest *GooglePrivacyDlpV2UpdateJobTriggerRequest
	urlParams_                                gensupport.URLParams
	ctx_                                      context.Context
	header_                                   http.Header
}

// Patch: Updates a job trigger. See
// https://cloud.google.com/sensitive-data-protection/docs/creating-job-triggers
// to learn more.
//
//   - name: Resource name of the project and the triggeredJob, for example
//     `projects/dlp-test-project/jobTriggers/53234423`.
func (r *OrganizationsLocationsJobTriggersService) Patch(name string, googleprivacydlpv2updatejobtriggerrequest *GooglePrivacyDlpV2UpdateJobTriggerRequest) *OrganizationsLocationsJobTriggersPatchCall {
	c := &OrganizationsLocationsJobTriggersPatchCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.googleprivacydlpv2updatejobtriggerrequest = googleprivacydlpv2updatejobtriggerrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *OrganizationsLocationsJobTriggersPatchCall) Fields(s ...googleapi.Field) *OrganizationsLocationsJobTriggersPatchCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *OrganizationsLocationsJobTriggersPatchCall) Context(ctx context.Context) *OrganizationsLocationsJobTriggersPatchCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *OrganizationsLocationsJobTriggersPatchCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *OrganizationsLocationsJobTriggersPatchCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.googleprivacydlpv2updatejobtriggerrequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v2/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("PATCH", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "dlp.organizations.locations.jobTriggers.patch", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "dlp.organizations.locations.jobTriggers.patch" call.
// Any non-2xx status code is an error. Response headers are in either
// *GooglePrivacyDlpV2JobTrigger.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *OrganizationsLocationsJobTriggersPatchCall) Do(opts ...googleapi.CallOption) (*GooglePrivacyDlpV2JobTrigger, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GooglePrivacyDlpV2JobTrigger{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "dlp.organizations.locations.jobTriggers.patch", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type OrganizationsLocationsProjectDataProfilesGetCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Gets a project data profile.
//
//   - name: Resource name, for example
//     `organizations/12345/locations/us/projectDataProfiles/53234423`.
func (r *OrganizationsLocationsProjectDataProfilesService) Get(name string) *OrganizationsLocationsProjectDataProfilesGetCall {
	c := &OrganizationsLocationsProjectDataProfilesGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *OrganizationsLocationsProjectDataProfilesGetCall) Fields(s ...googleapi.Field) *OrganizationsLocationsProjectDataProfilesGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *OrganizationsLocationsProjectDataProfilesGetCall) IfNoneMatch(entityTag string) *OrganizationsLocationsProjectDataProfilesGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *OrganizationsLocationsProjectDataProfilesGetCall) Context(ctx context.Context) *OrganizationsLocationsProjectDataProfilesGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *OrganizationsLocationsProjectDataProfilesGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *OrganizationsLocationsProjectDataProfilesGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v2/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "dlp.organizations.locations.projectDataProfiles.get", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "dlp.organizations.locations.projectDataProfiles.get" call.
// Any non-2xx status code is an error. Response headers are in either
// *GooglePrivacyDlpV2ProjectDataProfile.ServerResponse.Header or (if a
// response was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *OrganizationsLocationsProjectDataProfilesGetCall) Do(opts ...googleapi.CallOption) (*GooglePrivacyDlpV2ProjectDataProfile, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GooglePrivacyDlpV2ProjectDataProfile{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "dlp.organizations.locations.projectDataProfiles.get", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type OrganizationsLocationsProjectDataProfilesListCall struct {
	s            *Service
	parent       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Lists project data profiles for an organization.
//
// - parent: organizations/{org_id}/locations/{loc_id}.
func (r *OrganizationsLocationsProjectDataProfilesService) List(parent string) *OrganizationsLocationsProjectDataProfilesListCall {
	c := &OrganizationsLocationsProjectDataProfilesListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	return c
}

// Filter sets the optional parameter "filter": Allows filtering. Supported
// syntax: * Filter expressions are made up of one or more restrictions. *
// Restrictions can be combined by `AND` or `OR` logical operators. A sequence
// of restrictions implicitly uses `AND`. * A restriction has the form of
// `{field} {operator} {value}`. * Supported fields: - `project_id`: the Google
// Cloud project ID - `sensitivity_level`: HIGH|MODERATE|LOW -
// `data_risk_level`: HIGH|MODERATE|LOW - `status_code`: an RPC status code as
// defined in
// https://github.com/googleapis/googleapis/blob/master/google/rpc/code.proto -
// `profile_last_generated`: Date and time the profile was last generated * The
// operator must be `=` or `!=`. The `profile_last_generated` filter also
// supports `<` and `>`. The syntax is based on https://google.aip.dev/160.
// Examples: * `project_id = 12345 AND status_code = 1` * `project_id = 12345
// AND sensitivity_level = HIGH` * `profile_last_generated <
// "2025-01-01T00:00:00.000Z" The length of this field should be no more than
// 500 characters.
func (c *OrganizationsLocationsProjectDataProfilesListCall) Filter(filter string) *OrganizationsLocationsProjectDataProfilesListCall {
	c.urlParams_.Set("filter", filter)
	return c
}

// OrderBy sets the optional parameter "orderBy": Comma-separated list of
// fields to order by, followed by `asc` or `desc` postfix. This list is case
// insensitive. The default sorting order is ascending. Redundant space
// characters are insignificant. Only one order field at a time is allowed.
// Examples: * `project_id` * `sensitivity_level desc` Supported fields: -
// `project_id`: Google Cloud project ID - `sensitivity_level`: How sensitive
// the data in a project is, at most - `data_risk_level`: How much risk is
// associated with this data - `profile_last_generated`: Date and time (in
// epoch seconds) the profile was last generated
func (c *OrganizationsLocationsProjectDataProfilesListCall) OrderBy(orderBy string) *OrganizationsLocationsProjectDataProfilesListCall {
	c.urlParams_.Set("orderBy", orderBy)
	return c
}

// PageSize sets the optional parameter "pageSize": Size of the page. This
// value can be limited by the server. If zero, server returns a page of max
// size 100.
func (c *OrganizationsLocationsProjectDataProfilesListCall) PageSize(pageSize int64) *OrganizationsLocationsProjectDataProfilesListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": Page token to continue
// retrieval.
func (c *OrganizationsLocationsProjectDataProfilesListCall) PageToken(pageToken string) *OrganizationsLocationsProjectDataProfilesListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *OrganizationsLocationsProjectDataProfilesListCall) Fields(s ...googleapi.Field) *OrganizationsLocationsProjectDataProfilesListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *OrganizationsLocationsProjectDataProfilesListCall) IfNoneMatch(entityTag string) *OrganizationsLocationsProjectDataProfilesListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *OrganizationsLocationsProjectDataProfilesListCall) Context(ctx context.Context) *OrganizationsLocationsProjectDataProfilesListCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *OrganizationsLocationsProjectDataProfilesListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *OrganizationsLocationsProjectDataProfilesListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v2/{+parent}/projectDataProfiles")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "dlp.organizations.locations.projectDataProfiles.list", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "dlp.organizations.locations.projectDataProfiles.list" call.
// Any non-2xx status code is an error. Response headers are in either
// *GooglePrivacyDlpV2ListProjectDataProfilesResponse.ServerResponse.Header or
// (if a response was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *OrganizationsLocationsProjectDataProfilesListCall) Do(opts ...googleapi.CallOption) (*GooglePrivacyDlpV2ListProjectDataProfilesResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GooglePrivacyDlpV2ListProjectDataProfilesResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "dlp.organizations.locations.projectDataProfiles.list", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *OrganizationsLocationsProjectDataProfilesListCall) Pages(ctx context.Context, f func(*GooglePrivacyDlpV2ListProjectDataProfilesResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken"))
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

type OrganizationsLocationsStoredInfoTypesCreateCall struct {
	s                                             *Service
	parentid                                      string
	googleprivacydlpv2createstoredinfotyperequest *GooglePrivacyDlpV2CreateStoredInfoTypeRequest
	urlParams_                                    gensupport.URLParams
	ctx_                                          context.Context
	header_                                       http.Header
}

// Create: Creates a pre-built stored infoType to be used for inspection. See
// https://cloud.google.com/sensitive-data-protection/docs/creating-stored-infotypes
// to learn more.
//
//   - parent: Parent resource name. The format of this value varies depending on
//     the scope of the request (project or organization) and whether you have
//     specified a processing location
//     (https://cloud.google.com/sensitive-data-protection/docs/specifying-location):
//   - Projects scope, location specified:
//     `projects/{project_id}/locations/{location_id}` + Projects scope, no
//     location specified (defaults to global): `projects/{project_id}` +
//     Organizations scope, location specified:
//     `organizations/{org_id}/locations/{location_id}` + Organizations scope, no
//     location specified (defaults to global): `organizations/{org_id}` The
//     following example `parent` string specifies a parent project with the
//     identifier `example-project`, and specifies the `europe-west3` location
//     for processing data:
//     parent=projects/example-project/locations/europe-west3.
func (r *OrganizationsLocationsStoredInfoTypesService) Create(parentid string, googleprivacydlpv2createstoredinfotyperequest *GooglePrivacyDlpV2CreateStoredInfoTypeRequest) *OrganizationsLocationsStoredInfoTypesCreateCall {
	c := &OrganizationsLocationsStoredInfoTypesCreateCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parentid = parentid
	c.googleprivacydlpv2createstoredinfotyperequest = googleprivacydlpv2createstoredinfotyperequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *OrganizationsLocationsStoredInfoTypesCreateCall) Fields(s ...googleapi.Field) *OrganizationsLocationsStoredInfoTypesCreateCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *OrganizationsLocationsStoredInfoTypesCreateCall) Context(ctx context.Context) *OrganizationsLocationsStoredInfoTypesCreateCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *OrganizationsLocationsStoredInfoTypesCreateCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *OrganizationsLocationsStoredInfoTypesCreateCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.googleprivacydlpv2createstoredinfotyperequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v2/{+parent}/storedInfoTypes")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parentid,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "dlp.organizations.locations.storedInfoTypes.create", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "dlp.organizations.locations.storedInfoTypes.create" call.
// Any non-2xx status code is an error. Response headers are in either
// *GooglePrivacyDlpV2StoredInfoType.ServerResponse.Header or (if a response
// was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *OrganizationsLocationsStoredInfoTypesCreateCall) Do(opts ...googleapi.CallOption) (*GooglePrivacyDlpV2StoredInfoType, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GooglePrivacyDlpV2StoredInfoType{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "dlp.organizations.locations.storedInfoTypes.create", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type OrganizationsLocationsStoredInfoTypesDeleteCall struct {
	s          *Service
	name       string
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Delete: Deletes a stored infoType. See
// https://cloud.google.com/sensitive-data-protection/docs/creating-stored-infotypes
// to learn more.
//
//   - name: Resource name of the organization and storedInfoType to be deleted,
//     for example `organizations/433245324/storedInfoTypes/432452342` or
//     projects/project-id/storedInfoTypes/432452342.
func (r *OrganizationsLocationsStoredInfoTypesService) Delete(name string) *OrganizationsLocationsStoredInfoTypesDeleteCall {
	c := &OrganizationsLocationsStoredInfoTypesDeleteCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *OrganizationsLocationsStoredInfoTypesDeleteCall) Fields(s ...googleapi.Field) *OrganizationsLocationsStoredInfoTypesDeleteCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *OrganizationsLocationsStoredInfoTypesDeleteCall) Context(ctx context.Context) *OrganizationsLocationsStoredInfoTypesDeleteCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *OrganizationsLocationsStoredInfoTypesDeleteCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *OrganizationsLocationsStoredInfoTypesDeleteCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v2/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("DELETE", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "dlp.organizations.locations.storedInfoTypes.delete", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "dlp.organizations.locations.storedInfoTypes.delete" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleProtobufEmpty.ServerResponse.Header or (if a response was returned at
// all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified was
// returned.
func (c *OrganizationsLocationsStoredInfoTypesDeleteCall) Do(opts ...googleapi.CallOption) (*GoogleProtobufEmpty, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleProtobufEmpty{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "dlp.organizations.locations.storedInfoTypes.delete", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type OrganizationsLocationsStoredInfoTypesGetCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Gets a stored infoType. See
// https://cloud.google.com/sensitive-data-protection/docs/creating-stored-infotypes
// to learn more.
//
//   - name: Resource name of the organization and storedInfoType to be read, for
//     example `organizations/433245324/storedInfoTypes/432452342` or
//     projects/project-id/storedInfoTypes/432452342.
func (r *OrganizationsLocationsStoredInfoTypesService) Get(name string) *OrganizationsLocationsStoredInfoTypesGetCall {
	c := &OrganizationsLocationsStoredInfoTypesGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *OrganizationsLocationsStoredInfoTypesGetCall) Fields(s ...googleapi.Field) *OrganizationsLocationsStoredInfoTypesGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *OrganizationsLocationsStoredInfoTypesGetCall) IfNoneMatch(entityTag string) *OrganizationsLocationsStoredInfoTypesGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *OrganizationsLocationsStoredInfoTypesGetCall) Context(ctx context.Context) *OrganizationsLocationsStoredInfoTypesGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *OrganizationsLocationsStoredInfoTypesGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *OrganizationsLocationsStoredInfoTypesGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v2/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "dlp.organizations.locations.storedInfoTypes.get", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "dlp.organizations.locations.storedInfoTypes.get" call.
// Any non-2xx status code is an error. Response headers are in either
// *GooglePrivacyDlpV2StoredInfoType.ServerResponse.Header or (if a response
// was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *OrganizationsLocationsStoredInfoTypesGetCall) Do(opts ...googleapi.CallOption) (*GooglePrivacyDlpV2StoredInfoType, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GooglePrivacyDlpV2StoredInfoType{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "dlp.organizations.locations.storedInfoTypes.get", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type OrganizationsLocationsStoredInfoTypesListCall struct {
	s            *Service
	parentid     string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Lists stored infoTypes. See
// https://cloud.google.com/sensitive-data-protection/docs/creating-stored-infotypes
// to learn more.
//
//   - parent: Parent resource name. The format of this value varies depending on
//     the scope of the request (project or organization) and whether you have
//     specified a processing location
//     (https://cloud.google.com/sensitive-data-protection/docs/specifying-location):
//   - Projects scope, location specified:
//     `projects/{project_id}/locations/{location_id}` + Projects scope, no
//     location specified (defaults to global): `projects/{project_id}` The
//     following example `parent` string specifies a parent project with the
//     identifier `example-project`, and specifies the `europe-west3` location
//     for processing data:
//     parent=projects/example-project/locations/europe-west3.
func (r *OrganizationsLocationsStoredInfoTypesService) List(parentid string) *OrganizationsLocationsStoredInfoTypesListCall {
	c := &OrganizationsLocationsStoredInfoTypesListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parentid = parentid
	return c
}

// LocationId sets the optional parameter "locationId": Deprecated. This field
// has no effect.
func (c *OrganizationsLocationsStoredInfoTypesListCall) LocationId(locationId string) *OrganizationsLocationsStoredInfoTypesListCall {
	c.urlParams_.Set("locationId", locationId)
	return c
}

// OrderBy sets the optional parameter "orderBy": Comma-separated list of
// fields to order by, followed by `asc` or `desc` postfix. This list is case
// insensitive. The default sorting order is ascending. Redundant space
// characters are insignificant. Example: `name asc, display_name, create_time
// desc` Supported fields are: - `create_time`: corresponds to the time the
// most recent version of the resource was created. - `state`: corresponds to
// the state of the resource. - `name`: corresponds to resource name. -
// `display_name`: corresponds to info type's display name.
func (c *OrganizationsLocationsStoredInfoTypesListCall) OrderBy(orderBy string) *OrganizationsLocationsStoredInfoTypesListCall {
	c.urlParams_.Set("orderBy", orderBy)
	return c
}

// PageSize sets the optional parameter "pageSize": Size of the page. This
// value can be limited by the server. If zero server returns a page of max
// size 100.
func (c *OrganizationsLocationsStoredInfoTypesListCall) PageSize(pageSize int64) *OrganizationsLocationsStoredInfoTypesListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": Page token to continue
// retrieval. Comes from the previous call to `ListStoredInfoTypes`.
func (c *OrganizationsLocationsStoredInfoTypesListCall) PageToken(pageToken string) *OrganizationsLocationsStoredInfoTypesListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *OrganizationsLocationsStoredInfoTypesListCall) Fields(s ...googleapi.Field) *OrganizationsLocationsStoredInfoTypesListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *OrganizationsLocationsStoredInfoTypesListCall) IfNoneMatch(entityTag string) *OrganizationsLocationsStoredInfoTypesListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *OrganizationsLocationsStoredInfoTypesListCall) Context(ctx context.Context) *OrganizationsLocationsStoredInfoTypesListCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *OrganizationsLocationsStoredInfoTypesListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *OrganizationsLocationsStoredInfoTypesListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v2/{+parent}/storedInfoTypes")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parentid,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "dlp.organizations.locations.storedInfoTypes.list", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "dlp.organizations.locations.storedInfoTypes.list" call.
// Any non-2xx status code is an error. Response headers are in either
// *GooglePrivacyDlpV2ListStoredInfoTypesResponse.ServerResponse.Header or (if
// a response was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *OrganizationsLocationsStoredInfoTypesListCall) Do(opts ...googleapi.CallOption) (*GooglePrivacyDlpV2ListStoredInfoTypesResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GooglePrivacyDlpV2ListStoredInfoTypesResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "dlp.organizations.locations.storedInfoTypes.list", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *OrganizationsLocationsStoredInfoTypesListCall) Pages(ctx context.Context, f func(*GooglePrivacyDlpV2ListStoredInfoTypesResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken"))
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

type OrganizationsLocationsStoredInfoTypesPatchCall struct {
	s                                             *Service
	name                                          string
	googleprivacydlpv2updatestoredinfotyperequest *GooglePrivacyDlpV2UpdateStoredInfoTypeRequest
	urlParams_                                    gensupport.URLParams
	ctx_                                          context.Context
	header_                                       http.Header
}

// Patch: Updates the stored infoType by creating a new version. The existing
// version will continue to be used until the new version is ready. See
// https://cloud.google.com/sensitive-data-protection/docs/creating-stored-infotypes
// to learn more.
//
//   - name: Resource name of organization and storedInfoType to be updated, for
//     example `organizations/433245324/storedInfoTypes/432452342` or
//     projects/project-id/storedInfoTypes/432452342.
func (r *OrganizationsLocationsStoredInfoTypesService) Patch(name string, googleprivacydlpv2updatestoredinfotyperequest *GooglePrivacyDlpV2UpdateStoredInfoTypeRequest) *OrganizationsLocationsStoredInfoTypesPatchCall {
	c := &OrganizationsLocationsStoredInfoTypesPatchCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.googleprivacydlpv2updatestoredinfotyperequest = googleprivacydlpv2updatestoredinfotyperequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *OrganizationsLocationsStoredInfoTypesPatchCall) Fields(s ...googleapi.Field) *OrganizationsLocationsStoredInfoTypesPatchCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *OrganizationsLocationsStoredInfoTypesPatchCall) Context(ctx context.Context) *OrganizationsLocationsStoredInfoTypesPatchCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *OrganizationsLocationsStoredInfoTypesPatchCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *OrganizationsLocationsStoredInfoTypesPatchCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.googleprivacydlpv2updatestoredinfotyperequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v2/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("PATCH", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "dlp.organizations.locations.storedInfoTypes.patch", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "dlp.organizations.locations.storedInfoTypes.patch" call.
// Any non-2xx status code is an error. Response headers are in either
// *GooglePrivacyDlpV2StoredInfoType.ServerResponse.Header or (if a response
// was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *OrganizationsLocationsStoredInfoTypesPatchCall) Do(opts ...googleapi.CallOption) (*GooglePrivacyDlpV2StoredInfoType, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GooglePrivacyDlpV2StoredInfoType{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "dlp.organizations.locations.storedInfoTypes.patch", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type OrganizationsLocationsTableDataProfilesDeleteCall struct {
	s          *Service
	name       string
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Delete: Delete a TableDataProfile. Will not prevent the profile from being
// regenerated if the table is still included in a discovery configuration.
//
// - name: Resource name of the table data profile.
func (r *OrganizationsLocationsTableDataProfilesService) Delete(name string) *OrganizationsLocationsTableDataProfilesDeleteCall {
	c := &OrganizationsLocationsTableDataProfilesDeleteCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *OrganizationsLocationsTableDataProfilesDeleteCall) Fields(s ...googleapi.Field) *OrganizationsLocationsTableDataProfilesDeleteCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *OrganizationsLocationsTableDataProfilesDeleteCall) Context(ctx context.Context) *OrganizationsLocationsTableDataProfilesDeleteCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *OrganizationsLocationsTableDataProfilesDeleteCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *OrganizationsLocationsTableDataProfilesDeleteCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v2/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("DELETE", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "dlp.organizations.locations.tableDataProfiles.delete", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "dlp.organizations.locations.tableDataProfiles.delete" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleProtobufEmpty.ServerResponse.Header or (if a response was returned at
// all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified was
// returned.
func (c *OrganizationsLocationsTableDataProfilesDeleteCall) Do(opts ...googleapi.CallOption) (*GoogleProtobufEmpty, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleProtobufEmpty{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "dlp.organizations.locations.tableDataProfiles.delete", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type OrganizationsLocationsTableDataProfilesGetCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Gets a table data profile.
//
//   - name: Resource name, for example
//     `organizations/12345/locations/us/tableDataProfiles/53234423`.
func (r *OrganizationsLocationsTableDataProfilesService) Get(name string) *OrganizationsLocationsTableDataProfilesGetCall {
	c := &OrganizationsLocationsTableDataProfilesGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *OrganizationsLocationsTableDataProfilesGetCall) Fields(s ...googleapi.Field) *OrganizationsLocationsTableDataProfilesGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *OrganizationsLocationsTableDataProfilesGetCall) IfNoneMatch(entityTag string) *OrganizationsLocationsTableDataProfilesGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *OrganizationsLocationsTableDataProfilesGetCall) Context(ctx context.Context) *OrganizationsLocationsTableDataProfilesGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *OrganizationsLocationsTableDataProfilesGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *OrganizationsLocationsTableDataProfilesGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v2/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "dlp.organizations.locations.tableDataProfiles.get", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "dlp.organizations.locations.tableDataProfiles.get" call.
// Any non-2xx status code is an error. Response headers are in either
// *GooglePrivacyDlpV2TableDataProfile.ServerResponse.Header or (if a response
// was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *OrganizationsLocationsTableDataProfilesGetCall) Do(opts ...googleapi.CallOption) (*GooglePrivacyDlpV2TableDataProfile, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GooglePrivacyDlpV2TableDataProfile{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "dlp.organizations.locations.tableDataProfiles.get", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type OrganizationsLocationsTableDataProfilesListCall struct {
	s            *Service
	parent       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Lists table data profiles for an organization.
//
//   - parent: Resource name of the organization or project, for example
//     `organizations/433245324/locations/europe` or
//     `projects/project-id/locations/asia`.
func (r *OrganizationsLocationsTableDataProfilesService) List(parent string) *OrganizationsLocationsTableDataProfilesListCall {
	c := &OrganizationsLocationsTableDataProfilesListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	return c
}

// Filter sets the optional parameter "filter": Allows filtering. Supported
// syntax: * Filter expressions are made up of one or more restrictions. *
// Restrictions can be combined by `AND` or `OR` logical operators. A sequence
// of restrictions implicitly uses `AND`. * A restriction has the form of
// `{field} {operator} {value}`. * Supported fields: - `project_id`: The Google
// Cloud project ID - `dataset_id`: The BigQuery dataset ID - `table_id`: The
// ID of the BigQuery table - `sensitivity_level`: HIGH|MODERATE|LOW -
// `data_risk_level`: HIGH|MODERATE|LOW - `resource_visibility`:
// PUBLIC|RESTRICTED - `status_code`: an RPC status code as defined in
// https://github.com/googleapis/googleapis/blob/master/google/rpc/code.proto -
// `profile_last_generated`: Date and time the profile was last generated * The
// operator must be `=` or `!=`. The `profile_last_generated` filter also
// supports `<` and `>`. The syntax is based on https://google.aip.dev/160.
// Examples: * `project_id = 12345 AND status_code = 1` * `project_id = 12345
// AND sensitivity_level = HIGH` * `project_id = 12345 AND resource_visibility
// = PUBLIC` * `profile_last_generated < "2025-01-01T00:00:00.000Z" The length
// of this field should be no more than 500 characters.
func (c *OrganizationsLocationsTableDataProfilesListCall) Filter(filter string) *OrganizationsLocationsTableDataProfilesListCall {
	c.urlParams_.Set("filter", filter)
	return c
}

// OrderBy sets the optional parameter "orderBy": Comma-separated list of
// fields to order by, followed by `asc` or `desc` postfix. This list is case
// insensitive. The default sorting order is ascending. Redundant space
// characters are insignificant. Only one order field at a time is allowed.
// Examples: * `project_id asc` * `table_id` * `sensitivity_level desc`
// Supported fields are: - `project_id`: The Google Cloud project ID. -
// `dataset_id`: The ID of a BigQuery dataset. - `table_id`: The ID of a
// BigQuery table. - `sensitivity_level`: How sensitive the data in a table is,
// at most. - `data_risk_level`: How much risk is associated with this data. -
// `profile_last_generated`: When the profile was last updated in epoch
// seconds. - `last_modified`: The last time the resource was modified. -
// `resource_visibility`: Visibility restriction for this resource. -
// `row_count`: Number of rows in this resource.
func (c *OrganizationsLocationsTableDataProfilesListCall) OrderBy(orderBy string) *OrganizationsLocationsTableDataProfilesListCall {
	c.urlParams_.Set("orderBy", orderBy)
	return c
}

// PageSize sets the optional parameter "pageSize": Size of the page. This
// value can be limited by the server. If zero, server returns a page of max
// size 100.
func (c *OrganizationsLocationsTableDataProfilesListCall) PageSize(pageSize int64) *OrganizationsLocationsTableDataProfilesListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": Page token to continue
// retrieval.
func (c *OrganizationsLocationsTableDataProfilesListCall) PageToken(pageToken string) *OrganizationsLocationsTableDataProfilesListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *OrganizationsLocationsTableDataProfilesListCall) Fields(s ...googleapi.Field) *OrganizationsLocationsTableDataProfilesListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *OrganizationsLocationsTableDataProfilesListCall) IfNoneMatch(entityTag string) *OrganizationsLocationsTableDataProfilesListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *OrganizationsLocationsTableDataProfilesListCall) Context(ctx context.Context) *OrganizationsLocationsTableDataProfilesListCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *OrganizationsLocationsTableDataProfilesListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *OrganizationsLocationsTableDataProfilesListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v2/{+parent}/tableDataProfiles")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "dlp.organizations.locations.tableDataProfiles.list", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "dlp.organizations.locations.tableDataProfiles.list" call.
// Any non-2xx status code is an error. Response headers are in either
// *GooglePrivacyDlpV2ListTableDataProfilesResponse.ServerResponse.Header or
// (if a response was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *OrganizationsLocationsTableDataProfilesListCall) Do(opts ...googleapi.CallOption) (*GooglePrivacyDlpV2ListTableDataProfilesResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GooglePrivacyDlpV2ListTableDataProfilesResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "dlp.organizations.locations.tableDataProfiles.list", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *OrganizationsLocationsTableDataProfilesListCall) Pages(ctx context.Context, f func(*GooglePrivacyDlpV2ListTableDataProfilesResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken"))
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

type OrganizationsStoredInfoTypesCreateCall struct {
	s                                             *Service
	parentid                                      string
	googleprivacydlpv2createstoredinfotyperequest *GooglePrivacyDlpV2CreateStoredInfoTypeRequest
	urlParams_                                    gensupport.URLParams
	ctx_                                          context.Context
	header_                                       http.Header
}

// Create: Creates a pre-built stored infoType to be used for inspection. See
// https://cloud.google.com/sensitive-data-protection/docs/creating-stored-infotypes
// to learn more.
//
//   - parent: Parent resource name. The format of this value varies depending on
//     the scope of the request (project or organization) and whether you have
//     specified a processing location
//     (https://cloud.google.com/sensitive-data-protection/docs/specifying-location):
//   - Projects scope, location specified:
//     `projects/{project_id}/locations/{location_id}` + Projects scope, no
//     location specified (defaults to global): `projects/{project_id}` +
//     Organizations scope, location specified:
//     `organizations/{org_id}/locations/{location_id}` + Organizations scope, no
//     location specified (defaults to global): `organizations/{org_id}` The
//     following example `parent` string specifies a parent project with the
//     identifier `example-project`, and specifies the `europe-west3` location
//     for processing data:
//     parent=projects/example-project/locations/europe-west3.
func (r *OrganizationsStoredInfoTypesService) Create(parentid string, googleprivacydlpv2createstoredinfotyperequest *GooglePrivacyDlpV2CreateStoredInfoTypeRequest) *OrganizationsStoredInfoTypesCreateCall {
	c := &OrganizationsStoredInfoTypesCreateCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parentid = parentid
	c.googleprivacydlpv2createstoredinfotyperequest = googleprivacydlpv2createstoredinfotyperequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *OrganizationsStoredInfoTypesCreateCall) Fields(s ...googleapi.Field) *OrganizationsStoredInfoTypesCreateCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *OrganizationsStoredInfoTypesCreateCall) Context(ctx context.Context) *OrganizationsStoredInfoTypesCreateCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *OrganizationsStoredInfoTypesCreateCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *OrganizationsStoredInfoTypesCreateCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.googleprivacydlpv2createstoredinfotyperequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v2/{+parent}/storedInfoTypes")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parentid,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "dlp.organizations.storedInfoTypes.create", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "dlp.organizations.storedInfoTypes.create" call.
// Any non-2xx status code is an error. Response headers are in either
// *GooglePrivacyDlpV2StoredInfoType.ServerResponse.Header or (if a response
// was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *OrganizationsStoredInfoTypesCreateCall) Do(opts ...googleapi.CallOption) (*GooglePrivacyDlpV2StoredInfoType, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GooglePrivacyDlpV2StoredInfoType{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "dlp.organizations.storedInfoTypes.create", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type OrganizationsStoredInfoTypesDeleteCall struct {
	s          *Service
	name       string
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Delete: Deletes a stored infoType. See
// https://cloud.google.com/sensitive-data-protection/docs/creating-stored-infotypes
// to learn more.
//
//   - name: Resource name of the organization and storedInfoType to be deleted,
//     for example `organizations/433245324/storedInfoTypes/432452342` or
//     projects/project-id/storedInfoTypes/432452342.
func (r *OrganizationsStoredInfoTypesService) Delete(name string) *OrganizationsStoredInfoTypesDeleteCall {
	c := &OrganizationsStoredInfoTypesDeleteCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *OrganizationsStoredInfoTypesDeleteCall) Fields(s ...googleapi.Field) *OrganizationsStoredInfoTypesDeleteCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *OrganizationsStoredInfoTypesDeleteCall) Context(ctx context.Context) *OrganizationsStoredInfoTypesDeleteCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *OrganizationsStoredInfoTypesDeleteCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *OrganizationsStoredInfoTypesDeleteCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v2/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("DELETE", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "dlp.organizations.storedInfoTypes.delete", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "dlp.organizations.storedInfoTypes.delete" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleProtobufEmpty.ServerResponse.Header or (if a response was returned at
// all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified was
// returned.
func (c *OrganizationsStoredInfoTypesDeleteCall) Do(opts ...googleapi.CallOption) (*GoogleProtobufEmpty, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleProtobufEmpty{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "dlp.organizations.storedInfoTypes.delete", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type OrganizationsStoredInfoTypesGetCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Gets a stored infoType. See
// https://cloud.google.com/sensitive-data-protection/docs/creating-stored-infotypes
// to learn more.
//
//   - name: Resource name of the organization and storedInfoType to be read, for
//     example `organizations/433245324/storedInfoTypes/432452342` or
//     projects/project-id/storedInfoTypes/432452342.
func (r *OrganizationsStoredInfoTypesService) Get(name string) *OrganizationsStoredInfoTypesGetCall {
	c := &OrganizationsStoredInfoTypesGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *OrganizationsStoredInfoTypesGetCall) Fields(s ...googleapi.Field) *OrganizationsStoredInfoTypesGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *OrganizationsStoredInfoTypesGetCall) IfNoneMatch(entityTag string) *OrganizationsStoredInfoTypesGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *OrganizationsStoredInfoTypesGetCall) Context(ctx context.Context) *OrganizationsStoredInfoTypesGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *OrganizationsStoredInfoTypesGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *OrganizationsStoredInfoTypesGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v2/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "dlp.organizations.storedInfoTypes.get", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "dlp.organizations.storedInfoTypes.get" call.
// Any non-2xx status code is an error. Response headers are in either
// *GooglePrivacyDlpV2StoredInfoType.ServerResponse.Header or (if a response
// was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *OrganizationsStoredInfoTypesGetCall) Do(opts ...googleapi.CallOption) (*GooglePrivacyDlpV2StoredInfoType, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GooglePrivacyDlpV2StoredInfoType{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "dlp.organizations.storedInfoTypes.get", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type OrganizationsStoredInfoTypesListCall struct {
	s            *Service
	parentid     string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Lists stored infoTypes. See
// https://cloud.google.com/sensitive-data-protection/docs/creating-stored-infotypes
// to learn more.
//
//   - parent: Parent resource name. The format of this value varies depending on
//     the scope of the request (project or organization) and whether you have
//     specified a processing location
//     (https://cloud.google.com/sensitive-data-protection/docs/specifying-location):
//   - Projects scope, location specified:
//     `projects/{project_id}/locations/{location_id}` + Projects scope, no
//     location specified (defaults to global): `projects/{project_id}` The
//     following example `parent` string specifies a parent project with the
//     identifier `example-project`, and specifies the `europe-west3` location
//     for processing data:
//     parent=projects/example-project/locations/europe-west3.
func (r *OrganizationsStoredInfoTypesService) List(parentid string) *OrganizationsStoredInfoTypesListCall {
	c := &OrganizationsStoredInfoTypesListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parentid = parentid
	return c
}

// LocationId sets the optional parameter "locationId": Deprecated. This field
// has no effect.
func (c *OrganizationsStoredInfoTypesListCall) LocationId(locationId string) *OrganizationsStoredInfoTypesListCall {
	c.urlParams_.Set("locationId", locationId)
	return c
}

// OrderBy sets the optional parameter "orderBy": Comma-separated list of
// fields to order by, followed by `asc` or `desc` postfix. This list is case
// insensitive. The default sorting order is ascending. Redundant space
// characters are insignificant. Example: `name asc, display_name, create_time
// desc` Supported fields are: - `create_time`: corresponds to the time the
// most recent version of the resource was created. - `state`: corresponds to
// the state of the resource. - `name`: corresponds to resource name. -
// `display_name`: corresponds to info type's display name.
func (c *OrganizationsStoredInfoTypesListCall) OrderBy(orderBy string) *OrganizationsStoredInfoTypesListCall {
	c.urlParams_.Set("orderBy", orderBy)
	return c
}

// PageSize sets the optional parameter "pageSize": Size of the page. This
// value can be limited by the server. If zero server returns a page of max
// size 100.
func (c *OrganizationsStoredInfoTypesListCall) PageSize(pageSize int64) *OrganizationsStoredInfoTypesListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": Page token to continue
// retrieval. Comes from the previous call to `ListStoredInfoTypes`.
func (c *OrganizationsStoredInfoTypesListCall) PageToken(pageToken string) *OrganizationsStoredInfoTypesListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *OrganizationsStoredInfoTypesListCall) Fields(s ...googleapi.Field) *OrganizationsStoredInfoTypesListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *OrganizationsStoredInfoTypesListCall) IfNoneMatch(entityTag string) *OrganizationsStoredInfoTypesListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *OrganizationsStoredInfoTypesListCall) Context(ctx context.Context) *OrganizationsStoredInfoTypesListCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *OrganizationsStoredInfoTypesListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *OrganizationsStoredInfoTypesListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v2/{+parent}/storedInfoTypes")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parentid,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "dlp.organizations.storedInfoTypes.list", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "dlp.organizations.storedInfoTypes.list" call.
// Any non-2xx status code is an error. Response headers are in either
// *GooglePrivacyDlpV2ListStoredInfoTypesResponse.ServerResponse.Header or (if
// a response was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *OrganizationsStoredInfoTypesListCall) Do(opts ...googleapi.CallOption) (*GooglePrivacyDlpV2ListStoredInfoTypesResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GooglePrivacyDlpV2ListStoredInfoTypesResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "dlp.organizations.storedInfoTypes.list", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *OrganizationsStoredInfoTypesListCall) Pages(ctx context.Context, f func(*GooglePrivacyDlpV2ListStoredInfoTypesResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken"))
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

type OrganizationsStoredInfoTypesPatchCall struct {
	s                                             *Service
	name                                          string
	googleprivacydlpv2updatestoredinfotyperequest *GooglePrivacyDlpV2UpdateStoredInfoTypeRequest
	urlParams_                                    gensupport.URLParams
	ctx_                                          context.Context
	header_                                       http.Header
}

// Patch: Updates the stored infoType by creating a new version. The existing
// version will continue to be used until the new version is ready. See
// https://cloud.google.com/sensitive-data-protection/docs/creating-stored-infotypes
// to learn more.
//
//   - name: Resource name of organization and storedInfoType to be updated, for
//     example `organizations/433245324/storedInfoTypes/432452342` or
//     projects/project-id/storedInfoTypes/432452342.
func (r *OrganizationsStoredInfoTypesService) Patch(name string, googleprivacydlpv2updatestoredinfotyperequest *GooglePrivacyDlpV2UpdateStoredInfoTypeRequest) *OrganizationsStoredInfoTypesPatchCall {
	c := &OrganizationsStoredInfoTypesPatchCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.googleprivacydlpv2updatestoredinfotyperequest = googleprivacydlpv2updatestoredinfotyperequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *OrganizationsStoredInfoTypesPatchCall) Fields(s ...googleapi.Field) *OrganizationsStoredInfoTypesPatchCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *OrganizationsStoredInfoTypesPatchCall) Context(ctx context.Context) *OrganizationsStoredInfoTypesPatchCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *OrganizationsStoredInfoTypesPatchCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *OrganizationsStoredInfoTypesPatchCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.googleprivacydlpv2updatestoredinfotyperequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v2/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("PATCH", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "dlp.organizations.storedInfoTypes.patch", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "dlp.organizations.storedInfoTypes.patch" call.
// Any non-2xx status code is an error. Response headers are in either
// *GooglePrivacyDlpV2StoredInfoType.ServerResponse.Header or (if a response
// was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *OrganizationsStoredInfoTypesPatchCall) Do(opts ...googleapi.CallOption) (*GooglePrivacyDlpV2StoredInfoType, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GooglePrivacyDlpV2StoredInfoType{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "dlp.organizations.storedInfoTypes.patch", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsContentDeidentifyCall struct {
	s                                          *Service
	parentid                                   string
	googleprivacydlpv2deidentifycontentrequest *GooglePrivacyDlpV2DeidentifyContentRequest
	urlParams_                                 gensupport.URLParams
	ctx_                                       context.Context
	header_                                    http.Header
}

// Deidentify: De-identifies potentially sensitive info from a ContentItem.
// This method has limits on input size and output size. See
// https://cloud.google.com/sensitive-data-protection/docs/deidentify-sensitive-data
// to learn more. When no InfoTypes or CustomInfoTypes are specified in this
// request, the system will automatically choose what detectors to run. By
// default this may be all types, but may change over time as detectors are
// updated.
//
//   - parent: Parent resource name. The format of this value varies depending on
//     whether you have specified a processing location
//     (https://cloud.google.com/sensitive-data-protection/docs/specifying-location):
//   - Projects scope, location specified:
//     `projects/{project_id}/locations/{location_id}` + Projects scope, no
//     location specified (defaults to global): `projects/{project_id}` The
//     following example `parent` string specifies a parent project with the
//     identifier `example-project`, and specifies the `europe-west3` location
//     for processing data:
//     parent=projects/example-project/locations/europe-west3.
func (r *ProjectsContentService) Deidentify(parentid string, googleprivacydlpv2deidentifycontentrequest *GooglePrivacyDlpV2DeidentifyContentRequest) *ProjectsContentDeidentifyCall {
	c := &ProjectsContentDeidentifyCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parentid = parentid
	c.googleprivacydlpv2deidentifycontentrequest = googleprivacydlpv2deidentifycontentrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsContentDeidentifyCall) Fields(s ...googleapi.Field) *ProjectsContentDeidentifyCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsContentDeidentifyCall) Context(ctx context.Context) *ProjectsContentDeidentifyCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsContentDeidentifyCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsContentDeidentifyCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.googleprivacydlpv2deidentifycontentrequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v2/{+parent}/content:deidentify")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parentid,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "dlp.projects.content.deidentify", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "dlp.projects.content.deidentify" call.
// Any non-2xx status code is an error. Response headers are in either
// *GooglePrivacyDlpV2DeidentifyContentResponse.ServerResponse.Header or (if a
// response was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsContentDeidentifyCall) Do(opts ...googleapi.CallOption) (*GooglePrivacyDlpV2DeidentifyContentResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GooglePrivacyDlpV2DeidentifyContentResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "dlp.projects.content.deidentify", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsContentInspectCall struct {
	s                                       *Service
	parentid                                string
	googleprivacydlpv2inspectcontentrequest *GooglePrivacyDlpV2InspectContentRequest
	urlParams_                              gensupport.URLParams
	ctx_                                    context.Context
	header_                                 http.Header
}

// Inspect: Finds potentially sensitive info in content. This method has limits
// on input size, processing time, and output size. When no InfoTypes or
// CustomInfoTypes are specified in this request, the system will automatically
// choose what detectors to run. By default this may be all types, but may
// change over time as detectors are updated. For how to guides, see
// https://cloud.google.com/sensitive-data-protection/docs/inspecting-images
// and https://cloud.google.com/sensitive-data-protection/docs/inspecting-text,
//
//   - parent: Parent resource name. The format of this value varies depending on
//     whether you have specified a processing location
//     (https://cloud.google.com/sensitive-data-protection/docs/specifying-location):
//   - Projects scope, location specified:
//     `projects/{project_id}/locations/{location_id}` + Projects scope, no
//     location specified (defaults to global): `projects/{project_id}` The
//     following example `parent` string specifies a parent project with the
//     identifier `example-project`, and specifies the `europe-west3` location
//     for processing data:
//     parent=projects/example-project/locations/europe-west3.
func (r *ProjectsContentService) Inspect(parentid string, googleprivacydlpv2inspectcontentrequest *GooglePrivacyDlpV2InspectContentRequest) *ProjectsContentInspectCall {
	c := &ProjectsContentInspectCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parentid = parentid
	c.googleprivacydlpv2inspectcontentrequest = googleprivacydlpv2inspectcontentrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsContentInspectCall) Fields(s ...googleapi.Field) *ProjectsContentInspectCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsContentInspectCall) Context(ctx context.Context) *ProjectsContentInspectCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsContentInspectCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsContentInspectCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.googleprivacydlpv2inspectcontentrequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v2/{+parent}/content:inspect")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parentid,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "dlp.projects.content.inspect", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "dlp.projects.content.inspect" call.
// Any non-2xx status code is an error. Response headers are in either
// *GooglePrivacyDlpV2InspectContentResponse.ServerResponse.Header or (if a
// response was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsContentInspectCall) Do(opts ...googleapi.CallOption) (*GooglePrivacyDlpV2InspectContentResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GooglePrivacyDlpV2InspectContentResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "dlp.projects.content.inspect", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsContentReidentifyCall struct {
	s                                          *Service
	parentid                                   string
	googleprivacydlpv2reidentifycontentrequest *GooglePrivacyDlpV2ReidentifyContentRequest
	urlParams_                                 gensupport.URLParams
	ctx_                                       context.Context
	header_                                    http.Header
}

// Reidentify: Re-identifies content that has been de-identified. See
// https://cloud.google.com/sensitive-data-protection/docs/pseudonymization#re-identification_in_free_text_code_example
// to learn more.
//
//   - parent: Parent resource name. The format of this value varies depending on
//     whether you have specified a processing location
//     (https://cloud.google.com/sensitive-data-protection/docs/specifying-location):
//   - Projects scope, location specified:
//     `projects/{project_id}/locations/{location_id}` + Projects scope, no
//     location specified (defaults to global): `projects/{project_id}` The
//     following example `parent` string specifies a parent project with the
//     identifier `example-project`, and specifies the `europe-west3` location
//     for processing data:
//     parent=projects/example-project/locations/europe-west3.
func (r *ProjectsContentService) Reidentify(parentid string, googleprivacydlpv2reidentifycontentrequest *GooglePrivacyDlpV2ReidentifyContentRequest) *ProjectsContentReidentifyCall {
	c := &ProjectsContentReidentifyCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parentid = parentid
	c.googleprivacydlpv2reidentifycontentrequest = googleprivacydlpv2reidentifycontentrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsContentReidentifyCall) Fields(s ...googleapi.Field) *ProjectsContentReidentifyCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsContentReidentifyCall) Context(ctx context.Context) *ProjectsContentReidentifyCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsContentReidentifyCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsContentReidentifyCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.googleprivacydlpv2reidentifycontentrequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v2/{+parent}/content:reidentify")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parentid,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "dlp.projects.content.reidentify", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "dlp.projects.content.reidentify" call.
// Any non-2xx status code is an error. Response headers are in either
// *GooglePrivacyDlpV2ReidentifyContentResponse.ServerResponse.Header or (if a
// response was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsContentReidentifyCall) Do(opts ...googleapi.CallOption) (*GooglePrivacyDlpV2ReidentifyContentResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GooglePrivacyDlpV2ReidentifyContentResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "dlp.projects.content.reidentify", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsDeidentifyTemplatesCreateCall struct {
	s                                                 *Service
	parentid                                          string
	googleprivacydlpv2createdeidentifytemplaterequest *GooglePrivacyDlpV2CreateDeidentifyTemplateRequest
	urlParams_                                        gensupport.URLParams
	ctx_                                              context.Context
	header_                                           http.Header
}

// Create: Creates a DeidentifyTemplate for reusing frequently used
// configuration for de-identifying content, images, and storage. See
// https://cloud.google.com/sensitive-data-protection/docs/creating-templates-deid
// to learn more.
//
//   - parent: Parent resource name. The format of this value varies depending on
//     the scope of the request (project or organization) and whether you have
//     specified a processing location
//     (https://cloud.google.com/sensitive-data-protection/docs/specifying-location):
//   - Projects scope, location specified:
//     `projects/{project_id}/locations/{location_id}` + Projects scope, no
//     location specified (defaults to global): `projects/{project_id}` +
//     Organizations scope, location specified:
//     `organizations/{org_id}/locations/{location_id}` + Organizations scope, no
//     location specified (defaults to global): `organizations/{org_id}` The
//     following example `parent` string specifies a parent project with the
//     identifier `example-project`, and specifies the `europe-west3` location
//     for processing data:
//     parent=projects/example-project/locations/europe-west3.
func (r *ProjectsDeidentifyTemplatesService) Create(parentid string, googleprivacydlpv2createdeidentifytemplaterequest *GooglePrivacyDlpV2CreateDeidentifyTemplateRequest) *ProjectsDeidentifyTemplatesCreateCall {
	c := &ProjectsDeidentifyTemplatesCreateCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parentid = parentid
	c.googleprivacydlpv2createdeidentifytemplaterequest = googleprivacydlpv2createdeidentifytemplaterequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsDeidentifyTemplatesCreateCall) Fields(s ...googleapi.Field) *ProjectsDeidentifyTemplatesCreateCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsDeidentifyTemplatesCreateCall) Context(ctx context.Context) *ProjectsDeidentifyTemplatesCreateCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsDeidentifyTemplatesCreateCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsDeidentifyTemplatesCreateCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.googleprivacydlpv2createdeidentifytemplaterequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v2/{+parent}/deidentifyTemplates")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parentid,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "dlp.projects.deidentifyTemplates.create", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "dlp.projects.deidentifyTemplates.create" call.
// Any non-2xx status code is an error. Response headers are in either
// *GooglePrivacyDlpV2DeidentifyTemplate.ServerResponse.Header or (if a
// response was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsDeidentifyTemplatesCreateCall) Do(opts ...googleapi.CallOption) (*GooglePrivacyDlpV2DeidentifyTemplate, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GooglePrivacyDlpV2DeidentifyTemplate{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "dlp.projects.deidentifyTemplates.create", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsDeidentifyTemplatesDeleteCall struct {
	s          *Service
	name       string
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Delete: Deletes a DeidentifyTemplate. See
// https://cloud.google.com/sensitive-data-protection/docs/creating-templates-deid
// to learn more.
//
//   - name: Resource name of the organization and deidentify template to be
//     deleted, for example
//     `organizations/433245324/deidentifyTemplates/432452342` or
//     projects/project-id/deidentifyTemplates/432452342.
func (r *ProjectsDeidentifyTemplatesService) Delete(name string) *ProjectsDeidentifyTemplatesDeleteCall {
	c := &ProjectsDeidentifyTemplatesDeleteCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsDeidentifyTemplatesDeleteCall) Fields(s ...googleapi.Field) *ProjectsDeidentifyTemplatesDeleteCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsDeidentifyTemplatesDeleteCall) Context(ctx context.Context) *ProjectsDeidentifyTemplatesDeleteCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsDeidentifyTemplatesDeleteCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsDeidentifyTemplatesDeleteCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v2/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("DELETE", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "dlp.projects.deidentifyTemplates.delete", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "dlp.projects.deidentifyTemplates.delete" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleProtobufEmpty.ServerResponse.Header or (if a response was returned at
// all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified was
// returned.
func (c *ProjectsDeidentifyTemplatesDeleteCall) Do(opts ...googleapi.CallOption) (*GoogleProtobufEmpty, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleProtobufEmpty{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "dlp.projects.deidentifyTemplates.delete", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsDeidentifyTemplatesGetCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Gets a DeidentifyTemplate. See
// https://cloud.google.com/sensitive-data-protection/docs/creating-templates-deid
// to learn more.
//
//   - name: Resource name of the organization and deidentify template to be
//     read, for example `organizations/433245324/deidentifyTemplates/432452342`
//     or projects/project-id/deidentifyTemplates/432452342.
func (r *ProjectsDeidentifyTemplatesService) Get(name string) *ProjectsDeidentifyTemplatesGetCall {
	c := &ProjectsDeidentifyTemplatesGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsDeidentifyTemplatesGetCall) Fields(s ...googleapi.Field) *ProjectsDeidentifyTemplatesGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsDeidentifyTemplatesGetCall) IfNoneMatch(entityTag string) *ProjectsDeidentifyTemplatesGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsDeidentifyTemplatesGetCall) Context(ctx context.Context) *ProjectsDeidentifyTemplatesGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsDeidentifyTemplatesGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsDeidentifyTemplatesGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v2/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "dlp.projects.deidentifyTemplates.get", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "dlp.projects.deidentifyTemplates.get" call.
// Any non-2xx status code is an error. Response headers are in either
// *GooglePrivacyDlpV2DeidentifyTemplate.ServerResponse.Header or (if a
// response was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsDeidentifyTemplatesGetCall) Do(opts ...googleapi.CallOption) (*GooglePrivacyDlpV2DeidentifyTemplate, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GooglePrivacyDlpV2DeidentifyTemplate{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "dlp.projects.deidentifyTemplates.get", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsDeidentifyTemplatesListCall struct {
	s            *Service
	parentid     string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Lists DeidentifyTemplates. See
// https://cloud.google.com/sensitive-data-protection/docs/creating-templates-deid
// to learn more.
//
//   - parent: Parent resource name. The format of this value varies depending on
//     the scope of the request (project or organization) and whether you have
//     specified a processing location
//     (https://cloud.google.com/sensitive-data-protection/docs/specifying-location):
//   - Projects scope, location specified:
//     `projects/{project_id}/locations/{location_id}` + Projects scope, no
//     location specified (defaults to global): `projects/{project_id}` +
//     Organizations scope, location specified:
//     `organizations/{org_id}/locations/{location_id}` + Organizations scope, no
//     location specified (defaults to global): `organizations/{org_id}` The
//     following example `parent` string specifies a parent project with the
//     identifier `example-project`, and specifies the `europe-west3` location
//     for processing data:
//     parent=projects/example-project/locations/europe-west3.
func (r *ProjectsDeidentifyTemplatesService) List(parentid string) *ProjectsDeidentifyTemplatesListCall {
	c := &ProjectsDeidentifyTemplatesListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parentid = parentid
	return c
}

// LocationId sets the optional parameter "locationId": Deprecated. This field
// has no effect.
func (c *ProjectsDeidentifyTemplatesListCall) LocationId(locationId string) *ProjectsDeidentifyTemplatesListCall {
	c.urlParams_.Set("locationId", locationId)
	return c
}

// OrderBy sets the optional parameter "orderBy": Comma-separated list of
// fields to order by, followed by `asc` or `desc` postfix. This list is case
// insensitive. The default sorting order is ascending. Redundant space
// characters are insignificant. Example: `name asc,update_time, create_time
// desc` Supported fields are: - `create_time`: corresponds to the time the
// template was created. - `update_time`: corresponds to the time the template
// was last updated. - `name`: corresponds to the template's name. -
// `display_name`: corresponds to the template's display name.
func (c *ProjectsDeidentifyTemplatesListCall) OrderBy(orderBy string) *ProjectsDeidentifyTemplatesListCall {
	c.urlParams_.Set("orderBy", orderBy)
	return c
}

// PageSize sets the optional parameter "pageSize": Size of the page. This
// value can be limited by the server. If zero server returns a page of max
// size 100.
func (c *ProjectsDeidentifyTemplatesListCall) PageSize(pageSize int64) *ProjectsDeidentifyTemplatesListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": Page token to continue
// retrieval. Comes from the previous call to `ListDeidentifyTemplates`.
func (c *ProjectsDeidentifyTemplatesListCall) PageToken(pageToken string) *ProjectsDeidentifyTemplatesListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsDeidentifyTemplatesListCall) Fields(s ...googleapi.Field) *ProjectsDeidentifyTemplatesListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsDeidentifyTemplatesListCall) IfNoneMatch(entityTag string) *ProjectsDeidentifyTemplatesListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsDeidentifyTemplatesListCall) Context(ctx context.Context) *ProjectsDeidentifyTemplatesListCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsDeidentifyTemplatesListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsDeidentifyTemplatesListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v2/{+parent}/deidentifyTemplates")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parentid,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "dlp.projects.deidentifyTemplates.list", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "dlp.projects.deidentifyTemplates.list" call.
// Any non-2xx status code is an error. Response headers are in either
// *GooglePrivacyDlpV2ListDeidentifyTemplatesResponse.ServerResponse.Header or
// (if a response was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsDeidentifyTemplatesListCall) Do(opts ...googleapi.CallOption) (*GooglePrivacyDlpV2ListDeidentifyTemplatesResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GooglePrivacyDlpV2ListDeidentifyTemplatesResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "dlp.projects.deidentifyTemplates.list", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *ProjectsDeidentifyTemplatesListCall) Pages(ctx context.Context, f func(*GooglePrivacyDlpV2ListDeidentifyTemplatesResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken"))
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

type ProjectsDeidentifyTemplatesPatchCall struct {
	s                                                 *Service
	name                                              string
	googleprivacydlpv2updatedeidentifytemplaterequest *GooglePrivacyDlpV2UpdateDeidentifyTemplateRequest
	urlParams_                                        gensupport.URLParams
	ctx_                                              context.Context
	header_                                           http.Header
}

// Patch: Updates the DeidentifyTemplate. See
// https://cloud.google.com/sensitive-data-protection/docs/creating-templates-deid
// to learn more.
//
//   - name: Resource name of organization and deidentify template to be updated,
//     for example `organizations/433245324/deidentifyTemplates/432452342` or
//     projects/project-id/deidentifyTemplates/432452342.
func (r *ProjectsDeidentifyTemplatesService) Patch(name string, googleprivacydlpv2updatedeidentifytemplaterequest *GooglePrivacyDlpV2UpdateDeidentifyTemplateRequest) *ProjectsDeidentifyTemplatesPatchCall {
	c := &ProjectsDeidentifyTemplatesPatchCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.googleprivacydlpv2updatedeidentifytemplaterequest = googleprivacydlpv2updatedeidentifytemplaterequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsDeidentifyTemplatesPatchCall) Fields(s ...googleapi.Field) *ProjectsDeidentifyTemplatesPatchCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsDeidentifyTemplatesPatchCall) Context(ctx context.Context) *ProjectsDeidentifyTemplatesPatchCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsDeidentifyTemplatesPatchCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsDeidentifyTemplatesPatchCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.googleprivacydlpv2updatedeidentifytemplaterequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v2/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("PATCH", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "dlp.projects.deidentifyTemplates.patch", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "dlp.projects.deidentifyTemplates.patch" call.
// Any non-2xx status code is an error. Response headers are in either
// *GooglePrivacyDlpV2DeidentifyTemplate.ServerResponse.Header or (if a
// response was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsDeidentifyTemplatesPatchCall) Do(opts ...googleapi.CallOption) (*GooglePrivacyDlpV2DeidentifyTemplate, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GooglePrivacyDlpV2DeidentifyTemplate{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "dlp.projects.deidentifyTemplates.patch", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsDlpJobsCancelCall struct {
	s                                     *Service
	name                                  string
	googleprivacydlpv2canceldlpjobrequest *GooglePrivacyDlpV2CancelDlpJobRequest
	urlParams_                            gensupport.URLParams
	ctx_                                  context.Context
	header_                               http.Header
}

// Cancel: Starts asynchronous cancellation on a long-running DlpJob. The
// server makes a best effort to cancel the DlpJob, but success is not
// guaranteed. See
// https://cloud.google.com/sensitive-data-protection/docs/inspecting-storage
// and
// https://cloud.google.com/sensitive-data-protection/docs/compute-risk-analysis
// to learn more.
//
// - name: The name of the DlpJob resource to be cancelled.
func (r *ProjectsDlpJobsService) Cancel(name string, googleprivacydlpv2canceldlpjobrequest *GooglePrivacyDlpV2CancelDlpJobRequest) *ProjectsDlpJobsCancelCall {
	c := &ProjectsDlpJobsCancelCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.googleprivacydlpv2canceldlpjobrequest = googleprivacydlpv2canceldlpjobrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsDlpJobsCancelCall) Fields(s ...googleapi.Field) *ProjectsDlpJobsCancelCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsDlpJobsCancelCall) Context(ctx context.Context) *ProjectsDlpJobsCancelCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsDlpJobsCancelCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsDlpJobsCancelCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.googleprivacydlpv2canceldlpjobrequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v2/{+name}:cancel")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "dlp.projects.dlpJobs.cancel", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "dlp.projects.dlpJobs.cancel" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleProtobufEmpty.ServerResponse.Header or (if a response was returned at
// all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified was
// returned.
func (c *ProjectsDlpJobsCancelCall) Do(opts ...googleapi.CallOption) (*GoogleProtobufEmpty, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleProtobufEmpty{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "dlp.projects.dlpJobs.cancel", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsDlpJobsCreateCall struct {
	s                                     *Service
	parentid                              string
	googleprivacydlpv2createdlpjobrequest *GooglePrivacyDlpV2CreateDlpJobRequest
	urlParams_                            gensupport.URLParams
	ctx_                                  context.Context
	header_                               http.Header
}

// Create: Creates a new job to inspect storage or calculate risk metrics. See
// https://cloud.google.com/sensitive-data-protection/docs/inspecting-storage
// and
// https://cloud.google.com/sensitive-data-protection/docs/compute-risk-analysis
// to learn more. When no InfoTypes or CustomInfoTypes are specified in inspect
// jobs, the system will automatically choose what detectors to run. By default
// this may be all types, but may change over time as detectors are updated.
//
//   - parent: Parent resource name. The format of this value varies depending on
//     whether you have specified a processing location
//     (https://cloud.google.com/sensitive-data-protection/docs/specifying-location):
//   - Projects scope, location specified:
//     `projects/{project_id}/locations/{location_id}` + Projects scope, no
//     location specified (defaults to global): `projects/{project_id}` The
//     following example `parent` string specifies a parent project with the
//     identifier `example-project`, and specifies the `europe-west3` location
//     for processing data:
//     parent=projects/example-project/locations/europe-west3.
func (r *ProjectsDlpJobsService) Create(parentid string, googleprivacydlpv2createdlpjobrequest *GooglePrivacyDlpV2CreateDlpJobRequest) *ProjectsDlpJobsCreateCall {
	c := &ProjectsDlpJobsCreateCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parentid = parentid
	c.googleprivacydlpv2createdlpjobrequest = googleprivacydlpv2createdlpjobrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsDlpJobsCreateCall) Fields(s ...googleapi.Field) *ProjectsDlpJobsCreateCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsDlpJobsCreateCall) Context(ctx context.Context) *ProjectsDlpJobsCreateCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsDlpJobsCreateCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsDlpJobsCreateCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.googleprivacydlpv2createdlpjobrequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v2/{+parent}/dlpJobs")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parentid,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "dlp.projects.dlpJobs.create", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "dlp.projects.dlpJobs.create" call.
// Any non-2xx status code is an error. Response headers are in either
// *GooglePrivacyDlpV2DlpJob.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsDlpJobsCreateCall) Do(opts ...googleapi.CallOption) (*GooglePrivacyDlpV2DlpJob, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GooglePrivacyDlpV2DlpJob{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "dlp.projects.dlpJobs.create", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsDlpJobsDeleteCall struct {
	s          *Service
	name       string
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Delete: Deletes a long-running DlpJob. This method indicates that the client
// is no longer interested in the DlpJob result. The job will be canceled if
// possible. See
// https://cloud.google.com/sensitive-data-protection/docs/inspecting-storage
// and
// https://cloud.google.com/sensitive-data-protection/docs/compute-risk-analysis
// to learn more.
//
// - name: The name of the DlpJob resource to be deleted.
func (r *ProjectsDlpJobsService) Delete(name string) *ProjectsDlpJobsDeleteCall {
	c := &ProjectsDlpJobsDeleteCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsDlpJobsDeleteCall) Fields(s ...googleapi.Field) *ProjectsDlpJobsDeleteCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsDlpJobsDeleteCall) Context(ctx context.Context) *ProjectsDlpJobsDeleteCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsDlpJobsDeleteCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsDlpJobsDeleteCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v2/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("DELETE", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "dlp.projects.dlpJobs.delete", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "dlp.projects.dlpJobs.delete" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleProtobufEmpty.ServerResponse.Header or (if a response was returned at
// all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified was
// returned.
func (c *ProjectsDlpJobsDeleteCall) Do(opts ...googleapi.CallOption) (*GoogleProtobufEmpty, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleProtobufEmpty{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "dlp.projects.dlpJobs.delete", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsDlpJobsGetCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Gets the latest state of a long-running DlpJob. See
// https://cloud.google.com/sensitive-data-protection/docs/inspecting-storage
// and
// https://cloud.google.com/sensitive-data-protection/docs/compute-risk-analysis
// to learn more.
//
// - name: The name of the DlpJob resource.
func (r *ProjectsDlpJobsService) Get(name string) *ProjectsDlpJobsGetCall {
	c := &ProjectsDlpJobsGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsDlpJobsGetCall) Fields(s ...googleapi.Field) *ProjectsDlpJobsGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsDlpJobsGetCall) IfNoneMatch(entityTag string) *ProjectsDlpJobsGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsDlpJobsGetCall) Context(ctx context.Context) *ProjectsDlpJobsGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsDlpJobsGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsDlpJobsGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v2/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "dlp.projects.dlpJobs.get", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "dlp.projects.dlpJobs.get" call.
// Any non-2xx status code is an error. Response headers are in either
// *GooglePrivacyDlpV2DlpJob.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsDlpJobsGetCall) Do(opts ...googleapi.CallOption) (*GooglePrivacyDlpV2DlpJob, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GooglePrivacyDlpV2DlpJob{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "dlp.projects.dlpJobs.get", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsDlpJobsListCall struct {
	s            *Service
	parentid     string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Lists DlpJobs that match the specified filter in the request. See
// https://cloud.google.com/sensitive-data-protection/docs/inspecting-storage
// and
// https://cloud.google.com/sensitive-data-protection/docs/compute-risk-analysis
// to learn more.
//
//   - parent: Parent resource name. The format of this value varies depending on
//     whether you have specified a processing location
//     (https://cloud.google.com/sensitive-data-protection/docs/specifying-location):
//   - Projects scope, location specified:
//     `projects/{project_id}/locations/{location_id}` + Projects scope, no
//     location specified (defaults to global): `projects/{project_id}` The
//     following example `parent` string specifies a parent project with the
//     identifier `example-project`, and specifies the `europe-west3` location
//     for processing data:
//     parent=projects/example-project/locations/europe-west3.
func (r *ProjectsDlpJobsService) List(parentid string) *ProjectsDlpJobsListCall {
	c := &ProjectsDlpJobsListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parentid = parentid
	return c
}

// Filter sets the optional parameter "filter": Allows filtering. Supported
// syntax: * Filter expressions are made up of one or more restrictions. *
// Restrictions can be combined by `AND` or `OR` logical operators. A sequence
// of restrictions implicitly uses `AND`. * A restriction has the form of
// `{field} {operator} {value}`. * Supported fields/values for inspect jobs: -
// `state` - PENDING|RUNNING|CANCELED|FINISHED|FAILED - `inspected_storage` -
// DATASTORE|CLOUD_STORAGE|BIGQUERY - `trigger_name` - The name of the trigger
// that created the job. - 'end_time` - Corresponds to the time the job
// finished. - 'start_time` - Corresponds to the time the job finished. *
// Supported fields for risk analysis jobs: - `state` -
// RUNNING|CANCELED|FINISHED|FAILED - 'end_time` - Corresponds to the time the
// job finished. - 'start_time` - Corresponds to the time the job finished. *
// The operator must be `=` or `!=`. The syntax is based on
// https://google.aip.dev/160. Examples: * inspected_storage = cloud_storage
// AND state = done * inspected_storage = cloud_storage OR inspected_storage =
// bigquery * inspected_storage = cloud_storage AND (state = done OR state =
// canceled) * end_time > \"2017-12-12T00:00:00+00:00\" The length of this
// field should be no more than 500 characters.
func (c *ProjectsDlpJobsListCall) Filter(filter string) *ProjectsDlpJobsListCall {
	c.urlParams_.Set("filter", filter)
	return c
}

// LocationId sets the optional parameter "locationId": Deprecated. This field
// has no effect.
func (c *ProjectsDlpJobsListCall) LocationId(locationId string) *ProjectsDlpJobsListCall {
	c.urlParams_.Set("locationId", locationId)
	return c
}

// OrderBy sets the optional parameter "orderBy": Comma-separated list of
// fields to order by, followed by `asc` or `desc` postfix. This list is case
// insensitive. The default sorting order is ascending. Redundant space
// characters are insignificant. Example: `name asc, end_time asc, create_time
// desc` Supported fields are: - `create_time`: corresponds to the time the job
// was created. - `end_time`: corresponds to the time the job ended. - `name`:
// corresponds to the job's name. - `state`: corresponds to `state`
func (c *ProjectsDlpJobsListCall) OrderBy(orderBy string) *ProjectsDlpJobsListCall {
	c.urlParams_.Set("orderBy", orderBy)
	return c
}

// PageSize sets the optional parameter "pageSize": The standard list page
// size.
func (c *ProjectsDlpJobsListCall) PageSize(pageSize int64) *ProjectsDlpJobsListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": The standard list page
// token.
func (c *ProjectsDlpJobsListCall) PageToken(pageToken string) *ProjectsDlpJobsListCall {
