// Copyright 2026 Google LLC.
// Use of this source code is governed by a BSD-style
// license that can be found in the LICENSE file.

// Code generated file. DO NOT EDIT.

// Package dialogflow provides access to the Dialogflow API.
//
// This package is DEPRECATED. Use package cloud.google.com/go/dialogflow/apiv2 instead.
//
// For product documentation, see: https://cloud.google.com/dialogflow/
//
// # Library status
//
// These client libraries are officially supported by Google. However, this
// library is considered complete and is in maintenance mode. This means
// that we will address critical bugs and security issues but will not add
// any new features.
//
// When possible, we recommend using our newer
// [Cloud Client Libraries for Go](https://pkg.go.dev/cloud.google.com/go)
// that are still actively being worked and iterated on.
//
// # Creating a client
//
// Usage example:
//
//	import "google.golang.org/api/dialogflow/v3"
//	...
//	ctx := context.Background()
//	dialogflowService, err := dialogflow.NewService(ctx)
//
// In this example, Google Application Default Credentials are used for
// authentication. For information on how to create and obtain Application
// Default Credentials, see https://developers.google.com/identity/protocols/application-default-credentials.
//
// # Other authentication options
//
// By default, all available scopes (see "Constants") are used to authenticate.
// To restrict scopes, use [google.golang.org/api/option.WithScopes]:
//
//	dialogflowService, err := dialogflow.NewService(ctx, option.WithScopes(dialogflow.DialogflowScope))
//
// To use an API key for authentication (note: some APIs do not support API
// keys), use [google.golang.org/api/option.WithAPIKey]:
//
//	dialogflowService, err := dialogflow.NewService(ctx, option.WithAPIKey("AIza..."))
//
// To use an OAuth token (e.g., a user token obtained via a three-legged OAuth
// flow, use [google.golang.org/api/option.WithTokenSource]:
//
//	config := &oauth2.Config{...}
//	// ...
//	token, err := config.Exchange(ctx, ...)
//	dialogflowService, err := dialogflow.NewService(ctx, option.WithTokenSource(config.TokenSource(ctx, token)))
//
// See [google.golang.org/api/option.ClientOption] for details on options.
package dialogflow // import "google.golang.org/api/dialogflow/v3"

import (
	"bytes"
	"context"
	"encoding/json"
	"errors"
	"fmt"
	"io"
	"log/slog"
	"net/http"
	"net/url"
	"strconv"
	"strings"

	"github.com/googleapis/gax-go/v2/internallog"
	googleapi "google.golang.org/api/googleapi"
	internal "google.golang.org/api/internal"
	gensupport "google.golang.org/api/internal/gensupport"
	option "google.golang.org/api/option"
	internaloption "google.golang.org/api/option/internaloption"
	htransport "google.golang.org/api/transport/http"
)

// Always reference these packages, just in case the auto-generated code
// below doesn't.
var _ = bytes.NewBuffer
var _ = strconv.Itoa
var _ = fmt.Sprintf
var _ = json.NewDecoder
var _ = io.Copy
var _ = url.Parse
var _ = gensupport.MarshalJSON
var _ = googleapi.Version
var _ = errors.New
var _ = strings.Replace
var _ = context.Canceled
var _ = internaloption.WithDefaultEndpoint
var _ = internal.Version
var _ = internallog.New

const apiId = "dialogflow:v3"
const apiName = "dialogflow"
const apiVersion = "v3"
const basePath = "https://dialogflow.googleapis.com/"
const basePathTemplate = "https://dialogflow.UNIVERSE_DOMAIN/"
const mtlsBasePath = "https://dialogflow.mtls.googleapis.com/"

// OAuth2 scopes used by this API.
const (
	// See, edit, configure, and delete your Google Cloud data and see the email
	// address for your Google Account.
	CloudPlatformScope = "https://www.googleapis.com/auth/cloud-platform"

	// View, manage and query your Dialogflow agents
	DialogflowScope = "https://www.googleapis.com/auth/dialogflow"
)

// NewService creates a new Service.
func NewService(ctx context.Context, opts ...option.ClientOption) (*Service, error) {
	scopesOption := internaloption.WithDefaultScopes(
		"https://www.googleapis.com/auth/cloud-platform",
		"https://www.googleapis.com/auth/dialogflow",
	)
	// NOTE: prepend, so we don't override user-specified scopes.
	opts = append([]option.ClientOption{scopesOption}, opts...)
	opts = append(opts, internaloption.WithDefaultEndpoint(basePath))
	opts = append(opts, internaloption.WithDefaultEndpointTemplate(basePathTemplate))
	opts = append(opts, internaloption.WithDefaultMTLSEndpoint(mtlsBasePath))
	opts = append(opts, internaloption.EnableNewAuthLibrary())
	client, endpoint, err := htransport.NewClient(ctx, opts...)
	if err != nil {
		return nil, err
	}
	s := &Service{client: client, BasePath: basePath, logger: internaloption.GetLogger(opts)}
	s.Projects = NewProjectsService(s)
	if endpoint != "" {
		s.BasePath = endpoint
	}
	return s, nil
}

// New creates a new Service. It uses the provided http.Client for requests.
//
// Deprecated: please use NewService instead.
// To provide a custom HTTP client, use option.WithHTTPClient.
// If you are using google.golang.org/api/googleapis/transport.APIKey, use option.WithAPIKey with NewService instead.
func New(client *http.Client) (*Service, error) {
	if client == nil {
		return nil, errors.New("client is nil")
	}
	return NewService(context.TODO(), option.WithHTTPClient(client))
}

type Service struct {
	client    *http.Client
	logger    *slog.Logger
	BasePath  string // API endpoint base URL
	UserAgent string // optional additional User-Agent fragment

	Projects *ProjectsService
}

func (s *Service) userAgent() string {
	if s.UserAgent == "" {
		return googleapi.UserAgent
	}
	return googleapi.UserAgent + " " + s.UserAgent
}

func NewProjectsService(s *Service) *ProjectsService {
	rs := &ProjectsService{s: s}
	rs.Locations = NewProjectsLocationsService(s)
	rs.Operations = NewProjectsOperationsService(s)
	return rs
}

type ProjectsService struct {
	s *Service

	Locations *ProjectsLocationsService

	Operations *ProjectsOperationsService
}

func NewProjectsLocationsService(s *Service) *ProjectsLocationsService {
	rs := &ProjectsLocationsService{s: s}
	rs.Agents = NewProjectsLocationsAgentsService(s)
	rs.Operations = NewProjectsLocationsOperationsService(s)
	rs.SecuritySettings = NewProjectsLocationsSecuritySettingsService(s)
	return rs
}

type ProjectsLocationsService struct {
	s *Service

	Agents *ProjectsLocationsAgentsService

	Operations *ProjectsLocationsOperationsService

	SecuritySettings *ProjectsLocationsSecuritySettingsService
}

func NewProjectsLocationsAgentsService(s *Service) *ProjectsLocationsAgentsService {
	rs := &ProjectsLocationsAgentsService{s: s}
	rs.Changelogs = NewProjectsLocationsAgentsChangelogsService(s)
	rs.EntityTypes = NewProjectsLocationsAgentsEntityTypesService(s)
	rs.Environments = NewProjectsLocationsAgentsEnvironmentsService(s)
	rs.Flows = NewProjectsLocationsAgentsFlowsService(s)
	rs.Generators = NewProjectsLocationsAgentsGeneratorsService(s)
	rs.Intents = NewProjectsLocationsAgentsIntentsService(s)
	rs.Playbooks = NewProjectsLocationsAgentsPlaybooksService(s)
	rs.Sessions = NewProjectsLocationsAgentsSessionsService(s)
	rs.TestCases = NewProjectsLocationsAgentsTestCasesService(s)
	rs.Tools = NewProjectsLocationsAgentsToolsService(s)
	rs.TransitionRouteGroups = NewProjectsLocationsAgentsTransitionRouteGroupsService(s)
	rs.Webhooks = NewProjectsLocationsAgentsWebhooksService(s)
	return rs
}

type ProjectsLocationsAgentsService struct {
	s *Service

	Changelogs *ProjectsLocationsAgentsChangelogsService

	EntityTypes *ProjectsLocationsAgentsEntityTypesService

	Environments *ProjectsLocationsAgentsEnvironmentsService

	Flows *ProjectsLocationsAgentsFlowsService

	Generators *ProjectsLocationsAgentsGeneratorsService

	Intents *ProjectsLocationsAgentsIntentsService

	Playbooks *ProjectsLocationsAgentsPlaybooksService

	Sessions *ProjectsLocationsAgentsSessionsService

	TestCases *ProjectsLocationsAgentsTestCasesService

	Tools *ProjectsLocationsAgentsToolsService

	TransitionRouteGroups *ProjectsLocationsAgentsTransitionRouteGroupsService

	Webhooks *ProjectsLocationsAgentsWebhooksService
}

func NewProjectsLocationsAgentsChangelogsService(s *Service) *ProjectsLocationsAgentsChangelogsService {
	rs := &ProjectsLocationsAgentsChangelogsService{s: s}
	return rs
}

type ProjectsLocationsAgentsChangelogsService struct {
	s *Service
}

func NewProjectsLocationsAgentsEntityTypesService(s *Service) *ProjectsLocationsAgentsEntityTypesService {
	rs := &ProjectsLocationsAgentsEntityTypesService{s: s}
	return rs
}

type ProjectsLocationsAgentsEntityTypesService struct {
	s *Service
}

func NewProjectsLocationsAgentsEnvironmentsService(s *Service) *ProjectsLocationsAgentsEnvironmentsService {
	rs := &ProjectsLocationsAgentsEnvironmentsService{s: s}
	rs.ContinuousTestResults = NewProjectsLocationsAgentsEnvironmentsContinuousTestResultsService(s)
	rs.Deployments = NewProjectsLocationsAgentsEnvironmentsDeploymentsService(s)
	rs.Experiments = NewProjectsLocationsAgentsEnvironmentsExperimentsService(s)
	rs.Sessions = NewProjectsLocationsAgentsEnvironmentsSessionsService(s)
	return rs
}

type ProjectsLocationsAgentsEnvironmentsService struct {
	s *Service

	ContinuousTestResults *ProjectsLocationsAgentsEnvironmentsContinuousTestResultsService

	Deployments *ProjectsLocationsAgentsEnvironmentsDeploymentsService

	Experiments *ProjectsLocationsAgentsEnvironmentsExperimentsService

	Sessions *ProjectsLocationsAgentsEnvironmentsSessionsService
}

func NewProjectsLocationsAgentsEnvironmentsContinuousTestResultsService(s *Service) *ProjectsLocationsAgentsEnvironmentsContinuousTestResultsService {
	rs := &ProjectsLocationsAgentsEnvironmentsContinuousTestResultsService{s: s}
	return rs
}

type ProjectsLocationsAgentsEnvironmentsContinuousTestResultsService struct {
	s *Service
}

func NewProjectsLocationsAgentsEnvironmentsDeploymentsService(s *Service) *ProjectsLocationsAgentsEnvironmentsDeploymentsService {
	rs := &ProjectsLocationsAgentsEnvironmentsDeploymentsService{s: s}
	return rs
}

type ProjectsLocationsAgentsEnvironmentsDeploymentsService struct {
	s *Service
}

func NewProjectsLocationsAgentsEnvironmentsExperimentsService(s *Service) *ProjectsLocationsAgentsEnvironmentsExperimentsService {
	rs := &ProjectsLocationsAgentsEnvironmentsExperimentsService{s: s}
	return rs
}

type ProjectsLocationsAgentsEnvironmentsExperimentsService struct {
	s *Service
}

func NewProjectsLocationsAgentsEnvironmentsSessionsService(s *Service) *ProjectsLocationsAgentsEnvironmentsSessionsService {
	rs := &ProjectsLocationsAgentsEnvironmentsSessionsService{s: s}
	rs.EntityTypes = NewProjectsLocationsAgentsEnvironmentsSessionsEntityTypesService(s)
	return rs
}

type ProjectsLocationsAgentsEnvironmentsSessionsService struct {
	s *Service

	EntityTypes *ProjectsLocationsAgentsEnvironmentsSessionsEntityTypesService
}

func NewProjectsLocationsAgentsEnvironmentsSessionsEntityTypesService(s *Service) *ProjectsLocationsAgentsEnvironmentsSessionsEntityTypesService {
	rs := &ProjectsLocationsAgentsEnvironmentsSessionsEntityTypesService{s: s}
	return rs
}

type ProjectsLocationsAgentsEnvironmentsSessionsEntityTypesService struct {
	s *Service
}

func NewProjectsLocationsAgentsFlowsService(s *Service) *ProjectsLocationsAgentsFlowsService {
	rs := &ProjectsLocationsAgentsFlowsService{s: s}
	rs.Pages = NewProjectsLocationsAgentsFlowsPagesService(s)
	rs.TransitionRouteGroups = NewProjectsLocationsAgentsFlowsTransitionRouteGroupsService(s)
	rs.Versions = NewProjectsLocationsAgentsFlowsVersionsService(s)
	return rs
}

type ProjectsLocationsAgentsFlowsService struct {
	s *Service

	Pages *ProjectsLocationsAgentsFlowsPagesService

	TransitionRouteGroups *ProjectsLocationsAgentsFlowsTransitionRouteGroupsService

	Versions *ProjectsLocationsAgentsFlowsVersionsService
}

func NewProjectsLocationsAgentsFlowsPagesService(s *Service) *ProjectsLocationsAgentsFlowsPagesService {
	rs := &ProjectsLocationsAgentsFlowsPagesService{s: s}
	return rs
}

type ProjectsLocationsAgentsFlowsPagesService struct {
	s *Service
}

func NewProjectsLocationsAgentsFlowsTransitionRouteGroupsService(s *Service) *ProjectsLocationsAgentsFlowsTransitionRouteGroupsService {
	rs := &ProjectsLocationsAgentsFlowsTransitionRouteGroupsService{s: s}
	return rs
}

type ProjectsLocationsAgentsFlowsTransitionRouteGroupsService struct {
	s *Service
}

func NewProjectsLocationsAgentsFlowsVersionsService(s *Service) *ProjectsLocationsAgentsFlowsVersionsService {
	rs := &ProjectsLocationsAgentsFlowsVersionsService{s: s}
	return rs
}

type ProjectsLocationsAgentsFlowsVersionsService struct {
	s *Service
}

func NewProjectsLocationsAgentsGeneratorsService(s *Service) *ProjectsLocationsAgentsGeneratorsService {
	rs := &ProjectsLocationsAgentsGeneratorsService{s: s}
	return rs
}

type ProjectsLocationsAgentsGeneratorsService struct {
	s *Service
}

func NewProjectsLocationsAgentsIntentsService(s *Service) *ProjectsLocationsAgentsIntentsService {
	rs := &ProjectsLocationsAgentsIntentsService{s: s}
	return rs
}

type ProjectsLocationsAgentsIntentsService struct {
	s *Service
}

func NewProjectsLocationsAgentsPlaybooksService(s *Service) *ProjectsLocationsAgentsPlaybooksService {
	rs := &ProjectsLocationsAgentsPlaybooksService{s: s}
	rs.Examples = NewProjectsLocationsAgentsPlaybooksExamplesService(s)
	rs.Versions = NewProjectsLocationsAgentsPlaybooksVersionsService(s)
	return rs
}

type ProjectsLocationsAgentsPlaybooksService struct {
	s *Service

	Examples *ProjectsLocationsAgentsPlaybooksExamplesService

	Versions *ProjectsLocationsAgentsPlaybooksVersionsService
}

func NewProjectsLocationsAgentsPlaybooksExamplesService(s *Service) *ProjectsLocationsAgentsPlaybooksExamplesService {
	rs := &ProjectsLocationsAgentsPlaybooksExamplesService{s: s}
	return rs
}

type ProjectsLocationsAgentsPlaybooksExamplesService struct {
	s *Service
}

func NewProjectsLocationsAgentsPlaybooksVersionsService(s *Service) *ProjectsLocationsAgentsPlaybooksVersionsService {
	rs := &ProjectsLocationsAgentsPlaybooksVersionsService{s: s}
	return rs
}

type ProjectsLocationsAgentsPlaybooksVersionsService struct {
	s *Service
}

func NewProjectsLocationsAgentsSessionsService(s *Service) *ProjectsLocationsAgentsSessionsService {
	rs := &ProjectsLocationsAgentsSessionsService{s: s}
	rs.EntityTypes = NewProjectsLocationsAgentsSessionsEntityTypesService(s)
	return rs
}

type ProjectsLocationsAgentsSessionsService struct {
	s *Service

	EntityTypes *ProjectsLocationsAgentsSessionsEntityTypesService
}

func NewProjectsLocationsAgentsSessionsEntityTypesService(s *Service) *ProjectsLocationsAgentsSessionsEntityTypesService {
	rs := &ProjectsLocationsAgentsSessionsEntityTypesService{s: s}
	return rs
}

type ProjectsLocationsAgentsSessionsEntityTypesService struct {
	s *Service
}

func NewProjectsLocationsAgentsTestCasesService(s *Service) *ProjectsLocationsAgentsTestCasesService {
	rs := &ProjectsLocationsAgentsTestCasesService{s: s}
	rs.Results = NewProjectsLocationsAgentsTestCasesResultsService(s)
	return rs
}

type ProjectsLocationsAgentsTestCasesService struct {
	s *Service

	Results *ProjectsLocationsAgentsTestCasesResultsService
}

func NewProjectsLocationsAgentsTestCasesResultsService(s *Service) *ProjectsLocationsAgentsTestCasesResultsService {
	rs := &ProjectsLocationsAgentsTestCasesResultsService{s: s}
	return rs
}

type ProjectsLocationsAgentsTestCasesResultsService struct {
	s *Service
}

func NewProjectsLocationsAgentsToolsService(s *Service) *ProjectsLocationsAgentsToolsService {
	rs := &ProjectsLocationsAgentsToolsService{s: s}
	rs.Versions = NewProjectsLocationsAgentsToolsVersionsService(s)
	return rs
}

type ProjectsLocationsAgentsToolsService struct {
	s *Service

	Versions *ProjectsLocationsAgentsToolsVersionsService
}

func NewProjectsLocationsAgentsToolsVersionsService(s *Service) *ProjectsLocationsAgentsToolsVersionsService {
	rs := &ProjectsLocationsAgentsToolsVersionsService{s: s}
	return rs
}

type ProjectsLocationsAgentsToolsVersionsService struct {
	s *Service
}

func NewProjectsLocationsAgentsTransitionRouteGroupsService(s *Service) *ProjectsLocationsAgentsTransitionRouteGroupsService {
	rs := &ProjectsLocationsAgentsTransitionRouteGroupsService{s: s}
	return rs
}

type ProjectsLocationsAgentsTransitionRouteGroupsService struct {
	s *Service
}

func NewProjectsLocationsAgentsWebhooksService(s *Service) *ProjectsLocationsAgentsWebhooksService {
	rs := &ProjectsLocationsAgentsWebhooksService{s: s}
	return rs
}

type ProjectsLocationsAgentsWebhooksService struct {
	s *Service
}

func NewProjectsLocationsOperationsService(s *Service) *ProjectsLocationsOperationsService {
	rs := &ProjectsLocationsOperationsService{s: s}
	return rs
}

type ProjectsLocationsOperationsService struct {
	s *Service
}

func NewProjectsLocationsSecuritySettingsService(s *Service) *ProjectsLocationsSecuritySettingsService {
	rs := &ProjectsLocationsSecuritySettingsService{s: s}
	return rs
}

type ProjectsLocationsSecuritySettingsService struct {
	s *Service
}

func NewProjectsOperationsService(s *Service) *ProjectsOperationsService {
	rs := &ProjectsOperationsService{s: s}
	return rs
}

type ProjectsOperationsService struct {
	s *Service
}

type GoogleCloudDialogflowCxV3Action struct {
	AgentUtterance     *GoogleCloudDialogflowCxV3AgentUtterance     `json:"agentUtterance,omitempty"`
	FlowInvocation     *GoogleCloudDialogflowCxV3FlowInvocation     `json:"flowInvocation,omitempty"`
	FlowTransition     *GoogleCloudDialogflowCxV3FlowTransition     `json:"flowTransition,omitempty"`
	PlaybookInvocation *GoogleCloudDialogflowCxV3PlaybookInvocation `json:"playbookInvocation,omitempty"`
	PlaybookTransition *GoogleCloudDialogflowCxV3PlaybookTransition `json:"playbookTransition,omitempty"`
	ToolUse            *GoogleCloudDialogflowCxV3ToolUse            `json:"toolUse,omitempty"`
	UserUtterance      *GoogleCloudDialogflowCxV3UserUtterance      `json:"userUtterance,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AgentUtterance") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AgentUtterance") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3Action) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3Action
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowCxV3AdvancedSettings struct {
	AudioExportGcsDestination *GoogleCloudDialogflowCxV3GcsDestination                  `json:"audioExportGcsDestination,omitempty"`
	DtmfSettings              *GoogleCloudDialogflowCxV3AdvancedSettingsDtmfSettings    `json:"dtmfSettings,omitempty"`
	LoggingSettings           *GoogleCloudDialogflowCxV3AdvancedSettingsLoggingSettings `json:"loggingSettings,omitempty"`
	SpeechSettings            *GoogleCloudDialogflowCxV3AdvancedSettingsSpeechSettings  `json:"speechSettings,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AudioExportGcsDestination")
	// to unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AudioExportGcsDestination") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3AdvancedSettings) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3AdvancedSettings
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowCxV3AdvancedSettingsDtmfSettings struct {
	Enabled                    bool   `json:"enabled,omitempty"`
	EndpointingTimeoutDuration string `json:"endpointingTimeoutDuration,omitempty"`
	FinishDigit                string `json:"finishDigit,omitempty"`
	InterdigitTimeoutDuration  string `json:"interdigitTimeoutDuration,omitempty"`
	MaxDigits                  int64  `json:"maxDigits,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Enabled") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Enabled") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3AdvancedSettingsDtmfSettings) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3AdvancedSettingsDtmfSettings
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowCxV3AdvancedSettingsLoggingSettings struct {
	EnableConsentBasedRedaction bool `json:"enableConsentBasedRedaction,omitempty"`
	EnableInteractionLogging    bool `json:"enableInteractionLogging,omitempty"`
	EnableStackdriverLogging    bool `json:"enableStackdriverLogging,omitempty"`
	// ForceSendFields is a list of field names (e.g.
	// "EnableConsentBasedRedaction") to unconditionally include in API requests.
	// By default, fields with empty or default values are omitted from API
	// requests. See https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields
	// for more details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "EnableConsentBasedRedaction") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3AdvancedSettingsLoggingSettings) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3AdvancedSettingsLoggingSettings
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowCxV3AdvancedSettingsSpeechSettings struct {
	EndpointerSensitivity      int64             `json:"endpointerSensitivity,omitempty"`
	Models                     map[string]string `json:"models,omitempty"`
	NoSpeechTimeout            string            `json:"noSpeechTimeout,omitempty"`
	UseTimeoutBasedEndpointing bool              `json:"useTimeoutBasedEndpointing,omitempty"`
	// ForceSendFields is a list of field names (e.g. "EndpointerSensitivity") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "EndpointerSensitivity") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3AdvancedSettingsSpeechSettings) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3AdvancedSettingsSpeechSettings
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowCxV3Agent struct {
	AdvancedSettings            *GoogleCloudDialogflowCxV3AdvancedSettings               `json:"advancedSettings,omitempty"`
	AnswerFeedbackSettings      *GoogleCloudDialogflowCxV3AgentAnswerFeedbackSettings    `json:"answerFeedbackSettings,omitempty"`
	AvatarUri                   string                                                   `json:"avatarUri,omitempty"`
	ClientCertificateSettings   *GoogleCloudDialogflowCxV3AgentClientCertificateSettings `json:"clientCertificateSettings,omitempty"`
	DefaultLanguageCode         string                                                   `json:"defaultLanguageCode,omitempty"`
	Description                 string                                                   `json:"description,omitempty"`
	DisplayName                 string                                                   `json:"displayName,omitempty"`
	EnableMultiLanguageTraining bool                                                     `json:"enableMultiLanguageTraining,omitempty"`
	EnableSpellCorrection       bool                                                     `json:"enableSpellCorrection,omitempty"`
	EnableStackdriverLogging    bool                                                     `json:"enableStackdriverLogging,omitempty"`
	GenAppBuilderSettings       *GoogleCloudDialogflowCxV3AgentGenAppBuilderSettings     `json:"genAppBuilderSettings,omitempty"`
	GitIntegrationSettings      *GoogleCloudDialogflowCxV3AgentGitIntegrationSettings    `json:"gitIntegrationSettings,omitempty"`
	Locked                      bool                                                     `json:"locked,omitempty"`
	Name                        string                                                   `json:"name,omitempty"`
	PersonalizationSettings     *GoogleCloudDialogflowCxV3AgentPersonalizationSettings   `json:"personalizationSettings,omitempty"`
	SatisfiesPzi                bool                                                     `json:"satisfiesPzi,omitempty"`
	SatisfiesPzs                bool                                                     `json:"satisfiesPzs,omitempty"`
	SecuritySettings            string                                                   `json:"securitySettings,omitempty"`
	SpeechToTextSettings        *GoogleCloudDialogflowCxV3SpeechToTextSettings           `json:"speechToTextSettings,omitempty"`
	StartFlow                   string                                                   `json:"startFlow,omitempty"`
	StartPlaybook               string                                                   `json:"startPlaybook,omitempty"`
	SupportedLanguageCodes      []string                                                 `json:"supportedLanguageCodes,omitempty"`
	TextToSpeechSettings        *GoogleCloudDialogflowCxV3TextToSpeechSettings           `json:"textToSpeechSettings,omitempty"`
	TimeZone                    string                                                   `json:"timeZone,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "AdvancedSettings") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AdvancedSettings") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3Agent) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3Agent
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowCxV3AgentAnswerFeedbackSettings struct {
	EnableAnswerFeedback bool `json:"enableAnswerFeedback,omitempty"`
	// ForceSendFields is a list of field names (e.g. "EnableAnswerFeedback") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "EnableAnswerFeedback") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3AgentAnswerFeedbackSettings) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3AgentAnswerFeedbackSettings
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowCxV3AgentClientCertificateSettings struct {
	Passphrase     string `json:"passphrase,omitempty"`
	PrivateKey     string `json:"privateKey,omitempty"`
	SslCertificate string `json:"sslCertificate,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Passphrase") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Passphrase") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3AgentClientCertificateSettings) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3AgentClientCertificateSettings
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowCxV3AgentGenAppBuilderSettings struct {
	Engine string `json:"engine,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Engine") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Engine") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3AgentGenAppBuilderSettings) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3AgentGenAppBuilderSettings
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowCxV3AgentGitIntegrationSettings struct {
	GithubSettings *GoogleCloudDialogflowCxV3AgentGitIntegrationSettingsGithubSettings `json:"githubSettings,omitempty"`
	// ForceSendFields is a list of field names (e.g. "GithubSettings") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "GithubSettings") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3AgentGitIntegrationSettings) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3AgentGitIntegrationSettings
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowCxV3AgentGitIntegrationSettingsGithubSettings struct {
	AccessToken    string   `json:"accessToken,omitempty"`
	Branches       []string `json:"branches,omitempty"`
	DisplayName    string   `json:"displayName,omitempty"`
	RepositoryUri  string   `json:"repositoryUri,omitempty"`
	TrackingBranch string   `json:"trackingBranch,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AccessToken") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AccessToken") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3AgentGitIntegrationSettingsGithubSettings) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3AgentGitIntegrationSettingsGithubSettings
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowCxV3AgentPersonalizationSettings struct {
	DefaultEndUserMetadata googleapi.RawMessage `json:"defaultEndUserMetadata,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DefaultEndUserMetadata") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DefaultEndUserMetadata") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3AgentPersonalizationSettings) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3AgentPersonalizationSettings
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowCxV3AgentUtterance struct {
	Text string `json:"text,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Text") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Text") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3AgentUtterance) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3AgentUtterance
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowCxV3AgentValidationResult struct {
	FlowValidationResults []*GoogleCloudDialogflowCxV3FlowValidationResult `json:"flowValidationResults,omitempty"`
	Name                  string                                           `json:"name,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "FlowValidationResults") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "FlowValidationResults") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3AgentValidationResult) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3AgentValidationResult
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowCxV3AnswerFeedback struct {
	CustomRating string `json:"customRating,omitempty"`
	// Possible values:
	//   "RATING_UNSPECIFIED"
	//   "THUMBS_UP"
	//   "THUMBS_DOWN"
	Rating       string                                               `json:"rating,omitempty"`
	RatingReason *GoogleCloudDialogflowCxV3AnswerFeedbackRatingReason `json:"ratingReason,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "CustomRating") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CustomRating") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3AnswerFeedback) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3AnswerFeedback
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowCxV3AnswerFeedbackRatingReason struct {
	Feedback     string   `json:"feedback,omitempty"`
	ReasonLabels []string `json:"reasonLabels,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Feedback") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Feedback") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3AnswerFeedbackRatingReason) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3AnswerFeedbackRatingReason
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowCxV3AudioInput struct {
	Audio  string                                     `json:"audio,omitempty"`
	Config *GoogleCloudDialogflowCxV3InputAudioConfig `json:"config,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Audio") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Audio") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3AudioInput) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3AudioInput
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowCxV3BargeInConfig struct {
	NoBargeInDuration string `json:"noBargeInDuration,omitempty"`
	TotalDuration     string `json:"totalDuration,omitempty"`
	// ForceSendFields is a list of field names (e.g. "NoBargeInDuration") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "NoBargeInDuration") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3BargeInConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3BargeInConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowCxV3BatchDeleteTestCasesRequest struct {
	Names []string `json:"names,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Names") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Names") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3BatchDeleteTestCasesRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3BatchDeleteTestCasesRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowCxV3BatchRunTestCasesMetadata struct {
	Errors []*GoogleCloudDialogflowCxV3TestError `json:"errors,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Errors") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Errors") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3BatchRunTestCasesMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3BatchRunTestCasesMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowCxV3BatchRunTestCasesRequest struct {
	Environment string   `json:"environment,omitempty"`
	TestCases   []string `json:"testCases,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Environment") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Environment") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3BatchRunTestCasesRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3BatchRunTestCasesRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowCxV3BatchRunTestCasesResponse struct {
	Results []*GoogleCloudDialogflowCxV3TestCaseResult `json:"results,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Results") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Results") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3BatchRunTestCasesResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3BatchRunTestCasesResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowCxV3BoostSpec struct {
	ConditionBoostSpecs []*GoogleCloudDialogflowCxV3BoostSpecConditionBoostSpec `json:"conditionBoostSpecs,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ConditionBoostSpecs") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ConditionBoostSpecs") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3BoostSpec) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3BoostSpec
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowCxV3BoostSpecConditionBoostSpec struct {
	Boost            float64                                                               `json:"boost,omitempty"`
	BoostControlSpec *GoogleCloudDialogflowCxV3BoostSpecConditionBoostSpecBoostControlSpec `json:"boostControlSpec,omitempty"`
	Condition        string                                                                `json:"condition,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Boost") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Boost") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3BoostSpecConditionBoostSpec) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3BoostSpecConditionBoostSpec
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *GoogleCloudDialogflowCxV3BoostSpecConditionBoostSpec) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleCloudDialogflowCxV3BoostSpecConditionBoostSpec
	var s1 struct {
		Boost gensupport.JSONFloat64 `json:"boost"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.Boost = float64(s1.Boost)
	return nil
}

type GoogleCloudDialogflowCxV3BoostSpecConditionBoostSpecBoostControlSpec struct {
	// Possible values:
	//   "ATTRIBUTE_TYPE_UNSPECIFIED"
	//   "NUMERICAL"
	//   "FRESHNESS"
	AttributeType string                                                                              `json:"attributeType,omitempty"`
	ControlPoints []*GoogleCloudDialogflowCxV3BoostSpecConditionBoostSpecBoostControlSpecControlPoint `json:"controlPoints,omitempty"`
	FieldName     string                                                                              `json:"fieldName,omitempty"`
	// Possible values:
	//   "INTERPOLATION_TYPE_UNSPECIFIED"
	//   "LINEAR"
	InterpolationType string `json:"interpolationType,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AttributeType") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AttributeType") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3BoostSpecConditionBoostSpecBoostControlSpec) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3BoostSpecConditionBoostSpecBoostControlSpec
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowCxV3BoostSpecConditionBoostSpecBoostControlSpecControlPoint struct {
	AttributeValue string  `json:"attributeValue,omitempty"`
	BoostAmount    float64 `json:"boostAmount,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AttributeValue") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AttributeValue") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3BoostSpecConditionBoostSpecBoostControlSpecControlPoint) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3BoostSpecConditionBoostSpecBoostControlSpecControlPoint
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *GoogleCloudDialogflowCxV3BoostSpecConditionBoostSpecBoostControlSpecControlPoint) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleCloudDialogflowCxV3BoostSpecConditionBoostSpecBoostControlSpecControlPoint
	var s1 struct {
		BoostAmount gensupport.JSONFloat64 `json:"boostAmount"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.BoostAmount = float64(s1.BoostAmount)
	return nil
}

type GoogleCloudDialogflowCxV3BoostSpecs struct {
	DataStores []string                              `json:"dataStores,omitempty"`
	Spec       []*GoogleCloudDialogflowCxV3BoostSpec `json:"spec,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DataStores") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DataStores") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3BoostSpecs) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3BoostSpecs
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowCxV3CalculateCoverageResponse struct {
	Agent              string                                                 `json:"agent,omitempty"`
	IntentCoverage     *GoogleCloudDialogflowCxV3IntentCoverage               `json:"intentCoverage,omitempty"`
	RouteGroupCoverage *GoogleCloudDialogflowCxV3TransitionRouteGroupCoverage `json:"routeGroupCoverage,omitempty"`
	TransitionCoverage *GoogleCloudDialogflowCxV3TransitionCoverage           `json:"transitionCoverage,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Agent") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Agent") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3CalculateCoverageResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3CalculateCoverageResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowCxV3Changelog struct {
	Action       string `json:"action,omitempty"`
	CreateTime   string `json:"createTime,omitempty"`
	DisplayName  string `json:"displayName,omitempty"`
	LanguageCode string `json:"languageCode,omitempty"`
	Name         string `json:"name,omitempty"`
	Resource     string `json:"resource,omitempty"`
	Type         string `json:"type,omitempty"`
	UserEmail    string `json:"userEmail,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Action") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Action") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3Changelog) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3Changelog
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowCxV3CodeBlock struct {
	Code string `json:"code,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Code") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Code") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3CodeBlock) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3CodeBlock
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowCxV3CompareVersionsRequest struct {
	LanguageCode  string `json:"languageCode,omitempty"`
	TargetVersion string `json:"targetVersion,omitempty"`
	// ForceSendFields is a list of field names (e.g. "LanguageCode") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "LanguageCode") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3CompareVersionsRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3CompareVersionsRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowCxV3CompareVersionsResponse struct {
	BaseVersionContentJson   string `json:"baseVersionContentJson,omitempty"`
	CompareTime              string `json:"compareTime,omitempty"`
	TargetVersionContentJson string `json:"targetVersionContentJson,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "BaseVersionContentJson") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "BaseVersionContentJson") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3CompareVersionsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3CompareVersionsResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowCxV3ContinuousTestResult struct {
	Name string `json:"name,omitempty"`
	// Possible values:
	//   "AGGREGATED_TEST_RESULT_UNSPECIFIED"
	//   "PASSED"
	//   "FAILED"
	Result          string   `json:"result,omitempty"`
	RunTime         string   `json:"runTime,omitempty"`
	TestCaseResults []string `json:"testCaseResults,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Name") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Name") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3ContinuousTestResult) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3ContinuousTestResult
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowCxV3ConversationSignals struct {
	TurnSignals *GoogleCloudDialogflowCxV3TurnSignals `json:"turnSignals,omitempty"`
	// ForceSendFields is a list of field names (e.g. "TurnSignals") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "TurnSignals") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3ConversationSignals) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3ConversationSignals
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowCxV3ConversationTurn struct {
	UserInput          *GoogleCloudDialogflowCxV3ConversationTurnUserInput          `json:"userInput,omitempty"`
	VirtualAgentOutput *GoogleCloudDialogflowCxV3ConversationTurnVirtualAgentOutput `json:"virtualAgentOutput,omitempty"`
	// ForceSendFields is a list of field names (e.g. "UserInput") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "UserInput") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3ConversationTurn) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3ConversationTurn
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowCxV3ConversationTurnUserInput struct {
	EnableSentimentAnalysis bool                                 `json:"enableSentimentAnalysis,omitempty"`
	InjectedParameters      googleapi.RawMessage                 `json:"injectedParameters,omitempty"`
	Input                   *GoogleCloudDialogflowCxV3QueryInput `json:"input,omitempty"`
	IsWebhookEnabled        bool                                 `json:"isWebhookEnabled,omitempty"`
	// ForceSendFields is a list of field names (e.g. "EnableSentimentAnalysis") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "EnableSentimentAnalysis") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3ConversationTurnUserInput) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3ConversationTurnUserInput
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowCxV3ConversationTurnVirtualAgentOutput struct {
	CurrentPage       *GoogleCloudDialogflowCxV3Page                  `json:"currentPage,omitempty"`
	DiagnosticInfo    googleapi.RawMessage                            `json:"diagnosticInfo,omitempty"`
	Differences       []*GoogleCloudDialogflowCxV3TestRunDifference   `json:"differences,omitempty"`
	SessionParameters googleapi.RawMessage                            `json:"sessionParameters,omitempty"`
	Status            *GoogleRpcStatus                                `json:"status,omitempty"`
	TextResponses     []*GoogleCloudDialogflowCxV3ResponseMessageText `json:"textResponses,omitempty"`
	TriggeredIntent   *GoogleCloudDialogflowCxV3Intent                `json:"triggeredIntent,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CurrentPage") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CurrentPage") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3ConversationTurnVirtualAgentOutput) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3ConversationTurnVirtualAgentOutput
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowCxV3CreateVersionOperationMetadata struct {
	Version string `json:"version,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Version") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Version") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3CreateVersionOperationMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3CreateVersionOperationMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowCxV3DataStoreConnection struct {
	DataStore string `json:"dataStore,omitempty"`
	// Possible values:
	//   "DATA_STORE_TYPE_UNSPECIFIED"
	//   "PUBLIC_WEB"
	//   "UNSTRUCTURED"
	//   "STRUCTURED"
	DataStoreType string `json:"dataStoreType,omitempty"`
	// Possible values:
	//   "DOCUMENT_PROCESSING_MODE_UNSPECIFIED"
	//   "DOCUMENTS"
	//   "CHUNKS"
	DocumentProcessingMode string `json:"documentProcessingMode,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DataStore") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DataStore") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3DataStoreConnection) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3DataStoreConnection
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowCxV3DataStoreConnectionSignals struct {
	Answer                           string                                                                               `json:"answer,omitempty"`
	AnswerGenerationModelCallSignals *GoogleCloudDialogflowCxV3DataStoreConnectionSignalsAnswerGenerationModelCallSignals `json:"answerGenerationModelCallSignals,omitempty"`
	AnswerParts                      []*GoogleCloudDialogflowCxV3DataStoreConnectionSignalsAnswerPart                     `json:"answerParts,omitempty"`
	CitedSnippets                    []*GoogleCloudDialogflowCxV3DataStoreConnectionSignalsCitedSnippet                   `json:"citedSnippets,omitempty"`
	GroundingSignals                 *GoogleCloudDialogflowCxV3DataStoreConnectionSignalsGroundingSignals                 `json:"groundingSignals,omitempty"`
	RewriterModelCallSignals         *GoogleCloudDialogflowCxV3DataStoreConnectionSignalsRewriterModelCallSignals         `json:"rewriterModelCallSignals,omitempty"`
	RewrittenQuery                   string                                                                               `json:"rewrittenQuery,omitempty"`
	SafetySignals                    *GoogleCloudDialogflowCxV3DataStoreConnectionSignalsSafetySignals                    `json:"safetySignals,omitempty"`
	SearchSnippets                   []*GoogleCloudDialogflowCxV3DataStoreConnectionSignalsSearchSnippet                  `json:"searchSnippets,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Answer") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Answer") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3DataStoreConnectionSignals) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3DataStoreConnectionSignals
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowCxV3DataStoreConnectionSignalsAnswerGenerationModelCallSignals struct {
	Model          string `json:"model,omitempty"`
	ModelOutput    string `json:"modelOutput,omitempty"`
	RenderedPrompt string `json:"renderedPrompt,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Model") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Model") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3DataStoreConnectionSignalsAnswerGenerationModelCallSignals) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3DataStoreConnectionSignalsAnswerGenerationModelCallSignals
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowCxV3DataStoreConnectionSignalsAnswerPart struct {
	SupportingIndices []int64 `json:"supportingIndices,omitempty"`
	Text              string  `json:"text,omitempty"`
	// ForceSendFields is a list of field names (e.g. "SupportingIndices") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "SupportingIndices") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3DataStoreConnectionSignalsAnswerPart) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3DataStoreConnectionSignalsAnswerPart
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowCxV3DataStoreConnectionSignalsCitedSnippet struct {
	SearchSnippet *GoogleCloudDialogflowCxV3DataStoreConnectionSignalsSearchSnippet `json:"searchSnippet,omitempty"`
	SnippetIndex  int64                                                             `json:"snippetIndex,omitempty"`
	// ForceSendFields is a list of field names (e.g. "SearchSnippet") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "SearchSnippet") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3DataStoreConnectionSignalsCitedSnippet) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3DataStoreConnectionSignalsCitedSnippet
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowCxV3DataStoreConnectionSignalsGroundingSignals struct {
	// Possible values:
	//   "GROUNDING_DECISION_UNSPECIFIED"
	//   "ACCEPTED_BY_GROUNDING"
	//   "REJECTED_BY_GROUNDING"
	Decision string `json:"decision,omitempty"`
	// Possible values:
	//   "GROUNDING_SCORE_BUCKET_UNSPECIFIED"
	//   "VERY_LOW"
	//   "LOW"
	//   "MEDIUM"
	//   "HIGH"
	//   "VERY_HIGH"
	Score string `json:"score,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Decision") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Decision") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3DataStoreConnectionSignalsGroundingSignals) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3DataStoreConnectionSignalsGroundingSignals
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowCxV3DataStoreConnectionSignalsRewriterModelCallSignals struct {
	Model          string `json:"model,omitempty"`
	ModelOutput    string `json:"modelOutput,omitempty"`
	RenderedPrompt string `json:"renderedPrompt,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Model") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Model") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3DataStoreConnectionSignalsRewriterModelCallSignals) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3DataStoreConnectionSignalsRewriterModelCallSignals
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowCxV3DataStoreConnectionSignalsSafetySignals struct {
	// Possible values:
	//   "BANNED_PHRASE_MATCH_UNSPECIFIED"
	//   "BANNED_PHRASE_MATCH_NONE"
	//   "BANNED_PHRASE_MATCH_QUERY"
	//   "BANNED_PHRASE_MATCH_RESPONSE"
	BannedPhraseMatch string `json:"bannedPhraseMatch,omitempty"`
	// Possible values:
	//   "SAFETY_DECISION_UNSPECIFIED"
	//   "ACCEPTED_BY_SAFETY_CHECK"
	//   "REJECTED_BY_SAFETY_CHECK"
	Decision            string `json:"decision,omitempty"`
	MatchedBannedPhrase string `json:"matchedBannedPhrase,omitempty"`
	// ForceSendFields is a list of field names (e.g. "BannedPhraseMatch") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "BannedPhraseMatch") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3DataStoreConnectionSignalsSafetySignals) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3DataStoreConnectionSignalsSafetySignals
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowCxV3DataStoreConnectionSignalsSearchSnippet struct {
	DocumentTitle string               `json:"documentTitle,omitempty"`
	DocumentUri   string               `json:"documentUri,omitempty"`
	Metadata      googleapi.RawMessage `json:"metadata,omitempty"`
	Text          string               `json:"text,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DocumentTitle") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DocumentTitle") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3DataStoreConnectionSignalsSearchSnippet) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3DataStoreConnectionSignalsSearchSnippet
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowCxV3DeployFlowMetadata struct {
	TestErrors []*GoogleCloudDialogflowCxV3TestError `json:"testErrors,omitempty"`
	// ForceSendFields is a list of field names (e.g. "TestErrors") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "TestErrors") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3DeployFlowMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3DeployFlowMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowCxV3DeployFlowRequest struct {
	FlowVersion string `json:"flowVersion,omitempty"`
	// ForceSendFields is a list of field names (e.g. "FlowVersion") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "FlowVersion") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3DeployFlowRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3DeployFlowRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowCxV3DeployFlowResponse struct {
	Deployment  string                                `json:"deployment,omitempty"`
	Environment *GoogleCloudDialogflowCxV3Environment `json:"environment,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Deployment") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Deployment") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3DeployFlowResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3DeployFlowResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowCxV3Deployment struct {
	EndTime     string                                     `json:"endTime,omitempty"`
	FlowVersion string                                     `json:"flowVersion,omitempty"`
	Name        string                                     `json:"name,omitempty"`
	Result      *GoogleCloudDialogflowCxV3DeploymentResult `json:"result,omitempty"`
	StartTime   string                                     `json:"startTime,omitempty"`
	// Possible values:
	//   "STATE_UNSPECIFIED"
	//   "RUNNING"
	//   "SUCCEEDED"
	//   "FAILED"
	State string `json:"state,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "EndTime") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "EndTime") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3Deployment) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3Deployment
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowCxV3DeploymentResult struct {
	DeploymentTestResults []string `json:"deploymentTestResults,omitempty"`
	Experiment            string   `json:"experiment,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DeploymentTestResults") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DeploymentTestResults") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3DeploymentResult) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3DeploymentResult
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowCxV3DetectIntentRequest struct {
	OutputAudioConfig *GoogleCloudDialogflowCxV3OutputAudioConfig `json:"outputAudioConfig,omitempty"`
	QueryInput        *GoogleCloudDialogflowCxV3QueryInput        `json:"queryInput,omitempty"`
	QueryParams       *GoogleCloudDialogflowCxV3QueryParameters   `json:"queryParams,omitempty"`
	// Possible values:
	//   "DETECT_INTENT_RESPONSE_VIEW_UNSPECIFIED"
	//   "DETECT_INTENT_RESPONSE_VIEW_FULL"
	//   "DETECT_INTENT_RESPONSE_VIEW_BASIC"
	//   "DETECT_INTENT_RESPONSE_VIEW_DEFAULT"
	ResponseView string `json:"responseView,omitempty"`
	// ForceSendFields is a list of field names (e.g. "OutputAudioConfig") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "OutputAudioConfig") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3DetectIntentRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3DetectIntentRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowCxV3DetectIntentResponse struct {
	AllowCancellation bool                                        `json:"allowCancellation,omitempty"`
	OutputAudio       string                                      `json:"outputAudio,omitempty"`
	OutputAudioConfig *GoogleCloudDialogflowCxV3OutputAudioConfig `json:"outputAudioConfig,omitempty"`
	QueryResult       *GoogleCloudDialogflowCxV3QueryResult       `json:"queryResult,omitempty"`
	ResponseId        string                                      `json:"responseId,omitempty"`
	// Possible values:
	//   "RESPONSE_TYPE_UNSPECIFIED"
	//   "PARTIAL"
	//   "FINAL"
	ResponseType string `json:"responseType,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "AllowCancellation") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AllowCancellation") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3DetectIntentResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3DetectIntentResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowCxV3DtmfInput struct {
	Digits      string `json:"digits,omitempty"`
	FinishDigit string `json:"finishDigit,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Digits") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Digits") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3DtmfInput) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3DtmfInput
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowCxV3EntityType struct {
	// Possible values:
	//   "AUTO_EXPANSION_MODE_UNSPECIFIED"
	//   "AUTO_EXPANSION_MODE_DEFAULT"
	AutoExpansionMode     string                                               `json:"autoExpansionMode,omitempty"`
	DisplayName           string                                               `json:"displayName,omitempty"`
	EnableFuzzyExtraction bool                                                 `json:"enableFuzzyExtraction,omitempty"`
	Entities              []*GoogleCloudDialogflowCxV3EntityTypeEntity         `json:"entities,omitempty"`
	ExcludedPhrases       []*GoogleCloudDialogflowCxV3EntityTypeExcludedPhrase `json:"excludedPhrases,omitempty"`
	// Possible values:
	//   "KIND_UNSPECIFIED"
	//   "KIND_MAP"
	//   "KIND_LIST"
	//   "KIND_REGEXP"
	Kind   string `json:"kind,omitempty"`
	Name   string `json:"name,omitempty"`
	Redact bool   `json:"redact,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "AutoExpansionMode") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AutoExpansionMode") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3EntityType) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3EntityType
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowCxV3EntityTypeEntity struct {
	Synonyms []string `json:"synonyms,omitempty"`
	Value    string   `json:"value,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Synonyms") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Synonyms") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3EntityTypeEntity) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3EntityTypeEntity
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowCxV3EntityTypeExcludedPhrase struct {
	Value string `json:"value,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Value") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Value") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3EntityTypeExcludedPhrase) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3EntityTypeExcludedPhrase
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowCxV3Environment struct {
	Description     string                                               `json:"description,omitempty"`
	DisplayName     string                                               `json:"displayName,omitempty"`
	Name            string                                               `json:"name,omitempty"`
	TestCasesConfig *GoogleCloudDialogflowCxV3EnvironmentTestCasesConfig `json:"testCasesConfig,omitempty"`
	UpdateTime      string                                               `json:"updateTime,omitempty"`
	VersionConfigs  []*GoogleCloudDialogflowCxV3EnvironmentVersionConfig `json:"versionConfigs,omitempty"`
	WebhookConfig   *GoogleCloudDialogflowCxV3EnvironmentWebhookConfig   `json:"webhookConfig,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Description") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Description") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3Environment) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3Environment
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowCxV3EnvironmentTestCasesConfig struct {
	EnableContinuousRun    bool     `json:"enableContinuousRun,omitempty"`
	EnablePredeploymentRun bool     `json:"enablePredeploymentRun,omitempty"`
	TestCases              []string `json:"testCases,omitempty"`
	// ForceSendFields is a list of field names (e.g. "EnableContinuousRun") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "EnableContinuousRun") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3EnvironmentTestCasesConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3EnvironmentTestCasesConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowCxV3EnvironmentVersionConfig struct {
	Version string `json:"version,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Version") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Version") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3EnvironmentVersionConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3EnvironmentVersionConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowCxV3EnvironmentWebhookConfig struct {
	WebhookOverrides []*GoogleCloudDialogflowCxV3Webhook `json:"webhookOverrides,omitempty"`
	// ForceSendFields is a list of field names (e.g. "WebhookOverrides") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "WebhookOverrides") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3EnvironmentWebhookConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3EnvironmentWebhookConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowCxV3EventHandler struct {
	Event              string                                `json:"event,omitempty"`
	Name               string                                `json:"name,omitempty"`
	TargetFlow         string                                `json:"targetFlow,omitempty"`
	TargetPage         string                                `json:"targetPage,omitempty"`
	TargetPlaybook     string                                `json:"targetPlaybook,omitempty"`
	TriggerFulfillment *GoogleCloudDialogflowCxV3Fulfillment `json:"triggerFulfillment,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Event") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Event") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3EventHandler) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3EventHandler
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowCxV3EventInput struct {
	Event string `json:"event,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Event") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Event") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3EventInput) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3EventInput
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowCxV3Example struct {
	Actions []*GoogleCloudDialogflowCxV3Action `json:"actions,omitempty"`
	// Possible values:
	//   "OUTPUT_STATE_UNSPECIFIED"
	//   "OUTPUT_STATE_OK"
	//   "OUTPUT_STATE_CANCELLED"
	//   "OUTPUT_STATE_FAILED"
	//   "OUTPUT_STATE_ESCALATED"
	//   "OUTPUT_STATE_PENDING"
	ConversationState string                                   `json:"conversationState,omitempty"`
	CreateTime        string                                   `json:"createTime,omitempty"`
	Description       string                                   `json:"description,omitempty"`
	DisplayName       string                                   `json:"displayName,omitempty"`
	LanguageCode      string                                   `json:"languageCode,omitempty"`
	Name              string                                   `json:"name,omitempty"`
	PlaybookInput     *GoogleCloudDialogflowCxV3PlaybookInput  `json:"playbookInput,omitempty"`
	PlaybookOutput    *GoogleCloudDialogflowCxV3PlaybookOutput `json:"playbookOutput,omitempty"`
	TokenCount        int64                                    `json:"tokenCount,omitempty,string"`
	UpdateTime        string                                   `json:"updateTime,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Actions") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Actions") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3Example) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3Example
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowCxV3Experiment struct {
	CreateTime           string                                         `json:"createTime,omitempty"`
	Definition           *GoogleCloudDialogflowCxV3ExperimentDefinition `json:"definition,omitempty"`
	Description          string                                         `json:"description,omitempty"`
	DisplayName          string                                         `json:"displayName,omitempty"`
	EndTime              string                                         `json:"endTime,omitempty"`
	ExperimentLength     string                                         `json:"experimentLength,omitempty"`
	LastUpdateTime       string                                         `json:"lastUpdateTime,omitempty"`
	Name                 string                                         `json:"name,omitempty"`
	Result               *GoogleCloudDialogflowCxV3ExperimentResult     `json:"result,omitempty"`
	RolloutConfig        *GoogleCloudDialogflowCxV3RolloutConfig        `json:"rolloutConfig,omitempty"`
	RolloutFailureReason string                                         `json:"rolloutFailureReason,omitempty"`
	RolloutState         *GoogleCloudDialogflowCxV3RolloutState         `json:"rolloutState,omitempty"`
	StartTime            string                                         `json:"startTime,omitempty"`
	// Possible values:
	//   "STATE_UNSPECIFIED"
	//   "DRAFT"
	//   "RUNNING"
	//   "DONE"
	//   "ROLLOUT_FAILED"
	State           string                                      `json:"state,omitempty"`
	VariantsHistory []*GoogleCloudDialogflowCxV3VariantsHistory `json:"variantsHistory,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "CreateTime") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CreateTime") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3Experiment) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3Experiment
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowCxV3ExperimentDefinition struct {
	Condition       string                                    `json:"condition,omitempty"`
	VersionVariants *GoogleCloudDialogflowCxV3VersionVariants `json:"versionVariants,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Condition") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Condition") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3ExperimentDefinition) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3ExperimentDefinition
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowCxV3ExperimentResult struct {
	LastUpdateTime string                                                     `json:"lastUpdateTime,omitempty"`
	VersionMetrics []*GoogleCloudDialogflowCxV3ExperimentResultVersionMetrics `json:"versionMetrics,omitempty"`
	// ForceSendFields is a list of field names (e.g. "LastUpdateTime") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "LastUpdateTime") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3ExperimentResult) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3ExperimentResult
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowCxV3ExperimentResultConfidenceInterval struct {
	ConfidenceLevel float64 `json:"confidenceLevel,omitempty"`
	LowerBound      float64 `json:"lowerBound,omitempty"`
	Ratio           float64 `json:"ratio,omitempty"`
	UpperBound      float64 `json:"upperBound,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ConfidenceLevel") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ConfidenceLevel") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3ExperimentResultConfidenceInterval) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3ExperimentResultConfidenceInterval
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *GoogleCloudDialogflowCxV3ExperimentResultConfidenceInterval) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleCloudDialogflowCxV3ExperimentResultConfidenceInterval
	var s1 struct {
		ConfidenceLevel gensupport.JSONFloat64 `json:"confidenceLevel"`
		LowerBound      gensupport.JSONFloat64 `json:"lowerBound"`
		Ratio           gensupport.JSONFloat64 `json:"ratio"`
		UpperBound      gensupport.JSONFloat64 `json:"upperBound"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.ConfidenceLevel = float64(s1.ConfidenceLevel)
	s.LowerBound = float64(s1.LowerBound)
	s.Ratio = float64(s1.Ratio)
	s.UpperBound = float64(s1.UpperBound)
	return nil
}

type GoogleCloudDialogflowCxV3ExperimentResultMetric struct {
	ConfidenceInterval *GoogleCloudDialogflowCxV3ExperimentResultConfidenceInterval `json:"confidenceInterval,omitempty"`
	Count              float64                                                      `json:"count,omitempty"`
	// Possible values:
	//   "COUNT_TYPE_UNSPECIFIED"
	//   "TOTAL_NO_MATCH_COUNT"
	//   "TOTAL_TURN_COUNT"
	//   "AVERAGE_TURN_COUNT"
	CountType string  `json:"countType,omitempty"`
	Ratio     float64 `json:"ratio,omitempty"`
	// Possible values:
	//   "METRIC_UNSPECIFIED"
	//   "CONTAINED_SESSION_NO_CALLBACK_RATE"
	//   "LIVE_AGENT_HANDOFF_RATE"
	//   "CALLBACK_SESSION_RATE"
	//   "ABANDONED_SESSION_RATE"
	//   "SESSION_END_RATE"
	Type string `json:"type,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ConfidenceInterval") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ConfidenceInterval") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3ExperimentResultMetric) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3ExperimentResultMetric
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *GoogleCloudDialogflowCxV3ExperimentResultMetric) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleCloudDialogflowCxV3ExperimentResultMetric
	var s1 struct {
		Count gensupport.JSONFloat64 `json:"count"`
		Ratio gensupport.JSONFloat64 `json:"ratio"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.Count = float64(s1.Count)
	s.Ratio = float64(s1.Ratio)
	return nil
}

type GoogleCloudDialogflowCxV3ExperimentResultVersionMetrics struct {
	Metrics      []*GoogleCloudDialogflowCxV3ExperimentResultMetric `json:"metrics,omitempty"`
	SessionCount int64                                              `json:"sessionCount,omitempty"`
	Version      string                                             `json:"version,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Metrics") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Metrics") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3ExperimentResultVersionMetrics) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3ExperimentResultVersionMetrics
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowCxV3ExportAgentRequest struct {
	AgentUri string `json:"agentUri,omitempty"`
	// Possible values:
	//   "DATA_FORMAT_UNSPECIFIED"
	//   "BLOB"
	//   "JSON_PACKAGE"
	DataFormat                    string                                                     `json:"dataFormat,omitempty"`
	Environment                   string                                                     `json:"environment,omitempty"`
	GitDestination                *GoogleCloudDialogflowCxV3ExportAgentRequestGitDestination `json:"gitDestination,omitempty"`
	IncludeBigqueryExportSettings bool                                                       `json:"includeBigqueryExportSettings,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AgentUri") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AgentUri") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3ExportAgentRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3ExportAgentRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowCxV3ExportAgentRequestGitDestination struct {
	CommitMessage  string `json:"commitMessage,omitempty"`
	TrackingBranch string `json:"trackingBranch,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CommitMessage") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CommitMessage") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3ExportAgentRequestGitDestination) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3ExportAgentRequestGitDestination
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowCxV3ExportAgentResponse struct {
	AgentContent string `json:"agentContent,omitempty"`
	AgentUri     string `json:"agentUri,omitempty"`
	CommitSha    string `json:"commitSha,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AgentContent") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AgentContent") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3ExportAgentResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3ExportAgentResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowCxV3ExportEntityTypesMetadata struct {
}

type GoogleCloudDialogflowCxV3ExportEntityTypesRequest struct {
	// Possible values:
	//   "DATA_FORMAT_UNSPECIFIED"
	//   "BLOB"
	//   "JSON_PACKAGE"
	DataFormat               string   `json:"dataFormat,omitempty"`
	EntityTypes              []string `json:"entityTypes,omitempty"`
	EntityTypesContentInline bool     `json:"entityTypesContentInline,omitempty"`
	EntityTypesUri           string   `json:"entityTypesUri,omitempty"`
	LanguageCode             string   `json:"languageCode,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DataFormat") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DataFormat") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3ExportEntityTypesRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3ExportEntityTypesRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowCxV3ExportEntityTypesResponse struct {
	EntityTypesContent *GoogleCloudDialogflowCxV3InlineDestination `json:"entityTypesContent,omitempty"`
	EntityTypesUri     string                                      `json:"entityTypesUri,omitempty"`
	// ForceSendFields is a list of field names (e.g. "EntityTypesContent") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "EntityTypesContent") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3ExportEntityTypesResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3ExportEntityTypesResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowCxV3ExportFlowRequest struct {
	FlowUri                string `json:"flowUri,omitempty"`
	IncludeReferencedFlows bool   `json:"includeReferencedFlows,omitempty"`
	// ForceSendFields is a list of field names (e.g. "FlowUri") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "FlowUri") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3ExportFlowRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3ExportFlowRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowCxV3ExportFlowResponse struct {
	FlowContent string `json:"flowContent,omitempty"`
	FlowUri     string `json:"flowUri,omitempty"`
	// ForceSendFields is a list of field names (e.g. "FlowContent") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "FlowContent") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3ExportFlowResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3ExportFlowResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowCxV3ExportIntentsMetadata struct {
}

type GoogleCloudDialogflowCxV3ExportIntentsRequest struct {
	// Possible values:
	//   "DATA_FORMAT_UNSPECIFIED"
	//   "BLOB"
	//   "JSON"
	//   "CSV"
	DataFormat           string   `json:"dataFormat,omitempty"`
	Intents              []string `json:"intents,omitempty"`
	IntentsContentInline bool     `json:"intentsContentInline,omitempty"`
	IntentsUri           string   `json:"intentsUri,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DataFormat") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DataFormat") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3ExportIntentsRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3ExportIntentsRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowCxV3ExportIntentsResponse struct {
	IntentsContent *GoogleCloudDialogflowCxV3InlineDestination `json:"intentsContent,omitempty"`
	IntentsUri     string                                      `json:"intentsUri,omitempty"`
	// ForceSendFields is a list of field names (e.g. "IntentsContent") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "IntentsContent") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3ExportIntentsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3ExportIntentsResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowCxV3ExportPlaybookRequest struct {
	// Possible values:
	//   "DATA_FORMAT_UNSPECIFIED"
	//   "BLOB"
	//   "JSON"
	DataFormat  string `json:"dataFormat,omitempty"`
	PlaybookUri string `json:"playbookUri,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DataFormat") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DataFormat") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3ExportPlaybookRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3ExportPlaybookRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowCxV3ExportTestCasesMetadata struct {
}

type GoogleCloudDialogflowCxV3ExportTestCasesRequest struct {
	// Possible values:
	//   "DATA_FORMAT_UNSPECIFIED"
	//   "BLOB"
	//   "JSON"
	DataFormat string `json:"dataFormat,omitempty"`
	Filter     string `json:"filter,omitempty"`
	GcsUri     string `json:"gcsUri,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DataFormat") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DataFormat") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3ExportTestCasesRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3ExportTestCasesRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowCxV3ExportTestCasesResponse struct {
	Content string `json:"content,omitempty"`
	GcsUri  string `json:"gcsUri,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Content") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Content") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3ExportTestCasesResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3ExportTestCasesResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowCxV3FilterSpecs struct {
	DataStores []string `json:"dataStores,omitempty"`
	Filter     string   `json:"filter,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DataStores") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DataStores") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3FilterSpecs) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3FilterSpecs
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowCxV3Flow struct {
	AdvancedSettings           *GoogleCloudDialogflowCxV3AdvancedSettings           `json:"advancedSettings,omitempty"`
	Description                string                                               `json:"description,omitempty"`
	DisplayName                string                                               `json:"displayName,omitempty"`
	EventHandlers              []*GoogleCloudDialogflowCxV3EventHandler             `json:"eventHandlers,omitempty"`
	InputParameterDefinitions  []*GoogleCloudDialogflowCxV3ParameterDefinition      `json:"inputParameterDefinitions,omitempty"`
	KnowledgeConnectorSettings *GoogleCloudDialogflowCxV3KnowledgeConnectorSettings `json:"knowledgeConnectorSettings,omitempty"`
	Locked                     bool                                                 `json:"locked,omitempty"`
	MultiLanguageSettings      *GoogleCloudDialogflowCxV3FlowMultiLanguageSettings  `json:"multiLanguageSettings,omitempty"`
	Name                       string                                               `json:"name,omitempty"`
	NluSettings                *GoogleCloudDialogflowCxV3NluSettings                `json:"nluSettings,omitempty"`
	OutputParameterDefinitions []*GoogleCloudDialogflowCxV3ParameterDefinition      `json:"outputParameterDefinitions,omitempty"`
	TransitionRouteGroups      []string                                             `json:"transitionRouteGroups,omitempty"`
	TransitionRoutes           []*GoogleCloudDialogflowCxV3TransitionRoute          `json:"transitionRoutes,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "AdvancedSettings") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AdvancedSettings") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3Flow) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3Flow
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowCxV3FlowImportStrategy struct {
	// Possible values:
	//   "IMPORT_STRATEGY_UNSPECIFIED"
	//   "IMPORT_STRATEGY_CREATE_NEW"
	//   "IMPORT_STRATEGY_REPLACE"
	//   "IMPORT_STRATEGY_KEEP"
	//   "IMPORT_STRATEGY_MERGE"
	//   "IMPORT_STRATEGY_THROW_ERROR"
	GlobalImportStrategy string `json:"globalImportStrategy,omitempty"`
	// ForceSendFields is a list of field names (e.g. "GlobalImportStrategy") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "GlobalImportStrategy") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3FlowImportStrategy) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3FlowImportStrategy
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowCxV3FlowInvocation struct {
	DisplayName string `json:"displayName,omitempty"`
	Flow        string `json:"flow,omitempty"`
	// Possible values:
	//   "OUTPUT_STATE_UNSPECIFIED"
	//   "OUTPUT_STATE_OK"
	//   "OUTPUT_STATE_CANCELLED"
	//   "OUTPUT_STATE_FAILED"
	//   "OUTPUT_STATE_ESCALATED"
	//   "OUTPUT_STATE_PENDING"
	FlowState string `json:"flowState,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DisplayName") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DisplayName") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3FlowInvocation) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3FlowInvocation
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowCxV3FlowMultiLanguageSettings struct {
	EnableMultiLanguageDetection   bool     `json:"enableMultiLanguageDetection,omitempty"`
	SupportedResponseLanguageCodes []string `json:"supportedResponseLanguageCodes,omitempty"`
	// ForceSendFields is a list of field names (e.g.
	// "EnableMultiLanguageDetection") to unconditionally include in API requests.
	// By default, fields with empty or default values are omitted from API
	// requests. See https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields
	// for more details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "EnableMultiLanguageDetection") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3FlowMultiLanguageSettings) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3FlowMultiLanguageSettings
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowCxV3FlowTransition struct {
	DisplayName string `json:"displayName,omitempty"`
	Flow        string `json:"flow,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DisplayName") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DisplayName") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3FlowTransition) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3FlowTransition
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowCxV3FlowValidationResult struct {
	Name               string                                        `json:"name,omitempty"`
	UpdateTime         string                                        `json:"updateTime,omitempty"`
	ValidationMessages []*GoogleCloudDialogflowCxV3ValidationMessage `json:"validationMessages,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Name") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Name") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3FlowValidationResult) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3FlowValidationResult
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowCxV3Form struct {
	Parameters []*GoogleCloudDialogflowCxV3FormParameter `json:"parameters,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Parameters") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Parameters") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3Form) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3Form
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowCxV3FormParameter struct {
	AdvancedSettings *GoogleCloudDialogflowCxV3AdvancedSettings          `json:"advancedSettings,omitempty"`
	DefaultValue     interface{}                                         `json:"defaultValue,omitempty"`
	DisplayName      string                                              `json:"displayName,omitempty"`
	EntityType       string                                              `json:"entityType,omitempty"`
	FillBehavior     *GoogleCloudDialogflowCxV3FormParameterFillBehavior `json:"fillBehavior,omitempty"`
	IsList           bool                                                `json:"isList,omitempty"`
	Redact           bool                                                `json:"redact,omitempty"`
	Required         bool                                                `json:"required,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AdvancedSettings") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AdvancedSettings") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3FormParameter) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3FormParameter
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowCxV3FormParameterFillBehavior struct {
	InitialPromptFulfillment *GoogleCloudDialogflowCxV3Fulfillment    `json:"initialPromptFulfillment,omitempty"`
	RepromptEventHandlers    []*GoogleCloudDialogflowCxV3EventHandler `json:"repromptEventHandlers,omitempty"`
	// ForceSendFields is a list of field names (e.g. "InitialPromptFulfillment")
	// to unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "InitialPromptFulfillment") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3FormParameterFillBehavior) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3FormParameterFillBehavior
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowCxV3FulfillIntentRequest struct {
	Match              *GoogleCloudDialogflowCxV3Match              `json:"match,omitempty"`
	MatchIntentRequest *GoogleCloudDialogflowCxV3MatchIntentRequest `json:"matchIntentRequest,omitempty"`
	OutputAudioConfig  *GoogleCloudDialogflowCxV3OutputAudioConfig  `json:"outputAudioConfig,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Match") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Match") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3FulfillIntentRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3FulfillIntentRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowCxV3FulfillIntentResponse struct {
	OutputAudio       string                                      `json:"outputAudio,omitempty"`
	OutputAudioConfig *GoogleCloudDialogflowCxV3OutputAudioConfig `json:"outputAudioConfig,omitempty"`
	QueryResult       *GoogleCloudDialogflowCxV3QueryResult       `json:"queryResult,omitempty"`
	ResponseId        string                                      `json:"responseId,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "OutputAudio") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "OutputAudio") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3FulfillIntentResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3FulfillIntentResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowCxV3Fulfillment struct {
	AdvancedSettings         *GoogleCloudDialogflowCxV3AdvancedSettings                `json:"advancedSettings,omitempty"`
	ConditionalCases         []*GoogleCloudDialogflowCxV3FulfillmentConditionalCases   `json:"conditionalCases,omitempty"`
	EnableGenerativeFallback bool                                                      `json:"enableGenerativeFallback,omitempty"`
	Generators               []*GoogleCloudDialogflowCxV3FulfillmentGeneratorSettings  `json:"generators,omitempty"`
	Messages                 []*GoogleCloudDialogflowCxV3ResponseMessage               `json:"messages,omitempty"`
	ReturnPartialResponses   bool                                                      `json:"returnPartialResponses,omitempty"`
	SetParameterActions      []*GoogleCloudDialogflowCxV3FulfillmentSetParameterAction `json:"setParameterActions,omitempty"`
	Tag                      string                                                    `json:"tag,omitempty"`
	Webhook                  string                                                    `json:"webhook,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AdvancedSettings") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AdvancedSettings") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3Fulfillment) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3Fulfillment
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowCxV3FulfillmentConditionalCases struct {
	Cases []*GoogleCloudDialogflowCxV3FulfillmentConditionalCasesCase `json:"cases,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Cases") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Cases") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3FulfillmentConditionalCases) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3FulfillmentConditionalCases
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowCxV3FulfillmentConditionalCasesCase struct {
	CaseContent []*GoogleCloudDialogflowCxV3FulfillmentConditionalCasesCaseCaseContent `json:"caseContent,omitempty"`
	Condition   string                                                                 `json:"condition,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CaseContent") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CaseContent") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3FulfillmentConditionalCasesCase) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3FulfillmentConditionalCasesCase
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowCxV3FulfillmentConditionalCasesCaseCaseContent struct {
	AdditionalCases *GoogleCloudDialogflowCxV3FulfillmentConditionalCases `json:"additionalCases,omitempty"`
	Message         *GoogleCloudDialogflowCxV3ResponseMessage             `json:"message,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AdditionalCases") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AdditionalCases") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3FulfillmentConditionalCasesCaseCaseContent) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3FulfillmentConditionalCasesCaseCaseContent
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowCxV3FulfillmentGeneratorSettings struct {
	Generator       string            `json:"generator,omitempty"`
	InputParameters map[string]string `json:"inputParameters,omitempty"`
	OutputParameter string            `json:"outputParameter,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Generator") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Generator") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3FulfillmentGeneratorSettings) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3FulfillmentGeneratorSettings
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowCxV3FulfillmentSetParameterAction struct {
	Parameter string      `json:"parameter,omitempty"`
	Value     interface{} `json:"value,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Parameter") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Parameter") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3FulfillmentSetParameterAction) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3FulfillmentSetParameterAction
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowCxV3GcsDestination struct {
	Uri string `json:"uri,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Uri") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Uri") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3GcsDestination) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3GcsDestination
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowCxV3GenerativeSettings struct {
	FallbackSettings           *GoogleCloudDialogflowCxV3GenerativeSettingsFallbackSettings           `json:"fallbackSettings,omitempty"`
	GenerativeSafetySettings   *GoogleCloudDialogflowCxV3SafetySettings                               `json:"generativeSafetySettings,omitempty"`
	KnowledgeConnectorSettings *GoogleCloudDialogflowCxV3GenerativeSettingsKnowledgeConnectorSettings `json:"knowledgeConnectorSettings,omitempty"`
	LanguageCode               string                                                                 `json:"languageCode,omitempty"`
	LlmModelSettings           *GoogleCloudDialogflowCxV3LlmModelSettings                             `json:"llmModelSettings,omitempty"`
	Name                       string                                                                 `json:"name,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "FallbackSettings") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "FallbackSettings") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3GenerativeSettings) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3GenerativeSettings
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowCxV3GenerativeSettingsFallbackSettings struct {
	PromptTemplates []*GoogleCloudDialogflowCxV3GenerativeSettingsFallbackSettingsPromptTemplate `json:"promptTemplates,omitempty"`
	SelectedPrompt  string                                                                       `json:"selectedPrompt,omitempty"`
	// ForceSendFields is a list of field names (e.g. "PromptTemplates") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "PromptTemplates") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3GenerativeSettingsFallbackSettings) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3GenerativeSettingsFallbackSettings
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowCxV3GenerativeSettingsFallbackSettingsPromptTemplate struct {
	DisplayName string `json:"displayName,omitempty"`
	Frozen      bool   `json:"frozen,omitempty"`
	PromptText  string `json:"promptText,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DisplayName") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DisplayName") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3GenerativeSettingsFallbackSettingsPromptTemplate) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3GenerativeSettingsFallbackSettingsPromptTemplate
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowCxV3GenerativeSettingsKnowledgeConnectorSettings struct {
	Agent                    string `json:"agent,omitempty"`
	AgentIdentity            string `json:"agentIdentity,omitempty"`
	AgentScope               string `json:"agentScope,omitempty"`
	Business                 string `json:"business,omitempty"`
	BusinessDescription      string `json:"businessDescription,omitempty"`
	DisableDataStoreFallback bool   `json:"disableDataStoreFallback,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Agent") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Agent") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3GenerativeSettingsKnowledgeConnectorSettings) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3GenerativeSettingsKnowledgeConnectorSettings
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowCxV3Generator struct {
	DisplayName      string                                            `json:"displayName,omitempty"`
	LlmModelSettings *GoogleCloudDialogflowCxV3LlmModelSettings        `json:"llmModelSettings,omitempty"`
	ModelParameter   *GoogleCloudDialogflowCxV3GeneratorModelParameter `json:"modelParameter,omitempty"`
	Name             string                                            `json:"name,omitempty"`
	Placeholders     []*GoogleCloudDialogflowCxV3GeneratorPlaceholder  `json:"placeholders,omitempty"`
	PromptText       *GoogleCloudDialogflowCxV3Phrase                  `json:"promptText,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "DisplayName") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DisplayName") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3Generator) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3Generator
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowCxV3GeneratorModelParameter struct {
	MaxDecodeSteps int64   `json:"maxDecodeSteps,omitempty"`
	Temperature    float64 `json:"temperature,omitempty"`
	TopK           int64   `json:"topK,omitempty"`
	TopP           float64 `json:"topP,omitempty"`
	// ForceSendFields is a list of field names (e.g. "MaxDecodeSteps") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "MaxDecodeSteps") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3GeneratorModelParameter) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3GeneratorModelParameter
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *GoogleCloudDialogflowCxV3GeneratorModelParameter) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleCloudDialogflowCxV3GeneratorModelParameter
	var s1 struct {
		Temperature gensupport.JSONFloat64 `json:"temperature"`
		TopP        gensupport.JSONFloat64 `json:"topP"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.Temperature = float64(s1.Temperature)
	s.TopP = float64(s1.TopP)
	return nil
}

type GoogleCloudDialogflowCxV3GeneratorPlaceholder struct {
	Id   string `json:"id,omitempty"`
	Name string `json:"name,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Id") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Id") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3GeneratorPlaceholder) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3GeneratorPlaceholder
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowCxV3Handler struct {
	EventHandler     *GoogleCloudDialogflowCxV3HandlerEventHandler     `json:"eventHandler,omitempty"`
	LifecycleHandler *GoogleCloudDialogflowCxV3HandlerLifecycleHandler `json:"lifecycleHandler,omitempty"`
	// ForceSendFields is a list of field names (e.g. "EventHandler") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "EventHandler") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3Handler) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3Handler
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowCxV3HandlerEventHandler struct {
	Condition   string                                `json:"condition,omitempty"`
	Event       string                                `json:"event,omitempty"`
	Fulfillment *GoogleCloudDialogflowCxV3Fulfillment `json:"fulfillment,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Condition") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Condition") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3HandlerEventHandler) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3HandlerEventHandler
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowCxV3HandlerLifecycleHandler struct {
	Condition      string                                `json:"condition,omitempty"`
	Fulfillment    *GoogleCloudDialogflowCxV3Fulfillment `json:"fulfillment,omitempty"`
	LifecycleStage string                                `json:"lifecycleStage,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Condition") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Condition") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3HandlerLifecycleHandler) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3HandlerLifecycleHandler
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowCxV3ImportEntityTypesMetadata struct {
}

type GoogleCloudDialogflowCxV3ImportEntityTypesRequest struct {
	EntityTypesContent *GoogleCloudDialogflowCxV3InlineSource `json:"entityTypesContent,omitempty"`
	EntityTypesUri     string                                 `json:"entityTypesUri,omitempty"`
	// Possible values:
	//   "MERGE_OPTION_UNSPECIFIED"
	//   "REPLACE"
	//   "MERGE"
	//   "RENAME"
	//   "REPORT_CONFLICT"
	//   "KEEP"
	MergeOption      string `json:"mergeOption,omitempty"`
	TargetEntityType string `json:"targetEntityType,omitempty"`
	// ForceSendFields is a list of field names (e.g. "EntityTypesContent") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "EntityTypesContent") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3ImportEntityTypesRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3ImportEntityTypesRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowCxV3ImportEntityTypesResponse struct {
	ConflictingResources *GoogleCloudDialogflowCxV3ImportEntityTypesResponseConflictingResources `json:"conflictingResources,omitempty"`
	EntityTypes          []string                                                                `json:"entityTypes,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ConflictingResources") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ConflictingResources") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3ImportEntityTypesResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3ImportEntityTypesResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowCxV3ImportEntityTypesResponseConflictingResources struct {
	EntityDisplayNames     []string `json:"entityDisplayNames,omitempty"`
	EntityTypeDisplayNames []string `json:"entityTypeDisplayNames,omitempty"`
	// ForceSendFields is a list of field names (e.g. "EntityDisplayNames") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "EntityDisplayNames") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3ImportEntityTypesResponseConflictingResources) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3ImportEntityTypesResponseConflictingResources
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowCxV3ImportFlowRequest struct {
	FlowContent        string                                       `json:"flowContent,omitempty"`
	FlowImportStrategy *GoogleCloudDialogflowCxV3FlowImportStrategy `json:"flowImportStrategy,omitempty"`
	FlowUri            string                                       `json:"flowUri,omitempty"`
	// Possible values:
	//   "IMPORT_OPTION_UNSPECIFIED"
	//   "KEEP"
	//   "FALLBACK"
	ImportOption string `json:"importOption,omitempty"`
	// ForceSendFields is a list of field names (e.g. "FlowContent") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "FlowContent") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3ImportFlowRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3ImportFlowRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowCxV3ImportFlowResponse struct {
	Flow string `json:"flow,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Flow") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Flow") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3ImportFlowResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3ImportFlowResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowCxV3ImportIntentsMetadata struct {
}

type GoogleCloudDialogflowCxV3ImportIntentsRequest struct {
	IntentsContent *GoogleCloudDialogflowCxV3InlineSource `json:"intentsContent,omitempty"`
	IntentsUri     string                                 `json:"intentsUri,omitempty"`
	// Possible values:
	//   "MERGE_OPTION_UNSPECIFIED"
	//   "REJECT"
	//   "REPLACE"
	//   "MERGE"
	//   "RENAME"
	//   "REPORT_CONFLICT"
	//   "KEEP"
	MergeOption string `json:"mergeOption,omitempty"`
	// ForceSendFields is a list of field names (e.g. "IntentsContent") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "IntentsContent") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3ImportIntentsRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3ImportIntentsRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowCxV3ImportIntentsResponse struct {
	ConflictingResources *GoogleCloudDialogflowCxV3ImportIntentsResponseConflictingResources `json:"conflictingResources,omitempty"`
	Intents              []string                                                            `json:"intents,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ConflictingResources") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ConflictingResources") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3ImportIntentsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3ImportIntentsResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowCxV3ImportIntentsResponseConflictingResources struct {
	EntityDisplayNames []string `json:"entityDisplayNames,omitempty"`
	IntentDisplayNames []string `json:"intentDisplayNames,omitempty"`
	// ForceSendFields is a list of field names (e.g. "EntityDisplayNames") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "EntityDisplayNames") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3ImportIntentsResponseConflictingResources) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3ImportIntentsResponseConflictingResources
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowCxV3ImportPlaybookRequest struct {
	ImportStrategy  *GoogleCloudDialogflowCxV3PlaybookImportStrategy `json:"importStrategy,omitempty"`
	PlaybookContent string                                           `json:"playbookContent,omitempty"`
	PlaybookUri     string                                           `json:"playbookUri,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ImportStrategy") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ImportStrategy") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3ImportPlaybookRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3ImportPlaybookRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowCxV3ImportTestCasesMetadata struct {
	Errors []*GoogleCloudDialogflowCxV3TestCaseError `json:"errors,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Errors") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Errors") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3ImportTestCasesMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3ImportTestCasesMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowCxV3ImportTestCasesRequest struct {
	Content string `json:"content,omitempty"`
	GcsUri  string `json:"gcsUri,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Content") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Content") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3ImportTestCasesRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3ImportTestCasesRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowCxV3ImportTestCasesResponse struct {
	Names []string `json:"names,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Names") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Names") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3ImportTestCasesResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3ImportTestCasesResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowCxV3InlineDestination struct {
	Content string `json:"content,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Content") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Content") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3InlineDestination) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3InlineDestination
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowCxV3InlineSchema struct {
	Items *GoogleCloudDialogflowCxV3TypeSchema `json:"items,omitempty"`
	// Possible values:
	//   "DATA_TYPE_UNSPECIFIED"
	//   "STRING"
	//   "NUMBER"
	//   "BOOLEAN"
	//   "ARRAY"
	Type string `json:"type,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Items") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Items") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3InlineSchema) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3InlineSchema
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowCxV3InlineSource struct {
	Content string `json:"content,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Content") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Content") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3InlineSource) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3InlineSource
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowCxV3InputAudioConfig struct {
	// Possible values:
	//   "AUDIO_ENCODING_UNSPECIFIED"
	//   "AUDIO_ENCODING_LINEAR_16"
	//   "AUDIO_ENCODING_FLAC"
	//   "AUDIO_ENCODING_MULAW"
	//   "AUDIO_ENCODING_AMR"
	//   "AUDIO_ENCODING_AMR_WB"
	//   "AUDIO_ENCODING_OGG_OPUS"
	//   "AUDIO_ENCODING_SPEEX_WITH_HEADER_BYTE"
	//   "AUDIO_ENCODING_ALAW"
	AudioEncoding  string                                  `json:"audioEncoding,omitempty"`
	BargeInConfig  *GoogleCloudDialogflowCxV3BargeInConfig `json:"bargeInConfig,omitempty"`
	EnableWordInfo bool                                    `json:"enableWordInfo,omitempty"`
	Model          string                                  `json:"model,omitempty"`
	// Possible values:
	//   "SPEECH_MODEL_VARIANT_UNSPECIFIED"
	//   "USE_BEST_AVAILABLE"
	//   "USE_STANDARD"
	//   "USE_ENHANCED"
	ModelVariant                  string   `json:"modelVariant,omitempty"`
	OptOutConformerModelMigration bool     `json:"optOutConformerModelMigration,omitempty"`
	PhraseHints                   []string `json:"phraseHints,omitempty"`
	SampleRateHertz               int64    `json:"sampleRateHertz,omitempty"`
	SingleUtterance               bool     `json:"singleUtterance,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AudioEncoding") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AudioEncoding") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3InputAudioConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3InputAudioConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowCxV3Intent struct {
	Description     string                                           `json:"description,omitempty"`
	DisplayName     string                                           `json:"displayName,omitempty"`
	IsFallback      bool                                             `json:"isFallback,omitempty"`
	Labels          map[string]string                                `json:"labels,omitempty"`
	Name            string                                           `json:"name,omitempty"`
	Parameters      []*GoogleCloudDialogflowCxV3IntentParameter      `json:"parameters,omitempty"`
	Priority        int64                                            `json:"priority,omitempty"`
	TrainingPhrases []*GoogleCloudDialogflowCxV3IntentTrainingPhrase `json:"trainingPhrases,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Description") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Description") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3Intent) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3Intent
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowCxV3IntentCoverage struct {
	CoverageScore float64                                          `json:"coverageScore,omitempty"`
	Intents       []*GoogleCloudDialogflowCxV3IntentCoverageIntent `json:"intents,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CoverageScore") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CoverageScore") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3IntentCoverage) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3IntentCoverage
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *GoogleCloudDialogflowCxV3IntentCoverage) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleCloudDialogflowCxV3IntentCoverage
	var s1 struct {
		CoverageScore gensupport.JSONFloat64 `json:"coverageScore"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.CoverageScore = float64(s1.CoverageScore)
	return nil
}

type GoogleCloudDialogflowCxV3IntentCoverageIntent struct {
	Covered bool   `json:"covered,omitempty"`
	Intent  string `json:"intent,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Covered") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Covered") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3IntentCoverageIntent) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3IntentCoverageIntent
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowCxV3IntentInput struct {
	Intent string `json:"intent,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Intent") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Intent") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3IntentInput) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3IntentInput
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowCxV3IntentParameter struct {
	EntityType string `json:"entityType,omitempty"`
	Id         string `json:"id,omitempty"`
	IsList     bool   `json:"isList,omitempty"`
	Redact     bool   `json:"redact,omitempty"`
	// ForceSendFields is a list of field names (e.g. "EntityType") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "EntityType") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3IntentParameter) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3IntentParameter
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowCxV3IntentTrainingPhrase struct {
	Id          string                                               `json:"id,omitempty"`
	Parts       []*GoogleCloudDialogflowCxV3IntentTrainingPhrasePart `json:"parts,omitempty"`
	RepeatCount int64                                                `json:"repeatCount,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Id") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Id") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3IntentTrainingPhrase) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3IntentTrainingPhrase
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowCxV3IntentTrainingPhrasePart struct {
	ParameterId string `json:"parameterId,omitempty"`
	Text        string `json:"text,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ParameterId") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ParameterId") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3IntentTrainingPhrasePart) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3IntentTrainingPhrasePart
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowCxV3KnowledgeConnectorSettings struct {
	DataStoreConnections []*GoogleCloudDialogflowCxV3DataStoreConnection `json:"dataStoreConnections,omitempty"`
	Enabled              bool                                            `json:"enabled,omitempty"`
	TargetFlow           string                                          `json:"targetFlow,omitempty"`
	TargetPage           string                                          `json:"targetPage,omitempty"`
	TriggerFulfillment   *GoogleCloudDialogflowCxV3Fulfillment           `json:"triggerFulfillment,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DataStoreConnections") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DataStoreConnections") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3KnowledgeConnectorSettings) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3KnowledgeConnectorSettings
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowCxV3LanguageInfo struct {
	ConfidenceScore      float64 `json:"confidenceScore,omitempty"`
	InputLanguageCode    string  `json:"inputLanguageCode,omitempty"`
	ResolvedLanguageCode string  `json:"resolvedLanguageCode,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ConfidenceScore") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ConfidenceScore") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3LanguageInfo) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3LanguageInfo
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *GoogleCloudDialogflowCxV3LanguageInfo) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleCloudDialogflowCxV3LanguageInfo
	var s1 struct {
		ConfidenceScore gensupport.JSONFloat64 `json:"confidenceScore"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.ConfidenceScore = float64(s1.ConfidenceScore)
	return nil
}

type GoogleCloudDialogflowCxV3ListAgentsResponse struct {
	Agents        []*GoogleCloudDialogflowCxV3Agent `json:"agents,omitempty"`
	NextPageToken string                            `json:"nextPageToken,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Agents") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Agents") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3ListAgentsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3ListAgentsResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowCxV3ListChangelogsResponse struct {
	Changelogs    []*GoogleCloudDialogflowCxV3Changelog `json:"changelogs,omitempty"`
	NextPageToken string                                `json:"nextPageToken,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Changelogs") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Changelogs") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3ListChangelogsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3ListChangelogsResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowCxV3ListContinuousTestResultsResponse struct {
	ContinuousTestResults []*GoogleCloudDialogflowCxV3ContinuousTestResult `json:"continuousTestResults,omitempty"`
	NextPageToken         string                                           `json:"nextPageToken,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "ContinuousTestResults") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ContinuousTestResults") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3ListContinuousTestResultsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3ListContinuousTestResultsResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowCxV3ListDeploymentsResponse struct {
	Deployments   []*GoogleCloudDialogflowCxV3Deployment `json:"deployments,omitempty"`
	NextPageToken string                                 `json:"nextPageToken,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Deployments") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Deployments") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3ListDeploymentsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3ListDeploymentsResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowCxV3ListEntityTypesResponse struct {
	EntityTypes   []*GoogleCloudDialogflowCxV3EntityType `json:"entityTypes,omitempty"`
	NextPageToken string                                 `json:"nextPageToken,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "EntityTypes") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "EntityTypes") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3ListEntityTypesResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3ListEntityTypesResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowCxV3ListEnvironmentsResponse struct {
	Environments  []*GoogleCloudDialogflowCxV3Environment `json:"environments,omitempty"`
	NextPageToken string                                  `json:"nextPageToken,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Environments") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Environments") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3ListEnvironmentsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3ListEnvironmentsResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowCxV3ListExamplesResponse struct {
	Examples      []*GoogleCloudDialogflowCxV3Example `json:"examples,omitempty"`
	NextPageToken string                              `json:"nextPageToken,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Examples") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Examples") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3ListExamplesResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3ListExamplesResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowCxV3ListExperimentsResponse struct {
	Experiments   []*GoogleCloudDialogflowCxV3Experiment `json:"experiments,omitempty"`
	NextPageToken string                                 `json:"nextPageToken,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Experiments") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Experiments") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3ListExperimentsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3ListExperimentsResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowCxV3ListFlowsResponse struct {
	Flows         []*GoogleCloudDialogflowCxV3Flow `json:"flows,omitempty"`
	NextPageToken string                           `json:"nextPageToken,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Flows") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Flows") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3ListFlowsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3ListFlowsResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowCxV3ListGeneratorsResponse struct {
	Generators    []*GoogleCloudDialogflowCxV3Generator `json:"generators,omitempty"`
	NextPageToken string                                `json:"nextPageToken,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Generators") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Generators") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3ListGeneratorsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3ListGeneratorsResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowCxV3ListIntentsResponse struct {
	Intents       []*GoogleCloudDialogflowCxV3Intent `json:"intents,omitempty"`
	NextPageToken string                             `json:"nextPageToken,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Intents") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Intents") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3ListIntentsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3ListIntentsResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowCxV3ListPagesResponse struct {
	NextPageToken string                           `json:"nextPageToken,omitempty"`
	Pages         []*GoogleCloudDialogflowCxV3Page `json:"pages,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "NextPageToken") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "NextPageToken") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3ListPagesResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3ListPagesResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowCxV3ListPlaybookVersionsResponse struct {
	NextPageToken    string                                      `json:"nextPageToken,omitempty"`
	PlaybookVersions []*GoogleCloudDialogflowCxV3PlaybookVersion `json:"playbookVersions,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "NextPageToken") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "NextPageToken") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3ListPlaybookVersionsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3ListPlaybookVersionsResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowCxV3ListPlaybooksResponse struct {
	NextPageToken string                               `json:"nextPageToken,omitempty"`
	Playbooks     []*GoogleCloudDialogflowCxV3Playbook `json:"playbooks,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "NextPageToken") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "NextPageToken") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3ListPlaybooksResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3ListPlaybooksResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowCxV3ListSecuritySettingsResponse struct {
	NextPageToken    string                                       `json:"nextPageToken,omitempty"`
	SecuritySettings []*GoogleCloudDialogflowCxV3SecuritySettings `json:"securitySettings,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "NextPageToken") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "NextPageToken") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3ListSecuritySettingsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3ListSecuritySettingsResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowCxV3ListSessionEntityTypesResponse struct {
	NextPageToken      string                                        `json:"nextPageToken,omitempty"`
	SessionEntityTypes []*GoogleCloudDialogflowCxV3SessionEntityType `json:"sessionEntityTypes,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "NextPageToken") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "NextPageToken") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3ListSessionEntityTypesResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3ListSessionEntityTypesResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowCxV3ListTestCaseResultsResponse struct {
	NextPageToken   string                                     `json:"nextPageToken,omitempty"`
	TestCaseResults []*GoogleCloudDialogflowCxV3TestCaseResult `json:"testCaseResults,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "NextPageToken") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "NextPageToken") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3ListTestCaseResultsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3ListTestCaseResultsResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowCxV3ListTestCasesResponse struct {
	NextPageToken string                               `json:"nextPageToken,omitempty"`
	TestCases     []*GoogleCloudDialogflowCxV3TestCase `json:"testCases,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "NextPageToken") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "NextPageToken") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3ListTestCasesResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3ListTestCasesResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowCxV3ListToolVersionsResponse struct {
	NextPageToken string                                  `json:"nextPageToken,omitempty"`
	ToolVersions  []*GoogleCloudDialogflowCxV3ToolVersion `json:"toolVersions,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "NextPageToken") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "NextPageToken") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3ListToolVersionsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3ListToolVersionsResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowCxV3ListToolsResponse struct {
	NextPageToken string                           `json:"nextPageToken,omitempty"`
	Tools         []*GoogleCloudDialogflowCxV3Tool `json:"tools,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "NextPageToken") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "NextPageToken") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3ListToolsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3ListToolsResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowCxV3ListTransitionRouteGroupsResponse struct {
	NextPageToken         string                                           `json:"nextPageToken,omitempty"`
	TransitionRouteGroups []*GoogleCloudDialogflowCxV3TransitionRouteGroup `json:"transitionRouteGroups,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "NextPageToken") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "NextPageToken") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3ListTransitionRouteGroupsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3ListTransitionRouteGroupsResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowCxV3ListVersionsResponse struct {
	NextPageToken string                              `json:"nextPageToken,omitempty"`
	Versions      []*GoogleCloudDialogflowCxV3Version `json:"versions,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "NextPageToken") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "NextPageToken") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3ListVersionsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3ListVersionsResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowCxV3ListWebhooksResponse struct {
	NextPageToken string                              `json:"nextPageToken,omitempty"`
	Webhooks      []*GoogleCloudDialogflowCxV3Webhook `json:"webhooks,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "NextPageToken") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "NextPageToken") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3ListWebhooksResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3ListWebhooksResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowCxV3LlmModelSettings struct {
	Model      string `json:"model,omitempty"`
	PromptText string `json:"promptText,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Model") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Model") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3LlmModelSettings) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3LlmModelSettings
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowCxV3LoadVersionRequest struct {
	AllowOverrideAgentResources bool `json:"allowOverrideAgentResources,omitempty"`
	// ForceSendFields is a list of field names (e.g.
	// "AllowOverrideAgentResources") to unconditionally include in API requests.
	// By default, fields with empty or default values are omitted from API
	// requests. See https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields
	// for more details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AllowOverrideAgentResources") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3LoadVersionRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3LoadVersionRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowCxV3LookupEnvironmentHistoryResponse struct {
	Environments  []*GoogleCloudDialogflowCxV3Environment `json:"environments,omitempty"`
	NextPageToken string                                  `json:"nextPageToken,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Environments") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Environments") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3LookupEnvironmentHistoryResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3LookupEnvironmentHistoryResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowCxV3Match struct {
	Confidence float64                          `json:"confidence,omitempty"`
	Event      string                           `json:"event,omitempty"`
	Intent     *GoogleCloudDialogflowCxV3Intent `json:"intent,omitempty"`
	// Possible values:
	//   "MATCH_TYPE_UNSPECIFIED"
	//   "INTENT"
	//   "DIRECT_INTENT"
	//   "PARAMETER_FILLING"
	//   "NO_MATCH"
	//   "NO_INPUT"
	//   "EVENT"
	//   "KNOWLEDGE_CONNECTOR"
	//   "PLAYBOOK"
	MatchType     string               `json:"matchType,omitempty"`
	Parameters    googleapi.RawMessage `json:"parameters,omitempty"`
	ResolvedInput string               `json:"resolvedInput,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Confidence") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Confidence") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3Match) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3Match
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *GoogleCloudDialogflowCxV3Match) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleCloudDialogflowCxV3Match
	var s1 struct {
		Confidence gensupport.JSONFloat64 `json:"confidence"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.Confidence = float64(s1.Confidence)
	return nil
}

type GoogleCloudDialogflowCxV3MatchIntentRequest struct {
	PersistParameterChanges bool                                      `json:"persistParameterChanges,omitempty"`
	QueryInput              *GoogleCloudDialogflowCxV3QueryInput      `json:"queryInput,omitempty"`
	QueryParams             *GoogleCloudDialogflowCxV3QueryParameters `json:"queryParams,omitempty"`
	// ForceSendFields is a list of field names (e.g. "PersistParameterChanges") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "PersistParameterChanges") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3MatchIntentRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3MatchIntentRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowCxV3MatchIntentResponse struct {
	CurrentPage   *GoogleCloudDialogflowCxV3Page    `json:"currentPage,omitempty"`
	Matches       []*GoogleCloudDialogflowCxV3Match `json:"matches,omitempty"`
	Text          string                            `json:"text,omitempty"`
	Transcript    string                            `json:"transcript,omitempty"`
	TriggerEvent  string                            `json:"triggerEvent,omitempty"`
	TriggerIntent string                            `json:"triggerIntent,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "CurrentPage") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CurrentPage") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3MatchIntentResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3MatchIntentResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowCxV3NluSettings struct {
	ClassificationThreshold float64 `json:"classificationThreshold,omitempty"`
	// Possible values:
	//   "MODEL_TRAINING_MODE_UNSPECIFIED"
	//   "MODEL_TRAINING_MODE_AUTOMATIC"
	//   "MODEL_TRAINING_MODE_MANUAL"
	ModelTrainingMode string `json:"modelTrainingMode,omitempty"`
	// Possible values:
	//   "MODEL_TYPE_UNSPECIFIED"
	//   "MODEL_TYPE_STANDARD"
	//   "MODEL_TYPE_ADVANCED"
	ModelType string `json:"modelType,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ClassificationThreshold") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ClassificationThreshold") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3NluSettings) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3NluSettings
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *GoogleCloudDialogflowCxV3NluSettings) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleCloudDialogflowCxV3NluSettings
	var s1 struct {
		ClassificationThreshold gensupport.JSONFloat64 `json:"classificationThreshold"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.ClassificationThreshold = float64(s1.ClassificationThreshold)
	return nil
}

type GoogleCloudDialogflowCxV3OutputAudioConfig struct {
	// Possible values:
	//   "OUTPUT_AUDIO_ENCODING_UNSPECIFIED"
	//   "OUTPUT_AUDIO_ENCODING_LINEAR_16"
	//   "OUTPUT_AUDIO_ENCODING_MP3"
	//   "OUTPUT_AUDIO_ENCODING_MP3_64_KBPS"
	//   "OUTPUT_AUDIO_ENCODING_OGG_OPUS"
	//   "OUTPUT_AUDIO_ENCODING_MULAW"
	//   "OUTPUT_AUDIO_ENCODING_ALAW"
	AudioEncoding          string                                           `json:"audioEncoding,omitempty"`
	SampleRateHertz        int64                                            `json:"sampleRateHertz,omitempty"`
	SynthesizeSpeechConfig *GoogleCloudDialogflowCxV3SynthesizeSpeechConfig `json:"synthesizeSpeechConfig,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AudioEncoding") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AudioEncoding") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3OutputAudioConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3OutputAudioConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowCxV3Page struct {
	AdvancedSettings           *GoogleCloudDialogflowCxV3AdvancedSettings           `json:"advancedSettings,omitempty"`
	Description                string                                               `json:"description,omitempty"`
	DisplayName                string                                               `json:"displayName,omitempty"`
	EntryFulfillment           *GoogleCloudDialogflowCxV3Fulfillment                `json:"entryFulfillment,omitempty"`
	EventHandlers              []*GoogleCloudDialogflowCxV3EventHandler             `json:"eventHandlers,omitempty"`
	Form                       *GoogleCloudDialogflowCxV3Form                       `json:"form,omitempty"`
	KnowledgeConnectorSettings *GoogleCloudDialogflowCxV3KnowledgeConnectorSettings `json:"knowledgeConnectorSettings,omitempty"`
	Name                       string                                               `json:"name,omitempty"`
	TransitionRouteGroups      []string                                             `json:"transitionRouteGroups,omitempty"`
	TransitionRoutes           []*GoogleCloudDialogflowCxV3TransitionRoute          `json:"transitionRoutes,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "AdvancedSettings") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AdvancedSettings") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3Page) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3Page
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowCxV3PageInfo struct {
	CurrentPage string                                     `json:"currentPage,omitempty"`
	DisplayName string                                     `json:"displayName,omitempty"`
	FormInfo    *GoogleCloudDialogflowCxV3PageInfoFormInfo `json:"formInfo,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CurrentPage") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CurrentPage") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3PageInfo) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3PageInfo
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowCxV3PageInfoFormInfo struct {
	ParameterInfo []*GoogleCloudDialogflowCxV3PageInfoFormInfoParameterInfo `json:"parameterInfo,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ParameterInfo") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ParameterInfo") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3PageInfoFormInfo) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3PageInfoFormInfo
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowCxV3PageInfoFormInfoParameterInfo struct {
	DisplayName   string `json:"displayName,omitempty"`
	JustCollected bool   `json:"justCollected,omitempty"`
	Required      bool   `json:"required,omitempty"`
	// Possible values:
	//   "PARAMETER_STATE_UNSPECIFIED"
	//   "EMPTY"
	//   "INVALID"
	//   "FILLED"
	State string      `json:"state,omitempty"`
	Value interface{} `json:"value,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DisplayName") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DisplayName") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3PageInfoFormInfoParameterInfo) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3PageInfoFormInfoParameterInfo
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowCxV3ParameterDefinition struct {
	Description string `json:"description,omitempty"`
	Name        string `json:"name,omitempty"`
	// Possible values:
	//   "PARAMETER_TYPE_UNSPECIFIED"
	//   "STRING"
	//   "NUMBER"
	//   "BOOLEAN"
	//   "NULL"
	//   "OBJECT"
	//   "LIST"
	Type       string                               `json:"type,omitempty"`
	TypeSchema *GoogleCloudDialogflowCxV3TypeSchema `json:"typeSchema,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Description") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Description") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3ParameterDefinition) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3ParameterDefinition
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowCxV3Phrase struct {
	Text string `json:"text,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Text") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Text") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3Phrase) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3Phrase
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowCxV3Playbook struct {
	CodeBlock                  *GoogleCloudDialogflowCxV3CodeBlock             `json:"codeBlock,omitempty"`
	CreateTime                 string                                          `json:"createTime,omitempty"`
	DisplayName                string                                          `json:"displayName,omitempty"`
	Goal                       string                                          `json:"goal,omitempty"`
	Handlers                   []*GoogleCloudDialogflowCxV3Handler             `json:"handlers,omitempty"`
	InlineActions              []string                                        `json:"inlineActions,omitempty"`
	InputParameterDefinitions  []*GoogleCloudDialogflowCxV3ParameterDefinition `json:"inputParameterDefinitions,omitempty"`
	Instruction                *GoogleCloudDialogflowCxV3PlaybookInstruction   `json:"instruction,omitempty"`
	LlmModelSettings           *GoogleCloudDialogflowCxV3LlmModelSettings      `json:"llmModelSettings,omitempty"`
	Name                       string                                          `json:"name,omitempty"`
	OutputParameterDefinitions []*GoogleCloudDialogflowCxV3ParameterDefinition `json:"outputParameterDefinitions,omitempty"`
	// Possible values:
	//   "PLAYBOOK_TYPE_UNSPECIFIED"
	//   "TASK"
	//   "ROUTINE"
	PlaybookType        string   `json:"playbookType,omitempty"`
	ReferencedFlows     []string `json:"referencedFlows,omitempty"`
	ReferencedPlaybooks []string `json:"referencedPlaybooks,omitempty"`
	ReferencedTools     []string `json:"referencedTools,omitempty"`
	TokenCount          int64    `json:"tokenCount,omitempty,string"`
	UpdateTime          string   `json:"updateTime,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "CodeBlock") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CodeBlock") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3Playbook) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3Playbook
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowCxV3PlaybookImportStrategy struct {
	// Possible values:
	//   "IMPORT_STRATEGY_UNSPECIFIED"
	//   "IMPORT_STRATEGY_CREATE_NEW"
	//   "IMPORT_STRATEGY_REPLACE"
	//   "IMPORT_STRATEGY_KEEP"
	//   "IMPORT_STRATEGY_MERGE"
	//   "IMPORT_STRATEGY_THROW_ERROR"
	MainPlaybookImportStrategy string `json:"mainPlaybookImportStrategy,omitempty"`
	// Possible values:
	//   "IMPORT_STRATEGY_UNSPECIFIED"
	//   "IMPORT_STRATEGY_CREATE_NEW"
	//   "IMPORT_STRATEGY_REPLACE"
	//   "IMPORT_STRATEGY_KEEP"
	//   "IMPORT_STRATEGY_MERGE"
	//   "IMPORT_STRATEGY_THROW_ERROR"
	NestedResourceImportStrategy string `json:"nestedResourceImportStrategy,omitempty"`
	// Possible values:
	//   "IMPORT_STRATEGY_UNSPECIFIED"
	//   "IMPORT_STRATEGY_CREATE_NEW"
	//   "IMPORT_STRATEGY_REPLACE"
	//   "IMPORT_STRATEGY_KEEP"
	//   "IMPORT_STRATEGY_MERGE"
	//   "IMPORT_STRATEGY_THROW_ERROR"
	ToolImportStrategy string `json:"toolImportStrategy,omitempty"`
	// ForceSendFields is a list of field names (e.g. "MainPlaybookImportStrategy")
	// to unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "MainPlaybookImportStrategy") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3PlaybookImportStrategy) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3PlaybookImportStrategy
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowCxV3PlaybookInput struct {
	PrecedingConversationSummary string `json:"precedingConversationSummary,omitempty"`
	// ForceSendFields is a list of field names (e.g.
	// "PrecedingConversationSummary") to unconditionally include in API requests.
	// By default, fields with empty or default values are omitted from API
	// requests. See https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields
	// for more details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "PrecedingConversationSummary") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3PlaybookInput) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3PlaybookInput
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowCxV3PlaybookInstruction struct {
	Guidelines string                                   `json:"guidelines,omitempty"`
	Steps      []*GoogleCloudDialogflowCxV3PlaybookStep `json:"steps,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Guidelines") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Guidelines") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3PlaybookInstruction) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3PlaybookInstruction
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowCxV3PlaybookInvocation struct {
	DisplayName    string                                   `json:"displayName,omitempty"`
	Playbook       string                                   `json:"playbook,omitempty"`
	PlaybookInput  *GoogleCloudDialogflowCxV3PlaybookInput  `json:"playbookInput,omitempty"`
	PlaybookOutput *GoogleCloudDialogflowCxV3PlaybookOutput `json:"playbookOutput,omitempty"`
	// Possible values:
	//   "OUTPUT_STATE_UNSPECIFIED"
	//   "OUTPUT_STATE_OK"
	//   "OUTPUT_STATE_CANCELLED"
	//   "OUTPUT_STATE_FAILED"
	//   "OUTPUT_STATE_ESCALATED"
	//   "OUTPUT_STATE_PENDING"
	PlaybookState string `json:"playbookState,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DisplayName") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DisplayName") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3PlaybookInvocation) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3PlaybookInvocation
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowCxV3PlaybookOutput struct {
	ExecutionSummary string `json:"executionSummary,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ExecutionSummary") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ExecutionSummary") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3PlaybookOutput) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3PlaybookOutput
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowCxV3PlaybookStep struct {
	Steps []*GoogleCloudDialogflowCxV3PlaybookStep `json:"steps,omitempty"`
	Text  string                                   `json:"text,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Steps") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Steps") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3PlaybookStep) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3PlaybookStep
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowCxV3PlaybookTransition struct {
	DisplayName string `json:"displayName,omitempty"`
	Playbook    string `json:"playbook,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DisplayName") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DisplayName") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3PlaybookTransition) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3PlaybookTransition
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowCxV3PlaybookVersion struct {
	Description string                              `json:"description,omitempty"`
	Examples    []*GoogleCloudDialogflowCxV3Example `json:"examples,omitempty"`
	Name        string                              `json:"name,omitempty"`
	Playbook    *GoogleCloudDialogflowCxV3Playbook  `json:"playbook,omitempty"`
	UpdateTime  string                              `json:"updateTime,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Description") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Description") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3PlaybookVersion) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3PlaybookVersion
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowCxV3QueryInput struct {
	Audio          *GoogleCloudDialogflowCxV3AudioInput     `json:"audio,omitempty"`
	Dtmf           *GoogleCloudDialogflowCxV3DtmfInput      `json:"dtmf,omitempty"`
	Event          *GoogleCloudDialogflowCxV3EventInput     `json:"event,omitempty"`
	Intent         *GoogleCloudDialogflowCxV3IntentInput    `json:"intent,omitempty"`
	LanguageCode   string                                   `json:"languageCode,omitempty"`
	Text           *GoogleCloudDialogflowCxV3TextInput      `json:"text,omitempty"`
	ToolCallResult *GoogleCloudDialogflowCxV3ToolCallResult `json:"toolCallResult,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Audio") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Audio") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3QueryInput) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3QueryInput
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowCxV3QueryParameters struct {
	AnalyzeQueryTextSentiment          bool                                          `json:"analyzeQueryTextSentiment,omitempty"`
	Channel                            string                                        `json:"channel,omitempty"`
	CurrentPage                        string                                        `json:"currentPage,omitempty"`
	CurrentPlaybook                    string                                        `json:"currentPlaybook,omitempty"`
	DisableWebhook                     bool                                          `json:"disableWebhook,omitempty"`
	EndUserMetadata                    googleapi.RawMessage                          `json:"endUserMetadata,omitempty"`
	FlowVersions                       []string                                      `json:"flowVersions,omitempty"`
	GeoLocation                        *GoogleTypeLatLng                             `json:"geoLocation,omitempty"`
	LlmModelSettings                   *GoogleCloudDialogflowCxV3LlmModelSettings    `json:"llmModelSettings,omitempty"`
	ParameterScope                     string                                        `json:"parameterScope,omitempty"`
	Parameters                         googleapi.RawMessage                          `json:"parameters,omitempty"`
	Payload                            googleapi.RawMessage                          `json:"payload,omitempty"`
	PopulateDataStoreConnectionSignals bool                                          `json:"populateDataStoreConnectionSignals,omitempty"`
	SearchConfig                       *GoogleCloudDialogflowCxV3SearchConfig        `json:"searchConfig,omitempty"`
	SessionEntityTypes                 []*GoogleCloudDialogflowCxV3SessionEntityType `json:"sessionEntityTypes,omitempty"`
	SessionTtl                         string                                        `json:"sessionTtl,omitempty"`
	TimeZone                           string                                        `json:"timeZone,omitempty"`
	WebhookHeaders                     map[string]string                             `json:"webhookHeaders,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AnalyzeQueryTextSentiment")
	// to unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AnalyzeQueryTextSentiment") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3QueryParameters) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3QueryParameters
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowCxV3QueryResult struct {
	AdvancedSettings           *GoogleCloudDialogflowCxV3AdvancedSettings           `json:"advancedSettings,omitempty"`
	AllowAnswerFeedback        bool                                                 `json:"allowAnswerFeedback,omitempty"`
	CurrentFlow                *GoogleCloudDialogflowCxV3Flow                       `json:"currentFlow,omitempty"`
	CurrentPage                *GoogleCloudDialogflowCxV3Page                       `json:"currentPage,omitempty"`
	DataStoreConnectionSignals *GoogleCloudDialogflowCxV3DataStoreConnectionSignals `json:"dataStoreConnectionSignals,omitempty"`
	DiagnosticInfo             googleapi.RawMessage                                 `json:"diagnosticInfo,omitempty"`
	Dtmf                       *GoogleCloudDialogflowCxV3DtmfInput                  `json:"dtmf,omitempty"`
	Intent                     *GoogleCloudDialogflowCxV3Intent                     `json:"intent,omitempty"`
	IntentDetectionConfidence  float64                                              `json:"intentDetectionConfidence,omitempty"`
	LanguageCode               string                                               `json:"languageCode,omitempty"`
	Match                      *GoogleCloudDialogflowCxV3Match                      `json:"match,omitempty"`
	Parameters                 googleapi.RawMessage                                 `json:"parameters,omitempty"`
	ResponseMessages           []*GoogleCloudDialogflowCxV3ResponseMessage          `json:"responseMessages,omitempty"`
	SentimentAnalysisResult    *GoogleCloudDialogflowCxV3SentimentAnalysisResult    `json:"sentimentAnalysisResult,omitempty"`
	Text                       string                                               `json:"text,omitempty"`
	Transcript                 string                                               `json:"transcript,omitempty"`
	TriggerEvent               string                                               `json:"triggerEvent,omitempty"`
	TriggerIntent              string                                               `json:"triggerIntent,omitempty"`
	WebhookPayloads            []googleapi.RawMessage                               `json:"webhookPayloads,omitempty"`
	WebhookStatuses            []*GoogleRpcStatus                                   `json:"webhookStatuses,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AdvancedSettings") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AdvancedSettings") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3QueryResult) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3QueryResult
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *GoogleCloudDialogflowCxV3QueryResult) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleCloudDialogflowCxV3QueryResult
	var s1 struct {
		IntentDetectionConfidence gensupport.JSONFloat64 `json:"intentDetectionConfidence"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.IntentDetectionConfidence = float64(s1.IntentDetectionConfidence)
	return nil
}

type GoogleCloudDialogflowCxV3ResourceName struct {
	DisplayName string `json:"displayName,omitempty"`
	Name        string `json:"name,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DisplayName") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DisplayName") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3ResourceName) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3ResourceName
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowCxV3ResponseMessage struct {
	Channel             string                                                       `json:"channel,omitempty"`
	ConversationSuccess *GoogleCloudDialogflowCxV3ResponseMessageConversationSuccess `json:"conversationSuccess,omitempty"`
	EndInteraction      *GoogleCloudDialogflowCxV3ResponseMessageEndInteraction      `json:"endInteraction,omitempty"`
	KnowledgeInfoCard   *GoogleCloudDialogflowCxV3ResponseMessageKnowledgeInfoCard   `json:"knowledgeInfoCard,omitempty"`
	LiveAgentHandoff    *GoogleCloudDialogflowCxV3ResponseMessageLiveAgentHandoff    `json:"liveAgentHandoff,omitempty"`
	MixedAudio          *GoogleCloudDialogflowCxV3ResponseMessageMixedAudio          `json:"mixedAudio,omitempty"`
	OutputAudioText     *GoogleCloudDialogflowCxV3ResponseMessageOutputAudioText     `json:"outputAudioText,omitempty"`
	Payload             googleapi.RawMessage                                         `json:"payload,omitempty"`
	PlayAudio           *GoogleCloudDialogflowCxV3ResponseMessagePlayAudio           `json:"playAudio,omitempty"`
	// Possible values:
	//   "RESPONSE_TYPE_UNSPECIFIED"
	//   "ENTRY_PROMPT"
	//   "PARAMETER_PROMPT"
	//   "HANDLER_PROMPT"
	ResponseType          string                                                         `json:"responseType,omitempty"`
	TelephonyTransferCall *GoogleCloudDialogflowCxV3ResponseMessageTelephonyTransferCall `json:"telephonyTransferCall,omitempty"`
	Text                  *GoogleCloudDialogflowCxV3ResponseMessageText                  `json:"text,omitempty"`
	ToolCall              *GoogleCloudDialogflowCxV3ToolCall                             `json:"toolCall,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Channel") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Channel") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3ResponseMessage) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3ResponseMessage
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowCxV3ResponseMessageConversationSuccess struct {
	Metadata googleapi.RawMessage `json:"metadata,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Metadata") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Metadata") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3ResponseMessageConversationSuccess) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3ResponseMessageConversationSuccess
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowCxV3ResponseMessageEndInteraction struct {
}

type GoogleCloudDialogflowCxV3ResponseMessageKnowledgeInfoCard struct {
}

type GoogleCloudDialogflowCxV3ResponseMessageLiveAgentHandoff struct {
	Metadata googleapi.RawMessage `json:"metadata,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Metadata") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Metadata") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3ResponseMessageLiveAgentHandoff) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3ResponseMessageLiveAgentHandoff
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowCxV3ResponseMessageMixedAudio struct {
	Segments []*GoogleCloudDialogflowCxV3ResponseMessageMixedAudioSegment `json:"segments,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Segments") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Segments") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3ResponseMessageMixedAudio) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3ResponseMessageMixedAudio
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowCxV3ResponseMessageMixedAudioSegment struct {
	AllowPlaybackInterruption bool   `json:"allowPlaybackInterruption,omitempty"`
	Audio                     string `json:"audio,omitempty"`
	Uri                       string `json:"uri,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AllowPlaybackInterruption")
	// to unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AllowPlaybackInterruption") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3ResponseMessageMixedAudioSegment) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3ResponseMessageMixedAudioSegment
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowCxV3ResponseMessageOutputAudioText struct {
	AllowPlaybackInterruption bool   `json:"allowPlaybackInterruption,omitempty"`
	Ssml                      string `json:"ssml,omitempty"`
	Text                      string `json:"text,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AllowPlaybackInterruption")
	// to unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AllowPlaybackInterruption") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3ResponseMessageOutputAudioText) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3ResponseMessageOutputAudioText
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowCxV3ResponseMessagePlayAudio struct {
	AllowPlaybackInterruption bool   `json:"allowPlaybackInterruption,omitempty"`
	AudioUri                  string `json:"audioUri,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AllowPlaybackInterruption")
	// to unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AllowPlaybackInterruption") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3ResponseMessagePlayAudio) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3ResponseMessagePlayAudio
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowCxV3ResponseMessageTelephonyTransferCall struct {
	PhoneNumber string `json:"phoneNumber,omitempty"`
	// ForceSendFields is a list of field names (e.g. "PhoneNumber") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "PhoneNumber") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3ResponseMessageTelephonyTransferCall) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3ResponseMessageTelephonyTransferCall
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowCxV3ResponseMessageText struct {
	AllowPlaybackInterruption bool     `json:"allowPlaybackInterruption,omitempty"`
	Text                      []string `json:"text,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AllowPlaybackInterruption")
	// to unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AllowPlaybackInterruption") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3ResponseMessageText) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3ResponseMessageText
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowCxV3RestoreAgentRequest struct {
	AgentContent string                                                 `json:"agentContent,omitempty"`
	AgentUri     string                                                 `json:"agentUri,omitempty"`
	GitSource    *GoogleCloudDialogflowCxV3RestoreAgentRequestGitSource `json:"gitSource,omitempty"`
	// Possible values:
	//   "RESTORE_OPTION_UNSPECIFIED"
	//   "KEEP"
	//   "FALLBACK"
	RestoreOption string `json:"restoreOption,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AgentContent") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AgentContent") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3RestoreAgentRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3RestoreAgentRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowCxV3RestoreAgentRequestGitSource struct {
	TrackingBranch string `json:"trackingBranch,omitempty"`
	// ForceSendFields is a list of field names (e.g. "TrackingBranch") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "TrackingBranch") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3RestoreAgentRequestGitSource) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3RestoreAgentRequestGitSource
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowCxV3RestorePlaybookVersionRequest struct {
}

type GoogleCloudDialogflowCxV3RestorePlaybookVersionResponse struct {
	Playbook *GoogleCloudDialogflowCxV3Playbook `json:"playbook,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Playbook") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Playbook") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3RestorePlaybookVersionResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3RestorePlaybookVersionResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowCxV3RestoreToolVersionRequest struct {
}

type GoogleCloudDialogflowCxV3RestoreToolVersionResponse struct {
	Tool *GoogleCloudDialogflowCxV3Tool `json:"tool,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Tool") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Tool") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3RestoreToolVersionResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3RestoreToolVersionResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowCxV3RolloutConfig struct {
	FailureCondition string                                               `json:"failureCondition,omitempty"`
	RolloutCondition string                                               `json:"rolloutCondition,omitempty"`
	RolloutSteps     []*GoogleCloudDialogflowCxV3RolloutConfigRolloutStep `json:"rolloutSteps,omitempty"`
	// ForceSendFields is a list of field names (e.g. "FailureCondition") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "FailureCondition") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3RolloutConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3RolloutConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowCxV3RolloutConfigRolloutStep struct {
	DisplayName    string `json:"displayName,omitempty"`
	MinDuration    string `json:"minDuration,omitempty"`
	TrafficPercent int64  `json:"trafficPercent,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DisplayName") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DisplayName") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3RolloutConfigRolloutStep) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3RolloutConfigRolloutStep
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowCxV3RolloutState struct {
	StartTime string `json:"startTime,omitempty"`
	Step      string `json:"step,omitempty"`
	StepIndex int64  `json:"stepIndex,omitempty"`
	// ForceSendFields is a list of field names (e.g. "StartTime") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "StartTime") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3RolloutState) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3RolloutState
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowCxV3RunContinuousTestMetadata struct {
	Errors []*GoogleCloudDialogflowCxV3TestError `json:"errors,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Errors") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Errors") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3RunContinuousTestMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3RunContinuousTestMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowCxV3RunContinuousTestRequest struct {
}

type GoogleCloudDialogflowCxV3RunContinuousTestResponse struct {
	ContinuousTestResult *GoogleCloudDialogflowCxV3ContinuousTestResult `json:"continuousTestResult,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ContinuousTestResult") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ContinuousTestResult") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3RunContinuousTestResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3RunContinuousTestResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowCxV3RunTestCaseMetadata struct {
}

type GoogleCloudDialogflowCxV3RunTestCaseRequest struct {
	Environment string `json:"environment,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Environment") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Environment") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3RunTestCaseRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3RunTestCaseRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowCxV3RunTestCaseResponse struct {
	Result *GoogleCloudDialogflowCxV3TestCaseResult `json:"result,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Result") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Result") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3RunTestCaseResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3RunTestCaseResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowCxV3SafetySettings struct {
	BannedPhrases []*GoogleCloudDialogflowCxV3SafetySettingsPhrase `json:"bannedPhrases,omitempty"`
	// Possible values:
	//   "PHRASE_MATCH_STRATEGY_UNSPECIFIED"
	//   "PARTIAL_MATCH"
	//   "WORD_MATCH"
	DefaultBannedPhraseMatchStrategy string                                                         `json:"defaultBannedPhraseMatchStrategy,omitempty"`
	DefaultRaiSettings               *GoogleCloudDialogflowCxV3SafetySettingsRaiSettings            `json:"defaultRaiSettings,omitempty"`
	PromptSecuritySettings           *GoogleCloudDialogflowCxV3SafetySettingsPromptSecuritySettings `json:"promptSecuritySettings,omitempty"`
	RaiSettings                      *GoogleCloudDialogflowCxV3SafetySettingsRaiSettings            `json:"raiSettings,omitempty"`
	// ForceSendFields is a list of field names (e.g. "BannedPhrases") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "BannedPhrases") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3SafetySettings) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3SafetySettings
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowCxV3SafetySettingsPhrase struct {
	LanguageCode string `json:"languageCode,omitempty"`
	Text         string `json:"text,omitempty"`
	// ForceSendFields is a list of field names (e.g. "LanguageCode") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "LanguageCode") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3SafetySettingsPhrase) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3SafetySettingsPhrase
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowCxV3SafetySettingsPromptSecuritySettings struct {
	EnablePromptSecurity bool `json:"enablePromptSecurity,omitempty"`
	// ForceSendFields is a list of field names (e.g. "EnablePromptSecurity") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "EnablePromptSecurity") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3SafetySettingsPromptSecuritySettings) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3SafetySettingsPromptSecuritySettings
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowCxV3SafetySettingsRaiSettings struct {
	CategoryFilters []*GoogleCloudDialogflowCxV3SafetySettingsRaiSettingsCategoryFilter `json:"categoryFilters,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CategoryFilters") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CategoryFilters") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3SafetySettingsRaiSettings) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3SafetySettingsRaiSettings
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowCxV3SafetySettingsRaiSettingsCategoryFilter struct {
	// Possible values:
	//   "SAFETY_CATEGORY_UNSPECIFIED"
	//   "DANGEROUS_CONTENT"
	//   "HATE_SPEECH"
	//   "HARASSMENT"
	//   "SEXUALLY_EXPLICIT_CONTENT"
	Category string `json:"category,omitempty"`
	// Possible values:
	//   "SAFETY_FILTER_LEVEL_UNSPECIFIED"
	//   "BLOCK_NONE"
	//   "BLOCK_FEW"
	//   "BLOCK_SOME"
	//   "BLOCK_MOST"
	FilterLevel string `json:"filterLevel,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Category") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Category") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3SafetySettingsRaiSettingsCategoryFilter) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3SafetySettingsRaiSettingsCategoryFilter
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowCxV3SearchConfig struct {
	BoostSpecs  []*GoogleCloudDialogflowCxV3BoostSpecs  `json:"boostSpecs,omitempty"`
	FilterSpecs []*GoogleCloudDialogflowCxV3FilterSpecs `json:"filterSpecs,omitempty"`
	// ForceSendFields is a list of field names (e.g. "BoostSpecs") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "BoostSpecs") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3SearchConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3SearchConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowCxV3SecuritySettings struct {
	AudioExportSettings    *GoogleCloudDialogflowCxV3SecuritySettingsAudioExportSettings    `json:"audioExportSettings,omitempty"`
	DeidentifyTemplate     string                                                           `json:"deidentifyTemplate,omitempty"`
	DisplayName            string                                                           `json:"displayName,omitempty"`
	InsightsExportSettings *GoogleCloudDialogflowCxV3SecuritySettingsInsightsExportSettings `json:"insightsExportSettings,omitempty"`
	InspectTemplate        string                                                           `json:"inspectTemplate,omitempty"`
	Name                   string                                                           `json:"name,omitempty"`
	// Possible values:
	//   "PURGE_DATA_TYPE_UNSPECIFIED"
	//   "DIALOGFLOW_HISTORY"
	PurgeDataTypes []string `json:"purgeDataTypes,omitempty"`
	// Possible values:
	//   "REDACTION_SCOPE_UNSPECIFIED"
	//   "REDACT_DISK_STORAGE"
	RedactionScope string `json:"redactionScope,omitempty"`
	// Possible values:
	//   "REDACTION_STRATEGY_UNSPECIFIED"
	//   "REDACT_WITH_SERVICE"
	RedactionStrategy string `json:"redactionStrategy,omitempty"`
	// Possible values:
	//   "RETENTION_STRATEGY_UNSPECIFIED"
	//   "REMOVE_AFTER_CONVERSATION"
	RetentionStrategy   string `json:"retentionStrategy,omitempty"`
	RetentionWindowDays int64  `json:"retentionWindowDays,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "AudioExportSettings") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AudioExportSettings") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3SecuritySettings) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3SecuritySettings
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowCxV3SecuritySettingsAudioExportSettings struct {
	AudioExportPattern string `json:"audioExportPattern,omitempty"`
	// Possible values:
	//   "AUDIO_FORMAT_UNSPECIFIED"
	//   "MULAW"
	//   "MP3"
	//   "OGG"
	AudioFormat          string `json:"audioFormat,omitempty"`
	EnableAudioRedaction bool   `json:"enableAudioRedaction,omitempty"`
	GcsBucket            string `json:"gcsBucket,omitempty"`
	StoreTtsAudio        bool   `json:"storeTtsAudio,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AudioExportPattern") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AudioExportPattern") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3SecuritySettingsAudioExportSettings) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3SecuritySettingsAudioExportSettings
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowCxV3SecuritySettingsInsightsExportSettings struct {
	EnableInsightsExport bool `json:"enableInsightsExport,omitempty"`
	// ForceSendFields is a list of field names (e.g. "EnableInsightsExport") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "EnableInsightsExport") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3SecuritySettingsInsightsExportSettings) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3SecuritySettingsInsightsExportSettings
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowCxV3SentimentAnalysisResult struct {
	Magnitude float64 `json:"magnitude,omitempty"`
	Score     float64 `json:"score,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Magnitude") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Magnitude") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3SentimentAnalysisResult) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3SentimentAnalysisResult
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *GoogleCloudDialogflowCxV3SentimentAnalysisResult) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleCloudDialogflowCxV3SentimentAnalysisResult
	var s1 struct {
		Magnitude gensupport.JSONFloat64 `json:"magnitude"`
		Score     gensupport.JSONFloat64 `json:"score"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.Magnitude = float64(s1.Magnitude)
	s.Score = float64(s1.Score)
	return nil
}

type GoogleCloudDialogflowCxV3SessionEntityType struct {
	Entities []*GoogleCloudDialogflowCxV3EntityTypeEntity `json:"entities,omitempty"`
	// Possible values:
	//   "ENTITY_OVERRIDE_MODE_UNSPECIFIED"
	//   "ENTITY_OVERRIDE_MODE_OVERRIDE"
	//   "ENTITY_OVERRIDE_MODE_SUPPLEMENT"
	EntityOverrideMode string `json:"entityOverrideMode,omitempty"`
	Name               string `json:"name,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Entities") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Entities") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3SessionEntityType) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3SessionEntityType
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowCxV3SessionInfo struct {
	Parameters googleapi.RawMessage `json:"parameters,omitempty"`
	Session    string               `json:"session,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Parameters") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Parameters") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3SessionInfo) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3SessionInfo
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowCxV3SpeechToTextSettings struct {
	EnableSpeechAdaptation bool `json:"enableSpeechAdaptation,omitempty"`
	// ForceSendFields is a list of field names (e.g. "EnableSpeechAdaptation") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "EnableSpeechAdaptation") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3SpeechToTextSettings) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3SpeechToTextSettings
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowCxV3StartExperimentRequest struct {
}

type GoogleCloudDialogflowCxV3StopExperimentRequest struct {
}

type GoogleCloudDialogflowCxV3SubmitAnswerFeedbackRequest struct {
	AnswerFeedback *GoogleCloudDialogflowCxV3AnswerFeedback `json:"answerFeedback,omitempty"`
	ResponseId     string                                   `json:"responseId,omitempty"`
	UpdateMask     string                                   `json:"updateMask,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AnswerFeedback") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AnswerFeedback") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3SubmitAnswerFeedbackRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3SubmitAnswerFeedbackRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowCxV3SynthesizeSpeechConfig struct {
	EffectsProfileId []string                                       `json:"effectsProfileId,omitempty"`
	Pitch            float64                                        `json:"pitch,omitempty"`
	SpeakingRate     float64                                        `json:"speakingRate,omitempty"`
	Voice            *GoogleCloudDialogflowCxV3VoiceSelectionParams `json:"voice,omitempty"`
	VolumeGainDb     float64                                        `json:"volumeGainDb,omitempty"`
	// ForceSendFields is a list of field names (e.g. "EffectsProfileId") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "EffectsProfileId") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3SynthesizeSpeechConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3SynthesizeSpeechConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *GoogleCloudDialogflowCxV3SynthesizeSpeechConfig) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleCloudDialogflowCxV3SynthesizeSpeechConfig
	var s1 struct {
		Pitch        gensupport.JSONFloat64 `json:"pitch"`
		SpeakingRate gensupport.JSONFloat64 `json:"speakingRate"`
		VolumeGainDb gensupport.JSONFloat64 `json:"volumeGainDb"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.Pitch = float64(s1.Pitch)
	s.SpeakingRate = float64(s1.SpeakingRate)
	s.VolumeGainDb = float64(s1.VolumeGainDb)
	return nil
}

type GoogleCloudDialogflowCxV3TestCase struct {
	CreationTime              string                                       `json:"creationTime,omitempty"`
	DisplayName               string                                       `json:"displayName,omitempty"`
	LastTestResult            *GoogleCloudDialogflowCxV3TestCaseResult     `json:"lastTestResult,omitempty"`
	Name                      string                                       `json:"name,omitempty"`
	Notes                     string                                       `json:"notes,omitempty"`
	Tags                      []string                                     `json:"tags,omitempty"`
	TestCaseConversationTurns []*GoogleCloudDialogflowCxV3ConversationTurn `json:"testCaseConversationTurns,omitempty"`
	TestConfig                *GoogleCloudDialogflowCxV3TestConfig         `json:"testConfig,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "CreationTime") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CreationTime") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3TestCase) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3TestCase
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowCxV3TestCaseError struct {
	Status   *GoogleRpcStatus                   `json:"status,omitempty"`
	TestCase *GoogleCloudDialogflowCxV3TestCase `json:"testCase,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Status") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Status") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3TestCaseError) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3TestCaseError
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowCxV3TestCaseResult struct {
	ConversationTurns []*GoogleCloudDialogflowCxV3ConversationTurn `json:"conversationTurns,omitempty"`
	Environment       string                                       `json:"environment,omitempty"`
	Name              string                                       `json:"name,omitempty"`
	// Possible values:
	//   "TEST_RESULT_UNSPECIFIED"
	//   "PASSED"
	//   "FAILED"
	TestResult string `json:"testResult,omitempty"`
	TestTime   string `json:"testTime,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "ConversationTurns") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ConversationTurns") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3TestCaseResult) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3TestCaseResult
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowCxV3TestConfig struct {
	Flow               string   `json:"flow,omitempty"`
	Page               string   `json:"page,omitempty"`
	TrackingParameters []string `json:"trackingParameters,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Flow") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Flow") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3TestConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3TestConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowCxV3TestError struct {
	Status   *GoogleRpcStatus `json:"status,omitempty"`
	TestCase string           `json:"testCase,omitempty"`
	TestTime string           `json:"testTime,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Status") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Status") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3TestError) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3TestError
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowCxV3TestRunDifference struct {
	Description string `json:"description,omitempty"`
	// Possible values:
	//   "DIFF_TYPE_UNSPECIFIED"
	//   "INTENT"
	//   "PAGE"
	//   "PARAMETERS"
	//   "UTTERANCE"
	//   "FLOW"
	Type string `json:"type,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Description") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Description") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3TestRunDifference) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3TestRunDifference
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowCxV3TextInput struct {
	Text string `json:"text,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Text") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Text") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3TextInput) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3TextInput
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowCxV3TextToSpeechSettings struct {
	SynthesizeSpeechConfigs map[string]GoogleCloudDialogflowCxV3SynthesizeSpeechConfig `json:"synthesizeSpeechConfigs,omitempty"`
	// ForceSendFields is a list of field names (e.g. "SynthesizeSpeechConfigs") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "SynthesizeSpeechConfigs") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3TextToSpeechSettings) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3TextToSpeechSettings
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowCxV3Tool struct {
	DataStoreSpec *GoogleCloudDialogflowCxV3ToolDataStoreTool `json:"dataStoreSpec,omitempty"`
	Description   string                                      `json:"description,omitempty"`
	DisplayName   string                                      `json:"displayName,omitempty"`
	FunctionSpec  *GoogleCloudDialogflowCxV3ToolFunctionTool  `json:"functionSpec,omitempty"`
	Name          string                                      `json:"name,omitempty"`
	OpenApiSpec   *GoogleCloudDialogflowCxV3ToolOpenApiTool   `json:"openApiSpec,omitempty"`
	// Possible values:
	//   "TOOL_TYPE_UNSPECIFIED"
	//   "CUSTOMIZED_TOOL"
	//   "BUILTIN_TOOL"
	ToolType string `json:"toolType,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "DataStoreSpec") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DataStoreSpec") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3Tool) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3Tool
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowCxV3ToolAuthentication struct {
	ApiKeyConfig             *GoogleCloudDialogflowCxV3ToolAuthenticationApiKeyConfig             `json:"apiKeyConfig,omitempty"`
	BearerTokenConfig        *GoogleCloudDialogflowCxV3ToolAuthenticationBearerTokenConfig        `json:"bearerTokenConfig,omitempty"`
	OauthConfig              *GoogleCloudDialogflowCxV3ToolAuthenticationOAuthConfig              `json:"oauthConfig,omitempty"`
	ServiceAccountAuthConfig *GoogleCloudDialogflowCxV3ToolAuthenticationServiceAccountAuthConfig `json:"serviceAccountAuthConfig,omitempty"`
	ServiceAgentAuthConfig   *GoogleCloudDialogflowCxV3ToolAuthenticationServiceAgentAuthConfig   `json:"serviceAgentAuthConfig,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ApiKeyConfig") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ApiKeyConfig") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3ToolAuthentication) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3ToolAuthentication
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowCxV3ToolAuthenticationApiKeyConfig struct {
	ApiKey  string `json:"apiKey,omitempty"`
	KeyName string `json:"keyName,omitempty"`
	// Possible values:
	//   "REQUEST_LOCATION_UNSPECIFIED"
	//   "HEADER"
	//   "QUERY_STRING"
	RequestLocation        string `json:"requestLocation,omitempty"`
	SecretVersionForApiKey string `json:"secretVersionForApiKey,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ApiKey") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ApiKey") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3ToolAuthenticationApiKeyConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3ToolAuthenticationApiKeyConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowCxV3ToolAuthenticationBearerTokenConfig struct {
	SecretVersionForToken string `json:"secretVersionForToken,omitempty"`
	Token                 string `json:"token,omitempty"`
	// ForceSendFields is a list of field names (e.g. "SecretVersionForToken") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "SecretVersionForToken") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3ToolAuthenticationBearerTokenConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3ToolAuthenticationBearerTokenConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowCxV3ToolAuthenticationOAuthConfig struct {
	ClientId     string `json:"clientId,omitempty"`
	ClientSecret string `json:"clientSecret,omitempty"`
	// Possible values:
	//   "OAUTH_GRANT_TYPE_UNSPECIFIED"
	//   "CLIENT_CREDENTIAL"
	OauthGrantType               string   `json:"oauthGrantType,omitempty"`
	Scopes                       []string `json:"scopes,omitempty"`
	SecretVersionForClientSecret string   `json:"secretVersionForClientSecret,omitempty"`
	TokenEndpoint                string   `json:"tokenEndpoint,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ClientId") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ClientId") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3ToolAuthenticationOAuthConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3ToolAuthenticationOAuthConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowCxV3ToolAuthenticationServiceAccountAuthConfig struct {
	ServiceAccount string `json:"serviceAccount,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ServiceAccount") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ServiceAccount") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3ToolAuthenticationServiceAccountAuthConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3ToolAuthenticationServiceAccountAuthConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowCxV3ToolAuthenticationServiceAgentAuthConfig struct {
	// Possible values:
	//   "SERVICE_AGENT_AUTH_UNSPECIFIED"
	//   "ID_TOKEN"
	//   "ACCESS_TOKEN"
	ServiceAgentAuth string `json:"serviceAgentAuth,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ServiceAgentAuth") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ServiceAgentAuth") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3ToolAuthenticationServiceAgentAuthConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3ToolAuthenticationServiceAgentAuthConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowCxV3ToolCall struct {
	Action          string               `json:"action,omitempty"`
	InputParameters googleapi.RawMessage `json:"inputParameters,omitempty"`
	Tool            string               `json:"tool,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Action") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Action") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3ToolCall) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3ToolCall
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowCxV3ToolCallResult struct {
	Action           string                                        `json:"action,omitempty"`
	Error            *GoogleCloudDialogflowCxV3ToolCallResultError `json:"error,omitempty"`
	OutputParameters googleapi.RawMessage                          `json:"outputParameters,omitempty"`
	Tool             string                                        `json:"tool,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Action") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Action") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3ToolCallResult) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3ToolCallResult
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowCxV3ToolCallResultError struct {
	Message string `json:"message,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Message") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Message") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3ToolCallResultError) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3ToolCallResultError
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowCxV3ToolDataStoreTool struct {
	DataStoreConnections []*GoogleCloudDialogflowCxV3DataStoreConnection           `json:"dataStoreConnections,omitempty"`
	FallbackPrompt       *GoogleCloudDialogflowCxV3ToolDataStoreToolFallbackPrompt `json:"fallbackPrompt,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DataStoreConnections") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DataStoreConnections") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3ToolDataStoreTool) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3ToolDataStoreTool
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowCxV3ToolDataStoreToolFallbackPrompt struct {
}

type GoogleCloudDialogflowCxV3ToolFunctionTool struct {
	InputSchema  googleapi.RawMessage `json:"inputSchema,omitempty"`
	OutputSchema googleapi.RawMessage `json:"outputSchema,omitempty"`
	// ForceSendFields is a list of field names (e.g. "InputSchema") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "InputSchema") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3ToolFunctionTool) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3ToolFunctionTool
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowCxV3ToolOpenApiTool struct {
	Authentication         *GoogleCloudDialogflowCxV3ToolAuthentication         `json:"authentication,omitempty"`
	ServiceDirectoryConfig *GoogleCloudDialogflowCxV3ToolServiceDirectoryConfig `json:"serviceDirectoryConfig,omitempty"`
	TextSchema             string                                               `json:"textSchema,omitempty"`
	TlsConfig              *GoogleCloudDialogflowCxV3ToolTLSConfig              `json:"tlsConfig,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Authentication") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Authentication") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3ToolOpenApiTool) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3ToolOpenApiTool
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowCxV3ToolServiceDirectoryConfig struct {
	Service string `json:"service,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Service") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Service") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3ToolServiceDirectoryConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3ToolServiceDirectoryConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowCxV3ToolTLSConfig struct {
	CaCerts []*GoogleCloudDialogflowCxV3ToolTLSConfigCACert `json:"caCerts,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CaCerts") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CaCerts") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3ToolTLSConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3ToolTLSConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowCxV3ToolTLSConfigCACert struct {
	Cert        string `json:"cert,omitempty"`
	DisplayName string `json:"displayName,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Cert") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Cert") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3ToolTLSConfigCACert) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3ToolTLSConfigCACert
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowCxV3ToolUse struct {
	Action                 string               `json:"action,omitempty"`
	DisplayName            string               `json:"displayName,omitempty"`
	InputActionParameters  googleapi.RawMessage `json:"inputActionParameters,omitempty"`
	OutputActionParameters googleapi.RawMessage `json:"outputActionParameters,omitempty"`
	Tool                   string               `json:"tool,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Action") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Action") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3ToolUse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3ToolUse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowCxV3ToolVersion struct {
	CreateTime  string                         `json:"createTime,omitempty"`
	DisplayName string                         `json:"displayName,omitempty"`
	Name        string                         `json:"name,omitempty"`
	Tool        *GoogleCloudDialogflowCxV3Tool `json:"tool,omitempty"`
	UpdateTime  string                         `json:"updateTime,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "CreateTime") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CreateTime") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3ToolVersion) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3ToolVersion
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowCxV3TrainFlowRequest struct {
}

type GoogleCloudDialogflowCxV3TransitionCoverage struct {
	CoverageScore float64                                                  `json:"coverageScore,omitempty"`
	Transitions   []*GoogleCloudDialogflowCxV3TransitionCoverageTransition `json:"transitions,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CoverageScore") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CoverageScore") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3TransitionCoverage) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3TransitionCoverage
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *GoogleCloudDialogflowCxV3TransitionCoverage) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleCloudDialogflowCxV3TransitionCoverage
	var s1 struct {
		CoverageScore gensupport.JSONFloat64 `json:"coverageScore"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.CoverageScore = float64(s1.CoverageScore)
	return nil
}

type GoogleCloudDialogflowCxV3TransitionCoverageTransition struct {
	Covered         bool                                                       `json:"covered,omitempty"`
	EventHandler    *GoogleCloudDialogflowCxV3EventHandler                     `json:"eventHandler,omitempty"`
	Index           int64                                                      `json:"index,omitempty"`
	Source          *GoogleCloudDialogflowCxV3TransitionCoverageTransitionNode `json:"source,omitempty"`
	Target          *GoogleCloudDialogflowCxV3TransitionCoverageTransitionNode `json:"target,omitempty"`
	TransitionRoute *GoogleCloudDialogflowCxV3TransitionRoute                  `json:"transitionRoute,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Covered") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Covered") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3TransitionCoverageTransition) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3TransitionCoverageTransition
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowCxV3TransitionCoverageTransitionNode struct {
	Flow *GoogleCloudDialogflowCxV3Flow `json:"flow,omitempty"`
	Page *GoogleCloudDialogflowCxV3Page `json:"page,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Flow") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Flow") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3TransitionCoverageTransitionNode) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3TransitionCoverageTransitionNode
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowCxV3TransitionRoute struct {
	Condition          string                                `json:"condition,omitempty"`
	Description        string                                `json:"description,omitempty"`
	Intent             string                                `json:"intent,omitempty"`
	Name               string                                `json:"name,omitempty"`
	TargetFlow         string                                `json:"targetFlow,omitempty"`
	TargetPage         string                                `json:"targetPage,omitempty"`
	TriggerFulfillment *GoogleCloudDialogflowCxV3Fulfillment `json:"triggerFulfillment,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Condition") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Condition") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3TransitionRoute) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3TransitionRoute
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowCxV3TransitionRouteGroup struct {
	DisplayName      string                                      `json:"displayName,omitempty"`
	Name             string                                      `json:"name,omitempty"`
	TransitionRoutes []*GoogleCloudDialogflowCxV3TransitionRoute `json:"transitionRoutes,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "DisplayName") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DisplayName") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3TransitionRouteGroup) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3TransitionRouteGroup
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowCxV3TransitionRouteGroupCoverage struct {
	CoverageScore float64                                                          `json:"coverageScore,omitempty"`
	Coverages     []*GoogleCloudDialogflowCxV3TransitionRouteGroupCoverageCoverage `json:"coverages,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CoverageScore") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CoverageScore") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3TransitionRouteGroupCoverage) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3TransitionRouteGroupCoverage
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *GoogleCloudDialogflowCxV3TransitionRouteGroupCoverage) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleCloudDialogflowCxV3TransitionRouteGroupCoverage
	var s1 struct {
		CoverageScore gensupport.JSONFloat64 `json:"coverageScore"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.CoverageScore = float64(s1.CoverageScore)
	return nil
}

type GoogleCloudDialogflowCxV3TransitionRouteGroupCoverageCoverage struct {
	CoverageScore float64                                                                    `json:"coverageScore,omitempty"`
	RouteGroup    *GoogleCloudDialogflowCxV3TransitionRouteGroup                             `json:"routeGroup,omitempty"`
	Transitions   []*GoogleCloudDialogflowCxV3TransitionRouteGroupCoverageCoverageTransition `json:"transitions,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CoverageScore") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CoverageScore") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3TransitionRouteGroupCoverageCoverage) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3TransitionRouteGroupCoverageCoverage
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *GoogleCloudDialogflowCxV3TransitionRouteGroupCoverageCoverage) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleCloudDialogflowCxV3TransitionRouteGroupCoverageCoverage
	var s1 struct {
		CoverageScore gensupport.JSONFloat64 `json:"coverageScore"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.CoverageScore = float64(s1.CoverageScore)
	return nil
}

type GoogleCloudDialogflowCxV3TransitionRouteGroupCoverageCoverageTransition struct {
	Covered         bool                                      `json:"covered,omitempty"`
	TransitionRoute *GoogleCloudDialogflowCxV3TransitionRoute `json:"transitionRoute,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Covered") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Covered") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3TransitionRouteGroupCoverageCoverageTransition) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3TransitionRouteGroupCoverageCoverageTransition
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowCxV3TurnSignals struct {
	AgentEscalated bool `json:"agentEscalated,omitempty"`
	DtmfUsed       bool `json:"dtmfUsed,omitempty"`
	// Possible values:
	//   "FAILURE_REASON_UNSPECIFIED"
	//   "FAILED_INTENT"
	//   "FAILED_WEBHOOK"
	FailureReasons     []string `json:"failureReasons,omitempty"`
	NoMatch            bool     `json:"noMatch,omitempty"`
	NoUserInput        bool     `json:"noUserInput,omitempty"`
	ReachedEndPage     bool     `json:"reachedEndPage,omitempty"`
	SentimentMagnitude float64  `json:"sentimentMagnitude,omitempty"`
	SentimentScore     float64  `json:"sentimentScore,omitempty"`
	UserEscalated      bool     `json:"userEscalated,omitempty"`
	WebhookStatuses    []string `json:"webhookStatuses,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AgentEscalated") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AgentEscalated") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3TurnSignals) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3TurnSignals
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *GoogleCloudDialogflowCxV3TurnSignals) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleCloudDialogflowCxV3TurnSignals
	var s1 struct {
		SentimentMagnitude gensupport.JSONFloat64 `json:"sentimentMagnitude"`
		SentimentScore     gensupport.JSONFloat64 `json:"sentimentScore"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.SentimentMagnitude = float64(s1.SentimentMagnitude)
	s.SentimentScore = float64(s1.SentimentScore)
	return nil
}

type GoogleCloudDialogflowCxV3TypeSchema struct {
	InlineSchema    *GoogleCloudDialogflowCxV3InlineSchema              `json:"inlineSchema,omitempty"`
	SchemaReference *GoogleCloudDialogflowCxV3TypeSchemaSchemaReference `json:"schemaReference,omitempty"`
	// ForceSendFields is a list of field names (e.g. "InlineSchema") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "InlineSchema") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3TypeSchema) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3TypeSchema
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowCxV3TypeSchemaSchemaReference struct {
	Schema string `json:"schema,omitempty"`
	Tool   string `json:"tool,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Schema") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Schema") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3TypeSchemaSchemaReference) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3TypeSchemaSchemaReference
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowCxV3UserUtterance struct {
	Text string `json:"text,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Text") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Text") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3UserUtterance) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3UserUtterance
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowCxV3ValidateAgentRequest struct {
	LanguageCode string `json:"languageCode,omitempty"`
	// ForceSendFields is a list of field names (e.g. "LanguageCode") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "LanguageCode") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3ValidateAgentRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3ValidateAgentRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowCxV3ValidateFlowRequest struct {
	LanguageCode string `json:"languageCode,omitempty"`
	// ForceSendFields is a list of field names (e.g. "LanguageCode") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "LanguageCode") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3ValidateFlowRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3ValidateFlowRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowCxV3ValidationMessage struct {
	Detail        string                                   `json:"detail,omitempty"`
	ResourceNames []*GoogleCloudDialogflowCxV3ResourceName `json:"resourceNames,omitempty"`
	// Possible values:
	//   "RESOURCE_TYPE_UNSPECIFIED"
	//   "AGENT"
	//   "INTENT"
	//   "INTENT_TRAINING_PHRASE"
	//   "INTENT_PARAMETER"
	//   "INTENTS"
	//   "INTENT_TRAINING_PHRASES"
	//   "ENTITY_TYPE"
	//   "ENTITY_TYPES"
	//   "WEBHOOK"
	//   "FLOW"
	//   "PAGE"
	//   "PAGES"
	//   "TRANSITION_ROUTE_GROUP"
	//   "AGENT_TRANSITION_ROUTE_GROUP"
	ResourceType string   `json:"resourceType,omitempty"`
	Resources    []string `json:"resources,omitempty"`
	// Possible values:
	//   "SEVERITY_UNSPECIFIED"
	//   "INFO"
	//   "WARNING"
	//   "ERROR"
	Severity string `json:"severity,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Detail") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Detail") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3ValidationMessage) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3ValidationMessage
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowCxV3VariantsHistory struct {
	UpdateTime      string                                    `json:"updateTime,omitempty"`
	VersionVariants *GoogleCloudDialogflowCxV3VersionVariants `json:"versionVariants,omitempty"`
	// ForceSendFields is a list of field names (e.g. "UpdateTime") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "UpdateTime") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3VariantsHistory) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3VariantsHistory
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowCxV3Version struct {
	CreateTime  string                                `json:"createTime,omitempty"`
	Description string                                `json:"description,omitempty"`
	DisplayName string                                `json:"displayName,omitempty"`
	Name        string                                `json:"name,omitempty"`
	NluSettings *GoogleCloudDialogflowCxV3NluSettings `json:"nluSettings,omitempty"`
	// Possible values:
	//   "STATE_UNSPECIFIED"
	//   "RUNNING"
	//   "SUCCEEDED"
	//   "FAILED"
	State string `json:"state,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "CreateTime") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CreateTime") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3Version) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3Version
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowCxV3VersionVariants struct {
	Variants []*GoogleCloudDialogflowCxV3VersionVariantsVariant `json:"variants,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Variants") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Variants") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3VersionVariants) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3VersionVariants
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowCxV3VersionVariantsVariant struct {
	IsControlGroup    bool    `json:"isControlGroup,omitempty"`
	TrafficAllocation float64 `json:"trafficAllocation,omitempty"`
	Version           string  `json:"version,omitempty"`
	// ForceSendFields is a list of field names (e.g. "IsControlGroup") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "IsControlGroup") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3VersionVariantsVariant) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3VersionVariantsVariant
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *GoogleCloudDialogflowCxV3VersionVariantsVariant) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleCloudDialogflowCxV3VersionVariantsVariant
	var s1 struct {
		TrafficAllocation gensupport.JSONFloat64 `json:"trafficAllocation"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.TrafficAllocation = float64(s1.TrafficAllocation)
	return nil
}

type GoogleCloudDialogflowCxV3VoiceSelectionParams struct {
	Name string `json:"name,omitempty"`
	// Possible values:
	//   "SSML_VOICE_GENDER_UNSPECIFIED"
	//   "SSML_VOICE_GENDER_MALE"
	//   "SSML_VOICE_GENDER_FEMALE"
	//   "SSML_VOICE_GENDER_NEUTRAL"
	SsmlGender string `json:"ssmlGender,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Name") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Name") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3VoiceSelectionParams) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3VoiceSelectionParams
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowCxV3Webhook struct {
	Disabled          bool                                                    `json:"disabled,omitempty"`
	DisplayName       string                                                  `json:"displayName,omitempty"`
	GenericWebService *GoogleCloudDialogflowCxV3WebhookGenericWebService      `json:"genericWebService,omitempty"`
	Name              string                                                  `json:"name,omitempty"`
	ServiceDirectory  *GoogleCloudDialogflowCxV3WebhookServiceDirectoryConfig `json:"serviceDirectory,omitempty"`
	Timeout           string                                                  `json:"timeout,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Disabled") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Disabled") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3Webhook) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3Webhook
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowCxV3WebhookGenericWebService struct {
	AllowedCaCerts []string `json:"allowedCaCerts,omitempty"`
	// Possible values:
	//   "HTTP_METHOD_UNSPECIFIED"
	//   "POST"
	//   "GET"
	//   "HEAD"
	//   "PUT"
	//   "DELETE"
	//   "PATCH"
	//   "OPTIONS"
	HttpMethod                       string                                                                               `json:"httpMethod,omitempty"`
	OauthConfig                      *GoogleCloudDialogflowCxV3WebhookGenericWebServiceOAuthConfig                        `json:"oauthConfig,omitempty"`
	ParameterMapping                 map[string]string                                                                    `json:"parameterMapping,omitempty"`
	Password                         string                                                                               `json:"password,omitempty"`
	RequestBody                      string                                                                               `json:"requestBody,omitempty"`
	RequestHeaders                   map[string]string                                                                    `json:"requestHeaders,omitempty"`
	SecretVersionForUsernamePassword string                                                                               `json:"secretVersionForUsernamePassword,omitempty"`
	SecretVersionsForRequestHeaders  map[string]GoogleCloudDialogflowCxV3WebhookGenericWebServiceSecretVersionHeaderValue `json:"secretVersionsForRequestHeaders,omitempty"`
	ServiceAccountAuthConfig         *GoogleCloudDialogflowCxV3WebhookGenericWebServiceServiceAccountAuthConfig           `json:"serviceAccountAuthConfig,omitempty"`
	// Possible values:
	//   "SERVICE_AGENT_AUTH_UNSPECIFIED"
	//   "NONE"
	//   "ID_TOKEN"
	//   "ACCESS_TOKEN"
	ServiceAgentAuth string `json:"serviceAgentAuth,omitempty"`
	Uri              string `json:"uri,omitempty"`
	Username         string `json:"username,omitempty"`
	// Possible values:
	//   "WEBHOOK_TYPE_UNSPECIFIED"
	//   "STANDARD"
	//   "FLEXIBLE"
	WebhookType string `json:"webhookType,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AllowedCaCerts") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AllowedCaCerts") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3WebhookGenericWebService) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3WebhookGenericWebService
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowCxV3WebhookGenericWebServiceOAuthConfig struct {
	ClientId                     string   `json:"clientId,omitempty"`
	ClientSecret                 string   `json:"clientSecret,omitempty"`
	Scopes                       []string `json:"scopes,omitempty"`
	SecretVersionForClientSecret string   `json:"secretVersionForClientSecret,omitempty"`
	TokenEndpoint                string   `json:"tokenEndpoint,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ClientId") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ClientId") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3WebhookGenericWebServiceOAuthConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3WebhookGenericWebServiceOAuthConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowCxV3WebhookGenericWebServiceSecretVersionHeaderValue struct {
	SecretVersion string `json:"secretVersion,omitempty"`
	// ForceSendFields is a list of field names (e.g. "SecretVersion") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "SecretVersion") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3WebhookGenericWebServiceSecretVersionHeaderValue) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3WebhookGenericWebServiceSecretVersionHeaderValue
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowCxV3WebhookGenericWebServiceServiceAccountAuthConfig struct {
	ServiceAccount string `json:"serviceAccount,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ServiceAccount") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ServiceAccount") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3WebhookGenericWebServiceServiceAccountAuthConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3WebhookGenericWebServiceServiceAccountAuthConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowCxV3WebhookRequest struct {
	DetectIntentResponseId  string                                                          `json:"detectIntentResponseId,omitempty"`
	DtmfDigits              string                                                          `json:"dtmfDigits,omitempty"`
	FulfillmentInfo         *GoogleCloudDialogflowCxV3WebhookRequestFulfillmentInfo         `json:"fulfillmentInfo,omitempty"`
	IntentInfo              *GoogleCloudDialogflowCxV3WebhookRequestIntentInfo              `json:"intentInfo,omitempty"`
	LanguageCode            string                                                          `json:"languageCode,omitempty"`
	LanguageInfo            *GoogleCloudDialogflowCxV3LanguageInfo                          `json:"languageInfo,omitempty"`
	Messages                []*GoogleCloudDialogflowCxV3ResponseMessage                     `json:"messages,omitempty"`
	PageInfo                *GoogleCloudDialogflowCxV3PageInfo                              `json:"pageInfo,omitempty"`
	Payload                 googleapi.RawMessage                                            `json:"payload,omitempty"`
	SentimentAnalysisResult *GoogleCloudDialogflowCxV3WebhookRequestSentimentAnalysisResult `json:"sentimentAnalysisResult,omitempty"`
	SessionInfo             *GoogleCloudDialogflowCxV3SessionInfo                           `json:"sessionInfo,omitempty"`
	Text                    string                                                          `json:"text,omitempty"`
	Transcript              string                                                          `json:"transcript,omitempty"`
	TriggerEvent            string                                                          `json:"triggerEvent,omitempty"`
	TriggerIntent           string                                                          `json:"triggerIntent,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DetectIntentResponseId") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DetectIntentResponseId") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3WebhookRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3WebhookRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowCxV3WebhookRequestFulfillmentInfo struct {
	Tag string `json:"tag,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Tag") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Tag") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3WebhookRequestFulfillmentInfo) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3WebhookRequestFulfillmentInfo
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowCxV3WebhookRequestIntentInfo struct {
	Confidence        float64                                                                          `json:"confidence,omitempty"`
	DisplayName       string                                                                           `json:"displayName,omitempty"`
	LastMatchedIntent string                                                                           `json:"lastMatchedIntent,omitempty"`
	Parameters        map[string]GoogleCloudDialogflowCxV3WebhookRequestIntentInfoIntentParameterValue `json:"parameters,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Confidence") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Confidence") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3WebhookRequestIntentInfo) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3WebhookRequestIntentInfo
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *GoogleCloudDialogflowCxV3WebhookRequestIntentInfo) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleCloudDialogflowCxV3WebhookRequestIntentInfo
	var s1 struct {
		Confidence gensupport.JSONFloat64 `json:"confidence"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.Confidence = float64(s1.Confidence)
	return nil
}

type GoogleCloudDialogflowCxV3WebhookRequestIntentInfoIntentParameterValue struct {
	OriginalValue string      `json:"originalValue,omitempty"`
	ResolvedValue interface{} `json:"resolvedValue,omitempty"`
	// ForceSendFields is a list of field names (e.g. "OriginalValue") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "OriginalValue") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3WebhookRequestIntentInfoIntentParameterValue) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3WebhookRequestIntentInfoIntentParameterValue
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowCxV3WebhookRequestSentimentAnalysisResult struct {
	Magnitude float64 `json:"magnitude,omitempty"`
	Score     float64 `json:"score,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Magnitude") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Magnitude") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3WebhookRequestSentimentAnalysisResult) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3WebhookRequestSentimentAnalysisResult
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *GoogleCloudDialogflowCxV3WebhookRequestSentimentAnalysisResult) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleCloudDialogflowCxV3WebhookRequestSentimentAnalysisResult
	var s1 struct {
		Magnitude gensupport.JSONFloat64 `json:"magnitude"`
		Score     gensupport.JSONFloat64 `json:"score"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.Magnitude = float64(s1.Magnitude)
	s.Score = float64(s1.Score)
	return nil
}

type GoogleCloudDialogflowCxV3WebhookResponse struct {
	FulfillmentResponse *GoogleCloudDialogflowCxV3WebhookResponseFulfillmentResponse `json:"fulfillmentResponse,omitempty"`
	PageInfo            *GoogleCloudDialogflowCxV3PageInfo                           `json:"pageInfo,omitempty"`
	Payload             googleapi.RawMessage                                         `json:"payload,omitempty"`
	SessionInfo         *GoogleCloudDialogflowCxV3SessionInfo                        `json:"sessionInfo,omitempty"`
	TargetFlow          string                                                       `json:"targetFlow,omitempty"`
	TargetPage          string                                                       `json:"targetPage,omitempty"`
	// ForceSendFields is a list of field names (e.g. "FulfillmentResponse") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "FulfillmentResponse") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3WebhookResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3WebhookResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowCxV3WebhookResponseFulfillmentResponse struct {
	// Possible values:
	//   "MERGE_BEHAVIOR_UNSPECIFIED"
	//   "APPEND"
	//   "REPLACE"
	MergeBehavior string                                      `json:"mergeBehavior,omitempty"`
	Messages      []*GoogleCloudDialogflowCxV3ResponseMessage `json:"messages,omitempty"`
	// ForceSendFields is a list of field names (e.g. "MergeBehavior") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "MergeBehavior") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3WebhookResponseFulfillmentResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3WebhookResponseFulfillmentResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowCxV3WebhookServiceDirectoryConfig struct {
	GenericWebService *GoogleCloudDialogflowCxV3WebhookGenericWebService `json:"genericWebService,omitempty"`
	Service           string                                             `json:"service,omitempty"`
	// ForceSendFields is a list of field names (e.g. "GenericWebService") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "GenericWebService") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3WebhookServiceDirectoryConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3WebhookServiceDirectoryConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowCxV3beta1AdvancedSettings struct {
	AudioExportGcsDestination *GoogleCloudDialogflowCxV3beta1GcsDestination                  `json:"audioExportGcsDestination,omitempty"`
	DtmfSettings              *GoogleCloudDialogflowCxV3beta1AdvancedSettingsDtmfSettings    `json:"dtmfSettings,omitempty"`
	LoggingSettings           *GoogleCloudDialogflowCxV3beta1AdvancedSettingsLoggingSettings `json:"loggingSettings,omitempty"`
	SpeechSettings            *GoogleCloudDialogflowCxV3beta1AdvancedSettingsSpeechSettings  `json:"speechSettings,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AudioExportGcsDestination")
	// to unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AudioExportGcsDestination") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3beta1AdvancedSettings) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1AdvancedSettings
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowCxV3beta1AdvancedSettingsDtmfSettings struct {
	Enabled                    bool   `json:"enabled,omitempty"`
	EndpointingTimeoutDuration string `json:"endpointingTimeoutDuration,omitempty"`
	FinishDigit                string `json:"finishDigit,omitempty"`
	InterdigitTimeoutDuration  string `json:"interdigitTimeoutDuration,omitempty"`
	MaxDigits                  int64  `json:"maxDigits,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Enabled") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Enabled") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3beta1AdvancedSettingsDtmfSettings) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1AdvancedSettingsDtmfSettings
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowCxV3beta1AdvancedSettingsLoggingSettings struct {
	EnableConsentBasedRedaction bool `json:"enableConsentBasedRedaction,omitempty"`
	EnableInteractionLogging    bool `json:"enableInteractionLogging,omitempty"`
	EnableStackdriverLogging    bool `json:"enableStackdriverLogging,omitempty"`
	// ForceSendFields is a list of field names (e.g.
	// "EnableConsentBasedRedaction") to unconditionally include in API requests.
	// By default, fields with empty or default values are omitted from API
	// requests. See https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields
	// for more details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "EnableConsentBasedRedaction") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3beta1AdvancedSettingsLoggingSettings) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1AdvancedSettingsLoggingSettings
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowCxV3beta1AdvancedSettingsSpeechSettings struct {
	EndpointerSensitivity      int64             `json:"endpointerSensitivity,omitempty"`
	Models                     map[string]string `json:"models,omitempty"`
	NoSpeechTimeout            string            `json:"noSpeechTimeout,omitempty"`
	UseTimeoutBasedEndpointing bool              `json:"useTimeoutBasedEndpointing,omitempty"`
	// ForceSendFields is a list of field names (e.g. "EndpointerSensitivity") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "EndpointerSensitivity") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3beta1AdvancedSettingsSpeechSettings) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1AdvancedSettingsSpeechSettings
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowCxV3beta1AudioInput struct {
	Audio  string                                          `json:"audio,omitempty"`
	Config *GoogleCloudDialogflowCxV3beta1InputAudioConfig `json:"config,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Audio") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Audio") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3beta1AudioInput) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1AudioInput
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowCxV3beta1BargeInConfig struct {
	NoBargeInDuration string `json:"noBargeInDuration,omitempty"`
	TotalDuration     string `json:"totalDuration,omitempty"`
	// ForceSendFields is a list of field names (e.g. "NoBargeInDuration") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "NoBargeInDuration") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3beta1BargeInConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1BargeInConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowCxV3beta1BatchRunTestCasesMetadata struct {
	Errors []*GoogleCloudDialogflowCxV3beta1TestError `json:"errors,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Errors") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Errors") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3beta1BatchRunTestCasesMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1BatchRunTestCasesMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowCxV3beta1BatchRunTestCasesResponse struct {
	Results []*GoogleCloudDialogflowCxV3beta1TestCaseResult `json:"results,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Results") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Results") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3beta1BatchRunTestCasesResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1BatchRunTestCasesResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowCxV3beta1ContinuousTestResult struct {
	Name string `json:"name,omitempty"`
	// Possible values:
	//   "AGGREGATED_TEST_RESULT_UNSPECIFIED"
	//   "PASSED"
	//   "FAILED"
	Result          string   `json:"result,omitempty"`
	RunTime         string   `json:"runTime,omitempty"`
	TestCaseResults []string `json:"testCaseResults,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Name") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Name") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3beta1ContinuousTestResult) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1ContinuousTestResult
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowCxV3beta1ConversationSignals struct {
	TurnSignals *GoogleCloudDialogflowCxV3beta1TurnSignals `json:"turnSignals,omitempty"`
	// ForceSendFields is a list of field names (e.g. "TurnSignals") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "TurnSignals") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3beta1ConversationSignals) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1ConversationSignals
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowCxV3beta1ConversationTurn struct {
	UserInput          *GoogleCloudDialogflowCxV3beta1ConversationTurnUserInput          `json:"userInput,omitempty"`
	VirtualAgentOutput *GoogleCloudDialogflowCxV3beta1ConversationTurnVirtualAgentOutput `json:"virtualAgentOutput,omitempty"`
	// ForceSendFields is a list of field names (e.g. "UserInput") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "UserInput") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3beta1ConversationTurn) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1ConversationTurn
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowCxV3beta1ConversationTurnUserInput struct {
	EnableSentimentAnalysis bool                                      `json:"enableSentimentAnalysis,omitempty"`
	InjectedParameters      googleapi.RawMessage                      `json:"injectedParameters,omitempty"`
	Input                   *GoogleCloudDialogflowCxV3beta1QueryInput `json:"input,omitempty"`
	IsWebhookEnabled        bool                                      `json:"isWebhookEnabled,omitempty"`
	// ForceSendFields is a list of field names (e.g. "EnableSentimentAnalysis") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "EnableSentimentAnalysis") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3beta1ConversationTurnUserInput) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1ConversationTurnUserInput
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowCxV3beta1ConversationTurnVirtualAgentOutput struct {
	CurrentPage       *GoogleCloudDialogflowCxV3beta1Page                  `json:"currentPage,omitempty"`
	DiagnosticInfo    googleapi.RawMessage                                 `json:"diagnosticInfo,omitempty"`
	Differences       []*GoogleCloudDialogflowCxV3beta1TestRunDifference   `json:"differences,omitempty"`
	SessionParameters googleapi.RawMessage                                 `json:"sessionParameters,omitempty"`
	Status            *GoogleRpcStatus                                     `json:"status,omitempty"`
	TextResponses     []*GoogleCloudDialogflowCxV3beta1ResponseMessageText `json:"textResponses,omitempty"`
	TriggeredIntent   *GoogleCloudDialogflowCxV3beta1Intent                `json:"triggeredIntent,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CurrentPage") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CurrentPage") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3beta1ConversationTurnVirtualAgentOutput) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1ConversationTurnVirtualAgentOutput
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowCxV3beta1CreateVersionOperationMetadata struct {
	Version string `json:"version,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Version") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Version") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3beta1CreateVersionOperationMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1CreateVersionOperationMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowCxV3beta1DataStoreConnection struct {
	DataStore string `json:"dataStore,omitempty"`
	// Possible values:
	//   "DATA_STORE_TYPE_UNSPECIFIED"
	//   "PUBLIC_WEB"
	//   "UNSTRUCTURED"
	//   "STRUCTURED"
	DataStoreType string `json:"dataStoreType,omitempty"`
	// Possible values:
	//   "DOCUMENT_PROCESSING_MODE_UNSPECIFIED"
	//   "DOCUMENTS"
	//   "CHUNKS"
	DocumentProcessingMode string `json:"documentProcessingMode,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DataStore") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DataStore") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3beta1DataStoreConnection) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1DataStoreConnection
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowCxV3beta1DeployFlowMetadata struct {
	TestErrors []*GoogleCloudDialogflowCxV3beta1TestError `json:"testErrors,omitempty"`
	// ForceSendFields is a list of field names (e.g. "TestErrors") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "TestErrors") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3beta1DeployFlowMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1DeployFlowMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowCxV3beta1DeployFlowResponse struct {
	Deployment  string                                     `json:"deployment,omitempty"`
	Environment *GoogleCloudDialogflowCxV3beta1Environment `json:"environment,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Deployment") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Deployment") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3beta1DeployFlowResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1DeployFlowResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowCxV3beta1DtmfInput struct {
	Digits      string `json:"digits,omitempty"`
	FinishDigit string `json:"finishDigit,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Digits") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Digits") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3beta1DtmfInput) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1DtmfInput
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowCxV3beta1Environment struct {
	Description     string                                                    `json:"description,omitempty"`
	DisplayName     string                                                    `json:"displayName,omitempty"`
	Name            string                                                    `json:"name,omitempty"`
	TestCasesConfig *GoogleCloudDialogflowCxV3beta1EnvironmentTestCasesConfig `json:"testCasesConfig,omitempty"`
	UpdateTime      string                                                    `json:"updateTime,omitempty"`
	VersionConfigs  []*GoogleCloudDialogflowCxV3beta1EnvironmentVersionConfig `json:"versionConfigs,omitempty"`
	WebhookConfig   *GoogleCloudDialogflowCxV3beta1EnvironmentWebhookConfig   `json:"webhookConfig,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Description") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Description") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3beta1Environment) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1Environment
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowCxV3beta1EnvironmentTestCasesConfig struct {
	EnableContinuousRun    bool     `json:"enableContinuousRun,omitempty"`
	EnablePredeploymentRun bool     `json:"enablePredeploymentRun,omitempty"`
	TestCases              []string `json:"testCases,omitempty"`
	// ForceSendFields is a list of field names (e.g. "EnableContinuousRun") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "EnableContinuousRun") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3beta1EnvironmentTestCasesConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1EnvironmentTestCasesConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowCxV3beta1EnvironmentVersionConfig struct {
	Version string `json:"version,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Version") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Version") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3beta1EnvironmentVersionConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1EnvironmentVersionConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowCxV3beta1EnvironmentWebhookConfig struct {
	WebhookOverrides []*GoogleCloudDialogflowCxV3beta1Webhook `json:"webhookOverrides,omitempty"`
	// ForceSendFields is a list of field names (e.g. "WebhookOverrides") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "WebhookOverrides") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3beta1EnvironmentWebhookConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1EnvironmentWebhookConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowCxV3beta1EventHandler struct {
	Event              string                                     `json:"event,omitempty"`
	Name               string                                     `json:"name,omitempty"`
	TargetFlow         string                                     `json:"targetFlow,omitempty"`
	TargetPage         string                                     `json:"targetPage,omitempty"`
	TargetPlaybook     string                                     `json:"targetPlaybook,omitempty"`
	TriggerFulfillment *GoogleCloudDialogflowCxV3beta1Fulfillment `json:"triggerFulfillment,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Event") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Event") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3beta1EventHandler) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1EventHandler
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowCxV3beta1EventInput struct {
	Event string `json:"event,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Event") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Event") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3beta1EventInput) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1EventInput
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowCxV3beta1ExportAgentResponse struct {
	AgentContent string `json:"agentContent,omitempty"`
	AgentUri     string `json:"agentUri,omitempty"`
	CommitSha    string `json:"commitSha,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AgentContent") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AgentContent") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3beta1ExportAgentResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1ExportAgentResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowCxV3beta1ExportEntityTypesMetadata struct {
}

type GoogleCloudDialogflowCxV3beta1ExportEntityTypesResponse struct {
	EntityTypesContent *GoogleCloudDialogflowCxV3beta1InlineDestination `json:"entityTypesContent,omitempty"`
	EntityTypesUri     string                                           `json:"entityTypesUri,omitempty"`
	// ForceSendFields is a list of field names (e.g. "EntityTypesContent") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "EntityTypesContent") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3beta1ExportEntityTypesResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1ExportEntityTypesResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowCxV3beta1ExportFlowResponse struct {
	FlowContent string `json:"flowContent,omitempty"`
	FlowUri     string `json:"flowUri,omitempty"`
	// ForceSendFields is a list of field names (e.g. "FlowContent") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "FlowContent") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3beta1ExportFlowResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1ExportFlowResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowCxV3beta1ExportIntentsMetadata struct {
}

type GoogleCloudDialogflowCxV3beta1ExportIntentsResponse struct {
	IntentsContent *GoogleCloudDialogflowCxV3beta1InlineDestination `json:"intentsContent,omitempty"`
	IntentsUri     string                                           `json:"intentsUri,omitempty"`
	// ForceSendFields is a list of field names (e.g. "IntentsContent") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "IntentsContent") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3beta1ExportIntentsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1ExportIntentsResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowCxV3beta1ExportTestCasesMetadata struct {
}

type GoogleCloudDialogflowCxV3beta1ExportTestCasesResponse struct {
	Content string `json:"content,omitempty"`
	GcsUri  string `json:"gcsUri,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Content") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Content") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3beta1ExportTestCasesResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1ExportTestCasesResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowCxV3beta1Form struct {
	Parameters []*GoogleCloudDialogflowCxV3beta1FormParameter `json:"parameters,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Parameters") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Parameters") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3beta1Form) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1Form
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowCxV3beta1FormParameter struct {
	AdvancedSettings *GoogleCloudDialogflowCxV3beta1AdvancedSettings          `json:"advancedSettings,omitempty"`
	DefaultValue     interface{}                                              `json:"defaultValue,omitempty"`
	DisplayName      string                                                   `json:"displayName,omitempty"`
	EntityType       string                                                   `json:"entityType,omitempty"`
	FillBehavior     *GoogleCloudDialogflowCxV3beta1FormParameterFillBehavior `json:"fillBehavior,omitempty"`
	IsList           bool                                                     `json:"isList,omitempty"`
	Redact           bool                                                     `json:"redact,omitempty"`
	Required         bool                                                     `json:"required,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AdvancedSettings") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AdvancedSettings") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3beta1FormParameter) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1FormParameter
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowCxV3beta1FormParameterFillBehavior struct {
	InitialPromptFulfillment *GoogleCloudDialogflowCxV3beta1Fulfillment    `json:"initialPromptFulfillment,omitempty"`
	RepromptEventHandlers    []*GoogleCloudDialogflowCxV3beta1EventHandler `json:"repromptEventHandlers,omitempty"`
	// ForceSendFields is a list of field names (e.g. "InitialPromptFulfillment")
	// to unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "InitialPromptFulfillment") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3beta1FormParameterFillBehavior) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1FormParameterFillBehavior
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowCxV3beta1Fulfillment struct {
	AdvancedSettings         *GoogleCloudDialogflowCxV3beta1AdvancedSettings                `json:"advancedSettings,omitempty"`
	ConditionalCases         []*GoogleCloudDialogflowCxV3beta1FulfillmentConditionalCases   `json:"conditionalCases,omitempty"`
	EnableGenerativeFallback bool                                                           `json:"enableGenerativeFallback,omitempty"`
	Generators               []*GoogleCloudDialogflowCxV3beta1FulfillmentGeneratorSettings  `json:"generators,omitempty"`
	Messages                 []*GoogleCloudDialogflowCxV3beta1ResponseMessage               `json:"messages,omitempty"`
	ReturnPartialResponses   bool                                                           `json:"returnPartialResponses,omitempty"`
	SetParameterActions      []*GoogleCloudDialogflowCxV3beta1FulfillmentSetParameterAction `json:"setParameterActions,omitempty"`
	Tag                      string                                                         `json:"tag,omitempty"`
	Webhook                  string                                                         `json:"webhook,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AdvancedSettings") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AdvancedSettings") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3beta1Fulfillment) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1Fulfillment
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowCxV3beta1FulfillmentConditionalCases struct {
	Cases []*GoogleCloudDialogflowCxV3beta1FulfillmentConditionalCasesCase `json:"cases,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Cases") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Cases") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3beta1FulfillmentConditionalCases) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1FulfillmentConditionalCases
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowCxV3beta1FulfillmentConditionalCasesCase struct {
	CaseContent []*GoogleCloudDialogflowCxV3beta1FulfillmentConditionalCasesCaseCaseContent `json:"caseContent,omitempty"`
	Condition   string                                                                      `json:"condition,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CaseContent") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CaseContent") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3beta1FulfillmentConditionalCasesCase) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1FulfillmentConditionalCasesCase
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowCxV3beta1FulfillmentConditionalCasesCaseCaseContent struct {
	AdditionalCases *GoogleCloudDialogflowCxV3beta1FulfillmentConditionalCases `json:"additionalCases,omitempty"`
	Message         *GoogleCloudDialogflowCxV3beta1ResponseMessage             `json:"message,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AdditionalCases") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AdditionalCases") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3beta1FulfillmentConditionalCasesCaseCaseContent) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1FulfillmentConditionalCasesCaseCaseContent
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowCxV3beta1FulfillmentGeneratorSettings struct {
	Generator       string            `json:"generator,omitempty"`
	InputParameters map[string]string `json:"inputParameters,omitempty"`
	OutputParameter string            `json:"outputParameter,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Generator") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Generator") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3beta1FulfillmentGeneratorSettings) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1FulfillmentGeneratorSettings
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowCxV3beta1FulfillmentSetParameterAction struct {
	Parameter string      `json:"parameter,omitempty"`
	Value     interface{} `json:"value,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Parameter") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Parameter") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3beta1FulfillmentSetParameterAction) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1FulfillmentSetParameterAction
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowCxV3beta1GcsDestination struct {
	Uri string `json:"uri,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Uri") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Uri") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3beta1GcsDestination) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1GcsDestination
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowCxV3beta1ImportEntityTypesMetadata struct {
}

type GoogleCloudDialogflowCxV3beta1ImportEntityTypesResponse struct {
	ConflictingResources *GoogleCloudDialogflowCxV3beta1ImportEntityTypesResponseConflictingResources `json:"conflictingResources,omitempty"`
	EntityTypes          []string                                                                     `json:"entityTypes,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ConflictingResources") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ConflictingResources") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3beta1ImportEntityTypesResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1ImportEntityTypesResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowCxV3beta1ImportEntityTypesResponseConflictingResources struct {
	EntityDisplayNames     []string `json:"entityDisplayNames,omitempty"`
	EntityTypeDisplayNames []string `json:"entityTypeDisplayNames,omitempty"`
	// ForceSendFields is a list of field names (e.g. "EntityDisplayNames") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "EntityDisplayNames") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3beta1ImportEntityTypesResponseConflictingResources) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1ImportEntityTypesResponseConflictingResources
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowCxV3beta1ImportFlowResponse struct {
	Flow string `json:"flow,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Flow") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Flow") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3beta1ImportFlowResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1ImportFlowResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowCxV3beta1ImportIntentsMetadata struct {
}

type GoogleCloudDialogflowCxV3beta1ImportIntentsResponse struct {
	ConflictingResources *GoogleCloudDialogflowCxV3beta1ImportIntentsResponseConflictingResources `json:"conflictingResources,omitempty"`
	Intents              []string                                                                 `json:"intents,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ConflictingResources") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ConflictingResources") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3beta1ImportIntentsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1ImportIntentsResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowCxV3beta1ImportIntentsResponseConflictingResources struct {
	EntityDisplayNames []string `json:"entityDisplayNames,omitempty"`
	IntentDisplayNames []string `json:"intentDisplayNames,omitempty"`
	// ForceSendFields is a list of field names (e.g. "EntityDisplayNames") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "EntityDisplayNames") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3beta1ImportIntentsResponseConflictingResources) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1ImportIntentsResponseConflictingResources
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowCxV3beta1ImportTestCasesMetadata struct {
	Errors []*GoogleCloudDialogflowCxV3beta1TestCaseError `json:"errors,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Errors") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Errors") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3beta1ImportTestCasesMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1ImportTestCasesMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowCxV3beta1ImportTestCasesResponse struct {
	Names []string `json:"names,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Names") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Names") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3beta1ImportTestCasesResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1ImportTestCasesResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowCxV3beta1InlineDestination struct {
	Content string `json:"content,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Content") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Content") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3beta1InlineDestination) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1InlineDestination
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowCxV3beta1InputAudioConfig struct {
	// Possible values:
	//   "AUDIO_ENCODING_UNSPECIFIED"
	//   "AUDIO_ENCODING_LINEAR_16"
	//   "AUDIO_ENCODING_FLAC"
	//   "AUDIO_ENCODING_MULAW"
	//   "AUDIO_ENCODING_AMR"
	//   "AUDIO_ENCODING_AMR_WB"
	//   "AUDIO_ENCODING_OGG_OPUS"
	//   "AUDIO_ENCODING_SPEEX_WITH_HEADER_BYTE"
	//   "AUDIO_ENCODING_ALAW"
	AudioEncoding  string                                       `json:"audioEncoding,omitempty"`
	BargeInConfig  *GoogleCloudDialogflowCxV3beta1BargeInConfig `json:"bargeInConfig,omitempty"`
	EnableWordInfo bool                                         `json:"enableWordInfo,omitempty"`
	Model          string                                       `json:"model,omitempty"`
	// Possible values:
	//   "SPEECH_MODEL_VARIANT_UNSPECIFIED"
	//   "USE_BEST_AVAILABLE"
	//   "USE_STANDARD"
	//   "USE_ENHANCED"
	ModelVariant                  string   `json:"modelVariant,omitempty"`
	OptOutConformerModelMigration bool     `json:"optOutConformerModelMigration,omitempty"`
	PhraseHints                   []string `json:"phraseHints,omitempty"`
	SampleRateHertz               int64    `json:"sampleRateHertz,omitempty"`
	SingleUtterance               bool     `json:"singleUtterance,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AudioEncoding") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AudioEncoding") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3beta1InputAudioConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1InputAudioConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowCxV3beta1Intent struct {
	Description     string                                                `json:"description,omitempty"`
	DisplayName     string                                                `json:"displayName,omitempty"`
	IsFallback      bool                                                  `json:"isFallback,omitempty"`
	Labels          map[string]string                                     `json:"labels,omitempty"`
	Name            string                                                `json:"name,omitempty"`
	Parameters      []*GoogleCloudDialogflowCxV3beta1IntentParameter      `json:"parameters,omitempty"`
	Priority        int64                                                 `json:"priority,omitempty"`
	TrainingPhrases []*GoogleCloudDialogflowCxV3beta1IntentTrainingPhrase `json:"trainingPhrases,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Description") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Description") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3beta1Intent) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1Intent
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowCxV3beta1IntentInput struct {
	Intent string `json:"intent,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Intent") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Intent") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3beta1IntentInput) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1IntentInput
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowCxV3beta1IntentParameter struct {
	EntityType string `json:"entityType,omitempty"`
	Id         string `json:"id,omitempty"`
	IsList     bool   `json:"isList,omitempty"`
	Redact     bool   `json:"redact,omitempty"`
	// ForceSendFields is a list of field names (e.g. "EntityType") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "EntityType") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3beta1IntentParameter) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1IntentParameter
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowCxV3beta1IntentTrainingPhrase struct {
	Id          string                                                    `json:"id,omitempty"`
	Parts       []*GoogleCloudDialogflowCxV3beta1IntentTrainingPhrasePart `json:"parts,omitempty"`
	RepeatCount int64                                                     `json:"repeatCount,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Id") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Id") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3beta1IntentTrainingPhrase) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1IntentTrainingPhrase
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowCxV3beta1IntentTrainingPhrasePart struct {
	ParameterId string `json:"parameterId,omitempty"`
	Text        string `json:"text,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ParameterId") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ParameterId") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3beta1IntentTrainingPhrasePart) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1IntentTrainingPhrasePart
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowCxV3beta1KnowledgeConnectorSettings struct {
	DataStoreConnections []*GoogleCloudDialogflowCxV3beta1DataStoreConnection `json:"dataStoreConnections,omitempty"`
	Enabled              bool                                                 `json:"enabled,omitempty"`
	TargetFlow           string                                               `json:"targetFlow,omitempty"`
	TargetPage           string                                               `json:"targetPage,omitempty"`
	TriggerFulfillment   *GoogleCloudDialogflowCxV3beta1Fulfillment           `json:"triggerFulfillment,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DataStoreConnections") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DataStoreConnections") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3beta1KnowledgeConnectorSettings) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1KnowledgeConnectorSettings
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowCxV3beta1LanguageInfo struct {
	ConfidenceScore      float64 `json:"confidenceScore,omitempty"`
	InputLanguageCode    string  `json:"inputLanguageCode,omitempty"`
	ResolvedLanguageCode string  `json:"resolvedLanguageCode,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ConfidenceScore") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ConfidenceScore") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3beta1LanguageInfo) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1LanguageInfo
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *GoogleCloudDialogflowCxV3beta1LanguageInfo) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleCloudDialogflowCxV3beta1LanguageInfo
	var s1 struct {
		ConfidenceScore gensupport.JSONFloat64 `json:"confidenceScore"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.ConfidenceScore = float64(s1.ConfidenceScore)
	return nil
}

type GoogleCloudDialogflowCxV3beta1Page struct {
	AdvancedSettings           *GoogleCloudDialogflowCxV3beta1AdvancedSettings           `json:"advancedSettings,omitempty"`
	Description                string                                                    `json:"description,omitempty"`
	DisplayName                string                                                    `json:"displayName,omitempty"`
	EntryFulfillment           *GoogleCloudDialogflowCxV3beta1Fulfillment                `json:"entryFulfillment,omitempty"`
	EventHandlers              []*GoogleCloudDialogflowCxV3beta1EventHandler             `json:"eventHandlers,omitempty"`
	Form                       *GoogleCloudDialogflowCxV3beta1Form                       `json:"form,omitempty"`
	KnowledgeConnectorSettings *GoogleCloudDialogflowCxV3beta1KnowledgeConnectorSettings `json:"knowledgeConnectorSettings,omitempty"`
	Name                       string                                                    `json:"name,omitempty"`
	TransitionRouteGroups      []string                                                  `json:"transitionRouteGroups,omitempty"`
	TransitionRoutes           []*GoogleCloudDialogflowCxV3beta1TransitionRoute          `json:"transitionRoutes,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AdvancedSettings") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AdvancedSettings") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3beta1Page) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1Page
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowCxV3beta1PageInfo struct {
	CurrentPage string                                          `json:"currentPage,omitempty"`
	DisplayName string                                          `json:"displayName,omitempty"`
	FormInfo    *GoogleCloudDialogflowCxV3beta1PageInfoFormInfo `json:"formInfo,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CurrentPage") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CurrentPage") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3beta1PageInfo) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1PageInfo
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowCxV3beta1PageInfoFormInfo struct {
	ParameterInfo []*GoogleCloudDialogflowCxV3beta1PageInfoFormInfoParameterInfo `json:"parameterInfo,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ParameterInfo") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ParameterInfo") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3beta1PageInfoFormInfo) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1PageInfoFormInfo
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowCxV3beta1PageInfoFormInfoParameterInfo struct {
	DisplayName   string `json:"displayName,omitempty"`
	JustCollected bool   `json:"justCollected,omitempty"`
	Required      bool   `json:"required,omitempty"`
	// Possible values:
	//   "PARAMETER_STATE_UNSPECIFIED"
	//   "EMPTY"
	//   "INVALID"
	//   "FILLED"
	State string      `json:"state,omitempty"`
	Value interface{} `json:"value,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DisplayName") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DisplayName") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3beta1PageInfoFormInfoParameterInfo) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1PageInfoFormInfoParameterInfo
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowCxV3beta1QueryInput struct {
	Audio          *GoogleCloudDialogflowCxV3beta1AudioInput     `json:"audio,omitempty"`
	Dtmf           *GoogleCloudDialogflowCxV3beta1DtmfInput      `json:"dtmf,omitempty"`
	Event          *GoogleCloudDialogflowCxV3beta1EventInput     `json:"event,omitempty"`
	Intent         *GoogleCloudDialogflowCxV3beta1IntentInput    `json:"intent,omitempty"`
	LanguageCode   string                                        `json:"languageCode,omitempty"`
	Text           *GoogleCloudDialogflowCxV3beta1TextInput      `json:"text,omitempty"`
	ToolCallResult *GoogleCloudDialogflowCxV3beta1ToolCallResult `json:"toolCallResult,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Audio") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Audio") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3beta1QueryInput) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1QueryInput
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowCxV3beta1ResponseMessage struct {
	Channel               string                                                              `json:"channel,omitempty"`
	ConversationSuccess   *GoogleCloudDialogflowCxV3beta1ResponseMessageConversationSuccess   `json:"conversationSuccess,omitempty"`
	EndInteraction        *GoogleCloudDialogflowCxV3beta1ResponseMessageEndInteraction        `json:"endInteraction,omitempty"`
	KnowledgeInfoCard     *GoogleCloudDialogflowCxV3beta1ResponseMessageKnowledgeInfoCard     `json:"knowledgeInfoCard,omitempty"`
	LiveAgentHandoff      *GoogleCloudDialogflowCxV3beta1ResponseMessageLiveAgentHandoff      `json:"liveAgentHandoff,omitempty"`
	MixedAudio            *GoogleCloudDialogflowCxV3beta1ResponseMessageMixedAudio            `json:"mixedAudio,omitempty"`
	OutputAudioText       *GoogleCloudDialogflowCxV3beta1ResponseMessageOutputAudioText       `json:"outputAudioText,omitempty"`
	Payload               googleapi.RawMessage                                                `json:"payload,omitempty"`
	PlayAudio             *GoogleCloudDialogflowCxV3beta1ResponseMessagePlayAudio             `json:"playAudio,omitempty"`
	TelephonyTransferCall *GoogleCloudDialogflowCxV3beta1ResponseMessageTelephonyTransferCall `json:"telephonyTransferCall,omitempty"`
	Text                  *GoogleCloudDialogflowCxV3beta1ResponseMessageText                  `json:"text,omitempty"`
	ToolCall              *GoogleCloudDialogflowCxV3beta1ToolCall                             `json:"toolCall,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Channel") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Channel") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3beta1ResponseMessage) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1ResponseMessage
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowCxV3beta1ResponseMessageConversationSuccess struct {
	Metadata googleapi.RawMessage `json:"metadata,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Metadata") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Metadata") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3beta1ResponseMessageConversationSuccess) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1ResponseMessageConversationSuccess
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowCxV3beta1ResponseMessageEndInteraction struct {
}

type GoogleCloudDialogflowCxV3beta1ResponseMessageKnowledgeInfoCard struct {
}

type GoogleCloudDialogflowCxV3beta1ResponseMessageLiveAgentHandoff struct {
	Metadata googleapi.RawMessage `json:"metadata,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Metadata") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Metadata") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3beta1ResponseMessageLiveAgentHandoff) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1ResponseMessageLiveAgentHandoff
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowCxV3beta1ResponseMessageMixedAudio struct {
	Segments []*GoogleCloudDialogflowCxV3beta1ResponseMessageMixedAudioSegment `json:"segments,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Segments") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Segments") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3beta1ResponseMessageMixedAudio) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1ResponseMessageMixedAudio
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowCxV3beta1ResponseMessageMixedAudioSegment struct {
	AllowPlaybackInterruption bool   `json:"allowPlaybackInterruption,omitempty"`
	Audio                     string `json:"audio,omitempty"`
	Uri                       string `json:"uri,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AllowPlaybackInterruption")
	// to unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AllowPlaybackInterruption") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3beta1ResponseMessageMixedAudioSegment) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1ResponseMessageMixedAudioSegment
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowCxV3beta1ResponseMessageOutputAudioText struct {
	AllowPlaybackInterruption bool   `json:"allowPlaybackInterruption,omitempty"`
	Ssml                      string `json:"ssml,omitempty"`
	Text                      string `json:"text,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AllowPlaybackInterruption")
	// to unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AllowPlaybackInterruption") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3beta1ResponseMessageOutputAudioText) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1ResponseMessageOutputAudioText
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowCxV3beta1ResponseMessagePlayAudio struct {
	AllowPlaybackInterruption bool   `json:"allowPlaybackInterruption,omitempty"`
	AudioUri                  string `json:"audioUri,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AllowPlaybackInterruption")
	// to unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AllowPlaybackInterruption") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3beta1ResponseMessagePlayAudio) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1ResponseMessagePlayAudio
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowCxV3beta1ResponseMessageTelephonyTransferCall struct {
	PhoneNumber string `json:"phoneNumber,omitempty"`
	// ForceSendFields is a list of field names (e.g. "PhoneNumber") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "PhoneNumber") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3beta1ResponseMessageTelephonyTransferCall) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1ResponseMessageTelephonyTransferCall
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowCxV3beta1ResponseMessageText struct {
	AllowPlaybackInterruption bool     `json:"allowPlaybackInterruption,omitempty"`
	Text                      []string `json:"text,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AllowPlaybackInterruption")
	// to unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AllowPlaybackInterruption") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3beta1ResponseMessageText) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1ResponseMessageText
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowCxV3beta1RunContinuousTestMetadata struct {
	Errors []*GoogleCloudDialogflowCxV3beta1TestError `json:"errors,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Errors") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Errors") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3beta1RunContinuousTestMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1RunContinuousTestMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowCxV3beta1RunContinuousTestResponse struct {
	ContinuousTestResult *GoogleCloudDialogflowCxV3beta1ContinuousTestResult `json:"continuousTestResult,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ContinuousTestResult") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ContinuousTestResult") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3beta1RunContinuousTestResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1RunContinuousTestResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowCxV3beta1RunTestCaseMetadata struct {
}

type GoogleCloudDialogflowCxV3beta1RunTestCaseResponse struct {
	Result *GoogleCloudDialogflowCxV3beta1TestCaseResult `json:"result,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Result") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Result") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3beta1RunTestCaseResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1RunTestCaseResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowCxV3beta1SessionInfo struct {
	Parameters googleapi.RawMessage `json:"parameters,omitempty"`
	Session    string               `json:"session,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Parameters") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Parameters") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3beta1SessionInfo) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1SessionInfo
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowCxV3beta1TestCase struct {
	CreationTime              string                                            `json:"creationTime,omitempty"`
	DisplayName               string                                            `json:"displayName,omitempty"`
	LastTestResult            *GoogleCloudDialogflowCxV3beta1TestCaseResult     `json:"lastTestResult,omitempty"`
	Name                      string                                            `json:"name,omitempty"`
	Notes                     string                                            `json:"notes,omitempty"`
	Tags                      []string                                          `json:"tags,omitempty"`
	TestCaseConversationTurns []*GoogleCloudDialogflowCxV3beta1ConversationTurn `json:"testCaseConversationTurns,omitempty"`
	TestConfig                *GoogleCloudDialogflowCxV3beta1TestConfig         `json:"testConfig,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CreationTime") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CreationTime") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3beta1TestCase) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1TestCase
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowCxV3beta1TestCaseError struct {
	Status   *GoogleRpcStatus                        `json:"status,omitempty"`
	TestCase *GoogleCloudDialogflowCxV3beta1TestCase `json:"testCase,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Status") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Status") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3beta1TestCaseError) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1TestCaseError
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowCxV3beta1TestCaseResult struct {
	ConversationTurns []*GoogleCloudDialogflowCxV3beta1ConversationTurn `json:"conversationTurns,omitempty"`
	Environment       string                                            `json:"environment,omitempty"`
	Name              string                                            `json:"name,omitempty"`
	// Possible values:
	//   "TEST_RESULT_UNSPECIFIED"
	//   "PASSED"
	//   "FAILED"
	TestResult string `json:"testResult,omitempty"`
	TestTime   string `json:"testTime,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ConversationTurns") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ConversationTurns") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3beta1TestCaseResult) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1TestCaseResult
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowCxV3beta1TestConfig struct {
	Flow               string   `json:"flow,omitempty"`
	Page               string   `json:"page,omitempty"`
	TrackingParameters []string `json:"trackingParameters,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Flow") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Flow") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3beta1TestConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1TestConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowCxV3beta1TestError struct {
	Status   *GoogleRpcStatus `json:"status,omitempty"`
	TestCase string           `json:"testCase,omitempty"`
	TestTime string           `json:"testTime,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Status") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Status") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3beta1TestError) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1TestError
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowCxV3beta1TestRunDifference struct {
	Description string `json:"description,omitempty"`
	// Possible values:
	//   "DIFF_TYPE_UNSPECIFIED"
	//   "INTENT"
	//   "PAGE"
	//   "PARAMETERS"
	//   "UTTERANCE"
	//   "FLOW"
	Type string `json:"type,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Description") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Description") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3beta1TestRunDifference) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1TestRunDifference
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowCxV3beta1TextInput struct {
	Text string `json:"text,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Text") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Text") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3beta1TextInput) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1TextInput
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowCxV3beta1ToolCall struct {
	Action          string               `json:"action,omitempty"`
	InputParameters googleapi.RawMessage `json:"inputParameters,omitempty"`
	Tool            string               `json:"tool,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Action") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Action") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3beta1ToolCall) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1ToolCall
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowCxV3beta1ToolCallResult struct {
	Action           string                                             `json:"action,omitempty"`
	Error            *GoogleCloudDialogflowCxV3beta1ToolCallResultError `json:"error,omitempty"`
	OutputParameters googleapi.RawMessage                               `json:"outputParameters,omitempty"`
	Tool             string                                             `json:"tool,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Action") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Action") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3beta1ToolCallResult) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1ToolCallResult
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowCxV3beta1ToolCallResultError struct {
	Message string `json:"message,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Message") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Message") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3beta1ToolCallResultError) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1ToolCallResultError
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowCxV3beta1TransitionRoute struct {
	Condition          string                                     `json:"condition,omitempty"`
	Description        string                                     `json:"description,omitempty"`
	Intent             string                                     `json:"intent,omitempty"`
	Name               string                                     `json:"name,omitempty"`
	TargetFlow         string                                     `json:"targetFlow,omitempty"`
	TargetPage         string                                     `json:"targetPage,omitempty"`
	TriggerFulfillment *GoogleCloudDialogflowCxV3beta1Fulfillment `json:"triggerFulfillment,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Condition") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Condition") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3beta1TransitionRoute) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1TransitionRoute
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowCxV3beta1TurnSignals struct {
	AgentEscalated bool `json:"agentEscalated,omitempty"`
	DtmfUsed       bool `json:"dtmfUsed,omitempty"`
	// Possible values:
	//   "FAILURE_REASON_UNSPECIFIED"
	//   "FAILED_INTENT"
	//   "FAILED_WEBHOOK"
	FailureReasons     []string `json:"failureReasons,omitempty"`
	NoMatch            bool     `json:"noMatch,omitempty"`
	NoUserInput        bool     `json:"noUserInput,omitempty"`
	ReachedEndPage     bool     `json:"reachedEndPage,omitempty"`
	SentimentMagnitude float64  `json:"sentimentMagnitude,omitempty"`
	SentimentScore     float64  `json:"sentimentScore,omitempty"`
	UserEscalated      bool     `json:"userEscalated,omitempty"`
	WebhookStatuses    []string `json:"webhookStatuses,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AgentEscalated") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AgentEscalated") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3beta1TurnSignals) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1TurnSignals
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *GoogleCloudDialogflowCxV3beta1TurnSignals) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleCloudDialogflowCxV3beta1TurnSignals
	var s1 struct {
		SentimentMagnitude gensupport.JSONFloat64 `json:"sentimentMagnitude"`
		SentimentScore     gensupport.JSONFloat64 `json:"sentimentScore"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.SentimentMagnitude = float64(s1.SentimentMagnitude)
	s.SentimentScore = float64(s1.SentimentScore)
	return nil
}

type GoogleCloudDialogflowCxV3beta1Webhook struct {
	Disabled          bool                                                         `json:"disabled,omitempty"`
	DisplayName       string                                                       `json:"displayName,omitempty"`
	GenericWebService *GoogleCloudDialogflowCxV3beta1WebhookGenericWebService      `json:"genericWebService,omitempty"`
	Name              string                                                       `json:"name,omitempty"`
	ServiceDirectory  *GoogleCloudDialogflowCxV3beta1WebhookServiceDirectoryConfig `json:"serviceDirectory,omitempty"`
	Timeout           string                                                       `json:"timeout,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Disabled") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Disabled") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3beta1Webhook) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1Webhook
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowCxV3beta1WebhookGenericWebService struct {
	AllowedCaCerts []string `json:"allowedCaCerts,omitempty"`
	// Possible values:
	//   "HTTP_METHOD_UNSPECIFIED"
	//   "POST"
	//   "GET"
	//   "HEAD"
	//   "PUT"
	//   "DELETE"
	//   "PATCH"
	//   "OPTIONS"
	HttpMethod                       string                                                                                    `json:"httpMethod,omitempty"`
	OauthConfig                      *GoogleCloudDialogflowCxV3beta1WebhookGenericWebServiceOAuthConfig                        `json:"oauthConfig,omitempty"`
	ParameterMapping                 map[string]string                                                                         `json:"parameterMapping,omitempty"`
	Password                         string                                                                                    `json:"password,omitempty"`
	RequestBody                      string                                                                                    `json:"requestBody,omitempty"`
	RequestHeaders                   map[string]string                                                                         `json:"requestHeaders,omitempty"`
	SecretVersionForUsernamePassword string                                                                                    `json:"secretVersionForUsernamePassword,omitempty"`
	SecretVersionsForRequestHeaders  map[string]GoogleCloudDialogflowCxV3beta1WebhookGenericWebServiceSecretVersionHeaderValue `json:"secretVersionsForRequestHeaders,omitempty"`
	ServiceAccountAuthConfig         *GoogleCloudDialogflowCxV3beta1WebhookGenericWebServiceServiceAccountAuthConfig           `json:"serviceAccountAuthConfig,omitempty"`
	// Possible values:
	//   "SERVICE_AGENT_AUTH_UNSPECIFIED"
	//   "NONE"
	//   "ID_TOKEN"
	//   "ACCESS_TOKEN"
	ServiceAgentAuth string `json:"serviceAgentAuth,omitempty"`
	Uri              string `json:"uri,omitempty"`
	Username         string `json:"username,omitempty"`
	// Possible values:
	//   "WEBHOOK_TYPE_UNSPECIFIED"
	//   "STANDARD"
	//   "FLEXIBLE"
	WebhookType string `json:"webhookType,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AllowedCaCerts") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AllowedCaCerts") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3beta1WebhookGenericWebService) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1WebhookGenericWebService
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowCxV3beta1WebhookGenericWebServiceOAuthConfig struct {
	ClientId                     string   `json:"clientId,omitempty"`
	ClientSecret                 string   `json:"clientSecret,omitempty"`
	Scopes                       []string `json:"scopes,omitempty"`
	SecretVersionForClientSecret string   `json:"secretVersionForClientSecret,omitempty"`
	TokenEndpoint                string   `json:"tokenEndpoint,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ClientId") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ClientId") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3beta1WebhookGenericWebServiceOAuthConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1WebhookGenericWebServiceOAuthConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowCxV3beta1WebhookGenericWebServiceSecretVersionHeaderValue struct {
	SecretVersion string `json:"secretVersion,omitempty"`
	// ForceSendFields is a list of field names (e.g. "SecretVersion") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "SecretVersion") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3beta1WebhookGenericWebServiceSecretVersionHeaderValue) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1WebhookGenericWebServiceSecretVersionHeaderValue
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowCxV3beta1WebhookGenericWebServiceServiceAccountAuthConfig struct {
	ServiceAccount string `json:"serviceAccount,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ServiceAccount") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ServiceAccount") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3beta1WebhookGenericWebServiceServiceAccountAuthConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1WebhookGenericWebServiceServiceAccountAuthConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowCxV3beta1WebhookRequest struct {
	DetectIntentResponseId  string                                                               `json:"detectIntentResponseId,omitempty"`
	DtmfDigits              string                                                               `json:"dtmfDigits,omitempty"`
	FulfillmentInfo         *GoogleCloudDialogflowCxV3beta1WebhookRequestFulfillmentInfo         `json:"fulfillmentInfo,omitempty"`
	IntentInfo              *GoogleCloudDialogflowCxV3beta1WebhookRequestIntentInfo              `json:"intentInfo,omitempty"`
	LanguageCode            string                                                               `json:"languageCode,omitempty"`
	LanguageInfo            *GoogleCloudDialogflowCxV3beta1LanguageInfo                          `json:"languageInfo,omitempty"`
	Messages                []*GoogleCloudDialogflowCxV3beta1ResponseMessage                     `json:"messages,omitempty"`
	PageInfo                *GoogleCloudDialogflowCxV3beta1PageInfo                              `json:"pageInfo,omitempty"`
	Payload                 googleapi.RawMessage                                                 `json:"payload,omitempty"`
	SentimentAnalysisResult *GoogleCloudDialogflowCxV3beta1WebhookRequestSentimentAnalysisResult `json:"sentimentAnalysisResult,omitempty"`
	SessionInfo             *GoogleCloudDialogflowCxV3beta1SessionInfo                           `json:"sessionInfo,omitempty"`
	Text                    string                                                               `json:"text,omitempty"`
	Transcript              string                                                               `json:"transcript,omitempty"`
	TriggerEvent            string                                                               `json:"triggerEvent,omitempty"`
	TriggerIntent           string                                                               `json:"triggerIntent,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DetectIntentResponseId") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DetectIntentResponseId") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3beta1WebhookRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1WebhookRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowCxV3beta1WebhookRequestFulfillmentInfo struct {
	Tag string `json:"tag,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Tag") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Tag") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3beta1WebhookRequestFulfillmentInfo) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1WebhookRequestFulfillmentInfo
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowCxV3beta1WebhookRequestIntentInfo struct {
	Confidence        float64                                                                               `json:"confidence,omitempty"`
	DisplayName       string                                                                                `json:"displayName,omitempty"`
	LastMatchedIntent string                                                                                `json:"lastMatchedIntent,omitempty"`
	Parameters        map[string]GoogleCloudDialogflowCxV3beta1WebhookRequestIntentInfoIntentParameterValue `json:"parameters,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Confidence") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Confidence") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3beta1WebhookRequestIntentInfo) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1WebhookRequestIntentInfo
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *GoogleCloudDialogflowCxV3beta1WebhookRequestIntentInfo) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleCloudDialogflowCxV3beta1WebhookRequestIntentInfo
	var s1 struct {
		Confidence gensupport.JSONFloat64 `json:"confidence"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.Confidence = float64(s1.Confidence)
	return nil
}

type GoogleCloudDialogflowCxV3beta1WebhookRequestIntentInfoIntentParameterValue struct {
	OriginalValue string      `json:"originalValue,omitempty"`
	ResolvedValue interface{} `json:"resolvedValue,omitempty"`
	// ForceSendFields is a list of field names (e.g. "OriginalValue") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "OriginalValue") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3beta1WebhookRequestIntentInfoIntentParameterValue) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1WebhookRequestIntentInfoIntentParameterValue
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowCxV3beta1WebhookRequestSentimentAnalysisResult struct {
	Magnitude float64 `json:"magnitude,omitempty"`
	Score     float64 `json:"score,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Magnitude") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Magnitude") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3beta1WebhookRequestSentimentAnalysisResult) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1WebhookRequestSentimentAnalysisResult
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *GoogleCloudDialogflowCxV3beta1WebhookRequestSentimentAnalysisResult) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleCloudDialogflowCxV3beta1WebhookRequestSentimentAnalysisResult
	var s1 struct {
		Magnitude gensupport.JSONFloat64 `json:"magnitude"`
		Score     gensupport.JSONFloat64 `json:"score"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.Magnitude = float64(s1.Magnitude)
	s.Score = float64(s1.Score)
	return nil
}

type GoogleCloudDialogflowCxV3beta1WebhookResponse struct {
	FulfillmentResponse *GoogleCloudDialogflowCxV3beta1WebhookResponseFulfillmentResponse `json:"fulfillmentResponse,omitempty"`
	PageInfo            *GoogleCloudDialogflowCxV3beta1PageInfo                           `json:"pageInfo,omitempty"`
	Payload             googleapi.RawMessage                                              `json:"payload,omitempty"`
	SessionInfo         *GoogleCloudDialogflowCxV3beta1SessionInfo                        `json:"sessionInfo,omitempty"`
	TargetFlow          string                                                            `json:"targetFlow,omitempty"`
	TargetPage          string                                                            `json:"targetPage,omitempty"`
	// ForceSendFields is a list of field names (e.g. "FulfillmentResponse") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "FulfillmentResponse") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3beta1WebhookResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1WebhookResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowCxV3beta1WebhookResponseFulfillmentResponse struct {
	// Possible values:
	//   "MERGE_BEHAVIOR_UNSPECIFIED"
	//   "APPEND"
	//   "REPLACE"
	MergeBehavior string                                           `json:"mergeBehavior,omitempty"`
	Messages      []*GoogleCloudDialogflowCxV3beta1ResponseMessage `json:"messages,omitempty"`
	// ForceSendFields is a list of field names (e.g. "MergeBehavior") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "MergeBehavior") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3beta1WebhookResponseFulfillmentResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1WebhookResponseFulfillmentResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowCxV3beta1WebhookServiceDirectoryConfig struct {
	GenericWebService *GoogleCloudDialogflowCxV3beta1WebhookGenericWebService `json:"genericWebService,omitempty"`
	Service           string                                                  `json:"service,omitempty"`
	// ForceSendFields is a list of field names (e.g. "GenericWebService") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "GenericWebService") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3beta1WebhookServiceDirectoryConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1WebhookServiceDirectoryConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowV2AgentCoachingInstruction struct {
	AgentAction          string                                                               `json:"agentAction,omitempty"`
	Condition            string                                                               `json:"condition,omitempty"`
	DisplayDetails       string                                                               `json:"displayDetails,omitempty"`
	DisplayName          string                                                               `json:"displayName,omitempty"`
	DuplicateCheckResult *GoogleCloudDialogflowV2AgentCoachingInstructionDuplicateCheckResult `json:"duplicateCheckResult,omitempty"`
	SystemAction         string                                                               `json:"systemAction,omitempty"`
	// Possible values:
	//   "TRIGGER_EVENT_UNSPECIFIED"
	//   "END_OF_UTTERANCE"
	//   "MANUAL_CALL"
	//   "CUSTOMER_MESSAGE"
	//   "AGENT_MESSAGE"
	//   "TOOL_CALL_COMPLETION"
	TriggeringEvent string `json:"triggeringEvent,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AgentAction") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AgentAction") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2AgentCoachingInstruction) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2AgentCoachingInstruction
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowV2AgentCoachingInstructionDuplicateCheckResult struct {
	DuplicateSuggestions []*GoogleCloudDialogflowV2AgentCoachingInstructionDuplicateCheckResultDuplicateSuggestion `json:"duplicateSuggestions,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DuplicateSuggestions") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DuplicateSuggestions") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2AgentCoachingInstructionDuplicateCheckResult) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2AgentCoachingInstructionDuplicateCheckResult
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowV2AgentCoachingInstructionDuplicateCheckResultDuplicateSuggestion struct {
	AnswerRecord    string  `json:"answerRecord,omitempty"`
	SimilarityScore float64 `json:"similarityScore,omitempty"`
	SuggestionIndex int64   `json:"suggestionIndex,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AnswerRecord") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AnswerRecord") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2AgentCoachingInstructionDuplicateCheckResultDuplicateSuggestion) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2AgentCoachingInstructionDuplicateCheckResultDuplicateSuggestion
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *GoogleCloudDialogflowV2AgentCoachingInstructionDuplicateCheckResultDuplicateSuggestion) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleCloudDialogflowV2AgentCoachingInstructionDuplicateCheckResultDuplicateSuggestion
	var s1 struct {
		SimilarityScore gensupport.JSONFloat64 `json:"similarityScore"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.SimilarityScore = float64(s1.SimilarityScore)
	return nil
}

type GoogleCloudDialogflowV2AgentCoachingSuggestion struct {
	AgentActionSuggestions []*GoogleCloudDialogflowV2AgentCoachingSuggestionAgentActionSuggestion `json:"agentActionSuggestions,omitempty"`
	ApplicableInstructions []*GoogleCloudDialogflowV2AgentCoachingInstruction                     `json:"applicableInstructions,omitempty"`
	SampleResponses        []*GoogleCloudDialogflowV2AgentCoachingSuggestionSampleResponse        `json:"sampleResponses,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AgentActionSuggestions") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AgentActionSuggestions") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2AgentCoachingSuggestion) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2AgentCoachingSuggestion
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowV2AgentCoachingSuggestionAgentActionSuggestion struct {
	AgentAction          string                                                              `json:"agentAction,omitempty"`
	DuplicateCheckResult *GoogleCloudDialogflowV2AgentCoachingSuggestionDuplicateCheckResult `json:"duplicateCheckResult,omitempty"`
	Sources              *GoogleCloudDialogflowV2AgentCoachingSuggestionSources              `json:"sources,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AgentAction") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AgentAction") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2AgentCoachingSuggestionAgentActionSuggestion) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2AgentCoachingSuggestionAgentActionSuggestion
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowV2AgentCoachingSuggestionDuplicateCheckResult struct {
	DuplicateSuggestions []*GoogleCloudDialogflowV2AgentCoachingSuggestionDuplicateCheckResultDuplicateSuggestion `json:"duplicateSuggestions,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DuplicateSuggestions") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DuplicateSuggestions") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2AgentCoachingSuggestionDuplicateCheckResult) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2AgentCoachingSuggestionDuplicateCheckResult
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowV2AgentCoachingSuggestionDuplicateCheckResultDuplicateSuggestion struct {
	AnswerRecord    string                                                 `json:"answerRecord,omitempty"`
	SimilarityScore float64                                                `json:"similarityScore,omitempty"`
	Sources         *GoogleCloudDialogflowV2AgentCoachingSuggestionSources `json:"sources,omitempty"`
	SuggestionIndex int64                                                  `json:"suggestionIndex,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AnswerRecord") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AnswerRecord") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2AgentCoachingSuggestionDuplicateCheckResultDuplicateSuggestion) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2AgentCoachingSuggestionDuplicateCheckResultDuplicateSuggestion
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *GoogleCloudDialogflowV2AgentCoachingSuggestionDuplicateCheckResultDuplicateSuggestion) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleCloudDialogflowV2AgentCoachingSuggestionDuplicateCheckResultDuplicateSuggestion
	var s1 struct {
		SimilarityScore gensupport.JSONFloat64 `json:"similarityScore"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.SimilarityScore = float64(s1.SimilarityScore)
	return nil
}

type GoogleCloudDialogflowV2AgentCoachingSuggestionSampleResponse struct {
	DuplicateCheckResult *GoogleCloudDialogflowV2AgentCoachingSuggestionDuplicateCheckResult `json:"duplicateCheckResult,omitempty"`
	ResponseText         string                                                              `json:"responseText,omitempty"`
	Sources              *GoogleCloudDialogflowV2AgentCoachingSuggestionSources              `json:"sources,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DuplicateCheckResult") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DuplicateCheckResult") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2AgentCoachingSuggestionSampleResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2AgentCoachingSuggestionSampleResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowV2AgentCoachingSuggestionSources struct {
	InstructionIndexes []int64 `json:"instructionIndexes,omitempty"`
	// ForceSendFields is a list of field names (e.g. "InstructionIndexes") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "InstructionIndexes") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2AgentCoachingSuggestionSources) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2AgentCoachingSuggestionSources
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowV2AnnotatedMessagePart struct {
	EntityType     string      `json:"entityType,omitempty"`
	FormattedValue interface{} `json:"formattedValue,omitempty"`
	Text           string      `json:"text,omitempty"`
	// ForceSendFields is a list of field names (e.g. "EntityType") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "EntityType") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2AnnotatedMessagePart) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2AnnotatedMessagePart
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowV2ArticleAnswer struct {
	AnswerRecord string            `json:"answerRecord,omitempty"`
	Confidence   float64           `json:"confidence,omitempty"`
	Metadata     map[string]string `json:"metadata,omitempty"`
	Snippets     []string          `json:"snippets,omitempty"`
	Title        string            `json:"title,omitempty"`
	Uri          string            `json:"uri,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AnswerRecord") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AnswerRecord") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2ArticleAnswer) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2ArticleAnswer
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *GoogleCloudDialogflowV2ArticleAnswer) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleCloudDialogflowV2ArticleAnswer
	var s1 struct {
		Confidence gensupport.JSONFloat64 `json:"confidence"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.Confidence = float64(s1.Confidence)
	return nil
}

type GoogleCloudDialogflowV2ArticleSuggestionModelMetadata struct {
	// Possible values:
	//   "MODEL_TYPE_UNSPECIFIED"
	//   "SMART_REPLY_DUAL_ENCODER_MODEL"
	//   "SMART_REPLY_BERT_MODEL"
	TrainingModelType string `json:"trainingModelType,omitempty"`
	// ForceSendFields is a list of field names (e.g. "TrainingModelType") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "TrainingModelType") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2ArticleSuggestionModelMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2ArticleSuggestionModelMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowV2BatchUpdateEntityTypesResponse struct {
	EntityTypes []*GoogleCloudDialogflowV2EntityType `json:"entityTypes,omitempty"`
	// ForceSendFields is a list of field names (e.g. "EntityTypes") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "EntityTypes") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2BatchUpdateEntityTypesResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2BatchUpdateEntityTypesResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowV2BatchUpdateIntentsResponse struct {
	Intents []*GoogleCloudDialogflowV2Intent `json:"intents,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Intents") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Intents") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2BatchUpdateIntentsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2BatchUpdateIntentsResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowV2ClearSuggestionFeatureConfigOperationMetadata struct {
	ConversationProfile string `json:"conversationProfile,omitempty"`
	CreateTime          string `json:"createTime,omitempty"`
	// Possible values:
	//   "ROLE_UNSPECIFIED"
	//   "HUMAN_AGENT"
	//   "AUTOMATED_AGENT"
	//   "END_USER"
	ParticipantRole string `json:"participantRole,omitempty"`
	// Possible values:
	//   "TYPE_UNSPECIFIED"
	//   "ARTICLE_SUGGESTION"
	//   "FAQ"
	//   "SMART_REPLY"
	//   "CONVERSATION_SUMMARIZATION"
	//   "KNOWLEDGE_SEARCH"
	//   "KNOWLEDGE_ASSIST"
	SuggestionFeatureType string `json:"suggestionFeatureType,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ConversationProfile") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ConversationProfile") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2ClearSuggestionFeatureConfigOperationMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2ClearSuggestionFeatureConfigOperationMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowV2Context struct {
	LifespanCount int64                `json:"lifespanCount,omitempty"`
	Name          string               `json:"name,omitempty"`
	Parameters    googleapi.RawMessage `json:"parameters,omitempty"`
	// ForceSendFields is a list of field names (e.g. "LifespanCount") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "LifespanCount") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2Context) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2Context
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowV2ConversationEvent struct {
	Conversation                string                                             `json:"conversation,omitempty"`
	ErrorStatus                 *GoogleRpcStatus                                   `json:"errorStatus,omitempty"`
	NewMessagePayload           *GoogleCloudDialogflowV2Message                    `json:"newMessagePayload,omitempty"`
	NewRecognitionResultPayload *GoogleCloudDialogflowV2StreamingRecognitionResult `json:"newRecognitionResultPayload,omitempty"`
	// Possible values:
	//   "TYPE_UNSPECIFIED"
	//   "CONVERSATION_STARTED"
	//   "CONVERSATION_FINISHED"
	//   "HUMAN_INTERVENTION_NEEDED"
	//   "NEW_MESSAGE"
	//   "NEW_RECOGNITION_RESULT"
	//   "UNRECOVERABLE_ERROR"
	Type string `json:"type,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Conversation") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Conversation") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2ConversationEvent) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2ConversationEvent
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowV2ConversationModel struct {
	ArticleSuggestionModelMetadata *GoogleCloudDialogflowV2ArticleSuggestionModelMetadata `json:"articleSuggestionModelMetadata,omitempty"`
	CreateTime                     string                                                 `json:"createTime,omitempty"`
	Datasets                       []*GoogleCloudDialogflowV2InputDataset                 `json:"datasets,omitempty"`
	DisplayName                    string                                                 `json:"displayName,omitempty"`
	LanguageCode                   string                                                 `json:"languageCode,omitempty"`
	Name                           string                                                 `json:"name,omitempty"`
	SatisfiesPzi                   bool                                                   `json:"satisfiesPzi,omitempty"`
	SatisfiesPzs                   bool                                                   `json:"satisfiesPzs,omitempty"`
	SmartReplyModelMetadata        *GoogleCloudDialogflowV2SmartReplyModelMetadata        `json:"smartReplyModelMetadata,omitempty"`
	// Possible values:
	//   "STATE_UNSPECIFIED"
	//   "CREATING"
	//   "UNDEPLOYED"
	//   "DEPLOYING"
	//   "DEPLOYED"
	//   "UNDEPLOYING"
	//   "DELETING"
	//   "FAILED"
	//   "PENDING"
	State string `json:"state,omitempty"`
	// ForceSendFields is a list of field names (e.g.
	// "ArticleSuggestionModelMetadata") to unconditionally include in API
	// requests. By default, fields with empty or default values are omitted from
	// API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ArticleSuggestionModelMetadata")
	// to include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2ConversationModel) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2ConversationModel
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowV2CreateConversationDatasetOperationMetadata struct {
	ConversationDataset string `json:"conversationDataset,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ConversationDataset") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ConversationDataset") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2CreateConversationDatasetOperationMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2CreateConversationDatasetOperationMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowV2CreateConversationModelEvaluationOperationMetadata struct {
	ConversationModel           string `json:"conversationModel,omitempty"`
	ConversationModelEvaluation string `json:"conversationModelEvaluation,omitempty"`
	CreateTime                  string `json:"createTime,omitempty"`
	// Possible values:
	//   "STATE_UNSPECIFIED"
	//   "INITIALIZING"
	//   "RUNNING"
	//   "CANCELLED"
	//   "SUCCEEDED"
	//   "FAILED"
	State string `json:"state,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ConversationModel") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ConversationModel") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2CreateConversationModelEvaluationOperationMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2CreateConversationModelEvaluationOperationMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowV2CreateConversationModelOperationMetadata struct {
	ConversationModel string `json:"conversationModel,omitempty"`
	CreateTime        string `json:"createTime,omitempty"`
	DoneTime          string `json:"doneTime,omitempty"`
	// Possible values:
	//   "STATE_UNSPECIFIED"
	//   "PENDING"
	//   "SUCCEEDED"
	//   "FAILED"
	//   "CANCELLED"
	//   "CANCELLING"
	//   "TRAINING"
	State string `json:"state,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ConversationModel") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ConversationModel") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2CreateConversationModelOperationMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2CreateConversationModelOperationMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowV2DeleteConversationDatasetOperationMetadata struct {
}

type GoogleCloudDialogflowV2DeleteConversationModelOperationMetadata struct {
	ConversationModel string `json:"conversationModel,omitempty"`
	CreateTime        string `json:"createTime,omitempty"`
	DoneTime          string `json:"doneTime,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ConversationModel") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ConversationModel") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2DeleteConversationModelOperationMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2DeleteConversationModelOperationMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowV2DeployConversationModelOperationMetadata struct {
	ConversationModel string `json:"conversationModel,omitempty"`
	CreateTime        string `json:"createTime,omitempty"`
	DoneTime          string `json:"doneTime,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ConversationModel") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ConversationModel") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2DeployConversationModelOperationMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2DeployConversationModelOperationMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowV2EncryptionSpec struct {
	KmsKey string `json:"kmsKey,omitempty"`
	Name   string `json:"name,omitempty"`
	// ForceSendFields is a list of field names (e.g. "KmsKey") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "KmsKey") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2EncryptionSpec) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2EncryptionSpec
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowV2EntityType struct {
	// Possible values:
	//   "AUTO_EXPANSION_MODE_UNSPECIFIED"
	//   "AUTO_EXPANSION_MODE_DEFAULT"
	AutoExpansionMode     string                                     `json:"autoExpansionMode,omitempty"`
	DisplayName           string                                     `json:"displayName,omitempty"`
	EnableFuzzyExtraction bool                                       `json:"enableFuzzyExtraction,omitempty"`
	Entities              []*GoogleCloudDialogflowV2EntityTypeEntity `json:"entities,omitempty"`
	// Possible values:
	//   "KIND_UNSPECIFIED"
	//   "KIND_MAP"
	//   "KIND_LIST"
	//   "KIND_REGEXP"
	Kind string `json:"kind,omitempty"`
	Name string `json:"name,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AutoExpansionMode") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AutoExpansionMode") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2EntityType) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2EntityType
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowV2EntityTypeEntity struct {
	Synonyms []string `json:"synonyms,omitempty"`
	Value    string   `json:"value,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Synonyms") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Synonyms") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2EntityTypeEntity) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2EntityTypeEntity
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowV2EventInput struct {
	LanguageCode string               `json:"languageCode,omitempty"`
	Name         string               `json:"name,omitempty"`
	Parameters   googleapi.RawMessage `json:"parameters,omitempty"`
	// ForceSendFields is a list of field names (e.g. "LanguageCode") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "LanguageCode") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2EventInput) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2EventInput
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowV2ExportAgentResponse struct {
	AgentContent string `json:"agentContent,omitempty"`
	AgentUri     string `json:"agentUri,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AgentContent") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AgentContent") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2ExportAgentResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2ExportAgentResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowV2ExportOperationMetadata struct {
	ExportedGcsDestination *GoogleCloudDialogflowV2GcsDestination `json:"exportedGcsDestination,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ExportedGcsDestination") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ExportedGcsDestination") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2ExportOperationMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2ExportOperationMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowV2FaqAnswer struct {
	Answer       string            `json:"answer,omitempty"`
	AnswerRecord string            `json:"answerRecord,omitempty"`
	Confidence   float64           `json:"confidence,omitempty"`
	Metadata     map[string]string `json:"metadata,omitempty"`
	Question     string            `json:"question,omitempty"`
	Source       string            `json:"source,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Answer") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Answer") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2FaqAnswer) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2FaqAnswer
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *GoogleCloudDialogflowV2FaqAnswer) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleCloudDialogflowV2FaqAnswer
	var s1 struct {
		Confidence gensupport.JSONFloat64 `json:"confidence"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.Confidence = float64(s1.Confidence)
	return nil
}

type GoogleCloudDialogflowV2FreeFormSuggestion struct {
	Response string `json:"response,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Response") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Response") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2FreeFormSuggestion) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2FreeFormSuggestion
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowV2GcsDestination struct {
	Uri string `json:"uri,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Uri") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Uri") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2GcsDestination) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2GcsDestination
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowV2GenerateSuggestionsResponse struct {
	GeneratorSuggestionAnswers []*GoogleCloudDialogflowV2GenerateSuggestionsResponseGeneratorSuggestionAnswer `json:"generatorSuggestionAnswers,omitempty"`
	LatestMessage              string                                                                         `json:"latestMessage,omitempty"`
	// ForceSendFields is a list of field names (e.g. "GeneratorSuggestionAnswers")
	// to unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "GeneratorSuggestionAnswers") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2GenerateSuggestionsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2GenerateSuggestionsResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowV2GenerateSuggestionsResponseGeneratorSuggestionAnswer struct {
	AnswerRecord        string                                      `json:"answerRecord,omitempty"`
	GeneratorSuggestion *GoogleCloudDialogflowV2GeneratorSuggestion `json:"generatorSuggestion,omitempty"`
	SourceGenerator     string                                      `json:"sourceGenerator,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AnswerRecord") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AnswerRecord") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2GenerateSuggestionsResponseGeneratorSuggestionAnswer) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2GenerateSuggestionsResponseGeneratorSuggestionAnswer
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowV2GeneratorSuggestion struct {
	AgentCoachingSuggestion *GoogleCloudDialogflowV2AgentCoachingSuggestion           `json:"agentCoachingSuggestion,omitempty"`
	FreeFormSuggestion      *GoogleCloudDialogflowV2FreeFormSuggestion                `json:"freeFormSuggestion,omitempty"`
	SummarySuggestion       *GoogleCloudDialogflowV2SummarySuggestion                 `json:"summarySuggestion,omitempty"`
	ToolCallInfo            []*GoogleCloudDialogflowV2GeneratorSuggestionToolCallInfo `json:"toolCallInfo,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AgentCoachingSuggestion") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AgentCoachingSuggestion") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2GeneratorSuggestion) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2GeneratorSuggestion
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowV2GeneratorSuggestionToolCallInfo struct {
	ToolCall       *GoogleCloudDialogflowV2ToolCall       `json:"toolCall,omitempty"`
	ToolCallResult *GoogleCloudDialogflowV2ToolCallResult `json:"toolCallResult,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ToolCall") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ToolCall") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2GeneratorSuggestionToolCallInfo) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2GeneratorSuggestionToolCallInfo
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowV2HumanAgentAssistantEvent struct {
	Conversation      string                                     `json:"conversation,omitempty"`
	Participant       string                                     `json:"participant,omitempty"`
	SuggestionResults []*GoogleCloudDialogflowV2SuggestionResult `json:"suggestionResults,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Conversation") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Conversation") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2HumanAgentAssistantEvent) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2HumanAgentAssistantEvent
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowV2ImportConversationDataOperationMetadata struct {
	ConversationDataset string             `json:"conversationDataset,omitempty"`
	CreateTime          string             `json:"createTime,omitempty"`
	PartialFailures     []*GoogleRpcStatus `json:"partialFailures,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ConversationDataset") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ConversationDataset") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2ImportConversationDataOperationMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2ImportConversationDataOperationMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowV2ImportConversationDataOperationResponse struct {
	ConversationDataset string `json:"conversationDataset,omitempty"`
	ImportCount         int64  `json:"importCount,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ConversationDataset") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ConversationDataset") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2ImportConversationDataOperationResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2ImportConversationDataOperationResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowV2ImportDocumentsResponse struct {
	Warnings []*GoogleRpcStatus `json:"warnings,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Warnings") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Warnings") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2ImportDocumentsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2ImportDocumentsResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowV2IngestedContextReferenceDebugInfo struct {
	ContextReferenceRetrieved   bool                                                                                  `json:"contextReferenceRetrieved,omitempty"`
	IngestedParametersDebugInfo []*GoogleCloudDialogflowV2IngestedContextReferenceDebugInfoIngestedParameterDebugInfo `json:"ingestedParametersDebugInfo,omitempty"`
	ProjectNotAllowlisted       bool                                                                                  `json:"projectNotAllowlisted,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ContextReferenceRetrieved")
	// to unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ContextReferenceRetrieved") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2IngestedContextReferenceDebugInfo) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2IngestedContextReferenceDebugInfo
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowV2IngestedContextReferenceDebugInfoIngestedParameterDebugInfo struct {
	// Possible values:
	//   "INGESTION_STATUS_UNSPECIFIED"
	//   "INGESTION_STATUS_SUCCEEDED"
	//   "INGESTION_STATUS_CONTEXT_NOT_AVAILABLE"
	//   "INGESTION_STATUS_PARSE_FAILED"
	//   "INGESTION_STATUS_INVALID_ENTRY"
	//   "INGESTION_STATUS_INVALID_FORMAT"
	//   "INGESTION_STATUS_LANGUAGE_MISMATCH"
	IngestionStatus string `json:"ingestionStatus,omitempty"`
	Parameter       string `json:"parameter,omitempty"`
	// ForceSendFields is a list of field names (e.g. "IngestionStatus") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "IngestionStatus") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2IngestedContextReferenceDebugInfoIngestedParameterDebugInfo) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2IngestedContextReferenceDebugInfoIngestedParameterDebugInfo
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowV2InitializeEncryptionSpecMetadata struct {
	Request *GoogleCloudDialogflowV2InitializeEncryptionSpecRequest `json:"request,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Request") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Request") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2InitializeEncryptionSpecMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2InitializeEncryptionSpecMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowV2InitializeEncryptionSpecRequest struct {
	EncryptionSpec *GoogleCloudDialogflowV2EncryptionSpec `json:"encryptionSpec,omitempty"`
	// ForceSendFields is a list of field names (e.g. "EncryptionSpec") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "EncryptionSpec") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2InitializeEncryptionSpecRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2InitializeEncryptionSpecRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowV2InputDataset struct {
	Dataset string `json:"dataset,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Dataset") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Dataset") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2InputDataset) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2InputDataset
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowV2Intent struct {
	Action string `json:"action,omitempty"`
	// Possible values:
	//   "PLATFORM_UNSPECIFIED"
	//   "FACEBOOK"
	//   "SLACK"
	//   "TELEGRAM"
	//   "KIK"
	//   "SKYPE"
	//   "LINE"
	//   "VIBER"
	//   "ACTIONS_ON_GOOGLE"
	//   "GOOGLE_HANGOUTS"
	DefaultResponsePlatforms []string                                           `json:"defaultResponsePlatforms,omitempty"`
	DisplayName              string                                             `json:"displayName,omitempty"`
	EndInteraction           bool                                               `json:"endInteraction,omitempty"`
	Events                   []string                                           `json:"events,omitempty"`
	FollowupIntentInfo       []*GoogleCloudDialogflowV2IntentFollowupIntentInfo `json:"followupIntentInfo,omitempty"`
	InputContextNames        []string                                           `json:"inputContextNames,omitempty"`
	IsFallback               bool                                               `json:"isFallback,omitempty"`
	LiveAgentHandoff         bool                                               `json:"liveAgentHandoff,omitempty"`
	Messages                 []*GoogleCloudDialogflowV2IntentMessage            `json:"messages,omitempty"`
	MlDisabled               bool                                               `json:"mlDisabled,omitempty"`
	Name                     string                                             `json:"name,omitempty"`
	OutputContexts           []*GoogleCloudDialogflowV2Context                  `json:"outputContexts,omitempty"`
	Parameters               []*GoogleCloudDialogflowV2IntentParameter          `json:"parameters,omitempty"`
	ParentFollowupIntentName string                                             `json:"parentFollowupIntentName,omitempty"`
	Priority                 int64                                              `json:"priority,omitempty"`
	ResetContexts            bool                                               `json:"resetContexts,omitempty"`
	RootFollowupIntentName   string                                             `json:"rootFollowupIntentName,omitempty"`
	TrainingPhrases          []*GoogleCloudDialogflowV2IntentTrainingPhrase     `json:"trainingPhrases,omitempty"`
	// Possible values:
	//   "WEBHOOK_STATE_UNSPECIFIED"
	//   "WEBHOOK_STATE_ENABLED"
	//   "WEBHOOK_STATE_ENABLED_FOR_SLOT_FILLING"
	WebhookState string `json:"webhookState,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Action") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Action") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2Intent) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2Intent
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowV2IntentFollowupIntentInfo struct {
	FollowupIntentName       string `json:"followupIntentName,omitempty"`
	ParentFollowupIntentName string `json:"parentFollowupIntentName,omitempty"`
	// ForceSendFields is a list of field names (e.g. "FollowupIntentName") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "FollowupIntentName") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2IntentFollowupIntentInfo) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2IntentFollowupIntentInfo
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowV2IntentMessage struct {
	BasicCard          *GoogleCloudDialogflowV2IntentMessageBasicCard          `json:"basicCard,omitempty"`
	BrowseCarouselCard *GoogleCloudDialogflowV2IntentMessageBrowseCarouselCard `json:"browseCarouselCard,omitempty"`
	Card               *GoogleCloudDialogflowV2IntentMessageCard               `json:"card,omitempty"`
	CarouselSelect     *GoogleCloudDialogflowV2IntentMessageCarouselSelect     `json:"carouselSelect,omitempty"`
	Image              *GoogleCloudDialogflowV2IntentMessageImage              `json:"image,omitempty"`
	LinkOutSuggestion  *GoogleCloudDialogflowV2IntentMessageLinkOutSuggestion  `json:"linkOutSuggestion,omitempty"`
	ListSelect         *GoogleCloudDialogflowV2IntentMessageListSelect         `json:"listSelect,omitempty"`
	MediaContent       *GoogleCloudDialogflowV2IntentMessageMediaContent       `json:"mediaContent,omitempty"`
	Payload            googleapi.RawMessage                                    `json:"payload,omitempty"`
	// Possible values:
	//   "PLATFORM_UNSPECIFIED"
	//   "FACEBOOK"
	//   "SLACK"
	//   "TELEGRAM"
	//   "KIK"
	//   "SKYPE"
	//   "LINE"
	//   "VIBER"
	//   "ACTIONS_ON_GOOGLE"
	//   "GOOGLE_HANGOUTS"
	Platform        string                                               `json:"platform,omitempty"`
	QuickReplies    *GoogleCloudDialogflowV2IntentMessageQuickReplies    `json:"quickReplies,omitempty"`
	SimpleResponses *GoogleCloudDialogflowV2IntentMessageSimpleResponses `json:"simpleResponses,omitempty"`
	Suggestions     *GoogleCloudDialogflowV2IntentMessageSuggestions     `json:"suggestions,omitempty"`
	TableCard       *GoogleCloudDialogflowV2IntentMessageTableCard       `json:"tableCard,omitempty"`
	Text            *GoogleCloudDialogflowV2IntentMessageText            `json:"text,omitempty"`
	// ForceSendFields is a list of field names (e.g. "BasicCard") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "BasicCard") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2IntentMessage) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2IntentMessage
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowV2IntentMessageBasicCard struct {
	Buttons       []*GoogleCloudDialogflowV2IntentMessageBasicCardButton `json:"buttons,omitempty"`
	FormattedText string                                                 `json:"formattedText,omitempty"`
	Image         *GoogleCloudDialogflowV2IntentMessageImage             `json:"image,omitempty"`
	Subtitle      string                                                 `json:"subtitle,omitempty"`
	Title         string                                                 `json:"title,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Buttons") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Buttons") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2IntentMessageBasicCard) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2IntentMessageBasicCard
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowV2IntentMessageBasicCardButton struct {
	OpenUriAction *GoogleCloudDialogflowV2IntentMessageBasicCardButtonOpenUriAction `json:"openUriAction,omitempty"`
	Title         string                                                            `json:"title,omitempty"`
	// ForceSendFields is a list of field names (e.g. "OpenUriAction") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "OpenUriAction") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2IntentMessageBasicCardButton) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2IntentMessageBasicCardButton
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowV2IntentMessageBasicCardButtonOpenUriAction struct {
	Uri string `json:"uri,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Uri") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Uri") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2IntentMessageBasicCardButtonOpenUriAction) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2IntentMessageBasicCardButtonOpenUriAction
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowV2IntentMessageBrowseCarouselCard struct {
	// Possible values:
	//   "IMAGE_DISPLAY_OPTIONS_UNSPECIFIED"
	//   "GRAY"
	//   "WHITE"
	//   "CROPPED"
	//   "BLURRED_BACKGROUND"
	ImageDisplayOptions string                                                                          `json:"imageDisplayOptions,omitempty"`
	Items               []*GoogleCloudDialogflowV2IntentMessageBrowseCarouselCardBrowseCarouselCardItem `json:"items,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ImageDisplayOptions") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ImageDisplayOptions") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2IntentMessageBrowseCarouselCard) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2IntentMessageBrowseCarouselCard
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowV2IntentMessageBrowseCarouselCardBrowseCarouselCardItem struct {
	Description   string                                                                                     `json:"description,omitempty"`
	Footer        string                                                                                     `json:"footer,omitempty"`
	Image         *GoogleCloudDialogflowV2IntentMessageImage                                                 `json:"image,omitempty"`
	OpenUriAction *GoogleCloudDialogflowV2IntentMessageBrowseCarouselCardBrowseCarouselCardItemOpenUrlAction `json:"openUriAction,omitempty"`
	Title         string                                                                                     `json:"title,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Description") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Description") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2IntentMessageBrowseCarouselCardBrowseCarouselCardItem) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2IntentMessageBrowseCarouselCardBrowseCarouselCardItem
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowV2IntentMessageBrowseCarouselCardBrowseCarouselCardItemOpenUrlAction struct {
	Url string `json:"url,omitempty"`
	// Possible values:
	//   "URL_TYPE_HINT_UNSPECIFIED"
	//   "AMP_ACTION"
	//   "AMP_CONTENT"
	UrlTypeHint string `json:"urlTypeHint,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Url") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Url") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2IntentMessageBrowseCarouselCardBrowseCarouselCardItemOpenUrlAction) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2IntentMessageBrowseCarouselCardBrowseCarouselCardItemOpenUrlAction
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowV2IntentMessageCard struct {
	Buttons  []*GoogleCloudDialogflowV2IntentMessageCardButton `json:"buttons,omitempty"`
	ImageUri string                                            `json:"imageUri,omitempty"`
	Subtitle string                                            `json:"subtitle,omitempty"`
	Title    string                                            `json:"title,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Buttons") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Buttons") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2IntentMessageCard) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2IntentMessageCard
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowV2IntentMessageCardButton struct {
	Postback string `json:"postback,omitempty"`
	Text     string `json:"text,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Postback") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Postback") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2IntentMessageCardButton) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2IntentMessageCardButton
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowV2IntentMessageCarouselSelect struct {
	Items []*GoogleCloudDialogflowV2IntentMessageCarouselSelectItem `json:"items,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Items") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Items") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2IntentMessageCarouselSelect) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2IntentMessageCarouselSelect
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowV2IntentMessageCarouselSelectItem struct {
	Description string                                              `json:"description,omitempty"`
	Image       *GoogleCloudDialogflowV2IntentMessageImage          `json:"image,omitempty"`
	Info        *GoogleCloudDialogflowV2IntentMessageSelectItemInfo `json:"info,omitempty"`
	Title       string                                              `json:"title,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Description") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Description") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2IntentMessageCarouselSelectItem) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2IntentMessageCarouselSelectItem
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowV2IntentMessageColumnProperties struct {
	Header string `json:"header,omitempty"`
	// Possible values:
	//   "HORIZONTAL_ALIGNMENT_UNSPECIFIED"
	//   "LEADING"
	//   "CENTER"
	//   "TRAILING"
	HorizontalAlignment string `json:"horizontalAlignment,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Header") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Header") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2IntentMessageColumnProperties) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2IntentMessageColumnProperties
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowV2IntentMessageImage struct {
	AccessibilityText string `json:"accessibilityText,omitempty"`
	ImageUri          string `json:"imageUri,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AccessibilityText") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AccessibilityText") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2IntentMessageImage) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2IntentMessageImage
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowV2IntentMessageLinkOutSuggestion struct {
	DestinationName string `json:"destinationName,omitempty"`
	Uri             string `json:"uri,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DestinationName") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DestinationName") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2IntentMessageLinkOutSuggestion) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2IntentMessageLinkOutSuggestion
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowV2IntentMessageListSelect struct {
	Items    []*GoogleCloudDialogflowV2IntentMessageListSelectItem `json:"items,omitempty"`
	Subtitle string                                                `json:"subtitle,omitempty"`
	Title    string                                                `json:"title,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Items") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Items") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2IntentMessageListSelect) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2IntentMessageListSelect
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowV2IntentMessageListSelectItem struct {
	Description string                                              `json:"description,omitempty"`
	Image       *GoogleCloudDialogflowV2IntentMessageImage          `json:"image,omitempty"`
	Info        *GoogleCloudDialogflowV2IntentMessageSelectItemInfo `json:"info,omitempty"`
	Title       string                                              `json:"title,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Description") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Description") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2IntentMessageListSelectItem) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2IntentMessageListSelectItem
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowV2IntentMessageMediaContent struct {
	MediaObjects []*GoogleCloudDialogflowV2IntentMessageMediaContentResponseMediaObject `json:"mediaObjects,omitempty"`
	// Possible values:
	//   "RESPONSE_MEDIA_TYPE_UNSPECIFIED"
	//   "AUDIO"
	MediaType string `json:"mediaType,omitempty"`
	// ForceSendFields is a list of field names (e.g. "MediaObjects") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "MediaObjects") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2IntentMessageMediaContent) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2IntentMessageMediaContent
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowV2IntentMessageMediaContentResponseMediaObject struct {
	ContentUrl  string                                     `json:"contentUrl,omitempty"`
	Description string                                     `json:"description,omitempty"`
	Icon        *GoogleCloudDialogflowV2IntentMessageImage `json:"icon,omitempty"`
	LargeImage  *GoogleCloudDialogflowV2IntentMessageImage `json:"largeImage,omitempty"`
	Name        string                                     `json:"name,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ContentUrl") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ContentUrl") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2IntentMessageMediaContentResponseMediaObject) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2IntentMessageMediaContentResponseMediaObject
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowV2IntentMessageQuickReplies struct {
	QuickReplies []string `json:"quickReplies,omitempty"`
	Title        string   `json:"title,omitempty"`
	// ForceSendFields is a list of field names (e.g. "QuickReplies") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "QuickReplies") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2IntentMessageQuickReplies) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2IntentMessageQuickReplies
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowV2IntentMessageSelectItemInfo struct {
	Key      string   `json:"key,omitempty"`
	Synonyms []string `json:"synonyms,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Key") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Key") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2IntentMessageSelectItemInfo) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2IntentMessageSelectItemInfo
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowV2IntentMessageSimpleResponse struct {
	DisplayText  string `json:"displayText,omitempty"`
	Ssml         string `json:"ssml,omitempty"`
	TextToSpeech string `json:"textToSpeech,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DisplayText") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DisplayText") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2IntentMessageSimpleResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2IntentMessageSimpleResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowV2IntentMessageSimpleResponses struct {
	SimpleResponses []*GoogleCloudDialogflowV2IntentMessageSimpleResponse `json:"simpleResponses,omitempty"`
	// ForceSendFields is a list of field names (e.g. "SimpleResponses") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "SimpleResponses") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2IntentMessageSimpleResponses) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2IntentMessageSimpleResponses
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowV2IntentMessageSuggestion struct {
	Title string `json:"title,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Title") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Title") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2IntentMessageSuggestion) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2IntentMessageSuggestion
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowV2IntentMessageSuggestions struct {
	Suggestions []*GoogleCloudDialogflowV2IntentMessageSuggestion `json:"suggestions,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Suggestions") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Suggestions") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2IntentMessageSuggestions) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2IntentMessageSuggestions
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowV2IntentMessageTableCard struct {
	Buttons          []*GoogleCloudDialogflowV2IntentMessageBasicCardButton  `json:"buttons,omitempty"`
	ColumnProperties []*GoogleCloudDialogflowV2IntentMessageColumnProperties `json:"columnProperties,omitempty"`
	Image            *GoogleCloudDialogflowV2IntentMessageImage              `json:"image,omitempty"`
	Rows             []*GoogleCloudDialogflowV2IntentMessageTableCardRow     `json:"rows,omitempty"`
	Subtitle         string                                                  `json:"subtitle,omitempty"`
	Title            string                                                  `json:"title,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Buttons") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Buttons") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2IntentMessageTableCard) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2IntentMessageTableCard
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowV2IntentMessageTableCardCell struct {
	Text string `json:"text,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Text") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Text") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2IntentMessageTableCardCell) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2IntentMessageTableCardCell
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowV2IntentMessageTableCardRow struct {
	Cells        []*GoogleCloudDialogflowV2IntentMessageTableCardCell `json:"cells,omitempty"`
	DividerAfter bool                                                 `json:"dividerAfter,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Cells") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Cells") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2IntentMessageTableCardRow) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2IntentMessageTableCardRow
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowV2IntentMessageText struct {
	Text []string `json:"text,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Text") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Text") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2IntentMessageText) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2IntentMessageText
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowV2IntentParameter struct {
	DefaultValue          string   `json:"defaultValue,omitempty"`
	DisplayName           string   `json:"displayName,omitempty"`
	EntityTypeDisplayName string   `json:"entityTypeDisplayName,omitempty"`
	IsList                bool     `json:"isList,omitempty"`
	Mandatory             bool     `json:"mandatory,omitempty"`
	Name                  string   `json:"name,omitempty"`
	Prompts               []string `json:"prompts,omitempty"`
	Value                 string   `json:"value,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DefaultValue") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DefaultValue") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2IntentParameter) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2IntentParameter
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowV2IntentTrainingPhrase struct {
	Name            string                                             `json:"name,omitempty"`
	Parts           []*GoogleCloudDialogflowV2IntentTrainingPhrasePart `json:"parts,omitempty"`
	TimesAddedCount int64                                              `json:"timesAddedCount,omitempty"`
	// Possible values:
	//   "TYPE_UNSPECIFIED"
	//   "EXAMPLE"
	//   "TEMPLATE"
	Type string `json:"type,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Name") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Name") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2IntentTrainingPhrase) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2IntentTrainingPhrase
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowV2IntentTrainingPhrasePart struct {
	Alias       string `json:"alias,omitempty"`
	EntityType  string `json:"entityType,omitempty"`
	Text        string `json:"text,omitempty"`
	UserDefined bool   `json:"userDefined,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Alias") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Alias") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2IntentTrainingPhrasePart) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2IntentTrainingPhrasePart
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowV2KnowledgeAssistAnswer struct {
	AnswerRecord             string                                                       `json:"answerRecord,omitempty"`
	KnowledgeAssistDebugInfo *GoogleCloudDialogflowV2KnowledgeAssistDebugInfo             `json:"knowledgeAssistDebugInfo,omitempty"`
	SuggestedQuery           *GoogleCloudDialogflowV2KnowledgeAssistAnswerSuggestedQuery  `json:"suggestedQuery,omitempty"`
	SuggestedQueryAnswer     *GoogleCloudDialogflowV2KnowledgeAssistAnswerKnowledgeAnswer `json:"suggestedQueryAnswer,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AnswerRecord") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AnswerRecord") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2KnowledgeAssistAnswer) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2KnowledgeAssistAnswer
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowV2KnowledgeAssistAnswerKnowledgeAnswer struct {
	AnswerText       string                                                                       `json:"answerText,omitempty"`
	FaqSource        *GoogleCloudDialogflowV2KnowledgeAssistAnswerKnowledgeAnswerFaqSource        `json:"faqSource,omitempty"`
	GenerativeSource *GoogleCloudDialogflowV2KnowledgeAssistAnswerKnowledgeAnswerGenerativeSource `json:"generativeSource,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AnswerText") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AnswerText") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2KnowledgeAssistAnswerKnowledgeAnswer) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2KnowledgeAssistAnswerKnowledgeAnswer
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowV2KnowledgeAssistAnswerKnowledgeAnswerFaqSource struct {
	Question string `json:"question,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Question") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Question") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2KnowledgeAssistAnswerKnowledgeAnswerFaqSource) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2KnowledgeAssistAnswerKnowledgeAnswerFaqSource
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowV2KnowledgeAssistAnswerKnowledgeAnswerGenerativeSource struct {
	Snippets []*GoogleCloudDialogflowV2KnowledgeAssistAnswerKnowledgeAnswerGenerativeSourceSnippet `json:"snippets,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Snippets") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Snippets") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2KnowledgeAssistAnswerKnowledgeAnswerGenerativeSource) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2KnowledgeAssistAnswerKnowledgeAnswerGenerativeSource
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowV2KnowledgeAssistAnswerKnowledgeAnswerGenerativeSourceSnippet struct {
	Metadata googleapi.RawMessage `json:"metadata,omitempty"`
	Text     string               `json:"text,omitempty"`
	Title    string               `json:"title,omitempty"`
	Uri      string               `json:"uri,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Metadata") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Metadata") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2KnowledgeAssistAnswerKnowledgeAnswerGenerativeSourceSnippet) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2KnowledgeAssistAnswerKnowledgeAnswerGenerativeSourceSnippet
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowV2KnowledgeAssistAnswerSuggestedQuery struct {
	QueryText string `json:"queryText,omitempty"`
	// ForceSendFields is a list of field names (e.g. "QueryText") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "QueryText") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2KnowledgeAssistAnswerSuggestedQuery) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2KnowledgeAssistAnswerSuggestedQuery
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowV2KnowledgeAssistDebugInfo struct {
	// Possible values:
	//   "DATASTORE_RESPONSE_REASON_UNSPECIFIED"
	//   "NONE"
	//   "SEARCH_OUT_OF_QUOTA"
	//   "SEARCH_EMPTY_RESULTS"
	//   "ANSWER_GENERATION_GEN_AI_DISABLED"
	//   "ANSWER_GENERATION_OUT_OF_QUOTA"
	//   "ANSWER_GENERATION_ERROR"
	//   "ANSWER_GENERATION_NOT_ENOUGH_INFO"
	//   "ANSWER_GENERATION_RAI_FAILED"
	//   "ANSWER_GENERATION_NOT_GROUNDED"
	DatastoreResponseReason           string                                                                  `json:"datastoreResponseReason,omitempty"`
	IngestedContextReferenceDebugInfo *GoogleCloudDialogflowV2IngestedContextReferenceDebugInfo               `json:"ingestedContextReferenceDebugInfo,omitempty"`
	KnowledgeAssistBehavior           *GoogleCloudDialogflowV2KnowledgeAssistDebugInfoKnowledgeAssistBehavior `json:"knowledgeAssistBehavior,omitempty"`
	// Possible values:
	//   "QUERY_CATEGORIZATION_FAILURE_REASON_UNSPECIFIED"
	//   "QUERY_CATEGORIZATION_INVALID_CONFIG"
	//   "QUERY_CATEGORIZATION_RESULT_NOT_FOUND"
	//   "QUERY_CATEGORIZATION_FAILED"
	QueryCategorizationFailureReason string `json:"queryCategorizationFailureReason,omitempty"`
	// Possible values:
	//   "QUERY_GENERATION_FAILURE_REASON_UNSPECIFIED"
	//   "QUERY_GENERATION_OUT_OF_QUOTA"
	//   "QUERY_GENERATION_FAILED"
	//   "QUERY_GENERATION_NO_QUERY_GENERATED"
	//   "QUERY_GENERATION_RAI_FAILED"
	//   "NOT_IN_ALLOWLIST"
	//   "QUERY_GENERATION_QUERY_REDACTED"
	//   "QUERY_GENERATION_LLM_RESPONSE_PARSE_FAILED"
	//   "QUERY_GENERATION_EMPTY_CONVERSATION"
	//   "QUERY_GENERATION_EMPTY_LAST_MESSAGE"
	//   "QUERY_GENERATION_TRIGGERING_EVENT_CONDITION_NOT_MET"
	QueryGenerationFailureReason string                                 `json:"queryGenerationFailureReason,omitempty"`
	ServiceLatency               *GoogleCloudDialogflowV2ServiceLatency `json:"serviceLatency,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DatastoreResponseReason") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DatastoreResponseReason") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2KnowledgeAssistDebugInfo) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2KnowledgeAssistDebugInfo
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowV2KnowledgeAssistDebugInfoKnowledgeAssistBehavior struct {
	AnswerGenerationRewriterOn              bool  `json:"answerGenerationRewriterOn,omitempty"`
	AppendedSearchContextCount              int64 `json:"appendedSearchContextCount,omitempty"`
	ConversationTranscriptHasMixedLanguages bool  `json:"conversationTranscriptHasMixedLanguages,omitempty"`
	DisableSyncDelivery                     bool  `json:"disableSyncDelivery,omitempty"`
	EndUserMetadataIncluded                 bool  `json:"endUserMetadataIncluded,omitempty"`
	InvalidItemsQuerySuggestionSkipped      bool  `json:"invalidItemsQuerySuggestionSkipped,omitempty"`
	MultipleQueriesGenerated                bool  `json:"multipleQueriesGenerated,omitempty"`
	PreviousQueriesIncluded                 bool  `json:"previousQueriesIncluded,omitempty"`
	PrimaryQueryRedactedAndReplaced         bool  `json:"primaryQueryRedactedAndReplaced,omitempty"`
	QueryContainedSearchContext             bool  `json:"queryContainedSearchContext,omitempty"`
	QueryGenerationAgentLanguageMismatch    bool  `json:"queryGenerationAgentLanguageMismatch,omitempty"`
	QueryGenerationEndUserLanguageMismatch  bool  `json:"queryGenerationEndUserLanguageMismatch,omitempty"`
	ReturnQueryOnly                         bool  `json:"returnQueryOnly,omitempty"`
	ThirdPartyConnectorAllowed              bool  `json:"thirdPartyConnectorAllowed,omitempty"`
	UseCustomSafetyFilterLevel              bool  `json:"useCustomSafetyFilterLevel,omitempty"`
	UsePubsubDelivery                       bool  `json:"usePubsubDelivery,omitempty"`
	UseTranslatedMessage                    bool  `json:"useTranslatedMessage,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AnswerGenerationRewriterOn")
	// to unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AnswerGenerationRewriterOn") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2KnowledgeAssistDebugInfoKnowledgeAssistBehavior) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2KnowledgeAssistDebugInfoKnowledgeAssistBehavior
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowV2KnowledgeOperationMetadata struct {
	DoneTime                string                                          `json:"doneTime,omitempty"`
	ExportOperationMetadata *GoogleCloudDialogflowV2ExportOperationMetadata `json:"exportOperationMetadata,omitempty"`
	KnowledgeBase           string                                          `json:"knowledgeBase,omitempty"`
	// Possible values:
	//   "STATE_UNSPECIFIED"
	//   "PENDING"
	//   "RUNNING"
	//   "DONE"
	State string `json:"state,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DoneTime") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DoneTime") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2KnowledgeOperationMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2KnowledgeOperationMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowV2Message struct {
	Content           string                                    `json:"content,omitempty"`
	CreateTime        string                                    `json:"createTime,omitempty"`
	LanguageCode      string                                    `json:"languageCode,omitempty"`
	MessageAnnotation *GoogleCloudDialogflowV2MessageAnnotation `json:"messageAnnotation,omitempty"`
	Name              string                                    `json:"name,omitempty"`
	Participant       string                                    `json:"participant,omitempty"`
	// Possible values:
	//   "ROLE_UNSPECIFIED"
	//   "HUMAN_AGENT"
	//   "AUTOMATED_AGENT"
	//   "END_USER"
	ParticipantRole   string                                          `json:"participantRole,omitempty"`
	SendTime          string                                          `json:"sendTime,omitempty"`
	SentimentAnalysis *GoogleCloudDialogflowV2SentimentAnalysisResult `json:"sentimentAnalysis,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Content") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Content") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2Message) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2Message
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowV2MessageAnnotation struct {
	ContainEntities bool                                           `json:"containEntities,omitempty"`
	Parts           []*GoogleCloudDialogflowV2AnnotatedMessagePart `json:"parts,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ContainEntities") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ContainEntities") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2MessageAnnotation) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2MessageAnnotation
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowV2OriginalDetectIntentRequest struct {
	Payload googleapi.RawMessage `json:"payload,omitempty"`
	Source  string               `json:"source,omitempty"`
	Version string               `json:"version,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Payload") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Payload") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2OriginalDetectIntentRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2OriginalDetectIntentRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowV2QueryResult struct {
	Action                      string                                          `json:"action,omitempty"`
	AllRequiredParamsPresent    bool                                            `json:"allRequiredParamsPresent,omitempty"`
	CancelsSlotFilling          bool                                            `json:"cancelsSlotFilling,omitempty"`
	DiagnosticInfo              googleapi.RawMessage                            `json:"diagnosticInfo,omitempty"`
	FulfillmentMessages         []*GoogleCloudDialogflowV2IntentMessage         `json:"fulfillmentMessages,omitempty"`
	FulfillmentText             string                                          `json:"fulfillmentText,omitempty"`
	Intent                      *GoogleCloudDialogflowV2Intent                  `json:"intent,omitempty"`
	IntentDetectionConfidence   float64                                         `json:"intentDetectionConfidence,omitempty"`
	LanguageCode                string                                          `json:"languageCode,omitempty"`
	OutputContexts              []*GoogleCloudDialogflowV2Context               `json:"outputContexts,omitempty"`
	Parameters                  googleapi.RawMessage                            `json:"parameters,omitempty"`
	QueryText                   string                                          `json:"queryText,omitempty"`
	SentimentAnalysisResult     *GoogleCloudDialogflowV2SentimentAnalysisResult `json:"sentimentAnalysisResult,omitempty"`
	SpeechRecognitionConfidence float64                                         `json:"speechRecognitionConfidence,omitempty"`
	WebhookPayload              googleapi.RawMessage                            `json:"webhookPayload,omitempty"`
	WebhookSource               string                                          `json:"webhookSource,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Action") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Action") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2QueryResult) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2QueryResult
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *GoogleCloudDialogflowV2QueryResult) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleCloudDialogflowV2QueryResult
	var s1 struct {
		IntentDetectionConfidence   gensupport.JSONFloat64 `json:"intentDetectionConfidence"`
		SpeechRecognitionConfidence gensupport.JSONFloat64 `json:"speechRecognitionConfidence"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.IntentDetectionConfidence = float64(s1.IntentDetectionConfidence)
	s.SpeechRecognitionConfidence = float64(s1.SpeechRecognitionConfidence)
	return nil
}

type GoogleCloudDialogflowV2Sentiment struct {
	Magnitude float64 `json:"magnitude,omitempty"`
	Score     float64 `json:"score,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Magnitude") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Magnitude") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2Sentiment) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2Sentiment
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *GoogleCloudDialogflowV2Sentiment) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleCloudDialogflowV2Sentiment
	var s1 struct {
		Magnitude gensupport.JSONFloat64 `json:"magnitude"`
		Score     gensupport.JSONFloat64 `json:"score"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.Magnitude = float64(s1.Magnitude)
	s.Score = float64(s1.Score)
	return nil
}

type GoogleCloudDialogflowV2SentimentAnalysisResult struct {
	QueryTextSentiment *GoogleCloudDialogflowV2Sentiment `json:"queryTextSentiment,omitempty"`
	// ForceSendFields is a list of field names (e.g. "QueryTextSentiment") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "QueryTextSentiment") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2SentimentAnalysisResult) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2SentimentAnalysisResult
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowV2ServiceLatency struct {
	InternalServiceLatencies []*GoogleCloudDialogflowV2ServiceLatencyInternalServiceLatency `json:"internalServiceLatencies,omitempty"`
	// ForceSendFields is a list of field names (e.g. "InternalServiceLatencies")
	// to unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "InternalServiceLatencies") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2ServiceLatency) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2ServiceLatency
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowV2ServiceLatencyInternalServiceLatency struct {
	CompleteTime string  `json:"completeTime,omitempty"`
	LatencyMs    float64 `json:"latencyMs,omitempty"`
	StartTime    string  `json:"startTime,omitempty"`
	Step         string  `json:"step,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CompleteTime") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CompleteTime") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2ServiceLatencyInternalServiceLatency) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2ServiceLatencyInternalServiceLatency
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *GoogleCloudDialogflowV2ServiceLatencyInternalServiceLatency) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleCloudDialogflowV2ServiceLatencyInternalServiceLatency
	var s1 struct {
		LatencyMs gensupport.JSONFloat64 `json:"latencyMs"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.LatencyMs = float64(s1.LatencyMs)
	return nil
}

type GoogleCloudDialogflowV2SessionEntityType struct {
	Entities []*GoogleCloudDialogflowV2EntityTypeEntity `json:"entities,omitempty"`
	// Possible values:
	//   "ENTITY_OVERRIDE_MODE_UNSPECIFIED"
	//   "ENTITY_OVERRIDE_MODE_OVERRIDE"
	//   "ENTITY_OVERRIDE_MODE_SUPPLEMENT"
	EntityOverrideMode string `json:"entityOverrideMode,omitempty"`
	Name               string `json:"name,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Entities") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Entities") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2SessionEntityType) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2SessionEntityType
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowV2SetSuggestionFeatureConfigOperationMetadata struct {
	ConversationProfile string `json:"conversationProfile,omitempty"`
	CreateTime          string `json:"createTime,omitempty"`
	// Possible values:
	//   "ROLE_UNSPECIFIED"
	//   "HUMAN_AGENT"
	//   "AUTOMATED_AGENT"
	//   "END_USER"
	ParticipantRole string `json:"participantRole,omitempty"`
	// Possible values:
	//   "TYPE_UNSPECIFIED"
	//   "ARTICLE_SUGGESTION"
	//   "FAQ"
	//   "SMART_REPLY"
	//   "CONVERSATION_SUMMARIZATION"
	//   "KNOWLEDGE_SEARCH"
	//   "KNOWLEDGE_ASSIST"
	SuggestionFeatureType string `json:"suggestionFeatureType,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ConversationProfile") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ConversationProfile") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2SetSuggestionFeatureConfigOperationMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2SetSuggestionFeatureConfigOperationMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowV2SmartReplyAnswer struct {
	AnswerRecord string  `json:"answerRecord,omitempty"`
	Confidence   float64 `json:"confidence,omitempty"`
	Reply        string  `json:"reply,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AnswerRecord") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AnswerRecord") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2SmartReplyAnswer) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2SmartReplyAnswer
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *GoogleCloudDialogflowV2SmartReplyAnswer) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleCloudDialogflowV2SmartReplyAnswer
	var s1 struct {
		Confidence gensupport.JSONFloat64 `json:"confidence"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.Confidence = float64(s1.Confidence)
	return nil
}

type GoogleCloudDialogflowV2SmartReplyModelMetadata struct {
	// Possible values:
	//   "MODEL_TYPE_UNSPECIFIED"
	//   "SMART_REPLY_DUAL_ENCODER_MODEL"
	//   "SMART_REPLY_BERT_MODEL"
	TrainingModelType string `json:"trainingModelType,omitempty"`
	// ForceSendFields is a list of field names (e.g. "TrainingModelType") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "TrainingModelType") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2SmartReplyModelMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2SmartReplyModelMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowV2SpeechWordInfo struct {
	Confidence  float64 `json:"confidence,omitempty"`
	EndOffset   string  `json:"endOffset,omitempty"`
	StartOffset string  `json:"startOffset,omitempty"`
	Word        string  `json:"word,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Confidence") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Confidence") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2SpeechWordInfo) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2SpeechWordInfo
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *GoogleCloudDialogflowV2SpeechWordInfo) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleCloudDialogflowV2SpeechWordInfo
	var s1 struct {
		Confidence gensupport.JSONFloat64 `json:"confidence"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.Confidence = float64(s1.Confidence)
	return nil
}

type GoogleCloudDialogflowV2StreamingRecognitionResult struct {
	Confidence   float64 `json:"confidence,omitempty"`
	IsFinal      bool    `json:"isFinal,omitempty"`
	LanguageCode string  `json:"languageCode,omitempty"`
	// Possible values:
	//   "MESSAGE_TYPE_UNSPECIFIED"
	//   "TRANSCRIPT"
	//   "END_OF_SINGLE_UTTERANCE"
	MessageType     string                                   `json:"messageType,omitempty"`
	SpeechEndOffset string                                   `json:"speechEndOffset,omitempty"`
	SpeechWordInfo  []*GoogleCloudDialogflowV2SpeechWordInfo `json:"speechWordInfo,omitempty"`
	Transcript      string                                   `json:"transcript,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Confidence") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Confidence") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2StreamingRecognitionResult) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2StreamingRecognitionResult
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *GoogleCloudDialogflowV2StreamingRecognitionResult) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleCloudDialogflowV2StreamingRecognitionResult
	var s1 struct {
		Confidence gensupport.JSONFloat64 `json:"confidence"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.Confidence = float64(s1.Confidence)
	return nil
}

type GoogleCloudDialogflowV2SuggestArticlesResponse struct {
	ArticleAnswers []*GoogleCloudDialogflowV2ArticleAnswer `json:"articleAnswers,omitempty"`
	ContextSize    int64                                   `json:"contextSize,omitempty"`
	LatestMessage  string                                  `json:"latestMessage,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ArticleAnswers") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ArticleAnswers") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2SuggestArticlesResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2SuggestArticlesResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowV2SuggestFaqAnswersResponse struct {
	ContextSize   int64                               `json:"contextSize,omitempty"`
	FaqAnswers    []*GoogleCloudDialogflowV2FaqAnswer `json:"faqAnswers,omitempty"`
	LatestMessage string                              `json:"latestMessage,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ContextSize") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ContextSize") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2SuggestFaqAnswersResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2SuggestFaqAnswersResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowV2SuggestKnowledgeAssistResponse struct {
	ContextSize           int64                                         `json:"contextSize,omitempty"`
	KnowledgeAssistAnswer *GoogleCloudDialogflowV2KnowledgeAssistAnswer `json:"knowledgeAssistAnswer,omitempty"`
	LatestMessage         string                                        `json:"latestMessage,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ContextSize") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ContextSize") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2SuggestKnowledgeAssistResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2SuggestKnowledgeAssistResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowV2SuggestSmartRepliesResponse struct {
	ContextSize       int64                                      `json:"contextSize,omitempty"`
	LatestMessage     string                                     `json:"latestMessage,omitempty"`
	SmartReplyAnswers []*GoogleCloudDialogflowV2SmartReplyAnswer `json:"smartReplyAnswers,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ContextSize") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ContextSize") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2SuggestSmartRepliesResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2SuggestSmartRepliesResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowV2SuggestionResult struct {
	Error                          *GoogleRpcStatus                                       `json:"error,omitempty"`
	GenerateSuggestionsResponse    *GoogleCloudDialogflowV2GenerateSuggestionsResponse    `json:"generateSuggestionsResponse,omitempty"`
	SuggestArticlesResponse        *GoogleCloudDialogflowV2SuggestArticlesResponse        `json:"suggestArticlesResponse,omitempty"`
	SuggestFaqAnswersResponse      *GoogleCloudDialogflowV2SuggestFaqAnswersResponse      `json:"suggestFaqAnswersResponse,omitempty"`
	SuggestKnowledgeAssistResponse *GoogleCloudDialogflowV2SuggestKnowledgeAssistResponse `json:"suggestKnowledgeAssistResponse,omitempty"`
	SuggestSmartRepliesResponse    *GoogleCloudDialogflowV2SuggestSmartRepliesResponse    `json:"suggestSmartRepliesResponse,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Error") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Error") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2SuggestionResult) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2SuggestionResult
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowV2SummarySuggestion struct {
	SummarySections []*GoogleCloudDialogflowV2SummarySuggestionSummarySection `json:"summarySections,omitempty"`
	// ForceSendFields is a list of field names (e.g. "SummarySections") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "SummarySections") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2SummarySuggestion) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2SummarySuggestion
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowV2SummarySuggestionSummarySection struct {
	Section string `json:"section,omitempty"`
	Summary string `json:"summary,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Section") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Section") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2SummarySuggestionSummarySection) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2SummarySuggestionSummarySection
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowV2ToolCall struct {
	Action          string               `json:"action,omitempty"`
	AnswerRecord    string               `json:"answerRecord,omitempty"`
	CreateTime      string               `json:"createTime,omitempty"`
	InputParameters googleapi.RawMessage `json:"inputParameters,omitempty"`
	// Possible values:
	//   "STATE_UNSPECIFIED"
	//   "TRIGGERED"
	//   "NEEDS_CONFIRMATION"
	State              string `json:"state,omitempty"`
	Tool               string `json:"tool,omitempty"`
	ToolDisplayDetails string `json:"toolDisplayDetails,omitempty"`
	ToolDisplayName    string `json:"toolDisplayName,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Action") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Action") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2ToolCall) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2ToolCall
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowV2ToolCallResult struct {
	Action       string                                      `json:"action,omitempty"`
	AnswerRecord string                                      `json:"answerRecord,omitempty"`
	Content      string                                      `json:"content,omitempty"`
	CreateTime   string                                      `json:"createTime,omitempty"`
	Error        *GoogleCloudDialogflowV2ToolCallResultError `json:"error,omitempty"`
	RawContent   string                                      `json:"rawContent,omitempty"`
	Tool         string                                      `json:"tool,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Action") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Action") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2ToolCallResult) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2ToolCallResult
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowV2ToolCallResultError struct {
	Message string `json:"message,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Message") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Message") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2ToolCallResultError) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2ToolCallResultError
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowV2UndeployConversationModelOperationMetadata struct {
	ConversationModel string `json:"conversationModel,omitempty"`
	CreateTime        string `json:"createTime,omitempty"`
	DoneTime          string `json:"doneTime,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ConversationModel") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ConversationModel") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2UndeployConversationModelOperationMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2UndeployConversationModelOperationMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowV2WebhookRequest struct {
	OriginalDetectIntentRequest *GoogleCloudDialogflowV2OriginalDetectIntentRequest `json:"originalDetectIntentRequest,omitempty"`
	QueryResult                 *GoogleCloudDialogflowV2QueryResult                 `json:"queryResult,omitempty"`
	ResponseId                  string                                              `json:"responseId,omitempty"`
	Session                     string                                              `json:"session,omitempty"`
	// ForceSendFields is a list of field names (e.g.
	// "OriginalDetectIntentRequest") to unconditionally include in API requests.
	// By default, fields with empty or default values are omitted from API
	// requests. See https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields
	// for more details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "OriginalDetectIntentRequest") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2WebhookRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2WebhookRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowV2WebhookResponse struct {
	FollowupEventInput  *GoogleCloudDialogflowV2EventInput          `json:"followupEventInput,omitempty"`
	FulfillmentMessages []*GoogleCloudDialogflowV2IntentMessage     `json:"fulfillmentMessages,omitempty"`
	FulfillmentText     string                                      `json:"fulfillmentText,omitempty"`
	OutputContexts      []*GoogleCloudDialogflowV2Context           `json:"outputContexts,omitempty"`
	Payload             googleapi.RawMessage                        `json:"payload,omitempty"`
	SessionEntityTypes  []*GoogleCloudDialogflowV2SessionEntityType `json:"sessionEntityTypes,omitempty"`
	Source              string                                      `json:"source,omitempty"`
	// ForceSendFields is a list of field names (e.g. "FollowupEventInput") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "FollowupEventInput") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2WebhookResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2WebhookResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowV2beta1AgentCoachingInstruction struct {
	AgentAction          string                                                                    `json:"agentAction,omitempty"`
	Condition            string                                                                    `json:"condition,omitempty"`
	DisplayDetails       string                                                                    `json:"displayDetails,omitempty"`
	DisplayName          string                                                                    `json:"displayName,omitempty"`
	DuplicateCheckResult *GoogleCloudDialogflowV2beta1AgentCoachingInstructionDuplicateCheckResult `json:"duplicateCheckResult,omitempty"`
	SystemAction         string                                                                    `json:"systemAction,omitempty"`
	// Possible values:
	//   "TRIGGER_EVENT_UNSPECIFIED"
	//   "END_OF_UTTERANCE"
	//   "MANUAL_CALL"
	//   "CUSTOMER_MESSAGE"
	//   "AGENT_MESSAGE"
	//   "TOOL_CALL_COMPLETION"
	TriggeringEvent string `json:"triggeringEvent,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AgentAction") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AgentAction") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2beta1AgentCoachingInstruction) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2beta1AgentCoachingInstruction
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowV2beta1AgentCoachingInstructionDuplicateCheckResult struct {
	DuplicateSuggestions []*GoogleCloudDialogflowV2beta1AgentCoachingInstructionDuplicateCheckResultDuplicateSuggestion `json:"duplicateSuggestions,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DuplicateSuggestions") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DuplicateSuggestions") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2beta1AgentCoachingInstructionDuplicateCheckResult) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2beta1AgentCoachingInstructionDuplicateCheckResult
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowV2beta1AgentCoachingInstructionDuplicateCheckResultDuplicateSuggestion struct {
	AnswerRecord    string  `json:"answerRecord,omitempty"`
	SimilarityScore float64 `json:"similarityScore,omitempty"`
	SuggestionIndex int64   `json:"suggestionIndex,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AnswerRecord") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AnswerRecord") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2beta1AgentCoachingInstructionDuplicateCheckResultDuplicateSuggestion) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2beta1AgentCoachingInstructionDuplicateCheckResultDuplicateSuggestion
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *GoogleCloudDialogflowV2beta1AgentCoachingInstructionDuplicateCheckResultDuplicateSuggestion) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleCloudDialogflowV2beta1AgentCoachingInstructionDuplicateCheckResultDuplicateSuggestion
	var s1 struct {
		SimilarityScore gensupport.JSONFloat64 `json:"similarityScore"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.SimilarityScore = float64(s1.SimilarityScore)
	return nil
}

type GoogleCloudDialogflowV2beta1AgentCoachingSuggestion struct {
	AgentActionSuggestions []*GoogleCloudDialogflowV2beta1AgentCoachingSuggestionAgentActionSuggestion `json:"agentActionSuggestions,omitempty"`
	ApplicableInstructions []*GoogleCloudDialogflowV2beta1AgentCoachingInstruction                     `json:"applicableInstructions,omitempty"`
	SampleResponses        []*GoogleCloudDialogflowV2beta1AgentCoachingSuggestionSampleResponse        `json:"sampleResponses,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AgentActionSuggestions") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AgentActionSuggestions") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2beta1AgentCoachingSuggestion) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2beta1AgentCoachingSuggestion
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowV2beta1AgentCoachingSuggestionAgentActionSuggestion struct {
	AgentAction          string                                                                   `json:"agentAction,omitempty"`
	DuplicateCheckResult *GoogleCloudDialogflowV2beta1AgentCoachingSuggestionDuplicateCheckResult `json:"duplicateCheckResult,omitempty"`
	Sources              *GoogleCloudDialogflowV2beta1AgentCoachingSuggestionSources              `json:"sources,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AgentAction") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AgentAction") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2beta1AgentCoachingSuggestionAgentActionSuggestion) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2beta1AgentCoachingSuggestionAgentActionSuggestion
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowV2beta1AgentCoachingSuggestionDuplicateCheckResult struct {
	DuplicateSuggestions []*GoogleCloudDialogflowV2beta1AgentCoachingSuggestionDuplicateCheckResultDuplicateSuggestion `json:"duplicateSuggestions,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DuplicateSuggestions") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DuplicateSuggestions") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2beta1AgentCoachingSuggestionDuplicateCheckResult) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2beta1AgentCoachingSuggestionDuplicateCheckResult
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowV2beta1AgentCoachingSuggestionDuplicateCheckResultDuplicateSuggestion struct {
	AnswerRecord    string                                                      `json:"answerRecord,omitempty"`
	SimilarityScore float64                                                     `json:"similarityScore,omitempty"`
	Sources         *GoogleCloudDialogflowV2beta1AgentCoachingSuggestionSources `json:"sources,omitempty"`
	SuggestionIndex int64                                                       `json:"suggestionIndex,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AnswerRecord") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AnswerRecord") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2beta1AgentCoachingSuggestionDuplicateCheckResultDuplicateSuggestion) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2beta1AgentCoachingSuggestionDuplicateCheckResultDuplicateSuggestion
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *GoogleCloudDialogflowV2beta1AgentCoachingSuggestionDuplicateCheckResultDuplicateSuggestion) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleCloudDialogflowV2beta1AgentCoachingSuggestionDuplicateCheckResultDuplicateSuggestion
	var s1 struct {
		SimilarityScore gensupport.JSONFloat64 `json:"similarityScore"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.SimilarityScore = float64(s1.SimilarityScore)
	return nil
}

type GoogleCloudDialogflowV2beta1AgentCoachingSuggestionSampleResponse struct {
	DuplicateCheckResult *GoogleCloudDialogflowV2beta1AgentCoachingSuggestionDuplicateCheckResult `json:"duplicateCheckResult,omitempty"`
	ResponseText         string                                                                   `json:"responseText,omitempty"`
	Sources              *GoogleCloudDialogflowV2beta1AgentCoachingSuggestionSources              `json:"sources,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DuplicateCheckResult") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DuplicateCheckResult") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2beta1AgentCoachingSuggestionSampleResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2beta1AgentCoachingSuggestionSampleResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowV2beta1AgentCoachingSuggestionSources struct {
	InstructionIndexes []int64 `json:"instructionIndexes,omitempty"`
	// ForceSendFields is a list of field names (e.g. "InstructionIndexes") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "InstructionIndexes") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2beta1AgentCoachingSuggestionSources) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2beta1AgentCoachingSuggestionSources
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowV2beta1AnnotatedMessagePart struct {
	EntityType     string      `json:"entityType,omitempty"`
	FormattedValue interface{} `json:"formattedValue,omitempty"`
	Text           string      `json:"text,omitempty"`
	// ForceSendFields is a list of field names (e.g. "EntityType") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "EntityType") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2beta1AnnotatedMessagePart) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2beta1AnnotatedMessagePart
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowV2beta1ArticleAnswer struct {
	AnswerRecord string            `json:"answerRecord,omitempty"`
	Metadata     map[string]string `json:"metadata,omitempty"`
	Snippets     []string          `json:"snippets,omitempty"`
	Title        string            `json:"title,omitempty"`
	Uri          string            `json:"uri,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AnswerRecord") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AnswerRecord") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2beta1ArticleAnswer) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2beta1ArticleAnswer
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowV2beta1BatchUpdateEntityTypesResponse struct {
	EntityTypes []*GoogleCloudDialogflowV2beta1EntityType `json:"entityTypes,omitempty"`
	// ForceSendFields is a list of field names (e.g. "EntityTypes") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "EntityTypes") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2beta1BatchUpdateEntityTypesResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2beta1BatchUpdateEntityTypesResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowV2beta1BatchUpdateIntentsResponse struct {
	Intents []*GoogleCloudDialogflowV2beta1Intent `json:"intents,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Intents") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Intents") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2beta1BatchUpdateIntentsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2beta1BatchUpdateIntentsResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowV2beta1ClearSuggestionFeatureConfigOperationMetadata struct {
	ConversationProfile string `json:"conversationProfile,omitempty"`
	CreateTime          string `json:"createTime,omitempty"`
	// Possible values:
	//   "ROLE_UNSPECIFIED"
	//   "HUMAN_AGENT"
	//   "AUTOMATED_AGENT"
	//   "END_USER"
	ParticipantRole string `json:"participantRole,omitempty"`
	// Possible values:
	//   "TYPE_UNSPECIFIED"
	//   "ARTICLE_SUGGESTION"
	//   "FAQ"
	//   "SMART_REPLY"
	//   "DIALOGFLOW_ASSIST"
	//   "CONVERSATION_SUMMARIZATION"
	//   "KNOWLEDGE_SEARCH"
	//   "KNOWLEDGE_ASSIST"
	SuggestionFeatureType string `json:"suggestionFeatureType,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ConversationProfile") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ConversationProfile") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2beta1ClearSuggestionFeatureConfigOperationMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2beta1ClearSuggestionFeatureConfigOperationMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowV2beta1Context struct {
	LifespanCount int64                `json:"lifespanCount,omitempty"`
	Name          string               `json:"name,omitempty"`
	Parameters    googleapi.RawMessage `json:"parameters,omitempty"`
	// ForceSendFields is a list of field names (e.g. "LifespanCount") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "LifespanCount") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2beta1Context) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2beta1Context
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowV2beta1ConversationEvent struct {
	Conversation                string                                                  `json:"conversation,omitempty"`
	ErrorStatus                 *GoogleRpcStatus                                        `json:"errorStatus,omitempty"`
	NewMessagePayload           *GoogleCloudDialogflowV2beta1Message                    `json:"newMessagePayload,omitempty"`
	NewRecognitionResultPayload *GoogleCloudDialogflowV2beta1StreamingRecognitionResult `json:"newRecognitionResultPayload,omitempty"`
	// Possible values:
	//   "TYPE_UNSPECIFIED"
	//   "CONVERSATION_STARTED"
	//   "CONVERSATION_FINISHED"
	//   "HUMAN_INTERVENTION_NEEDED"
	//   "NEW_MESSAGE"
	//   "NEW_RECOGNITION_RESULT"
	//   "UNRECOVERABLE_ERROR"
	Type string `json:"type,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Conversation") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Conversation") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2beta1ConversationEvent) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2beta1ConversationEvent
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowV2beta1DialogflowAssistAnswer struct {
	AnswerRecord     string                                        `json:"answerRecord,omitempty"`
	IntentSuggestion *GoogleCloudDialogflowV2beta1IntentSuggestion `json:"intentSuggestion,omitempty"`
	QueryResult      *GoogleCloudDialogflowV2beta1QueryResult      `json:"queryResult,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AnswerRecord") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AnswerRecord") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2beta1DialogflowAssistAnswer) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2beta1DialogflowAssistAnswer
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowV2beta1EncryptionSpec struct {
	KmsKey string `json:"kmsKey,omitempty"`
	Name   string `json:"name,omitempty"`
	// ForceSendFields is a list of field names (e.g. "KmsKey") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "KmsKey") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2beta1EncryptionSpec) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2beta1EncryptionSpec
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowV2beta1EntityType struct {
	// Possible values:
	//   "AUTO_EXPANSION_MODE_UNSPECIFIED"
	//   "AUTO_EXPANSION_MODE_DEFAULT"
	AutoExpansionMode     string                                          `json:"autoExpansionMode,omitempty"`
	DisplayName           string                                          `json:"displayName,omitempty"`
	EnableFuzzyExtraction bool                                            `json:"enableFuzzyExtraction,omitempty"`
	Entities              []*GoogleCloudDialogflowV2beta1EntityTypeEntity `json:"entities,omitempty"`
	// Possible values:
	//   "KIND_UNSPECIFIED"
	//   "KIND_MAP"
	//   "KIND_LIST"
	//   "KIND_REGEXP"
	Kind string `json:"kind,omitempty"`
	Name string `json:"name,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AutoExpansionMode") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AutoExpansionMode") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2beta1EntityType) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2beta1EntityType
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowV2beta1EntityTypeEntity struct {
	Synonyms []string `json:"synonyms,omitempty"`
	Value    string   `json:"value,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Synonyms") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Synonyms") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2beta1EntityTypeEntity) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2beta1EntityTypeEntity
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowV2beta1EventInput struct {
	LanguageCode string               `json:"languageCode,omitempty"`
	Name         string               `json:"name,omitempty"`
	Parameters   googleapi.RawMessage `json:"parameters,omitempty"`
	// ForceSendFields is a list of field names (e.g. "LanguageCode") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "LanguageCode") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2beta1EventInput) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2beta1EventInput
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowV2beta1ExportAgentResponse struct {
	AgentContent string `json:"agentContent,omitempty"`
	AgentUri     string `json:"agentUri,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AgentContent") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AgentContent") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2beta1ExportAgentResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2beta1ExportAgentResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowV2beta1ExportOperationMetadata struct {
	ExportedGcsDestination *GoogleCloudDialogflowV2beta1GcsDestination `json:"exportedGcsDestination,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ExportedGcsDestination") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ExportedGcsDestination") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2beta1ExportOperationMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2beta1ExportOperationMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowV2beta1FaqAnswer struct {
	Answer       string            `json:"answer,omitempty"`
	AnswerRecord string            `json:"answerRecord,omitempty"`
	Confidence   float64           `json:"confidence,omitempty"`
	Metadata     map[string]string `json:"metadata,omitempty"`
	Question     string            `json:"question,omitempty"`
	Source       string            `json:"source,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Answer") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Answer") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2beta1FaqAnswer) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2beta1FaqAnswer
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *GoogleCloudDialogflowV2beta1FaqAnswer) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleCloudDialogflowV2beta1FaqAnswer
	var s1 struct {
		Confidence gensupport.JSONFloat64 `json:"confidence"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.Confidence = float64(s1.Confidence)
	return nil
}

type GoogleCloudDialogflowV2beta1FreeFormSuggestion struct {
	Response string `json:"response,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Response") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Response") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2beta1FreeFormSuggestion) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2beta1FreeFormSuggestion
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowV2beta1GcsDestination struct {
	Uri string `json:"uri,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Uri") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Uri") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2beta1GcsDestination) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2beta1GcsDestination
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowV2beta1GenerateSuggestionsResponse struct {
	GeneratorSuggestionAnswers []*GoogleCloudDialogflowV2beta1GenerateSuggestionsResponseGeneratorSuggestionAnswer `json:"generatorSuggestionAnswers,omitempty"`
	LatestMessage              string                                                                              `json:"latestMessage,omitempty"`
	// ForceSendFields is a list of field names (e.g. "GeneratorSuggestionAnswers")
	// to unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "GeneratorSuggestionAnswers") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2beta1GenerateSuggestionsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2beta1GenerateSuggestionsResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowV2beta1GenerateSuggestionsResponseGeneratorSuggestionAnswer struct {
	AnswerRecord        string                                           `json:"answerRecord,omitempty"`
	GeneratorSuggestion *GoogleCloudDialogflowV2beta1GeneratorSuggestion `json:"generatorSuggestion,omitempty"`
	SourceGenerator     string                                           `json:"sourceGenerator,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AnswerRecord") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AnswerRecord") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2beta1GenerateSuggestionsResponseGeneratorSuggestionAnswer) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2beta1GenerateSuggestionsResponseGeneratorSuggestionAnswer
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowV2beta1GeneratorSuggestion struct {
	AgentCoachingSuggestion *GoogleCloudDialogflowV2beta1AgentCoachingSuggestion           `json:"agentCoachingSuggestion,omitempty"`
	FreeFormSuggestion      *GoogleCloudDialogflowV2beta1FreeFormSuggestion                `json:"freeFormSuggestion,omitempty"`
	SummarySuggestion       *GoogleCloudDialogflowV2beta1SummarySuggestion                 `json:"summarySuggestion,omitempty"`
	ToolCallInfo            []*GoogleCloudDialogflowV2beta1GeneratorSuggestionToolCallInfo `json:"toolCallInfo,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AgentCoachingSuggestion") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AgentCoachingSuggestion") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2beta1GeneratorSuggestion) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2beta1GeneratorSuggestion
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowV2beta1GeneratorSuggestionToolCallInfo struct {
	ToolCall       *GoogleCloudDialogflowV2beta1ToolCall       `json:"toolCall,omitempty"`
	ToolCallResult *GoogleCloudDialogflowV2beta1ToolCallResult `json:"toolCallResult,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ToolCall") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ToolCall") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2beta1GeneratorSuggestionToolCallInfo) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2beta1GeneratorSuggestionToolCallInfo
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowV2beta1HumanAgentAssistantEvent struct {
	Conversation      string                                          `json:"conversation,omitempty"`
	Participant       string                                          `json:"participant,omitempty"`
	SuggestionResults []*GoogleCloudDialogflowV2beta1SuggestionResult `json:"suggestionResults,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Conversation") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Conversation") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2beta1HumanAgentAssistantEvent) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2beta1HumanAgentAssistantEvent
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowV2beta1ImportDocumentsResponse struct {
	Warnings []*GoogleRpcStatus `json:"warnings,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Warnings") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Warnings") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2beta1ImportDocumentsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2beta1ImportDocumentsResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowV2beta1IngestedContextReferenceDebugInfo struct {
	ContextReferenceRetrieved   bool                                                                                       `json:"contextReferenceRetrieved,omitempty"`
	IngestedParametersDebugInfo []*GoogleCloudDialogflowV2beta1IngestedContextReferenceDebugInfoIngestedParameterDebugInfo `json:"ingestedParametersDebugInfo,omitempty"`
	ProjectNotAllowlisted       bool                                                                                       `json:"projectNotAllowlisted,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ContextReferenceRetrieved")
	// to unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ContextReferenceRetrieved") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2beta1IngestedContextReferenceDebugInfo) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2beta1IngestedContextReferenceDebugInfo
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowV2beta1IngestedContextReferenceDebugInfoIngestedParameterDebugInfo struct {
	// Possible values:
	//   "INGESTION_STATUS_UNSPECIFIED"
	//   "INGESTION_STATUS_SUCCEEDED"
	//   "INGESTION_STATUS_CONTEXT_NOT_AVAILABLE"
	//   "INGESTION_STATUS_PARSE_FAILED"
	//   "INGESTION_STATUS_INVALID_ENTRY"
	//   "INGESTION_STATUS_INVALID_FORMAT"
	//   "INGESTION_STATUS_LANGUAGE_MISMATCH"
	IngestionStatus string `json:"ingestionStatus,omitempty"`
	Parameter       string `json:"parameter,omitempty"`
	// ForceSendFields is a list of field names (e.g. "IngestionStatus") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "IngestionStatus") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2beta1IngestedContextReferenceDebugInfoIngestedParameterDebugInfo) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2beta1IngestedContextReferenceDebugInfoIngestedParameterDebugInfo
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowV2beta1InitializeEncryptionSpecMetadata struct {
	Request *GoogleCloudDialogflowV2beta1InitializeEncryptionSpecRequest `json:"request,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Request") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Request") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2beta1InitializeEncryptionSpecMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2beta1InitializeEncryptionSpecMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowV2beta1InitializeEncryptionSpecRequest struct {
	EncryptionSpec *GoogleCloudDialogflowV2beta1EncryptionSpec `json:"encryptionSpec,omitempty"`
	// ForceSendFields is a list of field names (e.g. "EncryptionSpec") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "EncryptionSpec") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2beta1InitializeEncryptionSpecRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2beta1InitializeEncryptionSpecRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowV2beta1Intent struct {
	Action string `json:"action,omitempty"`
	// Possible values:
	//   "PLATFORM_UNSPECIFIED"
	//   "FACEBOOK"
	//   "SLACK"
	//   "TELEGRAM"
	//   "KIK"
	//   "SKYPE"
	//   "LINE"
	//   "VIBER"
	//   "ACTIONS_ON_GOOGLE"
	//   "TELEPHONY"
	//   "GOOGLE_HANGOUTS"
	DefaultResponsePlatforms []string                                                `json:"defaultResponsePlatforms,omitempty"`
	DisplayName              string                                                  `json:"displayName,omitempty"`
	EndInteraction           bool                                                    `json:"endInteraction,omitempty"`
	Events                   []string                                                `json:"events,omitempty"`
	FollowupIntentInfo       []*GoogleCloudDialogflowV2beta1IntentFollowupIntentInfo `json:"followupIntentInfo,omitempty"`
	InputContextNames        []string                                                `json:"inputContextNames,omitempty"`
	IsFallback               bool                                                    `json:"isFallback,omitempty"`
	LiveAgentHandoff         bool                                                    `json:"liveAgentHandoff,omitempty"`
	Messages                 []*GoogleCloudDialogflowV2beta1IntentMessage            `json:"messages,omitempty"`
	MlDisabled               bool                                                    `json:"mlDisabled,omitempty"`
	MlEnabled                bool                                                    `json:"mlEnabled,omitempty"`
	Name                     string                                                  `json:"name,omitempty"`
	OutputContexts           []*GoogleCloudDialogflowV2beta1Context                  `json:"outputContexts,omitempty"`
	Parameters               []*GoogleCloudDialogflowV2beta1IntentParameter          `json:"parameters,omitempty"`
	ParentFollowupIntentName string                                                  `json:"parentFollowupIntentName,omitempty"`
	Priority                 int64                                                   `json:"priority,omitempty"`
	ResetContexts            bool                                                    `json:"resetContexts,omitempty"`
	RootFollowupIntentName   string                                                  `json:"rootFollowupIntentName,omitempty"`
	TrainingPhrases          []*GoogleCloudDialogflowV2beta1IntentTrainingPhrase     `json:"trainingPhrases,omitempty"`
	// Possible values:
	//   "WEBHOOK_STATE_UNSPECIFIED"
	//   "WEBHOOK_STATE_ENABLED"
	//   "WEBHOOK_STATE_ENABLED_FOR_SLOT_FILLING"
	WebhookState string `json:"webhookState,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Action") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Action") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2beta1Intent) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2beta1Intent
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowV2beta1IntentFollowupIntentInfo struct {
	FollowupIntentName       string `json:"followupIntentName,omitempty"`
	ParentFollowupIntentName string `json:"parentFollowupIntentName,omitempty"`
	// ForceSendFields is a list of field names (e.g. "FollowupIntentName") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "FollowupIntentName") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2beta1IntentFollowupIntentInfo) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2beta1IntentFollowupIntentInfo
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowV2beta1IntentMessage struct {
	BasicCard          *GoogleCloudDialogflowV2beta1IntentMessageBasicCard          `json:"basicCard,omitempty"`
	BrowseCarouselCard *GoogleCloudDialogflowV2beta1IntentMessageBrowseCarouselCard `json:"browseCarouselCard,omitempty"`
	Card               *GoogleCloudDialogflowV2beta1IntentMessageCard               `json:"card,omitempty"`
	CarouselSelect     *GoogleCloudDialogflowV2beta1IntentMessageCarouselSelect     `json:"carouselSelect,omitempty"`
	Image              *GoogleCloudDialogflowV2beta1IntentMessageImage              `json:"image,omitempty"`
	LinkOutSuggestion  *GoogleCloudDialogflowV2beta1IntentMessageLinkOutSuggestion  `json:"linkOutSuggestion,omitempty"`
	ListSelect         *GoogleCloudDialogflowV2beta1IntentMessageListSelect         `json:"listSelect,omitempty"`
	MediaContent       *GoogleCloudDialogflowV2beta1IntentMessageMediaContent       `json:"mediaContent,omitempty"`
	Payload            googleapi.RawMessage                                         `json:"payload,omitempty"`
	// Possible values:
	//   "PLATFORM_UNSPECIFIED"
	//   "FACEBOOK"
	//   "SLACK"
	//   "TELEGRAM"
	//   "KIK"
	//   "SKYPE"
	//   "LINE"
	//   "VIBER"
	//   "ACTIONS_ON_GOOGLE"
	//   "TELEPHONY"
	//   "GOOGLE_HANGOUTS"
	Platform                  string                                                              `json:"platform,omitempty"`
	QuickReplies              *GoogleCloudDialogflowV2beta1IntentMessageQuickReplies              `json:"quickReplies,omitempty"`
	RbmCarouselRichCard       *GoogleCloudDialogflowV2beta1IntentMessageRbmCarouselCard           `json:"rbmCarouselRichCard,omitempty"`
	RbmStandaloneRichCard     *GoogleCloudDialogflowV2beta1IntentMessageRbmStandaloneCard         `json:"rbmStandaloneRichCard,omitempty"`
	RbmText                   *GoogleCloudDialogflowV2beta1IntentMessageRbmText                   `json:"rbmText,omitempty"`
	SimpleResponses           *GoogleCloudDialogflowV2beta1IntentMessageSimpleResponses           `json:"simpleResponses,omitempty"`
	Suggestions               *GoogleCloudDialogflowV2beta1IntentMessageSuggestions               `json:"suggestions,omitempty"`
	TableCard                 *GoogleCloudDialogflowV2beta1IntentMessageTableCard                 `json:"tableCard,omitempty"`
	TelephonyPlayAudio        *GoogleCloudDialogflowV2beta1IntentMessageTelephonyPlayAudio        `json:"telephonyPlayAudio,omitempty"`
	TelephonySynthesizeSpeech *GoogleCloudDialogflowV2beta1IntentMessageTelephonySynthesizeSpeech `json:"telephonySynthesizeSpeech,omitempty"`
	TelephonyTransferCall     *GoogleCloudDialogflowV2beta1IntentMessageTelephonyTransferCall     `json:"telephonyTransferCall,omitempty"`
	Text                      *GoogleCloudDialogflowV2beta1IntentMessageText                      `json:"text,omitempty"`
	// ForceSendFields is a list of field names (e.g. "BasicCard") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "BasicCard") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2beta1IntentMessage) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2beta1IntentMessage
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowV2beta1IntentMessageBasicCard struct {
	Buttons       []*GoogleCloudDialogflowV2beta1IntentMessageBasicCardButton `json:"buttons,omitempty"`
	FormattedText string                                                      `json:"formattedText,omitempty"`
	Image         *GoogleCloudDialogflowV2beta1IntentMessageImage             `json:"image,omitempty"`
	Subtitle      string                                                      `json:"subtitle,omitempty"`
	Title         string                                                      `json:"title,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Buttons") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Buttons") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2beta1IntentMessageBasicCard) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2beta1IntentMessageBasicCard
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowV2beta1IntentMessageBasicCardButton struct {
	OpenUriAction *GoogleCloudDialogflowV2beta1IntentMessageBasicCardButtonOpenUriAction `json:"openUriAction,omitempty"`
	Title         string                                                                 `json:"title,omitempty"`
	// ForceSendFields is a list of field names (e.g. "OpenUriAction") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "OpenUriAction") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2beta1IntentMessageBasicCardButton) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2beta1IntentMessageBasicCardButton
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowV2beta1IntentMessageBasicCardButtonOpenUriAction struct {
	Uri string `json:"uri,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Uri") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Uri") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2beta1IntentMessageBasicCardButtonOpenUriAction) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2beta1IntentMessageBasicCardButtonOpenUriAction
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowV2beta1IntentMessageBrowseCarouselCard struct {
	// Possible values:
	//   "IMAGE_DISPLAY_OPTIONS_UNSPECIFIED"
	//   "GRAY"
	//   "WHITE"
	//   "CROPPED"
	//   "BLURRED_BACKGROUND"
	ImageDisplayOptions string                                                                               `json:"imageDisplayOptions,omitempty"`
	Items               []*GoogleCloudDialogflowV2beta1IntentMessageBrowseCarouselCardBrowseCarouselCardItem `json:"items,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ImageDisplayOptions") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ImageDisplayOptions") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2beta1IntentMessageBrowseCarouselCard) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2beta1IntentMessageBrowseCarouselCard
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowV2beta1IntentMessageBrowseCarouselCardBrowseCarouselCardItem struct {
	Description   string                                                                                          `json:"description,omitempty"`
	Footer        string                                                                                          `json:"footer,omitempty"`
	Image         *GoogleCloudDialogflowV2beta1IntentMessageImage                                                 `json:"image,omitempty"`
	OpenUriAction *GoogleCloudDialogflowV2beta1IntentMessageBrowseCarouselCardBrowseCarouselCardItemOpenUrlAction `json:"openUriAction,omitempty"`
	Title         string                                                                                          `json:"title,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Description") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Description") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2beta1IntentMessageBrowseCarouselCardBrowseCarouselCardItem) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2beta1IntentMessageBrowseCarouselCardBrowseCarouselCardItem
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowV2beta1IntentMessageBrowseCarouselCardBrowseCarouselCardItemOpenUrlAction struct {
	Url string `json:"url,omitempty"`
	// Possible values:
	//   "URL_TYPE_HINT_UNSPECIFIED"
	//   "AMP_ACTION"
	//   "AMP_CONTENT"
	UrlTypeHint string `json:"urlTypeHint,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Url") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Url") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2beta1IntentMessageBrowseCarouselCardBrowseCarouselCardItemOpenUrlAction) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2beta1IntentMessageBrowseCarouselCardBrowseCarouselCardItemOpenUrlAction
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowV2beta1IntentMessageCard struct {
	Buttons  []*GoogleCloudDialogflowV2beta1IntentMessageCardButton `json:"buttons,omitempty"`
	ImageUri string                                                 `json:"imageUri,omitempty"`
	Subtitle string                                                 `json:"subtitle,omitempty"`
	Title    string                                                 `json:"title,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Buttons") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Buttons") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2beta1IntentMessageCard) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2beta1IntentMessageCard
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowV2beta1IntentMessageCardButton struct {
	Postback string `json:"postback,omitempty"`
	Text     string `json:"text,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Postback") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Postback") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2beta1IntentMessageCardButton) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2beta1IntentMessageCardButton
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowV2beta1IntentMessageCarouselSelect struct {
	Items []*GoogleCloudDialogflowV2beta1IntentMessageCarouselSelectItem `json:"items,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Items") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Items") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2beta1IntentMessageCarouselSelect) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2beta1IntentMessageCarouselSelect
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowV2beta1IntentMessageCarouselSelectItem struct {
	Description string                                                   `json:"description,omitempty"`
	Image       *GoogleCloudDialogflowV2beta1IntentMessageImage          `json:"image,omitempty"`
	Info        *GoogleCloudDialogflowV2beta1IntentMessageSelectItemInfo `json:"info,omitempty"`
	Title       string                                                   `json:"title,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Description") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Description") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2beta1IntentMessageCarouselSelectItem) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2beta1IntentMessageCarouselSelectItem
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowV2beta1IntentMessageColumnProperties struct {
	Header string `json:"header,omitempty"`
	// Possible values:
	//   "HORIZONTAL_ALIGNMENT_UNSPECIFIED"
	//   "LEADING"
	//   "CENTER"
	//   "TRAILING"
	HorizontalAlignment string `json:"horizontalAlignment,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Header") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Header") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2beta1IntentMessageColumnProperties) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2beta1IntentMessageColumnProperties
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowV2beta1IntentMessageImage struct {
	AccessibilityText string `json:"accessibilityText,omitempty"`
	ImageUri          string `json:"imageUri,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AccessibilityText") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AccessibilityText") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2beta1IntentMessageImage) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2beta1IntentMessageImage
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowV2beta1IntentMessageLinkOutSuggestion struct {
	DestinationName string `json:"destinationName,omitempty"`
	Uri             string `json:"uri,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DestinationName") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DestinationName") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2beta1IntentMessageLinkOutSuggestion) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2beta1IntentMessageLinkOutSuggestion
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowV2beta1IntentMessageListSelect struct {
	Items    []*GoogleCloudDialogflowV2beta1IntentMessageListSelectItem `json:"items,omitempty"`
	Subtitle string                                                     `json:"subtitle,omitempty"`
	Title    string                                                     `json:"title,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Items") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Items") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2beta1IntentMessageListSelect) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2beta1IntentMessageListSelect
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowV2beta1IntentMessageListSelectItem struct {
	Description string                                                   `json:"description,omitempty"`
	Image       *GoogleCloudDialogflowV2beta1IntentMessageImage          `json:"image,omitempty"`
	Info        *GoogleCloudDialogflowV2beta1IntentMessageSelectItemInfo `json:"info,omitempty"`
	Title       string                                                   `json:"title,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Description") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Description") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2beta1IntentMessageListSelectItem) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2beta1IntentMessageListSelectItem
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowV2beta1IntentMessageMediaContent struct {
	MediaObjects []*GoogleCloudDialogflowV2beta1IntentMessageMediaContentResponseMediaObject `json:"mediaObjects,omitempty"`
	// Possible values:
	//   "RESPONSE_MEDIA_TYPE_UNSPECIFIED"
	//   "AUDIO"
	MediaType string `json:"mediaType,omitempty"`
	// ForceSendFields is a list of field names (e.g. "MediaObjects") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "MediaObjects") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2beta1IntentMessageMediaContent) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2beta1IntentMessageMediaContent
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowV2beta1IntentMessageMediaContentResponseMediaObject struct {
	ContentUrl  string                                          `json:"contentUrl,omitempty"`
	Description string                                          `json:"description,omitempty"`
	Icon        *GoogleCloudDialogflowV2beta1IntentMessageImage `json:"icon,omitempty"`
	LargeImage  *GoogleCloudDialogflowV2beta1IntentMessageImage `json:"largeImage,omitempty"`
	Name        string                                          `json:"name,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ContentUrl") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ContentUrl") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2beta1IntentMessageMediaContentResponseMediaObject) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2beta1IntentMessageMediaContentResponseMediaObject
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowV2beta1IntentMessageQuickReplies struct {
	QuickReplies []string `json:"quickReplies,omitempty"`
	Title        string   `json:"title,omitempty"`
	// ForceSendFields is a list of field names (e.g. "QuickReplies") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "QuickReplies") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2beta1IntentMessageQuickReplies) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2beta1IntentMessageQuickReplies
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowV2beta1IntentMessageRbmCardContent struct {
	Description string                                                           `json:"description,omitempty"`
	Media       *GoogleCloudDialogflowV2beta1IntentMessageRbmCardContentRbmMedia `json:"media,omitempty"`
	Suggestions []*GoogleCloudDialogflowV2beta1IntentMessageRbmSuggestion        `json:"suggestions,omitempty"`
	Title       string                                                           `json:"title,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Description") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Description") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2beta1IntentMessageRbmCardContent) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2beta1IntentMessageRbmCardContent
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowV2beta1IntentMessageRbmCardContentRbmMedia struct {
	FileUri string `json:"fileUri,omitempty"`
	// Possible values:
	//   "HEIGHT_UNSPECIFIED"
	//   "SHORT"
	//   "MEDIUM"
	//   "TALL"
	Height       string `json:"height,omitempty"`
	ThumbnailUri string `json:"thumbnailUri,omitempty"`
	// ForceSendFields is a list of field names (e.g. "FileUri") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "FileUri") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2beta1IntentMessageRbmCardContentRbmMedia) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2beta1IntentMessageRbmCardContentRbmMedia
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowV2beta1IntentMessageRbmCarouselCard struct {
	CardContents []*GoogleCloudDialogflowV2beta1IntentMessageRbmCardContent `json:"cardContents,omitempty"`
	// Possible values:
	//   "CARD_WIDTH_UNSPECIFIED"
	//   "SMALL"
	//   "MEDIUM"
	CardWidth string `json:"cardWidth,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CardContents") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CardContents") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2beta1IntentMessageRbmCarouselCard) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2beta1IntentMessageRbmCarouselCard
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowV2beta1IntentMessageRbmStandaloneCard struct {
	CardContent *GoogleCloudDialogflowV2beta1IntentMessageRbmCardContent `json:"cardContent,omitempty"`
	// Possible values:
	//   "CARD_ORIENTATION_UNSPECIFIED"
	//   "HORIZONTAL"
	//   "VERTICAL"
	CardOrientation string `json:"cardOrientation,omitempty"`
	// Possible values:
	//   "THUMBNAIL_IMAGE_ALIGNMENT_UNSPECIFIED"
	//   "LEFT"
	//   "RIGHT"
	ThumbnailImageAlignment string `json:"thumbnailImageAlignment,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CardContent") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CardContent") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2beta1IntentMessageRbmStandaloneCard) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2beta1IntentMessageRbmStandaloneCard
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowV2beta1IntentMessageRbmSuggestedAction struct {
	Dial          *GoogleCloudDialogflowV2beta1IntentMessageRbmSuggestedActionRbmSuggestedActionDial          `json:"dial,omitempty"`
	OpenUrl       *GoogleCloudDialogflowV2beta1IntentMessageRbmSuggestedActionRbmSuggestedActionOpenUri       `json:"openUrl,omitempty"`
	PostbackData  string                                                                                      `json:"postbackData,omitempty"`
	ShareLocation *GoogleCloudDialogflowV2beta1IntentMessageRbmSuggestedActionRbmSuggestedActionShareLocation `json:"shareLocation,omitempty"`
	Text          string                                                                                      `json:"text,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Dial") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Dial") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2beta1IntentMessageRbmSuggestedAction) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2beta1IntentMessageRbmSuggestedAction
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowV2beta1IntentMessageRbmSuggestedActionRbmSuggestedActionDial struct {
	PhoneNumber string `json:"phoneNumber,omitempty"`
	// ForceSendFields is a list of field names (e.g. "PhoneNumber") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "PhoneNumber") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2beta1IntentMessageRbmSuggestedActionRbmSuggestedActionDial) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2beta1IntentMessageRbmSuggestedActionRbmSuggestedActionDial
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowV2beta1IntentMessageRbmSuggestedActionRbmSuggestedActionOpenUri struct {
	Uri string `json:"uri,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Uri") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Uri") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2beta1IntentMessageRbmSuggestedActionRbmSuggestedActionOpenUri) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2beta1IntentMessageRbmSuggestedActionRbmSuggestedActionOpenUri
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowV2beta1IntentMessageRbmSuggestedActionRbmSuggestedActionShareLocation struct {
}

type GoogleCloudDialogflowV2beta1IntentMessageRbmSuggestedReply struct {
	PostbackData string `json:"postbackData,omitempty"`
	Text         string `json:"text,omitempty"`
	// ForceSendFields is a list of field names (e.g. "PostbackData") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "PostbackData") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2beta1IntentMessageRbmSuggestedReply) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2beta1IntentMessageRbmSuggestedReply
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowV2beta1IntentMessageRbmSuggestion struct {
	Action *GoogleCloudDialogflowV2beta1IntentMessageRbmSuggestedAction `json:"action,omitempty"`
	Reply  *GoogleCloudDialogflowV2beta1IntentMessageRbmSuggestedReply  `json:"reply,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Action") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Action") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2beta1IntentMessageRbmSuggestion) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2beta1IntentMessageRbmSuggestion
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowV2beta1IntentMessageRbmText struct {
	RbmSuggestion []*GoogleCloudDialogflowV2beta1IntentMessageRbmSuggestion `json:"rbmSuggestion,omitempty"`
	Text          string                                                    `json:"text,omitempty"`
	// ForceSendFields is a list of field names (e.g. "RbmSuggestion") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "RbmSuggestion") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2beta1IntentMessageRbmText) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2beta1IntentMessageRbmText
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowV2beta1IntentMessageSelectItemInfo struct {
	Key      string   `json:"key,omitempty"`
	Synonyms []string `json:"synonyms,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Key") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Key") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2beta1IntentMessageSelectItemInfo) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2beta1IntentMessageSelectItemInfo
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowV2beta1IntentMessageSimpleResponse struct {
	DisplayText  string `json:"displayText,omitempty"`
	Ssml         string `json:"ssml,omitempty"`
	TextToSpeech string `json:"textToSpeech,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DisplayText") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DisplayText") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2beta1IntentMessageSimpleResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2beta1IntentMessageSimpleResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowV2beta1IntentMessageSimpleResponses struct {
	SimpleResponses []*GoogleCloudDialogflowV2beta1IntentMessageSimpleResponse `json:"simpleResponses,omitempty"`
	// ForceSendFields is a list of field names (e.g. "SimpleResponses") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "SimpleResponses") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2beta1IntentMessageSimpleResponses) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2beta1IntentMessageSimpleResponses
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowV2beta1IntentMessageSuggestion struct {
	Title string `json:"title,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Title") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Title") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2beta1IntentMessageSuggestion) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2beta1IntentMessageSuggestion
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowV2beta1IntentMessageSuggestions struct {
	Suggestions []*GoogleCloudDialogflowV2beta1IntentMessageSuggestion `json:"suggestions,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Suggestions") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Suggestions") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2beta1IntentMessageSuggestions) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2beta1IntentMessageSuggestions
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowV2beta1IntentMessageTableCard struct {
	Buttons          []*GoogleCloudDialogflowV2beta1IntentMessageBasicCardButton  `json:"buttons,omitempty"`
	ColumnProperties []*GoogleCloudDialogflowV2beta1IntentMessageColumnProperties `json:"columnProperties,omitempty"`
	Image            *GoogleCloudDialogflowV2beta1IntentMessageImage              `json:"image,omitempty"`
	Rows             []*GoogleCloudDialogflowV2beta1IntentMessageTableCardRow     `json:"rows,omitempty"`
	Subtitle         string                                                       `json:"subtitle,omitempty"`
	Title            string                                                       `json:"title,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Buttons") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Buttons") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2beta1IntentMessageTableCard) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2beta1IntentMessageTableCard
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowV2beta1IntentMessageTableCardCell struct {
	Text string `json:"text,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Text") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Text") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2beta1IntentMessageTableCardCell) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2beta1IntentMessageTableCardCell
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowV2beta1IntentMessageTableCardRow struct {
	Cells        []*GoogleCloudDialogflowV2beta1IntentMessageTableCardCell `json:"cells,omitempty"`
	DividerAfter bool                                                      `json:"dividerAfter,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Cells") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Cells") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2beta1IntentMessageTableCardRow) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2beta1IntentMessageTableCardRow
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowV2beta1IntentMessageTelephonyPlayAudio struct {
	AudioUri string `json:"audioUri,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AudioUri") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AudioUri") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2beta1IntentMessageTelephonyPlayAudio) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2beta1IntentMessageTelephonyPlayAudio
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowV2beta1IntentMessageTelephonySynthesizeSpeech struct {
	Ssml string `json:"ssml,omitempty"`
	Text string `json:"text,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Ssml") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Ssml") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2beta1IntentMessageTelephonySynthesizeSpeech) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2beta1IntentMessageTelephonySynthesizeSpeech
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowV2beta1IntentMessageTelephonyTransferCall struct {
	PhoneNumber string `json:"phoneNumber,omitempty"`
	// ForceSendFields is a list of field names (e.g. "PhoneNumber") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "PhoneNumber") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2beta1IntentMessageTelephonyTransferCall) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2beta1IntentMessageTelephonyTransferCall
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowV2beta1IntentMessageText struct {
	Text []string `json:"text,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Text") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Text") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2beta1IntentMessageText) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2beta1IntentMessageText
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowV2beta1IntentParameter struct {
	DefaultValue          string   `json:"defaultValue,omitempty"`
	DisplayName           string   `json:"displayName,omitempty"`
	EntityTypeDisplayName string   `json:"entityTypeDisplayName,omitempty"`
	IsList                bool     `json:"isList,omitempty"`
	Mandatory             bool     `json:"mandatory,omitempty"`
	Name                  string   `json:"name,omitempty"`
	Prompts               []string `json:"prompts,omitempty"`
	Value                 string   `json:"value,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DefaultValue") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DefaultValue") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2beta1IntentParameter) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2beta1IntentParameter
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowV2beta1IntentSuggestion struct {
	Description string `json:"description,omitempty"`
	DisplayName string `json:"displayName,omitempty"`
	IntentV2    string `json:"intentV2,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Description") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Description") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2beta1IntentSuggestion) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2beta1IntentSuggestion
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowV2beta1IntentTrainingPhrase struct {
	Name            string                                                  `json:"name,omitempty"`
	Parts           []*GoogleCloudDialogflowV2beta1IntentTrainingPhrasePart `json:"parts,omitempty"`
	TimesAddedCount int64                                                   `json:"timesAddedCount,omitempty"`
	// Possible values:
	//   "TYPE_UNSPECIFIED"
	//   "EXAMPLE"
	//   "TEMPLATE"
	Type string `json:"type,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Name") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Name") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2beta1IntentTrainingPhrase) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2beta1IntentTrainingPhrase
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowV2beta1IntentTrainingPhrasePart struct {
	Alias       string `json:"alias,omitempty"`
	EntityType  string `json:"entityType,omitempty"`
	Text        string `json:"text,omitempty"`
	UserDefined bool   `json:"userDefined,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Alias") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Alias") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2beta1IntentTrainingPhrasePart) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2beta1IntentTrainingPhrasePart
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowV2beta1KnowledgeAnswers struct {
	Answers []*GoogleCloudDialogflowV2beta1KnowledgeAnswersAnswer `json:"answers,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Answers") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Answers") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2beta1KnowledgeAnswers) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2beta1KnowledgeAnswers
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowV2beta1KnowledgeAnswersAnswer struct {
	Answer          string  `json:"answer,omitempty"`
	FaqQuestion     string  `json:"faqQuestion,omitempty"`
	MatchConfidence float64 `json:"matchConfidence,omitempty"`
	// Possible values:
	//   "MATCH_CONFIDENCE_LEVEL_UNSPECIFIED"
	//   "LOW"
	//   "MEDIUM"
	//   "HIGH"
	MatchConfidenceLevel string `json:"matchConfidenceLevel,omitempty"`
	Source               string `json:"source,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Answer") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Answer") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2beta1KnowledgeAnswersAnswer) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2beta1KnowledgeAnswersAnswer
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *GoogleCloudDialogflowV2beta1KnowledgeAnswersAnswer) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleCloudDialogflowV2beta1KnowledgeAnswersAnswer
	var s1 struct {
		MatchConfidence gensupport.JSONFloat64 `json:"matchConfidence"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.MatchConfidence = float64(s1.MatchConfidence)
	return nil
}

type GoogleCloudDialogflowV2beta1KnowledgeAssistAnswer struct {
	AnswerRecord             string                                                            `json:"answerRecord,omitempty"`
	KnowledgeAssistDebugInfo *GoogleCloudDialogflowV2beta1KnowledgeAssistDebugInfo             `json:"knowledgeAssistDebugInfo,omitempty"`
	SuggestedQuery           *GoogleCloudDialogflowV2beta1KnowledgeAssistAnswerSuggestedQuery  `json:"suggestedQuery,omitempty"`
	SuggestedQueryAnswer     *GoogleCloudDialogflowV2beta1KnowledgeAssistAnswerKnowledgeAnswer `json:"suggestedQueryAnswer,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AnswerRecord") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AnswerRecord") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2beta1KnowledgeAssistAnswer) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2beta1KnowledgeAssistAnswer
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowV2beta1KnowledgeAssistAnswerKnowledgeAnswer struct {
	AnswerText       string                                                                            `json:"answerText,omitempty"`
	FaqSource        *GoogleCloudDialogflowV2beta1KnowledgeAssistAnswerKnowledgeAnswerFaqSource        `json:"faqSource,omitempty"`
	GenerativeSource *GoogleCloudDialogflowV2beta1KnowledgeAssistAnswerKnowledgeAnswerGenerativeSource `json:"generativeSource,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AnswerText") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AnswerText") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2beta1KnowledgeAssistAnswerKnowledgeAnswer) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2beta1KnowledgeAssistAnswerKnowledgeAnswer
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowV2beta1KnowledgeAssistAnswerKnowledgeAnswerFaqSource struct {
	Question string `json:"question,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Question") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Question") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2beta1KnowledgeAssistAnswerKnowledgeAnswerFaqSource) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2beta1KnowledgeAssistAnswerKnowledgeAnswerFaqSource
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowV2beta1KnowledgeAssistAnswerKnowledgeAnswerGenerativeSource struct {
	Snippets []*GoogleCloudDialogflowV2beta1KnowledgeAssistAnswerKnowledgeAnswerGenerativeSourceSnippet `json:"snippets,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Snippets") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Snippets") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2beta1KnowledgeAssistAnswerKnowledgeAnswerGenerativeSource) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2beta1KnowledgeAssistAnswerKnowledgeAnswerGenerativeSource
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowV2beta1KnowledgeAssistAnswerKnowledgeAnswerGenerativeSourceSnippet struct {
	Metadata googleapi.RawMessage `json:"metadata,omitempty"`
	Text     string               `json:"text,omitempty"`
	Title    string               `json:"title,omitempty"`
	Uri      string               `json:"uri,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Metadata") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Metadata") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2beta1KnowledgeAssistAnswerKnowledgeAnswerGenerativeSourceSnippet) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2beta1KnowledgeAssistAnswerKnowledgeAnswerGenerativeSourceSnippet
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowV2beta1KnowledgeAssistAnswerSuggestedQuery struct {
	QueryText string `json:"queryText,omitempty"`
	// ForceSendFields is a list of field names (e.g. "QueryText") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "QueryText") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2beta1KnowledgeAssistAnswerSuggestedQuery) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2beta1KnowledgeAssistAnswerSuggestedQuery
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowV2beta1KnowledgeAssistDebugInfo struct {
	// Possible values:
	//   "DATASTORE_RESPONSE_REASON_UNSPECIFIED"
	//   "NONE"
	//   "SEARCH_OUT_OF_QUOTA"
	//   "SEARCH_EMPTY_RESULTS"
	//   "ANSWER_GENERATION_GEN_AI_DISABLED"
	//   "ANSWER_GENERATION_OUT_OF_QUOTA"
	//   "ANSWER_GENERATION_ERROR"
	//   "ANSWER_GENERATION_NOT_ENOUGH_INFO"
	//   "ANSWER_GENERATION_RAI_FAILED"
	//   "ANSWER_GENERATION_NOT_GROUNDED"
	DatastoreResponseReason           string                                                                       `json:"datastoreResponseReason,omitempty"`
	IngestedContextReferenceDebugInfo *GoogleCloudDialogflowV2beta1IngestedContextReferenceDebugInfo               `json:"ingestedContextReferenceDebugInfo,omitempty"`
	KnowledgeAssistBehavior           *GoogleCloudDialogflowV2beta1KnowledgeAssistDebugInfoKnowledgeAssistBehavior `json:"knowledgeAssistBehavior,omitempty"`
	// Possible values:
	//   "QUERY_CATEGORIZATION_FAILURE_REASON_UNSPECIFIED"
	//   "QUERY_CATEGORIZATION_INVALID_CONFIG"
	//   "QUERY_CATEGORIZATION_RESULT_NOT_FOUND"
	//   "QUERY_CATEGORIZATION_FAILED"
	QueryCategorizationFailureReason string `json:"queryCategorizationFailureReason,omitempty"`
	// Possible values:
	//   "QUERY_GENERATION_FAILURE_REASON_UNSPECIFIED"
	//   "QUERY_GENERATION_OUT_OF_QUOTA"
	//   "QUERY_GENERATION_FAILED"
	//   "QUERY_GENERATION_NO_QUERY_GENERATED"
	//   "QUERY_GENERATION_RAI_FAILED"
	//   "NOT_IN_ALLOWLIST"
	//   "QUERY_GENERATION_QUERY_REDACTED"
	//   "QUERY_GENERATION_LLM_RESPONSE_PARSE_FAILED"
	//   "QUERY_GENERATION_EMPTY_CONVERSATION"
	//   "QUERY_GENERATION_EMPTY_LAST_MESSAGE"
	//   "QUERY_GENERATION_TRIGGERING_EVENT_CONDITION_NOT_MET"
	QueryGenerationFailureReason string                                      `json:"queryGenerationFailureReason,omitempty"`
	ServiceLatency               *GoogleCloudDialogflowV2beta1ServiceLatency `json:"serviceLatency,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DatastoreResponseReason") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DatastoreResponseReason") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2beta1KnowledgeAssistDebugInfo) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2beta1KnowledgeAssistDebugInfo
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowV2beta1KnowledgeAssistDebugInfoKnowledgeAssistBehavior struct {
	AnswerGenerationRewriterOn              bool  `json:"answerGenerationRewriterOn,omitempty"`
	AppendedSearchContextCount              int64 `json:"appendedSearchContextCount,omitempty"`
	ConversationTranscriptHasMixedLanguages bool  `json:"conversationTranscriptHasMixedLanguages,omitempty"`
	DisableSyncDelivery                     bool  `json:"disableSyncDelivery,omitempty"`
	EndUserMetadataIncluded                 bool  `json:"endUserMetadataIncluded,omitempty"`
	InvalidItemsQuerySuggestionSkipped      bool  `json:"invalidItemsQuerySuggestionSkipped,omitempty"`
	MultipleQueriesGenerated                bool  `json:"multipleQueriesGenerated,omitempty"`
	PreviousQueriesIncluded                 bool  `json:"previousQueriesIncluded,omitempty"`
	PrimaryQueryRedactedAndReplaced         bool  `json:"primaryQueryRedactedAndReplaced,omitempty"`
	QueryContainedSearchContext             bool  `json:"queryContainedSearchContext,omitempty"`
	QueryGenerationAgentLanguageMismatch    bool  `json:"queryGenerationAgentLanguageMismatch,omitempty"`
	QueryGenerationEndUserLanguageMismatch  bool  `json:"queryGenerationEndUserLanguageMismatch,omitempty"`
	ReturnQueryOnly                         bool  `json:"returnQueryOnly,omitempty"`
	ThirdPartyConnectorAllowed              bool  `json:"thirdPartyConnectorAllowed,omitempty"`
	UseCustomSafetyFilterLevel              bool  `json:"useCustomSafetyFilterLevel,omitempty"`
	UsePubsubDelivery                       bool  `json:"usePubsubDelivery,omitempty"`
	UseTranslatedMessage                    bool  `json:"useTranslatedMessage,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AnswerGenerationRewriterOn")
	// to unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AnswerGenerationRewriterOn") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2beta1KnowledgeAssistDebugInfoKnowledgeAssistBehavior) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2beta1KnowledgeAssistDebugInfoKnowledgeAssistBehavior
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowV2beta1KnowledgeOperationMetadata struct {
	DoneTime                string                                               `json:"doneTime,omitempty"`
	ExportOperationMetadata *GoogleCloudDialogflowV2beta1ExportOperationMetadata `json:"exportOperationMetadata,omitempty"`
	KnowledgeBase           string                                               `json:"knowledgeBase,omitempty"`
	// Possible values:
	//   "STATE_UNSPECIFIED"
	//   "PENDING"
	//   "RUNNING"
	//   "DONE"
	State string `json:"state,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DoneTime") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DoneTime") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2beta1KnowledgeOperationMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2beta1KnowledgeOperationMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowV2beta1Message struct {
	Content           string                                         `json:"content,omitempty"`
	CreateTime        string                                         `json:"createTime,omitempty"`
	LanguageCode      string                                         `json:"languageCode,omitempty"`
	MessageAnnotation *GoogleCloudDialogflowV2beta1MessageAnnotation `json:"messageAnnotation,omitempty"`
	Name              string                                         `json:"name,omitempty"`
	Participant       string                                         `json:"participant,omitempty"`
	// Possible values:
	//   "ROLE_UNSPECIFIED"
	//   "HUMAN_AGENT"
	//   "AUTOMATED_AGENT"
	//   "END_USER"
	ParticipantRole   string                                               `json:"participantRole,omitempty"`
	ResponseMessages  []*GoogleCloudDialogflowV2beta1ResponseMessage       `json:"responseMessages,omitempty"`
	SendTime          string                                               `json:"sendTime,omitempty"`
	SentimentAnalysis *GoogleCloudDialogflowV2beta1SentimentAnalysisResult `json:"sentimentAnalysis,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Content") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Content") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2beta1Message) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2beta1Message
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowV2beta1MessageAnnotation struct {
	ContainEntities bool                                                `json:"containEntities,omitempty"`
	Parts           []*GoogleCloudDialogflowV2beta1AnnotatedMessagePart `json:"parts,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ContainEntities") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ContainEntities") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2beta1MessageAnnotation) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2beta1MessageAnnotation
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowV2beta1OriginalDetectIntentRequest struct {
	Payload googleapi.RawMessage `json:"payload,omitempty"`
	Source  string               `json:"source,omitempty"`
	Version string               `json:"version,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Payload") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Payload") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2beta1OriginalDetectIntentRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2beta1OriginalDetectIntentRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowV2beta1QueryResult struct {
	Action                      string                                               `json:"action,omitempty"`
	AllRequiredParamsPresent    bool                                                 `json:"allRequiredParamsPresent,omitempty"`
	CancelsSlotFilling          bool                                                 `json:"cancelsSlotFilling,omitempty"`
	DiagnosticInfo              googleapi.RawMessage                                 `json:"diagnosticInfo,omitempty"`
	FulfillmentMessages         []*GoogleCloudDialogflowV2beta1IntentMessage         `json:"fulfillmentMessages,omitempty"`
	FulfillmentText             string                                               `json:"fulfillmentText,omitempty"`
	Intent                      *GoogleCloudDialogflowV2beta1Intent                  `json:"intent,omitempty"`
	IntentDetectionConfidence   float64                                              `json:"intentDetectionConfidence,omitempty"`
	KnowledgeAnswers            *GoogleCloudDialogflowV2beta1KnowledgeAnswers        `json:"knowledgeAnswers,omitempty"`
	LanguageCode                string                                               `json:"languageCode,omitempty"`
	OutputContexts              []*GoogleCloudDialogflowV2beta1Context               `json:"outputContexts,omitempty"`
	Parameters                  googleapi.RawMessage                                 `json:"parameters,omitempty"`
	QueryText                   string                                               `json:"queryText,omitempty"`
	SentimentAnalysisResult     *GoogleCloudDialogflowV2beta1SentimentAnalysisResult `json:"sentimentAnalysisResult,omitempty"`
	SpeechRecognitionConfidence float64                                              `json:"speechRecognitionConfidence,omitempty"`
	WebhookPayload              googleapi.RawMessage                                 `json:"webhookPayload,omitempty"`
	WebhookSource               string                                               `json:"webhookSource,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Action") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Action") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2beta1QueryResult) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2beta1QueryResult
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *GoogleCloudDialogflowV2beta1QueryResult) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleCloudDialogflowV2beta1QueryResult
	var s1 struct {
		IntentDetectionConfidence   gensupport.JSONFloat64 `json:"intentDetectionConfidence"`
		SpeechRecognitionConfidence gensupport.JSONFloat64 `json:"speechRecognitionConfidence"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.IntentDetectionConfidence = float64(s1.IntentDetectionConfidence)
	s.SpeechRecognitionConfidence = float64(s1.SpeechRecognitionConfidence)
	return nil
}

type GoogleCloudDialogflowV2beta1ResponseMessage struct {
	EndInteraction        *GoogleCloudDialogflowV2beta1ResponseMessageEndInteraction        `json:"endInteraction,omitempty"`
	LiveAgentHandoff      *GoogleCloudDialogflowV2beta1ResponseMessageLiveAgentHandoff      `json:"liveAgentHandoff,omitempty"`
	MixedAudio            *GoogleCloudDialogflowV2beta1ResponseMessageMixedAudio            `json:"mixedAudio,omitempty"`
	Payload               googleapi.RawMessage                                              `json:"payload,omitempty"`
	TelephonyTransferCall *GoogleCloudDialogflowV2beta1ResponseMessageTelephonyTransferCall `json:"telephonyTransferCall,omitempty"`
	Text                  *GoogleCloudDialogflowV2beta1ResponseMessageText                  `json:"text,omitempty"`
	// ForceSendFields is a list of field names (e.g. "EndInteraction") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "EndInteraction") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2beta1ResponseMessage) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2beta1ResponseMessage
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowV2beta1ResponseMessageEndInteraction struct {
}

type GoogleCloudDialogflowV2beta1ResponseMessageLiveAgentHandoff struct {
	Metadata googleapi.RawMessage `json:"metadata,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Metadata") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Metadata") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2beta1ResponseMessageLiveAgentHandoff) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2beta1ResponseMessageLiveAgentHandoff
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowV2beta1ResponseMessageMixedAudio struct {
	Segments []*GoogleCloudDialogflowV2beta1ResponseMessageMixedAudioSegment `json:"segments,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Segments") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Segments") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2beta1ResponseMessageMixedAudio) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2beta1ResponseMessageMixedAudio
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowV2beta1ResponseMessageMixedAudioSegment struct {
	AllowPlaybackInterruption bool   `json:"allowPlaybackInterruption,omitempty"`
	Audio                     string `json:"audio,omitempty"`
	Uri                       string `json:"uri,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AllowPlaybackInterruption")
	// to unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AllowPlaybackInterruption") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2beta1ResponseMessageMixedAudioSegment) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2beta1ResponseMessageMixedAudioSegment
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowV2beta1ResponseMessageTelephonyTransferCall struct {
	PhoneNumber string `json:"phoneNumber,omitempty"`
	SipUri      string `json:"sipUri,omitempty"`
	// ForceSendFields is a list of field names (e.g. "PhoneNumber") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "PhoneNumber") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2beta1ResponseMessageTelephonyTransferCall) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2beta1ResponseMessageTelephonyTransferCall
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowV2beta1ResponseMessageText struct {
	Text []string `json:"text,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Text") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Text") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2beta1ResponseMessageText) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2beta1ResponseMessageText
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowV2beta1Sentiment struct {
	Magnitude float64 `json:"magnitude,omitempty"`
	Score     float64 `json:"score,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Magnitude") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Magnitude") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2beta1Sentiment) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2beta1Sentiment
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *GoogleCloudDialogflowV2beta1Sentiment) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleCloudDialogflowV2beta1Sentiment
	var s1 struct {
		Magnitude gensupport.JSONFloat64 `json:"magnitude"`
		Score     gensupport.JSONFloat64 `json:"score"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.Magnitude = float64(s1.Magnitude)
	s.Score = float64(s1.Score)
	return nil
}

type GoogleCloudDialogflowV2beta1SentimentAnalysisResult struct {
	QueryTextSentiment *GoogleCloudDialogflowV2beta1Sentiment `json:"queryTextSentiment,omitempty"`
	// ForceSendFields is a list of field names (e.g. "QueryTextSentiment") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "QueryTextSentiment") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2beta1SentimentAnalysisResult) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2beta1SentimentAnalysisResult
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowV2beta1ServiceLatency struct {
	InternalServiceLatencies []*GoogleCloudDialogflowV2beta1ServiceLatencyInternalServiceLatency `json:"internalServiceLatencies,omitempty"`
	// ForceSendFields is a list of field names (e.g. "InternalServiceLatencies")
	// to unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "InternalServiceLatencies") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2beta1ServiceLatency) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2beta1ServiceLatency
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowV2beta1ServiceLatencyInternalServiceLatency struct {
	CompleteTime string  `json:"completeTime,omitempty"`
	LatencyMs    float64 `json:"latencyMs,omitempty"`
	StartTime    string  `json:"startTime,omitempty"`
	Step         string  `json:"step,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CompleteTime") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CompleteTime") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2beta1ServiceLatencyInternalServiceLatency) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2beta1ServiceLatencyInternalServiceLatency
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *GoogleCloudDialogflowV2beta1ServiceLatencyInternalServiceLatency) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleCloudDialogflowV2beta1ServiceLatencyInternalServiceLatency
	var s1 struct {
		LatencyMs gensupport.JSONFloat64 `json:"latencyMs"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.LatencyMs = float64(s1.LatencyMs)
	return nil
}

type GoogleCloudDialogflowV2beta1SessionEntityType struct {
	Entities []*GoogleCloudDialogflowV2beta1EntityTypeEntity `json:"entities,omitempty"`
	// Possible values:
	//   "ENTITY_OVERRIDE_MODE_UNSPECIFIED"
	//   "ENTITY_OVERRIDE_MODE_OVERRIDE"
	//   "ENTITY_OVERRIDE_MODE_SUPPLEMENT"
	EntityOverrideMode string `json:"entityOverrideMode,omitempty"`
	Name               string `json:"name,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Entities") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Entities") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2beta1SessionEntityType) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2beta1SessionEntityType
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowV2beta1SetSuggestionFeatureConfigOperationMetadata struct {
	ConversationProfile string `json:"conversationProfile,omitempty"`
	CreateTime          string `json:"createTime,omitempty"`
	// Possible values:
	//   "ROLE_UNSPECIFIED"
	//   "HUMAN_AGENT"
	//   "AUTOMATED_AGENT"
	//   "END_USER"
	ParticipantRole string `json:"participantRole,omitempty"`
	// Possible values:
	//   "TYPE_UNSPECIFIED"
	//   "ARTICLE_SUGGESTION"
	//   "FAQ"
	//   "SMART_REPLY"
	//   "DIALOGFLOW_ASSIST"
	//   "CONVERSATION_SUMMARIZATION"
	//   "KNOWLEDGE_SEARCH"
	//   "KNOWLEDGE_ASSIST"
	SuggestionFeatureType string `json:"suggestionFeatureType,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ConversationProfile") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ConversationProfile") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2beta1SetSuggestionFeatureConfigOperationMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2beta1SetSuggestionFeatureConfigOperationMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowV2beta1SmartReplyAnswer struct {
	AnswerRecord string  `json:"answerRecord,omitempty"`
	Confidence   float64 `json:"confidence,omitempty"`
	Reply        string  `json:"reply,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AnswerRecord") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AnswerRecord") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2beta1SmartReplyAnswer) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2beta1SmartReplyAnswer
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *GoogleCloudDialogflowV2beta1SmartReplyAnswer) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleCloudDialogflowV2beta1SmartReplyAnswer
	var s1 struct {
		Confidence gensupport.JSONFloat64 `json:"confidence"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.Confidence = float64(s1.Confidence)
	return nil
}

type GoogleCloudDialogflowV2beta1SpeechWordInfo struct {
	Confidence  float64 `json:"confidence,omitempty"`
	EndOffset   string  `json:"endOffset,omitempty"`
	StartOffset string  `json:"startOffset,omitempty"`
	Word        string  `json:"word,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Confidence") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Confidence") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2beta1SpeechWordInfo) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2beta1SpeechWordInfo
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *GoogleCloudDialogflowV2beta1SpeechWordInfo) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleCloudDialogflowV2beta1SpeechWordInfo
	var s1 struct {
		Confidence gensupport.JSONFloat64 `json:"confidence"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.Confidence = float64(s1.Confidence)
	return nil
}

type GoogleCloudDialogflowV2beta1StreamingRecognitionResult struct {
	Confidence   float64                                          `json:"confidence,omitempty"`
	DtmfDigits   *GoogleCloudDialogflowV2beta1TelephonyDtmfEvents `json:"dtmfDigits,omitempty"`
	IsFinal      bool                                             `json:"isFinal,omitempty"`
	LanguageCode string                                           `json:"languageCode,omitempty"`
	// Possible values:
	//   "MESSAGE_TYPE_UNSPECIFIED"
	//   "TRANSCRIPT"
	//   "END_OF_SINGLE_UTTERANCE"
	//   "DTMF_DIGITS"
	//   "PARTIAL_DTMF_DIGITS"
	MessageType     string                                        `json:"messageType,omitempty"`
	SpeechEndOffset string                                        `json:"speechEndOffset,omitempty"`
	SpeechWordInfo  []*GoogleCloudDialogflowV2beta1SpeechWordInfo `json:"speechWordInfo,omitempty"`
	Stability       float64                                       `json:"stability,omitempty"`
	Transcript      string                                        `json:"transcript,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Confidence") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Confidence") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2beta1StreamingRecognitionResult) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2beta1StreamingRecognitionResult
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *GoogleCloudDialogflowV2beta1StreamingRecognitionResult) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleCloudDialogflowV2beta1StreamingRecognitionResult
	var s1 struct {
		Confidence gensupport.JSONFloat64 `json:"confidence"`
		Stability  gensupport.JSONFloat64 `json:"stability"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.Confidence = float64(s1.Confidence)
	s.Stability = float64(s1.Stability)
	return nil
}

type GoogleCloudDialogflowV2beta1SuggestArticlesResponse struct {
	ArticleAnswers []*GoogleCloudDialogflowV2beta1ArticleAnswer `json:"articleAnswers,omitempty"`
	ContextSize    int64                                        `json:"contextSize,omitempty"`
	LatestMessage  string                                       `json:"latestMessage,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ArticleAnswers") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ArticleAnswers") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2beta1SuggestArticlesResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2beta1SuggestArticlesResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowV2beta1SuggestDialogflowAssistsResponse struct {
	ContextSize             int64                                                 `json:"contextSize,omitempty"`
	DialogflowAssistAnswers []*GoogleCloudDialogflowV2beta1DialogflowAssistAnswer `json:"dialogflowAssistAnswers,omitempty"`
	LatestMessage           string                                                `json:"latestMessage,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ContextSize") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ContextSize") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2beta1SuggestDialogflowAssistsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2beta1SuggestDialogflowAssistsResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowV2beta1SuggestFaqAnswersResponse struct {
	ContextSize   int64                                    `json:"contextSize,omitempty"`
	FaqAnswers    []*GoogleCloudDialogflowV2beta1FaqAnswer `json:"faqAnswers,omitempty"`
	LatestMessage string                                   `json:"latestMessage,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ContextSize") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ContextSize") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2beta1SuggestFaqAnswersResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2beta1SuggestFaqAnswersResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowV2beta1SuggestKnowledgeAssistResponse struct {
	ContextSize           int64                                              `json:"contextSize,omitempty"`
	KnowledgeAssistAnswer *GoogleCloudDialogflowV2beta1KnowledgeAssistAnswer `json:"knowledgeAssistAnswer,omitempty"`
	LatestMessage         string                                             `json:"latestMessage,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ContextSize") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ContextSize") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2beta1SuggestKnowledgeAssistResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2beta1SuggestKnowledgeAssistResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowV2beta1SuggestSmartRepliesResponse struct {
	ContextSize       int64                                           `json:"contextSize,omitempty"`
	LatestMessage     string                                          `json:"latestMessage,omitempty"`
	SmartReplyAnswers []*GoogleCloudDialogflowV2beta1SmartReplyAnswer `json:"smartReplyAnswers,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ContextSize") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ContextSize") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2beta1SuggestSmartRepliesResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2beta1SuggestSmartRepliesResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowV2beta1SuggestionResult struct {
	Error                            *GoogleRpcStatus                                              `json:"error,omitempty"`
	GenerateSuggestionsResponse      *GoogleCloudDialogflowV2beta1GenerateSuggestionsResponse      `json:"generateSuggestionsResponse,omitempty"`
	SuggestArticlesResponse          *GoogleCloudDialogflowV2beta1SuggestArticlesResponse          `json:"suggestArticlesResponse,omitempty"`
	SuggestDialogflowAssistsResponse *GoogleCloudDialogflowV2beta1SuggestDialogflowAssistsResponse `json:"suggestDialogflowAssistsResponse,omitempty"`
	SuggestEntityExtractionResponse  *GoogleCloudDialogflowV2beta1SuggestDialogflowAssistsResponse `json:"suggestEntityExtractionResponse,omitempty"`
	SuggestFaqAnswersResponse        *GoogleCloudDialogflowV2beta1SuggestFaqAnswersResponse        `json:"suggestFaqAnswersResponse,omitempty"`
	SuggestKnowledgeAssistResponse   *GoogleCloudDialogflowV2beta1SuggestKnowledgeAssistResponse   `json:"suggestKnowledgeAssistResponse,omitempty"`
	SuggestSmartRepliesResponse      *GoogleCloudDialogflowV2beta1SuggestSmartRepliesResponse      `json:"suggestSmartRepliesResponse,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Error") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Error") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2beta1SuggestionResult) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2beta1SuggestionResult
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowV2beta1SummarySuggestion struct {
	SummarySections []*GoogleCloudDialogflowV2beta1SummarySuggestionSummarySection `json:"summarySections,omitempty"`
	// ForceSendFields is a list of field names (e.g. "SummarySections") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "SummarySections") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2beta1SummarySuggestion) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2beta1SummarySuggestion
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowV2beta1SummarySuggestionSummarySection struct {
	Section string `json:"section,omitempty"`
	Summary string `json:"summary,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Section") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Section") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2beta1SummarySuggestionSummarySection) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2beta1SummarySuggestionSummarySection
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowV2beta1TelephonyDtmfEvents struct {
	// Possible values:
	//   "TELEPHONY_DTMF_UNSPECIFIED"
	//   "DTMF_ONE"
	//   "DTMF_TWO"
	//   "DTMF_THREE"
	//   "DTMF_FOUR"
	//   "DTMF_FIVE"
	//   "DTMF_SIX"
	//   "DTMF_SEVEN"
	//   "DTMF_EIGHT"
	//   "DTMF_NINE"
	//   "DTMF_ZERO"
	//   "DTMF_A"
	//   "DTMF_B"
	//   "DTMF_C"
	//   "DTMF_D"
	//   "DTMF_STAR"
	//   "DTMF_POUND"
	DtmfEvents []string `json:"dtmfEvents,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DtmfEvents") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DtmfEvents") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2beta1TelephonyDtmfEvents) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2beta1TelephonyDtmfEvents
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowV2beta1ToolCall struct {
	Action          string               `json:"action,omitempty"`
	AnswerRecord    string               `json:"answerRecord,omitempty"`
	CreateTime      string               `json:"createTime,omitempty"`
	InputParameters googleapi.RawMessage `json:"inputParameters,omitempty"`
	// Possible values:
	//   "STATE_UNSPECIFIED"
	//   "TRIGGERED"
	//   "NEEDS_CONFIRMATION"
	State              string `json:"state,omitempty"`
	Tool               string `json:"tool,omitempty"`
	ToolDisplayDetails string `json:"toolDisplayDetails,omitempty"`
	ToolDisplayName    string `json:"toolDisplayName,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Action") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Action") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2beta1ToolCall) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2beta1ToolCall
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowV2beta1ToolCallResult struct {
	Action       string                                           `json:"action,omitempty"`
	AnswerRecord string                                           `json:"answerRecord,omitempty"`
	Content      string                                           `json:"content,omitempty"`
	CreateTime   string                                           `json:"createTime,omitempty"`
	Error        *GoogleCloudDialogflowV2beta1ToolCallResultError `json:"error,omitempty"`
	RawContent   string                                           `json:"rawContent,omitempty"`
	Tool         string                                           `json:"tool,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Action") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Action") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2beta1ToolCallResult) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2beta1ToolCallResult
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowV2beta1ToolCallResultError struct {
	Message string `json:"message,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Message") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Message") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2beta1ToolCallResultError) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2beta1ToolCallResultError
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowV2beta1WebhookRequest struct {
	AlternativeQueryResults     []*GoogleCloudDialogflowV2beta1QueryResult               `json:"alternativeQueryResults,omitempty"`
	OriginalDetectIntentRequest *GoogleCloudDialogflowV2beta1OriginalDetectIntentRequest `json:"originalDetectIntentRequest,omitempty"`
	QueryResult                 *GoogleCloudDialogflowV2beta1QueryResult                 `json:"queryResult,omitempty"`
	ResponseId                  string                                                   `json:"responseId,omitempty"`
	Session                     string                                                   `json:"session,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AlternativeQueryResults") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AlternativeQueryResults") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2beta1WebhookRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2beta1WebhookRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowV2beta1WebhookResponse struct {
	EndInteraction      bool                                             `json:"endInteraction,omitempty"`
	FollowupEventInput  *GoogleCloudDialogflowV2beta1EventInput          `json:"followupEventInput,omitempty"`
	FulfillmentMessages []*GoogleCloudDialogflowV2beta1IntentMessage     `json:"fulfillmentMessages,omitempty"`
	FulfillmentText     string                                           `json:"fulfillmentText,omitempty"`
	LiveAgentHandoff    bool                                             `json:"liveAgentHandoff,omitempty"`
	OutputContexts      []*GoogleCloudDialogflowV2beta1Context           `json:"outputContexts,omitempty"`
	Payload             googleapi.RawMessage                             `json:"payload,omitempty"`
	SessionEntityTypes  []*GoogleCloudDialogflowV2beta1SessionEntityType `json:"sessionEntityTypes,omitempty"`
	Source              string                                           `json:"source,omitempty"`
	// ForceSendFields is a list of field names (e.g. "EndInteraction") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "EndInteraction") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2beta1WebhookResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2beta1WebhookResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowV3alpha1ConversationSignals struct {
	TurnSignals *GoogleCloudDialogflowV3alpha1TurnSignals `json:"turnSignals,omitempty"`
	// ForceSendFields is a list of field names (e.g. "TurnSignals") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "TurnSignals") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV3alpha1ConversationSignals) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV3alpha1ConversationSignals
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudDialogflowV3alpha1TurnSignals struct {
	AgentEscalated bool `json:"agentEscalated,omitempty"`
	DtmfUsed       bool `json:"dtmfUsed,omitempty"`
	// Possible values:
	//   "FAILURE_REASON_UNSPECIFIED"
	//   "FAILED_INTENT"
	//   "FAILED_WEBHOOK"
	FailureReasons            []string `json:"failureReasons,omitempty"`
	NoMatch                   bool     `json:"noMatch,omitempty"`
	NoUserInput               bool     `json:"noUserInput,omitempty"`
	ReachedEndPage            bool     `json:"reachedEndPage,omitempty"`
	SentimentMagnitude        float64  `json:"sentimentMagnitude,omitempty"`
	SentimentScore            float64  `json:"sentimentScore,omitempty"`
	TriggeredAbandonmentEvent bool     `json:"triggeredAbandonmentEvent,omitempty"`
	UserEscalated             bool     `json:"userEscalated,omitempty"`
	WebhookStatuses           []string `json:"webhookStatuses,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AgentEscalated") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AgentEscalated") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV3alpha1TurnSignals) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV3alpha1TurnSignals
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *GoogleCloudDialogflowV3alpha1TurnSignals) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleCloudDialogflowV3alpha1TurnSignals
	var s1 struct {
		SentimentMagnitude gensupport.JSONFloat64 `json:"sentimentMagnitude"`
		SentimentScore     gensupport.JSONFloat64 `json:"sentimentScore"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.SentimentMagnitude = float64(s1.SentimentMagnitude)
	s.SentimentScore = float64(s1.SentimentScore)
	return nil
}

type GoogleCloudLocationListLocationsResponse struct {
	Locations     []*GoogleCloudLocationLocation `json:"locations,omitempty"`
	NextPageToken string                         `json:"nextPageToken,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Locations") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Locations") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudLocationListLocationsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudLocationListLocationsResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudLocationLocation struct {
	DisplayName string               `json:"displayName,omitempty"`
	Labels      map[string]string    `json:"labels,omitempty"`
	LocationId  string               `json:"locationId,omitempty"`
	Metadata    googleapi.RawMessage `json:"metadata,omitempty"`
	Name        string               `json:"name,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "DisplayName") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DisplayName") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudLocationLocation) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudLocationLocation
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleLongrunningListOperationsResponse struct {
	NextPageToken string                        `json:"nextPageToken,omitempty"`
	Operations    []*GoogleLongrunningOperation `json:"operations,omitempty"`
	Unreachable   []string                      `json:"unreachable,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "NextPageToken") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "NextPageToken") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleLongrunningListOperationsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleLongrunningListOperationsResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleLongrunningOperation struct {
	Done     bool                 `json:"done,omitempty"`
	Error    *GoogleRpcStatus     `json:"error,omitempty"`
	Metadata googleapi.RawMessage `json:"metadata,omitempty"`
	Name     string               `json:"name,omitempty"`
	Response googleapi.RawMessage `json:"response,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Done") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Done") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleLongrunningOperation) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleLongrunningOperation
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleProtobufEmpty struct {
	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
}

type GoogleRpcStatus struct {
	Code    int64                  `json:"code,omitempty"`
	Details []googleapi.RawMessage `json:"details,omitempty"`
	Message string                 `json:"message,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Code") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Code") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleRpcStatus) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleRpcStatus
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleTypeLatLng struct {
	Latitude  float64 `json:"latitude,omitempty"`
	Longitude float64 `json:"longitude,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Latitude") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Latitude") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleTypeLatLng) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleTypeLatLng
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *GoogleTypeLatLng) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleTypeLatLng
	var s1 struct {
		Latitude  gensupport.JSONFloat64 `json:"latitude"`
		Longitude gensupport.JSONFloat64 `json:"longitude"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.Latitude = float64(s1.Latitude)
	s.Longitude = float64(s1.Longitude)
	return nil
}

type ProjectsLocationsGetCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get:
//
// - name: .
func (r *ProjectsLocationsService) Get(name string) *ProjectsLocationsGetCall {
	c := &ProjectsLocationsGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsGetCall) Fields(s ...googleapi.Field) *ProjectsLocationsGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsGetCall) IfNoneMatch(entityTag string) *ProjectsLocationsGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsGetCall) Context(ctx context.Context) *ProjectsLocationsGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v3/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "dialogflow.projects.locations.get", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "dialogflow.projects.locations.get" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleCloudLocationLocation.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsGetCall) Do(opts ...googleapi.CallOption) (*GoogleCloudLocationLocation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleCloudLocationLocation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "dialogflow.projects.locations.get", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsListCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List:
//
// - name: .
func (r *ProjectsLocationsService) List(name string) *ProjectsLocationsListCall {
	c := &ProjectsLocationsListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// ExtraLocationTypes sets the optional parameter "extraLocationTypes":
func (c *ProjectsLocationsListCall) ExtraLocationTypes(extraLocationTypes ...string) *ProjectsLocationsListCall {
	c.urlParams_.SetMulti("extraLocationTypes", append([]string{}, extraLocationTypes...))
	return c
}

// Filter sets the optional parameter "filter":
func (c *ProjectsLocationsListCall) Filter(filter string) *ProjectsLocationsListCall {
	c.urlParams_.Set("filter", filter)
	return c
}

// PageSize sets the optional parameter "pageSize":
func (c *ProjectsLocationsListCall) PageSize(pageSize int64) *ProjectsLocationsListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken":
func (c *ProjectsLocationsListCall) PageToken(pageToken string) *ProjectsLocationsListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsListCall) Fields(s ...googleapi.Field) *ProjectsLocationsListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsListCall) IfNoneMatch(entityTag string) *ProjectsLocationsListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsListCall) Context(ctx context.Context) *ProjectsLocationsListCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v3/{+name}/locations")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "dialogflow.projects.locations.list", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "dialogflow.projects.locations.list" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleCloudLocationListLocationsResponse.ServerResponse.Header or (if a
// response was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsListCall) Do(opts ...googleapi.CallOption) (*GoogleCloudLocationListLocationsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleCloudLocationListLocationsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "dialogflow.projects.locations.list", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *ProjectsLocationsListCall) Pages(ctx context.Context, f func(*GoogleCloudLocationListLocationsResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken"))
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

type ProjectsLocationsAgentsCreateCall struct {
	s                              *Service
	parent                         string
	googleclouddialogflowcxv3agent *GoogleCloudDialogflowCxV3Agent
	urlParams_                     gensupport.URLParams
	ctx_                           context.Context
	header_                        http.Header
}

// Create:
//
// - parent: .
func (r *ProjectsLocationsAgentsService) Create(parent string, googleclouddialogflowcxv3agent *GoogleCloudDialogflowCxV3Agent) *ProjectsLocationsAgentsCreateCall {
	c := &ProjectsLocationsAgentsCreateCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	c.googleclouddialogflowcxv3agent = googleclouddialogflowcxv3agent
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsAgentsCreateCall) Fields(s ...googleapi.Field) *ProjectsLocationsAgentsCreateCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsAgentsCreateCall) Context(ctx context.Context) *ProjectsLocationsAgentsCreateCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsAgentsCreateCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsAgentsCreateCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.googleclouddialogflowcxv3agent)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v3/{+parent}/agents")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "dialogflow.projects.locations.agents.create", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "dialogflow.projects.locations.agents.create" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleCloudDialogflowCxV3Agent.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsAgentsCreateCall) Do(opts ...googleapi.CallOption) (*GoogleCloudDialogflowCxV3Agent, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleCloudDialogflowCxV3Agent{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "dialogflow.projects.locations.agents.create", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsAgentsDeleteCall struct {
	s          *Service
	name       string
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Delete:
//
// - name: .
func (r *ProjectsLocationsAgentsService) Delete(name string) *ProjectsLocationsAgentsDeleteCall {
	c := &ProjectsLocationsAgentsDeleteCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsAgentsDeleteCall) Fields(s ...googleapi.Field) *ProjectsLocationsAgentsDeleteCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsAgentsDeleteCall) Context(ctx context.Context) *ProjectsLocationsAgentsDeleteCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsAgentsDeleteCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsAgentsDeleteCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v3/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("DELETE", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "dialogflow.projects.locations.agents.delete", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "dialogflow.projects.locations.agents.delete" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleProtobufEmpty.ServerResponse.Header or (if a response was returned at
// all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified was
// returned.
func (c *ProjectsLocationsAgentsDeleteCall) Do(opts ...googleapi.CallOption) (*GoogleProtobufEmpty, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleProtobufEmpty{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "dialogflow.projects.locations.agents.delete", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsAgentsExportCall struct {
	s                                           *Service
	name                                        string
	googleclouddialogflowcxv3exportagentrequest *GoogleCloudDialogflowCxV3ExportAgentRequest
	urlParams_                                  gensupport.URLParams
	ctx_                                        context.Context
	header_                                     http.Header
}

// Export:
//
// - name: .
func (r *ProjectsLocationsAgentsService) Export(name string, googleclouddialogflowcxv3exportagentrequest *GoogleCloudDialogflowCxV3ExportAgentRequest) *ProjectsLocationsAgentsExportCall {
	c := &ProjectsLocationsAgentsExportCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.googleclouddialogflowcxv3exportagentrequest = googleclouddialogflowcxv3exportagentrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsAgentsExportCall) Fields(s ...googleapi.Field) *ProjectsLocationsAgentsExportCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsAgentsExportCall) Context(ctx context.Context) *ProjectsLocationsAgentsExportCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsAgentsExportCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsAgentsExportCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.googleclouddialogflowcxv3exportagentrequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v3/{+name}:export")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "dialogflow.projects.locations.agents.export", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "dialogflow.projects.locations.agents.export" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleLongrunningOperation.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsAgentsExportCall) Do(opts ...googleapi.CallOption) (*GoogleLongrunningOperation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleLongrunningOperation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "dialogflow.projects.locations.agents.export", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsAgentsGetCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get:
//
// - name: .
func (r *ProjectsLocationsAgentsService) Get(name string) *ProjectsLocationsAgentsGetCall {
	c := &ProjectsLocationsAgentsGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsAgentsGetCall) Fields(s ...googleapi.Field) *ProjectsLocationsAgentsGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsAgentsGetCall) IfNoneMatch(entityTag string) *ProjectsLocationsAgentsGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsAgentsGetCall) Context(ctx context.Context) *ProjectsLocationsAgentsGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsAgentsGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsAgentsGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v3/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "dialogflow.projects.locations.agents.get", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "dialogflow.projects.locations.agents.get" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleCloudDialogflowCxV3Agent.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsAgentsGetCall) Do(opts ...googleapi.CallOption) (*GoogleCloudDialogflowCxV3Agent, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleCloudDialogflowCxV3Agent{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "dialogflow.projects.locations.agents.get", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsAgentsGetGenerativeSettingsCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// GetGenerativeSettings:
//
// - name: .
func (r *ProjectsLocationsAgentsService) GetGenerativeSettings(name string) *ProjectsLocationsAgentsGetGenerativeSettingsCall {
	c := &ProjectsLocationsAgentsGetGenerativeSettingsCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// LanguageCode sets the optional parameter "languageCode":
func (c *ProjectsLocationsAgentsGetGenerativeSettingsCall) LanguageCode(languageCode string) *ProjectsLocationsAgentsGetGenerativeSettingsCall {
	c.urlParams_.Set("languageCode", languageCode)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsAgentsGetGenerativeSettingsCall) Fields(s ...googleapi.Field) *ProjectsLocationsAgentsGetGenerativeSettingsCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsAgentsGetGenerativeSettingsCall) IfNoneMatch(entityTag string) *ProjectsLocationsAgentsGetGenerativeSettingsCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsAgentsGetGenerativeSettingsCall) Context(ctx context.Context) *ProjectsLocationsAgentsGetGenerativeSettingsCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsAgentsGetGenerativeSettingsCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsAgentsGetGenerativeSettingsCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v3/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "dialogflow.projects.locations.agents.getGenerativeSettings", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "dialogflow.projects.locations.agents.getGenerativeSettings" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleCloudDialogflowCxV3GenerativeSettings.ServerResponse.Header or (if a
// response was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsAgentsGetGenerativeSettingsCall) Do(opts ...googleapi.CallOption) (*GoogleCloudDialogflowCxV3GenerativeSettings, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleCloudDialogflowCxV3GenerativeSettings{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "dialogflow.projects.locations.agents.getGenerativeSettings", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsAgentsGetValidationResultCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// GetValidationResult:
//
// - name: .
func (r *ProjectsLocationsAgentsService) GetValidationResult(name string) *ProjectsLocationsAgentsGetValidationResultCall {
	c := &ProjectsLocationsAgentsGetValidationResultCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// LanguageCode sets the optional parameter "languageCode":
func (c *ProjectsLocationsAgentsGetValidationResultCall) LanguageCode(languageCode string) *ProjectsLocationsAgentsGetValidationResultCall {
	c.urlParams_.Set("languageCode", languageCode)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsAgentsGetValidationResultCall) Fields(s ...googleapi.Field) *ProjectsLocationsAgentsGetValidationResultCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsAgentsGetValidationResultCall) IfNoneMatch(entityTag string) *ProjectsLocationsAgentsGetValidationResultCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsAgentsGetValidationResultCall) Context(ctx context.Context) *ProjectsLocationsAgentsGetValidationResultCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsAgentsGetValidationResultCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsAgentsGetValidationResultCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v3/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "dialogflow.projects.locations.agents.getValidationResult", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "dialogflow.projects.locations.agents.getValidationResult" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleCloudDialogflowCxV3AgentValidationResult.ServerResponse.Header or (if
// a response was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsAgentsGetValidationResultCall) Do(opts ...googleapi.CallOption) (*GoogleCloudDialogflowCxV3AgentValidationResult, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleCloudDialogflowCxV3AgentValidationResult{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "dialogflow.projects.locations.agents.getValidationResult", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsAgentsListCall struct {
	s            *Service
	parent       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List:
//
// - parent: .
func (r *ProjectsLocationsAgentsService) List(parent string) *ProjectsLocationsAgentsListCall {
	c := &ProjectsLocationsAgentsListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	return c
}

// PageSize sets the optional parameter "pageSize":
func (c *ProjectsLocationsAgentsListCall) PageSize(pageSize int64) *ProjectsLocationsAgentsListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken":
func (c *ProjectsLocationsAgentsListCall) PageToken(pageToken string) *ProjectsLocationsAgentsListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsAgentsListCall) Fields(s ...googleapi.Field) *ProjectsLocationsAgentsListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsAgentsListCall) IfNoneMatch(entityTag string) *ProjectsLocationsAgentsListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsAgentsListCall) Context(ctx context.Context) *ProjectsLocationsAgentsListCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsAgentsListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsAgentsListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v3/{+parent}/agents")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "dialogflow.projects.locations.agents.list", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "dialogflow.projects.locations.agents.list" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleCloudDialogflowCxV3ListAgentsResponse.ServerResponse.Header or (if a
// response was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsAgentsListCall) Do(opts ...googleapi.CallOption) (*GoogleCloudDialogflowCxV3ListAgentsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleCloudDialogflowCxV3ListAgentsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "dialogflow.projects.locations.agents.list", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *ProjectsLocationsAgentsListCall) Pages(ctx context.Context, f func(*GoogleCloudDialogflowCxV3ListAgentsResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken"))
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

type ProjectsLocationsAgentsPatchCall struct {
	s                              *Service
	name                           string
	googleclouddialogflowcxv3agent *GoogleCloudDialogflowCxV3Agent
	urlParams_                     gensupport.URLParams
	ctx_                           context.Context
	header_                        http.Header
}

// Patch:
//
// - name: .
func (r *ProjectsLocationsAgentsService) Patch(name string, googleclouddialogflowcxv3agent *GoogleCloudDialogflowCxV3Agent) *ProjectsLocationsAgentsPatchCall {
	c := &ProjectsLocationsAgentsPatchCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.googleclouddialogflowcxv3agent = googleclouddialogflowcxv3agent
	return c
}

// UpdateMask sets the optional parameter "updateMask":
func (c *ProjectsLocationsAgentsPatchCall) UpdateMask(updateMask string) *ProjectsLocationsAgentsPatchCall {
	c.urlParams_.Set("updateMask", updateMask)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsAgentsPatchCall) Fields(s ...googleapi.Field) *ProjectsLocationsAgentsPatchCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsAgentsPatchCall) Context(ctx context.Context) *ProjectsLocationsAgentsPatchCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsAgentsPatchCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsAgentsPatchCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.googleclouddialogflowcxv3agent)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v3/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("PATCH", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "dialogflow.projects.locations.agents.patch", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "dialogflow.projects.locations.agents.patch" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleCloudDialogflowCxV3Agent.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsAgentsPatchCall) Do(opts ...googleapi.CallOption) (*GoogleCloudDialogflowCxV3Agent, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleCloudDialogflowCxV3Agent{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "dialogflow.projects.locations.agents.patch", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsAgentsRestoreCall struct {
	s                                            *Service
	name                                         string
	googleclouddialogflowcxv3restoreagentrequest *GoogleCloudDialogflowCxV3RestoreAgentRequest
	urlParams_                                   gensupport.URLParams
	ctx_                                         context.Context
	header_                                      http.Header
}

// Restore:
//
// - name: .
func (r *ProjectsLocationsAgentsService) Restore(name string, googleclouddialogflowcxv3restoreagentrequest *GoogleCloudDialogflowCxV3RestoreAgentRequest) *ProjectsLocationsAgentsRestoreCall {
	c := &ProjectsLocationsAgentsRestoreCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.googleclouddialogflowcxv3restoreagentrequest = googleclouddialogflowcxv3restoreagentrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsAgentsRestoreCall) Fields(s ...googleapi.Field) *ProjectsLocationsAgentsRestoreCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsAgentsRestoreCall) Context(ctx context.Context) *ProjectsLocationsAgentsRestoreCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsAgentsRestoreCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsAgentsRestoreCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.googleclouddialogflowcxv3restoreagentrequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v3/{+name}:restore")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "dialogflow.projects.locations.agents.restore", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "dialogflow.projects.locations.agents.restore" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleLongrunningOperation.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsAgentsRestoreCall) Do(opts ...googleapi.CallOption) (*GoogleLongrunningOperation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleLongrunningOperation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "dialogflow.projects.locations.agents.restore", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsAgentsUpdateGenerativeSettingsCall struct {
	s                                           *Service
	name                                        string
	googleclouddialogflowcxv3generativesettings *GoogleCloudDialogflowCxV3GenerativeSettings
	urlParams_                                  gensupport.URLParams
	ctx_                                        context.Context
	header_                                     http.Header
}

// UpdateGenerativeSettings:
//
// - name: .
func (r *ProjectsLocationsAgentsService) UpdateGenerativeSettings(name string, googleclouddialogflowcxv3generativesettings *GoogleCloudDialogflowCxV3GenerativeSettings) *ProjectsLocationsAgentsUpdateGenerativeSettingsCall {
	c := &ProjectsLocationsAgentsUpdateGenerativeSettingsCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.googleclouddialogflowcxv3generativesettings = googleclouddialogflowcxv3generativesettings
	return c
}

// UpdateMask sets the optional parameter "updateMask":
func (c *ProjectsLocationsAgentsUpdateGenerativeSettingsCall) UpdateMask(updateMask string) *ProjectsLocationsAgentsUpdateGenerativeSettingsCall {
	c.urlParams_.Set("updateMask", updateMask)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsAgentsUpdateGenerativeSettingsCall) Fields(s ...googleapi.Field) *ProjectsLocationsAgentsUpdateGenerativeSettingsCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsAgentsUpdateGenerativeSettingsCall) Context(ctx context.Context) *ProjectsLocationsAgentsUpdateGenerativeSettingsCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsAgentsUpdateGenerativeSettingsCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsAgentsUpdateGenerativeSettingsCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.googleclouddialogflowcxv3generativesettings)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v3/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("PATCH", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "dialogflow.projects.locations.agents.updateGenerativeSettings", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "dialogflow.projects.locations.agents.updateGenerativeSettings" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleCloudDialogflowCxV3GenerativeSettings.ServerResponse.Header or (if a
// response was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsAgentsUpdateGenerativeSettingsCall) Do(opts ...googleapi.CallOption) (*GoogleCloudDialogflowCxV3GenerativeSettings, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleCloudDialogflowCxV3GenerativeSettings{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "dialogflow.projects.locations.agents.updateGenerativeSettings", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsAgentsValidateCall struct {
	s                                             *Service
	name                                          string
	googleclouddialogflowcxv3validateagentrequest *GoogleCloudDialogflowCxV3ValidateAgentRequest
	urlParams_                                    gensupport.URLParams
	ctx_                                          context.Context
	header_                                       http.Header
}

// Validate:
//
// - name: .
func (r *ProjectsLocationsAgentsService) Validate(name string, googleclouddialogflowcxv3validateagentrequest *GoogleCloudDialogflowCxV3ValidateAgentRequest) *ProjectsLocationsAgentsValidateCall {
	c := &ProjectsLocationsAgentsValidateCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.googleclouddialogflowcxv3validateagentrequest = googleclouddialogflowcxv3validateagentrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsAgentsValidateCall) Fields(s ...googleapi.Field) *ProjectsLocationsAgentsValidateCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsAgentsValidateCall) Context(ctx context.Context) *ProjectsLocationsAgentsValidateCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsAgentsValidateCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsAgentsValidateCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.googleclouddialogflowcxv3validateagentrequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v3/{+name}:validate")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "dialogflow.projects.locations.agents.validate", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "dialogflow.projects.locations.agents.validate" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleCloudDialogflowCxV3AgentValidationResult.ServerResponse.Header or (if
// a response was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsAgentsValidateCall) Do(opts ...googleapi.CallOption) (*GoogleCloudDialogflowCxV3AgentValidationResult, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleCloudDialogflowCxV3AgentValidationResult{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "dialogflow.projects.locations.agents.validate", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsAgentsChangelogsGetCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get:
//
// - name: .
func (r *ProjectsLocationsAgentsChangelogsService) Get(name string) *ProjectsLocationsAgentsChangelogsGetCall {
	c := &ProjectsLocationsAgentsChangelogsGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsAgentsChangelogsGetCall) Fields(s ...googleapi.Field) *ProjectsLocationsAgentsChangelogsGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsAgentsChangelogsGetCall) IfNoneMatch(entityTag string) *ProjectsLocationsAgentsChangelogsGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsAgentsChangelogsGetCall) Context(ctx context.Context) *ProjectsLocationsAgentsChangelogsGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsAgentsChangelogsGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsAgentsChangelogsGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v3/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "dialogflow.projects.locations.agents.changelogs.get", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "dialogflow.projects.locations.agents.changelogs.get" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleCloudDialogflowCxV3Changelog.ServerResponse.Header or (if a response
// was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsAgentsChangelogsGetCall) Do(opts ...googleapi.CallOption) (*GoogleCloudDialogflowCxV3Changelog, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleCloudDialogflowCxV3Changelog{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "dialogflow.projects.locations.agents.changelogs.get", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsAgentsChangelogsListCall struct {
	s            *Service
	parent       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List:
//
// - parent: .
func (r *ProjectsLocationsAgentsChangelogsService) List(parent string) *ProjectsLocationsAgentsChangelogsListCall {
	c := &ProjectsLocationsAgentsChangelogsListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	return c
}

// Filter sets the optional parameter "filter":
func (c *ProjectsLocationsAgentsChangelogsListCall) Filter(filter string) *ProjectsLocationsAgentsChangelogsListCall {
	c.urlParams_.Set("filter", filter)
	return c
}

// PageSize sets the optional parameter "pageSize":
func (c *ProjectsLocationsAgentsChangelogsListCall) PageSize(pageSize int64) *ProjectsLocationsAgentsChangelogsListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken":
func (c *ProjectsLocationsAgentsChangelogsListCall) PageToken(pageToken string) *ProjectsLocationsAgentsChangelogsListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsAgentsChangelogsListCall) Fields(s ...googleapi.Field) *ProjectsLocationsAgentsChangelogsListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsAgentsChangelogsListCall) IfNoneMatch(entityTag string) *ProjectsLocationsAgentsChangelogsListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsAgentsChangelogsListCall) Context(ctx context.Context) *ProjectsLocationsAgentsChangelogsListCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsAgentsChangelogsListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsAgentsChangelogsListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v3/{+parent}/changelogs")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "dialogflow.projects.locations.agents.changelogs.list", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "dialogflow.projects.locations.agents.changelogs.list" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleCloudDialogflowCxV3ListChangelogsResponse.ServerResponse.Header or
// (if a response was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsAgentsChangelogsListCall) Do(opts ...googleapi.CallOption) (*GoogleCloudDialogflowCxV3ListChangelogsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleCloudDialogflowCxV3ListChangelogsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "dialogflow.projects.locations.agents.changelogs.list", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *ProjectsLocationsAgentsChangelogsListCall) Pages(ctx context.Context, f func(*GoogleCloudDialogflowCxV3ListChangelogsResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken"))
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

type ProjectsLocationsAgentsEntityTypesCreateCall struct {
	s                                   *Service
	parent                              string
	googleclouddialogflowcxv3entitytype *GoogleCloudDialogflowCxV3EntityType
	urlParams_                          gensupport.URLParams
	ctx_                                context.Context
	header_                             http.Header
}

// Create:
//
// - parent: .
func (r *ProjectsLocationsAgentsEntityTypesService) Create(parent string, googleclouddialogflowcxv3entitytype *GoogleCloudDialogflowCxV3EntityType) *ProjectsLocationsAgentsEntityTypesCreateCall {
	c := &ProjectsLocationsAgentsEntityTypesCreateCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	c.googleclouddialogflowcxv3entitytype = googleclouddialogflowcxv3entitytype
	return c
}

// LanguageCode sets the optional parameter "languageCode":
func (c *ProjectsLocationsAgentsEntityTypesCreateCall) LanguageCode(languageCode string) *ProjectsLocationsAgentsEntityTypesCreateCall {
	c.urlParams_.Set("languageCode", languageCode)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsAgentsEntityTypesCreateCall) Fields(s ...googleapi.Field) *ProjectsLocationsAgentsEntityTypesCreateCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsAgentsEntityTypesCreateCall) Context(ctx context.Context) *ProjectsLocationsAgentsEntityTypesCreateCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsAgentsEntityTypesCreateCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsAgentsEntityTypesCreateCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.googleclouddialogflowcxv3entitytype)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v3/{+parent}/entityTypes")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "dialogflow.projects.locations.agents.entityTypes.create", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "dialogflow.projects.locations.agents.entityTypes.create" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleCloudDialogflowCxV3EntityType.ServerResponse.Header or (if a response
// was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsAgentsEntityTypesCreateCall) Do(opts ...googleapi.CallOption) (*GoogleCloudDialogflowCxV3EntityType, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleCloudDialogflowCxV3EntityType{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "dialogflow.projects.locations.agents.entityTypes.create", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsAgentsEntityTypesDeleteCall struct {
	s          *Service
	name       string
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Delete:
//
// - name: .
func (r *ProjectsLocationsAgentsEntityTypesService) Delete(name string) *ProjectsLocationsAgentsEntityTypesDeleteCall {
	c := &ProjectsLocationsAgentsEntityTypesDeleteCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Force sets the optional parameter "force":
func (c *ProjectsLocationsAgentsEntityTypesDeleteCall) Force(force bool) *ProjectsLocationsAgentsEntityTypesDeleteCall {
	c.urlParams_.Set("force", fmt.Sprint(force))
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsAgentsEntityTypesDeleteCall) Fields(s ...googleapi.Field) *ProjectsLocationsAgentsEntityTypesDeleteCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsAgentsEntityTypesDeleteCall) Context(ctx context.Context) *ProjectsLocationsAgentsEntityTypesDeleteCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsAgentsEntityTypesDeleteCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsAgentsEntityTypesDeleteCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v3/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("DELETE", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "dialogflow.projects.locations.agents.entityTypes.delete", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "dialogflow.projects.locations.agents.entityTypes.delete" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleProtobufEmpty.ServerResponse.Header or (if a response was returned at
// all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified was
// returned.
func (c *ProjectsLocationsAgentsEntityTypesDeleteCall) Do(opts ...googleapi.CallOption) (*GoogleProtobufEmpty, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleProtobufEmpty{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "dialogflow.projects.locations.agents.entityTypes.delete", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsAgentsEntityTypesExportCall struct {
	s                                                 *Service
	parent                                            string
	googleclouddialogflowcxv3exportentitytypesrequest *GoogleCloudDialogflowCxV3ExportEntityTypesRequest
	urlParams_                                        gensupport.URLParams
	ctx_                                              context.Context
	header_                                           http.Header
}

// Export:
//
// - parent: .
func (r *ProjectsLocationsAgentsEntityTypesService) Export(parent string, googleclouddialogflowcxv3exportentitytypesrequest *GoogleCloudDialogflowCxV3ExportEntityTypesRequest) *ProjectsLocationsAgentsEntityTypesExportCall {
	c := &ProjectsLocationsAgentsEntityTypesExportCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	c.googleclouddialogflowcxv3exportentitytypesrequest = googleclouddialogflowcxv3exportentitytypesrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsAgentsEntityTypesExportCall) Fields(s ...googleapi.Field) *ProjectsLocationsAgentsEntityTypesExportCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsAgentsEntityTypesExportCall) Context(ctx context.Context) *ProjectsLocationsAgentsEntityTypesExportCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsAgentsEntityTypesExportCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsAgentsEntityTypesExportCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.googleclouddialogflowcxv3exportentitytypesrequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v3/{+parent}/entityTypes:export")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "dialogflow.projects.locations.agents.entityTypes.export", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "dialogflow.projects.locations.agents.entityTypes.export" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleLongrunningOperation.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsAgentsEntityTypesExportCall) Do(opts ...googleapi.CallOption) (*GoogleLongrunningOperation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleLongrunningOperation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "dialogflow.projects.locations.agents.entityTypes.export", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsAgentsEntityTypesGetCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get:
//
// - name: .
func (r *ProjectsLocationsAgentsEntityTypesService) Get(name string) *ProjectsLocationsAgentsEntityTypesGetCall {
	c := &ProjectsLocationsAgentsEntityTypesGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// LanguageCode sets the optional parameter "languageCode":
func (c *ProjectsLocationsAgentsEntityTypesGetCall) LanguageCode(languageCode string) *ProjectsLocationsAgentsEntityTypesGetCall {
	c.urlParams_.Set("languageCode", languageCode)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsAgentsEntityTypesGetCall) Fields(s ...googleapi.Field) *ProjectsLocationsAgentsEntityTypesGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsAgentsEntityTypesGetCall) IfNoneMatch(entityTag string) *ProjectsLocationsAgentsEntityTypesGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsAgentsEntityTypesGetCall) Context(ctx context.Context) *ProjectsLocationsAgentsEntityTypesGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsAgentsEntityTypesGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsAgentsEntityTypesGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v3/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "dialogflow.projects.locations.agents.entityTypes.get", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "dialogflow.projects.locations.agents.entityTypes.get" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleCloudDialogflowCxV3EntityType.ServerResponse.Header or (if a response
// was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsAgentsEntityTypesGetCall) Do(opts ...googleapi.CallOption) (*GoogleCloudDialogflowCxV3EntityType, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleCloudDialogflowCxV3EntityType{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "dialogflow.projects.locations.agents.entityTypes.get", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsAgentsEntityTypesImportCall struct {
	s                                                 *Service
	parent                                            string
	googleclouddialogflowcxv3importentitytypesrequest *GoogleCloudDialogflowCxV3ImportEntityTypesRequest
	urlParams_                                        gensupport.URLParams
	ctx_                                              context.Context
	header_                                           http.Header
}

// Import:
//
// - parent: .
func (r *ProjectsLocationsAgentsEntityTypesService) Import(parent string, googleclouddialogflowcxv3importentitytypesrequest *GoogleCloudDialogflowCxV3ImportEntityTypesRequest) *ProjectsLocationsAgentsEntityTypesImportCall {
	c := &ProjectsLocationsAgentsEntityTypesImportCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	c.googleclouddialogflowcxv3importentitytypesrequest = googleclouddialogflowcxv3importentitytypesrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsAgentsEntityTypesImportCall) Fields(s ...googleapi.Field) *ProjectsLocationsAgentsEntityTypesImportCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsAgentsEntityTypesImportCall) Context(ctx context.Context) *ProjectsLocationsAgentsEntityTypesImportCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsAgentsEntityTypesImportCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsAgentsEntityTypesImportCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.googleclouddialogflowcxv3importentitytypesrequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v3/{+parent}/entityTypes:import")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "dialogflow.projects.locations.agents.entityTypes.import", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "dialogflow.projects.locations.agents.entityTypes.import" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleLongrunningOperation.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsAgentsEntityTypesImportCall) Do(opts ...googleapi.CallOption) (*GoogleLongrunningOperation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleLongrunningOperation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "dialogflow.projects.locations.agents.entityTypes.import", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsAgentsEntityTypesListCall struct {
	s            *Service
	parent       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List:
//
// - parent: .
func (r *ProjectsLocationsAgentsEntityTypesService) List(parent string) *ProjectsLocationsAgentsEntityTypesListCall {
	c := &ProjectsLocationsAgentsEntityTypesListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	return c
}

// LanguageCode sets the optional parameter "languageCode":
func (c *ProjectsLocationsAgentsEntityTypesListCall) LanguageCode(languageCode string) *ProjectsLocationsAgentsEntityTypesListCall {
	c.urlParams_.Set("languageCode", languageCode)
	return c
}

// PageSize sets the optional parameter "pageSize":
func (c *ProjectsLocationsAgentsEntityTypesListCall) PageSize(pageSize int64) *ProjectsLocationsAgentsEntityTypesListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken":
func (c *ProjectsLocationsAgentsEntityTypesListCall) PageToken(pageToken string) *ProjectsLocationsAgentsEntityTypesListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsAgentsEntityTypesListCall) Fields(s ...googleapi.Field) *ProjectsLocationsAgentsEntityTypesListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsAgentsEntityTypesListCall) IfNoneMatch(entityTag string) *ProjectsLocationsAgentsEntityTypesListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsAgentsEntityTypesListCall) Context(ctx context.Context) *ProjectsLocationsAgentsEntityTypesListCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsAgentsEntityTypesListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsAgentsEntityTypesListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v3/{+parent}/entityTypes")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "dialogflow.projects.locations.agents.entityTypes.list", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "dialogflow.projects.locations.agents.entityTypes.list" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleCloudDialogflowCxV3ListEntityTypesResponse.ServerResponse.Header or
// (if a response was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsAgentsEntityTypesListCall) Do(opts ...googleapi.CallOption) (*GoogleCloudDialogflowCxV3ListEntityTypesResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleCloudDialogflowCxV3ListEntityTypesResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "dialogflow.projects.locations.agents.entityTypes.list", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *ProjectsLocationsAgentsEntityTypesListCall) Pages(ctx context.Context, f func(*GoogleCloudDialogflowCxV3ListEntityTypesResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken"))
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

type ProjectsLocationsAgentsEntityTypesPatchCall struct {
	s                                   *Service
	name                                string
	googleclouddialogflowcxv3entitytype *GoogleCloudDialogflowCxV3EntityType
	urlParams_                          gensupport.URLParams
	ctx_                                context.Context
	header_                             http.Header
}

// Patch:
//
// - name: .
func (r *ProjectsLocationsAgentsEntityTypesService) Patch(name string, googleclouddialogflowcxv3entitytype *GoogleCloudDialogflowCxV3EntityType) *ProjectsLocationsAgentsEntityTypesPatchCall {
	c := &ProjectsLocationsAgentsEntityTypesPatchCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.googleclouddialogflowcxv3entitytype = googleclouddialogflowcxv3entitytype
	return c
}

// LanguageCode sets the optional parameter "languageCode":
func (c *ProjectsLocationsAgentsEntityTypesPatchCall) LanguageCode(languageCode string) *ProjectsLocationsAgentsEntityTypesPatchCall {
	c.urlParams_.Set("languageCode", languageCode)
	return c
}

// UpdateMask sets the optional parameter "updateMask":
func (c *ProjectsLocationsAgentsEntityTypesPatchCall) UpdateMask(updateMask string) *ProjectsLocationsAgentsEntityTypesPatchCall {
	c.urlParams_.Set("updateMask", updateMask)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsAgentsEntityTypesPatchCall) Fields(s ...googleapi.Field) *ProjectsLocationsAgentsEntityTypesPatchCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsAgentsEntityTypesPatchCall) Context(ctx context.Context) *ProjectsLocationsAgentsEntityTypesPatchCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsAgentsEntityTypesPatchCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsAgentsEntityTypesPatchCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.googleclouddialogflowcxv3entitytype)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v3/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("PATCH", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "dialogflow.projects.locations.agents.entityTypes.patch", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "dialogflow.projects.locations.agents.entityTypes.patch" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleCloudDialogflowCxV3EntityType.ServerResponse.Header or (if a response
// was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsAgentsEntityTypesPatchCall) Do(opts ...googleapi.CallOption) (*GoogleCloudDialogflowCxV3EntityType, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleCloudDialogflowCxV3EntityType{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "dialogflow.projects.locations.agents.entityTypes.patch", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsAgentsEnvironmentsCreateCall struct {
	s                                    *Service
	parent                               string
	googleclouddialogflowcxv3environment *GoogleCloudDialogflowCxV3Environment
	urlParams_                           gensupport.URLParams
	ctx_                                 context.Context
	header_                              http.Header
}

// Create:
//
// - parent: .
func (r *ProjectsLocationsAgentsEnvironmentsService) Create(parent string, googleclouddialogflowcxv3environment *GoogleCloudDialogflowCxV3Environment) *ProjectsLocationsAgentsEnvironmentsCreateCall {
	c := &ProjectsLocationsAgentsEnvironmentsCreateCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	c.googleclouddialogflowcxv3environment = googleclouddialogflowcxv3environment
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsAgentsEnvironmentsCreateCall) Fields(s ...googleapi.Field) *ProjectsLocationsAgentsEnvironmentsCreateCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsAgentsEnvironmentsCreateCall) Context(ctx context.Context) *ProjectsLocationsAgentsEnvironmentsCreateCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsAgentsEnvironmentsCreateCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsAgentsEnvironmentsCreateCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.googleclouddialogflowcxv3environment)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v3/{+parent}/environments")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "dialogflow.projects.locations.agents.environments.create", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "dialogflow.projects.locations.agents.environments.create" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleLongrunningOperation.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsAgentsEnvironmentsCreateCall) Do(opts ...googleapi.CallOption) (*GoogleLongrunningOperation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleLongrunningOperation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "dialogflow.projects.locations.agents.environments.create", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsAgentsEnvironmentsDeleteCall struct {
	s          *Service
	name       string
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Delete:
//
// - name: .
func (r *ProjectsLocationsAgentsEnvironmentsService) Delete(name string) *ProjectsLocationsAgentsEnvironmentsDeleteCall {
	c := &ProjectsLocationsAgentsEnvironmentsDeleteCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsAgentsEnvironmentsDeleteCall) Fields(s ...googleapi.Field) *ProjectsLocationsAgentsEnvironmentsDeleteCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsAgentsEnvironmentsDeleteCall) Context(ctx context.Context) *ProjectsLocationsAgentsEnvironmentsDeleteCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsAgentsEnvironmentsDeleteCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsAgentsEnvironmentsDeleteCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v3/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("DELETE", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "dialogflow.projects.locations.agents.environments.delete", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "dialogflow.projects.locations.agents.environments.delete" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleProtobufEmpty.ServerResponse.Header or (if a response was returned at
// all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified was
// returned.
func (c *ProjectsLocationsAgentsEnvironmentsDeleteCall) Do(opts ...googleapi.CallOption) (*GoogleProtobufEmpty, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleProtobufEmpty{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "dialogflow.projects.locations.agents.environments.delete", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsAgentsEnvironmentsDeployFlowCall struct {
	s                                          *Service
	environment                                string
	googleclouddialogflowcxv3deployflowrequest *GoogleCloudDialogflowCxV3DeployFlowRequest
	urlParams_                                 gensupport.URLParams
	ctx_                                       context.Context
	header_                                    http.Header
}

// DeployFlow:
//
// - environment: .
func (r *ProjectsLocationsAgentsEnvironmentsService) DeployFlow(environment string, googleclouddialogflowcxv3deployflowrequest *GoogleCloudDialogflowCxV3DeployFlowRequest) *ProjectsLocationsAgentsEnvironmentsDeployFlowCall {
	c := &ProjectsLocationsAgentsEnvironmentsDeployFlowCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.environment = environment
	c.googleclouddialogflowcxv3deployflowrequest = googleclouddialogflowcxv3deployflowrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsAgentsEnvironmentsDeployFlowCall) Fields(s ...googleapi.Field) *ProjectsLocationsAgentsEnvironmentsDeployFlowCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsAgentsEnvironmentsDeployFlowCall) Context(ctx context.Context) *ProjectsLocationsAgentsEnvironmentsDeployFlowCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsAgentsEnvironmentsDeployFlowCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsAgentsEnvironmentsDeployFlowCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.googleclouddialogflowcxv3deployflowrequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v3/{+environment}:deployFlow")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"environment": c.environment,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "dialogflow.projects.locations.agents.environments.deployFlow", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "dialogflow.projects.locations.agents.environments.deployFlow" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleLongrunningOperation.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsAgentsEnvironmentsDeployFlowCall) Do(opts ...googleapi.CallOption) (*GoogleLongrunningOperation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleLongrunningOperation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "dialogflow.projects.locations.agents.environments.deployFlow", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsAgentsEnvironmentsGetCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get:
//
// - name: .
func (r *ProjectsLocationsAgentsEnvironmentsService) Get(name string) *ProjectsLocationsAgentsEnvironmentsGetCall {
	c := &ProjectsLocationsAgentsEnvironmentsGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsAgentsEnvironmentsGetCall) Fields(s ...googleapi.Field) *ProjectsLocationsAgentsEnvironmentsGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsAgentsEnvironmentsGetCall) IfNoneMatch(entityTag string) *ProjectsLocationsAgentsEnvironmentsGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsAgentsEnvironmentsGetCall) Context(ctx context.Context) *ProjectsLocationsAgentsEnvironmentsGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsAgentsEnvironmentsGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsAgentsEnvironmentsGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v3/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "dialogflow.projects.locations.agents.environments.get", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "dialogflow.projects.locations.agents.environments.get" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleCloudDialogflowCxV3Environment.ServerResponse.Header or (if a
// response was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsAgentsEnvironmentsGetCall) Do(opts ...googleapi.CallOption) (*GoogleCloudDialogflowCxV3Environment, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleCloudDialogflowCxV3Environment{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "dialogflow.projects.locations.agents.environments.get", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsAgentsEnvironmentsListCall struct {
	s            *Service
	parent       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List:
//
// - parent: .
func (r *ProjectsLocationsAgentsEnvironmentsService) List(parent string) *ProjectsLocationsAgentsEnvironmentsListCall {
	c := &ProjectsLocationsAgentsEnvironmentsListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	return c
}

// PageSize sets the optional parameter "pageSize":
func (c *ProjectsLocationsAgentsEnvironmentsListCall) PageSize(pageSize int64) *ProjectsLocationsAgentsEnvironmentsListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken":
func (c *ProjectsLocationsAgentsEnvironmentsListCall) PageToken(pageToken string) *ProjectsLocationsAgentsEnvironmentsListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsAgentsEnvironmentsListCall) Fields(s ...googleapi.Field) *ProjectsLocationsAgentsEnvironmentsListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsAgentsEnvironmentsListCall) IfNoneMatch(entityTag string) *ProjectsLocationsAgentsEnvironmentsListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsAgentsEnvironmentsListCall) Context(ctx context.Context) *ProjectsLocationsAgentsEnvironmentsListCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsAgentsEnvironmentsListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsAgentsEnvironmentsListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v3/{+parent}/environments")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "dialogflow.projects.locations.agents.environments.list", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "dialogflow.projects.locations.agents.environments.list" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleCloudDialogflowCxV3ListEnvironmentsResponse.ServerResponse.Header or
// (if a response was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsAgentsEnvironmentsListCall) Do(opts ...googleapi.CallOption) (*GoogleCloudDialogflowCxV3ListEnvironmentsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleCloudDialogflowCxV3ListEnvironmentsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "dialogflow.projects.locations.agents.environments.list", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *ProjectsLocationsAgentsEnvironmentsListCall) Pages(ctx context.Context, f func(*GoogleCloudDialogflowCxV3ListEnvironmentsResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken"))
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

type ProjectsLocationsAgentsEnvironmentsLookupEnvironmentHistoryCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// LookupEnvironmentHistory:
//
// - name: .
func (r *ProjectsLocationsAgentsEnvironmentsService) LookupEnvironmentHistory(name string) *ProjectsLocationsAgentsEnvironmentsLookupEnvironmentHistoryCall {
	c := &ProjectsLocationsAgentsEnvironmentsLookupEnvironmentHistoryCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// PageSize sets the optional parameter "pageSize":
func (c *ProjectsLocationsAgentsEnvironmentsLookupEnvironmentHistoryCall) PageSize(pageSize int64) *ProjectsLocationsAgentsEnvironmentsLookupEnvironmentHistoryCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken":
func (c *ProjectsLocationsAgentsEnvironmentsLookupEnvironmentHistoryCall) PageToken(pageToken string) *ProjectsLocationsAgentsEnvironmentsLookupEnvironmentHistoryCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsAgentsEnvironmentsLookupEnvironmentHistoryCall) Fields(s ...googleapi.Field) *ProjectsLocationsAgentsEnvironmentsLookupEnvironmentHistoryCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsAgentsEnvironmentsLookupEnvironmentHistoryCall) IfNoneMatch(entityTag string) *ProjectsLocationsAgentsEnvironmentsLookupEnvironmentHistoryCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsAgentsEnvironmentsLookupEnvironmentHistoryCall) Context(ctx context.Context) *ProjectsLocationsAgentsEnvironmentsLookupEnvironmentHistoryCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsAgentsEnvironmentsLookupEnvironmentHistoryCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsAgentsEnvironmentsLookupEnvironmentHistoryCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v3/{+name}:lookupEnvironmentHistory")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "dialogflow.projects.locations.agents.environments.lookupEnvironmentHistory", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "dialogflow.projects.locations.agents.environments.lookupEnvironmentHistory" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleCloudDialogflowCxV3LookupEnvironmentHistoryResponse.ServerResponse.Hea
// der or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsAgentsEnvironmentsLookupEnvironmentHistoryCall) Do(opts ...googleapi.CallOption) (*GoogleCloudDialogflowCxV3LookupEnvironmentHistoryResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleCloudDialogflowCxV3LookupEnvironmentHistoryResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "dialogflow.projects.locations.agents.environments.lookupEnvironmentHistory", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *ProjectsLocationsAgentsEnvironmentsLookupEnvironmentHistoryCall) Pages(ctx context.Context, f func(*GoogleCloudDialogflowCxV3LookupEnvironmentHistoryResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken"))
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

type ProjectsLocationsAgentsEnvironmentsPatchCall struct {
	s                                    *Service
	name                                 string
	googleclouddialogflowcxv3environment *GoogleCloudDialogflowCxV3Environment
	urlParams_                           gensupport.URLParams
	ctx_                                 context.Context
	header_                              http.Header
}

// Patch:
//
// - name: .
func (r *ProjectsLocationsAgentsEnvironmentsService) Patch(name string, googleclouddialogflowcxv3environment *GoogleCloudDialogflowCxV3Environment) *ProjectsLocationsAgentsEnvironmentsPatchCall {
	c := &ProjectsLocationsAgentsEnvironmentsPatchCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.googleclouddialogflowcxv3environment = googleclouddialogflowcxv3environment
	return c
}

// UpdateMask sets the optional parameter "updateMask":
func (c *ProjectsLocationsAgentsEnvironmentsPatchCall) UpdateMask(updateMask string) *ProjectsLocationsAgentsEnvironmentsPatchCall {
	c.urlParams_.Set("updateMask", updateMask)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsAgentsEnvironmentsPatchCall) Fields(s ...googleapi.Field) *ProjectsLocationsAgentsEnvironmentsPatchCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsAgentsEnvironmentsPatchCall) Context(ctx context.Context) *ProjectsLocationsAgentsEnvironmentsPatchCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsAgentsEnvironmentsPatchCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsAgentsEnvironmentsPatchCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.googleclouddialogflowcxv3environment)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v3/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("PATCH", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "dialogflow.projects.locations.agents.environments.patch", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "dialogflow.projects.locations.agents.environments.patch" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleLongrunningOperation.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsAgentsEnvironmentsPatchCall) Do(opts ...googleapi.CallOption) (*GoogleLongrunningOperation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleLongrunningOperation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "dialogflow.projects.locations.agents.environments.patch", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsAgentsEnvironmentsRunContinuousTestCall struct {
	s                                                 *Service
	environment                                       string
	googleclouddialogflowcxv3runcontinuoustestrequest *GoogleCloudDialogflowCxV3RunContinuousTestRequest
	urlParams_                                        gensupport.URLParams
	ctx_                                              context.Context
	header_                                           http.Header
}

// RunContinuousTest:
//
// - environment: .
func (r *ProjectsLocationsAgentsEnvironmentsService) RunContinuousTest(environment string, googleclouddialogflowcxv3runcontinuoustestrequest *GoogleCloudDialogflowCxV3RunContinuousTestRequest) *ProjectsLocationsAgentsEnvironmentsRunContinuousTestCall {
	c := &ProjectsLocationsAgentsEnvironmentsRunContinuousTestCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.environment = environment
	c.googleclouddialogflowcxv3runcontinuoustestrequest = googleclouddialogflowcxv3runcontinuoustestrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsAgentsEnvironmentsRunContinuousTestCall) Fields(s ...googleapi.Field) *ProjectsLocationsAgentsEnvironmentsRunContinuousTestCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsAgentsEnvironmentsRunContinuousTestCall) Context(ctx context.Context) *ProjectsLocationsAgentsEnvironmentsRunContinuousTestCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsAgentsEnvironmentsRunContinuousTestCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsAgentsEnvironmentsRunContinuousTestCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.googleclouddialogflowcxv3runcontinuoustestrequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v3/{+environment}:runContinuousTest")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"environment": c.environment,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "dialogflow.projects.locations.agents.environments.runContinuousTest", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "dialogflow.projects.locations.agents.environments.runContinuousTest" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleLongrunningOperation.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsAgentsEnvironmentsRunContinuousTestCall) Do(opts ...googleapi.CallOption) (*GoogleLongrunningOperation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleLongrunningOperation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "dialogflow.projects.locations.agents.environments.runContinuousTest", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsAgentsEnvironmentsContinuousTestResultsListCall struct {
	s            *Service
	parent       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List:
//
// - parent: .
func (r *ProjectsLocationsAgentsEnvironmentsContinuousTestResultsService) List(parent string) *ProjectsLocationsAgentsEnvironmentsContinuousTestResultsListCall {
	c := &ProjectsLocationsAgentsEnvironmentsContinuousTestResultsListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	return c
}

// PageSize sets the optional parameter "pageSize":
func (c *ProjectsLocationsAgentsEnvironmentsContinuousTestResultsListCall) PageSize(pageSize int64) *ProjectsLocationsAgentsEnvironmentsContinuousTestResultsListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken":
func (c *ProjectsLocationsAgentsEnvironmentsContinuousTestResultsListCall) PageToken(pageToken string) *ProjectsLocationsAgentsEnvironmentsContinuousTestResultsListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsAgentsEnvironmentsContinuousTestResultsListCall) Fields(s ...googleapi.Field) *ProjectsLocationsAgentsEnvironmentsContinuousTestResultsListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsAgentsEnvironmentsContinuousTestResultsListCall) IfNoneMatch(entityTag string) *ProjectsLocationsAgentsEnvironmentsContinuousTestResultsListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsAgentsEnvironmentsContinuousTestResultsListCall) Context(ctx context.Context) *ProjectsLocationsAgentsEnvironmentsContinuousTestResultsListCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsAgentsEnvironmentsContinuousTestResultsListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsAgentsEnvironmentsContinuousTestResultsListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v3/{+parent}/continuousTestResults")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "dialogflow.projects.locations.agents.environments.continuousTestResults.list", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "dialogflow.projects.locations.agents.environments.continuousTestResults.list" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleCloudDialogflowCxV3ListContinuousTestResultsResponse.ServerResponse.He
// ader or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsAgentsEnvironmentsContinuousTestResultsListCall) Do(opts ...googleapi.CallOption) (*GoogleCloudDialogflowCxV3ListContinuousTestResultsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleCloudDialogflowCxV3ListContinuousTestResultsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "dialogflow.projects.locations.agents.environments.continuousTestResults.list", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *ProjectsLocationsAgentsEnvironmentsContinuousTestResultsListCall) Pages(ctx context.Context, f func(*GoogleCloudDialogflowCxV3ListContinuousTestResultsResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken"))
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

type ProjectsLocationsAgentsEnvironmentsDeploymentsGetCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get:
//
// - name: .
func (r *ProjectsLocationsAgentsEnvironmentsDeploymentsService) Get(name string) *ProjectsLocationsAgentsEnvironmentsDeploymentsGetCall {
	c := &ProjectsLocationsAgentsEnvironmentsDeploymentsGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsAgentsEnvironmentsDeploymentsGetCall) Fields(s ...googleapi.Field) *ProjectsLocationsAgentsEnvironmentsDeploymentsGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsAgentsEnvironmentsDeploymentsGetCall) IfNoneMatch(entityTag string) *ProjectsLocationsAgentsEnvironmentsDeploymentsGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsAgentsEnvironmentsDeploymentsGetCall) Context(ctx context.Context) *ProjectsLocationsAgentsEnvironmentsDeploymentsGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsAgentsEnvironmentsDeploymentsGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsAgentsEnvironmentsDeploymentsGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v3/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "dialogflow.projects.locations.agents.environments.deployments.get", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "dialogflow.projects.locations.agents.environments.deployments.get" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleCloudDialogflowCxV3Deployment.ServerResponse.Header or (if a response
// was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsAgentsEnvironmentsDeploymentsGetCall) Do(opts ...googleapi.CallOption) (*GoogleCloudDialogflowCxV3Deployment, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleCloudDialogflowCxV3Deployment{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "dialogflow.projects.locations.agents.environments.deployments.get", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsAgentsEnvironmentsDeploymentsListCall struct {
	s            *Service
	parent       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List:
//
// - parent: .
func (r *ProjectsLocationsAgentsEnvironmentsDeploymentsService) List(parent string) *ProjectsLocationsAgentsEnvironmentsDeploymentsListCall {
	c := &ProjectsLocationsAgentsEnvironmentsDeploymentsListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	return c
}

// PageSize sets the optional parameter "pageSize":
func (c *ProjectsLocationsAgentsEnvironmentsDeploymentsListCall) PageSize(pageSize int64) *ProjectsLocationsAgentsEnvironmentsDeploymentsListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken":
func (c *ProjectsLocationsAgentsEnvironmentsDeploymentsListCall) PageToken(pageToken string) *ProjectsLocationsAgentsEnvironmentsDeploymentsListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsAgentsEnvironmentsDeploymentsListCall) Fields(s ...googleapi.Field) *ProjectsLocationsAgentsEnvironmentsDeploymentsListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsAgentsEnvironmentsDeploymentsListCall) IfNoneMatch(entityTag string) *ProjectsLocationsAgentsEnvironmentsDeploymentsListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsAgentsEnvironmentsDeploymentsListCall) Context(ctx context.Context) *ProjectsLocationsAgentsEnvironmentsDeploymentsListCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsAgentsEnvironmentsDeploymentsListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsAgentsEnvironmentsDeploymentsListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v3/{+parent}/deployments")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "dialogflow.projects.locations.agents.environments.deployments.list", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "dialogflow.projects.locations.agents.environments.deployments.list" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleCloudDialogflowCxV3ListDeploymentsResponse.ServerResponse.Header or
// (if a response was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsAgentsEnvironmentsDeploymentsListCall) Do(opts ...googleapi.CallOption) (*GoogleCloudDialogflowCxV3ListDeploymentsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleCloudDialogflowCxV3ListDeploymentsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "dialogflow.projects.locations.agents.environments.deployments.list", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *ProjectsLocationsAgentsEnvironmentsDeploymentsListCall) Pages(ctx context.Context, f func(*GoogleCloudDialogflowCxV3ListDeploymentsResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken"))
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

type ProjectsLocationsAgentsEnvironmentsExperimentsCreateCall struct {
	s                                   *Service
	parent                              string
	googleclouddialogflowcxv3experiment *GoogleCloudDialogflowCxV3Experiment
	urlParams_                          gensupport.URLParams
	ctx_                                context.Context
	header_                             http.Header
}

// Create:
//
// - parent: .
func (r *ProjectsLocationsAgentsEnvironmentsExperimentsService) Create(parent string, googleclouddialogflowcxv3experiment *GoogleCloudDialogflowCxV3Experiment) *ProjectsLocationsAgentsEnvironmentsExperimentsCreateCall {
	c := &ProjectsLocationsAgentsEnvironmentsExperimentsCreateCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	c.googleclouddialogflowcxv3experiment = googleclouddialogflowcxv3experiment
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsAgentsEnvironmentsExperimentsCreateCall) Fields(s ...googleapi.Field) *ProjectsLocationsAgentsEnvironmentsExperimentsCreateCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsAgentsEnvironmentsExperimentsCreateCall) Context(ctx context.Context) *ProjectsLocationsAgentsEnvironmentsExperimentsCreateCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsAgentsEnvironmentsExperimentsCreateCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsAgentsEnvironmentsExperimentsCreateCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.googleclouddialogflowcxv3experiment)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v3/{+parent}/experiments")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "dialogflow.projects.locations.agents.environments.experiments.create", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "dialogflow.projects.locations.agents.environments.experiments.create" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleCloudDialogflowCxV3Experiment.ServerResponse.Header or (if a response
// was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsAgentsEnvironmentsExperimentsCreateCall) Do(opts ...googleapi.CallOption) (*GoogleCloudDialogflowCxV3Experiment, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleCloudDialogflowCxV3Experiment{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "dialogflow.projects.locations.agents.environments.experiments.create", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsAgentsEnvironmentsExperimentsDeleteCall struct {
	s          *Service
	name       string
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Delete:
//
// - name: .
func (r *ProjectsLocationsAgentsEnvironmentsExperimentsService) Delete(name string) *ProjectsLocationsAgentsEnvironmentsExperimentsDeleteCall {
	c := &ProjectsLocationsAgentsEnvironmentsExperimentsDeleteCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsAgentsEnvironmentsExperimentsDeleteCall) Fields(s ...googleapi.Field) *ProjectsLocationsAgentsEnvironmentsExperimentsDeleteCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsAgentsEnvironmentsExperimentsDeleteCall) Context(ctx context.Context) *ProjectsLocationsAgentsEnvironmentsExperimentsDeleteCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsAgentsEnvironmentsExperimentsDeleteCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsAgentsEnvironmentsExperimentsDeleteCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v3/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("DELETE", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "dialogflow.projects.locations.agents.environments.experiments.delete", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "dialogflow.projects.locations.agents.environments.experiments.delete" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleProtobufEmpty.ServerResponse.Header or (if a response was returned at
// all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified was
// returned.
func (c *ProjectsLocationsAgentsEnvironmentsExperimentsDeleteCall) Do(opts ...googleapi.CallOption) (*GoogleProtobufEmpty, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleProtobufEmpty{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "dialogflow.projects.locations.agents.environments.experiments.delete", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsAgentsEnvironmentsExperimentsGetCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get:
//
// - name: .
func (r *ProjectsLocationsAgentsEnvironmentsExperimentsService) Get(name string) *ProjectsLocationsAgentsEnvironmentsExperimentsGetCall {
	c := &ProjectsLocationsAgentsEnvironmentsExperimentsGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsAgentsEnvironmentsExperimentsGetCall) Fields(s ...googleapi.Field) *ProjectsLocationsAgentsEnvironmentsExperimentsGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsAgentsEnvironmentsExperimentsGetCall) IfNoneMatch(entityTag string) *ProjectsLocationsAgentsEnvironmentsExperimentsGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsAgentsEnvironmentsExperimentsGetCall) Context(ctx context.Context) *ProjectsLocationsAgentsEnvironmentsExperimentsGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsAgentsEnvironmentsExperimentsGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsAgentsEnvironmentsExperimentsGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v3/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "dialogflow.projects.locations.agents.environments.experiments.get", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "dialogflow.projects.locations.agents.environments.experiments.get" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleCloudDialogflowCxV3Experiment.ServerResponse.Header or (if a response
// was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsAgentsEnvironmentsExperimentsGetCall) Do(opts ...googleapi.CallOption) (*GoogleCloudDialogflowCxV3Experiment, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleCloudDialogflowCxV3Experiment{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "dialogflow.projects.locations.agents.environments.experiments.get", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsAgentsEnvironmentsExperimentsListCall struct {
	s            *Service
	parent       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List:
//
// - parent: .
func (r *ProjectsLocationsAgentsEnvironmentsExperimentsService) List(parent string) *ProjectsLocationsAgentsEnvironmentsExperimentsListCall {
	c := &ProjectsLocationsAgentsEnvironmentsExperimentsListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	return c
}

// PageSize sets the optional parameter "pageSize":
func (c *ProjectsLocationsAgentsEnvironmentsExperimentsListCall) PageSize(pageSize int64) *ProjectsLocationsAgentsEnvironmentsExperimentsListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken":
func 