/*
Purge API

No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

API version: 1.0.0
*/

// Code generated by OpenAPI Generator (https://openapi-generator.tech); DO NOT EDIT.

package realtimepurge

import (
	"bytes"
	"context"
	"io"
	"net/http"
	"net/url"
)


// RealTimePurgeApiService RealTimePurgeApi service
type RealTimePurgeApiService service

type ApiPurgeCacheKeyRequest struct {
	ctx context.Context
	ApiService *RealTimePurgeApiService
	accept *string
	contentType *string
	purgeCacheKeyRequest *PurgeCacheKeyRequest
}

func (r ApiPurgeCacheKeyRequest) Accept(accept string) ApiPurgeCacheKeyRequest {
	r.accept = &accept
	return r
}

func (r ApiPurgeCacheKeyRequest) ContentType(contentType string) ApiPurgeCacheKeyRequest {
	r.contentType = &contentType
	return r
}

func (r ApiPurgeCacheKeyRequest) PurgeCacheKeyRequest(purgeCacheKeyRequest PurgeCacheKeyRequest) ApiPurgeCacheKeyRequest {
	r.purgeCacheKeyRequest = &purgeCacheKeyRequest
	return r
}

func (r ApiPurgeCacheKeyRequest) Execute() (*http.Response, error) {
	return r.ApiService.PurgeCacheKeyExecute(r)
}

/*
PurgeCacheKey /purge/cachekey

List of Cache Keys you want to remove from the Azion Edge Servers cache.
urls (array): list of up to 50 Cache Keys to be expired from the cache, per request.
method (choice): purge method, use the “delete” value for removal.
Layer (choice): layer where the purge will be done. Use the value “edge_caching” (default value if not informed) to purge on the Edge Caching layer and the value “l2_caching” to purge on L2 Caching.

 @param ctx context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
 @return ApiPurgeCacheKeyRequest
*/
func (a *RealTimePurgeApiService) PurgeCacheKey(ctx context.Context) ApiPurgeCacheKeyRequest {
	return ApiPurgeCacheKeyRequest{
		ApiService: a,
		ctx: ctx,
	}
}

// Execute executes the request
func (a *RealTimePurgeApiService) PurgeCacheKeyExecute(r ApiPurgeCacheKeyRequest) (*http.Response, error) {
	var (
		localVarHTTPMethod   = http.MethodPost
		localVarPostBody     interface{}
		formFiles            []formFile
	)

	localBasePath, err := a.client.cfg.ServerURLWithContext(r.ctx, "RealTimePurgeApiService.PurgeCacheKey")
	if err != nil {
		return nil, &GenericOpenAPIError{error: err.Error()}
	}

	localVarPath := localBasePath + "/purge/cachekey"

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := url.Values{}
	localVarFormParams := url.Values{}

	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{"application/json"}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{"application/json", "application/json; version=3"}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	if r.accept != nil {
		parameterAddToHeaderOrQuery(localVarHeaderParams, "Accept", r.accept, "")
	}
	if r.contentType != nil {
		parameterAddToHeaderOrQuery(localVarHeaderParams, "Content-Type", r.contentType, "")
	}
	// body params
	localVarPostBody = r.purgeCacheKeyRequest
	if r.ctx != nil {
		// API Key Authentication
		if auth, ok := r.ctx.Value(ContextAPIKeys).(map[string]APIKey); ok {
			if apiKey, ok := auth["tokenAuth"]; ok {
				var key string
				if apiKey.Prefix != "" {
					key = apiKey.Prefix + " " + apiKey.Key
				} else {
					key = apiKey.Key
				}
				localVarHeaderParams["Authorization"] = key
			}
		}
	}
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, formFiles)
	if err != nil {
		return nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(req)
	if err != nil || localVarHTTPResponse == nil {
		return localVarHTTPResponse, err
	}

	localVarBody, err := io.ReadAll(localVarHTTPResponse.Body)
	localVarHTTPResponse.Body.Close()
	localVarHTTPResponse.Body = io.NopCloser(bytes.NewBuffer(localVarBody))
	if err != nil {
		return localVarHTTPResponse, err
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: localVarHTTPResponse.Status,
		}
		return localVarHTTPResponse, newErr
	}

	return localVarHTTPResponse, nil
}

type ApiPurgeUrlRequest struct {
	ctx context.Context
	ApiService *RealTimePurgeApiService
	accept *string
	contentType *string
	purgeUrlRequest *PurgeUrlRequest
}

func (r ApiPurgeUrlRequest) Accept(accept string) ApiPurgeUrlRequest {
	r.accept = &accept
	return r
}

func (r ApiPurgeUrlRequest) ContentType(contentType string) ApiPurgeUrlRequest {
	r.contentType = &contentType
	return r
}

func (r ApiPurgeUrlRequest) PurgeUrlRequest(purgeUrlRequest PurgeUrlRequest) ApiPurgeUrlRequest {
	r.purgeUrlRequest = &purgeUrlRequest
	return r
}

func (r ApiPurgeUrlRequest) Execute() (*http.Response, error) {
	return r.ApiService.PurgeUrlExecute(r)
}

/*
PurgeUrl /purge/url

List of URLs you want to remove from the Azion Edge Servers cache.
urls (array): list of up to 50 URLs to be expired from the cache, per request.
method (choice): purge method, use the “delete” value for removal.

 @param ctx context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
 @return ApiPurgeUrlRequest
*/
func (a *RealTimePurgeApiService) PurgeUrl(ctx context.Context) ApiPurgeUrlRequest {
	return ApiPurgeUrlRequest{
		ApiService: a,
		ctx: ctx,
	}
}

// Execute executes the request
func (a *RealTimePurgeApiService) PurgeUrlExecute(r ApiPurgeUrlRequest) (*http.Response, error) {
	var (
		localVarHTTPMethod   = http.MethodPost
		localVarPostBody     interface{}
		formFiles            []formFile
	)

	localBasePath, err := a.client.cfg.ServerURLWithContext(r.ctx, "RealTimePurgeApiService.PurgeUrl")
	if err != nil {
		return nil, &GenericOpenAPIError{error: err.Error()}
	}

	localVarPath := localBasePath + "/purge/url"

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := url.Values{}
	localVarFormParams := url.Values{}

	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{"application/json; version=3"}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{"application/json; version=3"}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	if r.accept != nil {
		parameterAddToHeaderOrQuery(localVarHeaderParams, "Accept", r.accept, "")
	}
	if r.contentType != nil {
		parameterAddToHeaderOrQuery(localVarHeaderParams, "Content-Type", r.contentType, "")
	}
	// body params
	localVarPostBody = r.purgeUrlRequest
	if r.ctx != nil {
		// API Key Authentication
		if auth, ok := r.ctx.Value(ContextAPIKeys).(map[string]APIKey); ok {
			if apiKey, ok := auth["tokenAuth"]; ok {
				var key string
				if apiKey.Prefix != "" {
					key = apiKey.Prefix + " " + apiKey.Key
				} else {
					key = apiKey.Key
				}
				localVarHeaderParams["Authorization"] = key
			}
		}
	}
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, formFiles)
	if err != nil {
		return nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(req)
	if err != nil || localVarHTTPResponse == nil {
		return localVarHTTPResponse, err
	}

	localVarBody, err := io.ReadAll(localVarHTTPResponse.Body)
	localVarHTTPResponse.Body.Close()
	localVarHTTPResponse.Body = io.NopCloser(bytes.NewBuffer(localVarBody))
	if err != nil {
		return localVarHTTPResponse, err
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: localVarHTTPResponse.Status,
		}
		return localVarHTTPResponse, newErr
	}

	return localVarHTTPResponse, nil
}

type ApiPurgeWildcardRequest struct {
	ctx context.Context
	ApiService *RealTimePurgeApiService
	accept *string
	contentType *string
	purgeWildcardRequest *PurgeWildcardRequest
}

func (r ApiPurgeWildcardRequest) Accept(accept string) ApiPurgeWildcardRequest {
	r.accept = &accept
	return r
}

func (r ApiPurgeWildcardRequest) ContentType(contentType string) ApiPurgeWildcardRequest {
	r.contentType = &contentType
	return r
}

func (r ApiPurgeWildcardRequest) PurgeWildcardRequest(purgeWildcardRequest PurgeWildcardRequest) ApiPurgeWildcardRequest {
	r.purgeWildcardRequest = &purgeWildcardRequest
	return r
}

func (r ApiPurgeWildcardRequest) Execute() (*http.Response, error) {
	return r.ApiService.PurgeWildcardExecute(r)
}

/*
PurgeWildcard /purge/wildcard

The Wildcard expression that represents the list of objects that you want to remove from the Azion Edge Servers cache.
urls (array):the Wildcard URL or Wildcard Cache Key that represents the list of objects you want to expire. You can only use one Wildcard expression per request.
method (choice): purge method, use the “delete” value for removal.

 @param ctx context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
 @return ApiPurgeWildcardRequest
*/
func (a *RealTimePurgeApiService) PurgeWildcard(ctx context.Context) ApiPurgeWildcardRequest {
	return ApiPurgeWildcardRequest{
		ApiService: a,
		ctx: ctx,
	}
}

// Execute executes the request
func (a *RealTimePurgeApiService) PurgeWildcardExecute(r ApiPurgeWildcardRequest) (*http.Response, error) {
	var (
		localVarHTTPMethod   = http.MethodPost
		localVarPostBody     interface{}
		formFiles            []formFile
	)

	localBasePath, err := a.client.cfg.ServerURLWithContext(r.ctx, "RealTimePurgeApiService.PurgeWildcard")
	if err != nil {
		return nil, &GenericOpenAPIError{error: err.Error()}
	}

	localVarPath := localBasePath + "/purge/wildcard"

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := url.Values{}
	localVarFormParams := url.Values{}

	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{"application/json"}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{"application/json", "application/json; version=3"}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	if r.accept != nil {
		parameterAddToHeaderOrQuery(localVarHeaderParams, "Accept", r.accept, "")
	}
	if r.contentType != nil {
		parameterAddToHeaderOrQuery(localVarHeaderParams, "Content-Type", r.contentType, "")
	}
	// body params
	localVarPostBody = r.purgeWildcardRequest
	if r.ctx != nil {
		// API Key Authentication
		if auth, ok := r.ctx.Value(ContextAPIKeys).(map[string]APIKey); ok {
			if apiKey, ok := auth["tokenAuth"]; ok {
				var key string
				if apiKey.Prefix != "" {
					key = apiKey.Prefix + " " + apiKey.Key
				} else {
					key = apiKey.Key
				}
				localVarHeaderParams["Authorization"] = key
			}
		}
	}
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, formFiles)
	if err != nil {
		return nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(req)
	if err != nil || localVarHTTPResponse == nil {
		return localVarHTTPResponse, err
	}

	localVarBody, err := io.ReadAll(localVarHTTPResponse.Body)
	localVarHTTPResponse.Body.Close()
	localVarHTTPResponse.Body = io.NopCloser(bytes.NewBuffer(localVarBody))
	if err != nil {
		return localVarHTTPResponse, err
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: localVarHTTPResponse.Status,
		}
		return localVarHTTPResponse, newErr
	}

	return localVarHTTPResponse, nil
}
