package model

import (
	"github.com/huaweicloud/huaweicloud-sdk-go-v3/core/utils"

	"strings"
)

// ListGlobalMalwareResponse Response Object
type ListGlobalMalwareResponse struct {

	// Global恶意文件总数
	TotalNum *int32 `json:"total_num,omitempty"`

	// 漏洞总数
	DataList       *[]GlobalMalwareInfo `json:"data_list,omitempty"`
	HttpStatusCode int                  `json:"-"`
}

func (o ListGlobalMalwareResponse) String() string {
	data, err := utils.Marshal(o)
	if err != nil {
		return "ListGlobalMalwareResponse struct{}"
	}

	return strings.Join([]string{"ListGlobalMalwareResponse", string(data)}, " ")
}
