package model

import (
	"github.com/huaweicloud/huaweicloud-sdk-go-v3/core/utils"

	"strings"
)

// UpdateRedirectPoolsStickySessionConfig **参数解释**：配置转发策略关联的服务器组之间会话保持。负载均衡器会根据客户端第一个请求生成一个cookie，后续所有包含这个cookie值的请求都会由同一个pool处理。  [**约束限制**：共享型负载均衡器下的转发策略不支持该字段，传入会报错。](tag:hws,hws_hk,ocb,ctc,hcs,g42,tm,cmcc,hk_g42,hws_ocb,srg,fcs,dt)  [不支持该字段，请勿使用。](tag:hcso_dt)  [荷兰region不支持该字段，请勿使用。](tag:dt)
type UpdateRedirectPoolsStickySessionConfig struct {

	// **参数解释**：转发策略服务器组会话保持开启的开关。  **约束限制**：不涉及  **取值范围**：不涉及  **默认取值**：false，表示关闭服务器组会话保持。
	Enable *bool `json:"enable,omitempty"`

	// **参数解释**：会话保持的时间。  **约束限制**：不涉及  **取值范围**：1-1440（分钟）  **默认取值**：1440  [荷兰region不支持QUIC。](tag:dt)
	Timeout *int32 `json:"timeout,omitempty"`
}

func (o UpdateRedirectPoolsStickySessionConfig) String() string {
	data, err := utils.Marshal(o)
	if err != nil {
		return "UpdateRedirectPoolsStickySessionConfig struct{}"
	}

	return strings.Join([]string{"UpdateRedirectPoolsStickySessionConfig", string(data)}, " ")
}
