/*
 * Decompiled with CFR 0.152.
 */
package com.ubnt.service.orchestration.template.device.sw;

import com.ubnt.data.Device;
import com.ubnt.service.orchestration.dto.report.IssueDetailReportDto;
import com.ubnt.service.orchestration.model.SwitchDeviceTemplate;
import com.ubnt.service.orchestration.template.TemplateConfigurationConstructor;
import com.ubnt.service.orchestration.template.TemplateProvisioningHandler;
import com.ubnt.service.orchestration.template.TemplateProvisioningValidationIssue;
import com.ubnt.service.orchestration.template.TemplateType;
import com.ubnt.service.orchestration.template.device.sw.SwitchDeviceConfigsProvisionService;
import com.ubnt.service.orchestration.template.device.sw.validator.SwitchDeviceOrchestrationError;
import com.ubnt.service.system.jA;
import java.beans.ConstructorProperties;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.slf4j.Logger;

public class SwitchDeviceTemplateTypeProvisioningHandler
implements TemplateProvisioningHandler<SwitchDeviceTemplate> {
    private static final Logger LOGGER = jA.ifnew;
    private final TemplateConfigurationConstructor<SwitchDeviceTemplate, List<Device>> templateConfigurationConstructor;
    private final SwitchDeviceConfigsProvisionService switchDeviceConfigsProvisionService;

    @Override
    public Map<TemplateProvisioningValidationIssue, List<IssueDetailReportDto>> handle(String string, SwitchDeviceTemplate switchDeviceTemplate) {
        List<Device> list = this.templateConfigurationConstructor.construct(string, switchDeviceTemplate);
        try {
            return this.switchDeviceConfigsProvisionService.validateAndProvision(list);
        }
        catch (Exception exception) {
            LOGGER.warn("Failed to apply Switch configuration: {}", (Object)exception.getMessage(), (Object)exception);
            return Map.of(TemplateProvisioningValidationIssue.ERROR, List.of(IssueDetailReportDto.builder().code(SwitchDeviceOrchestrationError.PROVISIONING_ERROR).issueDetail("Failed to apply Switch configuration: " + exception.getMessage()).build()));
        }
    }

    @Override
    public TemplateType getType() {
        return TemplateType.SWITCH_DEVICE;
    }

    @Override
    public Class<SwitchDeviceTemplate> handledType() {
        return SwitchDeviceTemplate.class;
    }

    @ConstructorProperties(value={"templateConfigurationConstructor", "switchDeviceConfigsProvisionService"})
    @Generated
    public SwitchDeviceTemplateTypeProvisioningHandler(TemplateConfigurationConstructor<SwitchDeviceTemplate, List<Device>> templateConfigurationConstructor, SwitchDeviceConfigsProvisionService switchDeviceConfigsProvisionService) {
        this.templateConfigurationConstructor = templateConfigurationConstructor;
        this.switchDeviceConfigsProvisionService = switchDeviceConfigsProvisionService;
    }
}

